/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/firestore/v1/firestore.proto

// Protobuf Java Version: 3.25.5
package com.google.firestore.v1;

public interface ListDocumentsRequestOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.firestore.v1.ListDocumentsRequest)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Required. The parent resource name. In the format:
   * `projects/{project_id}/databases/{database_id}/documents` or
   * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
   *
   * For example:
   * `projects/my-project/databases/my-database/documents` or
   * `projects/my-project/databases/my-database/documents/chatrooms/my-chatroom`
   * </pre>
   *
   * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The parent.
   */
  java.lang.String getParent();

  /**
   *
   *
   * <pre>
   * Required. The parent resource name. In the format:
   * `projects/{project_id}/databases/{database_id}/documents` or
   * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
   *
   * For example:
   * `projects/my-project/databases/my-database/documents` or
   * `projects/my-project/databases/my-database/documents/chatrooms/my-chatroom`
   * </pre>
   *
   * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for parent.
   */
  com.google.protobuf.ByteString getParentBytes();

  /**
   *
   *
   * <pre>
   * Optional. The collection ID, relative to `parent`, to list.
   *
   * For example: `chatrooms` or `messages`.
   *
   * This is optional, and when not provided, Firestore will list documents
   * from all collections under the provided `parent`.
   * </pre>
   *
   * <code>string collection_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The collectionId.
   */
  java.lang.String getCollectionId();

  /**
   *
   *
   * <pre>
   * Optional. The collection ID, relative to `parent`, to list.
   *
   * For example: `chatrooms` or `messages`.
   *
   * This is optional, and when not provided, Firestore will list documents
   * from all collections under the provided `parent`.
   * </pre>
   *
   * <code>string collection_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for collectionId.
   */
  com.google.protobuf.ByteString getCollectionIdBytes();

  /**
   *
   *
   * <pre>
   * Optional. The maximum number of documents to return in a single response.
   *
   * Firestore may return fewer than this value.
   * </pre>
   *
   * <code>int32 page_size = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The pageSize.
   */
  int getPageSize();

  /**
   *
   *
   * <pre>
   * Optional. A page token, received from a previous `ListDocuments` response.
   *
   * Provide this to retrieve the subsequent page. When paginating, all other
   * parameters (with the exception of `page_size`) must match the values set
   * in the request that generated the page token.
   * </pre>
   *
   * <code>string page_token = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The pageToken.
   */
  java.lang.String getPageToken();

  /**
   *
   *
   * <pre>
   * Optional. A page token, received from a previous `ListDocuments` response.
   *
   * Provide this to retrieve the subsequent page. When paginating, all other
   * parameters (with the exception of `page_size`) must match the values set
   * in the request that generated the page token.
   * </pre>
   *
   * <code>string page_token = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for pageToken.
   */
  com.google.protobuf.ByteString getPageTokenBytes();

  /**
   *
   *
   * <pre>
   * Optional. The optional ordering of the documents to return.
   *
   * For example: `priority desc, __name__ desc`.
   *
   * This mirrors the [`ORDER BY`][google.firestore.v1.StructuredQuery.order_by]
   * used in Firestore queries but in a string representation. When absent,
   * documents are ordered based on `__name__ ASC`.
   * </pre>
   *
   * <code>string order_by = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The orderBy.
   */
  java.lang.String getOrderBy();

  /**
   *
   *
   * <pre>
   * Optional. The optional ordering of the documents to return.
   *
   * For example: `priority desc, __name__ desc`.
   *
   * This mirrors the [`ORDER BY`][google.firestore.v1.StructuredQuery.order_by]
   * used in Firestore queries but in a string representation. When absent,
   * documents are ordered based on `__name__ ASC`.
   * </pre>
   *
   * <code>string order_by = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for orderBy.
   */
  com.google.protobuf.ByteString getOrderByBytes();

  /**
   *
   *
   * <pre>
   * Optional. The fields to return. If not set, returns all fields.
   *
   * If a document has a field that is not present in this mask, that field
   * will not be returned in the response.
   * </pre>
   *
   * <code>.google.firestore.v1.DocumentMask mask = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the mask field is set.
   */
  boolean hasMask();

  /**
   *
   *
   * <pre>
   * Optional. The fields to return. If not set, returns all fields.
   *
   * If a document has a field that is not present in this mask, that field
   * will not be returned in the response.
   * </pre>
   *
   * <code>.google.firestore.v1.DocumentMask mask = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The mask.
   */
  com.google.firestore.v1.DocumentMask getMask();

  /**
   *
   *
   * <pre>
   * Optional. The fields to return. If not set, returns all fields.
   *
   * If a document has a field that is not present in this mask, that field
   * will not be returned in the response.
   * </pre>
   *
   * <code>.google.firestore.v1.DocumentMask mask = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.firestore.v1.DocumentMaskOrBuilder getMaskOrBuilder();

  /**
   *
   *
   * <pre>
   * Perform the read as part of an already active transaction.
   * </pre>
   *
   * <code>bytes transaction = 8;</code>
   *
   * @return Whether the transaction field is set.
   */
  boolean hasTransaction();

  /**
   *
   *
   * <pre>
   * Perform the read as part of an already active transaction.
   * </pre>
   *
   * <code>bytes transaction = 8;</code>
   *
   * @return The transaction.
   */
  com.google.protobuf.ByteString getTransaction();

  /**
   *
   *
   * <pre>
   * Perform the read at the provided time.
   *
   * This must be a microsecond precision timestamp within the past one hour,
   * or if Point-in-Time Recovery is enabled, can additionally be a whole
   * minute timestamp within the past 7 days.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp read_time = 10;</code>
   *
   * @return Whether the readTime field is set.
   */
  boolean hasReadTime();

  /**
   *
   *
   * <pre>
   * Perform the read at the provided time.
   *
   * This must be a microsecond precision timestamp within the past one hour,
   * or if Point-in-Time Recovery is enabled, can additionally be a whole
   * minute timestamp within the past 7 days.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp read_time = 10;</code>
   *
   * @return The readTime.
   */
  com.google.protobuf.Timestamp getReadTime();

  /**
   *
   *
   * <pre>
   * Perform the read at the provided time.
   *
   * This must be a microsecond precision timestamp within the past one hour,
   * or if Point-in-Time Recovery is enabled, can additionally be a whole
   * minute timestamp within the past 7 days.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp read_time = 10;</code>
   */
  com.google.protobuf.TimestampOrBuilder getReadTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * If the list should show missing documents.
   *
   * A document is missing if it does not exist, but there are sub-documents
   * nested underneath it. When true, such missing documents will be returned
   * with a key but will not have fields,
   * [`create_time`][google.firestore.v1.Document.create_time], or
   * [`update_time`][google.firestore.v1.Document.update_time] set.
   *
   * Requests with `show_missing` may not specify `where` or `order_by`.
   * </pre>
   *
   * <code>bool show_missing = 12;</code>
   *
   * @return The showMissing.
   */
  boolean getShowMissing();

  com.google.firestore.v1.ListDocumentsRequest.ConsistencySelectorCase getConsistencySelectorCase();
}
