/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/firestore/v1/firestore.proto

package com.google.firestore.v1;

/**
 *
 *
 * <pre>
 * Targets being watched have changed.
 * </pre>
 *
 * Protobuf type {@code google.firestore.v1.TargetChange}
 */
public final class TargetChange extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.firestore.v1.TargetChange)
    TargetChangeOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use TargetChange.newBuilder() to construct.
  private TargetChange(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TargetChange() {
    targetChangeType_ = 0;
    targetIds_ = emptyIntList();
    resumeToken_ = com.google.protobuf.ByteString.EMPTY;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TargetChange();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.firestore.v1.FirestoreProto
        .internal_static_google_firestore_v1_TargetChange_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.firestore.v1.FirestoreProto
        .internal_static_google_firestore_v1_TargetChange_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.firestore.v1.TargetChange.class,
            com.google.firestore.v1.TargetChange.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The type of change.
   * </pre>
   *
   * Protobuf enum {@code google.firestore.v1.TargetChange.TargetChangeType}
   */
  public enum TargetChangeType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * No change has occurred. Used only to send an updated `resume_token`.
     * </pre>
     *
     * <code>NO_CHANGE = 0;</code>
     */
    NO_CHANGE(0),
    /**
     *
     *
     * <pre>
     * The targets have been added.
     * </pre>
     *
     * <code>ADD = 1;</code>
     */
    ADD(1),
    /**
     *
     *
     * <pre>
     * The targets have been removed.
     * </pre>
     *
     * <code>REMOVE = 2;</code>
     */
    REMOVE(2),
    /**
     *
     *
     * <pre>
     * The targets reflect all changes committed before the targets were added
     * to the stream.
     * This will be sent after or with a `read_time` that is greater than or
     * equal to the time at which the targets were added.
     * Listeners can wait for this change if read-after-write semantics
     * are desired.
     * </pre>
     *
     * <code>CURRENT = 3;</code>
     */
    CURRENT(3),
    /**
     *
     *
     * <pre>
     * The targets have been reset, and a new initial state for the targets
     * will be returned in subsequent changes.
     * After the initial state is complete, `CURRENT` will be returned even
     * if the target was previously indicated to be `CURRENT`.
     * </pre>
     *
     * <code>RESET = 4;</code>
     */
    RESET(4),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * No change has occurred. Used only to send an updated `resume_token`.
     * </pre>
     *
     * <code>NO_CHANGE = 0;</code>
     */
    public static final int NO_CHANGE_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The targets have been added.
     * </pre>
     *
     * <code>ADD = 1;</code>
     */
    public static final int ADD_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The targets have been removed.
     * </pre>
     *
     * <code>REMOVE = 2;</code>
     */
    public static final int REMOVE_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The targets reflect all changes committed before the targets were added
     * to the stream.
     * This will be sent after or with a `read_time` that is greater than or
     * equal to the time at which the targets were added.
     * Listeners can wait for this change if read-after-write semantics
     * are desired.
     * </pre>
     *
     * <code>CURRENT = 3;</code>
     */
    public static final int CURRENT_VALUE = 3;
    /**
     *
     *
     * <pre>
     * The targets have been reset, and a new initial state for the targets
     * will be returned in subsequent changes.
     * After the initial state is complete, `CURRENT` will be returned even
     * if the target was previously indicated to be `CURRENT`.
     * </pre>
     *
     * <code>RESET = 4;</code>
     */
    public static final int RESET_VALUE = 4;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TargetChangeType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static TargetChangeType forNumber(int value) {
      switch (value) {
        case 0:
          return NO_CHANGE;
        case 1:
          return ADD;
        case 2:
          return REMOVE;
        case 3:
          return CURRENT;
        case 4:
          return RESET;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<TargetChangeType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<TargetChangeType>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<TargetChangeType>() {
              public TargetChangeType findValueByNumber(int number) {
                return TargetChangeType.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.firestore.v1.TargetChange.getDescriptor().getEnumTypes().get(0);
    }

    private static final TargetChangeType[] VALUES = values();

    public static TargetChangeType valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private TargetChangeType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.firestore.v1.TargetChange.TargetChangeType)
  }

  public static final int TARGET_CHANGE_TYPE_FIELD_NUMBER = 1;
  private int targetChangeType_;
  /**
   *
   *
   * <pre>
   * The type of change that occurred.
   * </pre>
   *
   * <code>.google.firestore.v1.TargetChange.TargetChangeType target_change_type = 1;</code>
   *
   * @return The enum numeric value on the wire for targetChangeType.
   */
  @java.lang.Override
  public int getTargetChangeTypeValue() {
    return targetChangeType_;
  }
  /**
   *
   *
   * <pre>
   * The type of change that occurred.
   * </pre>
   *
   * <code>.google.firestore.v1.TargetChange.TargetChangeType target_change_type = 1;</code>
   *
   * @return The targetChangeType.
   */
  @java.lang.Override
  public com.google.firestore.v1.TargetChange.TargetChangeType getTargetChangeType() {
    @SuppressWarnings("deprecation")
    com.google.firestore.v1.TargetChange.TargetChangeType result =
        com.google.firestore.v1.TargetChange.TargetChangeType.valueOf(targetChangeType_);
    return result == null
        ? com.google.firestore.v1.TargetChange.TargetChangeType.UNRECOGNIZED
        : result;
  }

  public static final int TARGET_IDS_FIELD_NUMBER = 2;
  private com.google.protobuf.Internal.IntList targetIds_;
  /**
   *
   *
   * <pre>
   * The target IDs of targets that have changed.
   * If empty, the change applies to all targets.
   * The order of the target IDs is not defined.
   * </pre>
   *
   * <code>repeated int32 target_ids = 2;</code>
   *
   * @return A list containing the targetIds.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getTargetIdsList() {
    return targetIds_;
  }
  /**
   *
   *
   * <pre>
   * The target IDs of targets that have changed.
   * If empty, the change applies to all targets.
   * The order of the target IDs is not defined.
   * </pre>
   *
   * <code>repeated int32 target_ids = 2;</code>
   *
   * @return The count of targetIds.
   */
  public int getTargetIdsCount() {
    return targetIds_.size();
  }
  /**
   *
   *
   * <pre>
   * The target IDs of targets that have changed.
   * If empty, the change applies to all targets.
   * The order of the target IDs is not defined.
   * </pre>
   *
   * <code>repeated int32 target_ids = 2;</code>
   *
   * @param index The index of the element to return.
   * @return The targetIds at the given index.
   */
  public int getTargetIds(int index) {
    return targetIds_.getInt(index);
  }

  private int targetIdsMemoizedSerializedSize = -1;

  public static final int CAUSE_FIELD_NUMBER = 3;
  private com.google.rpc.Status cause_;
  /**
   *
   *
   * <pre>
   * The error that resulted in this change, if applicable.
   * </pre>
   *
   * <code>.google.rpc.Status cause = 3;</code>
   *
   * @return Whether the cause field is set.
   */
  @java.lang.Override
  public boolean hasCause() {
    return cause_ != null;
  }
  /**
   *
   *
   * <pre>
   * The error that resulted in this change, if applicable.
   * </pre>
   *
   * <code>.google.rpc.Status cause = 3;</code>
   *
   * @return The cause.
   */
  @java.lang.Override
  public com.google.rpc.Status getCause() {
    return cause_ == null ? com.google.rpc.Status.getDefaultInstance() : cause_;
  }
  /**
   *
   *
   * <pre>
   * The error that resulted in this change, if applicable.
   * </pre>
   *
   * <code>.google.rpc.Status cause = 3;</code>
   */
  @java.lang.Override
  public com.google.rpc.StatusOrBuilder getCauseOrBuilder() {
    return getCause();
  }

  public static final int RESUME_TOKEN_FIELD_NUMBER = 4;
  private com.google.protobuf.ByteString resumeToken_;
  /**
   *
   *
   * <pre>
   * A token that can be used to resume the stream for the given `target_ids`,
   * or all targets if `target_ids` is empty.
   * Not set on every target change.
   * </pre>
   *
   * <code>bytes resume_token = 4;</code>
   *
   * @return The resumeToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getResumeToken() {
    return resumeToken_;
  }

  public static final int READ_TIME_FIELD_NUMBER = 6;
  private com.google.protobuf.Timestamp readTime_;
  /**
   *
   *
   * <pre>
   * The consistent `read_time` for the given `target_ids` (omitted when the
   * target_ids are not at a consistent snapshot).
   * The stream is guaranteed to send a `read_time` with `target_ids` empty
   * whenever the entire stream reaches a new consistent snapshot. ADD,
   * CURRENT, and RESET messages are guaranteed to (eventually) result in a
   * new consistent snapshot (while NO_CHANGE and REMOVE messages are not).
   * For a given stream, `read_time` is guaranteed to be monotonically
   * increasing.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp read_time = 6;</code>
   *
   * @return Whether the readTime field is set.
   */
  @java.lang.Override
  public boolean hasReadTime() {
    return readTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * The consistent `read_time` for the given `target_ids` (omitted when the
   * target_ids are not at a consistent snapshot).
   * The stream is guaranteed to send a `read_time` with `target_ids` empty
   * whenever the entire stream reaches a new consistent snapshot. ADD,
   * CURRENT, and RESET messages are guaranteed to (eventually) result in a
   * new consistent snapshot (while NO_CHANGE and REMOVE messages are not).
   * For a given stream, `read_time` is guaranteed to be monotonically
   * increasing.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp read_time = 6;</code>
   *
   * @return The readTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getReadTime() {
    return readTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : readTime_;
  }
  /**
   *
   *
   * <pre>
   * The consistent `read_time` for the given `target_ids` (omitted when the
   * target_ids are not at a consistent snapshot).
   * The stream is guaranteed to send a `read_time` with `target_ids` empty
   * whenever the entire stream reaches a new consistent snapshot. ADD,
   * CURRENT, and RESET messages are guaranteed to (eventually) result in a
   * new consistent snapshot (while NO_CHANGE and REMOVE messages are not).
   * For a given stream, `read_time` is guaranteed to be monotonically
   * increasing.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp read_time = 6;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getReadTimeOrBuilder() {
    return getReadTime();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (targetChangeType_
        != com.google.firestore.v1.TargetChange.TargetChangeType.NO_CHANGE.getNumber()) {
      output.writeEnum(1, targetChangeType_);
    }
    if (getTargetIdsList().size() > 0) {
      output.writeUInt32NoTag(18);
      output.writeUInt32NoTag(targetIdsMemoizedSerializedSize);
    }
    for (int i = 0; i < targetIds_.size(); i++) {
      output.writeInt32NoTag(targetIds_.getInt(i));
    }
    if (cause_ != null) {
      output.writeMessage(3, getCause());
    }
    if (!resumeToken_.isEmpty()) {
      output.writeBytes(4, resumeToken_);
    }
    if (readTime_ != null) {
      output.writeMessage(6, getReadTime());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (targetChangeType_
        != com.google.firestore.v1.TargetChange.TargetChangeType.NO_CHANGE.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, targetChangeType_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < targetIds_.size(); i++) {
        dataSize +=
            com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(targetIds_.getInt(i));
      }
      size += dataSize;
      if (!getTargetIdsList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(dataSize);
      }
      targetIdsMemoizedSerializedSize = dataSize;
    }
    if (cause_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getCause());
    }
    if (!resumeToken_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream.computeBytesSize(4, resumeToken_);
    }
    if (readTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getReadTime());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.firestore.v1.TargetChange)) {
      return super.equals(obj);
    }
    com.google.firestore.v1.TargetChange other = (com.google.firestore.v1.TargetChange) obj;

    if (targetChangeType_ != other.targetChangeType_) return false;
    if (!getTargetIdsList().equals(other.getTargetIdsList())) return false;
    if (hasCause() != other.hasCause()) return false;
    if (hasCause()) {
      if (!getCause().equals(other.getCause())) return false;
    }
    if (!getResumeToken().equals(other.getResumeToken())) return false;
    if (hasReadTime() != other.hasReadTime()) return false;
    if (hasReadTime()) {
      if (!getReadTime().equals(other.getReadTime())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TARGET_CHANGE_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + targetChangeType_;
    if (getTargetIdsCount() > 0) {
      hash = (37 * hash) + TARGET_IDS_FIELD_NUMBER;
      hash = (53 * hash) + getTargetIdsList().hashCode();
    }
    if (hasCause()) {
      hash = (37 * hash) + CAUSE_FIELD_NUMBER;
      hash = (53 * hash) + getCause().hashCode();
    }
    hash = (37 * hash) + RESUME_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getResumeToken().hashCode();
    if (hasReadTime()) {
      hash = (37 * hash) + READ_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getReadTime().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.firestore.v1.TargetChange parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1.TargetChange parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1.TargetChange parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1.TargetChange parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1.TargetChange parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1.TargetChange parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1.TargetChange parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1.TargetChange parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.v1.TargetChange parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1.TargetChange parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.v1.TargetChange parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1.TargetChange parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.firestore.v1.TargetChange prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Targets being watched have changed.
   * </pre>
   *
   * Protobuf type {@code google.firestore.v1.TargetChange}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.firestore.v1.TargetChange)
      com.google.firestore.v1.TargetChangeOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.firestore.v1.FirestoreProto
          .internal_static_google_firestore_v1_TargetChange_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.firestore.v1.FirestoreProto
          .internal_static_google_firestore_v1_TargetChange_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.firestore.v1.TargetChange.class,
              com.google.firestore.v1.TargetChange.Builder.class);
    }

    // Construct using com.google.firestore.v1.TargetChange.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      targetChangeType_ = 0;

      targetIds_ = emptyIntList();
      bitField0_ = (bitField0_ & ~0x00000001);
      if (causeBuilder_ == null) {
        cause_ = null;
      } else {
        cause_ = null;
        causeBuilder_ = null;
      }
      resumeToken_ = com.google.protobuf.ByteString.EMPTY;

      if (readTimeBuilder_ == null) {
        readTime_ = null;
      } else {
        readTime_ = null;
        readTimeBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.firestore.v1.FirestoreProto
          .internal_static_google_firestore_v1_TargetChange_descriptor;
    }

    @java.lang.Override
    public com.google.firestore.v1.TargetChange getDefaultInstanceForType() {
      return com.google.firestore.v1.TargetChange.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.firestore.v1.TargetChange build() {
      com.google.firestore.v1.TargetChange result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.firestore.v1.TargetChange buildPartial() {
      com.google.firestore.v1.TargetChange result = new com.google.firestore.v1.TargetChange(this);
      int from_bitField0_ = bitField0_;
      result.targetChangeType_ = targetChangeType_;
      if (((bitField0_ & 0x00000001) != 0)) {
        targetIds_.makeImmutable();
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.targetIds_ = targetIds_;
      if (causeBuilder_ == null) {
        result.cause_ = cause_;
      } else {
        result.cause_ = causeBuilder_.build();
      }
      result.resumeToken_ = resumeToken_;
      if (readTimeBuilder_ == null) {
        result.readTime_ = readTime_;
      } else {
        result.readTime_ = readTimeBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.firestore.v1.TargetChange) {
        return mergeFrom((com.google.firestore.v1.TargetChange) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.firestore.v1.TargetChange other) {
      if (other == com.google.firestore.v1.TargetChange.getDefaultInstance()) return this;
      if (other.targetChangeType_ != 0) {
        setTargetChangeTypeValue(other.getTargetChangeTypeValue());
      }
      if (!other.targetIds_.isEmpty()) {
        if (targetIds_.isEmpty()) {
          targetIds_ = other.targetIds_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensureTargetIdsIsMutable();
          targetIds_.addAll(other.targetIds_);
        }
        onChanged();
      }
      if (other.hasCause()) {
        mergeCause(other.getCause());
      }
      if (other.getResumeToken() != com.google.protobuf.ByteString.EMPTY) {
        setResumeToken(other.getResumeToken());
      }
      if (other.hasReadTime()) {
        mergeReadTime(other.getReadTime());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                targetChangeType_ = input.readEnum();

                break;
              } // case 8
            case 16:
              {
                int v = input.readInt32();
                ensureTargetIdsIsMutable();
                targetIds_.addInt(v);
                break;
              } // case 16
            case 18:
              {
                int length = input.readRawVarint32();
                int limit = input.pushLimit(length);
                ensureTargetIdsIsMutable();
                while (input.getBytesUntilLimit() > 0) {
                  targetIds_.addInt(input.readInt32());
                }
                input.popLimit(limit);
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getCauseFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 26
            case 34:
              {
                resumeToken_ = input.readBytes();

                break;
              } // case 34
            case 50:
              {
                input.readMessage(getReadTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int targetChangeType_ = 0;
    /**
     *
     *
     * <pre>
     * The type of change that occurred.
     * </pre>
     *
     * <code>.google.firestore.v1.TargetChange.TargetChangeType target_change_type = 1;</code>
     *
     * @return The enum numeric value on the wire for targetChangeType.
     */
    @java.lang.Override
    public int getTargetChangeTypeValue() {
      return targetChangeType_;
    }
    /**
     *
     *
     * <pre>
     * The type of change that occurred.
     * </pre>
     *
     * <code>.google.firestore.v1.TargetChange.TargetChangeType target_change_type = 1;</code>
     *
     * @param value The enum numeric value on the wire for targetChangeType to set.
     * @return This builder for chaining.
     */
    public Builder setTargetChangeTypeValue(int value) {

      targetChangeType_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of change that occurred.
     * </pre>
     *
     * <code>.google.firestore.v1.TargetChange.TargetChangeType target_change_type = 1;</code>
     *
     * @return The targetChangeType.
     */
    @java.lang.Override
    public com.google.firestore.v1.TargetChange.TargetChangeType getTargetChangeType() {
      @SuppressWarnings("deprecation")
      com.google.firestore.v1.TargetChange.TargetChangeType result =
          com.google.firestore.v1.TargetChange.TargetChangeType.valueOf(targetChangeType_);
      return result == null
          ? com.google.firestore.v1.TargetChange.TargetChangeType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The type of change that occurred.
     * </pre>
     *
     * <code>.google.firestore.v1.TargetChange.TargetChangeType target_change_type = 1;</code>
     *
     * @param value The targetChangeType to set.
     * @return This builder for chaining.
     */
    public Builder setTargetChangeType(
        com.google.firestore.v1.TargetChange.TargetChangeType value) {
      if (value == null) {
        throw new NullPointerException();
      }

      targetChangeType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of change that occurred.
     * </pre>
     *
     * <code>.google.firestore.v1.TargetChange.TargetChangeType target_change_type = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTargetChangeType() {

      targetChangeType_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Internal.IntList targetIds_ = emptyIntList();

    private void ensureTargetIdsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        targetIds_ = mutableCopy(targetIds_);
        bitField0_ |= 0x00000001;
      }
    }
    /**
     *
     *
     * <pre>
     * The target IDs of targets that have changed.
     * If empty, the change applies to all targets.
     * The order of the target IDs is not defined.
     * </pre>
     *
     * <code>repeated int32 target_ids = 2;</code>
     *
     * @return A list containing the targetIds.
     */
    public java.util.List<java.lang.Integer> getTargetIdsList() {
      return ((bitField0_ & 0x00000001) != 0)
          ? java.util.Collections.unmodifiableList(targetIds_)
          : targetIds_;
    }
    /**
     *
     *
     * <pre>
     * The target IDs of targets that have changed.
     * If empty, the change applies to all targets.
     * The order of the target IDs is not defined.
     * </pre>
     *
     * <code>repeated int32 target_ids = 2;</code>
     *
     * @return The count of targetIds.
     */
    public int getTargetIdsCount() {
      return targetIds_.size();
    }
    /**
     *
     *
     * <pre>
     * The target IDs of targets that have changed.
     * If empty, the change applies to all targets.
     * The order of the target IDs is not defined.
     * </pre>
     *
     * <code>repeated int32 target_ids = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The targetIds at the given index.
     */
    public int getTargetIds(int index) {
      return targetIds_.getInt(index);
    }
    /**
     *
     *
     * <pre>
     * The target IDs of targets that have changed.
     * If empty, the change applies to all targets.
     * The order of the target IDs is not defined.
     * </pre>
     *
     * <code>repeated int32 target_ids = 2;</code>
     *
     * @param index The index to set the value at.
     * @param value The targetIds to set.
     * @return This builder for chaining.
     */
    public Builder setTargetIds(int index, int value) {
      ensureTargetIdsIsMutable();
      targetIds_.setInt(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The target IDs of targets that have changed.
     * If empty, the change applies to all targets.
     * The order of the target IDs is not defined.
     * </pre>
     *
     * <code>repeated int32 target_ids = 2;</code>
     *
     * @param value The targetIds to add.
     * @return This builder for chaining.
     */
    public Builder addTargetIds(int value) {
      ensureTargetIdsIsMutable();
      targetIds_.addInt(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The target IDs of targets that have changed.
     * If empty, the change applies to all targets.
     * The order of the target IDs is not defined.
     * </pre>
     *
     * <code>repeated int32 target_ids = 2;</code>
     *
     * @param values The targetIds to add.
     * @return This builder for chaining.
     */
    public Builder addAllTargetIds(java.lang.Iterable<? extends java.lang.Integer> values) {
      ensureTargetIdsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, targetIds_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The target IDs of targets that have changed.
     * If empty, the change applies to all targets.
     * The order of the target IDs is not defined.
     * </pre>
     *
     * <code>repeated int32 target_ids = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTargetIds() {
      targetIds_ = emptyIntList();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    private com.google.rpc.Status cause_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        causeBuilder_;
    /**
     *
     *
     * <pre>
     * The error that resulted in this change, if applicable.
     * </pre>
     *
     * <code>.google.rpc.Status cause = 3;</code>
     *
     * @return Whether the cause field is set.
     */
    public boolean hasCause() {
      return causeBuilder_ != null || cause_ != null;
    }
    /**
     *
     *
     * <pre>
     * The error that resulted in this change, if applicable.
     * </pre>
     *
     * <code>.google.rpc.Status cause = 3;</code>
     *
     * @return The cause.
     */
    public com.google.rpc.Status getCause() {
      if (causeBuilder_ == null) {
        return cause_ == null ? com.google.rpc.Status.getDefaultInstance() : cause_;
      } else {
        return causeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The error that resulted in this change, if applicable.
     * </pre>
     *
     * <code>.google.rpc.Status cause = 3;</code>
     */
    public Builder setCause(com.google.rpc.Status value) {
      if (causeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        cause_ = value;
        onChanged();
      } else {
        causeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The error that resulted in this change, if applicable.
     * </pre>
     *
     * <code>.google.rpc.Status cause = 3;</code>
     */
    public Builder setCause(com.google.rpc.Status.Builder builderForValue) {
      if (causeBuilder_ == null) {
        cause_ = builderForValue.build();
        onChanged();
      } else {
        causeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The error that resulted in this change, if applicable.
     * </pre>
     *
     * <code>.google.rpc.Status cause = 3;</code>
     */
    public Builder mergeCause(com.google.rpc.Status value) {
      if (causeBuilder_ == null) {
        if (cause_ != null) {
          cause_ = com.google.rpc.Status.newBuilder(cause_).mergeFrom(value).buildPartial();
        } else {
          cause_ = value;
        }
        onChanged();
      } else {
        causeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The error that resulted in this change, if applicable.
     * </pre>
     *
     * <code>.google.rpc.Status cause = 3;</code>
     */
    public Builder clearCause() {
      if (causeBuilder_ == null) {
        cause_ = null;
        onChanged();
      } else {
        cause_ = null;
        causeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The error that resulted in this change, if applicable.
     * </pre>
     *
     * <code>.google.rpc.Status cause = 3;</code>
     */
    public com.google.rpc.Status.Builder getCauseBuilder() {

      onChanged();
      return getCauseFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The error that resulted in this change, if applicable.
     * </pre>
     *
     * <code>.google.rpc.Status cause = 3;</code>
     */
    public com.google.rpc.StatusOrBuilder getCauseOrBuilder() {
      if (causeBuilder_ != null) {
        return causeBuilder_.getMessageOrBuilder();
      } else {
        return cause_ == null ? com.google.rpc.Status.getDefaultInstance() : cause_;
      }
    }
    /**
     *
     *
     * <pre>
     * The error that resulted in this change, if applicable.
     * </pre>
     *
     * <code>.google.rpc.Status cause = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        getCauseFieldBuilder() {
      if (causeBuilder_ == null) {
        causeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.rpc.Status,
                com.google.rpc.Status.Builder,
                com.google.rpc.StatusOrBuilder>(getCause(), getParentForChildren(), isClean());
        cause_ = null;
      }
      return causeBuilder_;
    }

    private com.google.protobuf.ByteString resumeToken_ = com.google.protobuf.ByteString.EMPTY;
    /**
     *
     *
     * <pre>
     * A token that can be used to resume the stream for the given `target_ids`,
     * or all targets if `target_ids` is empty.
     * Not set on every target change.
     * </pre>
     *
     * <code>bytes resume_token = 4;</code>
     *
     * @return The resumeToken.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getResumeToken() {
      return resumeToken_;
    }
    /**
     *
     *
     * <pre>
     * A token that can be used to resume the stream for the given `target_ids`,
     * or all targets if `target_ids` is empty.
     * Not set on every target change.
     * </pre>
     *
     * <code>bytes resume_token = 4;</code>
     *
     * @param value The resumeToken to set.
     * @return This builder for chaining.
     */
    public Builder setResumeToken(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }

      resumeToken_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A token that can be used to resume the stream for the given `target_ids`,
     * or all targets if `target_ids` is empty.
     * Not set on every target change.
     * </pre>
     *
     * <code>bytes resume_token = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearResumeToken() {

      resumeToken_ = getDefaultInstance().getResumeToken();
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp readTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        readTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The consistent `read_time` for the given `target_ids` (omitted when the
     * target_ids are not at a consistent snapshot).
     * The stream is guaranteed to send a `read_time` with `target_ids` empty
     * whenever the entire stream reaches a new consistent snapshot. ADD,
     * CURRENT, and RESET messages are guaranteed to (eventually) result in a
     * new consistent snapshot (while NO_CHANGE and REMOVE messages are not).
     * For a given stream, `read_time` is guaranteed to be monotonically
     * increasing.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 6;</code>
     *
     * @return Whether the readTime field is set.
     */
    public boolean hasReadTime() {
      return readTimeBuilder_ != null || readTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * The consistent `read_time` for the given `target_ids` (omitted when the
     * target_ids are not at a consistent snapshot).
     * The stream is guaranteed to send a `read_time` with `target_ids` empty
     * whenever the entire stream reaches a new consistent snapshot. ADD,
     * CURRENT, and RESET messages are guaranteed to (eventually) result in a
     * new consistent snapshot (while NO_CHANGE and REMOVE messages are not).
     * For a given stream, `read_time` is guaranteed to be monotonically
     * increasing.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 6;</code>
     *
     * @return The readTime.
     */
    public com.google.protobuf.Timestamp getReadTime() {
      if (readTimeBuilder_ == null) {
        return readTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : readTime_;
      } else {
        return readTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The consistent `read_time` for the given `target_ids` (omitted when the
     * target_ids are not at a consistent snapshot).
     * The stream is guaranteed to send a `read_time` with `target_ids` empty
     * whenever the entire stream reaches a new consistent snapshot. ADD,
     * CURRENT, and RESET messages are guaranteed to (eventually) result in a
     * new consistent snapshot (while NO_CHANGE and REMOVE messages are not).
     * For a given stream, `read_time` is guaranteed to be monotonically
     * increasing.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 6;</code>
     */
    public Builder setReadTime(com.google.protobuf.Timestamp value) {
      if (readTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        readTime_ = value;
        onChanged();
      } else {
        readTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The consistent `read_time` for the given `target_ids` (omitted when the
     * target_ids are not at a consistent snapshot).
     * The stream is guaranteed to send a `read_time` with `target_ids` empty
     * whenever the entire stream reaches a new consistent snapshot. ADD,
     * CURRENT, and RESET messages are guaranteed to (eventually) result in a
     * new consistent snapshot (while NO_CHANGE and REMOVE messages are not).
     * For a given stream, `read_time` is guaranteed to be monotonically
     * increasing.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 6;</code>
     */
    public Builder setReadTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (readTimeBuilder_ == null) {
        readTime_ = builderForValue.build();
        onChanged();
      } else {
        readTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The consistent `read_time` for the given `target_ids` (omitted when the
     * target_ids are not at a consistent snapshot).
     * The stream is guaranteed to send a `read_time` with `target_ids` empty
     * whenever the entire stream reaches a new consistent snapshot. ADD,
     * CURRENT, and RESET messages are guaranteed to (eventually) result in a
     * new consistent snapshot (while NO_CHANGE and REMOVE messages are not).
     * For a given stream, `read_time` is guaranteed to be monotonically
     * increasing.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 6;</code>
     */
    public Builder mergeReadTime(com.google.protobuf.Timestamp value) {
      if (readTimeBuilder_ == null) {
        if (readTime_ != null) {
          readTime_ =
              com.google.protobuf.Timestamp.newBuilder(readTime_).mergeFrom(value).buildPartial();
        } else {
          readTime_ = value;
        }
        onChanged();
      } else {
        readTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The consistent `read_time` for the given `target_ids` (omitted when the
     * target_ids are not at a consistent snapshot).
     * The stream is guaranteed to send a `read_time` with `target_ids` empty
     * whenever the entire stream reaches a new consistent snapshot. ADD,
     * CURRENT, and RESET messages are guaranteed to (eventually) result in a
     * new consistent snapshot (while NO_CHANGE and REMOVE messages are not).
     * For a given stream, `read_time` is guaranteed to be monotonically
     * increasing.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 6;</code>
     */
    public Builder clearReadTime() {
      if (readTimeBuilder_ == null) {
        readTime_ = null;
        onChanged();
      } else {
        readTime_ = null;
        readTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The consistent `read_time` for the given `target_ids` (omitted when the
     * target_ids are not at a consistent snapshot).
     * The stream is guaranteed to send a `read_time` with `target_ids` empty
     * whenever the entire stream reaches a new consistent snapshot. ADD,
     * CURRENT, and RESET messages are guaranteed to (eventually) result in a
     * new consistent snapshot (while NO_CHANGE and REMOVE messages are not).
     * For a given stream, `read_time` is guaranteed to be monotonically
     * increasing.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 6;</code>
     */
    public com.google.protobuf.Timestamp.Builder getReadTimeBuilder() {

      onChanged();
      return getReadTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The consistent `read_time` for the given `target_ids` (omitted when the
     * target_ids are not at a consistent snapshot).
     * The stream is guaranteed to send a `read_time` with `target_ids` empty
     * whenever the entire stream reaches a new consistent snapshot. ADD,
     * CURRENT, and RESET messages are guaranteed to (eventually) result in a
     * new consistent snapshot (while NO_CHANGE and REMOVE messages are not).
     * For a given stream, `read_time` is guaranteed to be monotonically
     * increasing.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 6;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getReadTimeOrBuilder() {
      if (readTimeBuilder_ != null) {
        return readTimeBuilder_.getMessageOrBuilder();
      } else {
        return readTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : readTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The consistent `read_time` for the given `target_ids` (omitted when the
     * target_ids are not at a consistent snapshot).
     * The stream is guaranteed to send a `read_time` with `target_ids` empty
     * whenever the entire stream reaches a new consistent snapshot. ADD,
     * CURRENT, and RESET messages are guaranteed to (eventually) result in a
     * new consistent snapshot (while NO_CHANGE and REMOVE messages are not).
     * For a given stream, `read_time` is guaranteed to be monotonically
     * increasing.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getReadTimeFieldBuilder() {
      if (readTimeBuilder_ == null) {
        readTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getReadTime(), getParentForChildren(), isClean());
        readTime_ = null;
      }
      return readTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.firestore.v1.TargetChange)
  }

  // @@protoc_insertion_point(class_scope:google.firestore.v1.TargetChange)
  private static final com.google.firestore.v1.TargetChange DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.firestore.v1.TargetChange();
  }

  public static com.google.firestore.v1.TargetChange getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TargetChange> PARSER =
      new com.google.protobuf.AbstractParser<TargetChange>() {
        @java.lang.Override
        public TargetChange parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<TargetChange> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TargetChange> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.firestore.v1.TargetChange getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
