/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/firestore/v1/document.proto

package com.google.firestore.v1;

/**
 *
 *
 * <pre>
 * A message that can hold any of the supported value types.
 * </pre>
 *
 * Protobuf type {@code google.firestore.v1.Value}
 */
public final class Value extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.firestore.v1.Value)
    ValueOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Value.newBuilder() to construct.
  private Value(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Value() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Value();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.firestore.v1.DocumentProto
        .internal_static_google_firestore_v1_Value_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.firestore.v1.DocumentProto
        .internal_static_google_firestore_v1_Value_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.firestore.v1.Value.class, com.google.firestore.v1.Value.Builder.class);
  }

  private int valueTypeCase_ = 0;
  private java.lang.Object valueType_;

  public enum ValueTypeCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    NULL_VALUE(11),
    BOOLEAN_VALUE(1),
    INTEGER_VALUE(2),
    DOUBLE_VALUE(3),
    TIMESTAMP_VALUE(10),
    STRING_VALUE(17),
    BYTES_VALUE(18),
    REFERENCE_VALUE(5),
    GEO_POINT_VALUE(8),
    ARRAY_VALUE(9),
    MAP_VALUE(6),
    VALUETYPE_NOT_SET(0);
    private final int value;

    private ValueTypeCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ValueTypeCase valueOf(int value) {
      return forNumber(value);
    }

    public static ValueTypeCase forNumber(int value) {
      switch (value) {
        case 11:
          return NULL_VALUE;
        case 1:
          return BOOLEAN_VALUE;
        case 2:
          return INTEGER_VALUE;
        case 3:
          return DOUBLE_VALUE;
        case 10:
          return TIMESTAMP_VALUE;
        case 17:
          return STRING_VALUE;
        case 18:
          return BYTES_VALUE;
        case 5:
          return REFERENCE_VALUE;
        case 8:
          return GEO_POINT_VALUE;
        case 9:
          return ARRAY_VALUE;
        case 6:
          return MAP_VALUE;
        case 0:
          return VALUETYPE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ValueTypeCase getValueTypeCase() {
    return ValueTypeCase.forNumber(valueTypeCase_);
  }

  public static final int NULL_VALUE_FIELD_NUMBER = 11;
  /**
   *
   *
   * <pre>
   * A null value.
   * </pre>
   *
   * <code>.google.protobuf.NullValue null_value = 11;</code>
   *
   * @return Whether the nullValue field is set.
   */
  public boolean hasNullValue() {
    return valueTypeCase_ == 11;
  }
  /**
   *
   *
   * <pre>
   * A null value.
   * </pre>
   *
   * <code>.google.protobuf.NullValue null_value = 11;</code>
   *
   * @return The enum numeric value on the wire for nullValue.
   */
  public int getNullValueValue() {
    if (valueTypeCase_ == 11) {
      return (java.lang.Integer) valueType_;
    }
    return 0;
  }
  /**
   *
   *
   * <pre>
   * A null value.
   * </pre>
   *
   * <code>.google.protobuf.NullValue null_value = 11;</code>
   *
   * @return The nullValue.
   */
  public com.google.protobuf.NullValue getNullValue() {
    if (valueTypeCase_ == 11) {
      @SuppressWarnings("deprecation")
      com.google.protobuf.NullValue result =
          com.google.protobuf.NullValue.valueOf((java.lang.Integer) valueType_);
      return result == null ? com.google.protobuf.NullValue.UNRECOGNIZED : result;
    }
    return com.google.protobuf.NullValue.NULL_VALUE;
  }

  public static final int BOOLEAN_VALUE_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * A boolean value.
   * </pre>
   *
   * <code>bool boolean_value = 1;</code>
   *
   * @return Whether the booleanValue field is set.
   */
  @java.lang.Override
  public boolean hasBooleanValue() {
    return valueTypeCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * A boolean value.
   * </pre>
   *
   * <code>bool boolean_value = 1;</code>
   *
   * @return The booleanValue.
   */
  @java.lang.Override
  public boolean getBooleanValue() {
    if (valueTypeCase_ == 1) {
      return (java.lang.Boolean) valueType_;
    }
    return false;
  }

  public static final int INTEGER_VALUE_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * An integer value.
   * </pre>
   *
   * <code>int64 integer_value = 2;</code>
   *
   * @return Whether the integerValue field is set.
   */
  @java.lang.Override
  public boolean hasIntegerValue() {
    return valueTypeCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * An integer value.
   * </pre>
   *
   * <code>int64 integer_value = 2;</code>
   *
   * @return The integerValue.
   */
  @java.lang.Override
  public long getIntegerValue() {
    if (valueTypeCase_ == 2) {
      return (java.lang.Long) valueType_;
    }
    return 0L;
  }

  public static final int DOUBLE_VALUE_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * A double value.
   * </pre>
   *
   * <code>double double_value = 3;</code>
   *
   * @return Whether the doubleValue field is set.
   */
  @java.lang.Override
  public boolean hasDoubleValue() {
    return valueTypeCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * A double value.
   * </pre>
   *
   * <code>double double_value = 3;</code>
   *
   * @return The doubleValue.
   */
  @java.lang.Override
  public double getDoubleValue() {
    if (valueTypeCase_ == 3) {
      return (java.lang.Double) valueType_;
    }
    return 0D;
  }

  public static final int TIMESTAMP_VALUE_FIELD_NUMBER = 10;
  /**
   *
   *
   * <pre>
   * A timestamp value.
   * Precise only to microseconds. When stored, any additional precision is
   * rounded down.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp timestamp_value = 10;</code>
   *
   * @return Whether the timestampValue field is set.
   */
  @java.lang.Override
  public boolean hasTimestampValue() {
    return valueTypeCase_ == 10;
  }
  /**
   *
   *
   * <pre>
   * A timestamp value.
   * Precise only to microseconds. When stored, any additional precision is
   * rounded down.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp timestamp_value = 10;</code>
   *
   * @return The timestampValue.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getTimestampValue() {
    if (valueTypeCase_ == 10) {
      return (com.google.protobuf.Timestamp) valueType_;
    }
    return com.google.protobuf.Timestamp.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A timestamp value.
   * Precise only to microseconds. When stored, any additional precision is
   * rounded down.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp timestamp_value = 10;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getTimestampValueOrBuilder() {
    if (valueTypeCase_ == 10) {
      return (com.google.protobuf.Timestamp) valueType_;
    }
    return com.google.protobuf.Timestamp.getDefaultInstance();
  }

  public static final int STRING_VALUE_FIELD_NUMBER = 17;
  /**
   *
   *
   * <pre>
   * A string value.
   * The string, represented as UTF-8, must not exceed 1 MiB - 89 bytes.
   * Only the first 1,500 bytes of the UTF-8 representation are considered by
   * queries.
   * </pre>
   *
   * <code>string string_value = 17;</code>
   *
   * @return Whether the stringValue field is set.
   */
  public boolean hasStringValue() {
    return valueTypeCase_ == 17;
  }
  /**
   *
   *
   * <pre>
   * A string value.
   * The string, represented as UTF-8, must not exceed 1 MiB - 89 bytes.
   * Only the first 1,500 bytes of the UTF-8 representation are considered by
   * queries.
   * </pre>
   *
   * <code>string string_value = 17;</code>
   *
   * @return The stringValue.
   */
  public java.lang.String getStringValue() {
    java.lang.Object ref = "";
    if (valueTypeCase_ == 17) {
      ref = valueType_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (valueTypeCase_ == 17) {
        valueType_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A string value.
   * The string, represented as UTF-8, must not exceed 1 MiB - 89 bytes.
   * Only the first 1,500 bytes of the UTF-8 representation are considered by
   * queries.
   * </pre>
   *
   * <code>string string_value = 17;</code>
   *
   * @return The bytes for stringValue.
   */
  public com.google.protobuf.ByteString getStringValueBytes() {
    java.lang.Object ref = "";
    if (valueTypeCase_ == 17) {
      ref = valueType_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (valueTypeCase_ == 17) {
        valueType_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int BYTES_VALUE_FIELD_NUMBER = 18;
  /**
   *
   *
   * <pre>
   * A bytes value.
   * Must not exceed 1 MiB - 89 bytes.
   * Only the first 1,500 bytes are considered by queries.
   * </pre>
   *
   * <code>bytes bytes_value = 18;</code>
   *
   * @return Whether the bytesValue field is set.
   */
  @java.lang.Override
  public boolean hasBytesValue() {
    return valueTypeCase_ == 18;
  }
  /**
   *
   *
   * <pre>
   * A bytes value.
   * Must not exceed 1 MiB - 89 bytes.
   * Only the first 1,500 bytes are considered by queries.
   * </pre>
   *
   * <code>bytes bytes_value = 18;</code>
   *
   * @return The bytesValue.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBytesValue() {
    if (valueTypeCase_ == 18) {
      return (com.google.protobuf.ByteString) valueType_;
    }
    return com.google.protobuf.ByteString.EMPTY;
  }

  public static final int REFERENCE_VALUE_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * A reference to a document. For example:
   * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
   * </pre>
   *
   * <code>string reference_value = 5;</code>
   *
   * @return Whether the referenceValue field is set.
   */
  public boolean hasReferenceValue() {
    return valueTypeCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * A reference to a document. For example:
   * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
   * </pre>
   *
   * <code>string reference_value = 5;</code>
   *
   * @return The referenceValue.
   */
  public java.lang.String getReferenceValue() {
    java.lang.Object ref = "";
    if (valueTypeCase_ == 5) {
      ref = valueType_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (valueTypeCase_ == 5) {
        valueType_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A reference to a document. For example:
   * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
   * </pre>
   *
   * <code>string reference_value = 5;</code>
   *
   * @return The bytes for referenceValue.
   */
  public com.google.protobuf.ByteString getReferenceValueBytes() {
    java.lang.Object ref = "";
    if (valueTypeCase_ == 5) {
      ref = valueType_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (valueTypeCase_ == 5) {
        valueType_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int GEO_POINT_VALUE_FIELD_NUMBER = 8;
  /**
   *
   *
   * <pre>
   * A geo point value representing a point on the surface of Earth.
   * </pre>
   *
   * <code>.google.type.LatLng geo_point_value = 8;</code>
   *
   * @return Whether the geoPointValue field is set.
   */
  @java.lang.Override
  public boolean hasGeoPointValue() {
    return valueTypeCase_ == 8;
  }
  /**
   *
   *
   * <pre>
   * A geo point value representing a point on the surface of Earth.
   * </pre>
   *
   * <code>.google.type.LatLng geo_point_value = 8;</code>
   *
   * @return The geoPointValue.
   */
  @java.lang.Override
  public com.google.type.LatLng getGeoPointValue() {
    if (valueTypeCase_ == 8) {
      return (com.google.type.LatLng) valueType_;
    }
    return com.google.type.LatLng.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A geo point value representing a point on the surface of Earth.
   * </pre>
   *
   * <code>.google.type.LatLng geo_point_value = 8;</code>
   */
  @java.lang.Override
  public com.google.type.LatLngOrBuilder getGeoPointValueOrBuilder() {
    if (valueTypeCase_ == 8) {
      return (com.google.type.LatLng) valueType_;
    }
    return com.google.type.LatLng.getDefaultInstance();
  }

  public static final int ARRAY_VALUE_FIELD_NUMBER = 9;
  /**
   *
   *
   * <pre>
   * An array value.
   * Cannot directly contain another array value, though can contain an
   * map which contains another array.
   * </pre>
   *
   * <code>.google.firestore.v1.ArrayValue array_value = 9;</code>
   *
   * @return Whether the arrayValue field is set.
   */
  @java.lang.Override
  public boolean hasArrayValue() {
    return valueTypeCase_ == 9;
  }
  /**
   *
   *
   * <pre>
   * An array value.
   * Cannot directly contain another array value, though can contain an
   * map which contains another array.
   * </pre>
   *
   * <code>.google.firestore.v1.ArrayValue array_value = 9;</code>
   *
   * @return The arrayValue.
   */
  @java.lang.Override
  public com.google.firestore.v1.ArrayValue getArrayValue() {
    if (valueTypeCase_ == 9) {
      return (com.google.firestore.v1.ArrayValue) valueType_;
    }
    return com.google.firestore.v1.ArrayValue.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * An array value.
   * Cannot directly contain another array value, though can contain an
   * map which contains another array.
   * </pre>
   *
   * <code>.google.firestore.v1.ArrayValue array_value = 9;</code>
   */
  @java.lang.Override
  public com.google.firestore.v1.ArrayValueOrBuilder getArrayValueOrBuilder() {
    if (valueTypeCase_ == 9) {
      return (com.google.firestore.v1.ArrayValue) valueType_;
    }
    return com.google.firestore.v1.ArrayValue.getDefaultInstance();
  }

  public static final int MAP_VALUE_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * A map value.
   * </pre>
   *
   * <code>.google.firestore.v1.MapValue map_value = 6;</code>
   *
   * @return Whether the mapValue field is set.
   */
  @java.lang.Override
  public boolean hasMapValue() {
    return valueTypeCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * A map value.
   * </pre>
   *
   * <code>.google.firestore.v1.MapValue map_value = 6;</code>
   *
   * @return The mapValue.
   */
  @java.lang.Override
  public com.google.firestore.v1.MapValue getMapValue() {
    if (valueTypeCase_ == 6) {
      return (com.google.firestore.v1.MapValue) valueType_;
    }
    return com.google.firestore.v1.MapValue.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A map value.
   * </pre>
   *
   * <code>.google.firestore.v1.MapValue map_value = 6;</code>
   */
  @java.lang.Override
  public com.google.firestore.v1.MapValueOrBuilder getMapValueOrBuilder() {
    if (valueTypeCase_ == 6) {
      return (com.google.firestore.v1.MapValue) valueType_;
    }
    return com.google.firestore.v1.MapValue.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (valueTypeCase_ == 1) {
      output.writeBool(1, (boolean) ((java.lang.Boolean) valueType_));
    }
    if (valueTypeCase_ == 2) {
      output.writeInt64(2, (long) ((java.lang.Long) valueType_));
    }
    if (valueTypeCase_ == 3) {
      output.writeDouble(3, (double) ((java.lang.Double) valueType_));
    }
    if (valueTypeCase_ == 5) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, valueType_);
    }
    if (valueTypeCase_ == 6) {
      output.writeMessage(6, (com.google.firestore.v1.MapValue) valueType_);
    }
    if (valueTypeCase_ == 8) {
      output.writeMessage(8, (com.google.type.LatLng) valueType_);
    }
    if (valueTypeCase_ == 9) {
      output.writeMessage(9, (com.google.firestore.v1.ArrayValue) valueType_);
    }
    if (valueTypeCase_ == 10) {
      output.writeMessage(10, (com.google.protobuf.Timestamp) valueType_);
    }
    if (valueTypeCase_ == 11) {
      output.writeEnum(11, ((java.lang.Integer) valueType_));
    }
    if (valueTypeCase_ == 17) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 17, valueType_);
    }
    if (valueTypeCase_ == 18) {
      output.writeBytes(18, (com.google.protobuf.ByteString) valueType_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (valueTypeCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(
              1, (boolean) ((java.lang.Boolean) valueType_));
    }
    if (valueTypeCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt64Size(
              2, (long) ((java.lang.Long) valueType_));
    }
    if (valueTypeCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeDoubleSize(
              3, (double) ((java.lang.Double) valueType_));
    }
    if (valueTypeCase_ == 5) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, valueType_);
    }
    if (valueTypeCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.firestore.v1.MapValue) valueType_);
    }
    if (valueTypeCase_ == 8) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              8, (com.google.type.LatLng) valueType_);
    }
    if (valueTypeCase_ == 9) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              9, (com.google.firestore.v1.ArrayValue) valueType_);
    }
    if (valueTypeCase_ == 10) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              10, (com.google.protobuf.Timestamp) valueType_);
    }
    if (valueTypeCase_ == 11) {
      size +=
          com.google.protobuf.CodedOutputStream.computeEnumSize(
              11, ((java.lang.Integer) valueType_));
    }
    if (valueTypeCase_ == 17) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(17, valueType_);
    }
    if (valueTypeCase_ == 18) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBytesSize(
              18, (com.google.protobuf.ByteString) valueType_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.firestore.v1.Value)) {
      return super.equals(obj);
    }
    com.google.firestore.v1.Value other = (com.google.firestore.v1.Value) obj;

    if (!getValueTypeCase().equals(other.getValueTypeCase())) return false;
    switch (valueTypeCase_) {
      case 11:
        if (getNullValueValue() != other.getNullValueValue()) return false;
        break;
      case 1:
        if (getBooleanValue() != other.getBooleanValue()) return false;
        break;
      case 2:
        if (getIntegerValue() != other.getIntegerValue()) return false;
        break;
      case 3:
        if (java.lang.Double.doubleToLongBits(getDoubleValue())
            != java.lang.Double.doubleToLongBits(other.getDoubleValue())) return false;
        break;
      case 10:
        if (!getTimestampValue().equals(other.getTimestampValue())) return false;
        break;
      case 17:
        if (!getStringValue().equals(other.getStringValue())) return false;
        break;
      case 18:
        if (!getBytesValue().equals(other.getBytesValue())) return false;
        break;
      case 5:
        if (!getReferenceValue().equals(other.getReferenceValue())) return false;
        break;
      case 8:
        if (!getGeoPointValue().equals(other.getGeoPointValue())) return false;
        break;
      case 9:
        if (!getArrayValue().equals(other.getArrayValue())) return false;
        break;
      case 6:
        if (!getMapValue().equals(other.getMapValue())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (valueTypeCase_) {
      case 11:
        hash = (37 * hash) + NULL_VALUE_FIELD_NUMBER;
        hash = (53 * hash) + getNullValueValue();
        break;
      case 1:
        hash = (37 * hash) + BOOLEAN_VALUE_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getBooleanValue());
        break;
      case 2:
        hash = (37 * hash) + INTEGER_VALUE_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getIntegerValue());
        break;
      case 3:
        hash = (37 * hash) + DOUBLE_VALUE_FIELD_NUMBER;
        hash =
            (53 * hash)
                + com.google.protobuf.Internal.hashLong(
                    java.lang.Double.doubleToLongBits(getDoubleValue()));
        break;
      case 10:
        hash = (37 * hash) + TIMESTAMP_VALUE_FIELD_NUMBER;
        hash = (53 * hash) + getTimestampValue().hashCode();
        break;
      case 17:
        hash = (37 * hash) + STRING_VALUE_FIELD_NUMBER;
        hash = (53 * hash) + getStringValue().hashCode();
        break;
      case 18:
        hash = (37 * hash) + BYTES_VALUE_FIELD_NUMBER;
        hash = (53 * hash) + getBytesValue().hashCode();
        break;
      case 5:
        hash = (37 * hash) + REFERENCE_VALUE_FIELD_NUMBER;
        hash = (53 * hash) + getReferenceValue().hashCode();
        break;
      case 8:
        hash = (37 * hash) + GEO_POINT_VALUE_FIELD_NUMBER;
        hash = (53 * hash) + getGeoPointValue().hashCode();
        break;
      case 9:
        hash = (37 * hash) + ARRAY_VALUE_FIELD_NUMBER;
        hash = (53 * hash) + getArrayValue().hashCode();
        break;
      case 6:
        hash = (37 * hash) + MAP_VALUE_FIELD_NUMBER;
        hash = (53 * hash) + getMapValue().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.firestore.v1.Value parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1.Value parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1.Value parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1.Value parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1.Value parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1.Value parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1.Value parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1.Value parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.v1.Value parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1.Value parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.v1.Value parseFrom(com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1.Value parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.firestore.v1.Value prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A message that can hold any of the supported value types.
   * </pre>
   *
   * Protobuf type {@code google.firestore.v1.Value}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.firestore.v1.Value)
      com.google.firestore.v1.ValueOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.firestore.v1.DocumentProto
          .internal_static_google_firestore_v1_Value_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.firestore.v1.DocumentProto
          .internal_static_google_firestore_v1_Value_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.firestore.v1.Value.class, com.google.firestore.v1.Value.Builder.class);
    }

    // Construct using com.google.firestore.v1.Value.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (timestampValueBuilder_ != null) {
        timestampValueBuilder_.clear();
      }
      if (geoPointValueBuilder_ != null) {
        geoPointValueBuilder_.clear();
      }
      if (arrayValueBuilder_ != null) {
        arrayValueBuilder_.clear();
      }
      if (mapValueBuilder_ != null) {
        mapValueBuilder_.clear();
      }
      valueTypeCase_ = 0;
      valueType_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.firestore.v1.DocumentProto
          .internal_static_google_firestore_v1_Value_descriptor;
    }

    @java.lang.Override
    public com.google.firestore.v1.Value getDefaultInstanceForType() {
      return com.google.firestore.v1.Value.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.firestore.v1.Value build() {
      com.google.firestore.v1.Value result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.firestore.v1.Value buildPartial() {
      com.google.firestore.v1.Value result = new com.google.firestore.v1.Value(this);
      if (valueTypeCase_ == 11) {
        result.valueType_ = valueType_;
      }
      if (valueTypeCase_ == 1) {
        result.valueType_ = valueType_;
      }
      if (valueTypeCase_ == 2) {
        result.valueType_ = valueType_;
      }
      if (valueTypeCase_ == 3) {
        result.valueType_ = valueType_;
      }
      if (valueTypeCase_ == 10) {
        if (timestampValueBuilder_ == null) {
          result.valueType_ = valueType_;
        } else {
          result.valueType_ = timestampValueBuilder_.build();
        }
      }
      if (valueTypeCase_ == 17) {
        result.valueType_ = valueType_;
      }
      if (valueTypeCase_ == 18) {
        result.valueType_ = valueType_;
      }
      if (valueTypeCase_ == 5) {
        result.valueType_ = valueType_;
      }
      if (valueTypeCase_ == 8) {
        if (geoPointValueBuilder_ == null) {
          result.valueType_ = valueType_;
        } else {
          result.valueType_ = geoPointValueBuilder_.build();
        }
      }
      if (valueTypeCase_ == 9) {
        if (arrayValueBuilder_ == null) {
          result.valueType_ = valueType_;
        } else {
          result.valueType_ = arrayValueBuilder_.build();
        }
      }
      if (valueTypeCase_ == 6) {
        if (mapValueBuilder_ == null) {
          result.valueType_ = valueType_;
        } else {
          result.valueType_ = mapValueBuilder_.build();
        }
      }
      result.valueTypeCase_ = valueTypeCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.firestore.v1.Value) {
        return mergeFrom((com.google.firestore.v1.Value) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.firestore.v1.Value other) {
      if (other == com.google.firestore.v1.Value.getDefaultInstance()) return this;
      switch (other.getValueTypeCase()) {
        case NULL_VALUE:
          {
            setNullValueValue(other.getNullValueValue());
            break;
          }
        case BOOLEAN_VALUE:
          {
            setBooleanValue(other.getBooleanValue());
            break;
          }
        case INTEGER_VALUE:
          {
            setIntegerValue(other.getIntegerValue());
            break;
          }
        case DOUBLE_VALUE:
          {
            setDoubleValue(other.getDoubleValue());
            break;
          }
        case TIMESTAMP_VALUE:
          {
            mergeTimestampValue(other.getTimestampValue());
            break;
          }
        case STRING_VALUE:
          {
            valueTypeCase_ = 17;
            valueType_ = other.valueType_;
            onChanged();
            break;
          }
        case BYTES_VALUE:
          {
            setBytesValue(other.getBytesValue());
            break;
          }
        case REFERENCE_VALUE:
          {
            valueTypeCase_ = 5;
            valueType_ = other.valueType_;
            onChanged();
            break;
          }
        case GEO_POINT_VALUE:
          {
            mergeGeoPointValue(other.getGeoPointValue());
            break;
          }
        case ARRAY_VALUE:
          {
            mergeArrayValue(other.getArrayValue());
            break;
          }
        case MAP_VALUE:
          {
            mergeMapValue(other.getMapValue());
            break;
          }
        case VALUETYPE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                valueType_ = input.readBool();
                valueTypeCase_ = 1;
                break;
              } // case 8
            case 16:
              {
                valueType_ = input.readInt64();
                valueTypeCase_ = 2;
                break;
              } // case 16
            case 25:
              {
                valueType_ = input.readDouble();
                valueTypeCase_ = 3;
                break;
              } // case 25
            case 42:
              {
                java.lang.String s = input.readStringRequireUtf8();
                valueTypeCase_ = 5;
                valueType_ = s;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getMapValueFieldBuilder().getBuilder(), extensionRegistry);
                valueTypeCase_ = 6;
                break;
              } // case 50
            case 66:
              {
                input.readMessage(getGeoPointValueFieldBuilder().getBuilder(), extensionRegistry);
                valueTypeCase_ = 8;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(getArrayValueFieldBuilder().getBuilder(), extensionRegistry);
                valueTypeCase_ = 9;
                break;
              } // case 74
            case 82:
              {
                input.readMessage(getTimestampValueFieldBuilder().getBuilder(), extensionRegistry);
                valueTypeCase_ = 10;
                break;
              } // case 82
            case 88:
              {
                int rawValue = input.readEnum();
                valueTypeCase_ = 11;
                valueType_ = rawValue;
                break;
              } // case 88
            case 138:
              {
                java.lang.String s = input.readStringRequireUtf8();
                valueTypeCase_ = 17;
                valueType_ = s;
                break;
              } // case 138
            case 146:
              {
                valueType_ = input.readBytes();
                valueTypeCase_ = 18;
                break;
              } // case 146
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int valueTypeCase_ = 0;
    private java.lang.Object valueType_;

    public ValueTypeCase getValueTypeCase() {
      return ValueTypeCase.forNumber(valueTypeCase_);
    }

    public Builder clearValueType() {
      valueTypeCase_ = 0;
      valueType_ = null;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A null value.
     * </pre>
     *
     * <code>.google.protobuf.NullValue null_value = 11;</code>
     *
     * @return Whether the nullValue field is set.
     */
    @java.lang.Override
    public boolean hasNullValue() {
      return valueTypeCase_ == 11;
    }
    /**
     *
     *
     * <pre>
     * A null value.
     * </pre>
     *
     * <code>.google.protobuf.NullValue null_value = 11;</code>
     *
     * @return The enum numeric value on the wire for nullValue.
     */
    @java.lang.Override
    public int getNullValueValue() {
      if (valueTypeCase_ == 11) {
        return ((java.lang.Integer) valueType_).intValue();
      }
      return 0;
    }
    /**
     *
     *
     * <pre>
     * A null value.
     * </pre>
     *
     * <code>.google.protobuf.NullValue null_value = 11;</code>
     *
     * @param value The enum numeric value on the wire for nullValue to set.
     * @return This builder for chaining.
     */
    public Builder setNullValueValue(int value) {
      valueTypeCase_ = 11;
      valueType_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A null value.
     * </pre>
     *
     * <code>.google.protobuf.NullValue null_value = 11;</code>
     *
     * @return The nullValue.
     */
    @java.lang.Override
    public com.google.protobuf.NullValue getNullValue() {
      if (valueTypeCase_ == 11) {
        @SuppressWarnings("deprecation")
        com.google.protobuf.NullValue result =
            com.google.protobuf.NullValue.valueOf((java.lang.Integer) valueType_);
        return result == null ? com.google.protobuf.NullValue.UNRECOGNIZED : result;
      }
      return com.google.protobuf.NullValue.NULL_VALUE;
    }
    /**
     *
     *
     * <pre>
     * A null value.
     * </pre>
     *
     * <code>.google.protobuf.NullValue null_value = 11;</code>
     *
     * @param value The nullValue to set.
     * @return This builder for chaining.
     */
    public Builder setNullValue(com.google.protobuf.NullValue value) {
      if (value == null) {
        throw new NullPointerException();
      }
      valueTypeCase_ = 11;
      valueType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A null value.
     * </pre>
     *
     * <code>.google.protobuf.NullValue null_value = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNullValue() {
      if (valueTypeCase_ == 11) {
        valueTypeCase_ = 0;
        valueType_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A boolean value.
     * </pre>
     *
     * <code>bool boolean_value = 1;</code>
     *
     * @return Whether the booleanValue field is set.
     */
    public boolean hasBooleanValue() {
      return valueTypeCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * A boolean value.
     * </pre>
     *
     * <code>bool boolean_value = 1;</code>
     *
     * @return The booleanValue.
     */
    public boolean getBooleanValue() {
      if (valueTypeCase_ == 1) {
        return (java.lang.Boolean) valueType_;
      }
      return false;
    }
    /**
     *
     *
     * <pre>
     * A boolean value.
     * </pre>
     *
     * <code>bool boolean_value = 1;</code>
     *
     * @param value The booleanValue to set.
     * @return This builder for chaining.
     */
    public Builder setBooleanValue(boolean value) {
      valueTypeCase_ = 1;
      valueType_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A boolean value.
     * </pre>
     *
     * <code>bool boolean_value = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBooleanValue() {
      if (valueTypeCase_ == 1) {
        valueTypeCase_ = 0;
        valueType_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * An integer value.
     * </pre>
     *
     * <code>int64 integer_value = 2;</code>
     *
     * @return Whether the integerValue field is set.
     */
    public boolean hasIntegerValue() {
      return valueTypeCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * An integer value.
     * </pre>
     *
     * <code>int64 integer_value = 2;</code>
     *
     * @return The integerValue.
     */
    public long getIntegerValue() {
      if (valueTypeCase_ == 2) {
        return (java.lang.Long) valueType_;
      }
      return 0L;
    }
    /**
     *
     *
     * <pre>
     * An integer value.
     * </pre>
     *
     * <code>int64 integer_value = 2;</code>
     *
     * @param value The integerValue to set.
     * @return This builder for chaining.
     */
    public Builder setIntegerValue(long value) {
      valueTypeCase_ = 2;
      valueType_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An integer value.
     * </pre>
     *
     * <code>int64 integer_value = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIntegerValue() {
      if (valueTypeCase_ == 2) {
        valueTypeCase_ = 0;
        valueType_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A double value.
     * </pre>
     *
     * <code>double double_value = 3;</code>
     *
     * @return Whether the doubleValue field is set.
     */
    public boolean hasDoubleValue() {
      return valueTypeCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * A double value.
     * </pre>
     *
     * <code>double double_value = 3;</code>
     *
     * @return The doubleValue.
     */
    public double getDoubleValue() {
      if (valueTypeCase_ == 3) {
        return (java.lang.Double) valueType_;
      }
      return 0D;
    }
    /**
     *
     *
     * <pre>
     * A double value.
     * </pre>
     *
     * <code>double double_value = 3;</code>
     *
     * @param value The doubleValue to set.
     * @return This builder for chaining.
     */
    public Builder setDoubleValue(double value) {
      valueTypeCase_ = 3;
      valueType_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A double value.
     * </pre>
     *
     * <code>double double_value = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDoubleValue() {
      if (valueTypeCase_ == 3) {
        valueTypeCase_ = 0;
        valueType_ = null;
        onChanged();
      }
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        timestampValueBuilder_;
    /**
     *
     *
     * <pre>
     * A timestamp value.
     * Precise only to microseconds. When stored, any additional precision is
     * rounded down.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp_value = 10;</code>
     *
     * @return Whether the timestampValue field is set.
     */
    @java.lang.Override
    public boolean hasTimestampValue() {
      return valueTypeCase_ == 10;
    }
    /**
     *
     *
     * <pre>
     * A timestamp value.
     * Precise only to microseconds. When stored, any additional precision is
     * rounded down.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp_value = 10;</code>
     *
     * @return The timestampValue.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getTimestampValue() {
      if (timestampValueBuilder_ == null) {
        if (valueTypeCase_ == 10) {
          return (com.google.protobuf.Timestamp) valueType_;
        }
        return com.google.protobuf.Timestamp.getDefaultInstance();
      } else {
        if (valueTypeCase_ == 10) {
          return timestampValueBuilder_.getMessage();
        }
        return com.google.protobuf.Timestamp.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A timestamp value.
     * Precise only to microseconds. When stored, any additional precision is
     * rounded down.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp_value = 10;</code>
     */
    public Builder setTimestampValue(com.google.protobuf.Timestamp value) {
      if (timestampValueBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        valueType_ = value;
        onChanged();
      } else {
        timestampValueBuilder_.setMessage(value);
      }
      valueTypeCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A timestamp value.
     * Precise only to microseconds. When stored, any additional precision is
     * rounded down.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp_value = 10;</code>
     */
    public Builder setTimestampValue(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (timestampValueBuilder_ == null) {
        valueType_ = builderForValue.build();
        onChanged();
      } else {
        timestampValueBuilder_.setMessage(builderForValue.build());
      }
      valueTypeCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A timestamp value.
     * Precise only to microseconds. When stored, any additional precision is
     * rounded down.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp_value = 10;</code>
     */
    public Builder mergeTimestampValue(com.google.protobuf.Timestamp value) {
      if (timestampValueBuilder_ == null) {
        if (valueTypeCase_ == 10
            && valueType_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          valueType_ =
              com.google.protobuf.Timestamp.newBuilder((com.google.protobuf.Timestamp) valueType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          valueType_ = value;
        }
        onChanged();
      } else {
        if (valueTypeCase_ == 10) {
          timestampValueBuilder_.mergeFrom(value);
        } else {
          timestampValueBuilder_.setMessage(value);
        }
      }
      valueTypeCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A timestamp value.
     * Precise only to microseconds. When stored, any additional precision is
     * rounded down.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp_value = 10;</code>
     */
    public Builder clearTimestampValue() {
      if (timestampValueBuilder_ == null) {
        if (valueTypeCase_ == 10) {
          valueTypeCase_ = 0;
          valueType_ = null;
          onChanged();
        }
      } else {
        if (valueTypeCase_ == 10) {
          valueTypeCase_ = 0;
          valueType_ = null;
        }
        timestampValueBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A timestamp value.
     * Precise only to microseconds. When stored, any additional precision is
     * rounded down.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp_value = 10;</code>
     */
    public com.google.protobuf.Timestamp.Builder getTimestampValueBuilder() {
      return getTimestampValueFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A timestamp value.
     * Precise only to microseconds. When stored, any additional precision is
     * rounded down.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp_value = 10;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getTimestampValueOrBuilder() {
      if ((valueTypeCase_ == 10) && (timestampValueBuilder_ != null)) {
        return timestampValueBuilder_.getMessageOrBuilder();
      } else {
        if (valueTypeCase_ == 10) {
          return (com.google.protobuf.Timestamp) valueType_;
        }
        return com.google.protobuf.Timestamp.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A timestamp value.
     * Precise only to microseconds. When stored, any additional precision is
     * rounded down.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp_value = 10;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getTimestampValueFieldBuilder() {
      if (timestampValueBuilder_ == null) {
        if (!(valueTypeCase_ == 10)) {
          valueType_ = com.google.protobuf.Timestamp.getDefaultInstance();
        }
        timestampValueBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                (com.google.protobuf.Timestamp) valueType_, getParentForChildren(), isClean());
        valueType_ = null;
      }
      valueTypeCase_ = 10;
      onChanged();
      ;
      return timestampValueBuilder_;
    }

    /**
     *
     *
     * <pre>
     * A string value.
     * The string, represented as UTF-8, must not exceed 1 MiB - 89 bytes.
     * Only the first 1,500 bytes of the UTF-8 representation are considered by
     * queries.
     * </pre>
     *
     * <code>string string_value = 17;</code>
     *
     * @return Whether the stringValue field is set.
     */
    @java.lang.Override
    public boolean hasStringValue() {
      return valueTypeCase_ == 17;
    }
    /**
     *
     *
     * <pre>
     * A string value.
     * The string, represented as UTF-8, must not exceed 1 MiB - 89 bytes.
     * Only the first 1,500 bytes of the UTF-8 representation are considered by
     * queries.
     * </pre>
     *
     * <code>string string_value = 17;</code>
     *
     * @return The stringValue.
     */
    @java.lang.Override
    public java.lang.String getStringValue() {
      java.lang.Object ref = "";
      if (valueTypeCase_ == 17) {
        ref = valueType_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (valueTypeCase_ == 17) {
          valueType_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A string value.
     * The string, represented as UTF-8, must not exceed 1 MiB - 89 bytes.
     * Only the first 1,500 bytes of the UTF-8 representation are considered by
     * queries.
     * </pre>
     *
     * <code>string string_value = 17;</code>
     *
     * @return The bytes for stringValue.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getStringValueBytes() {
      java.lang.Object ref = "";
      if (valueTypeCase_ == 17) {
        ref = valueType_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (valueTypeCase_ == 17) {
          valueType_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A string value.
     * The string, represented as UTF-8, must not exceed 1 MiB - 89 bytes.
     * Only the first 1,500 bytes of the UTF-8 representation are considered by
     * queries.
     * </pre>
     *
     * <code>string string_value = 17;</code>
     *
     * @param value The stringValue to set.
     * @return This builder for chaining.
     */
    public Builder setStringValue(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      valueTypeCase_ = 17;
      valueType_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A string value.
     * The string, represented as UTF-8, must not exceed 1 MiB - 89 bytes.
     * Only the first 1,500 bytes of the UTF-8 representation are considered by
     * queries.
     * </pre>
     *
     * <code>string string_value = 17;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStringValue() {
      if (valueTypeCase_ == 17) {
        valueTypeCase_ = 0;
        valueType_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A string value.
     * The string, represented as UTF-8, must not exceed 1 MiB - 89 bytes.
     * Only the first 1,500 bytes of the UTF-8 representation are considered by
     * queries.
     * </pre>
     *
     * <code>string string_value = 17;</code>
     *
     * @param value The bytes for stringValue to set.
     * @return This builder for chaining.
     */
    public Builder setStringValueBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      valueTypeCase_ = 17;
      valueType_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A bytes value.
     * Must not exceed 1 MiB - 89 bytes.
     * Only the first 1,500 bytes are considered by queries.
     * </pre>
     *
     * <code>bytes bytes_value = 18;</code>
     *
     * @return Whether the bytesValue field is set.
     */
    public boolean hasBytesValue() {
      return valueTypeCase_ == 18;
    }
    /**
     *
     *
     * <pre>
     * A bytes value.
     * Must not exceed 1 MiB - 89 bytes.
     * Only the first 1,500 bytes are considered by queries.
     * </pre>
     *
     * <code>bytes bytes_value = 18;</code>
     *
     * @return The bytesValue.
     */
    public com.google.protobuf.ByteString getBytesValue() {
      if (valueTypeCase_ == 18) {
        return (com.google.protobuf.ByteString) valueType_;
      }
      return com.google.protobuf.ByteString.EMPTY;
    }
    /**
     *
     *
     * <pre>
     * A bytes value.
     * Must not exceed 1 MiB - 89 bytes.
     * Only the first 1,500 bytes are considered by queries.
     * </pre>
     *
     * <code>bytes bytes_value = 18;</code>
     *
     * @param value The bytesValue to set.
     * @return This builder for chaining.
     */
    public Builder setBytesValue(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      valueTypeCase_ = 18;
      valueType_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A bytes value.
     * Must not exceed 1 MiB - 89 bytes.
     * Only the first 1,500 bytes are considered by queries.
     * </pre>
     *
     * <code>bytes bytes_value = 18;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBytesValue() {
      if (valueTypeCase_ == 18) {
        valueTypeCase_ = 0;
        valueType_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A reference to a document. For example:
     * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
     * </pre>
     *
     * <code>string reference_value = 5;</code>
     *
     * @return Whether the referenceValue field is set.
     */
    @java.lang.Override
    public boolean hasReferenceValue() {
      return valueTypeCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * A reference to a document. For example:
     * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
     * </pre>
     *
     * <code>string reference_value = 5;</code>
     *
     * @return The referenceValue.
     */
    @java.lang.Override
    public java.lang.String getReferenceValue() {
      java.lang.Object ref = "";
      if (valueTypeCase_ == 5) {
        ref = valueType_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (valueTypeCase_ == 5) {
          valueType_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A reference to a document. For example:
     * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
     * </pre>
     *
     * <code>string reference_value = 5;</code>
     *
     * @return The bytes for referenceValue.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getReferenceValueBytes() {
      java.lang.Object ref = "";
      if (valueTypeCase_ == 5) {
        ref = valueType_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (valueTypeCase_ == 5) {
          valueType_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A reference to a document. For example:
     * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
     * </pre>
     *
     * <code>string reference_value = 5;</code>
     *
     * @param value The referenceValue to set.
     * @return This builder for chaining.
     */
    public Builder setReferenceValue(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      valueTypeCase_ = 5;
      valueType_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A reference to a document. For example:
     * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
     * </pre>
     *
     * <code>string reference_value = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReferenceValue() {
      if (valueTypeCase_ == 5) {
        valueTypeCase_ = 0;
        valueType_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A reference to a document. For example:
     * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
     * </pre>
     *
     * <code>string reference_value = 5;</code>
     *
     * @param value The bytes for referenceValue to set.
     * @return This builder for chaining.
     */
    public Builder setReferenceValueBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      valueTypeCase_ = 5;
      valueType_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.LatLng, com.google.type.LatLng.Builder, com.google.type.LatLngOrBuilder>
        geoPointValueBuilder_;
    /**
     *
     *
     * <pre>
     * A geo point value representing a point on the surface of Earth.
     * </pre>
     *
     * <code>.google.type.LatLng geo_point_value = 8;</code>
     *
     * @return Whether the geoPointValue field is set.
     */
    @java.lang.Override
    public boolean hasGeoPointValue() {
      return valueTypeCase_ == 8;
    }
    /**
     *
     *
     * <pre>
     * A geo point value representing a point on the surface of Earth.
     * </pre>
     *
     * <code>.google.type.LatLng geo_point_value = 8;</code>
     *
     * @return The geoPointValue.
     */
    @java.lang.Override
    public com.google.type.LatLng getGeoPointValue() {
      if (geoPointValueBuilder_ == null) {
        if (valueTypeCase_ == 8) {
          return (com.google.type.LatLng) valueType_;
        }
        return com.google.type.LatLng.getDefaultInstance();
      } else {
        if (valueTypeCase_ == 8) {
          return geoPointValueBuilder_.getMessage();
        }
        return com.google.type.LatLng.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A geo point value representing a point on the surface of Earth.
     * </pre>
     *
     * <code>.google.type.LatLng geo_point_value = 8;</code>
     */
    public Builder setGeoPointValue(com.google.type.LatLng value) {
      if (geoPointValueBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        valueType_ = value;
        onChanged();
      } else {
        geoPointValueBuilder_.setMessage(value);
      }
      valueTypeCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A geo point value representing a point on the surface of Earth.
     * </pre>
     *
     * <code>.google.type.LatLng geo_point_value = 8;</code>
     */
    public Builder setGeoPointValue(com.google.type.LatLng.Builder builderForValue) {
      if (geoPointValueBuilder_ == null) {
        valueType_ = builderForValue.build();
        onChanged();
      } else {
        geoPointValueBuilder_.setMessage(builderForValue.build());
      }
      valueTypeCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A geo point value representing a point on the surface of Earth.
     * </pre>
     *
     * <code>.google.type.LatLng geo_point_value = 8;</code>
     */
    public Builder mergeGeoPointValue(com.google.type.LatLng value) {
      if (geoPointValueBuilder_ == null) {
        if (valueTypeCase_ == 8 && valueType_ != com.google.type.LatLng.getDefaultInstance()) {
          valueType_ =
              com.google.type.LatLng.newBuilder((com.google.type.LatLng) valueType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          valueType_ = value;
        }
        onChanged();
      } else {
        if (valueTypeCase_ == 8) {
          geoPointValueBuilder_.mergeFrom(value);
        } else {
          geoPointValueBuilder_.setMessage(value);
        }
      }
      valueTypeCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A geo point value representing a point on the surface of Earth.
     * </pre>
     *
     * <code>.google.type.LatLng geo_point_value = 8;</code>
     */
    public Builder clearGeoPointValue() {
      if (geoPointValueBuilder_ == null) {
        if (valueTypeCase_ == 8) {
          valueTypeCase_ = 0;
          valueType_ = null;
          onChanged();
        }
      } else {
        if (valueTypeCase_ == 8) {
          valueTypeCase_ = 0;
          valueType_ = null;
        }
        geoPointValueBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A geo point value representing a point on the surface of Earth.
     * </pre>
     *
     * <code>.google.type.LatLng geo_point_value = 8;</code>
     */
    public com.google.type.LatLng.Builder getGeoPointValueBuilder() {
      return getGeoPointValueFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A geo point value representing a point on the surface of Earth.
     * </pre>
     *
     * <code>.google.type.LatLng geo_point_value = 8;</code>
     */
    @java.lang.Override
    public com.google.type.LatLngOrBuilder getGeoPointValueOrBuilder() {
      if ((valueTypeCase_ == 8) && (geoPointValueBuilder_ != null)) {
        return geoPointValueBuilder_.getMessageOrBuilder();
      } else {
        if (valueTypeCase_ == 8) {
          return (com.google.type.LatLng) valueType_;
        }
        return com.google.type.LatLng.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A geo point value representing a point on the surface of Earth.
     * </pre>
     *
     * <code>.google.type.LatLng geo_point_value = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.LatLng, com.google.type.LatLng.Builder, com.google.type.LatLngOrBuilder>
        getGeoPointValueFieldBuilder() {
      if (geoPointValueBuilder_ == null) {
        if (!(valueTypeCase_ == 8)) {
          valueType_ = com.google.type.LatLng.getDefaultInstance();
        }
        geoPointValueBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.type.LatLng,
                com.google.type.LatLng.Builder,
                com.google.type.LatLngOrBuilder>(
                (com.google.type.LatLng) valueType_, getParentForChildren(), isClean());
        valueType_ = null;
      }
      valueTypeCase_ = 8;
      onChanged();
      ;
      return geoPointValueBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.v1.ArrayValue,
            com.google.firestore.v1.ArrayValue.Builder,
            com.google.firestore.v1.ArrayValueOrBuilder>
        arrayValueBuilder_;
    /**
     *
     *
     * <pre>
     * An array value.
     * Cannot directly contain another array value, though can contain an
     * map which contains another array.
     * </pre>
     *
     * <code>.google.firestore.v1.ArrayValue array_value = 9;</code>
     *
     * @return Whether the arrayValue field is set.
     */
    @java.lang.Override
    public boolean hasArrayValue() {
      return valueTypeCase_ == 9;
    }
    /**
     *
     *
     * <pre>
     * An array value.
     * Cannot directly contain another array value, though can contain an
     * map which contains another array.
     * </pre>
     *
     * <code>.google.firestore.v1.ArrayValue array_value = 9;</code>
     *
     * @return The arrayValue.
     */
    @java.lang.Override
    public com.google.firestore.v1.ArrayValue getArrayValue() {
      if (arrayValueBuilder_ == null) {
        if (valueTypeCase_ == 9) {
          return (com.google.firestore.v1.ArrayValue) valueType_;
        }
        return com.google.firestore.v1.ArrayValue.getDefaultInstance();
      } else {
        if (valueTypeCase_ == 9) {
          return arrayValueBuilder_.getMessage();
        }
        return com.google.firestore.v1.ArrayValue.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * An array value.
     * Cannot directly contain another array value, though can contain an
     * map which contains another array.
     * </pre>
     *
     * <code>.google.firestore.v1.ArrayValue array_value = 9;</code>
     */
    public Builder setArrayValue(com.google.firestore.v1.ArrayValue value) {
      if (arrayValueBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        valueType_ = value;
        onChanged();
      } else {
        arrayValueBuilder_.setMessage(value);
      }
      valueTypeCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * An array value.
     * Cannot directly contain another array value, though can contain an
     * map which contains another array.
     * </pre>
     *
     * <code>.google.firestore.v1.ArrayValue array_value = 9;</code>
     */
    public Builder setArrayValue(com.google.firestore.v1.ArrayValue.Builder builderForValue) {
      if (arrayValueBuilder_ == null) {
        valueType_ = builderForValue.build();
        onChanged();
      } else {
        arrayValueBuilder_.setMessage(builderForValue.build());
      }
      valueTypeCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * An array value.
     * Cannot directly contain another array value, though can contain an
     * map which contains another array.
     * </pre>
     *
     * <code>.google.firestore.v1.ArrayValue array_value = 9;</code>
     */
    public Builder mergeArrayValue(com.google.firestore.v1.ArrayValue value) {
      if (arrayValueBuilder_ == null) {
        if (valueTypeCase_ == 9
            && valueType_ != com.google.firestore.v1.ArrayValue.getDefaultInstance()) {
          valueType_ =
              com.google.firestore.v1.ArrayValue.newBuilder(
                      (com.google.firestore.v1.ArrayValue) valueType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          valueType_ = value;
        }
        onChanged();
      } else {
        if (valueTypeCase_ == 9) {
          arrayValueBuilder_.mergeFrom(value);
        } else {
          arrayValueBuilder_.setMessage(value);
        }
      }
      valueTypeCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * An array value.
     * Cannot directly contain another array value, though can contain an
     * map which contains another array.
     * </pre>
     *
     * <code>.google.firestore.v1.ArrayValue array_value = 9;</code>
     */
    public Builder clearArrayValue() {
      if (arrayValueBuilder_ == null) {
        if (valueTypeCase_ == 9) {
          valueTypeCase_ = 0;
          valueType_ = null;
          onChanged();
        }
      } else {
        if (valueTypeCase_ == 9) {
          valueTypeCase_ = 0;
          valueType_ = null;
        }
        arrayValueBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An array value.
     * Cannot directly contain another array value, though can contain an
     * map which contains another array.
     * </pre>
     *
     * <code>.google.firestore.v1.ArrayValue array_value = 9;</code>
     */
    public com.google.firestore.v1.ArrayValue.Builder getArrayValueBuilder() {
      return getArrayValueFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * An array value.
     * Cannot directly contain another array value, though can contain an
     * map which contains another array.
     * </pre>
     *
     * <code>.google.firestore.v1.ArrayValue array_value = 9;</code>
     */
    @java.lang.Override
    public com.google.firestore.v1.ArrayValueOrBuilder getArrayValueOrBuilder() {
      if ((valueTypeCase_ == 9) && (arrayValueBuilder_ != null)) {
        return arrayValueBuilder_.getMessageOrBuilder();
      } else {
        if (valueTypeCase_ == 9) {
          return (com.google.firestore.v1.ArrayValue) valueType_;
        }
        return com.google.firestore.v1.ArrayValue.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * An array value.
     * Cannot directly contain another array value, though can contain an
     * map which contains another array.
     * </pre>
     *
     * <code>.google.firestore.v1.ArrayValue array_value = 9;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.v1.ArrayValue,
            com.google.firestore.v1.ArrayValue.Builder,
            com.google.firestore.v1.ArrayValueOrBuilder>
        getArrayValueFieldBuilder() {
      if (arrayValueBuilder_ == null) {
        if (!(valueTypeCase_ == 9)) {
          valueType_ = com.google.firestore.v1.ArrayValue.getDefaultInstance();
        }
        arrayValueBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.firestore.v1.ArrayValue,
                com.google.firestore.v1.ArrayValue.Builder,
                com.google.firestore.v1.ArrayValueOrBuilder>(
                (com.google.firestore.v1.ArrayValue) valueType_, getParentForChildren(), isClean());
        valueType_ = null;
      }
      valueTypeCase_ = 9;
      onChanged();
      ;
      return arrayValueBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.v1.MapValue,
            com.google.firestore.v1.MapValue.Builder,
            com.google.firestore.v1.MapValueOrBuilder>
        mapValueBuilder_;
    /**
     *
     *
     * <pre>
     * A map value.
     * </pre>
     *
     * <code>.google.firestore.v1.MapValue map_value = 6;</code>
     *
     * @return Whether the mapValue field is set.
     */
    @java.lang.Override
    public boolean hasMapValue() {
      return valueTypeCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * A map value.
     * </pre>
     *
     * <code>.google.firestore.v1.MapValue map_value = 6;</code>
     *
     * @return The mapValue.
     */
    @java.lang.Override
    public com.google.firestore.v1.MapValue getMapValue() {
      if (mapValueBuilder_ == null) {
        if (valueTypeCase_ == 6) {
          return (com.google.firestore.v1.MapValue) valueType_;
        }
        return com.google.firestore.v1.MapValue.getDefaultInstance();
      } else {
        if (valueTypeCase_ == 6) {
          return mapValueBuilder_.getMessage();
        }
        return com.google.firestore.v1.MapValue.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A map value.
     * </pre>
     *
     * <code>.google.firestore.v1.MapValue map_value = 6;</code>
     */
    public Builder setMapValue(com.google.firestore.v1.MapValue value) {
      if (mapValueBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        valueType_ = value;
        onChanged();
      } else {
        mapValueBuilder_.setMessage(value);
      }
      valueTypeCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A map value.
     * </pre>
     *
     * <code>.google.firestore.v1.MapValue map_value = 6;</code>
     */
    public Builder setMapValue(com.google.firestore.v1.MapValue.Builder builderForValue) {
      if (mapValueBuilder_ == null) {
        valueType_ = builderForValue.build();
        onChanged();
      } else {
        mapValueBuilder_.setMessage(builderForValue.build());
      }
      valueTypeCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A map value.
     * </pre>
     *
     * <code>.google.firestore.v1.MapValue map_value = 6;</code>
     */
    public Builder mergeMapValue(com.google.firestore.v1.MapValue value) {
      if (mapValueBuilder_ == null) {
        if (valueTypeCase_ == 6
            && valueType_ != com.google.firestore.v1.MapValue.getDefaultInstance()) {
          valueType_ =
              com.google.firestore.v1.MapValue.newBuilder(
                      (com.google.firestore.v1.MapValue) valueType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          valueType_ = value;
        }
        onChanged();
      } else {
        if (valueTypeCase_ == 6) {
          mapValueBuilder_.mergeFrom(value);
        } else {
          mapValueBuilder_.setMessage(value);
        }
      }
      valueTypeCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A map value.
     * </pre>
     *
     * <code>.google.firestore.v1.MapValue map_value = 6;</code>
     */
    public Builder clearMapValue() {
      if (mapValueBuilder_ == null) {
        if (valueTypeCase_ == 6) {
          valueTypeCase_ = 0;
          valueType_ = null;
          onChanged();
        }
      } else {
        if (valueTypeCase_ == 6) {
          valueTypeCase_ = 0;
          valueType_ = null;
        }
        mapValueBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A map value.
     * </pre>
     *
     * <code>.google.firestore.v1.MapValue map_value = 6;</code>
     */
    public com.google.firestore.v1.MapValue.Builder getMapValueBuilder() {
      return getMapValueFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A map value.
     * </pre>
     *
     * <code>.google.firestore.v1.MapValue map_value = 6;</code>
     */
    @java.lang.Override
    public com.google.firestore.v1.MapValueOrBuilder getMapValueOrBuilder() {
      if ((valueTypeCase_ == 6) && (mapValueBuilder_ != null)) {
        return mapValueBuilder_.getMessageOrBuilder();
      } else {
        if (valueTypeCase_ == 6) {
          return (com.google.firestore.v1.MapValue) valueType_;
        }
        return com.google.firestore.v1.MapValue.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A map value.
     * </pre>
     *
     * <code>.google.firestore.v1.MapValue map_value = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.v1.MapValue,
            com.google.firestore.v1.MapValue.Builder,
            com.google.firestore.v1.MapValueOrBuilder>
        getMapValueFieldBuilder() {
      if (mapValueBuilder_ == null) {
        if (!(valueTypeCase_ == 6)) {
          valueType_ = com.google.firestore.v1.MapValue.getDefaultInstance();
        }
        mapValueBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.firestore.v1.MapValue,
                com.google.firestore.v1.MapValue.Builder,
                com.google.firestore.v1.MapValueOrBuilder>(
                (com.google.firestore.v1.MapValue) valueType_, getParentForChildren(), isClean());
        valueType_ = null;
      }
      valueTypeCase_ = 6;
      onChanged();
      ;
      return mapValueBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.firestore.v1.Value)
  }

  // @@protoc_insertion_point(class_scope:google.firestore.v1.Value)
  private static final com.google.firestore.v1.Value DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.firestore.v1.Value();
  }

  public static com.google.firestore.v1.Value getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Value> PARSER =
      new com.google.protobuf.AbstractParser<Value>() {
        @java.lang.Override
        public Value parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Value> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Value> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.firestore.v1.Value getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
