/*
 * Decompiled with CFR 0.152.
 */
package com.google.firestore.admin.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameType;
import com.google.common.base.Preconditions;
import com.google.firestore.admin.v1beta1.DocumentRootNameType;
import java.util.Map;

public class DocumentRootName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/databases/{database}/documents");
    private final String project;
    private final String database;

    public String getProject() {
        return this.project;
    }

    public String getDatabase() {
        return this.database;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private DocumentRootName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.database = (String)Preconditions.checkNotNull((Object)builder.getDatabase());
    }

    public static DocumentRootName create(String project, String database) {
        return DocumentRootName.newBuilder().setProject(project).setDatabase(database).build();
    }

    public static DocumentRootName parse(String formattedString) {
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "DocumentRootName.parse: formattedString not in valid format");
        return DocumentRootName.create((String)matchMap.get("project"), (String)matchMap.get("database"));
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    public ResourceNameType getType() {
        return DocumentRootNameType.instance();
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "database", this.database});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DocumentRootName) {
            DocumentRootName that = (DocumentRootName)o;
            return this.project.equals(that.project) && this.database.equals(that.database);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        return h ^= this.database.hashCode();
    }

    public static class Builder {
        private String project;
        private String database;

        public String getProject() {
            return this.project;
        }

        public String getDatabase() {
            return this.database;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setDatabase(String database) {
            this.database = database;
            return this;
        }

        private Builder() {
        }

        private Builder(DocumentRootName documentRootName) {
            this.project = documentRootName.project;
            this.database = documentRootName.database;
        }

        public DocumentRootName build() {
            return new DocumentRootName(this);
        }
    }
}

