/*
 * Decompiled with CFR 0.152.
 */
package com.google.firestore.admin.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameType;
import com.google.common.base.Preconditions;
import com.google.firestore.admin.v1beta1.IndexNameType;
import java.util.Map;

public class IndexName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/databases/{database}/indexes/{index}");
    private final String project;
    private final String database;
    private final String index;

    public String getProject() {
        return this.project;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getIndex() {
        return this.index;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private IndexName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.database = (String)Preconditions.checkNotNull((Object)builder.getDatabase());
        this.index = (String)Preconditions.checkNotNull((Object)builder.getIndex());
    }

    public static IndexName create(String project, String database, String index) {
        return IndexName.newBuilder().setProject(project).setDatabase(database).setIndex(index).build();
    }

    public static IndexName parse(String formattedString) {
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "IndexName.parse: formattedString not in valid format");
        return IndexName.create((String)matchMap.get("project"), (String)matchMap.get("database"), (String)matchMap.get("index"));
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    public ResourceNameType getType() {
        return IndexNameType.instance();
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "database", this.database, "index", this.index});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof IndexName) {
            IndexName that = (IndexName)o;
            return this.project.equals(that.project) && this.database.equals(that.database) && this.index.equals(that.index);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.database.hashCode();
        h *= 1000003;
        return h ^= this.index.hashCode();
    }

    public static class Builder {
        private String project;
        private String database;
        private String index;

        public String getProject() {
            return this.project;
        }

        public String getDatabase() {
            return this.database;
        }

        public String getIndex() {
            return this.index;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setDatabase(String database) {
            this.database = database;
            return this;
        }

        public Builder setIndex(String index) {
            this.index = index;
            return this;
        }

        private Builder() {
        }

        private Builder(IndexName indexName) {
            this.project = indexName.project;
            this.database = indexName.database;
            this.index = indexName.index;
        }

        public IndexName build() {
            return new IndexName(this);
        }
    }
}

