/*
 * Decompiled with CFR 0.152.
 */
package com.google.firestore.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameType;
import com.google.common.base.Preconditions;
import com.google.firestore.v1beta1.DatabaseNameType;
import java.util.Map;

public class DatabaseName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/databases/{database}");
    private final String project;
    private final String database;

    public String getProject() {
        return this.project;
    }

    public String getDatabase() {
        return this.database;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private DatabaseName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.database = (String)Preconditions.checkNotNull((Object)builder.getDatabase());
    }

    public static DatabaseName create(String project, String database) {
        return DatabaseName.newBuilder().setProject(project).setDatabase(database).build();
    }

    public static DatabaseName parse(String formattedString) {
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "DatabaseName.parse: formattedString not in valid format");
        return DatabaseName.create((String)matchMap.get("project"), (String)matchMap.get("database"));
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    public ResourceNameType getType() {
        return DatabaseNameType.instance();
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "database", this.database});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DatabaseName) {
            DatabaseName that = (DatabaseName)o;
            return this.project.equals(that.project) && this.database.equals(that.database);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        return h ^= this.database.hashCode();
    }

    public static class Builder {
        private String project;
        private String database;

        public String getProject() {
            return this.project;
        }

        public String getDatabase() {
            return this.database;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setDatabase(String database) {
            this.database = database;
            return this;
        }

        private Builder() {
        }

        private Builder(DatabaseName databaseName) {
            this.project = databaseName.project;
            this.database = databaseName.database;
        }

        public DatabaseName build() {
            return new DatabaseName(this);
        }
    }
}

