/*
 * Decompiled with CFR 0.152.
 */
package com.google.firestore.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DocumentPathName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/databases/{database}/documents/{document_path=**}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String database;
    private final String documentPath;

    public String getProject() {
        return this.project;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getDocumentPath() {
        return this.documentPath;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private DocumentPathName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.database = (String)Preconditions.checkNotNull((Object)builder.getDatabase());
        this.documentPath = (String)Preconditions.checkNotNull((Object)builder.getDocumentPath());
    }

    public static DocumentPathName of(String project, String database, String documentPath) {
        return DocumentPathName.newBuilder().setProject(project).setDatabase(database).setDocumentPath(documentPath).build();
    }

    public static String format(String project, String database, String documentPath) {
        return DocumentPathName.newBuilder().setProject(project).setDatabase(database).setDocumentPath(documentPath).build().toString();
    }

    public static DocumentPathName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "DocumentPathName.parse: formattedString not in valid format");
        return DocumentPathName.of((String)matchMap.get("project"), (String)matchMap.get("database"), (String)matchMap.get("document_path"));
    }

    public static List<DocumentPathName> parseList(List<String> formattedStrings) {
        ArrayList<DocumentPathName> list = new ArrayList<DocumentPathName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DocumentPathName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DocumentPathName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DocumentPathName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DocumentPathName documentPathName = this;
            synchronized (documentPathName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"database", (Object)this.database);
                    fieldMapBuilder.put((Object)"documentPath", (Object)this.documentPath);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    @Deprecated
    public ResourceNameType getType() {
        throw new UnsupportedOperationException("DocumentPathName.getType() not supported");
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "database", this.database, "document_path", this.documentPath});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DocumentPathName) {
            DocumentPathName that = (DocumentPathName)o;
            return this.project.equals(that.project) && this.database.equals(that.database) && this.documentPath.equals(that.documentPath);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.database.hashCode();
        h *= 1000003;
        return h ^= this.documentPath.hashCode();
    }

    public static class Builder {
        private String project;
        private String database;
        private String documentPath;

        public String getProject() {
            return this.project;
        }

        public String getDatabase() {
            return this.database;
        }

        public String getDocumentPath() {
            return this.documentPath;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setDatabase(String database) {
            this.database = database;
            return this;
        }

        public Builder setDocumentPath(String documentPath) {
            this.documentPath = documentPath;
            return this;
        }

        private Builder() {
        }

        private Builder(DocumentPathName documentPathName) {
            this.project = documentPathName.project;
            this.database = documentPathName.database;
            this.documentPath = documentPathName.documentPath;
        }

        public DocumentPathName build() {
            return new DocumentPathName(this);
        }
    }
}

