/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/functions/v1/functions.proto

package com.google.cloud.functions.v1;

/**
 *
 *
 * <pre>
 * Response for the `ListFunctions` method.
 * </pre>
 *
 * Protobuf type {@code google.cloud.functions.v1.ListFunctionsResponse}
 */
public final class ListFunctionsResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.functions.v1.ListFunctionsResponse)
    ListFunctionsResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ListFunctionsResponse.newBuilder() to construct.
  private ListFunctionsResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ListFunctionsResponse() {
    functions_ = java.util.Collections.emptyList();
    nextPageToken_ = "";
    unreachable_ = com.google.protobuf.LazyStringArrayList.EMPTY;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ListFunctionsResponse();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.functions.v1.FunctionsProto
        .internal_static_google_cloud_functions_v1_ListFunctionsResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.functions.v1.FunctionsProto
        .internal_static_google_cloud_functions_v1_ListFunctionsResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.functions.v1.ListFunctionsResponse.class,
            com.google.cloud.functions.v1.ListFunctionsResponse.Builder.class);
  }

  public static final int FUNCTIONS_FIELD_NUMBER = 1;
  private java.util.List<com.google.cloud.functions.v1.CloudFunction> functions_;
  /**
   *
   *
   * <pre>
   * The functions that match the request.
   * </pre>
   *
   * <code>repeated .google.cloud.functions.v1.CloudFunction functions = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.functions.v1.CloudFunction> getFunctionsList() {
    return functions_;
  }
  /**
   *
   *
   * <pre>
   * The functions that match the request.
   * </pre>
   *
   * <code>repeated .google.cloud.functions.v1.CloudFunction functions = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.functions.v1.CloudFunctionOrBuilder>
      getFunctionsOrBuilderList() {
    return functions_;
  }
  /**
   *
   *
   * <pre>
   * The functions that match the request.
   * </pre>
   *
   * <code>repeated .google.cloud.functions.v1.CloudFunction functions = 1;</code>
   */
  @java.lang.Override
  public int getFunctionsCount() {
    return functions_.size();
  }
  /**
   *
   *
   * <pre>
   * The functions that match the request.
   * </pre>
   *
   * <code>repeated .google.cloud.functions.v1.CloudFunction functions = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.functions.v1.CloudFunction getFunctions(int index) {
    return functions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The functions that match the request.
   * </pre>
   *
   * <code>repeated .google.cloud.functions.v1.CloudFunction functions = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.functions.v1.CloudFunctionOrBuilder getFunctionsOrBuilder(int index) {
    return functions_.get(index);
  }

  public static final int NEXT_PAGE_TOKEN_FIELD_NUMBER = 2;
  private volatile java.lang.Object nextPageToken_;
  /**
   *
   *
   * <pre>
   * If not empty, indicates that there may be more functions that match
   * the request; this value should be passed in a new
   * [google.cloud.functions.v1.ListFunctionsRequest][google.cloud.functions.v1.ListFunctionsRequest]
   * to get more functions.
   * </pre>
   *
   * <code>string next_page_token = 2;</code>
   *
   * @return The nextPageToken.
   */
  @java.lang.Override
  public java.lang.String getNextPageToken() {
    java.lang.Object ref = nextPageToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      nextPageToken_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * If not empty, indicates that there may be more functions that match
   * the request; this value should be passed in a new
   * [google.cloud.functions.v1.ListFunctionsRequest][google.cloud.functions.v1.ListFunctionsRequest]
   * to get more functions.
   * </pre>
   *
   * <code>string next_page_token = 2;</code>
   *
   * @return The bytes for nextPageToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNextPageTokenBytes() {
    java.lang.Object ref = nextPageToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      nextPageToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int UNREACHABLE_FIELD_NUMBER = 3;
  private com.google.protobuf.LazyStringList unreachable_;
  /**
   *
   *
   * <pre>
   * Locations that could not be reached. The response does not include any
   * functions from these locations.
   * </pre>
   *
   * <code>repeated string unreachable = 3;</code>
   *
   * @return A list containing the unreachable.
   */
  public com.google.protobuf.ProtocolStringList getUnreachableList() {
    return unreachable_;
  }
  /**
   *
   *
   * <pre>
   * Locations that could not be reached. The response does not include any
   * functions from these locations.
   * </pre>
   *
   * <code>repeated string unreachable = 3;</code>
   *
   * @return The count of unreachable.
   */
  public int getUnreachableCount() {
    return unreachable_.size();
  }
  /**
   *
   *
   * <pre>
   * Locations that could not be reached. The response does not include any
   * functions from these locations.
   * </pre>
   *
   * <code>repeated string unreachable = 3;</code>
   *
   * @param index The index of the element to return.
   * @return The unreachable at the given index.
   */
  public java.lang.String getUnreachable(int index) {
    return unreachable_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Locations that could not be reached. The response does not include any
   * functions from these locations.
   * </pre>
   *
   * <code>repeated string unreachable = 3;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the unreachable at the given index.
   */
  public com.google.protobuf.ByteString getUnreachableBytes(int index) {
    return unreachable_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < functions_.size(); i++) {
      output.writeMessage(1, functions_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, nextPageToken_);
    }
    for (int i = 0; i < unreachable_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, unreachable_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < functions_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, functions_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, nextPageToken_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < unreachable_.size(); i++) {
        dataSize += computeStringSizeNoTag(unreachable_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getUnreachableList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.functions.v1.ListFunctionsResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.functions.v1.ListFunctionsResponse other =
        (com.google.cloud.functions.v1.ListFunctionsResponse) obj;

    if (!getFunctionsList().equals(other.getFunctionsList())) return false;
    if (!getNextPageToken().equals(other.getNextPageToken())) return false;
    if (!getUnreachableList().equals(other.getUnreachableList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getFunctionsCount() > 0) {
      hash = (37 * hash) + FUNCTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getFunctionsList().hashCode();
    }
    hash = (37 * hash) + NEXT_PAGE_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getNextPageToken().hashCode();
    if (getUnreachableCount() > 0) {
      hash = (37 * hash) + UNREACHABLE_FIELD_NUMBER;
      hash = (53 * hash) + getUnreachableList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.functions.v1.ListFunctionsResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.functions.v1.ListFunctionsResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.functions.v1.ListFunctionsResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.functions.v1.ListFunctionsResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.functions.v1.ListFunctionsResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.functions.v1.ListFunctionsResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.functions.v1.ListFunctionsResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.functions.v1.ListFunctionsResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.functions.v1.ListFunctionsResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.functions.v1.ListFunctionsResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.functions.v1.ListFunctionsResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.functions.v1.ListFunctionsResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.functions.v1.ListFunctionsResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Response for the `ListFunctions` method.
   * </pre>
   *
   * Protobuf type {@code google.cloud.functions.v1.ListFunctionsResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.functions.v1.ListFunctionsResponse)
      com.google.cloud.functions.v1.ListFunctionsResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.functions.v1.FunctionsProto
          .internal_static_google_cloud_functions_v1_ListFunctionsResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.functions.v1.FunctionsProto
          .internal_static_google_cloud_functions_v1_ListFunctionsResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.functions.v1.ListFunctionsResponse.class,
              com.google.cloud.functions.v1.ListFunctionsResponse.Builder.class);
    }

    // Construct using com.google.cloud.functions.v1.ListFunctionsResponse.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (functionsBuilder_ == null) {
        functions_ = java.util.Collections.emptyList();
      } else {
        functions_ = null;
        functionsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      nextPageToken_ = "";

      unreachable_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000002);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.functions.v1.FunctionsProto
          .internal_static_google_cloud_functions_v1_ListFunctionsResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.functions.v1.ListFunctionsResponse getDefaultInstanceForType() {
      return com.google.cloud.functions.v1.ListFunctionsResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.functions.v1.ListFunctionsResponse build() {
      com.google.cloud.functions.v1.ListFunctionsResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.functions.v1.ListFunctionsResponse buildPartial() {
      com.google.cloud.functions.v1.ListFunctionsResponse result =
          new com.google.cloud.functions.v1.ListFunctionsResponse(this);
      int from_bitField0_ = bitField0_;
      if (functionsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          functions_ = java.util.Collections.unmodifiableList(functions_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.functions_ = functions_;
      } else {
        result.functions_ = functionsBuilder_.build();
      }
      result.nextPageToken_ = nextPageToken_;
      if (((bitField0_ & 0x00000002) != 0)) {
        unreachable_ = unreachable_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000002);
      }
      result.unreachable_ = unreachable_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.functions.v1.ListFunctionsResponse) {
        return mergeFrom((com.google.cloud.functions.v1.ListFunctionsResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.functions.v1.ListFunctionsResponse other) {
      if (other == com.google.cloud.functions.v1.ListFunctionsResponse.getDefaultInstance())
        return this;
      if (functionsBuilder_ == null) {
        if (!other.functions_.isEmpty()) {
          if (functions_.isEmpty()) {
            functions_ = other.functions_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureFunctionsIsMutable();
            functions_.addAll(other.functions_);
          }
          onChanged();
        }
      } else {
        if (!other.functions_.isEmpty()) {
          if (functionsBuilder_.isEmpty()) {
            functionsBuilder_.dispose();
            functionsBuilder_ = null;
            functions_ = other.functions_;
            bitField0_ = (bitField0_ & ~0x00000001);
            functionsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getFunctionsFieldBuilder()
                    : null;
          } else {
            functionsBuilder_.addAllMessages(other.functions_);
          }
        }
      }
      if (!other.getNextPageToken().isEmpty()) {
        nextPageToken_ = other.nextPageToken_;
        onChanged();
      }
      if (!other.unreachable_.isEmpty()) {
        if (unreachable_.isEmpty()) {
          unreachable_ = other.unreachable_;
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          ensureUnreachableIsMutable();
          unreachable_.addAll(other.unreachable_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.functions.v1.CloudFunction m =
                    input.readMessage(
                        com.google.cloud.functions.v1.CloudFunction.parser(), extensionRegistry);
                if (functionsBuilder_ == null) {
                  ensureFunctionsIsMutable();
                  functions_.add(m);
                } else {
                  functionsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                nextPageToken_ = input.readStringRequireUtf8();

                break;
              } // case 18
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureUnreachableIsMutable();
                unreachable_.add(s);
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.functions.v1.CloudFunction> functions_ =
        java.util.Collections.emptyList();

    private void ensureFunctionsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        functions_ =
            new java.util.ArrayList<com.google.cloud.functions.v1.CloudFunction>(functions_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.functions.v1.CloudFunction,
            com.google.cloud.functions.v1.CloudFunction.Builder,
            com.google.cloud.functions.v1.CloudFunctionOrBuilder>
        functionsBuilder_;

    /**
     *
     *
     * <pre>
     * The functions that match the request.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v1.CloudFunction functions = 1;</code>
     */
    public java.util.List<com.google.cloud.functions.v1.CloudFunction> getFunctionsList() {
      if (functionsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(functions_);
      } else {
        return functionsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The functions that match the request.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v1.CloudFunction functions = 1;</code>
     */
    public int getFunctionsCount() {
      if (functionsBuilder_ == null) {
        return functions_.size();
      } else {
        return functionsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The functions that match the request.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v1.CloudFunction functions = 1;</code>
     */
    public com.google.cloud.functions.v1.CloudFunction getFunctions(int index) {
      if (functionsBuilder_ == null) {
        return functions_.get(index);
      } else {
        return functionsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The functions that match the request.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v1.CloudFunction functions = 1;</code>
     */
    public Builder setFunctions(int index, com.google.cloud.functions.v1.CloudFunction value) {
      if (functionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFunctionsIsMutable();
        functions_.set(index, value);
        onChanged();
      } else {
        functionsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The functions that match the request.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v1.CloudFunction functions = 1;</code>
     */
    public Builder setFunctions(
        int index, com.google.cloud.functions.v1.CloudFunction.Builder builderForValue) {
      if (functionsBuilder_ == null) {
        ensureFunctionsIsMutable();
        functions_.set(index, builderForValue.build());
        onChanged();
      } else {
        functionsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The functions that match the request.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v1.CloudFunction functions = 1;</code>
     */
    public Builder addFunctions(com.google.cloud.functions.v1.CloudFunction value) {
      if (functionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFunctionsIsMutable();
        functions_.add(value);
        onChanged();
      } else {
        functionsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The functions that match the request.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v1.CloudFunction functions = 1;</code>
     */
    public Builder addFunctions(int index, com.google.cloud.functions.v1.CloudFunction value) {
      if (functionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFunctionsIsMutable();
        functions_.add(index, value);
        onChanged();
      } else {
        functionsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The functions that match the request.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v1.CloudFunction functions = 1;</code>
     */
    public Builder addFunctions(
        com.google.cloud.functions.v1.CloudFunction.Builder builderForValue) {
      if (functionsBuilder_ == null) {
        ensureFunctionsIsMutable();
        functions_.add(builderForValue.build());
        onChanged();
      } else {
        functionsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The functions that match the request.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v1.CloudFunction functions = 1;</code>
     */
    public Builder addFunctions(
        int index, com.google.cloud.functions.v1.CloudFunction.Builder builderForValue) {
      if (functionsBuilder_ == null) {
        ensureFunctionsIsMutable();
        functions_.add(index, builderForValue.build());
        onChanged();
      } else {
        functionsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The functions that match the request.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v1.CloudFunction functions = 1;</code>
     */
    public Builder addAllFunctions(
        java.lang.Iterable<? extends com.google.cloud.functions.v1.CloudFunction> values) {
      if (functionsBuilder_ == null) {
        ensureFunctionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, functions_);
        onChanged();
      } else {
        functionsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The functions that match the request.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v1.CloudFunction functions = 1;</code>
     */
    public Builder clearFunctions() {
      if (functionsBuilder_ == null) {
        functions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        functionsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The functions that match the request.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v1.CloudFunction functions = 1;</code>
     */
    public Builder removeFunctions(int index) {
      if (functionsBuilder_ == null) {
        ensureFunctionsIsMutable();
        functions_.remove(index);
        onChanged();
      } else {
        functionsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The functions that match the request.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v1.CloudFunction functions = 1;</code>
     */
    public com.google.cloud.functions.v1.CloudFunction.Builder getFunctionsBuilder(int index) {
      return getFunctionsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The functions that match the request.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v1.CloudFunction functions = 1;</code>
     */
    public com.google.cloud.functions.v1.CloudFunctionOrBuilder getFunctionsOrBuilder(int index) {
      if (functionsBuilder_ == null) {
        return functions_.get(index);
      } else {
        return functionsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The functions that match the request.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v1.CloudFunction functions = 1;</code>
     */
    public java.util.List<? extends com.google.cloud.functions.v1.CloudFunctionOrBuilder>
        getFunctionsOrBuilderList() {
      if (functionsBuilder_ != null) {
        return functionsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(functions_);
      }
    }
    /**
     *
     *
     * <pre>
     * The functions that match the request.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v1.CloudFunction functions = 1;</code>
     */
    public com.google.cloud.functions.v1.CloudFunction.Builder addFunctionsBuilder() {
      return getFunctionsFieldBuilder()
          .addBuilder(com.google.cloud.functions.v1.CloudFunction.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The functions that match the request.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v1.CloudFunction functions = 1;</code>
     */
    public com.google.cloud.functions.v1.CloudFunction.Builder addFunctionsBuilder(int index) {
      return getFunctionsFieldBuilder()
          .addBuilder(index, com.google.cloud.functions.v1.CloudFunction.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The functions that match the request.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v1.CloudFunction functions = 1;</code>
     */
    public java.util.List<com.google.cloud.functions.v1.CloudFunction.Builder>
        getFunctionsBuilderList() {
      return getFunctionsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.functions.v1.CloudFunction,
            com.google.cloud.functions.v1.CloudFunction.Builder,
            com.google.cloud.functions.v1.CloudFunctionOrBuilder>
        getFunctionsFieldBuilder() {
      if (functionsBuilder_ == null) {
        functionsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.functions.v1.CloudFunction,
                com.google.cloud.functions.v1.CloudFunction.Builder,
                com.google.cloud.functions.v1.CloudFunctionOrBuilder>(
                functions_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        functions_ = null;
      }
      return functionsBuilder_;
    }

    private java.lang.Object nextPageToken_ = "";
    /**
     *
     *
     * <pre>
     * If not empty, indicates that there may be more functions that match
     * the request; this value should be passed in a new
     * [google.cloud.functions.v1.ListFunctionsRequest][google.cloud.functions.v1.ListFunctionsRequest]
     * to get more functions.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return The nextPageToken.
     */
    public java.lang.String getNextPageToken() {
      java.lang.Object ref = nextPageToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        nextPageToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If not empty, indicates that there may be more functions that match
     * the request; this value should be passed in a new
     * [google.cloud.functions.v1.ListFunctionsRequest][google.cloud.functions.v1.ListFunctionsRequest]
     * to get more functions.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return The bytes for nextPageToken.
     */
    public com.google.protobuf.ByteString getNextPageTokenBytes() {
      java.lang.Object ref = nextPageToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        nextPageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If not empty, indicates that there may be more functions that match
     * the request; this value should be passed in a new
     * [google.cloud.functions.v1.ListFunctionsRequest][google.cloud.functions.v1.ListFunctionsRequest]
     * to get more functions.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @param value The nextPageToken to set.
     * @return This builder for chaining.
     */
    public Builder setNextPageToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      nextPageToken_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If not empty, indicates that there may be more functions that match
     * the request; this value should be passed in a new
     * [google.cloud.functions.v1.ListFunctionsRequest][google.cloud.functions.v1.ListFunctionsRequest]
     * to get more functions.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNextPageToken() {

      nextPageToken_ = getDefaultInstance().getNextPageToken();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If not empty, indicates that there may be more functions that match
     * the request; this value should be passed in a new
     * [google.cloud.functions.v1.ListFunctionsRequest][google.cloud.functions.v1.ListFunctionsRequest]
     * to get more functions.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @param value The bytes for nextPageToken to set.
     * @return This builder for chaining.
     */
    public Builder setNextPageTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      nextPageToken_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList unreachable_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureUnreachableIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        unreachable_ = new com.google.protobuf.LazyStringArrayList(unreachable_);
        bitField0_ |= 0x00000002;
      }
    }
    /**
     *
     *
     * <pre>
     * Locations that could not be reached. The response does not include any
     * functions from these locations.
     * </pre>
     *
     * <code>repeated string unreachable = 3;</code>
     *
     * @return A list containing the unreachable.
     */
    public com.google.protobuf.ProtocolStringList getUnreachableList() {
      return unreachable_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * Locations that could not be reached. The response does not include any
     * functions from these locations.
     * </pre>
     *
     * <code>repeated string unreachable = 3;</code>
     *
     * @return The count of unreachable.
     */
    public int getUnreachableCount() {
      return unreachable_.size();
    }
    /**
     *
     *
     * <pre>
     * Locations that could not be reached. The response does not include any
     * functions from these locations.
     * </pre>
     *
     * <code>repeated string unreachable = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The unreachable at the given index.
     */
    public java.lang.String getUnreachable(int index) {
      return unreachable_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Locations that could not be reached. The response does not include any
     * functions from these locations.
     * </pre>
     *
     * <code>repeated string unreachable = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the unreachable at the given index.
     */
    public com.google.protobuf.ByteString getUnreachableBytes(int index) {
      return unreachable_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Locations that could not be reached. The response does not include any
     * functions from these locations.
     * </pre>
     *
     * <code>repeated string unreachable = 3;</code>
     *
     * @param index The index to set the value at.
     * @param value The unreachable to set.
     * @return This builder for chaining.
     */
    public Builder setUnreachable(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureUnreachableIsMutable();
      unreachable_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Locations that could not be reached. The response does not include any
     * functions from these locations.
     * </pre>
     *
     * <code>repeated string unreachable = 3;</code>
     *
     * @param value The unreachable to add.
     * @return This builder for chaining.
     */
    public Builder addUnreachable(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureUnreachableIsMutable();
      unreachable_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Locations that could not be reached. The response does not include any
     * functions from these locations.
     * </pre>
     *
     * <code>repeated string unreachable = 3;</code>
     *
     * @param values The unreachable to add.
     * @return This builder for chaining.
     */
    public Builder addAllUnreachable(java.lang.Iterable<java.lang.String> values) {
      ensureUnreachableIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, unreachable_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Locations that could not be reached. The response does not include any
     * functions from these locations.
     * </pre>
     *
     * <code>repeated string unreachable = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUnreachable() {
      unreachable_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Locations that could not be reached. The response does not include any
     * functions from these locations.
     * </pre>
     *
     * <code>repeated string unreachable = 3;</code>
     *
     * @param value The bytes of the unreachable to add.
     * @return This builder for chaining.
     */
    public Builder addUnreachableBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureUnreachableIsMutable();
      unreachable_.add(value);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.functions.v1.ListFunctionsResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.functions.v1.ListFunctionsResponse)
  private static final com.google.cloud.functions.v1.ListFunctionsResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.functions.v1.ListFunctionsResponse();
  }

  public static com.google.cloud.functions.v1.ListFunctionsResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ListFunctionsResponse> PARSER =
      new com.google.protobuf.AbstractParser<ListFunctionsResponse>() {
        @java.lang.Override
        public ListFunctionsResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ListFunctionsResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ListFunctionsResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.functions.v1.ListFunctionsResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
