/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/functions/v1/functions.proto

package com.google.cloud.functions.v1;

/**
 *
 *
 * <pre>
 * Describes EventTrigger, used to request that events be sent from another
 * service.
 * </pre>
 *
 * Protobuf type {@code google.cloud.functions.v1.EventTrigger}
 */
public final class EventTrigger extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.functions.v1.EventTrigger)
    EventTriggerOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use EventTrigger.newBuilder() to construct.
  private EventTrigger(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private EventTrigger() {
    eventType_ = "";
    resource_ = "";
    service_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new EventTrigger();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.functions.v1.FunctionsProto
        .internal_static_google_cloud_functions_v1_EventTrigger_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.functions.v1.FunctionsProto
        .internal_static_google_cloud_functions_v1_EventTrigger_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.functions.v1.EventTrigger.class,
            com.google.cloud.functions.v1.EventTrigger.Builder.class);
  }

  public static final int EVENT_TYPE_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object eventType_ = "";
  /**
   *
   *
   * <pre>
   * Required. The type of event to observe. For example:
   * `providers/cloud.storage/eventTypes/object.change` and
   * `providers/cloud.pubsub/eventTypes/topic.publish`.
   *
   * Event types match pattern `providers/&#42;&#47;eventTypes/&#42;.*`.
   * The pattern contains:
   *
   * 1. namespace: For example, `cloud.storage` and
   *    `google.firebase.analytics`.
   * 2. resource type: The type of resource on which event occurs. For
   *    example, the Google Cloud Storage API includes the type `object`.
   * 3. action: The action that generates the event. For example, action for
   *    a Google Cloud Storage Object is 'change'.
   * These parts are lowercase.
   * </pre>
   *
   * <code>string event_type = 1;</code>
   *
   * @return The eventType.
   */
  @java.lang.Override
  public java.lang.String getEventType() {
    java.lang.Object ref = eventType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      eventType_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The type of event to observe. For example:
   * `providers/cloud.storage/eventTypes/object.change` and
   * `providers/cloud.pubsub/eventTypes/topic.publish`.
   *
   * Event types match pattern `providers/&#42;&#47;eventTypes/&#42;.*`.
   * The pattern contains:
   *
   * 1. namespace: For example, `cloud.storage` and
   *    `google.firebase.analytics`.
   * 2. resource type: The type of resource on which event occurs. For
   *    example, the Google Cloud Storage API includes the type `object`.
   * 3. action: The action that generates the event. For example, action for
   *    a Google Cloud Storage Object is 'change'.
   * These parts are lowercase.
   * </pre>
   *
   * <code>string event_type = 1;</code>
   *
   * @return The bytes for eventType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEventTypeBytes() {
    java.lang.Object ref = eventType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      eventType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RESOURCE_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object resource_ = "";
  /**
   *
   *
   * <pre>
   * Required. The resource(s) from which to observe events, for example,
   * `projects/_/buckets/myBucket`.
   *
   * Not all syntactically correct values are accepted by all services. For
   * example:
   *
   * 1. The authorization model must support it. Google Cloud Functions
   *    only allows EventTriggers to be deployed that observe resources in the
   *    same project as the `CloudFunction`.
   * 2. The resource type must match the pattern expected for an
   *    `event_type`. For example, an `EventTrigger` that has an
   *    `event_type` of "google.pubsub.topic.publish" should have a resource
   *    that matches Google Cloud Pub/Sub topics.
   *
   * Additionally, some services may support short names when creating an
   * `EventTrigger`. These are always returned in the normalized "long"
   * format.
   *
   * See each *service's* documentation for supported formats.
   * </pre>
   *
   * <code>string resource = 2;</code>
   *
   * @return The resource.
   */
  @java.lang.Override
  public java.lang.String getResource() {
    java.lang.Object ref = resource_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      resource_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The resource(s) from which to observe events, for example,
   * `projects/_/buckets/myBucket`.
   *
   * Not all syntactically correct values are accepted by all services. For
   * example:
   *
   * 1. The authorization model must support it. Google Cloud Functions
   *    only allows EventTriggers to be deployed that observe resources in the
   *    same project as the `CloudFunction`.
   * 2. The resource type must match the pattern expected for an
   *    `event_type`. For example, an `EventTrigger` that has an
   *    `event_type` of "google.pubsub.topic.publish" should have a resource
   *    that matches Google Cloud Pub/Sub topics.
   *
   * Additionally, some services may support short names when creating an
   * `EventTrigger`. These are always returned in the normalized "long"
   * format.
   *
   * See each *service's* documentation for supported formats.
   * </pre>
   *
   * <code>string resource = 2;</code>
   *
   * @return The bytes for resource.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getResourceBytes() {
    java.lang.Object ref = resource_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      resource_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SERVICE_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object service_ = "";
  /**
   *
   *
   * <pre>
   * The hostname of the service that should be observed.
   *
   * If no string is provided, the default service implementing the API will
   * be used. For example, `storage.googleapis.com` is the default for all
   * event types in the `google.storage` namespace.
   * </pre>
   *
   * <code>string service = 3;</code>
   *
   * @return The service.
   */
  @java.lang.Override
  public java.lang.String getService() {
    java.lang.Object ref = service_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      service_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The hostname of the service that should be observed.
   *
   * If no string is provided, the default service implementing the API will
   * be used. For example, `storage.googleapis.com` is the default for all
   * event types in the `google.storage` namespace.
   * </pre>
   *
   * <code>string service = 3;</code>
   *
   * @return The bytes for service.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServiceBytes() {
    java.lang.Object ref = service_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      service_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FAILURE_POLICY_FIELD_NUMBER = 5;
  private com.google.cloud.functions.v1.FailurePolicy failurePolicy_;
  /**
   *
   *
   * <pre>
   * Specifies policy for failed executions.
   * </pre>
   *
   * <code>.google.cloud.functions.v1.FailurePolicy failure_policy = 5;</code>
   *
   * @return Whether the failurePolicy field is set.
   */
  @java.lang.Override
  public boolean hasFailurePolicy() {
    return failurePolicy_ != null;
  }
  /**
   *
   *
   * <pre>
   * Specifies policy for failed executions.
   * </pre>
   *
   * <code>.google.cloud.functions.v1.FailurePolicy failure_policy = 5;</code>
   *
   * @return The failurePolicy.
   */
  @java.lang.Override
  public com.google.cloud.functions.v1.FailurePolicy getFailurePolicy() {
    return failurePolicy_ == null
        ? com.google.cloud.functions.v1.FailurePolicy.getDefaultInstance()
        : failurePolicy_;
  }
  /**
   *
   *
   * <pre>
   * Specifies policy for failed executions.
   * </pre>
   *
   * <code>.google.cloud.functions.v1.FailurePolicy failure_policy = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.functions.v1.FailurePolicyOrBuilder getFailurePolicyOrBuilder() {
    return failurePolicy_ == null
        ? com.google.cloud.functions.v1.FailurePolicy.getDefaultInstance()
        : failurePolicy_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(eventType_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, eventType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resource_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, resource_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(service_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, service_);
    }
    if (failurePolicy_ != null) {
      output.writeMessage(5, getFailurePolicy());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(eventType_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, eventType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resource_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, resource_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(service_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, service_);
    }
    if (failurePolicy_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getFailurePolicy());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.functions.v1.EventTrigger)) {
      return super.equals(obj);
    }
    com.google.cloud.functions.v1.EventTrigger other =
        (com.google.cloud.functions.v1.EventTrigger) obj;

    if (!getEventType().equals(other.getEventType())) return false;
    if (!getResource().equals(other.getResource())) return false;
    if (!getService().equals(other.getService())) return false;
    if (hasFailurePolicy() != other.hasFailurePolicy()) return false;
    if (hasFailurePolicy()) {
      if (!getFailurePolicy().equals(other.getFailurePolicy())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + EVENT_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getEventType().hashCode();
    hash = (37 * hash) + RESOURCE_FIELD_NUMBER;
    hash = (53 * hash) + getResource().hashCode();
    hash = (37 * hash) + SERVICE_FIELD_NUMBER;
    hash = (53 * hash) + getService().hashCode();
    if (hasFailurePolicy()) {
      hash = (37 * hash) + FAILURE_POLICY_FIELD_NUMBER;
      hash = (53 * hash) + getFailurePolicy().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.functions.v1.EventTrigger parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.functions.v1.EventTrigger parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.functions.v1.EventTrigger parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.functions.v1.EventTrigger parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.functions.v1.EventTrigger parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.functions.v1.EventTrigger parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.functions.v1.EventTrigger parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.functions.v1.EventTrigger parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.functions.v1.EventTrigger parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.functions.v1.EventTrigger parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.functions.v1.EventTrigger parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.functions.v1.EventTrigger parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.functions.v1.EventTrigger prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Describes EventTrigger, used to request that events be sent from another
   * service.
   * </pre>
   *
   * Protobuf type {@code google.cloud.functions.v1.EventTrigger}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.functions.v1.EventTrigger)
      com.google.cloud.functions.v1.EventTriggerOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.functions.v1.FunctionsProto
          .internal_static_google_cloud_functions_v1_EventTrigger_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.functions.v1.FunctionsProto
          .internal_static_google_cloud_functions_v1_EventTrigger_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.functions.v1.EventTrigger.class,
              com.google.cloud.functions.v1.EventTrigger.Builder.class);
    }

    // Construct using com.google.cloud.functions.v1.EventTrigger.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      eventType_ = "";
      resource_ = "";
      service_ = "";
      failurePolicy_ = null;
      if (failurePolicyBuilder_ != null) {
        failurePolicyBuilder_.dispose();
        failurePolicyBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.functions.v1.FunctionsProto
          .internal_static_google_cloud_functions_v1_EventTrigger_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.functions.v1.EventTrigger getDefaultInstanceForType() {
      return com.google.cloud.functions.v1.EventTrigger.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.functions.v1.EventTrigger build() {
      com.google.cloud.functions.v1.EventTrigger result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.functions.v1.EventTrigger buildPartial() {
      com.google.cloud.functions.v1.EventTrigger result =
          new com.google.cloud.functions.v1.EventTrigger(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.functions.v1.EventTrigger result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.eventType_ = eventType_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.resource_ = resource_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.service_ = service_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.failurePolicy_ =
            failurePolicyBuilder_ == null ? failurePolicy_ : failurePolicyBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.functions.v1.EventTrigger) {
        return mergeFrom((com.google.cloud.functions.v1.EventTrigger) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.functions.v1.EventTrigger other) {
      if (other == com.google.cloud.functions.v1.EventTrigger.getDefaultInstance()) return this;
      if (!other.getEventType().isEmpty()) {
        eventType_ = other.eventType_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getResource().isEmpty()) {
        resource_ = other.resource_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getService().isEmpty()) {
        service_ = other.service_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasFailurePolicy()) {
        mergeFailurePolicy(other.getFailurePolicy());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                eventType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                resource_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                service_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 42:
              {
                input.readMessage(getFailurePolicyFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object eventType_ = "";
    /**
     *
     *
     * <pre>
     * Required. The type of event to observe. For example:
     * `providers/cloud.storage/eventTypes/object.change` and
     * `providers/cloud.pubsub/eventTypes/topic.publish`.
     *
     * Event types match pattern `providers/&#42;&#47;eventTypes/&#42;.*`.
     * The pattern contains:
     *
     * 1. namespace: For example, `cloud.storage` and
     *    `google.firebase.analytics`.
     * 2. resource type: The type of resource on which event occurs. For
     *    example, the Google Cloud Storage API includes the type `object`.
     * 3. action: The action that generates the event. For example, action for
     *    a Google Cloud Storage Object is 'change'.
     * These parts are lowercase.
     * </pre>
     *
     * <code>string event_type = 1;</code>
     *
     * @return The eventType.
     */
    public java.lang.String getEventType() {
      java.lang.Object ref = eventType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        eventType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The type of event to observe. For example:
     * `providers/cloud.storage/eventTypes/object.change` and
     * `providers/cloud.pubsub/eventTypes/topic.publish`.
     *
     * Event types match pattern `providers/&#42;&#47;eventTypes/&#42;.*`.
     * The pattern contains:
     *
     * 1. namespace: For example, `cloud.storage` and
     *    `google.firebase.analytics`.
     * 2. resource type: The type of resource on which event occurs. For
     *    example, the Google Cloud Storage API includes the type `object`.
     * 3. action: The action that generates the event. For example, action for
     *    a Google Cloud Storage Object is 'change'.
     * These parts are lowercase.
     * </pre>
     *
     * <code>string event_type = 1;</code>
     *
     * @return The bytes for eventType.
     */
    public com.google.protobuf.ByteString getEventTypeBytes() {
      java.lang.Object ref = eventType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        eventType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The type of event to observe. For example:
     * `providers/cloud.storage/eventTypes/object.change` and
     * `providers/cloud.pubsub/eventTypes/topic.publish`.
     *
     * Event types match pattern `providers/&#42;&#47;eventTypes/&#42;.*`.
     * The pattern contains:
     *
     * 1. namespace: For example, `cloud.storage` and
     *    `google.firebase.analytics`.
     * 2. resource type: The type of resource on which event occurs. For
     *    example, the Google Cloud Storage API includes the type `object`.
     * 3. action: The action that generates the event. For example, action for
     *    a Google Cloud Storage Object is 'change'.
     * These parts are lowercase.
     * </pre>
     *
     * <code>string event_type = 1;</code>
     *
     * @param value The eventType to set.
     * @return This builder for chaining.
     */
    public Builder setEventType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      eventType_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The type of event to observe. For example:
     * `providers/cloud.storage/eventTypes/object.change` and
     * `providers/cloud.pubsub/eventTypes/topic.publish`.
     *
     * Event types match pattern `providers/&#42;&#47;eventTypes/&#42;.*`.
     * The pattern contains:
     *
     * 1. namespace: For example, `cloud.storage` and
     *    `google.firebase.analytics`.
     * 2. resource type: The type of resource on which event occurs. For
     *    example, the Google Cloud Storage API includes the type `object`.
     * 3. action: The action that generates the event. For example, action for
     *    a Google Cloud Storage Object is 'change'.
     * These parts are lowercase.
     * </pre>
     *
     * <code>string event_type = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEventType() {
      eventType_ = getDefaultInstance().getEventType();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The type of event to observe. For example:
     * `providers/cloud.storage/eventTypes/object.change` and
     * `providers/cloud.pubsub/eventTypes/topic.publish`.
     *
     * Event types match pattern `providers/&#42;&#47;eventTypes/&#42;.*`.
     * The pattern contains:
     *
     * 1. namespace: For example, `cloud.storage` and
     *    `google.firebase.analytics`.
     * 2. resource type: The type of resource on which event occurs. For
     *    example, the Google Cloud Storage API includes the type `object`.
     * 3. action: The action that generates the event. For example, action for
     *    a Google Cloud Storage Object is 'change'.
     * These parts are lowercase.
     * </pre>
     *
     * <code>string event_type = 1;</code>
     *
     * @param value The bytes for eventType to set.
     * @return This builder for chaining.
     */
    public Builder setEventTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      eventType_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object resource_ = "";
    /**
     *
     *
     * <pre>
     * Required. The resource(s) from which to observe events, for example,
     * `projects/_/buckets/myBucket`.
     *
     * Not all syntactically correct values are accepted by all services. For
     * example:
     *
     * 1. The authorization model must support it. Google Cloud Functions
     *    only allows EventTriggers to be deployed that observe resources in the
     *    same project as the `CloudFunction`.
     * 2. The resource type must match the pattern expected for an
     *    `event_type`. For example, an `EventTrigger` that has an
     *    `event_type` of "google.pubsub.topic.publish" should have a resource
     *    that matches Google Cloud Pub/Sub topics.
     *
     * Additionally, some services may support short names when creating an
     * `EventTrigger`. These are always returned in the normalized "long"
     * format.
     *
     * See each *service's* documentation for supported formats.
     * </pre>
     *
     * <code>string resource = 2;</code>
     *
     * @return The resource.
     */
    public java.lang.String getResource() {
      java.lang.Object ref = resource_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        resource_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource(s) from which to observe events, for example,
     * `projects/_/buckets/myBucket`.
     *
     * Not all syntactically correct values are accepted by all services. For
     * example:
     *
     * 1. The authorization model must support it. Google Cloud Functions
     *    only allows EventTriggers to be deployed that observe resources in the
     *    same project as the `CloudFunction`.
     * 2. The resource type must match the pattern expected for an
     *    `event_type`. For example, an `EventTrigger` that has an
     *    `event_type` of "google.pubsub.topic.publish" should have a resource
     *    that matches Google Cloud Pub/Sub topics.
     *
     * Additionally, some services may support short names when creating an
     * `EventTrigger`. These are always returned in the normalized "long"
     * format.
     *
     * See each *service's* documentation for supported formats.
     * </pre>
     *
     * <code>string resource = 2;</code>
     *
     * @return The bytes for resource.
     */
    public com.google.protobuf.ByteString getResourceBytes() {
      java.lang.Object ref = resource_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        resource_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource(s) from which to observe events, for example,
     * `projects/_/buckets/myBucket`.
     *
     * Not all syntactically correct values are accepted by all services. For
     * example:
     *
     * 1. The authorization model must support it. Google Cloud Functions
     *    only allows EventTriggers to be deployed that observe resources in the
     *    same project as the `CloudFunction`.
     * 2. The resource type must match the pattern expected for an
     *    `event_type`. For example, an `EventTrigger` that has an
     *    `event_type` of "google.pubsub.topic.publish" should have a resource
     *    that matches Google Cloud Pub/Sub topics.
     *
     * Additionally, some services may support short names when creating an
     * `EventTrigger`. These are always returned in the normalized "long"
     * format.
     *
     * See each *service's* documentation for supported formats.
     * </pre>
     *
     * <code>string resource = 2;</code>
     *
     * @param value The resource to set.
     * @return This builder for chaining.
     */
    public Builder setResource(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      resource_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource(s) from which to observe events, for example,
     * `projects/_/buckets/myBucket`.
     *
     * Not all syntactically correct values are accepted by all services. For
     * example:
     *
     * 1. The authorization model must support it. Google Cloud Functions
     *    only allows EventTriggers to be deployed that observe resources in the
     *    same project as the `CloudFunction`.
     * 2. The resource type must match the pattern expected for an
     *    `event_type`. For example, an `EventTrigger` that has an
     *    `event_type` of "google.pubsub.topic.publish" should have a resource
     *    that matches Google Cloud Pub/Sub topics.
     *
     * Additionally, some services may support short names when creating an
     * `EventTrigger`. These are always returned in the normalized "long"
     * format.
     *
     * See each *service's* documentation for supported formats.
     * </pre>
     *
     * <code>string resource = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearResource() {
      resource_ = getDefaultInstance().getResource();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource(s) from which to observe events, for example,
     * `projects/_/buckets/myBucket`.
     *
     * Not all syntactically correct values are accepted by all services. For
     * example:
     *
     * 1. The authorization model must support it. Google Cloud Functions
     *    only allows EventTriggers to be deployed that observe resources in the
     *    same project as the `CloudFunction`.
     * 2. The resource type must match the pattern expected for an
     *    `event_type`. For example, an `EventTrigger` that has an
     *    `event_type` of "google.pubsub.topic.publish" should have a resource
     *    that matches Google Cloud Pub/Sub topics.
     *
     * Additionally, some services may support short names when creating an
     * `EventTrigger`. These are always returned in the normalized "long"
     * format.
     *
     * See each *service's* documentation for supported formats.
     * </pre>
     *
     * <code>string resource = 2;</code>
     *
     * @param value The bytes for resource to set.
     * @return This builder for chaining.
     */
    public Builder setResourceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      resource_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object service_ = "";
    /**
     *
     *
     * <pre>
     * The hostname of the service that should be observed.
     *
     * If no string is provided, the default service implementing the API will
     * be used. For example, `storage.googleapis.com` is the default for all
     * event types in the `google.storage` namespace.
     * </pre>
     *
     * <code>string service = 3;</code>
     *
     * @return The service.
     */
    public java.lang.String getService() {
      java.lang.Object ref = service_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        service_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The hostname of the service that should be observed.
     *
     * If no string is provided, the default service implementing the API will
     * be used. For example, `storage.googleapis.com` is the default for all
     * event types in the `google.storage` namespace.
     * </pre>
     *
     * <code>string service = 3;</code>
     *
     * @return The bytes for service.
     */
    public com.google.protobuf.ByteString getServiceBytes() {
      java.lang.Object ref = service_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        service_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The hostname of the service that should be observed.
     *
     * If no string is provided, the default service implementing the API will
     * be used. For example, `storage.googleapis.com` is the default for all
     * event types in the `google.storage` namespace.
     * </pre>
     *
     * <code>string service = 3;</code>
     *
     * @param value The service to set.
     * @return This builder for chaining.
     */
    public Builder setService(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      service_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The hostname of the service that should be observed.
     *
     * If no string is provided, the default service implementing the API will
     * be used. For example, `storage.googleapis.com` is the default for all
     * event types in the `google.storage` namespace.
     * </pre>
     *
     * <code>string service = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearService() {
      service_ = getDefaultInstance().getService();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The hostname of the service that should be observed.
     *
     * If no string is provided, the default service implementing the API will
     * be used. For example, `storage.googleapis.com` is the default for all
     * event types in the `google.storage` namespace.
     * </pre>
     *
     * <code>string service = 3;</code>
     *
     * @param value The bytes for service to set.
     * @return This builder for chaining.
     */
    public Builder setServiceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      service_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.cloud.functions.v1.FailurePolicy failurePolicy_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.functions.v1.FailurePolicy,
            com.google.cloud.functions.v1.FailurePolicy.Builder,
            com.google.cloud.functions.v1.FailurePolicyOrBuilder>
        failurePolicyBuilder_;
    /**
     *
     *
     * <pre>
     * Specifies policy for failed executions.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.FailurePolicy failure_policy = 5;</code>
     *
     * @return Whether the failurePolicy field is set.
     */
    public boolean hasFailurePolicy() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Specifies policy for failed executions.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.FailurePolicy failure_policy = 5;</code>
     *
     * @return The failurePolicy.
     */
    public com.google.cloud.functions.v1.FailurePolicy getFailurePolicy() {
      if (failurePolicyBuilder_ == null) {
        return failurePolicy_ == null
            ? com.google.cloud.functions.v1.FailurePolicy.getDefaultInstance()
            : failurePolicy_;
      } else {
        return failurePolicyBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies policy for failed executions.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.FailurePolicy failure_policy = 5;</code>
     */
    public Builder setFailurePolicy(com.google.cloud.functions.v1.FailurePolicy value) {
      if (failurePolicyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        failurePolicy_ = value;
      } else {
        failurePolicyBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies policy for failed executions.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.FailurePolicy failure_policy = 5;</code>
     */
    public Builder setFailurePolicy(
        com.google.cloud.functions.v1.FailurePolicy.Builder builderForValue) {
      if (failurePolicyBuilder_ == null) {
        failurePolicy_ = builderForValue.build();
      } else {
        failurePolicyBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies policy for failed executions.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.FailurePolicy failure_policy = 5;</code>
     */
    public Builder mergeFailurePolicy(com.google.cloud.functions.v1.FailurePolicy value) {
      if (failurePolicyBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && failurePolicy_ != null
            && failurePolicy_ != com.google.cloud.functions.v1.FailurePolicy.getDefaultInstance()) {
          getFailurePolicyBuilder().mergeFrom(value);
        } else {
          failurePolicy_ = value;
        }
      } else {
        failurePolicyBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies policy for failed executions.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.FailurePolicy failure_policy = 5;</code>
     */
    public Builder clearFailurePolicy() {
      bitField0_ = (bitField0_ & ~0x00000008);
      failurePolicy_ = null;
      if (failurePolicyBuilder_ != null) {
        failurePolicyBuilder_.dispose();
        failurePolicyBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies policy for failed executions.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.FailurePolicy failure_policy = 5;</code>
     */
    public com.google.cloud.functions.v1.FailurePolicy.Builder getFailurePolicyBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getFailurePolicyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Specifies policy for failed executions.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.FailurePolicy failure_policy = 5;</code>
     */
    public com.google.cloud.functions.v1.FailurePolicyOrBuilder getFailurePolicyOrBuilder() {
      if (failurePolicyBuilder_ != null) {
        return failurePolicyBuilder_.getMessageOrBuilder();
      } else {
        return failurePolicy_ == null
            ? com.google.cloud.functions.v1.FailurePolicy.getDefaultInstance()
            : failurePolicy_;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies policy for failed executions.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.FailurePolicy failure_policy = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.functions.v1.FailurePolicy,
            com.google.cloud.functions.v1.FailurePolicy.Builder,
            com.google.cloud.functions.v1.FailurePolicyOrBuilder>
        getFailurePolicyFieldBuilder() {
      if (failurePolicyBuilder_ == null) {
        failurePolicyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.functions.v1.FailurePolicy,
                com.google.cloud.functions.v1.FailurePolicy.Builder,
                com.google.cloud.functions.v1.FailurePolicyOrBuilder>(
                getFailurePolicy(), getParentForChildren(), isClean());
        failurePolicy_ = null;
      }
      return failurePolicyBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.functions.v1.EventTrigger)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.functions.v1.EventTrigger)
  private static final com.google.cloud.functions.v1.EventTrigger DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.functions.v1.EventTrigger();
  }

  public static com.google.cloud.functions.v1.EventTrigger getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<EventTrigger> PARSER =
      new com.google.protobuf.AbstractParser<EventTrigger>() {
        @java.lang.Override
        public EventTrigger parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<EventTrigger> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<EventTrigger> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.functions.v1.EventTrigger getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
