/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/functions/v2alpha/functions.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.functions.v2alpha;

/**
 *
 *
 * <pre>
 * Response for the `ListRuntimes` method.
 * </pre>
 *
 * Protobuf type {@code google.cloud.functions.v2alpha.ListRuntimesResponse}
 */
public final class ListRuntimesResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.functions.v2alpha.ListRuntimesResponse)
    ListRuntimesResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ListRuntimesResponse.newBuilder() to construct.
  private ListRuntimesResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ListRuntimesResponse() {
    runtimes_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ListRuntimesResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.functions.v2alpha.FunctionsProto
        .internal_static_google_cloud_functions_v2alpha_ListRuntimesResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.functions.v2alpha.FunctionsProto
        .internal_static_google_cloud_functions_v2alpha_ListRuntimesResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.functions.v2alpha.ListRuntimesResponse.class,
            com.google.cloud.functions.v2alpha.ListRuntimesResponse.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The various stages that a runtime can be in.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.functions.v2alpha.ListRuntimesResponse.RuntimeStage}
   */
  public enum RuntimeStage implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not specified.
     * </pre>
     *
     * <code>RUNTIME_STAGE_UNSPECIFIED = 0;</code>
     */
    RUNTIME_STAGE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The runtime is in development.
     * </pre>
     *
     * <code>DEVELOPMENT = 1;</code>
     */
    DEVELOPMENT(1),
    /**
     *
     *
     * <pre>
     * The runtime is in the Alpha stage.
     * </pre>
     *
     * <code>ALPHA = 2;</code>
     */
    ALPHA(2),
    /**
     *
     *
     * <pre>
     * The runtime is in the Beta stage.
     * </pre>
     *
     * <code>BETA = 3;</code>
     */
    BETA(3),
    /**
     *
     *
     * <pre>
     * The runtime is generally available.
     * </pre>
     *
     * <code>GA = 4;</code>
     */
    GA(4),
    /**
     *
     *
     * <pre>
     * The runtime is deprecated.
     * </pre>
     *
     * <code>DEPRECATED = 5;</code>
     */
    DEPRECATED(5),
    /**
     *
     *
     * <pre>
     * The runtime is no longer supported.
     * </pre>
     *
     * <code>DECOMMISSIONED = 6;</code>
     */
    DECOMMISSIONED(6),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not specified.
     * </pre>
     *
     * <code>RUNTIME_STAGE_UNSPECIFIED = 0;</code>
     */
    public static final int RUNTIME_STAGE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The runtime is in development.
     * </pre>
     *
     * <code>DEVELOPMENT = 1;</code>
     */
    public static final int DEVELOPMENT_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The runtime is in the Alpha stage.
     * </pre>
     *
     * <code>ALPHA = 2;</code>
     */
    public static final int ALPHA_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The runtime is in the Beta stage.
     * </pre>
     *
     * <code>BETA = 3;</code>
     */
    public static final int BETA_VALUE = 3;
    /**
     *
     *
     * <pre>
     * The runtime is generally available.
     * </pre>
     *
     * <code>GA = 4;</code>
     */
    public static final int GA_VALUE = 4;
    /**
     *
     *
     * <pre>
     * The runtime is deprecated.
     * </pre>
     *
     * <code>DEPRECATED = 5;</code>
     */
    public static final int DEPRECATED_VALUE = 5;
    /**
     *
     *
     * <pre>
     * The runtime is no longer supported.
     * </pre>
     *
     * <code>DECOMMISSIONED = 6;</code>
     */
    public static final int DECOMMISSIONED_VALUE = 6;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static RuntimeStage valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static RuntimeStage forNumber(int value) {
      switch (value) {
        case 0:
          return RUNTIME_STAGE_UNSPECIFIED;
        case 1:
          return DEVELOPMENT;
        case 2:
          return ALPHA;
        case 3:
          return BETA;
        case 4:
          return GA;
        case 5:
          return DEPRECATED;
        case 6:
          return DECOMMISSIONED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<RuntimeStage> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<RuntimeStage> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<RuntimeStage>() {
          public RuntimeStage findValueByNumber(int number) {
            return RuntimeStage.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.functions.v2alpha.ListRuntimesResponse.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final RuntimeStage[] VALUES = values();

    public static RuntimeStage valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private RuntimeStage(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.functions.v2alpha.ListRuntimesResponse.RuntimeStage)
  }

  public interface RuntimeOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The name of the runtime, e.g., 'go113', 'nodejs12', etc.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    java.lang.String getName();
    /**
     *
     *
     * <pre>
     * The name of the runtime, e.g., 'go113', 'nodejs12', etc.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString getNameBytes();

    /**
     *
     *
     * <pre>
     * The user facing name, eg 'Go 1.13', 'Node.js 12', etc.
     * </pre>
     *
     * <code>string display_name = 5;</code>
     *
     * @return The displayName.
     */
    java.lang.String getDisplayName();
    /**
     *
     *
     * <pre>
     * The user facing name, eg 'Go 1.13', 'Node.js 12', etc.
     * </pre>
     *
     * <code>string display_name = 5;</code>
     *
     * @return The bytes for displayName.
     */
    com.google.protobuf.ByteString getDisplayNameBytes();

    /**
     *
     *
     * <pre>
     * The stage of life this runtime is in, e.g., BETA, GA, etc.
     * </pre>
     *
     * <code>.google.cloud.functions.v2alpha.ListRuntimesResponse.RuntimeStage stage = 2;</code>
     *
     * @return The enum numeric value on the wire for stage.
     */
    int getStageValue();
    /**
     *
     *
     * <pre>
     * The stage of life this runtime is in, e.g., BETA, GA, etc.
     * </pre>
     *
     * <code>.google.cloud.functions.v2alpha.ListRuntimesResponse.RuntimeStage stage = 2;</code>
     *
     * @return The stage.
     */
    com.google.cloud.functions.v2alpha.ListRuntimesResponse.RuntimeStage getStage();

    /**
     *
     *
     * <pre>
     * Warning messages, e.g., a deprecation warning.
     * </pre>
     *
     * <code>repeated string warnings = 3;</code>
     *
     * @return A list containing the warnings.
     */
    java.util.List<java.lang.String> getWarningsList();
    /**
     *
     *
     * <pre>
     * Warning messages, e.g., a deprecation warning.
     * </pre>
     *
     * <code>repeated string warnings = 3;</code>
     *
     * @return The count of warnings.
     */
    int getWarningsCount();
    /**
     *
     *
     * <pre>
     * Warning messages, e.g., a deprecation warning.
     * </pre>
     *
     * <code>repeated string warnings = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The warnings at the given index.
     */
    java.lang.String getWarnings(int index);
    /**
     *
     *
     * <pre>
     * Warning messages, e.g., a deprecation warning.
     * </pre>
     *
     * <code>repeated string warnings = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the warnings at the given index.
     */
    com.google.protobuf.ByteString getWarningsBytes(int index);

    /**
     *
     *
     * <pre>
     * The environment for the runtime.
     * </pre>
     *
     * <code>.google.cloud.functions.v2alpha.Environment environment = 4;</code>
     *
     * @return The enum numeric value on the wire for environment.
     */
    int getEnvironmentValue();
    /**
     *
     *
     * <pre>
     * The environment for the runtime.
     * </pre>
     *
     * <code>.google.cloud.functions.v2alpha.Environment environment = 4;</code>
     *
     * @return The environment.
     */
    com.google.cloud.functions.v2alpha.Environment getEnvironment();
  }
  /**
   *
   *
   * <pre>
   * Describes a runtime and any special information (e.g., deprecation status)
   * related to it.
   * </pre>
   *
   * Protobuf type {@code google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime}
   */
  public static final class Runtime extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime)
      RuntimeOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Runtime.newBuilder() to construct.
    private Runtime(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Runtime() {
      name_ = "";
      displayName_ = "";
      stage_ = 0;
      warnings_ = com.google.protobuf.LazyStringArrayList.emptyList();
      environment_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Runtime();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.functions.v2alpha.FunctionsProto
          .internal_static_google_cloud_functions_v2alpha_ListRuntimesResponse_Runtime_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.functions.v2alpha.FunctionsProto
          .internal_static_google_cloud_functions_v2alpha_ListRuntimesResponse_Runtime_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime.class,
              com.google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime.Builder.class);
    }

    public static final int NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The name of the runtime, e.g., 'go113', 'nodejs12', etc.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the runtime, e.g., 'go113', 'nodejs12', etc.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DISPLAY_NAME_FIELD_NUMBER = 5;

    @SuppressWarnings("serial")
    private volatile java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * The user facing name, eg 'Go 1.13', 'Node.js 12', etc.
     * </pre>
     *
     * <code>string display_name = 5;</code>
     *
     * @return The displayName.
     */
    @java.lang.Override
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The user facing name, eg 'Go 1.13', 'Node.js 12', etc.
     * </pre>
     *
     * <code>string display_name = 5;</code>
     *
     * @return The bytes for displayName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int STAGE_FIELD_NUMBER = 2;
    private int stage_ = 0;
    /**
     *
     *
     * <pre>
     * The stage of life this runtime is in, e.g., BETA, GA, etc.
     * </pre>
     *
     * <code>.google.cloud.functions.v2alpha.ListRuntimesResponse.RuntimeStage stage = 2;</code>
     *
     * @return The enum numeric value on the wire for stage.
     */
    @java.lang.Override
    public int getStageValue() {
      return stage_;
    }
    /**
     *
     *
     * <pre>
     * The stage of life this runtime is in, e.g., BETA, GA, etc.
     * </pre>
     *
     * <code>.google.cloud.functions.v2alpha.ListRuntimesResponse.RuntimeStage stage = 2;</code>
     *
     * @return The stage.
     */
    @java.lang.Override
    public com.google.cloud.functions.v2alpha.ListRuntimesResponse.RuntimeStage getStage() {
      com.google.cloud.functions.v2alpha.ListRuntimesResponse.RuntimeStage result =
          com.google.cloud.functions.v2alpha.ListRuntimesResponse.RuntimeStage.forNumber(stage_);
      return result == null
          ? com.google.cloud.functions.v2alpha.ListRuntimesResponse.RuntimeStage.UNRECOGNIZED
          : result;
    }

    public static final int WARNINGS_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList warnings_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * Warning messages, e.g., a deprecation warning.
     * </pre>
     *
     * <code>repeated string warnings = 3;</code>
     *
     * @return A list containing the warnings.
     */
    public com.google.protobuf.ProtocolStringList getWarningsList() {
      return warnings_;
    }
    /**
     *
     *
     * <pre>
     * Warning messages, e.g., a deprecation warning.
     * </pre>
     *
     * <code>repeated string warnings = 3;</code>
     *
     * @return The count of warnings.
     */
    public int getWarningsCount() {
      return warnings_.size();
    }
    /**
     *
     *
     * <pre>
     * Warning messages, e.g., a deprecation warning.
     * </pre>
     *
     * <code>repeated string warnings = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The warnings at the given index.
     */
    public java.lang.String getWarnings(int index) {
      return warnings_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Warning messages, e.g., a deprecation warning.
     * </pre>
     *
     * <code>repeated string warnings = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the warnings at the given index.
     */
    public com.google.protobuf.ByteString getWarningsBytes(int index) {
      return warnings_.getByteString(index);
    }

    public static final int ENVIRONMENT_FIELD_NUMBER = 4;
    private int environment_ = 0;
    /**
     *
     *
     * <pre>
     * The environment for the runtime.
     * </pre>
     *
     * <code>.google.cloud.functions.v2alpha.Environment environment = 4;</code>
     *
     * @return The enum numeric value on the wire for environment.
     */
    @java.lang.Override
    public int getEnvironmentValue() {
      return environment_;
    }
    /**
     *
     *
     * <pre>
     * The environment for the runtime.
     * </pre>
     *
     * <code>.google.cloud.functions.v2alpha.Environment environment = 4;</code>
     *
     * @return The environment.
     */
    @java.lang.Override
    public com.google.cloud.functions.v2alpha.Environment getEnvironment() {
      com.google.cloud.functions.v2alpha.Environment result =
          com.google.cloud.functions.v2alpha.Environment.forNumber(environment_);
      return result == null ? com.google.cloud.functions.v2alpha.Environment.UNRECOGNIZED : result;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
      }
      if (stage_
          != com.google.cloud.functions.v2alpha.ListRuntimesResponse.RuntimeStage
              .RUNTIME_STAGE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(2, stage_);
      }
      for (int i = 0; i < warnings_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, warnings_.getRaw(i));
      }
      if (environment_
          != com.google.cloud.functions.v2alpha.Environment.ENVIRONMENT_UNSPECIFIED.getNumber()) {
        output.writeEnum(4, environment_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, displayName_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
      }
      if (stage_
          != com.google.cloud.functions.v2alpha.ListRuntimesResponse.RuntimeStage
              .RUNTIME_STAGE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, stage_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < warnings_.size(); i++) {
          dataSize += computeStringSizeNoTag(warnings_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getWarningsList().size();
      }
      if (environment_
          != com.google.cloud.functions.v2alpha.Environment.ENVIRONMENT_UNSPECIFIED.getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, environment_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, displayName_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime)) {
        return super.equals(obj);
      }
      com.google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime other =
          (com.google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime) obj;

      if (!getName().equals(other.getName())) return false;
      if (!getDisplayName().equals(other.getDisplayName())) return false;
      if (stage_ != other.stage_) return false;
      if (!getWarningsList().equals(other.getWarningsList())) return false;
      if (environment_ != other.environment_) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getDisplayName().hashCode();
      hash = (37 * hash) + STAGE_FIELD_NUMBER;
      hash = (53 * hash) + stage_;
      if (getWarningsCount() > 0) {
        hash = (37 * hash) + WARNINGS_FIELD_NUMBER;
        hash = (53 * hash) + getWarningsList().hashCode();
      }
      hash = (37 * hash) + ENVIRONMENT_FIELD_NUMBER;
      hash = (53 * hash) + environment_;
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Describes a runtime and any special information (e.g., deprecation status)
     * related to it.
     * </pre>
     *
     * Protobuf type {@code google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime)
        com.google.cloud.functions.v2alpha.ListRuntimesResponse.RuntimeOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.functions.v2alpha.FunctionsProto
            .internal_static_google_cloud_functions_v2alpha_ListRuntimesResponse_Runtime_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.functions.v2alpha.FunctionsProto
            .internal_static_google_cloud_functions_v2alpha_ListRuntimesResponse_Runtime_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime.class,
                com.google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime.Builder.class);
      }

      // Construct using
      // com.google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        name_ = "";
        displayName_ = "";
        stage_ = 0;
        warnings_ = com.google.protobuf.LazyStringArrayList.emptyList();
        environment_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.functions.v2alpha.FunctionsProto
            .internal_static_google_cloud_functions_v2alpha_ListRuntimesResponse_Runtime_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime
          getDefaultInstanceForType() {
        return com.google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime build() {
        com.google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime buildPartial() {
        com.google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime result =
            new com.google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.name_ = name_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.displayName_ = displayName_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.stage_ = stage_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          warnings_.makeImmutable();
          result.warnings_ = warnings_;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.environment_ = environment_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime) {
          return mergeFrom((com.google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime other) {
        if (other
            == com.google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime.getDefaultInstance())
          return this;
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getDisplayName().isEmpty()) {
          displayName_ = other.displayName_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (other.stage_ != 0) {
          setStageValue(other.getStageValue());
        }
        if (!other.warnings_.isEmpty()) {
          if (warnings_.isEmpty()) {
            warnings_ = other.warnings_;
            bitField0_ |= 0x00000008;
          } else {
            ensureWarningsIsMutable();
            warnings_.addAll(other.warnings_);
          }
          onChanged();
        }
        if (other.environment_ != 0) {
          setEnvironmentValue(other.getEnvironmentValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  name_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 16:
                {
                  stage_ = input.readEnum();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 16
              case 26:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureWarningsIsMutable();
                  warnings_.add(s);
                  break;
                } // case 26
              case 32:
                {
                  environment_ = input.readEnum();
                  bitField0_ |= 0x00000010;
                  break;
                } // case 32
              case 42:
                {
                  displayName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 42
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object name_ = "";
      /**
       *
       *
       * <pre>
       * The name of the runtime, e.g., 'go113', 'nodejs12', etc.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the runtime, e.g., 'go113', 'nodejs12', etc.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the runtime, e.g., 'go113', 'nodejs12', etc.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of the runtime, e.g., 'go113', 'nodejs12', etc.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearName() {
        name_ = getDefaultInstance().getName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of the runtime, e.g., 'go113', 'nodejs12', etc.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object displayName_ = "";
      /**
       *
       *
       * <pre>
       * The user facing name, eg 'Go 1.13', 'Node.js 12', etc.
       * </pre>
       *
       * <code>string display_name = 5;</code>
       *
       * @return The displayName.
       */
      public java.lang.String getDisplayName() {
        java.lang.Object ref = displayName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          displayName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The user facing name, eg 'Go 1.13', 'Node.js 12', etc.
       * </pre>
       *
       * <code>string display_name = 5;</code>
       *
       * @return The bytes for displayName.
       */
      public com.google.protobuf.ByteString getDisplayNameBytes() {
        java.lang.Object ref = displayName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          displayName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The user facing name, eg 'Go 1.13', 'Node.js 12', etc.
       * </pre>
       *
       * <code>string display_name = 5;</code>
       *
       * @param value The displayName to set.
       * @return This builder for chaining.
       */
      public Builder setDisplayName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        displayName_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The user facing name, eg 'Go 1.13', 'Node.js 12', etc.
       * </pre>
       *
       * <code>string display_name = 5;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDisplayName() {
        displayName_ = getDefaultInstance().getDisplayName();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The user facing name, eg 'Go 1.13', 'Node.js 12', etc.
       * </pre>
       *
       * <code>string display_name = 5;</code>
       *
       * @param value The bytes for displayName to set.
       * @return This builder for chaining.
       */
      public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        displayName_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private int stage_ = 0;
      /**
       *
       *
       * <pre>
       * The stage of life this runtime is in, e.g., BETA, GA, etc.
       * </pre>
       *
       * <code>.google.cloud.functions.v2alpha.ListRuntimesResponse.RuntimeStage stage = 2;</code>
       *
       * @return The enum numeric value on the wire for stage.
       */
      @java.lang.Override
      public int getStageValue() {
        return stage_;
      }
      /**
       *
       *
       * <pre>
       * The stage of life this runtime is in, e.g., BETA, GA, etc.
       * </pre>
       *
       * <code>.google.cloud.functions.v2alpha.ListRuntimesResponse.RuntimeStage stage = 2;</code>
       *
       * @param value The enum numeric value on the wire for stage to set.
       * @return This builder for chaining.
       */
      public Builder setStageValue(int value) {
        stage_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The stage of life this runtime is in, e.g., BETA, GA, etc.
       * </pre>
       *
       * <code>.google.cloud.functions.v2alpha.ListRuntimesResponse.RuntimeStage stage = 2;</code>
       *
       * @return The stage.
       */
      @java.lang.Override
      public com.google.cloud.functions.v2alpha.ListRuntimesResponse.RuntimeStage getStage() {
        com.google.cloud.functions.v2alpha.ListRuntimesResponse.RuntimeStage result =
            com.google.cloud.functions.v2alpha.ListRuntimesResponse.RuntimeStage.forNumber(stage_);
        return result == null
            ? com.google.cloud.functions.v2alpha.ListRuntimesResponse.RuntimeStage.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * The stage of life this runtime is in, e.g., BETA, GA, etc.
       * </pre>
       *
       * <code>.google.cloud.functions.v2alpha.ListRuntimesResponse.RuntimeStage stage = 2;</code>
       *
       * @param value The stage to set.
       * @return This builder for chaining.
       */
      public Builder setStage(
          com.google.cloud.functions.v2alpha.ListRuntimesResponse.RuntimeStage value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000004;
        stage_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The stage of life this runtime is in, e.g., BETA, GA, etc.
       * </pre>
       *
       * <code>.google.cloud.functions.v2alpha.ListRuntimesResponse.RuntimeStage stage = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearStage() {
        bitField0_ = (bitField0_ & ~0x00000004);
        stage_ = 0;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList warnings_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureWarningsIsMutable() {
        if (!warnings_.isModifiable()) {
          warnings_ = new com.google.protobuf.LazyStringArrayList(warnings_);
        }
        bitField0_ |= 0x00000008;
      }
      /**
       *
       *
       * <pre>
       * Warning messages, e.g., a deprecation warning.
       * </pre>
       *
       * <code>repeated string warnings = 3;</code>
       *
       * @return A list containing the warnings.
       */
      public com.google.protobuf.ProtocolStringList getWarningsList() {
        warnings_.makeImmutable();
        return warnings_;
      }
      /**
       *
       *
       * <pre>
       * Warning messages, e.g., a deprecation warning.
       * </pre>
       *
       * <code>repeated string warnings = 3;</code>
       *
       * @return The count of warnings.
       */
      public int getWarningsCount() {
        return warnings_.size();
      }
      /**
       *
       *
       * <pre>
       * Warning messages, e.g., a deprecation warning.
       * </pre>
       *
       * <code>repeated string warnings = 3;</code>
       *
       * @param index The index of the element to return.
       * @return The warnings at the given index.
       */
      public java.lang.String getWarnings(int index) {
        return warnings_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Warning messages, e.g., a deprecation warning.
       * </pre>
       *
       * <code>repeated string warnings = 3;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the warnings at the given index.
       */
      public com.google.protobuf.ByteString getWarningsBytes(int index) {
        return warnings_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * Warning messages, e.g., a deprecation warning.
       * </pre>
       *
       * <code>repeated string warnings = 3;</code>
       *
       * @param index The index to set the value at.
       * @param value The warnings to set.
       * @return This builder for chaining.
       */
      public Builder setWarnings(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureWarningsIsMutable();
        warnings_.set(index, value);
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Warning messages, e.g., a deprecation warning.
       * </pre>
       *
       * <code>repeated string warnings = 3;</code>
       *
       * @param value The warnings to add.
       * @return This builder for chaining.
       */
      public Builder addWarnings(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureWarningsIsMutable();
        warnings_.add(value);
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Warning messages, e.g., a deprecation warning.
       * </pre>
       *
       * <code>repeated string warnings = 3;</code>
       *
       * @param values The warnings to add.
       * @return This builder for chaining.
       */
      public Builder addAllWarnings(java.lang.Iterable<java.lang.String> values) {
        ensureWarningsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, warnings_);
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Warning messages, e.g., a deprecation warning.
       * </pre>
       *
       * <code>repeated string warnings = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearWarnings() {
        warnings_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Warning messages, e.g., a deprecation warning.
       * </pre>
       *
       * <code>repeated string warnings = 3;</code>
       *
       * @param value The bytes of the warnings to add.
       * @return This builder for chaining.
       */
      public Builder addWarningsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureWarningsIsMutable();
        warnings_.add(value);
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      private int environment_ = 0;
      /**
       *
       *
       * <pre>
       * The environment for the runtime.
       * </pre>
       *
       * <code>.google.cloud.functions.v2alpha.Environment environment = 4;</code>
       *
       * @return The enum numeric value on the wire for environment.
       */
      @java.lang.Override
      public int getEnvironmentValue() {
        return environment_;
      }
      /**
       *
       *
       * <pre>
       * The environment for the runtime.
       * </pre>
       *
       * <code>.google.cloud.functions.v2alpha.Environment environment = 4;</code>
       *
       * @param value The enum numeric value on the wire for environment to set.
       * @return This builder for chaining.
       */
      public Builder setEnvironmentValue(int value) {
        environment_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The environment for the runtime.
       * </pre>
       *
       * <code>.google.cloud.functions.v2alpha.Environment environment = 4;</code>
       *
       * @return The environment.
       */
      @java.lang.Override
      public com.google.cloud.functions.v2alpha.Environment getEnvironment() {
        com.google.cloud.functions.v2alpha.Environment result =
            com.google.cloud.functions.v2alpha.Environment.forNumber(environment_);
        return result == null
            ? com.google.cloud.functions.v2alpha.Environment.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * The environment for the runtime.
       * </pre>
       *
       * <code>.google.cloud.functions.v2alpha.Environment environment = 4;</code>
       *
       * @param value The environment to set.
       * @return This builder for chaining.
       */
      public Builder setEnvironment(com.google.cloud.functions.v2alpha.Environment value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000010;
        environment_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The environment for the runtime.
       * </pre>
       *
       * <code>.google.cloud.functions.v2alpha.Environment environment = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEnvironment() {
        bitField0_ = (bitField0_ & ~0x00000010);
        environment_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime)
    private static final com.google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime();
    }

    public static com.google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Runtime> PARSER =
        new com.google.protobuf.AbstractParser<Runtime>() {
          @java.lang.Override
          public Runtime parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Runtime> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Runtime> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int RUNTIMES_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime> runtimes_;
  /**
   *
   *
   * <pre>
   * The runtimes that match the request.
   * </pre>
   *
   * <code>repeated .google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime runtimes = 1;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime>
      getRuntimesList() {
    return runtimes_;
  }
  /**
   *
   *
   * <pre>
   * The runtimes that match the request.
   * </pre>
   *
   * <code>repeated .google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime runtimes = 1;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.functions.v2alpha.ListRuntimesResponse.RuntimeOrBuilder>
      getRuntimesOrBuilderList() {
    return runtimes_;
  }
  /**
   *
   *
   * <pre>
   * The runtimes that match the request.
   * </pre>
   *
   * <code>repeated .google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime runtimes = 1;
   * </code>
   */
  @java.lang.Override
  public int getRuntimesCount() {
    return runtimes_.size();
  }
  /**
   *
   *
   * <pre>
   * The runtimes that match the request.
   * </pre>
   *
   * <code>repeated .google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime runtimes = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime getRuntimes(int index) {
    return runtimes_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The runtimes that match the request.
   * </pre>
   *
   * <code>repeated .google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime runtimes = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.functions.v2alpha.ListRuntimesResponse.RuntimeOrBuilder
      getRuntimesOrBuilder(int index) {
    return runtimes_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < runtimes_.size(); i++) {
      output.writeMessage(1, runtimes_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < runtimes_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, runtimes_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.functions.v2alpha.ListRuntimesResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.functions.v2alpha.ListRuntimesResponse other =
        (com.google.cloud.functions.v2alpha.ListRuntimesResponse) obj;

    if (!getRuntimesList().equals(other.getRuntimesList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getRuntimesCount() > 0) {
      hash = (37 * hash) + RUNTIMES_FIELD_NUMBER;
      hash = (53 * hash) + getRuntimesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.functions.v2alpha.ListRuntimesResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.functions.v2alpha.ListRuntimesResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.functions.v2alpha.ListRuntimesResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.functions.v2alpha.ListRuntimesResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.functions.v2alpha.ListRuntimesResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.functions.v2alpha.ListRuntimesResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.functions.v2alpha.ListRuntimesResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.functions.v2alpha.ListRuntimesResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.functions.v2alpha.ListRuntimesResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.functions.v2alpha.ListRuntimesResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.functions.v2alpha.ListRuntimesResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.functions.v2alpha.ListRuntimesResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.functions.v2alpha.ListRuntimesResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Response for the `ListRuntimes` method.
   * </pre>
   *
   * Protobuf type {@code google.cloud.functions.v2alpha.ListRuntimesResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.functions.v2alpha.ListRuntimesResponse)
      com.google.cloud.functions.v2alpha.ListRuntimesResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.functions.v2alpha.FunctionsProto
          .internal_static_google_cloud_functions_v2alpha_ListRuntimesResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.functions.v2alpha.FunctionsProto
          .internal_static_google_cloud_functions_v2alpha_ListRuntimesResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.functions.v2alpha.ListRuntimesResponse.class,
              com.google.cloud.functions.v2alpha.ListRuntimesResponse.Builder.class);
    }

    // Construct using com.google.cloud.functions.v2alpha.ListRuntimesResponse.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (runtimesBuilder_ == null) {
        runtimes_ = java.util.Collections.emptyList();
      } else {
        runtimes_ = null;
        runtimesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.functions.v2alpha.FunctionsProto
          .internal_static_google_cloud_functions_v2alpha_ListRuntimesResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.functions.v2alpha.ListRuntimesResponse getDefaultInstanceForType() {
      return com.google.cloud.functions.v2alpha.ListRuntimesResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.functions.v2alpha.ListRuntimesResponse build() {
      com.google.cloud.functions.v2alpha.ListRuntimesResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.functions.v2alpha.ListRuntimesResponse buildPartial() {
      com.google.cloud.functions.v2alpha.ListRuntimesResponse result =
          new com.google.cloud.functions.v2alpha.ListRuntimesResponse(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.functions.v2alpha.ListRuntimesResponse result) {
      if (runtimesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          runtimes_ = java.util.Collections.unmodifiableList(runtimes_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.runtimes_ = runtimes_;
      } else {
        result.runtimes_ = runtimesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.functions.v2alpha.ListRuntimesResponse result) {
      int from_bitField0_ = bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.functions.v2alpha.ListRuntimesResponse) {
        return mergeFrom((com.google.cloud.functions.v2alpha.ListRuntimesResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.functions.v2alpha.ListRuntimesResponse other) {
      if (other == com.google.cloud.functions.v2alpha.ListRuntimesResponse.getDefaultInstance())
        return this;
      if (runtimesBuilder_ == null) {
        if (!other.runtimes_.isEmpty()) {
          if (runtimes_.isEmpty()) {
            runtimes_ = other.runtimes_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureRuntimesIsMutable();
            runtimes_.addAll(other.runtimes_);
          }
          onChanged();
        }
      } else {
        if (!other.runtimes_.isEmpty()) {
          if (runtimesBuilder_.isEmpty()) {
            runtimesBuilder_.dispose();
            runtimesBuilder_ = null;
            runtimes_ = other.runtimes_;
            bitField0_ = (bitField0_ & ~0x00000001);
            runtimesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getRuntimesFieldBuilder()
                    : null;
          } else {
            runtimesBuilder_.addAllMessages(other.runtimes_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime m =
                    input.readMessage(
                        com.google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime.parser(),
                        extensionRegistry);
                if (runtimesBuilder_ == null) {
                  ensureRuntimesIsMutable();
                  runtimes_.add(m);
                } else {
                  runtimesBuilder_.addMessage(m);
                }
                break;
              } // case 10
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime>
        runtimes_ = java.util.Collections.emptyList();

    private void ensureRuntimesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        runtimes_ =
            new java.util.ArrayList<
                com.google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime>(runtimes_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime,
            com.google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime.Builder,
            com.google.cloud.functions.v2alpha.ListRuntimesResponse.RuntimeOrBuilder>
        runtimesBuilder_;

    /**
     *
     *
     * <pre>
     * The runtimes that match the request.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime runtimes = 1;
     * </code>
     */
    public java.util.List<com.google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime>
        getRuntimesList() {
      if (runtimesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(runtimes_);
      } else {
        return runtimesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The runtimes that match the request.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime runtimes = 1;
     * </code>
     */
    public int getRuntimesCount() {
      if (runtimesBuilder_ == null) {
        return runtimes_.size();
      } else {
        return runtimesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The runtimes that match the request.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime runtimes = 1;
     * </code>
     */
    public com.google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime getRuntimes(int index) {
      if (runtimesBuilder_ == null) {
        return runtimes_.get(index);
      } else {
        return runtimesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The runtimes that match the request.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime runtimes = 1;
     * </code>
     */
    public Builder setRuntimes(
        int index, com.google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime value) {
      if (runtimesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRuntimesIsMutable();
        runtimes_.set(index, value);
        onChanged();
      } else {
        runtimesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The runtimes that match the request.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime runtimes = 1;
     * </code>
     */
    public Builder setRuntimes(
        int index,
        com.google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime.Builder builderForValue) {
      if (runtimesBuilder_ == null) {
        ensureRuntimesIsMutable();
        runtimes_.set(index, builderForValue.build());
        onChanged();
      } else {
        runtimesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The runtimes that match the request.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime runtimes = 1;
     * </code>
     */
    public Builder addRuntimes(
        com.google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime value) {
      if (runtimesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRuntimesIsMutable();
        runtimes_.add(value);
        onChanged();
      } else {
        runtimesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The runtimes that match the request.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime runtimes = 1;
     * </code>
     */
    public Builder addRuntimes(
        int index, com.google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime value) {
      if (runtimesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRuntimesIsMutable();
        runtimes_.add(index, value);
        onChanged();
      } else {
        runtimesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The runtimes that match the request.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime runtimes = 1;
     * </code>
     */
    public Builder addRuntimes(
        com.google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime.Builder builderForValue) {
      if (runtimesBuilder_ == null) {
        ensureRuntimesIsMutable();
        runtimes_.add(builderForValue.build());
        onChanged();
      } else {
        runtimesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The runtimes that match the request.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime runtimes = 1;
     * </code>
     */
    public Builder addRuntimes(
        int index,
        com.google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime.Builder builderForValue) {
      if (runtimesBuilder_ == null) {
        ensureRuntimesIsMutable();
        runtimes_.add(index, builderForValue.build());
        onChanged();
      } else {
        runtimesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The runtimes that match the request.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime runtimes = 1;
     * </code>
     */
    public Builder addAllRuntimes(
        java.lang.Iterable<
                ? extends com.google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime>
            values) {
      if (runtimesBuilder_ == null) {
        ensureRuntimesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, runtimes_);
        onChanged();
      } else {
        runtimesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The runtimes that match the request.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime runtimes = 1;
     * </code>
     */
    public Builder clearRuntimes() {
      if (runtimesBuilder_ == null) {
        runtimes_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        runtimesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The runtimes that match the request.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime runtimes = 1;
     * </code>
     */
    public Builder removeRuntimes(int index) {
      if (runtimesBuilder_ == null) {
        ensureRuntimesIsMutable();
        runtimes_.remove(index);
        onChanged();
      } else {
        runtimesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The runtimes that match the request.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime runtimes = 1;
     * </code>
     */
    public com.google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime.Builder
        getRuntimesBuilder(int index) {
      return getRuntimesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The runtimes that match the request.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime runtimes = 1;
     * </code>
     */
    public com.google.cloud.functions.v2alpha.ListRuntimesResponse.RuntimeOrBuilder
        getRuntimesOrBuilder(int index) {
      if (runtimesBuilder_ == null) {
        return runtimes_.get(index);
      } else {
        return runtimesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The runtimes that match the request.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime runtimes = 1;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.functions.v2alpha.ListRuntimesResponse.RuntimeOrBuilder>
        getRuntimesOrBuilderList() {
      if (runtimesBuilder_ != null) {
        return runtimesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(runtimes_);
      }
    }
    /**
     *
     *
     * <pre>
     * The runtimes that match the request.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime runtimes = 1;
     * </code>
     */
    public com.google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime.Builder
        addRuntimesBuilder() {
      return getRuntimesFieldBuilder()
          .addBuilder(
              com.google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The runtimes that match the request.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime runtimes = 1;
     * </code>
     */
    public com.google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime.Builder
        addRuntimesBuilder(int index) {
      return getRuntimesFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The runtimes that match the request.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime runtimes = 1;
     * </code>
     */
    public java.util.List<com.google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime.Builder>
        getRuntimesBuilderList() {
      return getRuntimesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime,
            com.google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime.Builder,
            com.google.cloud.functions.v2alpha.ListRuntimesResponse.RuntimeOrBuilder>
        getRuntimesFieldBuilder() {
      if (runtimesBuilder_ == null) {
        runtimesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime,
                com.google.cloud.functions.v2alpha.ListRuntimesResponse.Runtime.Builder,
                com.google.cloud.functions.v2alpha.ListRuntimesResponse.RuntimeOrBuilder>(
                runtimes_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        runtimes_ = null;
      }
      return runtimesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.functions.v2alpha.ListRuntimesResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.functions.v2alpha.ListRuntimesResponse)
  private static final com.google.cloud.functions.v2alpha.ListRuntimesResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.functions.v2alpha.ListRuntimesResponse();
  }

  public static com.google.cloud.functions.v2alpha.ListRuntimesResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ListRuntimesResponse> PARSER =
      new com.google.protobuf.AbstractParser<ListRuntimesResponse>() {
        @java.lang.Override
        public ListRuntimesResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ListRuntimesResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ListRuntimesResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.functions.v2alpha.ListRuntimesResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
