/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.functions.v2alpha;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class FunctionName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_FUNCTION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/functions/{function}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String function;

    @Deprecated
    protected FunctionName() {
        this.project = null;
        this.location = null;
        this.function = null;
    }

    private FunctionName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.function = (String)Preconditions.checkNotNull((Object)builder.getFunction());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getFunction() {
        return this.function;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static FunctionName of(String project, String location, String function) {
        return FunctionName.newBuilder().setProject(project).setLocation(location).setFunction(function).build();
    }

    public static String format(String project, String location, String function) {
        return FunctionName.newBuilder().setProject(project).setLocation(location).setFunction(function).build().toString();
    }

    public static FunctionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_FUNCTION.validatedMatch(formattedString, "FunctionName.parse: formattedString not in valid format");
        return FunctionName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("function"));
    }

    public static List<FunctionName> parseList(List<String> formattedStrings) {
        ArrayList<FunctionName> list = new ArrayList<FunctionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(FunctionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<FunctionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (FunctionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_FUNCTION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            FunctionName functionName = this;
            synchronized (functionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.function != null) {
                        fieldMapBuilder.put((Object)"function", (Object)this.function);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_FUNCTION.instantiate(new String[]{"project", this.project, "location", this.location, "function", this.function});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            FunctionName that = (FunctionName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.function, that.function);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.function);
    }

    public static class Builder {
        private String project;
        private String location;
        private String function;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getFunction() {
            return this.function;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setFunction(String function) {
            this.function = function;
            return this;
        }

        private Builder(FunctionName functionName) {
            this.project = functionName.project;
            this.location = functionName.location;
            this.function = functionName.function;
        }

        public FunctionName build() {
            return new FunctionName(this);
        }
    }
}

