/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/functions/v2alpha/functions.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.functions.v2alpha;

public interface SecretVolumeOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.functions.v2alpha.SecretVolume)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * The path within the container to mount the secret volume. For example,
   * setting the mount_path as `/etc/secrets` would mount the secret value files
   * under the `/etc/secrets` directory. This directory will also be completely
   * shadowed and unavailable to mount any other secrets.
   * Recommended mount path: /etc/secrets
   * </pre>
   *
   * <code>string mount_path = 1;</code>
   *
   * @return The mountPath.
   */
  java.lang.String getMountPath();
  /**
   *
   *
   * <pre>
   * The path within the container to mount the secret volume. For example,
   * setting the mount_path as `/etc/secrets` would mount the secret value files
   * under the `/etc/secrets` directory. This directory will also be completely
   * shadowed and unavailable to mount any other secrets.
   * Recommended mount path: /etc/secrets
   * </pre>
   *
   * <code>string mount_path = 1;</code>
   *
   * @return The bytes for mountPath.
   */
  com.google.protobuf.ByteString getMountPathBytes();

  /**
   *
   *
   * <pre>
   * Project identifier (preferably project number but can also be the project
   * ID) of the project that contains the secret. If not set, it is
   * assumed that the secret is in the same project as the function.
   * </pre>
   *
   * <code>string project_id = 2;</code>
   *
   * @return The projectId.
   */
  java.lang.String getProjectId();
  /**
   *
   *
   * <pre>
   * Project identifier (preferably project number but can also be the project
   * ID) of the project that contains the secret. If not set, it is
   * assumed that the secret is in the same project as the function.
   * </pre>
   *
   * <code>string project_id = 2;</code>
   *
   * @return The bytes for projectId.
   */
  com.google.protobuf.ByteString getProjectIdBytes();

  /**
   *
   *
   * <pre>
   * Name of the secret in secret manager (not the full resource name).
   * </pre>
   *
   * <code>string secret = 3;</code>
   *
   * @return The secret.
   */
  java.lang.String getSecret();
  /**
   *
   *
   * <pre>
   * Name of the secret in secret manager (not the full resource name).
   * </pre>
   *
   * <code>string secret = 3;</code>
   *
   * @return The bytes for secret.
   */
  com.google.protobuf.ByteString getSecretBytes();

  /**
   *
   *
   * <pre>
   * List of secret versions to mount for this secret. If empty, the `latest`
   * version of the secret will be made available in a file named after the
   * secret under the mount point.
   * </pre>
   *
   * <code>repeated .google.cloud.functions.v2alpha.SecretVolume.SecretVersion versions = 4;</code>
   */
  java.util.List<com.google.cloud.functions.v2alpha.SecretVolume.SecretVersion> getVersionsList();
  /**
   *
   *
   * <pre>
   * List of secret versions to mount for this secret. If empty, the `latest`
   * version of the secret will be made available in a file named after the
   * secret under the mount point.
   * </pre>
   *
   * <code>repeated .google.cloud.functions.v2alpha.SecretVolume.SecretVersion versions = 4;</code>
   */
  com.google.cloud.functions.v2alpha.SecretVolume.SecretVersion getVersions(int index);
  /**
   *
   *
   * <pre>
   * List of secret versions to mount for this secret. If empty, the `latest`
   * version of the secret will be made available in a file named after the
   * secret under the mount point.
   * </pre>
   *
   * <code>repeated .google.cloud.functions.v2alpha.SecretVolume.SecretVersion versions = 4;</code>
   */
  int getVersionsCount();
  /**
   *
   *
   * <pre>
   * List of secret versions to mount for this secret. If empty, the `latest`
   * version of the secret will be made available in a file named after the
   * secret under the mount point.
   * </pre>
   *
   * <code>repeated .google.cloud.functions.v2alpha.SecretVolume.SecretVersion versions = 4;</code>
   */
  java.util.List<? extends com.google.cloud.functions.v2alpha.SecretVolume.SecretVersionOrBuilder>
      getVersionsOrBuilderList();
  /**
   *
   *
   * <pre>
   * List of secret versions to mount for this secret. If empty, the `latest`
   * version of the secret will be made available in a file named after the
   * secret under the mount point.
   * </pre>
   *
   * <code>repeated .google.cloud.functions.v2alpha.SecretVolume.SecretVersion versions = 4;</code>
   */
  com.google.cloud.functions.v2alpha.SecretVolume.SecretVersionOrBuilder getVersionsOrBuilder(
      int index);
}
