/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/functions/v2alpha/functions.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.functions.v2alpha;

/**
 *
 *
 * <pre>
 * Describes EventTrigger, used to request events to be sent from another
 * service.
 * </pre>
 *
 * Protobuf type {@code google.cloud.functions.v2alpha.EventTrigger}
 */
public final class EventTrigger extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.functions.v2alpha.EventTrigger)
    EventTriggerOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use EventTrigger.newBuilder() to construct.
  private EventTrigger(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private EventTrigger() {
    trigger_ = "";
    triggerRegion_ = "";
    eventType_ = "";
    eventFilters_ = java.util.Collections.emptyList();
    pubsubTopic_ = "";
    serviceAccountEmail_ = "";
    retryPolicy_ = 0;
    channel_ = "";
    service_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new EventTrigger();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.functions.v2alpha.FunctionsProto
        .internal_static_google_cloud_functions_v2alpha_EventTrigger_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.functions.v2alpha.FunctionsProto
        .internal_static_google_cloud_functions_v2alpha_EventTrigger_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.functions.v2alpha.EventTrigger.class,
            com.google.cloud.functions.v2alpha.EventTrigger.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Describes the retry policy in case of function's execution failure.
   * Retried execution is charged as any other execution.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.functions.v2alpha.EventTrigger.RetryPolicy}
   */
  public enum RetryPolicy implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not specified.
     * </pre>
     *
     * <code>RETRY_POLICY_UNSPECIFIED = 0;</code>
     */
    RETRY_POLICY_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Do not retry.
     * </pre>
     *
     * <code>RETRY_POLICY_DO_NOT_RETRY = 1;</code>
     */
    RETRY_POLICY_DO_NOT_RETRY(1),
    /**
     *
     *
     * <pre>
     * Retry on any failure, retry up to 7 days with an exponential backoff
     * (capped at 10 seconds).
     * </pre>
     *
     * <code>RETRY_POLICY_RETRY = 2;</code>
     */
    RETRY_POLICY_RETRY(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not specified.
     * </pre>
     *
     * <code>RETRY_POLICY_UNSPECIFIED = 0;</code>
     */
    public static final int RETRY_POLICY_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Do not retry.
     * </pre>
     *
     * <code>RETRY_POLICY_DO_NOT_RETRY = 1;</code>
     */
    public static final int RETRY_POLICY_DO_NOT_RETRY_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Retry on any failure, retry up to 7 days with an exponential backoff
     * (capped at 10 seconds).
     * </pre>
     *
     * <code>RETRY_POLICY_RETRY = 2;</code>
     */
    public static final int RETRY_POLICY_RETRY_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static RetryPolicy valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static RetryPolicy forNumber(int value) {
      switch (value) {
        case 0:
          return RETRY_POLICY_UNSPECIFIED;
        case 1:
          return RETRY_POLICY_DO_NOT_RETRY;
        case 2:
          return RETRY_POLICY_RETRY;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<RetryPolicy> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<RetryPolicy> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<RetryPolicy>() {
          public RetryPolicy findValueByNumber(int number) {
            return RetryPolicy.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.functions.v2alpha.EventTrigger.getDescriptor().getEnumTypes().get(0);
    }

    private static final RetryPolicy[] VALUES = values();

    public static RetryPolicy valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private RetryPolicy(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.functions.v2alpha.EventTrigger.RetryPolicy)
  }

  public static final int TRIGGER_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object trigger_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the Eventarc trigger. The format of this
   * field is `projects/{project}/locations/{region}/triggers/{trigger}`.
   * </pre>
   *
   * <code>
   * string trigger = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The trigger.
   */
  @java.lang.Override
  public java.lang.String getTrigger() {
    java.lang.Object ref = trigger_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      trigger_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the Eventarc trigger. The format of this
   * field is `projects/{project}/locations/{region}/triggers/{trigger}`.
   * </pre>
   *
   * <code>
   * string trigger = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for trigger.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTriggerBytes() {
    java.lang.Object ref = trigger_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      trigger_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TRIGGER_REGION_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object triggerRegion_ = "";
  /**
   *
   *
   * <pre>
   * The region that the trigger will be in. The trigger will only receive
   * events originating in this region. It can be the same
   * region as the function, a different region or multi-region, or the global
   * region. If not provided, defaults to the same region as the function.
   * </pre>
   *
   * <code>string trigger_region = 2;</code>
   *
   * @return The triggerRegion.
   */
  @java.lang.Override
  public java.lang.String getTriggerRegion() {
    java.lang.Object ref = triggerRegion_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      triggerRegion_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The region that the trigger will be in. The trigger will only receive
   * events originating in this region. It can be the same
   * region as the function, a different region or multi-region, or the global
   * region. If not provided, defaults to the same region as the function.
   * </pre>
   *
   * <code>string trigger_region = 2;</code>
   *
   * @return The bytes for triggerRegion.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTriggerRegionBytes() {
    java.lang.Object ref = triggerRegion_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      triggerRegion_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EVENT_TYPE_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object eventType_ = "";
  /**
   *
   *
   * <pre>
   * Required. The type of event to observe. For example:
   * `google.cloud.audit.log.v1.written` or
   * `google.cloud.pubsub.topic.v1.messagePublished`.
   * </pre>
   *
   * <code>string event_type = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The eventType.
   */
  @java.lang.Override
  public java.lang.String getEventType() {
    java.lang.Object ref = eventType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      eventType_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The type of event to observe. For example:
   * `google.cloud.audit.log.v1.written` or
   * `google.cloud.pubsub.topic.v1.messagePublished`.
   * </pre>
   *
   * <code>string event_type = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for eventType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEventTypeBytes() {
    java.lang.Object ref = eventType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      eventType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EVENT_FILTERS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.functions.v2alpha.EventFilter> eventFilters_;
  /**
   *
   *
   * <pre>
   * Criteria used to filter events.
   * </pre>
   *
   * <code>repeated .google.cloud.functions.v2alpha.EventFilter event_filters = 4;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.functions.v2alpha.EventFilter> getEventFiltersList() {
    return eventFilters_;
  }
  /**
   *
   *
   * <pre>
   * Criteria used to filter events.
   * </pre>
   *
   * <code>repeated .google.cloud.functions.v2alpha.EventFilter event_filters = 4;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.functions.v2alpha.EventFilterOrBuilder>
      getEventFiltersOrBuilderList() {
    return eventFilters_;
  }
  /**
   *
   *
   * <pre>
   * Criteria used to filter events.
   * </pre>
   *
   * <code>repeated .google.cloud.functions.v2alpha.EventFilter event_filters = 4;</code>
   */
  @java.lang.Override
  public int getEventFiltersCount() {
    return eventFilters_.size();
  }
  /**
   *
   *
   * <pre>
   * Criteria used to filter events.
   * </pre>
   *
   * <code>repeated .google.cloud.functions.v2alpha.EventFilter event_filters = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.functions.v2alpha.EventFilter getEventFilters(int index) {
    return eventFilters_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Criteria used to filter events.
   * </pre>
   *
   * <code>repeated .google.cloud.functions.v2alpha.EventFilter event_filters = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.functions.v2alpha.EventFilterOrBuilder getEventFiltersOrBuilder(
      int index) {
    return eventFilters_.get(index);
  }

  public static final int PUBSUB_TOPIC_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object pubsubTopic_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The name of a Pub/Sub topic in the same project that will be used
   * as the transport topic for the event delivery. Format:
   * `projects/{project}/topics/{topic}`.
   *
   * This is only valid for events of type
   * `google.cloud.pubsub.topic.v1.messagePublished`. The topic provided here
   * will not be deleted at function deletion.
   * </pre>
   *
   * <code>
   * string pubsub_topic = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The pubsubTopic.
   */
  @java.lang.Override
  public java.lang.String getPubsubTopic() {
    java.lang.Object ref = pubsubTopic_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      pubsubTopic_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The name of a Pub/Sub topic in the same project that will be used
   * as the transport topic for the event delivery. Format:
   * `projects/{project}/topics/{topic}`.
   *
   * This is only valid for events of type
   * `google.cloud.pubsub.topic.v1.messagePublished`. The topic provided here
   * will not be deleted at function deletion.
   * </pre>
   *
   * <code>
   * string pubsub_topic = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for pubsubTopic.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPubsubTopicBytes() {
    java.lang.Object ref = pubsubTopic_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      pubsubTopic_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SERVICE_ACCOUNT_EMAIL_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object serviceAccountEmail_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The email of the trigger's service account. The service account
   * must have permission to invoke Cloud Run services, the permission is
   * `run.routes.invoke`.
   * If empty, defaults to the Compute Engine default service account:
   * `{project_number}-compute&#64;developer.gserviceaccount.com`.
   * </pre>
   *
   * <code>string service_account_email = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The serviceAccountEmail.
   */
  @java.lang.Override
  public java.lang.String getServiceAccountEmail() {
    java.lang.Object ref = serviceAccountEmail_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      serviceAccountEmail_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The email of the trigger's service account. The service account
   * must have permission to invoke Cloud Run services, the permission is
   * `run.routes.invoke`.
   * If empty, defaults to the Compute Engine default service account:
   * `{project_number}-compute&#64;developer.gserviceaccount.com`.
   * </pre>
   *
   * <code>string service_account_email = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for serviceAccountEmail.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServiceAccountEmailBytes() {
    java.lang.Object ref = serviceAccountEmail_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      serviceAccountEmail_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RETRY_POLICY_FIELD_NUMBER = 7;
  private int retryPolicy_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. If unset, then defaults to ignoring failures (i.e. not retrying
   * them).
   * </pre>
   *
   * <code>
   * .google.cloud.functions.v2alpha.EventTrigger.RetryPolicy retry_policy = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for retryPolicy.
   */
  @java.lang.Override
  public int getRetryPolicyValue() {
    return retryPolicy_;
  }
  /**
   *
   *
   * <pre>
   * Optional. If unset, then defaults to ignoring failures (i.e. not retrying
   * them).
   * </pre>
   *
   * <code>
   * .google.cloud.functions.v2alpha.EventTrigger.RetryPolicy retry_policy = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The retryPolicy.
   */
  @java.lang.Override
  public com.google.cloud.functions.v2alpha.EventTrigger.RetryPolicy getRetryPolicy() {
    com.google.cloud.functions.v2alpha.EventTrigger.RetryPolicy result =
        com.google.cloud.functions.v2alpha.EventTrigger.RetryPolicy.forNumber(retryPolicy_);
    return result == null
        ? com.google.cloud.functions.v2alpha.EventTrigger.RetryPolicy.UNRECOGNIZED
        : result;
  }

  public static final int CHANNEL_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object channel_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The name of the channel associated with the trigger in
   * `projects/{project}/locations/{location}/channels/{channel}` format.
   * You must provide a channel to receive events from Eventarc SaaS partners.
   * </pre>
   *
   * <code>
   * string channel = 8 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The channel.
   */
  @java.lang.Override
  public java.lang.String getChannel() {
    java.lang.Object ref = channel_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      channel_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The name of the channel associated with the trigger in
   * `projects/{project}/locations/{location}/channels/{channel}` format.
   * You must provide a channel to receive events from Eventarc SaaS partners.
   * </pre>
   *
   * <code>
   * string channel = 8 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for channel.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getChannelBytes() {
    java.lang.Object ref = channel_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      channel_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SERVICE_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private volatile java.lang.Object service_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The hostname of the service that 1st Gen function should be
   * observed.
   *
   * If no string is provided, the default service implementing the API will
   * be used. For example, `storage.googleapis.com` is the default for all
   * event types in the `google.storage` namespace.
   *
   * The field is only applicable to 1st Gen functions.
   * </pre>
   *
   * <code>string service = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The service.
   */
  @java.lang.Override
  public java.lang.String getService() {
    java.lang.Object ref = service_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      service_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The hostname of the service that 1st Gen function should be
   * observed.
   *
   * If no string is provided, the default service implementing the API will
   * be used. For example, `storage.googleapis.com` is the default for all
   * event types in the `google.storage` namespace.
   *
   * The field is only applicable to 1st Gen functions.
   * </pre>
   *
   * <code>string service = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for service.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServiceBytes() {
    java.lang.Object ref = service_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      service_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(trigger_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, trigger_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(triggerRegion_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, triggerRegion_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(eventType_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, eventType_);
    }
    for (int i = 0; i < eventFilters_.size(); i++) {
      output.writeMessage(4, eventFilters_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pubsubTopic_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, pubsubTopic_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccountEmail_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, serviceAccountEmail_);
    }
    if (retryPolicy_
        != com.google.cloud.functions.v2alpha.EventTrigger.RetryPolicy.RETRY_POLICY_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(7, retryPolicy_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(channel_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, channel_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(service_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, service_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(trigger_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, trigger_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(triggerRegion_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, triggerRegion_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(eventType_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, eventType_);
    }
    for (int i = 0; i < eventFilters_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, eventFilters_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pubsubTopic_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, pubsubTopic_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccountEmail_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, serviceAccountEmail_);
    }
    if (retryPolicy_
        != com.google.cloud.functions.v2alpha.EventTrigger.RetryPolicy.RETRY_POLICY_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(7, retryPolicy_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(channel_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, channel_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(service_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, service_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.functions.v2alpha.EventTrigger)) {
      return super.equals(obj);
    }
    com.google.cloud.functions.v2alpha.EventTrigger other =
        (com.google.cloud.functions.v2alpha.EventTrigger) obj;

    if (!getTrigger().equals(other.getTrigger())) return false;
    if (!getTriggerRegion().equals(other.getTriggerRegion())) return false;
    if (!getEventType().equals(other.getEventType())) return false;
    if (!getEventFiltersList().equals(other.getEventFiltersList())) return false;
    if (!getPubsubTopic().equals(other.getPubsubTopic())) return false;
    if (!getServiceAccountEmail().equals(other.getServiceAccountEmail())) return false;
    if (retryPolicy_ != other.retryPolicy_) return false;
    if (!getChannel().equals(other.getChannel())) return false;
    if (!getService().equals(other.getService())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TRIGGER_FIELD_NUMBER;
    hash = (53 * hash) + getTrigger().hashCode();
    hash = (37 * hash) + TRIGGER_REGION_FIELD_NUMBER;
    hash = (53 * hash) + getTriggerRegion().hashCode();
    hash = (37 * hash) + EVENT_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getEventType().hashCode();
    if (getEventFiltersCount() > 0) {
      hash = (37 * hash) + EVENT_FILTERS_FIELD_NUMBER;
      hash = (53 * hash) + getEventFiltersList().hashCode();
    }
    hash = (37 * hash) + PUBSUB_TOPIC_FIELD_NUMBER;
    hash = (53 * hash) + getPubsubTopic().hashCode();
    hash = (37 * hash) + SERVICE_ACCOUNT_EMAIL_FIELD_NUMBER;
    hash = (53 * hash) + getServiceAccountEmail().hashCode();
    hash = (37 * hash) + RETRY_POLICY_FIELD_NUMBER;
    hash = (53 * hash) + retryPolicy_;
    hash = (37 * hash) + CHANNEL_FIELD_NUMBER;
    hash = (53 * hash) + getChannel().hashCode();
    hash = (37 * hash) + SERVICE_FIELD_NUMBER;
    hash = (53 * hash) + getService().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.functions.v2alpha.EventTrigger parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.functions.v2alpha.EventTrigger parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.functions.v2alpha.EventTrigger parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.functions.v2alpha.EventTrigger parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.functions.v2alpha.EventTrigger parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.functions.v2alpha.EventTrigger parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.functions.v2alpha.EventTrigger parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.functions.v2alpha.EventTrigger parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.functions.v2alpha.EventTrigger parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.functions.v2alpha.EventTrigger parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.functions.v2alpha.EventTrigger parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.functions.v2alpha.EventTrigger parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.functions.v2alpha.EventTrigger prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Describes EventTrigger, used to request events to be sent from another
   * service.
   * </pre>
   *
   * Protobuf type {@code google.cloud.functions.v2alpha.EventTrigger}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.functions.v2alpha.EventTrigger)
      com.google.cloud.functions.v2alpha.EventTriggerOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.functions.v2alpha.FunctionsProto
          .internal_static_google_cloud_functions_v2alpha_EventTrigger_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.functions.v2alpha.FunctionsProto
          .internal_static_google_cloud_functions_v2alpha_EventTrigger_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.functions.v2alpha.EventTrigger.class,
              com.google.cloud.functions.v2alpha.EventTrigger.Builder.class);
    }

    // Construct using com.google.cloud.functions.v2alpha.EventTrigger.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      trigger_ = "";
      triggerRegion_ = "";
      eventType_ = "";
      if (eventFiltersBuilder_ == null) {
        eventFilters_ = java.util.Collections.emptyList();
      } else {
        eventFilters_ = null;
        eventFiltersBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      pubsubTopic_ = "";
      serviceAccountEmail_ = "";
      retryPolicy_ = 0;
      channel_ = "";
      service_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.functions.v2alpha.FunctionsProto
          .internal_static_google_cloud_functions_v2alpha_EventTrigger_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.functions.v2alpha.EventTrigger getDefaultInstanceForType() {
      return com.google.cloud.functions.v2alpha.EventTrigger.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.functions.v2alpha.EventTrigger build() {
      com.google.cloud.functions.v2alpha.EventTrigger result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.functions.v2alpha.EventTrigger buildPartial() {
      com.google.cloud.functions.v2alpha.EventTrigger result =
          new com.google.cloud.functions.v2alpha.EventTrigger(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.functions.v2alpha.EventTrigger result) {
      if (eventFiltersBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          eventFilters_ = java.util.Collections.unmodifiableList(eventFilters_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.eventFilters_ = eventFilters_;
      } else {
        result.eventFilters_ = eventFiltersBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.functions.v2alpha.EventTrigger result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.trigger_ = trigger_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.triggerRegion_ = triggerRegion_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.eventType_ = eventType_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.pubsubTopic_ = pubsubTopic_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.serviceAccountEmail_ = serviceAccountEmail_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.retryPolicy_ = retryPolicy_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.channel_ = channel_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.service_ = service_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.functions.v2alpha.EventTrigger) {
        return mergeFrom((com.google.cloud.functions.v2alpha.EventTrigger) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.functions.v2alpha.EventTrigger other) {
      if (other == com.google.cloud.functions.v2alpha.EventTrigger.getDefaultInstance())
        return this;
      if (!other.getTrigger().isEmpty()) {
        trigger_ = other.trigger_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getTriggerRegion().isEmpty()) {
        triggerRegion_ = other.triggerRegion_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getEventType().isEmpty()) {
        eventType_ = other.eventType_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (eventFiltersBuilder_ == null) {
        if (!other.eventFilters_.isEmpty()) {
          if (eventFilters_.isEmpty()) {
            eventFilters_ = other.eventFilters_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureEventFiltersIsMutable();
            eventFilters_.addAll(other.eventFilters_);
          }
          onChanged();
        }
      } else {
        if (!other.eventFilters_.isEmpty()) {
          if (eventFiltersBuilder_.isEmpty()) {
            eventFiltersBuilder_.dispose();
            eventFiltersBuilder_ = null;
            eventFilters_ = other.eventFilters_;
            bitField0_ = (bitField0_ & ~0x00000008);
            eventFiltersBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getEventFiltersFieldBuilder()
                    : null;
          } else {
            eventFiltersBuilder_.addAllMessages(other.eventFilters_);
          }
        }
      }
      if (!other.getPubsubTopic().isEmpty()) {
        pubsubTopic_ = other.pubsubTopic_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.getServiceAccountEmail().isEmpty()) {
        serviceAccountEmail_ = other.serviceAccountEmail_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.retryPolicy_ != 0) {
        setRetryPolicyValue(other.getRetryPolicyValue());
      }
      if (!other.getChannel().isEmpty()) {
        channel_ = other.channel_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (!other.getService().isEmpty()) {
        service_ = other.service_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                trigger_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                triggerRegion_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                eventType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                com.google.cloud.functions.v2alpha.EventFilter m =
                    input.readMessage(
                        com.google.cloud.functions.v2alpha.EventFilter.parser(), extensionRegistry);
                if (eventFiltersBuilder_ == null) {
                  ensureEventFiltersIsMutable();
                  eventFilters_.add(m);
                } else {
                  eventFiltersBuilder_.addMessage(m);
                }
                break;
              } // case 34
            case 42:
              {
                pubsubTopic_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                serviceAccountEmail_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 56:
              {
                retryPolicy_ = input.readEnum();
                bitField0_ |= 0x00000040;
                break;
              } // case 56
            case 66:
              {
                channel_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            case 74:
              {
                service_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 74
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object trigger_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the Eventarc trigger. The format of this
     * field is `projects/{project}/locations/{region}/triggers/{trigger}`.
     * </pre>
     *
     * <code>
     * string trigger = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The trigger.
     */
    public java.lang.String getTrigger() {
      java.lang.Object ref = trigger_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        trigger_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the Eventarc trigger. The format of this
     * field is `projects/{project}/locations/{region}/triggers/{trigger}`.
     * </pre>
     *
     * <code>
     * string trigger = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for trigger.
     */
    public com.google.protobuf.ByteString getTriggerBytes() {
      java.lang.Object ref = trigger_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        trigger_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the Eventarc trigger. The format of this
     * field is `projects/{project}/locations/{region}/triggers/{trigger}`.
     * </pre>
     *
     * <code>
     * string trigger = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The trigger to set.
     * @return This builder for chaining.
     */
    public Builder setTrigger(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      trigger_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the Eventarc trigger. The format of this
     * field is `projects/{project}/locations/{region}/triggers/{trigger}`.
     * </pre>
     *
     * <code>
     * string trigger = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTrigger() {
      trigger_ = getDefaultInstance().getTrigger();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the Eventarc trigger. The format of this
     * field is `projects/{project}/locations/{region}/triggers/{trigger}`.
     * </pre>
     *
     * <code>
     * string trigger = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for trigger to set.
     * @return This builder for chaining.
     */
    public Builder setTriggerBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      trigger_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object triggerRegion_ = "";
    /**
     *
     *
     * <pre>
     * The region that the trigger will be in. The trigger will only receive
     * events originating in this region. It can be the same
     * region as the function, a different region or multi-region, or the global
     * region. If not provided, defaults to the same region as the function.
     * </pre>
     *
     * <code>string trigger_region = 2;</code>
     *
     * @return The triggerRegion.
     */
    public java.lang.String getTriggerRegion() {
      java.lang.Object ref = triggerRegion_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        triggerRegion_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The region that the trigger will be in. The trigger will only receive
     * events originating in this region. It can be the same
     * region as the function, a different region or multi-region, or the global
     * region. If not provided, defaults to the same region as the function.
     * </pre>
     *
     * <code>string trigger_region = 2;</code>
     *
     * @return The bytes for triggerRegion.
     */
    public com.google.protobuf.ByteString getTriggerRegionBytes() {
      java.lang.Object ref = triggerRegion_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        triggerRegion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The region that the trigger will be in. The trigger will only receive
     * events originating in this region. It can be the same
     * region as the function, a different region or multi-region, or the global
     * region. If not provided, defaults to the same region as the function.
     * </pre>
     *
     * <code>string trigger_region = 2;</code>
     *
     * @param value The triggerRegion to set.
     * @return This builder for chaining.
     */
    public Builder setTriggerRegion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      triggerRegion_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The region that the trigger will be in. The trigger will only receive
     * events originating in this region. It can be the same
     * region as the function, a different region or multi-region, or the global
     * region. If not provided, defaults to the same region as the function.
     * </pre>
     *
     * <code>string trigger_region = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTriggerRegion() {
      triggerRegion_ = getDefaultInstance().getTriggerRegion();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The region that the trigger will be in. The trigger will only receive
     * events originating in this region. It can be the same
     * region as the function, a different region or multi-region, or the global
     * region. If not provided, defaults to the same region as the function.
     * </pre>
     *
     * <code>string trigger_region = 2;</code>
     *
     * @param value The bytes for triggerRegion to set.
     * @return This builder for chaining.
     */
    public Builder setTriggerRegionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      triggerRegion_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object eventType_ = "";
    /**
     *
     *
     * <pre>
     * Required. The type of event to observe. For example:
     * `google.cloud.audit.log.v1.written` or
     * `google.cloud.pubsub.topic.v1.messagePublished`.
     * </pre>
     *
     * <code>string event_type = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The eventType.
     */
    public java.lang.String getEventType() {
      java.lang.Object ref = eventType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        eventType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The type of event to observe. For example:
     * `google.cloud.audit.log.v1.written` or
     * `google.cloud.pubsub.topic.v1.messagePublished`.
     * </pre>
     *
     * <code>string event_type = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for eventType.
     */
    public com.google.protobuf.ByteString getEventTypeBytes() {
      java.lang.Object ref = eventType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        eventType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The type of event to observe. For example:
     * `google.cloud.audit.log.v1.written` or
     * `google.cloud.pubsub.topic.v1.messagePublished`.
     * </pre>
     *
     * <code>string event_type = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The eventType to set.
     * @return This builder for chaining.
     */
    public Builder setEventType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      eventType_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The type of event to observe. For example:
     * `google.cloud.audit.log.v1.written` or
     * `google.cloud.pubsub.topic.v1.messagePublished`.
     * </pre>
     *
     * <code>string event_type = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEventType() {
      eventType_ = getDefaultInstance().getEventType();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The type of event to observe. For example:
     * `google.cloud.audit.log.v1.written` or
     * `google.cloud.pubsub.topic.v1.messagePublished`.
     * </pre>
     *
     * <code>string event_type = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for eventType to set.
     * @return This builder for chaining.
     */
    public Builder setEventTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      eventType_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.functions.v2alpha.EventFilter> eventFilters_ =
        java.util.Collections.emptyList();

    private void ensureEventFiltersIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        eventFilters_ =
            new java.util.ArrayList<com.google.cloud.functions.v2alpha.EventFilter>(eventFilters_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.functions.v2alpha.EventFilter,
            com.google.cloud.functions.v2alpha.EventFilter.Builder,
            com.google.cloud.functions.v2alpha.EventFilterOrBuilder>
        eventFiltersBuilder_;

    /**
     *
     *
     * <pre>
     * Criteria used to filter events.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2alpha.EventFilter event_filters = 4;</code>
     */
    public java.util.List<com.google.cloud.functions.v2alpha.EventFilter> getEventFiltersList() {
      if (eventFiltersBuilder_ == null) {
        return java.util.Collections.unmodifiableList(eventFilters_);
      } else {
        return eventFiltersBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Criteria used to filter events.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2alpha.EventFilter event_filters = 4;</code>
     */
    public int getEventFiltersCount() {
      if (eventFiltersBuilder_ == null) {
        return eventFilters_.size();
      } else {
        return eventFiltersBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Criteria used to filter events.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2alpha.EventFilter event_filters = 4;</code>
     */
    public com.google.cloud.functions.v2alpha.EventFilter getEventFilters(int index) {
      if (eventFiltersBuilder_ == null) {
        return eventFilters_.get(index);
      } else {
        return eventFiltersBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Criteria used to filter events.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2alpha.EventFilter event_filters = 4;</code>
     */
    public Builder setEventFilters(
        int index, com.google.cloud.functions.v2alpha.EventFilter value) {
      if (eventFiltersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEventFiltersIsMutable();
        eventFilters_.set(index, value);
        onChanged();
      } else {
        eventFiltersBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Criteria used to filter events.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2alpha.EventFilter event_filters = 4;</code>
     */
    public Builder setEventFilters(
        int index, com.google.cloud.functions.v2alpha.EventFilter.Builder builderForValue) {
      if (eventFiltersBuilder_ == null) {
        ensureEventFiltersIsMutable();
        eventFilters_.set(index, builderForValue.build());
        onChanged();
      } else {
        eventFiltersBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Criteria used to filter events.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2alpha.EventFilter event_filters = 4;</code>
     */
    public Builder addEventFilters(com.google.cloud.functions.v2alpha.EventFilter value) {
      if (eventFiltersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEventFiltersIsMutable();
        eventFilters_.add(value);
        onChanged();
      } else {
        eventFiltersBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Criteria used to filter events.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2alpha.EventFilter event_filters = 4;</code>
     */
    public Builder addEventFilters(
        int index, com.google.cloud.functions.v2alpha.EventFilter value) {
      if (eventFiltersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEventFiltersIsMutable();
        eventFilters_.add(index, value);
        onChanged();
      } else {
        eventFiltersBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Criteria used to filter events.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2alpha.EventFilter event_filters = 4;</code>
     */
    public Builder addEventFilters(
        com.google.cloud.functions.v2alpha.EventFilter.Builder builderForValue) {
      if (eventFiltersBuilder_ == null) {
        ensureEventFiltersIsMutable();
        eventFilters_.add(builderForValue.build());
        onChanged();
      } else {
        eventFiltersBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Criteria used to filter events.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2alpha.EventFilter event_filters = 4;</code>
     */
    public Builder addEventFilters(
        int index, com.google.cloud.functions.v2alpha.EventFilter.Builder builderForValue) {
      if (eventFiltersBuilder_ == null) {
        ensureEventFiltersIsMutable();
        eventFilters_.add(index, builderForValue.build());
        onChanged();
      } else {
        eventFiltersBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Criteria used to filter events.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2alpha.EventFilter event_filters = 4;</code>
     */
    public Builder addAllEventFilters(
        java.lang.Iterable<? extends com.google.cloud.functions.v2alpha.EventFilter> values) {
      if (eventFiltersBuilder_ == null) {
        ensureEventFiltersIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, eventFilters_);
        onChanged();
      } else {
        eventFiltersBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Criteria used to filter events.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2alpha.EventFilter event_filters = 4;</code>
     */
    public Builder clearEventFilters() {
      if (eventFiltersBuilder_ == null) {
        eventFilters_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        eventFiltersBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Criteria used to filter events.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2alpha.EventFilter event_filters = 4;</code>
     */
    public Builder removeEventFilters(int index) {
      if (eventFiltersBuilder_ == null) {
        ensureEventFiltersIsMutable();
        eventFilters_.remove(index);
        onChanged();
      } else {
        eventFiltersBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Criteria used to filter events.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2alpha.EventFilter event_filters = 4;</code>
     */
    public com.google.cloud.functions.v2alpha.EventFilter.Builder getEventFiltersBuilder(
        int index) {
      return getEventFiltersFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Criteria used to filter events.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2alpha.EventFilter event_filters = 4;</code>
     */
    public com.google.cloud.functions.v2alpha.EventFilterOrBuilder getEventFiltersOrBuilder(
        int index) {
      if (eventFiltersBuilder_ == null) {
        return eventFilters_.get(index);
      } else {
        return eventFiltersBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Criteria used to filter events.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2alpha.EventFilter event_filters = 4;</code>
     */
    public java.util.List<? extends com.google.cloud.functions.v2alpha.EventFilterOrBuilder>
        getEventFiltersOrBuilderList() {
      if (eventFiltersBuilder_ != null) {
        return eventFiltersBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(eventFilters_);
      }
    }
    /**
     *
     *
     * <pre>
     * Criteria used to filter events.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2alpha.EventFilter event_filters = 4;</code>
     */
    public com.google.cloud.functions.v2alpha.EventFilter.Builder addEventFiltersBuilder() {
      return getEventFiltersFieldBuilder()
          .addBuilder(com.google.cloud.functions.v2alpha.EventFilter.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Criteria used to filter events.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2alpha.EventFilter event_filters = 4;</code>
     */
    public com.google.cloud.functions.v2alpha.EventFilter.Builder addEventFiltersBuilder(
        int index) {
      return getEventFiltersFieldBuilder()
          .addBuilder(index, com.google.cloud.functions.v2alpha.EventFilter.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Criteria used to filter events.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2alpha.EventFilter event_filters = 4;</code>
     */
    public java.util.List<com.google.cloud.functions.v2alpha.EventFilter.Builder>
        getEventFiltersBuilderList() {
      return getEventFiltersFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.functions.v2alpha.EventFilter,
            com.google.cloud.functions.v2alpha.EventFilter.Builder,
            com.google.cloud.functions.v2alpha.EventFilterOrBuilder>
        getEventFiltersFieldBuilder() {
      if (eventFiltersBuilder_ == null) {
        eventFiltersBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.functions.v2alpha.EventFilter,
                com.google.cloud.functions.v2alpha.EventFilter.Builder,
                com.google.cloud.functions.v2alpha.EventFilterOrBuilder>(
                eventFilters_, ((bitField0_ & 0x00000008) != 0), getParentForChildren(), isClean());
        eventFilters_ = null;
      }
      return eventFiltersBuilder_;
    }

    private java.lang.Object pubsubTopic_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The name of a Pub/Sub topic in the same project that will be used
     * as the transport topic for the event delivery. Format:
     * `projects/{project}/topics/{topic}`.
     *
     * This is only valid for events of type
     * `google.cloud.pubsub.topic.v1.messagePublished`. The topic provided here
     * will not be deleted at function deletion.
     * </pre>
     *
     * <code>
     * string pubsub_topic = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The pubsubTopic.
     */
    public java.lang.String getPubsubTopic() {
      java.lang.Object ref = pubsubTopic_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pubsubTopic_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of a Pub/Sub topic in the same project that will be used
     * as the transport topic for the event delivery. Format:
     * `projects/{project}/topics/{topic}`.
     *
     * This is only valid for events of type
     * `google.cloud.pubsub.topic.v1.messagePublished`. The topic provided here
     * will not be deleted at function deletion.
     * </pre>
     *
     * <code>
     * string pubsub_topic = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for pubsubTopic.
     */
    public com.google.protobuf.ByteString getPubsubTopicBytes() {
      java.lang.Object ref = pubsubTopic_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pubsubTopic_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of a Pub/Sub topic in the same project that will be used
     * as the transport topic for the event delivery. Format:
     * `projects/{project}/topics/{topic}`.
     *
     * This is only valid for events of type
     * `google.cloud.pubsub.topic.v1.messagePublished`. The topic provided here
     * will not be deleted at function deletion.
     * </pre>
     *
     * <code>
     * string pubsub_topic = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The pubsubTopic to set.
     * @return This builder for chaining.
     */
    public Builder setPubsubTopic(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      pubsubTopic_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of a Pub/Sub topic in the same project that will be used
     * as the transport topic for the event delivery. Format:
     * `projects/{project}/topics/{topic}`.
     *
     * This is only valid for events of type
     * `google.cloud.pubsub.topic.v1.messagePublished`. The topic provided here
     * will not be deleted at function deletion.
     * </pre>
     *
     * <code>
     * string pubsub_topic = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPubsubTopic() {
      pubsubTopic_ = getDefaultInstance().getPubsubTopic();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of a Pub/Sub topic in the same project that will be used
     * as the transport topic for the event delivery. Format:
     * `projects/{project}/topics/{topic}`.
     *
     * This is only valid for events of type
     * `google.cloud.pubsub.topic.v1.messagePublished`. The topic provided here
     * will not be deleted at function deletion.
     * </pre>
     *
     * <code>
     * string pubsub_topic = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for pubsubTopic to set.
     * @return This builder for chaining.
     */
    public Builder setPubsubTopicBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      pubsubTopic_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object serviceAccountEmail_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The email of the trigger's service account. The service account
     * must have permission to invoke Cloud Run services, the permission is
     * `run.routes.invoke`.
     * If empty, defaults to the Compute Engine default service account:
     * `{project_number}-compute&#64;developer.gserviceaccount.com`.
     * </pre>
     *
     * <code>string service_account_email = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The serviceAccountEmail.
     */
    public java.lang.String getServiceAccountEmail() {
      java.lang.Object ref = serviceAccountEmail_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceAccountEmail_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The email of the trigger's service account. The service account
     * must have permission to invoke Cloud Run services, the permission is
     * `run.routes.invoke`.
     * If empty, defaults to the Compute Engine default service account:
     * `{project_number}-compute&#64;developer.gserviceaccount.com`.
     * </pre>
     *
     * <code>string service_account_email = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for serviceAccountEmail.
     */
    public com.google.protobuf.ByteString getServiceAccountEmailBytes() {
      java.lang.Object ref = serviceAccountEmail_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceAccountEmail_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The email of the trigger's service account. The service account
     * must have permission to invoke Cloud Run services, the permission is
     * `run.routes.invoke`.
     * If empty, defaults to the Compute Engine default service account:
     * `{project_number}-compute&#64;developer.gserviceaccount.com`.
     * </pre>
     *
     * <code>string service_account_email = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The serviceAccountEmail to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccountEmail(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      serviceAccountEmail_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The email of the trigger's service account. The service account
     * must have permission to invoke Cloud Run services, the permission is
     * `run.routes.invoke`.
     * If empty, defaults to the Compute Engine default service account:
     * `{project_number}-compute&#64;developer.gserviceaccount.com`.
     * </pre>
     *
     * <code>string service_account_email = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServiceAccountEmail() {
      serviceAccountEmail_ = getDefaultInstance().getServiceAccountEmail();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The email of the trigger's service account. The service account
     * must have permission to invoke Cloud Run services, the permission is
     * `run.routes.invoke`.
     * If empty, defaults to the Compute Engine default service account:
     * `{project_number}-compute&#64;developer.gserviceaccount.com`.
     * </pre>
     *
     * <code>string service_account_email = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for serviceAccountEmail to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccountEmailBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      serviceAccountEmail_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private int retryPolicy_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. If unset, then defaults to ignoring failures (i.e. not retrying
     * them).
     * </pre>
     *
     * <code>
     * .google.cloud.functions.v2alpha.EventTrigger.RetryPolicy retry_policy = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for retryPolicy.
     */
    @java.lang.Override
    public int getRetryPolicyValue() {
      return retryPolicy_;
    }
    /**
     *
     *
     * <pre>
     * Optional. If unset, then defaults to ignoring failures (i.e. not retrying
     * them).
     * </pre>
     *
     * <code>
     * .google.cloud.functions.v2alpha.EventTrigger.RetryPolicy retry_policy = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for retryPolicy to set.
     * @return This builder for chaining.
     */
    public Builder setRetryPolicyValue(int value) {
      retryPolicy_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If unset, then defaults to ignoring failures (i.e. not retrying
     * them).
     * </pre>
     *
     * <code>
     * .google.cloud.functions.v2alpha.EventTrigger.RetryPolicy retry_policy = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The retryPolicy.
     */
    @java.lang.Override
    public com.google.cloud.functions.v2alpha.EventTrigger.RetryPolicy getRetryPolicy() {
      com.google.cloud.functions.v2alpha.EventTrigger.RetryPolicy result =
          com.google.cloud.functions.v2alpha.EventTrigger.RetryPolicy.forNumber(retryPolicy_);
      return result == null
          ? com.google.cloud.functions.v2alpha.EventTrigger.RetryPolicy.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Optional. If unset, then defaults to ignoring failures (i.e. not retrying
     * them).
     * </pre>
     *
     * <code>
     * .google.cloud.functions.v2alpha.EventTrigger.RetryPolicy retry_policy = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The retryPolicy to set.
     * @return This builder for chaining.
     */
    public Builder setRetryPolicy(
        com.google.cloud.functions.v2alpha.EventTrigger.RetryPolicy value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000040;
      retryPolicy_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If unset, then defaults to ignoring failures (i.e. not retrying
     * them).
     * </pre>
     *
     * <code>
     * .google.cloud.functions.v2alpha.EventTrigger.RetryPolicy retry_policy = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRetryPolicy() {
      bitField0_ = (bitField0_ & ~0x00000040);
      retryPolicy_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object channel_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The name of the channel associated with the trigger in
     * `projects/{project}/locations/{location}/channels/{channel}` format.
     * You must provide a channel to receive events from Eventarc SaaS partners.
     * </pre>
     *
     * <code>
     * string channel = 8 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The channel.
     */
    public java.lang.String getChannel() {
      java.lang.Object ref = channel_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        channel_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of the channel associated with the trigger in
     * `projects/{project}/locations/{location}/channels/{channel}` format.
     * You must provide a channel to receive events from Eventarc SaaS partners.
     * </pre>
     *
     * <code>
     * string channel = 8 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for channel.
     */
    public com.google.protobuf.ByteString getChannelBytes() {
      java.lang.Object ref = channel_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        channel_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of the channel associated with the trigger in
     * `projects/{project}/locations/{location}/channels/{channel}` format.
     * You must provide a channel to receive events from Eventarc SaaS partners.
     * </pre>
     *
     * <code>
     * string channel = 8 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The channel to set.
     * @return This builder for chaining.
     */
    public Builder setChannel(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      channel_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of the channel associated with the trigger in
     * `projects/{project}/locations/{location}/channels/{channel}` format.
     * You must provide a channel to receive events from Eventarc SaaS partners.
     * </pre>
     *
     * <code>
     * string channel = 8 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearChannel() {
      channel_ = getDefaultInstance().getChannel();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of the channel associated with the trigger in
     * `projects/{project}/locations/{location}/channels/{channel}` format.
     * You must provide a channel to receive events from Eventarc SaaS partners.
     * </pre>
     *
     * <code>
     * string channel = 8 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for channel to set.
     * @return This builder for chaining.
     */
    public Builder setChannelBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      channel_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private java.lang.Object service_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The hostname of the service that 1st Gen function should be
     * observed.
     *
     * If no string is provided, the default service implementing the API will
     * be used. For example, `storage.googleapis.com` is the default for all
     * event types in the `google.storage` namespace.
     *
     * The field is only applicable to 1st Gen functions.
     * </pre>
     *
     * <code>string service = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The service.
     */
    public java.lang.String getService() {
      java.lang.Object ref = service_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        service_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The hostname of the service that 1st Gen function should be
     * observed.
     *
     * If no string is provided, the default service implementing the API will
     * be used. For example, `storage.googleapis.com` is the default for all
     * event types in the `google.storage` namespace.
     *
     * The field is only applicable to 1st Gen functions.
     * </pre>
     *
     * <code>string service = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for service.
     */
    public com.google.protobuf.ByteString getServiceBytes() {
      java.lang.Object ref = service_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        service_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The hostname of the service that 1st Gen function should be
     * observed.
     *
     * If no string is provided, the default service implementing the API will
     * be used. For example, `storage.googleapis.com` is the default for all
     * event types in the `google.storage` namespace.
     *
     * The field is only applicable to 1st Gen functions.
     * </pre>
     *
     * <code>string service = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The service to set.
     * @return This builder for chaining.
     */
    public Builder setService(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      service_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The hostname of the service that 1st Gen function should be
     * observed.
     *
     * If no string is provided, the default service implementing the API will
     * be used. For example, `storage.googleapis.com` is the default for all
     * event types in the `google.storage` namespace.
     *
     * The field is only applicable to 1st Gen functions.
     * </pre>
     *
     * <code>string service = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearService() {
      service_ = getDefaultInstance().getService();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The hostname of the service that 1st Gen function should be
     * observed.
     *
     * If no string is provided, the default service implementing the API will
     * be used. For example, `storage.googleapis.com` is the default for all
     * event types in the `google.storage` namespace.
     *
     * The field is only applicable to 1st Gen functions.
     * </pre>
     *
     * <code>string service = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for service to set.
     * @return This builder for chaining.
     */
    public Builder setServiceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      service_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.functions.v2alpha.EventTrigger)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.functions.v2alpha.EventTrigger)
  private static final com.google.cloud.functions.v2alpha.EventTrigger DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.functions.v2alpha.EventTrigger();
  }

  public static com.google.cloud.functions.v2alpha.EventTrigger getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<EventTrigger> PARSER =
      new com.google.protobuf.AbstractParser<EventTrigger>() {
        @java.lang.Override
        public EventTrigger parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<EventTrigger> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<EventTrigger> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.functions.v2alpha.EventTrigger getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
