/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gaming.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GameServerClusterName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_REALM_CLUSTER = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/realms/{realm}/gameServerClusters/{cluster}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String realm;
    private final String cluster;

    @Deprecated
    protected GameServerClusterName() {
        this.project = null;
        this.location = null;
        this.realm = null;
        this.cluster = null;
    }

    private GameServerClusterName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.realm = (String)Preconditions.checkNotNull((Object)builder.getRealm());
        this.cluster = (String)Preconditions.checkNotNull((Object)builder.getCluster());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getRealm() {
        return this.realm;
    }

    public String getCluster() {
        return this.cluster;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static GameServerClusterName of(String project, String location, String realm, String cluster) {
        return GameServerClusterName.newBuilder().setProject(project).setLocation(location).setRealm(realm).setCluster(cluster).build();
    }

    public static String format(String project, String location, String realm, String cluster) {
        return GameServerClusterName.newBuilder().setProject(project).setLocation(location).setRealm(realm).setCluster(cluster).build().toString();
    }

    public static GameServerClusterName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_REALM_CLUSTER.validatedMatch(formattedString, "GameServerClusterName.parse: formattedString not in valid format");
        return GameServerClusterName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("realm"), (String)matchMap.get("cluster"));
    }

    public static List<GameServerClusterName> parseList(List<String> formattedStrings) {
        ArrayList<GameServerClusterName> list = new ArrayList<GameServerClusterName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(GameServerClusterName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<GameServerClusterName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (GameServerClusterName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_REALM_CLUSTER.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            GameServerClusterName gameServerClusterName = this;
            synchronized (gameServerClusterName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.realm != null) {
                        fieldMapBuilder.put((Object)"realm", (Object)this.realm);
                    }
                    if (this.cluster != null) {
                        fieldMapBuilder.put((Object)"cluster", (Object)this.cluster);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_REALM_CLUSTER.instantiate(new String[]{"project", this.project, "location", this.location, "realm", this.realm, "cluster", this.cluster});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            GameServerClusterName that = (GameServerClusterName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.realm, that.realm) && Objects.equals(this.cluster, that.cluster);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.realm);
        h *= 1000003;
        return h ^= Objects.hashCode(this.cluster);
    }

    public static class Builder {
        private String project;
        private String location;
        private String realm;
        private String cluster;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getRealm() {
            return this.realm;
        }

        public String getCluster() {
            return this.cluster;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setRealm(String realm) {
            this.realm = realm;
            return this;
        }

        public Builder setCluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        private Builder(GameServerClusterName gameServerClusterName) {
            this.project = gameServerClusterName.project;
            this.location = gameServerClusterName.location;
            this.realm = gameServerClusterName.realm;
            this.cluster = gameServerClusterName.cluster;
        }

        public GameServerClusterName build() {
            return new GameServerClusterName(this);
        }
    }
}

