/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gaming.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GameServerConfigName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_DEPLOYMENT_CONFIG = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/gameServerDeployments/{deployment}/configs/{config}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String deployment;
    private final String config;

    @Deprecated
    protected GameServerConfigName() {
        this.project = null;
        this.location = null;
        this.deployment = null;
        this.config = null;
    }

    private GameServerConfigName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.deployment = (String)Preconditions.checkNotNull((Object)builder.getDeployment());
        this.config = (String)Preconditions.checkNotNull((Object)builder.getConfig());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDeployment() {
        return this.deployment;
    }

    public String getConfig() {
        return this.config;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static GameServerConfigName of(String project, String location, String deployment, String config) {
        return GameServerConfigName.newBuilder().setProject(project).setLocation(location).setDeployment(deployment).setConfig(config).build();
    }

    public static String format(String project, String location, String deployment, String config) {
        return GameServerConfigName.newBuilder().setProject(project).setLocation(location).setDeployment(deployment).setConfig(config).build().toString();
    }

    public static GameServerConfigName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_DEPLOYMENT_CONFIG.validatedMatch(formattedString, "GameServerConfigName.parse: formattedString not in valid format");
        return GameServerConfigName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("deployment"), (String)matchMap.get("config"));
    }

    public static List<GameServerConfigName> parseList(List<String> formattedStrings) {
        ArrayList<GameServerConfigName> list = new ArrayList<GameServerConfigName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(GameServerConfigName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<GameServerConfigName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (GameServerConfigName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_DEPLOYMENT_CONFIG.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            GameServerConfigName gameServerConfigName = this;
            synchronized (gameServerConfigName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.deployment != null) {
                        fieldMapBuilder.put((Object)"deployment", (Object)this.deployment);
                    }
                    if (this.config != null) {
                        fieldMapBuilder.put((Object)"config", (Object)this.config);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_DEPLOYMENT_CONFIG.instantiate(new String[]{"project", this.project, "location", this.location, "deployment", this.deployment, "config", this.config});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            GameServerConfigName that = (GameServerConfigName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.deployment, that.deployment) && Objects.equals(this.config, that.config);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.deployment);
        h *= 1000003;
        return h ^= Objects.hashCode(this.config);
    }

    public static class Builder {
        private String project;
        private String location;
        private String deployment;
        private String config;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getDeployment() {
            return this.deployment;
        }

        public String getConfig() {
            return this.config;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setDeployment(String deployment) {
            this.deployment = deployment;
            return this;
        }

        public Builder setConfig(String config) {
            this.config = config;
            return this;
        }

        private Builder(GameServerConfigName gameServerConfigName) {
            this.project = gameServerConfigName.project;
            this.location = gameServerConfigName.location;
            this.deployment = gameServerConfigName.deployment;
            this.config = gameServerConfigName.config;
        }

        public GameServerConfigName build() {
            return new GameServerConfigName(this);
        }
    }
}

