/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gaming.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GameServerDeploymentName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_DEPLOYMENT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/gameServerDeployments/{deployment}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String deployment;

    @Deprecated
    protected GameServerDeploymentName() {
        this.project = null;
        this.location = null;
        this.deployment = null;
    }

    private GameServerDeploymentName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.deployment = (String)Preconditions.checkNotNull((Object)builder.getDeployment());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDeployment() {
        return this.deployment;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static GameServerDeploymentName of(String project, String location, String deployment) {
        return GameServerDeploymentName.newBuilder().setProject(project).setLocation(location).setDeployment(deployment).build();
    }

    public static String format(String project, String location, String deployment) {
        return GameServerDeploymentName.newBuilder().setProject(project).setLocation(location).setDeployment(deployment).build().toString();
    }

    public static GameServerDeploymentName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_DEPLOYMENT.validatedMatch(formattedString, "GameServerDeploymentName.parse: formattedString not in valid format");
        return GameServerDeploymentName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("deployment"));
    }

    public static List<GameServerDeploymentName> parseList(List<String> formattedStrings) {
        ArrayList<GameServerDeploymentName> list = new ArrayList<GameServerDeploymentName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(GameServerDeploymentName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<GameServerDeploymentName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (GameServerDeploymentName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_DEPLOYMENT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            GameServerDeploymentName gameServerDeploymentName = this;
            synchronized (gameServerDeploymentName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.deployment != null) {
                        fieldMapBuilder.put((Object)"deployment", (Object)this.deployment);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_DEPLOYMENT.instantiate(new String[]{"project", this.project, "location", this.location, "deployment", this.deployment});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            GameServerDeploymentName that = (GameServerDeploymentName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.deployment, that.deployment);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.deployment);
    }

    public static class Builder {
        private String project;
        private String location;
        private String deployment;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getDeployment() {
            return this.deployment;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setDeployment(String deployment) {
            this.deployment = deployment;
            return this;
        }

        private Builder(GameServerDeploymentName gameServerDeploymentName) {
            this.project = gameServerDeploymentName.project;
            this.location = gameServerDeploymentName.location;
            this.deployment = gameServerDeploymentName.deployment;
        }

        public GameServerDeploymentName build() {
            return new GameServerDeploymentName(this);
        }
    }
}

