/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gaming.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RealmName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_REALM = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/realms/{realm}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String realm;

    @Deprecated
    protected RealmName() {
        this.project = null;
        this.location = null;
        this.realm = null;
    }

    private RealmName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.realm = (String)Preconditions.checkNotNull((Object)builder.getRealm());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getRealm() {
        return this.realm;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static RealmName of(String project, String location, String realm) {
        return RealmName.newBuilder().setProject(project).setLocation(location).setRealm(realm).build();
    }

    public static String format(String project, String location, String realm) {
        return RealmName.newBuilder().setProject(project).setLocation(location).setRealm(realm).build().toString();
    }

    public static RealmName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_REALM.validatedMatch(formattedString, "RealmName.parse: formattedString not in valid format");
        return RealmName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("realm"));
    }

    public static List<RealmName> parseList(List<String> formattedStrings) {
        ArrayList<RealmName> list = new ArrayList<RealmName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(RealmName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<RealmName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (RealmName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_REALM.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            RealmName realmName = this;
            synchronized (realmName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.realm != null) {
                        fieldMapBuilder.put((Object)"realm", (Object)this.realm);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_REALM.instantiate(new String[]{"project", this.project, "location", this.location, "realm", this.realm});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            RealmName that = (RealmName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.realm, that.realm);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.realm);
    }

    public static class Builder {
        private String project;
        private String location;
        private String realm;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getRealm() {
            return this.realm;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setRealm(String realm) {
            this.realm = realm;
            return this;
        }

        private Builder(RealmName realmName) {
            this.project = realmName.project;
            this.location = realmName.location;
            this.realm = realmName.realm;
        }

        public RealmName build() {
            return new RealmName(this);
        }
    }
}

