/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/gaming/v1/common.proto

package com.google.cloud.gaming.v1;

/**
 *
 *
 * <pre>
 * Details of the deployed Agones fleet.
 * </pre>
 *
 * Protobuf type {@code google.cloud.gaming.v1.DeployedFleetDetails}
 */
public final class DeployedFleetDetails extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.gaming.v1.DeployedFleetDetails)
    DeployedFleetDetailsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use DeployedFleetDetails.newBuilder() to construct.
  private DeployedFleetDetails(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DeployedFleetDetails() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DeployedFleetDetails();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.gaming.v1.Common
        .internal_static_google_cloud_gaming_v1_DeployedFleetDetails_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.gaming.v1.Common
        .internal_static_google_cloud_gaming_v1_DeployedFleetDetails_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.gaming.v1.DeployedFleetDetails.class,
            com.google.cloud.gaming.v1.DeployedFleetDetails.Builder.class);
  }

  public interface DeployedFleetOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The name of the Agones fleet.
     * </pre>
     *
     * <code>string fleet = 1;</code>
     *
     * @return The fleet.
     */
    java.lang.String getFleet();
    /**
     *
     *
     * <pre>
     * The name of the Agones fleet.
     * </pre>
     *
     * <code>string fleet = 1;</code>
     *
     * @return The bytes for fleet.
     */
    com.google.protobuf.ByteString getFleetBytes();

    /**
     *
     *
     * <pre>
     * The fleet spec retrieved from the Agones fleet.
     * </pre>
     *
     * <code>string fleet_spec = 2;</code>
     *
     * @return The fleetSpec.
     */
    java.lang.String getFleetSpec();
    /**
     *
     *
     * <pre>
     * The fleet spec retrieved from the Agones fleet.
     * </pre>
     *
     * <code>string fleet_spec = 2;</code>
     *
     * @return The bytes for fleetSpec.
     */
    com.google.protobuf.ByteString getFleetSpecBytes();

    /**
     *
     *
     * <pre>
     * The source spec that is used to create the Agones fleet.
     * The GameServerConfig resource may no longer exist in the system.
     * </pre>
     *
     * <code>.google.cloud.gaming.v1.SpecSource spec_source = 3;</code>
     *
     * @return Whether the specSource field is set.
     */
    boolean hasSpecSource();
    /**
     *
     *
     * <pre>
     * The source spec that is used to create the Agones fleet.
     * The GameServerConfig resource may no longer exist in the system.
     * </pre>
     *
     * <code>.google.cloud.gaming.v1.SpecSource spec_source = 3;</code>
     *
     * @return The specSource.
     */
    com.google.cloud.gaming.v1.SpecSource getSpecSource();
    /**
     *
     *
     * <pre>
     * The source spec that is used to create the Agones fleet.
     * The GameServerConfig resource may no longer exist in the system.
     * </pre>
     *
     * <code>.google.cloud.gaming.v1.SpecSource spec_source = 3;</code>
     */
    com.google.cloud.gaming.v1.SpecSourceOrBuilder getSpecSourceOrBuilder();

    /**
     *
     *
     * <pre>
     * The current status of the Agones fleet.
     * Includes count of game servers in various states.
     * </pre>
     *
     * <code>
     * .google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.DeployedFleetStatus status = 5;
     * </code>
     *
     * @return Whether the status field is set.
     */
    boolean hasStatus();
    /**
     *
     *
     * <pre>
     * The current status of the Agones fleet.
     * Includes count of game servers in various states.
     * </pre>
     *
     * <code>
     * .google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.DeployedFleetStatus status = 5;
     * </code>
     *
     * @return The status.
     */
    com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.DeployedFleetStatus getStatus();
    /**
     *
     *
     * <pre>
     * The current status of the Agones fleet.
     * Includes count of game servers in various states.
     * </pre>
     *
     * <code>
     * .google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.DeployedFleetStatus status = 5;
     * </code>
     */
    com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.DeployedFleetStatusOrBuilder
        getStatusOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Agones fleet specification and details.
   * </pre>
   *
   * Protobuf type {@code google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet}
   */
  public static final class DeployedFleet extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet)
      DeployedFleetOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use DeployedFleet.newBuilder() to construct.
    private DeployedFleet(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private DeployedFleet() {
      fleet_ = "";
      fleetSpec_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new DeployedFleet();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.gaming.v1.Common
          .internal_static_google_cloud_gaming_v1_DeployedFleetDetails_DeployedFleet_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.gaming.v1.Common
          .internal_static_google_cloud_gaming_v1_DeployedFleetDetails_DeployedFleet_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.class,
              com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.Builder.class);
    }

    public interface DeployedFleetStatusOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.DeployedFleetStatus)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * The number of GameServer replicas in the READY state in this fleet.
       * </pre>
       *
       * <code>int64 ready_replicas = 1;</code>
       *
       * @return The readyReplicas.
       */
      long getReadyReplicas();

      /**
       *
       *
       * <pre>
       * The number of GameServer replicas in the ALLOCATED state in this fleet.
       * </pre>
       *
       * <code>int64 allocated_replicas = 2;</code>
       *
       * @return The allocatedReplicas.
       */
      long getAllocatedReplicas();

      /**
       *
       *
       * <pre>
       * The number of GameServer replicas in the RESERVED state in this fleet.
       * Reserved instances won't be deleted on scale down, but won't cause
       * an autoscaler to scale up.
       * </pre>
       *
       * <code>int64 reserved_replicas = 3;</code>
       *
       * @return The reservedReplicas.
       */
      long getReservedReplicas();

      /**
       *
       *
       * <pre>
       * The total number of current GameServer replicas in this fleet.
       * </pre>
       *
       * <code>int64 replicas = 4;</code>
       *
       * @return The replicas.
       */
      long getReplicas();
    }
    /**
     *
     *
     * <pre>
     * DeployedFleetStatus has details about the Agones fleets such as how many
     * are running, how many allocated, and so on.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.DeployedFleetStatus}
     */
    public static final class DeployedFleetStatus extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.DeployedFleetStatus)
        DeployedFleetStatusOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use DeployedFleetStatus.newBuilder() to construct.
      private DeployedFleetStatus(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private DeployedFleetStatus() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new DeployedFleetStatus();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.gaming.v1.Common
            .internal_static_google_cloud_gaming_v1_DeployedFleetDetails_DeployedFleet_DeployedFleetStatus_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.gaming.v1.Common
            .internal_static_google_cloud_gaming_v1_DeployedFleetDetails_DeployedFleet_DeployedFleetStatus_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.DeployedFleetStatus
                    .class,
                com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.DeployedFleetStatus
                    .Builder.class);
      }

      public static final int READY_REPLICAS_FIELD_NUMBER = 1;
      private long readyReplicas_ = 0L;
      /**
       *
       *
       * <pre>
       * The number of GameServer replicas in the READY state in this fleet.
       * </pre>
       *
       * <code>int64 ready_replicas = 1;</code>
       *
       * @return The readyReplicas.
       */
      @java.lang.Override
      public long getReadyReplicas() {
        return readyReplicas_;
      }

      public static final int ALLOCATED_REPLICAS_FIELD_NUMBER = 2;
      private long allocatedReplicas_ = 0L;
      /**
       *
       *
       * <pre>
       * The number of GameServer replicas in the ALLOCATED state in this fleet.
       * </pre>
       *
       * <code>int64 allocated_replicas = 2;</code>
       *
       * @return The allocatedReplicas.
       */
      @java.lang.Override
      public long getAllocatedReplicas() {
        return allocatedReplicas_;
      }

      public static final int RESERVED_REPLICAS_FIELD_NUMBER = 3;
      private long reservedReplicas_ = 0L;
      /**
       *
       *
       * <pre>
       * The number of GameServer replicas in the RESERVED state in this fleet.
       * Reserved instances won't be deleted on scale down, but won't cause
       * an autoscaler to scale up.
       * </pre>
       *
       * <code>int64 reserved_replicas = 3;</code>
       *
       * @return The reservedReplicas.
       */
      @java.lang.Override
      public long getReservedReplicas() {
        return reservedReplicas_;
      }

      public static final int REPLICAS_FIELD_NUMBER = 4;
      private long replicas_ = 0L;
      /**
       *
       *
       * <pre>
       * The total number of current GameServer replicas in this fleet.
       * </pre>
       *
       * <code>int64 replicas = 4;</code>
       *
       * @return The replicas.
       */
      @java.lang.Override
      public long getReplicas() {
        return replicas_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (readyReplicas_ != 0L) {
          output.writeInt64(1, readyReplicas_);
        }
        if (allocatedReplicas_ != 0L) {
          output.writeInt64(2, allocatedReplicas_);
        }
        if (reservedReplicas_ != 0L) {
          output.writeInt64(3, reservedReplicas_);
        }
        if (replicas_ != 0L) {
          output.writeInt64(4, replicas_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (readyReplicas_ != 0L) {
          size += com.google.protobuf.CodedOutputStream.computeInt64Size(1, readyReplicas_);
        }
        if (allocatedReplicas_ != 0L) {
          size += com.google.protobuf.CodedOutputStream.computeInt64Size(2, allocatedReplicas_);
        }
        if (reservedReplicas_ != 0L) {
          size += com.google.protobuf.CodedOutputStream.computeInt64Size(3, reservedReplicas_);
        }
        if (replicas_ != 0L) {
          size += com.google.protobuf.CodedOutputStream.computeInt64Size(4, replicas_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.DeployedFleetStatus)) {
          return super.equals(obj);
        }
        com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.DeployedFleetStatus other =
            (com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.DeployedFleetStatus) obj;

        if (getReadyReplicas() != other.getReadyReplicas()) return false;
        if (getAllocatedReplicas() != other.getAllocatedReplicas()) return false;
        if (getReservedReplicas() != other.getReservedReplicas()) return false;
        if (getReplicas() != other.getReplicas()) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + READY_REPLICAS_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getReadyReplicas());
        hash = (37 * hash) + ALLOCATED_REPLICAS_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getAllocatedReplicas());
        hash = (37 * hash) + RESERVED_REPLICAS_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getReservedReplicas());
        hash = (37 * hash) + REPLICAS_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getReplicas());
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet
              .DeployedFleetStatus
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet
              .DeployedFleetStatus
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet
              .DeployedFleetStatus
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet
              .DeployedFleetStatus
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet
              .DeployedFleetStatus
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet
              .DeployedFleetStatus
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet
              .DeployedFleetStatus
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet
              .DeployedFleetStatus
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet
              .DeployedFleetStatus
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet
              .DeployedFleetStatus
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet
              .DeployedFleetStatus
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet
              .DeployedFleetStatus
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.DeployedFleetStatus
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * DeployedFleetStatus has details about the Agones fleets such as how many
       * are running, how many allocated, and so on.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.DeployedFleetStatus}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.DeployedFleetStatus)
          com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet
              .DeployedFleetStatusOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.gaming.v1.Common
              .internal_static_google_cloud_gaming_v1_DeployedFleetDetails_DeployedFleet_DeployedFleetStatus_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.gaming.v1.Common
              .internal_static_google_cloud_gaming_v1_DeployedFleetDetails_DeployedFleet_DeployedFleetStatus_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.DeployedFleetStatus
                      .class,
                  com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.DeployedFleetStatus
                      .Builder.class);
        }

        // Construct using
        // com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.DeployedFleetStatus.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          readyReplicas_ = 0L;
          allocatedReplicas_ = 0L;
          reservedReplicas_ = 0L;
          replicas_ = 0L;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.gaming.v1.Common
              .internal_static_google_cloud_gaming_v1_DeployedFleetDetails_DeployedFleet_DeployedFleetStatus_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.DeployedFleetStatus
            getDefaultInstanceForType() {
          return com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.DeployedFleetStatus
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.DeployedFleetStatus
            build() {
          com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.DeployedFleetStatus result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.DeployedFleetStatus
            buildPartial() {
          com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.DeployedFleetStatus result =
              new com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.DeployedFleetStatus(
                  this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.DeployedFleetStatus
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.readyReplicas_ = readyReplicas_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.allocatedReplicas_ = allocatedReplicas_;
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.reservedReplicas_ = reservedReplicas_;
          }
          if (((from_bitField0_ & 0x00000008) != 0)) {
            result.replicas_ = replicas_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.DeployedFleetStatus) {
            return mergeFrom(
                (com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.DeployedFleetStatus)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.DeployedFleetStatus
                other) {
          if (other
              == com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.DeployedFleetStatus
                  .getDefaultInstance()) return this;
          if (other.getReadyReplicas() != 0L) {
            setReadyReplicas(other.getReadyReplicas());
          }
          if (other.getAllocatedReplicas() != 0L) {
            setAllocatedReplicas(other.getAllocatedReplicas());
          }
          if (other.getReservedReplicas() != 0L) {
            setReservedReplicas(other.getReservedReplicas());
          }
          if (other.getReplicas() != 0L) {
            setReplicas(other.getReplicas());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 8:
                  {
                    readyReplicas_ = input.readInt64();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 8
                case 16:
                  {
                    allocatedReplicas_ = input.readInt64();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 16
                case 24:
                  {
                    reservedReplicas_ = input.readInt64();
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 24
                case 32:
                  {
                    replicas_ = input.readInt64();
                    bitField0_ |= 0x00000008;
                    break;
                  } // case 32
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private long readyReplicas_;
        /**
         *
         *
         * <pre>
         * The number of GameServer replicas in the READY state in this fleet.
         * </pre>
         *
         * <code>int64 ready_replicas = 1;</code>
         *
         * @return The readyReplicas.
         */
        @java.lang.Override
        public long getReadyReplicas() {
          return readyReplicas_;
        }
        /**
         *
         *
         * <pre>
         * The number of GameServer replicas in the READY state in this fleet.
         * </pre>
         *
         * <code>int64 ready_replicas = 1;</code>
         *
         * @param value The readyReplicas to set.
         * @return This builder for chaining.
         */
        public Builder setReadyReplicas(long value) {

          readyReplicas_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The number of GameServer replicas in the READY state in this fleet.
         * </pre>
         *
         * <code>int64 ready_replicas = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearReadyReplicas() {
          bitField0_ = (bitField0_ & ~0x00000001);
          readyReplicas_ = 0L;
          onChanged();
          return this;
        }

        private long allocatedReplicas_;
        /**
         *
         *
         * <pre>
         * The number of GameServer replicas in the ALLOCATED state in this fleet.
         * </pre>
         *
         * <code>int64 allocated_replicas = 2;</code>
         *
         * @return The allocatedReplicas.
         */
        @java.lang.Override
        public long getAllocatedReplicas() {
          return allocatedReplicas_;
        }
        /**
         *
         *
         * <pre>
         * The number of GameServer replicas in the ALLOCATED state in this fleet.
         * </pre>
         *
         * <code>int64 allocated_replicas = 2;</code>
         *
         * @param value The allocatedReplicas to set.
         * @return This builder for chaining.
         */
        public Builder setAllocatedReplicas(long value) {

          allocatedReplicas_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The number of GameServer replicas in the ALLOCATED state in this fleet.
         * </pre>
         *
         * <code>int64 allocated_replicas = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearAllocatedReplicas() {
          bitField0_ = (bitField0_ & ~0x00000002);
          allocatedReplicas_ = 0L;
          onChanged();
          return this;
        }

        private long reservedReplicas_;
        /**
         *
         *
         * <pre>
         * The number of GameServer replicas in the RESERVED state in this fleet.
         * Reserved instances won't be deleted on scale down, but won't cause
         * an autoscaler to scale up.
         * </pre>
         *
         * <code>int64 reserved_replicas = 3;</code>
         *
         * @return The reservedReplicas.
         */
        @java.lang.Override
        public long getReservedReplicas() {
          return reservedReplicas_;
        }
        /**
         *
         *
         * <pre>
         * The number of GameServer replicas in the RESERVED state in this fleet.
         * Reserved instances won't be deleted on scale down, but won't cause
         * an autoscaler to scale up.
         * </pre>
         *
         * <code>int64 reserved_replicas = 3;</code>
         *
         * @param value The reservedReplicas to set.
         * @return This builder for chaining.
         */
        public Builder setReservedReplicas(long value) {

          reservedReplicas_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The number of GameServer replicas in the RESERVED state in this fleet.
         * Reserved instances won't be deleted on scale down, but won't cause
         * an autoscaler to scale up.
         * </pre>
         *
         * <code>int64 reserved_replicas = 3;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearReservedReplicas() {
          bitField0_ = (bitField0_ & ~0x00000004);
          reservedReplicas_ = 0L;
          onChanged();
          return this;
        }

        private long replicas_;
        /**
         *
         *
         * <pre>
         * The total number of current GameServer replicas in this fleet.
         * </pre>
         *
         * <code>int64 replicas = 4;</code>
         *
         * @return The replicas.
         */
        @java.lang.Override
        public long getReplicas() {
          return replicas_;
        }
        /**
         *
         *
         * <pre>
         * The total number of current GameServer replicas in this fleet.
         * </pre>
         *
         * <code>int64 replicas = 4;</code>
         *
         * @param value The replicas to set.
         * @return This builder for chaining.
         */
        public Builder setReplicas(long value) {

          replicas_ = value;
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The total number of current GameServer replicas in this fleet.
         * </pre>
         *
         * <code>int64 replicas = 4;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearReplicas() {
          bitField0_ = (bitField0_ & ~0x00000008);
          replicas_ = 0L;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.DeployedFleetStatus)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.DeployedFleetStatus)
      private static final com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet
              .DeployedFleetStatus
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.DeployedFleetStatus();
      }

      public static com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet
              .DeployedFleetStatus
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<DeployedFleetStatus> PARSER =
          new com.google.protobuf.AbstractParser<DeployedFleetStatus>() {
            @java.lang.Override
            public DeployedFleetStatus parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<DeployedFleetStatus> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<DeployedFleetStatus> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.DeployedFleetStatus
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public static final int FLEET_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object fleet_ = "";
    /**
     *
     *
     * <pre>
     * The name of the Agones fleet.
     * </pre>
     *
     * <code>string fleet = 1;</code>
     *
     * @return The fleet.
     */
    @java.lang.Override
    public java.lang.String getFleet() {
      java.lang.Object ref = fleet_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        fleet_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the Agones fleet.
     * </pre>
     *
     * <code>string fleet = 1;</code>
     *
     * @return The bytes for fleet.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getFleetBytes() {
      java.lang.Object ref = fleet_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        fleet_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int FLEET_SPEC_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object fleetSpec_ = "";
    /**
     *
     *
     * <pre>
     * The fleet spec retrieved from the Agones fleet.
     * </pre>
     *
     * <code>string fleet_spec = 2;</code>
     *
     * @return The fleetSpec.
     */
    @java.lang.Override
    public java.lang.String getFleetSpec() {
      java.lang.Object ref = fleetSpec_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        fleetSpec_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The fleet spec retrieved from the Agones fleet.
     * </pre>
     *
     * <code>string fleet_spec = 2;</code>
     *
     * @return The bytes for fleetSpec.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getFleetSpecBytes() {
      java.lang.Object ref = fleetSpec_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        fleetSpec_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SPEC_SOURCE_FIELD_NUMBER = 3;
    private com.google.cloud.gaming.v1.SpecSource specSource_;
    /**
     *
     *
     * <pre>
     * The source spec that is used to create the Agones fleet.
     * The GameServerConfig resource may no longer exist in the system.
     * </pre>
     *
     * <code>.google.cloud.gaming.v1.SpecSource spec_source = 3;</code>
     *
     * @return Whether the specSource field is set.
     */
    @java.lang.Override
    public boolean hasSpecSource() {
      return specSource_ != null;
    }
    /**
     *
     *
     * <pre>
     * The source spec that is used to create the Agones fleet.
     * The GameServerConfig resource may no longer exist in the system.
     * </pre>
     *
     * <code>.google.cloud.gaming.v1.SpecSource spec_source = 3;</code>
     *
     * @return The specSource.
     */
    @java.lang.Override
    public com.google.cloud.gaming.v1.SpecSource getSpecSource() {
      return specSource_ == null
          ? com.google.cloud.gaming.v1.SpecSource.getDefaultInstance()
          : specSource_;
    }
    /**
     *
     *
     * <pre>
     * The source spec that is used to create the Agones fleet.
     * The GameServerConfig resource may no longer exist in the system.
     * </pre>
     *
     * <code>.google.cloud.gaming.v1.SpecSource spec_source = 3;</code>
     */
    @java.lang.Override
    public com.google.cloud.gaming.v1.SpecSourceOrBuilder getSpecSourceOrBuilder() {
      return specSource_ == null
          ? com.google.cloud.gaming.v1.SpecSource.getDefaultInstance()
          : specSource_;
    }

    public static final int STATUS_FIELD_NUMBER = 5;
    private com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.DeployedFleetStatus
        status_;
    /**
     *
     *
     * <pre>
     * The current status of the Agones fleet.
     * Includes count of game servers in various states.
     * </pre>
     *
     * <code>
     * .google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.DeployedFleetStatus status = 5;
     * </code>
     *
     * @return Whether the status field is set.
     */
    @java.lang.Override
    public boolean hasStatus() {
      return status_ != null;
    }
    /**
     *
     *
     * <pre>
     * The current status of the Agones fleet.
     * Includes count of game servers in various states.
     * </pre>
     *
     * <code>
     * .google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.DeployedFleetStatus status = 5;
     * </code>
     *
     * @return The status.
     */
    @java.lang.Override
    public com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.DeployedFleetStatus
        getStatus() {
      return status_ == null
          ? com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.DeployedFleetStatus
              .getDefaultInstance()
          : status_;
    }
    /**
     *
     *
     * <pre>
     * The current status of the Agones fleet.
     * Includes count of game servers in various states.
     * </pre>
     *
     * <code>
     * .google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.DeployedFleetStatus status = 5;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet
            .DeployedFleetStatusOrBuilder
        getStatusOrBuilder() {
      return status_ == null
          ? com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.DeployedFleetStatus
              .getDefaultInstance()
          : status_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fleet_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, fleet_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fleetSpec_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, fleetSpec_);
      }
      if (specSource_ != null) {
        output.writeMessage(3, getSpecSource());
      }
      if (status_ != null) {
        output.writeMessage(5, getStatus());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fleet_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, fleet_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fleetSpec_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, fleetSpec_);
      }
      if (specSource_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getSpecSource());
      }
      if (status_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getStatus());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet)) {
        return super.equals(obj);
      }
      com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet other =
          (com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet) obj;

      if (!getFleet().equals(other.getFleet())) return false;
      if (!getFleetSpec().equals(other.getFleetSpec())) return false;
      if (hasSpecSource() != other.hasSpecSource()) return false;
      if (hasSpecSource()) {
        if (!getSpecSource().equals(other.getSpecSource())) return false;
      }
      if (hasStatus() != other.hasStatus()) return false;
      if (hasStatus()) {
        if (!getStatus().equals(other.getStatus())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + FLEET_FIELD_NUMBER;
      hash = (53 * hash) + getFleet().hashCode();
      hash = (37 * hash) + FLEET_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getFleetSpec().hashCode();
      if (hasSpecSource()) {
        hash = (37 * hash) + SPEC_SOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getSpecSource().hashCode();
      }
      if (hasStatus()) {
        hash = (37 * hash) + STATUS_FIELD_NUMBER;
        hash = (53 * hash) + getStatus().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Agones fleet specification and details.
     * </pre>
     *
     * Protobuf type {@code google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet)
        com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.gaming.v1.Common
            .internal_static_google_cloud_gaming_v1_DeployedFleetDetails_DeployedFleet_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.gaming.v1.Common
            .internal_static_google_cloud_gaming_v1_DeployedFleetDetails_DeployedFleet_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.class,
                com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.Builder.class);
      }

      // Construct using com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        fleet_ = "";
        fleetSpec_ = "";
        specSource_ = null;
        if (specSourceBuilder_ != null) {
          specSourceBuilder_.dispose();
          specSourceBuilder_ = null;
        }
        status_ = null;
        if (statusBuilder_ != null) {
          statusBuilder_.dispose();
          statusBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.gaming.v1.Common
            .internal_static_google_cloud_gaming_v1_DeployedFleetDetails_DeployedFleet_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet
          getDefaultInstanceForType() {
        return com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet build() {
        com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet buildPartial() {
        com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet result =
            new com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.fleet_ = fleet_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.fleetSpec_ = fleetSpec_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.specSource_ =
              specSourceBuilder_ == null ? specSource_ : specSourceBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.status_ = statusBuilder_ == null ? status_ : statusBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet) {
          return mergeFrom((com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet other) {
        if (other
            == com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.getDefaultInstance())
          return this;
        if (!other.getFleet().isEmpty()) {
          fleet_ = other.fleet_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getFleetSpec().isEmpty()) {
          fleetSpec_ = other.fleetSpec_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (other.hasSpecSource()) {
          mergeSpecSource(other.getSpecSource());
        }
        if (other.hasStatus()) {
          mergeStatus(other.getStatus());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  fleet_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  fleetSpec_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(getSpecSourceFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 42:
                {
                  input.readMessage(getStatusFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000008;
                  break;
                } // case 42
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object fleet_ = "";
      /**
       *
       *
       * <pre>
       * The name of the Agones fleet.
       * </pre>
       *
       * <code>string fleet = 1;</code>
       *
       * @return The fleet.
       */
      public java.lang.String getFleet() {
        java.lang.Object ref = fleet_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          fleet_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the Agones fleet.
       * </pre>
       *
       * <code>string fleet = 1;</code>
       *
       * @return The bytes for fleet.
       */
      public com.google.protobuf.ByteString getFleetBytes() {
        java.lang.Object ref = fleet_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          fleet_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the Agones fleet.
       * </pre>
       *
       * <code>string fleet = 1;</code>
       *
       * @param value The fleet to set.
       * @return This builder for chaining.
       */
      public Builder setFleet(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        fleet_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of the Agones fleet.
       * </pre>
       *
       * <code>string fleet = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFleet() {
        fleet_ = getDefaultInstance().getFleet();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of the Agones fleet.
       * </pre>
       *
       * <code>string fleet = 1;</code>
       *
       * @param value The bytes for fleet to set.
       * @return This builder for chaining.
       */
      public Builder setFleetBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        fleet_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object fleetSpec_ = "";
      /**
       *
       *
       * <pre>
       * The fleet spec retrieved from the Agones fleet.
       * </pre>
       *
       * <code>string fleet_spec = 2;</code>
       *
       * @return The fleetSpec.
       */
      public java.lang.String getFleetSpec() {
        java.lang.Object ref = fleetSpec_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          fleetSpec_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The fleet spec retrieved from the Agones fleet.
       * </pre>
       *
       * <code>string fleet_spec = 2;</code>
       *
       * @return The bytes for fleetSpec.
       */
      public com.google.protobuf.ByteString getFleetSpecBytes() {
        java.lang.Object ref = fleetSpec_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          fleetSpec_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The fleet spec retrieved from the Agones fleet.
       * </pre>
       *
       * <code>string fleet_spec = 2;</code>
       *
       * @param value The fleetSpec to set.
       * @return This builder for chaining.
       */
      public Builder setFleetSpec(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        fleetSpec_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The fleet spec retrieved from the Agones fleet.
       * </pre>
       *
       * <code>string fleet_spec = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFleetSpec() {
        fleetSpec_ = getDefaultInstance().getFleetSpec();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The fleet spec retrieved from the Agones fleet.
       * </pre>
       *
       * <code>string fleet_spec = 2;</code>
       *
       * @param value The bytes for fleetSpec to set.
       * @return This builder for chaining.
       */
      public Builder setFleetSpecBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        fleetSpec_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private com.google.cloud.gaming.v1.SpecSource specSource_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.gaming.v1.SpecSource,
              com.google.cloud.gaming.v1.SpecSource.Builder,
              com.google.cloud.gaming.v1.SpecSourceOrBuilder>
          specSourceBuilder_;
      /**
       *
       *
       * <pre>
       * The source spec that is used to create the Agones fleet.
       * The GameServerConfig resource may no longer exist in the system.
       * </pre>
       *
       * <code>.google.cloud.gaming.v1.SpecSource spec_source = 3;</code>
       *
       * @return Whether the specSource field is set.
       */
      public boolean hasSpecSource() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * The source spec that is used to create the Agones fleet.
       * The GameServerConfig resource may no longer exist in the system.
       * </pre>
       *
       * <code>.google.cloud.gaming.v1.SpecSource spec_source = 3;</code>
       *
       * @return The specSource.
       */
      public com.google.cloud.gaming.v1.SpecSource getSpecSource() {
        if (specSourceBuilder_ == null) {
          return specSource_ == null
              ? com.google.cloud.gaming.v1.SpecSource.getDefaultInstance()
              : specSource_;
        } else {
          return specSourceBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The source spec that is used to create the Agones fleet.
       * The GameServerConfig resource may no longer exist in the system.
       * </pre>
       *
       * <code>.google.cloud.gaming.v1.SpecSource spec_source = 3;</code>
       */
      public Builder setSpecSource(com.google.cloud.gaming.v1.SpecSource value) {
        if (specSourceBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          specSource_ = value;
        } else {
          specSourceBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The source spec that is used to create the Agones fleet.
       * The GameServerConfig resource may no longer exist in the system.
       * </pre>
       *
       * <code>.google.cloud.gaming.v1.SpecSource spec_source = 3;</code>
       */
      public Builder setSpecSource(com.google.cloud.gaming.v1.SpecSource.Builder builderForValue) {
        if (specSourceBuilder_ == null) {
          specSource_ = builderForValue.build();
        } else {
          specSourceBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The source spec that is used to create the Agones fleet.
       * The GameServerConfig resource may no longer exist in the system.
       * </pre>
       *
       * <code>.google.cloud.gaming.v1.SpecSource spec_source = 3;</code>
       */
      public Builder mergeSpecSource(com.google.cloud.gaming.v1.SpecSource value) {
        if (specSourceBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && specSource_ != null
              && specSource_ != com.google.cloud.gaming.v1.SpecSource.getDefaultInstance()) {
            getSpecSourceBuilder().mergeFrom(value);
          } else {
            specSource_ = value;
          }
        } else {
          specSourceBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The source spec that is used to create the Agones fleet.
       * The GameServerConfig resource may no longer exist in the system.
       * </pre>
       *
       * <code>.google.cloud.gaming.v1.SpecSource spec_source = 3;</code>
       */
      public Builder clearSpecSource() {
        bitField0_ = (bitField0_ & ~0x00000004);
        specSource_ = null;
        if (specSourceBuilder_ != null) {
          specSourceBuilder_.dispose();
          specSourceBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The source spec that is used to create the Agones fleet.
       * The GameServerConfig resource may no longer exist in the system.
       * </pre>
       *
       * <code>.google.cloud.gaming.v1.SpecSource spec_source = 3;</code>
       */
      public com.google.cloud.gaming.v1.SpecSource.Builder getSpecSourceBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getSpecSourceFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The source spec that is used to create the Agones fleet.
       * The GameServerConfig resource may no longer exist in the system.
       * </pre>
       *
       * <code>.google.cloud.gaming.v1.SpecSource spec_source = 3;</code>
       */
      public com.google.cloud.gaming.v1.SpecSourceOrBuilder getSpecSourceOrBuilder() {
        if (specSourceBuilder_ != null) {
          return specSourceBuilder_.getMessageOrBuilder();
        } else {
          return specSource_ == null
              ? com.google.cloud.gaming.v1.SpecSource.getDefaultInstance()
              : specSource_;
        }
      }
      /**
       *
       *
       * <pre>
       * The source spec that is used to create the Agones fleet.
       * The GameServerConfig resource may no longer exist in the system.
       * </pre>
       *
       * <code>.google.cloud.gaming.v1.SpecSource spec_source = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.gaming.v1.SpecSource,
              com.google.cloud.gaming.v1.SpecSource.Builder,
              com.google.cloud.gaming.v1.SpecSourceOrBuilder>
          getSpecSourceFieldBuilder() {
        if (specSourceBuilder_ == null) {
          specSourceBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.gaming.v1.SpecSource,
                  com.google.cloud.gaming.v1.SpecSource.Builder,
                  com.google.cloud.gaming.v1.SpecSourceOrBuilder>(
                  getSpecSource(), getParentForChildren(), isClean());
          specSource_ = null;
        }
        return specSourceBuilder_;
      }

      private com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.DeployedFleetStatus
          status_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.DeployedFleetStatus,
              com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.DeployedFleetStatus
                  .Builder,
              com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet
                  .DeployedFleetStatusOrBuilder>
          statusBuilder_;
      /**
       *
       *
       * <pre>
       * The current status of the Agones fleet.
       * Includes count of game servers in various states.
       * </pre>
       *
       * <code>
       * .google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.DeployedFleetStatus status = 5;
       * </code>
       *
       * @return Whether the status field is set.
       */
      public boolean hasStatus() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       *
       *
       * <pre>
       * The current status of the Agones fleet.
       * Includes count of game servers in various states.
       * </pre>
       *
       * <code>
       * .google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.DeployedFleetStatus status = 5;
       * </code>
       *
       * @return The status.
       */
      public com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.DeployedFleetStatus
          getStatus() {
        if (statusBuilder_ == null) {
          return status_ == null
              ? com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.DeployedFleetStatus
                  .getDefaultInstance()
              : status_;
        } else {
          return statusBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The current status of the Agones fleet.
       * Includes count of game servers in various states.
       * </pre>
       *
       * <code>
       * .google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.DeployedFleetStatus status = 5;
       * </code>
       */
      public Builder setStatus(
          com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.DeployedFleetStatus value) {
        if (statusBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          status_ = value;
        } else {
          statusBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The current status of the Agones fleet.
       * Includes count of game servers in various states.
       * </pre>
       *
       * <code>
       * .google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.DeployedFleetStatus status = 5;
       * </code>
       */
      public Builder setStatus(
          com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.DeployedFleetStatus.Builder
              builderForValue) {
        if (statusBuilder_ == null) {
          status_ = builderForValue.build();
        } else {
          statusBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The current status of the Agones fleet.
       * Includes count of game servers in various states.
       * </pre>
       *
       * <code>
       * .google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.DeployedFleetStatus status = 5;
       * </code>
       */
      public Builder mergeStatus(
          com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.DeployedFleetStatus value) {
        if (statusBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0)
              && status_ != null
              && status_
                  != com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet
                      .DeployedFleetStatus.getDefaultInstance()) {
            getStatusBuilder().mergeFrom(value);
          } else {
            status_ = value;
          }
        } else {
          statusBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The current status of the Agones fleet.
       * Includes count of game servers in various states.
       * </pre>
       *
       * <code>
       * .google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.DeployedFleetStatus status = 5;
       * </code>
       */
      public Builder clearStatus() {
        bitField0_ = (bitField0_ & ~0x00000008);
        status_ = null;
        if (statusBuilder_ != null) {
          statusBuilder_.dispose();
          statusBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The current status of the Agones fleet.
       * Includes count of game servers in various states.
       * </pre>
       *
       * <code>
       * .google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.DeployedFleetStatus status = 5;
       * </code>
       */
      public com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.DeployedFleetStatus
              .Builder
          getStatusBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return getStatusFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The current status of the Agones fleet.
       * Includes count of game servers in various states.
       * </pre>
       *
       * <code>
       * .google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.DeployedFleetStatus status = 5;
       * </code>
       */
      public com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet
              .DeployedFleetStatusOrBuilder
          getStatusOrBuilder() {
        if (statusBuilder_ != null) {
          return statusBuilder_.getMessageOrBuilder();
        } else {
          return status_ == null
              ? com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.DeployedFleetStatus
                  .getDefaultInstance()
              : status_;
        }
      }
      /**
       *
       *
       * <pre>
       * The current status of the Agones fleet.
       * Includes count of game servers in various states.
       * </pre>
       *
       * <code>
       * .google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.DeployedFleetStatus status = 5;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.DeployedFleetStatus,
              com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.DeployedFleetStatus
                  .Builder,
              com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet
                  .DeployedFleetStatusOrBuilder>
          getStatusFieldBuilder() {
        if (statusBuilder_ == null) {
          statusBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.DeployedFleetStatus,
                  com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.DeployedFleetStatus
                      .Builder,
                  com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet
                      .DeployedFleetStatusOrBuilder>(
                  getStatus(), getParentForChildren(), isClean());
          status_ = null;
        }
        return statusBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet)
    private static final com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet();
    }

    public static com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<DeployedFleet> PARSER =
        new com.google.protobuf.AbstractParser<DeployedFleet>() {
          @java.lang.Override
          public DeployedFleet parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<DeployedFleet> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DeployedFleet> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface DeployedFleetAutoscalerOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscaler)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The name of the Agones autoscaler.
     * </pre>
     *
     * <code>string autoscaler = 1;</code>
     *
     * @return The autoscaler.
     */
    java.lang.String getAutoscaler();
    /**
     *
     *
     * <pre>
     * The name of the Agones autoscaler.
     * </pre>
     *
     * <code>string autoscaler = 1;</code>
     *
     * @return The bytes for autoscaler.
     */
    com.google.protobuf.ByteString getAutoscalerBytes();

    /**
     *
     *
     * <pre>
     * The source spec that is used to create the autoscaler.
     * The GameServerConfig resource may no longer exist in the system.
     * </pre>
     *
     * <code>.google.cloud.gaming.v1.SpecSource spec_source = 4;</code>
     *
     * @return Whether the specSource field is set.
     */
    boolean hasSpecSource();
    /**
     *
     *
     * <pre>
     * The source spec that is used to create the autoscaler.
     * The GameServerConfig resource may no longer exist in the system.
     * </pre>
     *
     * <code>.google.cloud.gaming.v1.SpecSource spec_source = 4;</code>
     *
     * @return The specSource.
     */
    com.google.cloud.gaming.v1.SpecSource getSpecSource();
    /**
     *
     *
     * <pre>
     * The source spec that is used to create the autoscaler.
     * The GameServerConfig resource may no longer exist in the system.
     * </pre>
     *
     * <code>.google.cloud.gaming.v1.SpecSource spec_source = 4;</code>
     */
    com.google.cloud.gaming.v1.SpecSourceOrBuilder getSpecSourceOrBuilder();

    /**
     *
     *
     * <pre>
     * The autoscaler spec retrieved from Agones.
     * </pre>
     *
     * <code>string fleet_autoscaler_spec = 3;</code>
     *
     * @return The fleetAutoscalerSpec.
     */
    java.lang.String getFleetAutoscalerSpec();
    /**
     *
     *
     * <pre>
     * The autoscaler spec retrieved from Agones.
     * </pre>
     *
     * <code>string fleet_autoscaler_spec = 3;</code>
     *
     * @return The bytes for fleetAutoscalerSpec.
     */
    com.google.protobuf.ByteString getFleetAutoscalerSpecBytes();
  }
  /**
   *
   *
   * <pre>
   * Details about the Agones autoscaler.
   * </pre>
   *
   * Protobuf type {@code google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscaler}
   */
  public static final class DeployedFleetAutoscaler extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscaler)
      DeployedFleetAutoscalerOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use DeployedFleetAutoscaler.newBuilder() to construct.
    private DeployedFleetAutoscaler(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private DeployedFleetAutoscaler() {
      autoscaler_ = "";
      fleetAutoscalerSpec_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new DeployedFleetAutoscaler();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.gaming.v1.Common
          .internal_static_google_cloud_gaming_v1_DeployedFleetDetails_DeployedFleetAutoscaler_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.gaming.v1.Common
          .internal_static_google_cloud_gaming_v1_DeployedFleetDetails_DeployedFleetAutoscaler_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscaler.class,
              com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscaler.Builder
                  .class);
    }

    public static final int AUTOSCALER_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object autoscaler_ = "";
    /**
     *
     *
     * <pre>
     * The name of the Agones autoscaler.
     * </pre>
     *
     * <code>string autoscaler = 1;</code>
     *
     * @return The autoscaler.
     */
    @java.lang.Override
    public java.lang.String getAutoscaler() {
      java.lang.Object ref = autoscaler_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        autoscaler_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the Agones autoscaler.
     * </pre>
     *
     * <code>string autoscaler = 1;</code>
     *
     * @return The bytes for autoscaler.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getAutoscalerBytes() {
      java.lang.Object ref = autoscaler_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        autoscaler_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SPEC_SOURCE_FIELD_NUMBER = 4;
    private com.google.cloud.gaming.v1.SpecSource specSource_;
    /**
     *
     *
     * <pre>
     * The source spec that is used to create the autoscaler.
     * The GameServerConfig resource may no longer exist in the system.
     * </pre>
     *
     * <code>.google.cloud.gaming.v1.SpecSource spec_source = 4;</code>
     *
     * @return Whether the specSource field is set.
     */
    @java.lang.Override
    public boolean hasSpecSource() {
      return specSource_ != null;
    }
    /**
     *
     *
     * <pre>
     * The source spec that is used to create the autoscaler.
     * The GameServerConfig resource may no longer exist in the system.
     * </pre>
     *
     * <code>.google.cloud.gaming.v1.SpecSource spec_source = 4;</code>
     *
     * @return The specSource.
     */
    @java.lang.Override
    public com.google.cloud.gaming.v1.SpecSource getSpecSource() {
      return specSource_ == null
          ? com.google.cloud.gaming.v1.SpecSource.getDefaultInstance()
          : specSource_;
    }
    /**
     *
     *
     * <pre>
     * The source spec that is used to create the autoscaler.
     * The GameServerConfig resource may no longer exist in the system.
     * </pre>
     *
     * <code>.google.cloud.gaming.v1.SpecSource spec_source = 4;</code>
     */
    @java.lang.Override
    public com.google.cloud.gaming.v1.SpecSourceOrBuilder getSpecSourceOrBuilder() {
      return specSource_ == null
          ? com.google.cloud.gaming.v1.SpecSource.getDefaultInstance()
          : specSource_;
    }

    public static final int FLEET_AUTOSCALER_SPEC_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object fleetAutoscalerSpec_ = "";
    /**
     *
     *
     * <pre>
     * The autoscaler spec retrieved from Agones.
     * </pre>
     *
     * <code>string fleet_autoscaler_spec = 3;</code>
     *
     * @return The fleetAutoscalerSpec.
     */
    @java.lang.Override
    public java.lang.String getFleetAutoscalerSpec() {
      java.lang.Object ref = fleetAutoscalerSpec_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        fleetAutoscalerSpec_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The autoscaler spec retrieved from Agones.
     * </pre>
     *
     * <code>string fleet_autoscaler_spec = 3;</code>
     *
     * @return The bytes for fleetAutoscalerSpec.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getFleetAutoscalerSpecBytes() {
      java.lang.Object ref = fleetAutoscalerSpec_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        fleetAutoscalerSpec_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(autoscaler_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, autoscaler_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fleetAutoscalerSpec_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, fleetAutoscalerSpec_);
      }
      if (specSource_ != null) {
        output.writeMessage(4, getSpecSource());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(autoscaler_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, autoscaler_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fleetAutoscalerSpec_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, fleetAutoscalerSpec_);
      }
      if (specSource_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getSpecSource());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscaler)) {
        return super.equals(obj);
      }
      com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscaler other =
          (com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscaler) obj;

      if (!getAutoscaler().equals(other.getAutoscaler())) return false;
      if (hasSpecSource() != other.hasSpecSource()) return false;
      if (hasSpecSource()) {
        if (!getSpecSource().equals(other.getSpecSource())) return false;
      }
      if (!getFleetAutoscalerSpec().equals(other.getFleetAutoscalerSpec())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + AUTOSCALER_FIELD_NUMBER;
      hash = (53 * hash) + getAutoscaler().hashCode();
      if (hasSpecSource()) {
        hash = (37 * hash) + SPEC_SOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getSpecSource().hashCode();
      }
      hash = (37 * hash) + FLEET_AUTOSCALER_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getFleetAutoscalerSpec().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscaler parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscaler parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscaler parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscaler parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscaler parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscaler parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscaler parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscaler parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscaler
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscaler
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscaler parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscaler parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscaler prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Details about the Agones autoscaler.
     * </pre>
     *
     * Protobuf type {@code google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscaler}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscaler)
        com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscalerOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.gaming.v1.Common
            .internal_static_google_cloud_gaming_v1_DeployedFleetDetails_DeployedFleetAutoscaler_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.gaming.v1.Common
            .internal_static_google_cloud_gaming_v1_DeployedFleetDetails_DeployedFleetAutoscaler_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscaler.class,
                com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscaler.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscaler.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        autoscaler_ = "";
        specSource_ = null;
        if (specSourceBuilder_ != null) {
          specSourceBuilder_.dispose();
          specSourceBuilder_ = null;
        }
        fleetAutoscalerSpec_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.gaming.v1.Common
            .internal_static_google_cloud_gaming_v1_DeployedFleetDetails_DeployedFleetAutoscaler_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscaler
          getDefaultInstanceForType() {
        return com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscaler
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscaler build() {
        com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscaler result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscaler
          buildPartial() {
        com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscaler result =
            new com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscaler(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscaler result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.autoscaler_ = autoscaler_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.specSource_ =
              specSourceBuilder_ == null ? specSource_ : specSourceBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.fleetAutoscalerSpec_ = fleetAutoscalerSpec_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscaler) {
          return mergeFrom(
              (com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscaler) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscaler other) {
        if (other
            == com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscaler
                .getDefaultInstance()) return this;
        if (!other.getAutoscaler().isEmpty()) {
          autoscaler_ = other.autoscaler_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.hasSpecSource()) {
          mergeSpecSource(other.getSpecSource());
        }
        if (!other.getFleetAutoscalerSpec().isEmpty()) {
          fleetAutoscalerSpec_ = other.fleetAutoscalerSpec_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  autoscaler_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 26:
                {
                  fleetAutoscalerSpec_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  input.readMessage(getSpecSourceFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object autoscaler_ = "";
      /**
       *
       *
       * <pre>
       * The name of the Agones autoscaler.
       * </pre>
       *
       * <code>string autoscaler = 1;</code>
       *
       * @return The autoscaler.
       */
      public java.lang.String getAutoscaler() {
        java.lang.Object ref = autoscaler_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          autoscaler_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the Agones autoscaler.
       * </pre>
       *
       * <code>string autoscaler = 1;</code>
       *
       * @return The bytes for autoscaler.
       */
      public com.google.protobuf.ByteString getAutoscalerBytes() {
        java.lang.Object ref = autoscaler_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          autoscaler_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the Agones autoscaler.
       * </pre>
       *
       * <code>string autoscaler = 1;</code>
       *
       * @param value The autoscaler to set.
       * @return This builder for chaining.
       */
      public Builder setAutoscaler(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        autoscaler_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of the Agones autoscaler.
       * </pre>
       *
       * <code>string autoscaler = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAutoscaler() {
        autoscaler_ = getDefaultInstance().getAutoscaler();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of the Agones autoscaler.
       * </pre>
       *
       * <code>string autoscaler = 1;</code>
       *
       * @param value The bytes for autoscaler to set.
       * @return This builder for chaining.
       */
      public Builder setAutoscalerBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        autoscaler_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.cloud.gaming.v1.SpecSource specSource_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.gaming.v1.SpecSource,
              com.google.cloud.gaming.v1.SpecSource.Builder,
              com.google.cloud.gaming.v1.SpecSourceOrBuilder>
          specSourceBuilder_;
      /**
       *
       *
       * <pre>
       * The source spec that is used to create the autoscaler.
       * The GameServerConfig resource may no longer exist in the system.
       * </pre>
       *
       * <code>.google.cloud.gaming.v1.SpecSource spec_source = 4;</code>
       *
       * @return Whether the specSource field is set.
       */
      public boolean hasSpecSource() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * The source spec that is used to create the autoscaler.
       * The GameServerConfig resource may no longer exist in the system.
       * </pre>
       *
       * <code>.google.cloud.gaming.v1.SpecSource spec_source = 4;</code>
       *
       * @return The specSource.
       */
      public com.google.cloud.gaming.v1.SpecSource getSpecSource() {
        if (specSourceBuilder_ == null) {
          return specSource_ == null
              ? com.google.cloud.gaming.v1.SpecSource.getDefaultInstance()
              : specSource_;
        } else {
          return specSourceBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The source spec that is used to create the autoscaler.
       * The GameServerConfig resource may no longer exist in the system.
       * </pre>
       *
       * <code>.google.cloud.gaming.v1.SpecSource spec_source = 4;</code>
       */
      public Builder setSpecSource(com.google.cloud.gaming.v1.SpecSource value) {
        if (specSourceBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          specSource_ = value;
        } else {
          specSourceBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The source spec that is used to create the autoscaler.
       * The GameServerConfig resource may no longer exist in the system.
       * </pre>
       *
       * <code>.google.cloud.gaming.v1.SpecSource spec_source = 4;</code>
       */
      public Builder setSpecSource(com.google.cloud.gaming.v1.SpecSource.Builder builderForValue) {
        if (specSourceBuilder_ == null) {
          specSource_ = builderForValue.build();
        } else {
          specSourceBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The source spec that is used to create the autoscaler.
       * The GameServerConfig resource may no longer exist in the system.
       * </pre>
       *
       * <code>.google.cloud.gaming.v1.SpecSource spec_source = 4;</code>
       */
      public Builder mergeSpecSource(com.google.cloud.gaming.v1.SpecSource value) {
        if (specSourceBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && specSource_ != null
              && specSource_ != com.google.cloud.gaming.v1.SpecSource.getDefaultInstance()) {
            getSpecSourceBuilder().mergeFrom(value);
          } else {
            specSource_ = value;
          }
        } else {
          specSourceBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The source spec that is used to create the autoscaler.
       * The GameServerConfig resource may no longer exist in the system.
       * </pre>
       *
       * <code>.google.cloud.gaming.v1.SpecSource spec_source = 4;</code>
       */
      public Builder clearSpecSource() {
        bitField0_ = (bitField0_ & ~0x00000002);
        specSource_ = null;
        if (specSourceBuilder_ != null) {
          specSourceBuilder_.dispose();
          specSourceBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The source spec that is used to create the autoscaler.
       * The GameServerConfig resource may no longer exist in the system.
       * </pre>
       *
       * <code>.google.cloud.gaming.v1.SpecSource spec_source = 4;</code>
       */
      public com.google.cloud.gaming.v1.SpecSource.Builder getSpecSourceBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getSpecSourceFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The source spec that is used to create the autoscaler.
       * The GameServerConfig resource may no longer exist in the system.
       * </pre>
       *
       * <code>.google.cloud.gaming.v1.SpecSource spec_source = 4;</code>
       */
      public com.google.cloud.gaming.v1.SpecSourceOrBuilder getSpecSourceOrBuilder() {
        if (specSourceBuilder_ != null) {
          return specSourceBuilder_.getMessageOrBuilder();
        } else {
          return specSource_ == null
              ? com.google.cloud.gaming.v1.SpecSource.getDefaultInstance()
              : specSource_;
        }
      }
      /**
       *
       *
       * <pre>
       * The source spec that is used to create the autoscaler.
       * The GameServerConfig resource may no longer exist in the system.
       * </pre>
       *
       * <code>.google.cloud.gaming.v1.SpecSource spec_source = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.gaming.v1.SpecSource,
              com.google.cloud.gaming.v1.SpecSource.Builder,
              com.google.cloud.gaming.v1.SpecSourceOrBuilder>
          getSpecSourceFieldBuilder() {
        if (specSourceBuilder_ == null) {
          specSourceBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.gaming.v1.SpecSource,
                  com.google.cloud.gaming.v1.SpecSource.Builder,
                  com.google.cloud.gaming.v1.SpecSourceOrBuilder>(
                  getSpecSource(), getParentForChildren(), isClean());
          specSource_ = null;
        }
        return specSourceBuilder_;
      }

      private java.lang.Object fleetAutoscalerSpec_ = "";
      /**
       *
       *
       * <pre>
       * The autoscaler spec retrieved from Agones.
       * </pre>
       *
       * <code>string fleet_autoscaler_spec = 3;</code>
       *
       * @return The fleetAutoscalerSpec.
       */
      public java.lang.String getFleetAutoscalerSpec() {
        java.lang.Object ref = fleetAutoscalerSpec_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          fleetAutoscalerSpec_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The autoscaler spec retrieved from Agones.
       * </pre>
       *
       * <code>string fleet_autoscaler_spec = 3;</code>
       *
       * @return The bytes for fleetAutoscalerSpec.
       */
      public com.google.protobuf.ByteString getFleetAutoscalerSpecBytes() {
        java.lang.Object ref = fleetAutoscalerSpec_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          fleetAutoscalerSpec_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The autoscaler spec retrieved from Agones.
       * </pre>
       *
       * <code>string fleet_autoscaler_spec = 3;</code>
       *
       * @param value The fleetAutoscalerSpec to set.
       * @return This builder for chaining.
       */
      public Builder setFleetAutoscalerSpec(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        fleetAutoscalerSpec_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The autoscaler spec retrieved from Agones.
       * </pre>
       *
       * <code>string fleet_autoscaler_spec = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFleetAutoscalerSpec() {
        fleetAutoscalerSpec_ = getDefaultInstance().getFleetAutoscalerSpec();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The autoscaler spec retrieved from Agones.
       * </pre>
       *
       * <code>string fleet_autoscaler_spec = 3;</code>
       *
       * @param value The bytes for fleetAutoscalerSpec to set.
       * @return This builder for chaining.
       */
      public Builder setFleetAutoscalerSpecBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        fleetAutoscalerSpec_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscaler)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscaler)
    private static final com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscaler
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscaler();
    }

    public static com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscaler
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<DeployedFleetAutoscaler> PARSER =
        new com.google.protobuf.AbstractParser<DeployedFleetAutoscaler>() {
          @java.lang.Override
          public DeployedFleetAutoscaler parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<DeployedFleetAutoscaler> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DeployedFleetAutoscaler> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscaler
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int DEPLOYED_FLEET_FIELD_NUMBER = 1;
  private com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet deployedFleet_;
  /**
   *
   *
   * <pre>
   * Information about the Agones fleet.
   * </pre>
   *
   * <code>.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet deployed_fleet = 1;</code>
   *
   * @return Whether the deployedFleet field is set.
   */
  @java.lang.Override
  public boolean hasDeployedFleet() {
    return deployedFleet_ != null;
  }
  /**
   *
   *
   * <pre>
   * Information about the Agones fleet.
   * </pre>
   *
   * <code>.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet deployed_fleet = 1;</code>
   *
   * @return The deployedFleet.
   */
  @java.lang.Override
  public com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet getDeployedFleet() {
    return deployedFleet_ == null
        ? com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.getDefaultInstance()
        : deployedFleet_;
  }
  /**
   *
   *
   * <pre>
   * Information about the Agones fleet.
   * </pre>
   *
   * <code>.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet deployed_fleet = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetOrBuilder
      getDeployedFleetOrBuilder() {
    return deployedFleet_ == null
        ? com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.getDefaultInstance()
        : deployedFleet_;
  }

  public static final int DEPLOYED_AUTOSCALER_FIELD_NUMBER = 2;
  private com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscaler
      deployedAutoscaler_;
  /**
   *
   *
   * <pre>
   * Information about the Agones autoscaler for that fleet.
   * </pre>
   *
   * <code>
   * .google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscaler deployed_autoscaler = 2;
   * </code>
   *
   * @return Whether the deployedAutoscaler field is set.
   */
  @java.lang.Override
  public boolean hasDeployedAutoscaler() {
    return deployedAutoscaler_ != null;
  }
  /**
   *
   *
   * <pre>
   * Information about the Agones autoscaler for that fleet.
   * </pre>
   *
   * <code>
   * .google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscaler deployed_autoscaler = 2;
   * </code>
   *
   * @return The deployedAutoscaler.
   */
  @java.lang.Override
  public com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscaler
      getDeployedAutoscaler() {
    return deployedAutoscaler_ == null
        ? com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscaler
            .getDefaultInstance()
        : deployedAutoscaler_;
  }
  /**
   *
   *
   * <pre>
   * Information about the Agones autoscaler for that fleet.
   * </pre>
   *
   * <code>
   * .google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscaler deployed_autoscaler = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscalerOrBuilder
      getDeployedAutoscalerOrBuilder() {
    return deployedAutoscaler_ == null
        ? com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscaler
            .getDefaultInstance()
        : deployedAutoscaler_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (deployedFleet_ != null) {
      output.writeMessage(1, getDeployedFleet());
    }
    if (deployedAutoscaler_ != null) {
      output.writeMessage(2, getDeployedAutoscaler());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (deployedFleet_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getDeployedFleet());
    }
    if (deployedAutoscaler_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getDeployedAutoscaler());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.gaming.v1.DeployedFleetDetails)) {
      return super.equals(obj);
    }
    com.google.cloud.gaming.v1.DeployedFleetDetails other =
        (com.google.cloud.gaming.v1.DeployedFleetDetails) obj;

    if (hasDeployedFleet() != other.hasDeployedFleet()) return false;
    if (hasDeployedFleet()) {
      if (!getDeployedFleet().equals(other.getDeployedFleet())) return false;
    }
    if (hasDeployedAutoscaler() != other.hasDeployedAutoscaler()) return false;
    if (hasDeployedAutoscaler()) {
      if (!getDeployedAutoscaler().equals(other.getDeployedAutoscaler())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasDeployedFleet()) {
      hash = (37 * hash) + DEPLOYED_FLEET_FIELD_NUMBER;
      hash = (53 * hash) + getDeployedFleet().hashCode();
    }
    if (hasDeployedAutoscaler()) {
      hash = (37 * hash) + DEPLOYED_AUTOSCALER_FIELD_NUMBER;
      hash = (53 * hash) + getDeployedAutoscaler().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.gaming.v1.DeployedFleetDetails parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gaming.v1.DeployedFleetDetails parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gaming.v1.DeployedFleetDetails parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gaming.v1.DeployedFleetDetails parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gaming.v1.DeployedFleetDetails parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gaming.v1.DeployedFleetDetails parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gaming.v1.DeployedFleetDetails parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.gaming.v1.DeployedFleetDetails parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.gaming.v1.DeployedFleetDetails parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.gaming.v1.DeployedFleetDetails parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.gaming.v1.DeployedFleetDetails parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.gaming.v1.DeployedFleetDetails parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.gaming.v1.DeployedFleetDetails prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Details of the deployed Agones fleet.
   * </pre>
   *
   * Protobuf type {@code google.cloud.gaming.v1.DeployedFleetDetails}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.gaming.v1.DeployedFleetDetails)
      com.google.cloud.gaming.v1.DeployedFleetDetailsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.gaming.v1.Common
          .internal_static_google_cloud_gaming_v1_DeployedFleetDetails_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.gaming.v1.Common
          .internal_static_google_cloud_gaming_v1_DeployedFleetDetails_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.gaming.v1.DeployedFleetDetails.class,
              com.google.cloud.gaming.v1.DeployedFleetDetails.Builder.class);
    }

    // Construct using com.google.cloud.gaming.v1.DeployedFleetDetails.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      deployedFleet_ = null;
      if (deployedFleetBuilder_ != null) {
        deployedFleetBuilder_.dispose();
        deployedFleetBuilder_ = null;
      }
      deployedAutoscaler_ = null;
      if (deployedAutoscalerBuilder_ != null) {
        deployedAutoscalerBuilder_.dispose();
        deployedAutoscalerBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.gaming.v1.Common
          .internal_static_google_cloud_gaming_v1_DeployedFleetDetails_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.gaming.v1.DeployedFleetDetails getDefaultInstanceForType() {
      return com.google.cloud.gaming.v1.DeployedFleetDetails.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.gaming.v1.DeployedFleetDetails build() {
      com.google.cloud.gaming.v1.DeployedFleetDetails result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.gaming.v1.DeployedFleetDetails buildPartial() {
      com.google.cloud.gaming.v1.DeployedFleetDetails result =
          new com.google.cloud.gaming.v1.DeployedFleetDetails(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.gaming.v1.DeployedFleetDetails result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.deployedFleet_ =
            deployedFleetBuilder_ == null ? deployedFleet_ : deployedFleetBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.deployedAutoscaler_ =
            deployedAutoscalerBuilder_ == null
                ? deployedAutoscaler_
                : deployedAutoscalerBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.gaming.v1.DeployedFleetDetails) {
        return mergeFrom((com.google.cloud.gaming.v1.DeployedFleetDetails) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.gaming.v1.DeployedFleetDetails other) {
      if (other == com.google.cloud.gaming.v1.DeployedFleetDetails.getDefaultInstance())
        return this;
      if (other.hasDeployedFleet()) {
        mergeDeployedFleet(other.getDeployedFleet());
      }
      if (other.hasDeployedAutoscaler()) {
        mergeDeployedAutoscaler(other.getDeployedAutoscaler());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getDeployedFleetFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(
                    getDeployedAutoscalerFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet deployedFleet_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet,
            com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.Builder,
            com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetOrBuilder>
        deployedFleetBuilder_;
    /**
     *
     *
     * <pre>
     * Information about the Agones fleet.
     * </pre>
     *
     * <code>.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet deployed_fleet = 1;</code>
     *
     * @return Whether the deployedFleet field is set.
     */
    public boolean hasDeployedFleet() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Information about the Agones fleet.
     * </pre>
     *
     * <code>.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet deployed_fleet = 1;</code>
     *
     * @return The deployedFleet.
     */
    public com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet getDeployedFleet() {
      if (deployedFleetBuilder_ == null) {
        return deployedFleet_ == null
            ? com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.getDefaultInstance()
            : deployedFleet_;
      } else {
        return deployedFleetBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Information about the Agones fleet.
     * </pre>
     *
     * <code>.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet deployed_fleet = 1;</code>
     */
    public Builder setDeployedFleet(
        com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet value) {
      if (deployedFleetBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        deployedFleet_ = value;
      } else {
        deployedFleetBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about the Agones fleet.
     * </pre>
     *
     * <code>.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet deployed_fleet = 1;</code>
     */
    public Builder setDeployedFleet(
        com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.Builder builderForValue) {
      if (deployedFleetBuilder_ == null) {
        deployedFleet_ = builderForValue.build();
      } else {
        deployedFleetBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about the Agones fleet.
     * </pre>
     *
     * <code>.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet deployed_fleet = 1;</code>
     */
    public Builder mergeDeployedFleet(
        com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet value) {
      if (deployedFleetBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && deployedFleet_ != null
            && deployedFleet_
                != com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet
                    .getDefaultInstance()) {
          getDeployedFleetBuilder().mergeFrom(value);
        } else {
          deployedFleet_ = value;
        }
      } else {
        deployedFleetBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about the Agones fleet.
     * </pre>
     *
     * <code>.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet deployed_fleet = 1;</code>
     */
    public Builder clearDeployedFleet() {
      bitField0_ = (bitField0_ & ~0x00000001);
      deployedFleet_ = null;
      if (deployedFleetBuilder_ != null) {
        deployedFleetBuilder_.dispose();
        deployedFleetBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about the Agones fleet.
     * </pre>
     *
     * <code>.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet deployed_fleet = 1;</code>
     */
    public com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.Builder
        getDeployedFleetBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getDeployedFleetFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Information about the Agones fleet.
     * </pre>
     *
     * <code>.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet deployed_fleet = 1;</code>
     */
    public com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetOrBuilder
        getDeployedFleetOrBuilder() {
      if (deployedFleetBuilder_ != null) {
        return deployedFleetBuilder_.getMessageOrBuilder();
      } else {
        return deployedFleet_ == null
            ? com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.getDefaultInstance()
            : deployedFleet_;
      }
    }
    /**
     *
     *
     * <pre>
     * Information about the Agones fleet.
     * </pre>
     *
     * <code>.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet deployed_fleet = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet,
            com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.Builder,
            com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetOrBuilder>
        getDeployedFleetFieldBuilder() {
      if (deployedFleetBuilder_ == null) {
        deployedFleetBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet,
                com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleet.Builder,
                com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetOrBuilder>(
                getDeployedFleet(), getParentForChildren(), isClean());
        deployedFleet_ = null;
      }
      return deployedFleetBuilder_;
    }

    private com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscaler
        deployedAutoscaler_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscaler,
            com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscaler.Builder,
            com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscalerOrBuilder>
        deployedAutoscalerBuilder_;
    /**
     *
     *
     * <pre>
     * Information about the Agones autoscaler for that fleet.
     * </pre>
     *
     * <code>
     * .google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscaler deployed_autoscaler = 2;
     * </code>
     *
     * @return Whether the deployedAutoscaler field is set.
     */
    public boolean hasDeployedAutoscaler() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Information about the Agones autoscaler for that fleet.
     * </pre>
     *
     * <code>
     * .google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscaler deployed_autoscaler = 2;
     * </code>
     *
     * @return The deployedAutoscaler.
     */
    public com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscaler
        getDeployedAutoscaler() {
      if (deployedAutoscalerBuilder_ == null) {
        return deployedAutoscaler_ == null
            ? com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscaler
                .getDefaultInstance()
            : deployedAutoscaler_;
      } else {
        return deployedAutoscalerBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Information about the Agones autoscaler for that fleet.
     * </pre>
     *
     * <code>
     * .google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscaler deployed_autoscaler = 2;
     * </code>
     */
    public Builder setDeployedAutoscaler(
        com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscaler value) {
      if (deployedAutoscalerBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        deployedAutoscaler_ = value;
      } else {
        deployedAutoscalerBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about the Agones autoscaler for that fleet.
     * </pre>
     *
     * <code>
     * .google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscaler deployed_autoscaler = 2;
     * </code>
     */
    public Builder setDeployedAutoscaler(
        com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscaler.Builder
            builderForValue) {
      if (deployedAutoscalerBuilder_ == null) {
        deployedAutoscaler_ = builderForValue.build();
      } else {
        deployedAutoscalerBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about the Agones autoscaler for that fleet.
     * </pre>
     *
     * <code>
     * .google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscaler deployed_autoscaler = 2;
     * </code>
     */
    public Builder mergeDeployedAutoscaler(
        com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscaler value) {
      if (deployedAutoscalerBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && deployedAutoscaler_ != null
            && deployedAutoscaler_
                != com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscaler
                    .getDefaultInstance()) {
          getDeployedAutoscalerBuilder().mergeFrom(value);
        } else {
          deployedAutoscaler_ = value;
        }
      } else {
        deployedAutoscalerBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about the Agones autoscaler for that fleet.
     * </pre>
     *
     * <code>
     * .google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscaler deployed_autoscaler = 2;
     * </code>
     */
    public Builder clearDeployedAutoscaler() {
      bitField0_ = (bitField0_ & ~0x00000002);
      deployedAutoscaler_ = null;
      if (deployedAutoscalerBuilder_ != null) {
        deployedAutoscalerBuilder_.dispose();
        deployedAutoscalerBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about the Agones autoscaler for that fleet.
     * </pre>
     *
     * <code>
     * .google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscaler deployed_autoscaler = 2;
     * </code>
     */
    public com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscaler.Builder
        getDeployedAutoscalerBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getDeployedAutoscalerFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Information about the Agones autoscaler for that fleet.
     * </pre>
     *
     * <code>
     * .google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscaler deployed_autoscaler = 2;
     * </code>
     */
    public com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscalerOrBuilder
        getDeployedAutoscalerOrBuilder() {
      if (deployedAutoscalerBuilder_ != null) {
        return deployedAutoscalerBuilder_.getMessageOrBuilder();
      } else {
        return deployedAutoscaler_ == null
            ? com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscaler
                .getDefaultInstance()
            : deployedAutoscaler_;
      }
    }
    /**
     *
     *
     * <pre>
     * Information about the Agones autoscaler for that fleet.
     * </pre>
     *
     * <code>
     * .google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscaler deployed_autoscaler = 2;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscaler,
            com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscaler.Builder,
            com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscalerOrBuilder>
        getDeployedAutoscalerFieldBuilder() {
      if (deployedAutoscalerBuilder_ == null) {
        deployedAutoscalerBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscaler,
                com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscaler.Builder,
                com.google.cloud.gaming.v1.DeployedFleetDetails.DeployedFleetAutoscalerOrBuilder>(
                getDeployedAutoscaler(), getParentForChildren(), isClean());
        deployedAutoscaler_ = null;
      }
      return deployedAutoscalerBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.gaming.v1.DeployedFleetDetails)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.gaming.v1.DeployedFleetDetails)
  private static final com.google.cloud.gaming.v1.DeployedFleetDetails DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.gaming.v1.DeployedFleetDetails();
  }

  public static com.google.cloud.gaming.v1.DeployedFleetDetails getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DeployedFleetDetails> PARSER =
      new com.google.protobuf.AbstractParser<DeployedFleetDetails>() {
        @java.lang.Override
        public DeployedFleetDetails parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<DeployedFleetDetails> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DeployedFleetDetails> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.gaming.v1.DeployedFleetDetails getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
