/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/gaming/v1/game_server_deployments.proto

package com.google.cloud.gaming.v1;

/**
 *
 *
 * <pre>
 * Response message for GameServerDeploymentsService.FetchDeploymentState.
 * </pre>
 *
 * Protobuf type {@code google.cloud.gaming.v1.FetchDeploymentStateResponse}
 */
public final class FetchDeploymentStateResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.gaming.v1.FetchDeploymentStateResponse)
    FetchDeploymentStateResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use FetchDeploymentStateResponse.newBuilder() to construct.
  private FetchDeploymentStateResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private FetchDeploymentStateResponse() {
    clusterState_ = java.util.Collections.emptyList();
    unavailable_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new FetchDeploymentStateResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.gaming.v1.GameServerDeployments
        .internal_static_google_cloud_gaming_v1_FetchDeploymentStateResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.gaming.v1.GameServerDeployments
        .internal_static_google_cloud_gaming_v1_FetchDeploymentStateResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.gaming.v1.FetchDeploymentStateResponse.class,
            com.google.cloud.gaming.v1.FetchDeploymentStateResponse.Builder.class);
  }

  public interface DeployedClusterStateOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The name of the cluster.
     * </pre>
     *
     * <code>string cluster = 1;</code>
     *
     * @return The cluster.
     */
    java.lang.String getCluster();
    /**
     *
     *
     * <pre>
     * The name of the cluster.
     * </pre>
     *
     * <code>string cluster = 1;</code>
     *
     * @return The bytes for cluster.
     */
    com.google.protobuf.ByteString getClusterBytes();

    /**
     *
     *
     * <pre>
     * The details about the Agones fleets and autoscalers created in the
     * game server cluster.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.DeployedFleetDetails fleet_details = 2;</code>
     */
    java.util.List<com.google.cloud.gaming.v1.DeployedFleetDetails> getFleetDetailsList();
    /**
     *
     *
     * <pre>
     * The details about the Agones fleets and autoscalers created in the
     * game server cluster.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.DeployedFleetDetails fleet_details = 2;</code>
     */
    com.google.cloud.gaming.v1.DeployedFleetDetails getFleetDetails(int index);
    /**
     *
     *
     * <pre>
     * The details about the Agones fleets and autoscalers created in the
     * game server cluster.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.DeployedFleetDetails fleet_details = 2;</code>
     */
    int getFleetDetailsCount();
    /**
     *
     *
     * <pre>
     * The details about the Agones fleets and autoscalers created in the
     * game server cluster.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.DeployedFleetDetails fleet_details = 2;</code>
     */
    java.util.List<? extends com.google.cloud.gaming.v1.DeployedFleetDetailsOrBuilder>
        getFleetDetailsOrBuilderList();
    /**
     *
     *
     * <pre>
     * The details about the Agones fleets and autoscalers created in the
     * game server cluster.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.DeployedFleetDetails fleet_details = 2;</code>
     */
    com.google.cloud.gaming.v1.DeployedFleetDetailsOrBuilder getFleetDetailsOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * The game server cluster changes made by the game server deployment.
   * </pre>
   *
   * Protobuf type {@code google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState}
   */
  public static final class DeployedClusterState extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState)
      DeployedClusterStateOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use DeployedClusterState.newBuilder() to construct.
    private DeployedClusterState(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private DeployedClusterState() {
      cluster_ = "";
      fleetDetails_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new DeployedClusterState();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.gaming.v1.GameServerDeployments
          .internal_static_google_cloud_gaming_v1_FetchDeploymentStateResponse_DeployedClusterState_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.gaming.v1.GameServerDeployments
          .internal_static_google_cloud_gaming_v1_FetchDeploymentStateResponse_DeployedClusterState_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState.class,
              com.google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState.Builder
                  .class);
    }

    public static final int CLUSTER_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object cluster_ = "";
    /**
     *
     *
     * <pre>
     * The name of the cluster.
     * </pre>
     *
     * <code>string cluster = 1;</code>
     *
     * @return The cluster.
     */
    @java.lang.Override
    public java.lang.String getCluster() {
      java.lang.Object ref = cluster_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        cluster_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the cluster.
     * </pre>
     *
     * <code>string cluster = 1;</code>
     *
     * @return The bytes for cluster.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getClusterBytes() {
      java.lang.Object ref = cluster_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        cluster_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int FLEET_DETAILS_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.gaming.v1.DeployedFleetDetails> fleetDetails_;
    /**
     *
     *
     * <pre>
     * The details about the Agones fleets and autoscalers created in the
     * game server cluster.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.DeployedFleetDetails fleet_details = 2;</code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.gaming.v1.DeployedFleetDetails> getFleetDetailsList() {
      return fleetDetails_;
    }
    /**
     *
     *
     * <pre>
     * The details about the Agones fleets and autoscalers created in the
     * game server cluster.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.DeployedFleetDetails fleet_details = 2;</code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.cloud.gaming.v1.DeployedFleetDetailsOrBuilder>
        getFleetDetailsOrBuilderList() {
      return fleetDetails_;
    }
    /**
     *
     *
     * <pre>
     * The details about the Agones fleets and autoscalers created in the
     * game server cluster.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.DeployedFleetDetails fleet_details = 2;</code>
     */
    @java.lang.Override
    public int getFleetDetailsCount() {
      return fleetDetails_.size();
    }
    /**
     *
     *
     * <pre>
     * The details about the Agones fleets and autoscalers created in the
     * game server cluster.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.DeployedFleetDetails fleet_details = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.gaming.v1.DeployedFleetDetails getFleetDetails(int index) {
      return fleetDetails_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The details about the Agones fleets and autoscalers created in the
     * game server cluster.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.DeployedFleetDetails fleet_details = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.gaming.v1.DeployedFleetDetailsOrBuilder getFleetDetailsOrBuilder(
        int index) {
      return fleetDetails_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cluster_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, cluster_);
      }
      for (int i = 0; i < fleetDetails_.size(); i++) {
        output.writeMessage(2, fleetDetails_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cluster_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, cluster_);
      }
      for (int i = 0; i < fleetDetails_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, fleetDetails_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState)) {
        return super.equals(obj);
      }
      com.google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState other =
          (com.google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState) obj;

      if (!getCluster().equals(other.getCluster())) return false;
      if (!getFleetDetailsList().equals(other.getFleetDetailsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + CLUSTER_FIELD_NUMBER;
      hash = (53 * hash) + getCluster().hashCode();
      if (getFleetDetailsCount() > 0) {
        hash = (37 * hash) + FLEET_DETAILS_FIELD_NUMBER;
        hash = (53 * hash) + getFleetDetailsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The game server cluster changes made by the game server deployment.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState)
        com.google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterStateOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.gaming.v1.GameServerDeployments
            .internal_static_google_cloud_gaming_v1_FetchDeploymentStateResponse_DeployedClusterState_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.gaming.v1.GameServerDeployments
            .internal_static_google_cloud_gaming_v1_FetchDeploymentStateResponse_DeployedClusterState_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState.class,
                com.google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        cluster_ = "";
        if (fleetDetailsBuilder_ == null) {
          fleetDetails_ = java.util.Collections.emptyList();
        } else {
          fleetDetails_ = null;
          fleetDetailsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.gaming.v1.GameServerDeployments
            .internal_static_google_cloud_gaming_v1_FetchDeploymentStateResponse_DeployedClusterState_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState
          getDefaultInstanceForType() {
        return com.google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState build() {
        com.google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState
          buildPartial() {
        com.google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState result =
            new com.google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState result) {
        if (fleetDetailsBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)) {
            fleetDetails_ = java.util.Collections.unmodifiableList(fleetDetails_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.fleetDetails_ = fleetDetails_;
        } else {
          result.fleetDetails_ = fleetDetailsBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.cluster_ = cluster_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState) {
          return mergeFrom(
              (com.google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState other) {
        if (other
            == com.google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState
                .getDefaultInstance()) return this;
        if (!other.getCluster().isEmpty()) {
          cluster_ = other.cluster_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (fleetDetailsBuilder_ == null) {
          if (!other.fleetDetails_.isEmpty()) {
            if (fleetDetails_.isEmpty()) {
              fleetDetails_ = other.fleetDetails_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureFleetDetailsIsMutable();
              fleetDetails_.addAll(other.fleetDetails_);
            }
            onChanged();
          }
        } else {
          if (!other.fleetDetails_.isEmpty()) {
            if (fleetDetailsBuilder_.isEmpty()) {
              fleetDetailsBuilder_.dispose();
              fleetDetailsBuilder_ = null;
              fleetDetails_ = other.fleetDetails_;
              bitField0_ = (bitField0_ & ~0x00000002);
              fleetDetailsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getFleetDetailsFieldBuilder()
                      : null;
            } else {
              fleetDetailsBuilder_.addAllMessages(other.fleetDetails_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  cluster_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  com.google.cloud.gaming.v1.DeployedFleetDetails m =
                      input.readMessage(
                          com.google.cloud.gaming.v1.DeployedFleetDetails.parser(),
                          extensionRegistry);
                  if (fleetDetailsBuilder_ == null) {
                    ensureFleetDetailsIsMutable();
                    fleetDetails_.add(m);
                  } else {
                    fleetDetailsBuilder_.addMessage(m);
                  }
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object cluster_ = "";
      /**
       *
       *
       * <pre>
       * The name of the cluster.
       * </pre>
       *
       * <code>string cluster = 1;</code>
       *
       * @return The cluster.
       */
      public java.lang.String getCluster() {
        java.lang.Object ref = cluster_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          cluster_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the cluster.
       * </pre>
       *
       * <code>string cluster = 1;</code>
       *
       * @return The bytes for cluster.
       */
      public com.google.protobuf.ByteString getClusterBytes() {
        java.lang.Object ref = cluster_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          cluster_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the cluster.
       * </pre>
       *
       * <code>string cluster = 1;</code>
       *
       * @param value The cluster to set.
       * @return This builder for chaining.
       */
      public Builder setCluster(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        cluster_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of the cluster.
       * </pre>
       *
       * <code>string cluster = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCluster() {
        cluster_ = getDefaultInstance().getCluster();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of the cluster.
       * </pre>
       *
       * <code>string cluster = 1;</code>
       *
       * @param value The bytes for cluster to set.
       * @return This builder for chaining.
       */
      public Builder setClusterBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        cluster_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.util.List<com.google.cloud.gaming.v1.DeployedFleetDetails> fleetDetails_ =
          java.util.Collections.emptyList();

      private void ensureFleetDetailsIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          fleetDetails_ =
              new java.util.ArrayList<com.google.cloud.gaming.v1.DeployedFleetDetails>(
                  fleetDetails_);
          bitField0_ |= 0x00000002;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.gaming.v1.DeployedFleetDetails,
              com.google.cloud.gaming.v1.DeployedFleetDetails.Builder,
              com.google.cloud.gaming.v1.DeployedFleetDetailsOrBuilder>
          fleetDetailsBuilder_;

      /**
       *
       *
       * <pre>
       * The details about the Agones fleets and autoscalers created in the
       * game server cluster.
       * </pre>
       *
       * <code>repeated .google.cloud.gaming.v1.DeployedFleetDetails fleet_details = 2;</code>
       */
      public java.util.List<com.google.cloud.gaming.v1.DeployedFleetDetails> getFleetDetailsList() {
        if (fleetDetailsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(fleetDetails_);
        } else {
          return fleetDetailsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * The details about the Agones fleets and autoscalers created in the
       * game server cluster.
       * </pre>
       *
       * <code>repeated .google.cloud.gaming.v1.DeployedFleetDetails fleet_details = 2;</code>
       */
      public int getFleetDetailsCount() {
        if (fleetDetailsBuilder_ == null) {
          return fleetDetails_.size();
        } else {
          return fleetDetailsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * The details about the Agones fleets and autoscalers created in the
       * game server cluster.
       * </pre>
       *
       * <code>repeated .google.cloud.gaming.v1.DeployedFleetDetails fleet_details = 2;</code>
       */
      public com.google.cloud.gaming.v1.DeployedFleetDetails getFleetDetails(int index) {
        if (fleetDetailsBuilder_ == null) {
          return fleetDetails_.get(index);
        } else {
          return fleetDetailsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * The details about the Agones fleets and autoscalers created in the
       * game server cluster.
       * </pre>
       *
       * <code>repeated .google.cloud.gaming.v1.DeployedFleetDetails fleet_details = 2;</code>
       */
      public Builder setFleetDetails(
          int index, com.google.cloud.gaming.v1.DeployedFleetDetails value) {
        if (fleetDetailsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFleetDetailsIsMutable();
          fleetDetails_.set(index, value);
          onChanged();
        } else {
          fleetDetailsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The details about the Agones fleets and autoscalers created in the
       * game server cluster.
       * </pre>
       *
       * <code>repeated .google.cloud.gaming.v1.DeployedFleetDetails fleet_details = 2;</code>
       */
      public Builder setFleetDetails(
          int index, com.google.cloud.gaming.v1.DeployedFleetDetails.Builder builderForValue) {
        if (fleetDetailsBuilder_ == null) {
          ensureFleetDetailsIsMutable();
          fleetDetails_.set(index, builderForValue.build());
          onChanged();
        } else {
          fleetDetailsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The details about the Agones fleets and autoscalers created in the
       * game server cluster.
       * </pre>
       *
       * <code>repeated .google.cloud.gaming.v1.DeployedFleetDetails fleet_details = 2;</code>
       */
      public Builder addFleetDetails(com.google.cloud.gaming.v1.DeployedFleetDetails value) {
        if (fleetDetailsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFleetDetailsIsMutable();
          fleetDetails_.add(value);
          onChanged();
        } else {
          fleetDetailsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The details about the Agones fleets and autoscalers created in the
       * game server cluster.
       * </pre>
       *
       * <code>repeated .google.cloud.gaming.v1.DeployedFleetDetails fleet_details = 2;</code>
       */
      public Builder addFleetDetails(
          int index, com.google.cloud.gaming.v1.DeployedFleetDetails value) {
        if (fleetDetailsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFleetDetailsIsMutable();
          fleetDetails_.add(index, value);
          onChanged();
        } else {
          fleetDetailsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The details about the Agones fleets and autoscalers created in the
       * game server cluster.
       * </pre>
       *
       * <code>repeated .google.cloud.gaming.v1.DeployedFleetDetails fleet_details = 2;</code>
       */
      public Builder addFleetDetails(
          com.google.cloud.gaming.v1.DeployedFleetDetails.Builder builderForValue) {
        if (fleetDetailsBuilder_ == null) {
          ensureFleetDetailsIsMutable();
          fleetDetails_.add(builderForValue.build());
          onChanged();
        } else {
          fleetDetailsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The details about the Agones fleets and autoscalers created in the
       * game server cluster.
       * </pre>
       *
       * <code>repeated .google.cloud.gaming.v1.DeployedFleetDetails fleet_details = 2;</code>
       */
      public Builder addFleetDetails(
          int index, com.google.cloud.gaming.v1.DeployedFleetDetails.Builder builderForValue) {
        if (fleetDetailsBuilder_ == null) {
          ensureFleetDetailsIsMutable();
          fleetDetails_.add(index, builderForValue.build());
          onChanged();
        } else {
          fleetDetailsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The details about the Agones fleets and autoscalers created in the
       * game server cluster.
       * </pre>
       *
       * <code>repeated .google.cloud.gaming.v1.DeployedFleetDetails fleet_details = 2;</code>
       */
      public Builder addAllFleetDetails(
          java.lang.Iterable<? extends com.google.cloud.gaming.v1.DeployedFleetDetails> values) {
        if (fleetDetailsBuilder_ == null) {
          ensureFleetDetailsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, fleetDetails_);
          onChanged();
        } else {
          fleetDetailsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The details about the Agones fleets and autoscalers created in the
       * game server cluster.
       * </pre>
       *
       * <code>repeated .google.cloud.gaming.v1.DeployedFleetDetails fleet_details = 2;</code>
       */
      public Builder clearFleetDetails() {
        if (fleetDetailsBuilder_ == null) {
          fleetDetails_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          fleetDetailsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The details about the Agones fleets and autoscalers created in the
       * game server cluster.
       * </pre>
       *
       * <code>repeated .google.cloud.gaming.v1.DeployedFleetDetails fleet_details = 2;</code>
       */
      public Builder removeFleetDetails(int index) {
        if (fleetDetailsBuilder_ == null) {
          ensureFleetDetailsIsMutable();
          fleetDetails_.remove(index);
          onChanged();
        } else {
          fleetDetailsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The details about the Agones fleets and autoscalers created in the
       * game server cluster.
       * </pre>
       *
       * <code>repeated .google.cloud.gaming.v1.DeployedFleetDetails fleet_details = 2;</code>
       */
      public com.google.cloud.gaming.v1.DeployedFleetDetails.Builder getFleetDetailsBuilder(
          int index) {
        return getFleetDetailsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * The details about the Agones fleets and autoscalers created in the
       * game server cluster.
       * </pre>
       *
       * <code>repeated .google.cloud.gaming.v1.DeployedFleetDetails fleet_details = 2;</code>
       */
      public com.google.cloud.gaming.v1.DeployedFleetDetailsOrBuilder getFleetDetailsOrBuilder(
          int index) {
        if (fleetDetailsBuilder_ == null) {
          return fleetDetails_.get(index);
        } else {
          return fleetDetailsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * The details about the Agones fleets and autoscalers created in the
       * game server cluster.
       * </pre>
       *
       * <code>repeated .google.cloud.gaming.v1.DeployedFleetDetails fleet_details = 2;</code>
       */
      public java.util.List<? extends com.google.cloud.gaming.v1.DeployedFleetDetailsOrBuilder>
          getFleetDetailsOrBuilderList() {
        if (fleetDetailsBuilder_ != null) {
          return fleetDetailsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(fleetDetails_);
        }
      }
      /**
       *
       *
       * <pre>
       * The details about the Agones fleets and autoscalers created in the
       * game server cluster.
       * </pre>
       *
       * <code>repeated .google.cloud.gaming.v1.DeployedFleetDetails fleet_details = 2;</code>
       */
      public com.google.cloud.gaming.v1.DeployedFleetDetails.Builder addFleetDetailsBuilder() {
        return getFleetDetailsFieldBuilder()
            .addBuilder(com.google.cloud.gaming.v1.DeployedFleetDetails.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * The details about the Agones fleets and autoscalers created in the
       * game server cluster.
       * </pre>
       *
       * <code>repeated .google.cloud.gaming.v1.DeployedFleetDetails fleet_details = 2;</code>
       */
      public com.google.cloud.gaming.v1.DeployedFleetDetails.Builder addFleetDetailsBuilder(
          int index) {
        return getFleetDetailsFieldBuilder()
            .addBuilder(
                index, com.google.cloud.gaming.v1.DeployedFleetDetails.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * The details about the Agones fleets and autoscalers created in the
       * game server cluster.
       * </pre>
       *
       * <code>repeated .google.cloud.gaming.v1.DeployedFleetDetails fleet_details = 2;</code>
       */
      public java.util.List<com.google.cloud.gaming.v1.DeployedFleetDetails.Builder>
          getFleetDetailsBuilderList() {
        return getFleetDetailsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.gaming.v1.DeployedFleetDetails,
              com.google.cloud.gaming.v1.DeployedFleetDetails.Builder,
              com.google.cloud.gaming.v1.DeployedFleetDetailsOrBuilder>
          getFleetDetailsFieldBuilder() {
        if (fleetDetailsBuilder_ == null) {
          fleetDetailsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.gaming.v1.DeployedFleetDetails,
                  com.google.cloud.gaming.v1.DeployedFleetDetails.Builder,
                  com.google.cloud.gaming.v1.DeployedFleetDetailsOrBuilder>(
                  fleetDetails_,
                  ((bitField0_ & 0x00000002) != 0),
                  getParentForChildren(),
                  isClean());
          fleetDetails_ = null;
        }
        return fleetDetailsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState)
    private static final com.google.cloud.gaming.v1.FetchDeploymentStateResponse
            .DeployedClusterState
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState();
    }

    public static com.google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<DeployedClusterState> PARSER =
        new com.google.protobuf.AbstractParser<DeployedClusterState>() {
          @java.lang.Override
          public DeployedClusterState parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<DeployedClusterState> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DeployedClusterState> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int CLUSTER_STATE_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<
          com.google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState>
      clusterState_;
  /**
   *
   *
   * <pre>
   * The state of the game server deployment in each game server cluster.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState cluster_state = 1;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          com.google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState>
      getClusterStateList() {
    return clusterState_;
  }
  /**
   *
   *
   * <pre>
   * The state of the game server deployment in each game server cluster.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState cluster_state = 1;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterStateOrBuilder>
      getClusterStateOrBuilderList() {
    return clusterState_;
  }
  /**
   *
   *
   * <pre>
   * The state of the game server deployment in each game server cluster.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState cluster_state = 1;
   * </code>
   */
  @java.lang.Override
  public int getClusterStateCount() {
    return clusterState_.size();
  }
  /**
   *
   *
   * <pre>
   * The state of the game server deployment in each game server cluster.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState cluster_state = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState
      getClusterState(int index) {
    return clusterState_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The state of the game server deployment in each game server cluster.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState cluster_state = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterStateOrBuilder
      getClusterStateOrBuilder(int index) {
    return clusterState_.get(index);
  }

  public static final int UNAVAILABLE_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList unavailable_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * List of locations that could not be reached.
   * </pre>
   *
   * <code>repeated string unavailable = 2;</code>
   *
   * @return A list containing the unavailable.
   */
  public com.google.protobuf.ProtocolStringList getUnavailableList() {
    return unavailable_;
  }
  /**
   *
   *
   * <pre>
   * List of locations that could not be reached.
   * </pre>
   *
   * <code>repeated string unavailable = 2;</code>
   *
   * @return The count of unavailable.
   */
  public int getUnavailableCount() {
    return unavailable_.size();
  }
  /**
   *
   *
   * <pre>
   * List of locations that could not be reached.
   * </pre>
   *
   * <code>repeated string unavailable = 2;</code>
   *
   * @param index The index of the element to return.
   * @return The unavailable at the given index.
   */
  public java.lang.String getUnavailable(int index) {
    return unavailable_.get(index);
  }
  /**
   *
   *
   * <pre>
   * List of locations that could not be reached.
   * </pre>
   *
   * <code>repeated string unavailable = 2;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the unavailable at the given index.
   */
  public com.google.protobuf.ByteString getUnavailableBytes(int index) {
    return unavailable_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < clusterState_.size(); i++) {
      output.writeMessage(1, clusterState_.get(i));
    }
    for (int i = 0; i < unavailable_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, unavailable_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < clusterState_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, clusterState_.get(i));
    }
    {
      int dataSize = 0;
      for (int i = 0; i < unavailable_.size(); i++) {
        dataSize += computeStringSizeNoTag(unavailable_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getUnavailableList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.gaming.v1.FetchDeploymentStateResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.gaming.v1.FetchDeploymentStateResponse other =
        (com.google.cloud.gaming.v1.FetchDeploymentStateResponse) obj;

    if (!getClusterStateList().equals(other.getClusterStateList())) return false;
    if (!getUnavailableList().equals(other.getUnavailableList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getClusterStateCount() > 0) {
      hash = (37 * hash) + CLUSTER_STATE_FIELD_NUMBER;
      hash = (53 * hash) + getClusterStateList().hashCode();
    }
    if (getUnavailableCount() > 0) {
      hash = (37 * hash) + UNAVAILABLE_FIELD_NUMBER;
      hash = (53 * hash) + getUnavailableList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.gaming.v1.FetchDeploymentStateResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gaming.v1.FetchDeploymentStateResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gaming.v1.FetchDeploymentStateResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gaming.v1.FetchDeploymentStateResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gaming.v1.FetchDeploymentStateResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gaming.v1.FetchDeploymentStateResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gaming.v1.FetchDeploymentStateResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.gaming.v1.FetchDeploymentStateResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.gaming.v1.FetchDeploymentStateResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.gaming.v1.FetchDeploymentStateResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.gaming.v1.FetchDeploymentStateResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.gaming.v1.FetchDeploymentStateResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.gaming.v1.FetchDeploymentStateResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Response message for GameServerDeploymentsService.FetchDeploymentState.
   * </pre>
   *
   * Protobuf type {@code google.cloud.gaming.v1.FetchDeploymentStateResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.gaming.v1.FetchDeploymentStateResponse)
      com.google.cloud.gaming.v1.FetchDeploymentStateResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.gaming.v1.GameServerDeployments
          .internal_static_google_cloud_gaming_v1_FetchDeploymentStateResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.gaming.v1.GameServerDeployments
          .internal_static_google_cloud_gaming_v1_FetchDeploymentStateResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.gaming.v1.FetchDeploymentStateResponse.class,
              com.google.cloud.gaming.v1.FetchDeploymentStateResponse.Builder.class);
    }

    // Construct using com.google.cloud.gaming.v1.FetchDeploymentStateResponse.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (clusterStateBuilder_ == null) {
        clusterState_ = java.util.Collections.emptyList();
      } else {
        clusterState_ = null;
        clusterStateBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      unavailable_ = com.google.protobuf.LazyStringArrayList.emptyList();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.gaming.v1.GameServerDeployments
          .internal_static_google_cloud_gaming_v1_FetchDeploymentStateResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.gaming.v1.FetchDeploymentStateResponse getDefaultInstanceForType() {
      return com.google.cloud.gaming.v1.FetchDeploymentStateResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.gaming.v1.FetchDeploymentStateResponse build() {
      com.google.cloud.gaming.v1.FetchDeploymentStateResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.gaming.v1.FetchDeploymentStateResponse buildPartial() {
      com.google.cloud.gaming.v1.FetchDeploymentStateResponse result =
          new com.google.cloud.gaming.v1.FetchDeploymentStateResponse(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.gaming.v1.FetchDeploymentStateResponse result) {
      if (clusterStateBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          clusterState_ = java.util.Collections.unmodifiableList(clusterState_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.clusterState_ = clusterState_;
      } else {
        result.clusterState_ = clusterStateBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.gaming.v1.FetchDeploymentStateResponse result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        unavailable_.makeImmutable();
        result.unavailable_ = unavailable_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.gaming.v1.FetchDeploymentStateResponse) {
        return mergeFrom((com.google.cloud.gaming.v1.FetchDeploymentStateResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.gaming.v1.FetchDeploymentStateResponse other) {
      if (other == com.google.cloud.gaming.v1.FetchDeploymentStateResponse.getDefaultInstance())
        return this;
      if (clusterStateBuilder_ == null) {
        if (!other.clusterState_.isEmpty()) {
          if (clusterState_.isEmpty()) {
            clusterState_ = other.clusterState_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureClusterStateIsMutable();
            clusterState_.addAll(other.clusterState_);
          }
          onChanged();
        }
      } else {
        if (!other.clusterState_.isEmpty()) {
          if (clusterStateBuilder_.isEmpty()) {
            clusterStateBuilder_.dispose();
            clusterStateBuilder_ = null;
            clusterState_ = other.clusterState_;
            bitField0_ = (bitField0_ & ~0x00000001);
            clusterStateBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getClusterStateFieldBuilder()
                    : null;
          } else {
            clusterStateBuilder_.addAllMessages(other.clusterState_);
          }
        }
      }
      if (!other.unavailable_.isEmpty()) {
        if (unavailable_.isEmpty()) {
          unavailable_ = other.unavailable_;
          bitField0_ |= 0x00000002;
        } else {
          ensureUnavailableIsMutable();
          unavailable_.addAll(other.unavailable_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState m =
                    input.readMessage(
                        com.google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState
                            .parser(),
                        extensionRegistry);
                if (clusterStateBuilder_ == null) {
                  ensureClusterStateIsMutable();
                  clusterState_.add(m);
                } else {
                  clusterStateBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureUnavailableIsMutable();
                unavailable_.add(s);
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<
            com.google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState>
        clusterState_ = java.util.Collections.emptyList();

    private void ensureClusterStateIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        clusterState_ =
            new java.util.ArrayList<
                com.google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState>(
                clusterState_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState,
            com.google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState.Builder,
            com.google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterStateOrBuilder>
        clusterStateBuilder_;

    /**
     *
     *
     * <pre>
     * The state of the game server deployment in each game server cluster.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState cluster_state = 1;
     * </code>
     */
    public java.util.List<
            com.google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState>
        getClusterStateList() {
      if (clusterStateBuilder_ == null) {
        return java.util.Collections.unmodifiableList(clusterState_);
      } else {
        return clusterStateBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The state of the game server deployment in each game server cluster.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState cluster_state = 1;
     * </code>
     */
    public int getClusterStateCount() {
      if (clusterStateBuilder_ == null) {
        return clusterState_.size();
      } else {
        return clusterStateBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The state of the game server deployment in each game server cluster.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState cluster_state = 1;
     * </code>
     */
    public com.google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState
        getClusterState(int index) {
      if (clusterStateBuilder_ == null) {
        return clusterState_.get(index);
      } else {
        return clusterStateBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The state of the game server deployment in each game server cluster.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState cluster_state = 1;
     * </code>
     */
    public Builder setClusterState(
        int index,
        com.google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState value) {
      if (clusterStateBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureClusterStateIsMutable();
        clusterState_.set(index, value);
        onChanged();
      } else {
        clusterStateBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The state of the game server deployment in each game server cluster.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState cluster_state = 1;
     * </code>
     */
    public Builder setClusterState(
        int index,
        com.google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState.Builder
            builderForValue) {
      if (clusterStateBuilder_ == null) {
        ensureClusterStateIsMutable();
        clusterState_.set(index, builderForValue.build());
        onChanged();
      } else {
        clusterStateBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The state of the game server deployment in each game server cluster.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState cluster_state = 1;
     * </code>
     */
    public Builder addClusterState(
        com.google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState value) {
      if (clusterStateBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureClusterStateIsMutable();
        clusterState_.add(value);
        onChanged();
      } else {
        clusterStateBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The state of the game server deployment in each game server cluster.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState cluster_state = 1;
     * </code>
     */
    public Builder addClusterState(
        int index,
        com.google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState value) {
      if (clusterStateBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureClusterStateIsMutable();
        clusterState_.add(index, value);
        onChanged();
      } else {
        clusterStateBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The state of the game server deployment in each game server cluster.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState cluster_state = 1;
     * </code>
     */
    public Builder addClusterState(
        com.google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState.Builder
            builderForValue) {
      if (clusterStateBuilder_ == null) {
        ensureClusterStateIsMutable();
        clusterState_.add(builderForValue.build());
        onChanged();
      } else {
        clusterStateBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The state of the game server deployment in each game server cluster.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState cluster_state = 1;
     * </code>
     */
    public Builder addClusterState(
        int index,
        com.google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState.Builder
            builderForValue) {
      if (clusterStateBuilder_ == null) {
        ensureClusterStateIsMutable();
        clusterState_.add(index, builderForValue.build());
        onChanged();
      } else {
        clusterStateBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The state of the game server deployment in each game server cluster.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState cluster_state = 1;
     * </code>
     */
    public Builder addAllClusterState(
        java.lang.Iterable<
                ? extends
                    com.google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState>
            values) {
      if (clusterStateBuilder_ == null) {
        ensureClusterStateIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, clusterState_);
        onChanged();
      } else {
        clusterStateBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The state of the game server deployment in each game server cluster.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState cluster_state = 1;
     * </code>
     */
    public Builder clearClusterState() {
      if (clusterStateBuilder_ == null) {
        clusterState_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        clusterStateBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The state of the game server deployment in each game server cluster.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState cluster_state = 1;
     * </code>
     */
    public Builder removeClusterState(int index) {
      if (clusterStateBuilder_ == null) {
        ensureClusterStateIsMutable();
        clusterState_.remove(index);
        onChanged();
      } else {
        clusterStateBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The state of the game server deployment in each game server cluster.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState cluster_state = 1;
     * </code>
     */
    public com.google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState.Builder
        getClusterStateBuilder(int index) {
      return getClusterStateFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The state of the game server deployment in each game server cluster.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState cluster_state = 1;
     * </code>
     */
    public com.google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterStateOrBuilder
        getClusterStateOrBuilder(int index) {
      if (clusterStateBuilder_ == null) {
        return clusterState_.get(index);
      } else {
        return clusterStateBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The state of the game server deployment in each game server cluster.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState cluster_state = 1;
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.gaming.v1.FetchDeploymentStateResponse
                    .DeployedClusterStateOrBuilder>
        getClusterStateOrBuilderList() {
      if (clusterStateBuilder_ != null) {
        return clusterStateBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(clusterState_);
      }
    }
    /**
     *
     *
     * <pre>
     * The state of the game server deployment in each game server cluster.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState cluster_state = 1;
     * </code>
     */
    public com.google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState.Builder
        addClusterStateBuilder() {
      return getClusterStateFieldBuilder()
          .addBuilder(
              com.google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The state of the game server deployment in each game server cluster.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState cluster_state = 1;
     * </code>
     */
    public com.google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState.Builder
        addClusterStateBuilder(int index) {
      return getClusterStateFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The state of the game server deployment in each game server cluster.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState cluster_state = 1;
     * </code>
     */
    public java.util.List<
            com.google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState.Builder>
        getClusterStateBuilderList() {
      return getClusterStateFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState,
            com.google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState.Builder,
            com.google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterStateOrBuilder>
        getClusterStateFieldBuilder() {
      if (clusterStateBuilder_ == null) {
        clusterStateBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState,
                com.google.cloud.gaming.v1.FetchDeploymentStateResponse.DeployedClusterState
                    .Builder,
                com.google.cloud.gaming.v1.FetchDeploymentStateResponse
                    .DeployedClusterStateOrBuilder>(
                clusterState_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        clusterState_ = null;
      }
      return clusterStateBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList unavailable_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureUnavailableIsMutable() {
      if (!unavailable_.isModifiable()) {
        unavailable_ = new com.google.protobuf.LazyStringArrayList(unavailable_);
      }
      bitField0_ |= 0x00000002;
    }
    /**
     *
     *
     * <pre>
     * List of locations that could not be reached.
     * </pre>
     *
     * <code>repeated string unavailable = 2;</code>
     *
     * @return A list containing the unavailable.
     */
    public com.google.protobuf.ProtocolStringList getUnavailableList() {
      unavailable_.makeImmutable();
      return unavailable_;
    }
    /**
     *
     *
     * <pre>
     * List of locations that could not be reached.
     * </pre>
     *
     * <code>repeated string unavailable = 2;</code>
     *
     * @return The count of unavailable.
     */
    public int getUnavailableCount() {
      return unavailable_.size();
    }
    /**
     *
     *
     * <pre>
     * List of locations that could not be reached.
     * </pre>
     *
     * <code>repeated string unavailable = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The unavailable at the given index.
     */
    public java.lang.String getUnavailable(int index) {
      return unavailable_.get(index);
    }
    /**
     *
     *
     * <pre>
     * List of locations that could not be reached.
     * </pre>
     *
     * <code>repeated string unavailable = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the unavailable at the given index.
     */
    public com.google.protobuf.ByteString getUnavailableBytes(int index) {
      return unavailable_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * List of locations that could not be reached.
     * </pre>
     *
     * <code>repeated string unavailable = 2;</code>
     *
     * @param index The index to set the value at.
     * @param value The unavailable to set.
     * @return This builder for chaining.
     */
    public Builder setUnavailable(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureUnavailableIsMutable();
      unavailable_.set(index, value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of locations that could not be reached.
     * </pre>
     *
     * <code>repeated string unavailable = 2;</code>
     *
     * @param value The unavailable to add.
     * @return This builder for chaining.
     */
    public Builder addUnavailable(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureUnavailableIsMutable();
      unavailable_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of locations that could not be reached.
     * </pre>
     *
     * <code>repeated string unavailable = 2;</code>
     *
     * @param values The unavailable to add.
     * @return This builder for chaining.
     */
    public Builder addAllUnavailable(java.lang.Iterable<java.lang.String> values) {
      ensureUnavailableIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, unavailable_);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of locations that could not be reached.
     * </pre>
     *
     * <code>repeated string unavailable = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUnavailable() {
      unavailable_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of locations that could not be reached.
     * </pre>
     *
     * <code>repeated string unavailable = 2;</code>
     *
     * @param value The bytes of the unavailable to add.
     * @return This builder for chaining.
     */
    public Builder addUnavailableBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureUnavailableIsMutable();
      unavailable_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.gaming.v1.FetchDeploymentStateResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.gaming.v1.FetchDeploymentStateResponse)
  private static final com.google.cloud.gaming.v1.FetchDeploymentStateResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.gaming.v1.FetchDeploymentStateResponse();
  }

  public static com.google.cloud.gaming.v1.FetchDeploymentStateResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<FetchDeploymentStateResponse> PARSER =
      new com.google.protobuf.AbstractParser<FetchDeploymentStateResponse>() {
        @java.lang.Override
        public FetchDeploymentStateResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<FetchDeploymentStateResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<FetchDeploymentStateResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.gaming.v1.FetchDeploymentStateResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
