/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/gaming/v1/game_server_configs.proto

package com.google.cloud.gaming.v1;

/**
 *
 *
 * <pre>
 * A game server config resource.
 * </pre>
 *
 * Protobuf type {@code google.cloud.gaming.v1.GameServerConfig}
 */
public final class GameServerConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.gaming.v1.GameServerConfig)
    GameServerConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use GameServerConfig.newBuilder() to construct.
  private GameServerConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private GameServerConfig() {
    name_ = "";
    fleetConfigs_ = java.util.Collections.emptyList();
    scalingConfigs_ = java.util.Collections.emptyList();
    description_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new GameServerConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.gaming.v1.GameServerConfigs
        .internal_static_google_cloud_gaming_v1_GameServerConfig_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 4:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.gaming.v1.GameServerConfigs
        .internal_static_google_cloud_gaming_v1_GameServerConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.gaming.v1.GameServerConfig.class,
            com.google.cloud.gaming.v1.GameServerConfig.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The resource name of the game server config, in the following form:
   * `projects/{project}/locations/{location}/gameServerDeployments/{deployment}/configs/{config}`.
   * For example,
   * `projects/my-project/locations/global/gameServerDeployments/my-game/configs/my-config`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The resource name of the game server config, in the following form:
   * `projects/{project}/locations/{location}/gameServerDeployments/{deployment}/configs/{config}`.
   * For example,
   * `projects/my-project/locations/global/gameServerDeployments/my-game/configs/my-config`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The creation time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The creation time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The creation time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The last-modified time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The last-modified time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The last-modified time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int LABELS_FIELD_NUMBER = 4;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.gaming.v1.GameServerConfigs
                .internal_static_google_cloud_gaming_v1_GameServerConfig_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * The labels associated with this game server config. Each label is a
   * key-value pair.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * The labels associated with this game server config. Each label is a
   * key-value pair.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * The labels associated with this game server config. Each label is a
   * key-value pair.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * The labels associated with this game server config. Each label is a
   * key-value pair.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int FLEET_CONFIGS_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.gaming.v1.FleetConfig> fleetConfigs_;
  /**
   *
   *
   * <pre>
   * FleetConfig contains a list of Agones fleet specs. Only one FleetConfig
   * is allowed.
   * </pre>
   *
   * <code>repeated .google.cloud.gaming.v1.FleetConfig fleet_configs = 5;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.gaming.v1.FleetConfig> getFleetConfigsList() {
    return fleetConfigs_;
  }
  /**
   *
   *
   * <pre>
   * FleetConfig contains a list of Agones fleet specs. Only one FleetConfig
   * is allowed.
   * </pre>
   *
   * <code>repeated .google.cloud.gaming.v1.FleetConfig fleet_configs = 5;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.gaming.v1.FleetConfigOrBuilder>
      getFleetConfigsOrBuilderList() {
    return fleetConfigs_;
  }
  /**
   *
   *
   * <pre>
   * FleetConfig contains a list of Agones fleet specs. Only one FleetConfig
   * is allowed.
   * </pre>
   *
   * <code>repeated .google.cloud.gaming.v1.FleetConfig fleet_configs = 5;</code>
   */
  @java.lang.Override
  public int getFleetConfigsCount() {
    return fleetConfigs_.size();
  }
  /**
   *
   *
   * <pre>
   * FleetConfig contains a list of Agones fleet specs. Only one FleetConfig
   * is allowed.
   * </pre>
   *
   * <code>repeated .google.cloud.gaming.v1.FleetConfig fleet_configs = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.gaming.v1.FleetConfig getFleetConfigs(int index) {
    return fleetConfigs_.get(index);
  }
  /**
   *
   *
   * <pre>
   * FleetConfig contains a list of Agones fleet specs. Only one FleetConfig
   * is allowed.
   * </pre>
   *
   * <code>repeated .google.cloud.gaming.v1.FleetConfig fleet_configs = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.gaming.v1.FleetConfigOrBuilder getFleetConfigsOrBuilder(int index) {
    return fleetConfigs_.get(index);
  }

  public static final int SCALING_CONFIGS_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.gaming.v1.ScalingConfig> scalingConfigs_;
  /**
   *
   *
   * <pre>
   * The autoscaling settings.
   * </pre>
   *
   * <code>repeated .google.cloud.gaming.v1.ScalingConfig scaling_configs = 6;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.gaming.v1.ScalingConfig> getScalingConfigsList() {
    return scalingConfigs_;
  }
  /**
   *
   *
   * <pre>
   * The autoscaling settings.
   * </pre>
   *
   * <code>repeated .google.cloud.gaming.v1.ScalingConfig scaling_configs = 6;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.gaming.v1.ScalingConfigOrBuilder>
      getScalingConfigsOrBuilderList() {
    return scalingConfigs_;
  }
  /**
   *
   *
   * <pre>
   * The autoscaling settings.
   * </pre>
   *
   * <code>repeated .google.cloud.gaming.v1.ScalingConfig scaling_configs = 6;</code>
   */
  @java.lang.Override
  public int getScalingConfigsCount() {
    return scalingConfigs_.size();
  }
  /**
   *
   *
   * <pre>
   * The autoscaling settings.
   * </pre>
   *
   * <code>repeated .google.cloud.gaming.v1.ScalingConfig scaling_configs = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.gaming.v1.ScalingConfig getScalingConfigs(int index) {
    return scalingConfigs_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The autoscaling settings.
   * </pre>
   *
   * <code>repeated .google.cloud.gaming.v1.ScalingConfig scaling_configs = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.gaming.v1.ScalingConfigOrBuilder getScalingConfigsOrBuilder(int index) {
    return scalingConfigs_.get(index);
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * The description of the game server config.
   * </pre>
   *
   * <code>string description = 7;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The description of the game server config.
   * </pre>
   *
   * <code>string description = 7;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (createTime_ != null) {
      output.writeMessage(2, getCreateTime());
    }
    if (updateTime_ != null) {
      output.writeMessage(3, getUpdateTime());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 4);
    for (int i = 0; i < fleetConfigs_.size(); i++) {
      output.writeMessage(5, fleetConfigs_.get(i));
    }
    for (int i = 0; i < scalingConfigs_.size(); i++) {
      output.writeMessage(6, scalingConfigs_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, description_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getCreateTime());
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getUpdateTime());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, labels__);
    }
    for (int i = 0; i < fleetConfigs_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, fleetConfigs_.get(i));
    }
    for (int i = 0; i < scalingConfigs_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, scalingConfigs_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, description_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.gaming.v1.GameServerConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.gaming.v1.GameServerConfig other =
        (com.google.cloud.gaming.v1.GameServerConfig) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!getFleetConfigsList().equals(other.getFleetConfigsList())) return false;
    if (!getScalingConfigsList().equals(other.getScalingConfigsList())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (getFleetConfigsCount() > 0) {
      hash = (37 * hash) + FLEET_CONFIGS_FIELD_NUMBER;
      hash = (53 * hash) + getFleetConfigsList().hashCode();
    }
    if (getScalingConfigsCount() > 0) {
      hash = (37 * hash) + SCALING_CONFIGS_FIELD_NUMBER;
      hash = (53 * hash) + getScalingConfigsList().hashCode();
    }
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.gaming.v1.GameServerConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gaming.v1.GameServerConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gaming.v1.GameServerConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gaming.v1.GameServerConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gaming.v1.GameServerConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gaming.v1.GameServerConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gaming.v1.GameServerConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.gaming.v1.GameServerConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.gaming.v1.GameServerConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.gaming.v1.GameServerConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.gaming.v1.GameServerConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.gaming.v1.GameServerConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.gaming.v1.GameServerConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A game server config resource.
   * </pre>
   *
   * Protobuf type {@code google.cloud.gaming.v1.GameServerConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.gaming.v1.GameServerConfig)
      com.google.cloud.gaming.v1.GameServerConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.gaming.v1.GameServerConfigs
          .internal_static_google_cloud_gaming_v1_GameServerConfig_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 4:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 4:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.gaming.v1.GameServerConfigs
          .internal_static_google_cloud_gaming_v1_GameServerConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.gaming.v1.GameServerConfig.class,
              com.google.cloud.gaming.v1.GameServerConfig.Builder.class);
    }

    // Construct using com.google.cloud.gaming.v1.GameServerConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      internalGetMutableLabels().clear();
      if (fleetConfigsBuilder_ == null) {
        fleetConfigs_ = java.util.Collections.emptyList();
      } else {
        fleetConfigs_ = null;
        fleetConfigsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000010);
      if (scalingConfigsBuilder_ == null) {
        scalingConfigs_ = java.util.Collections.emptyList();
      } else {
        scalingConfigs_ = null;
        scalingConfigsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000020);
      description_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.gaming.v1.GameServerConfigs
          .internal_static_google_cloud_gaming_v1_GameServerConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.gaming.v1.GameServerConfig getDefaultInstanceForType() {
      return com.google.cloud.gaming.v1.GameServerConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.gaming.v1.GameServerConfig build() {
      com.google.cloud.gaming.v1.GameServerConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.gaming.v1.GameServerConfig buildPartial() {
      com.google.cloud.gaming.v1.GameServerConfig result =
          new com.google.cloud.gaming.v1.GameServerConfig(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.gaming.v1.GameServerConfig result) {
      if (fleetConfigsBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)) {
          fleetConfigs_ = java.util.Collections.unmodifiableList(fleetConfigs_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.fleetConfigs_ = fleetConfigs_;
      } else {
        result.fleetConfigs_ = fleetConfigsBuilder_.build();
      }
      if (scalingConfigsBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)) {
          scalingConfigs_ = java.util.Collections.unmodifiableList(scalingConfigs_);
          bitField0_ = (bitField0_ & ~0x00000020);
        }
        result.scalingConfigs_ = scalingConfigs_;
      } else {
        result.scalingConfigs_ = scalingConfigsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.gaming.v1.GameServerConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.description_ = description_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.gaming.v1.GameServerConfig) {
        return mergeFrom((com.google.cloud.gaming.v1.GameServerConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.gaming.v1.GameServerConfig other) {
      if (other == com.google.cloud.gaming.v1.GameServerConfig.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000008;
      if (fleetConfigsBuilder_ == null) {
        if (!other.fleetConfigs_.isEmpty()) {
          if (fleetConfigs_.isEmpty()) {
            fleetConfigs_ = other.fleetConfigs_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureFleetConfigsIsMutable();
            fleetConfigs_.addAll(other.fleetConfigs_);
          }
          onChanged();
        }
      } else {
        if (!other.fleetConfigs_.isEmpty()) {
          if (fleetConfigsBuilder_.isEmpty()) {
            fleetConfigsBuilder_.dispose();
            fleetConfigsBuilder_ = null;
            fleetConfigs_ = other.fleetConfigs_;
            bitField0_ = (bitField0_ & ~0x00000010);
            fleetConfigsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getFleetConfigsFieldBuilder()
                    : null;
          } else {
            fleetConfigsBuilder_.addAllMessages(other.fleetConfigs_);
          }
        }
      }
      if (scalingConfigsBuilder_ == null) {
        if (!other.scalingConfigs_.isEmpty()) {
          if (scalingConfigs_.isEmpty()) {
            scalingConfigs_ = other.scalingConfigs_;
            bitField0_ = (bitField0_ & ~0x00000020);
          } else {
            ensureScalingConfigsIsMutable();
            scalingConfigs_.addAll(other.scalingConfigs_);
          }
          onChanged();
        }
      } else {
        if (!other.scalingConfigs_.isEmpty()) {
          if (scalingConfigsBuilder_.isEmpty()) {
            scalingConfigsBuilder_.dispose();
            scalingConfigsBuilder_ = null;
            scalingConfigs_ = other.scalingConfigs_;
            bitField0_ = (bitField0_ & ~0x00000020);
            scalingConfigsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getScalingConfigsFieldBuilder()
                    : null;
          } else {
            scalingConfigsBuilder_.addAllMessages(other.scalingConfigs_);
          }
        }
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                com.google.cloud.gaming.v1.FleetConfig m =
                    input.readMessage(
                        com.google.cloud.gaming.v1.FleetConfig.parser(), extensionRegistry);
                if (fleetConfigsBuilder_ == null) {
                  ensureFleetConfigsIsMutable();
                  fleetConfigs_.add(m);
                } else {
                  fleetConfigsBuilder_.addMessage(m);
                }
                break;
              } // case 42
            case 50:
              {
                com.google.cloud.gaming.v1.ScalingConfig m =
                    input.readMessage(
                        com.google.cloud.gaming.v1.ScalingConfig.parser(), extensionRegistry);
                if (scalingConfigsBuilder_ == null) {
                  ensureScalingConfigsIsMutable();
                  scalingConfigs_.add(m);
                } else {
                  scalingConfigsBuilder_.addMessage(m);
                }
                break;
              } // case 50
            case 58:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The resource name of the game server config, in the following form:
     * `projects/{project}/locations/{location}/gameServerDeployments/{deployment}/configs/{config}`.
     * For example,
     * `projects/my-project/locations/global/gameServerDeployments/my-game/configs/my-config`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the game server config, in the following form:
     * `projects/{project}/locations/{location}/gameServerDeployments/{deployment}/configs/{config}`.
     * For example,
     * `projects/my-project/locations/global/gameServerDeployments/my-game/configs/my-config`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the game server config, in the following form:
     * `projects/{project}/locations/{location}/gameServerDeployments/{deployment}/configs/{config}`.
     * For example,
     * `projects/my-project/locations/global/gameServerDeployments/my-game/configs/my-config`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the game server config, in the following form:
     * `projects/{project}/locations/{location}/gameServerDeployments/{deployment}/configs/{config}`.
     * For example,
     * `projects/my-project/locations/global/gameServerDeployments/my-game/configs/my-config`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the game server config, in the following form:
     * `projects/{project}/locations/{location}/gameServerDeployments/{deployment}/configs/{config}`.
     * For example,
     * `projects/my-project/locations/global/gameServerDeployments/my-game/configs/my-config`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000002);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The last-modified time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The last-modified time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The last-modified time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last-modified time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last-modified time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last-modified time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last-modified time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The last-modified time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The last-modified time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * The labels associated with this game server config. Each label is a
     * key-value pair.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * The labels associated with this game server config. Each label is a
     * key-value pair.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * The labels associated with this game server config. Each label is a
     * key-value pair.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * The labels associated with this game server config. Each label is a
     * key-value pair.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000008);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The labels associated with this game server config. Each label is a
     * key-value pair.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000008;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * The labels associated with this game server config. Each label is a
     * key-value pair.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000008;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The labels associated with this game server config. Each label is a
     * key-value pair.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000008;
      return this;
    }

    private java.util.List<com.google.cloud.gaming.v1.FleetConfig> fleetConfigs_ =
        java.util.Collections.emptyList();

    private void ensureFleetConfigsIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        fleetConfigs_ =
            new java.util.ArrayList<com.google.cloud.gaming.v1.FleetConfig>(fleetConfigs_);
        bitField0_ |= 0x00000010;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.gaming.v1.FleetConfig,
            com.google.cloud.gaming.v1.FleetConfig.Builder,
            com.google.cloud.gaming.v1.FleetConfigOrBuilder>
        fleetConfigsBuilder_;

    /**
     *
     *
     * <pre>
     * FleetConfig contains a list of Agones fleet specs. Only one FleetConfig
     * is allowed.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.FleetConfig fleet_configs = 5;</code>
     */
    public java.util.List<com.google.cloud.gaming.v1.FleetConfig> getFleetConfigsList() {
      if (fleetConfigsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(fleetConfigs_);
      } else {
        return fleetConfigsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * FleetConfig contains a list of Agones fleet specs. Only one FleetConfig
     * is allowed.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.FleetConfig fleet_configs = 5;</code>
     */
    public int getFleetConfigsCount() {
      if (fleetConfigsBuilder_ == null) {
        return fleetConfigs_.size();
      } else {
        return fleetConfigsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * FleetConfig contains a list of Agones fleet specs. Only one FleetConfig
     * is allowed.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.FleetConfig fleet_configs = 5;</code>
     */
    public com.google.cloud.gaming.v1.FleetConfig getFleetConfigs(int index) {
      if (fleetConfigsBuilder_ == null) {
        return fleetConfigs_.get(index);
      } else {
        return fleetConfigsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * FleetConfig contains a list of Agones fleet specs. Only one FleetConfig
     * is allowed.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.FleetConfig fleet_configs = 5;</code>
     */
    public Builder setFleetConfigs(int index, com.google.cloud.gaming.v1.FleetConfig value) {
      if (fleetConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFleetConfigsIsMutable();
        fleetConfigs_.set(index, value);
        onChanged();
      } else {
        fleetConfigsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * FleetConfig contains a list of Agones fleet specs. Only one FleetConfig
     * is allowed.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.FleetConfig fleet_configs = 5;</code>
     */
    public Builder setFleetConfigs(
        int index, com.google.cloud.gaming.v1.FleetConfig.Builder builderForValue) {
      if (fleetConfigsBuilder_ == null) {
        ensureFleetConfigsIsMutable();
        fleetConfigs_.set(index, builderForValue.build());
        onChanged();
      } else {
        fleetConfigsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * FleetConfig contains a list of Agones fleet specs. Only one FleetConfig
     * is allowed.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.FleetConfig fleet_configs = 5;</code>
     */
    public Builder addFleetConfigs(com.google.cloud.gaming.v1.FleetConfig value) {
      if (fleetConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFleetConfigsIsMutable();
        fleetConfigs_.add(value);
        onChanged();
      } else {
        fleetConfigsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * FleetConfig contains a list of Agones fleet specs. Only one FleetConfig
     * is allowed.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.FleetConfig fleet_configs = 5;</code>
     */
    public Builder addFleetConfigs(int index, com.google.cloud.gaming.v1.FleetConfig value) {
      if (fleetConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFleetConfigsIsMutable();
        fleetConfigs_.add(index, value);
        onChanged();
      } else {
        fleetConfigsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * FleetConfig contains a list of Agones fleet specs. Only one FleetConfig
     * is allowed.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.FleetConfig fleet_configs = 5;</code>
     */
    public Builder addFleetConfigs(com.google.cloud.gaming.v1.FleetConfig.Builder builderForValue) {
      if (fleetConfigsBuilder_ == null) {
        ensureFleetConfigsIsMutable();
        fleetConfigs_.add(builderForValue.build());
        onChanged();
      } else {
        fleetConfigsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * FleetConfig contains a list of Agones fleet specs. Only one FleetConfig
     * is allowed.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.FleetConfig fleet_configs = 5;</code>
     */
    public Builder addFleetConfigs(
        int index, com.google.cloud.gaming.v1.FleetConfig.Builder builderForValue) {
      if (fleetConfigsBuilder_ == null) {
        ensureFleetConfigsIsMutable();
        fleetConfigs_.add(index, builderForValue.build());
        onChanged();
      } else {
        fleetConfigsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * FleetConfig contains a list of Agones fleet specs. Only one FleetConfig
     * is allowed.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.FleetConfig fleet_configs = 5;</code>
     */
    public Builder addAllFleetConfigs(
        java.lang.Iterable<? extends com.google.cloud.gaming.v1.FleetConfig> values) {
      if (fleetConfigsBuilder_ == null) {
        ensureFleetConfigsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, fleetConfigs_);
        onChanged();
      } else {
        fleetConfigsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * FleetConfig contains a list of Agones fleet specs. Only one FleetConfig
     * is allowed.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.FleetConfig fleet_configs = 5;</code>
     */
    public Builder clearFleetConfigs() {
      if (fleetConfigsBuilder_ == null) {
        fleetConfigs_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        fleetConfigsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * FleetConfig contains a list of Agones fleet specs. Only one FleetConfig
     * is allowed.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.FleetConfig fleet_configs = 5;</code>
     */
    public Builder removeFleetConfigs(int index) {
      if (fleetConfigsBuilder_ == null) {
        ensureFleetConfigsIsMutable();
        fleetConfigs_.remove(index);
        onChanged();
      } else {
        fleetConfigsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * FleetConfig contains a list of Agones fleet specs. Only one FleetConfig
     * is allowed.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.FleetConfig fleet_configs = 5;</code>
     */
    public com.google.cloud.gaming.v1.FleetConfig.Builder getFleetConfigsBuilder(int index) {
      return getFleetConfigsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * FleetConfig contains a list of Agones fleet specs. Only one FleetConfig
     * is allowed.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.FleetConfig fleet_configs = 5;</code>
     */
    public com.google.cloud.gaming.v1.FleetConfigOrBuilder getFleetConfigsOrBuilder(int index) {
      if (fleetConfigsBuilder_ == null) {
        return fleetConfigs_.get(index);
      } else {
        return fleetConfigsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * FleetConfig contains a list of Agones fleet specs. Only one FleetConfig
     * is allowed.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.FleetConfig fleet_configs = 5;</code>
     */
    public java.util.List<? extends com.google.cloud.gaming.v1.FleetConfigOrBuilder>
        getFleetConfigsOrBuilderList() {
      if (fleetConfigsBuilder_ != null) {
        return fleetConfigsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(fleetConfigs_);
      }
    }
    /**
     *
     *
     * <pre>
     * FleetConfig contains a list of Agones fleet specs. Only one FleetConfig
     * is allowed.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.FleetConfig fleet_configs = 5;</code>
     */
    public com.google.cloud.gaming.v1.FleetConfig.Builder addFleetConfigsBuilder() {
      return getFleetConfigsFieldBuilder()
          .addBuilder(com.google.cloud.gaming.v1.FleetConfig.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * FleetConfig contains a list of Agones fleet specs. Only one FleetConfig
     * is allowed.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.FleetConfig fleet_configs = 5;</code>
     */
    public com.google.cloud.gaming.v1.FleetConfig.Builder addFleetConfigsBuilder(int index) {
      return getFleetConfigsFieldBuilder()
          .addBuilder(index, com.google.cloud.gaming.v1.FleetConfig.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * FleetConfig contains a list of Agones fleet specs. Only one FleetConfig
     * is allowed.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.FleetConfig fleet_configs = 5;</code>
     */
    public java.util.List<com.google.cloud.gaming.v1.FleetConfig.Builder>
        getFleetConfigsBuilderList() {
      return getFleetConfigsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.gaming.v1.FleetConfig,
            com.google.cloud.gaming.v1.FleetConfig.Builder,
            com.google.cloud.gaming.v1.FleetConfigOrBuilder>
        getFleetConfigsFieldBuilder() {
      if (fleetConfigsBuilder_ == null) {
        fleetConfigsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.gaming.v1.FleetConfig,
                com.google.cloud.gaming.v1.FleetConfig.Builder,
                com.google.cloud.gaming.v1.FleetConfigOrBuilder>(
                fleetConfigs_, ((bitField0_ & 0x00000010) != 0), getParentForChildren(), isClean());
        fleetConfigs_ = null;
      }
      return fleetConfigsBuilder_;
    }

    private java.util.List<com.google.cloud.gaming.v1.ScalingConfig> scalingConfigs_ =
        java.util.Collections.emptyList();

    private void ensureScalingConfigsIsMutable() {
      if (!((bitField0_ & 0x00000020) != 0)) {
        scalingConfigs_ =
            new java.util.ArrayList<com.google.cloud.gaming.v1.ScalingConfig>(scalingConfigs_);
        bitField0_ |= 0x00000020;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.gaming.v1.ScalingConfig,
            com.google.cloud.gaming.v1.ScalingConfig.Builder,
            com.google.cloud.gaming.v1.ScalingConfigOrBuilder>
        scalingConfigsBuilder_;

    /**
     *
     *
     * <pre>
     * The autoscaling settings.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.ScalingConfig scaling_configs = 6;</code>
     */
    public java.util.List<com.google.cloud.gaming.v1.ScalingConfig> getScalingConfigsList() {
      if (scalingConfigsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(scalingConfigs_);
      } else {
        return scalingConfigsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The autoscaling settings.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.ScalingConfig scaling_configs = 6;</code>
     */
    public int getScalingConfigsCount() {
      if (scalingConfigsBuilder_ == null) {
        return scalingConfigs_.size();
      } else {
        return scalingConfigsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The autoscaling settings.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.ScalingConfig scaling_configs = 6;</code>
     */
    public com.google.cloud.gaming.v1.ScalingConfig getScalingConfigs(int index) {
      if (scalingConfigsBuilder_ == null) {
        return scalingConfigs_.get(index);
      } else {
        return scalingConfigsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The autoscaling settings.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.ScalingConfig scaling_configs = 6;</code>
     */
    public Builder setScalingConfigs(int index, com.google.cloud.gaming.v1.ScalingConfig value) {
      if (scalingConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureScalingConfigsIsMutable();
        scalingConfigs_.set(index, value);
        onChanged();
      } else {
        scalingConfigsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The autoscaling settings.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.ScalingConfig scaling_configs = 6;</code>
     */
    public Builder setScalingConfigs(
        int index, com.google.cloud.gaming.v1.ScalingConfig.Builder builderForValue) {
      if (scalingConfigsBuilder_ == null) {
        ensureScalingConfigsIsMutable();
        scalingConfigs_.set(index, builderForValue.build());
        onChanged();
      } else {
        scalingConfigsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The autoscaling settings.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.ScalingConfig scaling_configs = 6;</code>
     */
    public Builder addScalingConfigs(com.google.cloud.gaming.v1.ScalingConfig value) {
      if (scalingConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureScalingConfigsIsMutable();
        scalingConfigs_.add(value);
        onChanged();
      } else {
        scalingConfigsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The autoscaling settings.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.ScalingConfig scaling_configs = 6;</code>
     */
    public Builder addScalingConfigs(int index, com.google.cloud.gaming.v1.ScalingConfig value) {
      if (scalingConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureScalingConfigsIsMutable();
        scalingConfigs_.add(index, value);
        onChanged();
      } else {
        scalingConfigsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The autoscaling settings.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.ScalingConfig scaling_configs = 6;</code>
     */
    public Builder addScalingConfigs(
        com.google.cloud.gaming.v1.ScalingConfig.Builder builderForValue) {
      if (scalingConfigsBuilder_ == null) {
        ensureScalingConfigsIsMutable();
        scalingConfigs_.add(builderForValue.build());
        onChanged();
      } else {
        scalingConfigsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The autoscaling settings.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.ScalingConfig scaling_configs = 6;</code>
     */
    public Builder addScalingConfigs(
        int index, com.google.cloud.gaming.v1.ScalingConfig.Builder builderForValue) {
      if (scalingConfigsBuilder_ == null) {
        ensureScalingConfigsIsMutable();
        scalingConfigs_.add(index, builderForValue.build());
        onChanged();
      } else {
        scalingConfigsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The autoscaling settings.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.ScalingConfig scaling_configs = 6;</code>
     */
    public Builder addAllScalingConfigs(
        java.lang.Iterable<? extends com.google.cloud.gaming.v1.ScalingConfig> values) {
      if (scalingConfigsBuilder_ == null) {
        ensureScalingConfigsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, scalingConfigs_);
        onChanged();
      } else {
        scalingConfigsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The autoscaling settings.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.ScalingConfig scaling_configs = 6;</code>
     */
    public Builder clearScalingConfigs() {
      if (scalingConfigsBuilder_ == null) {
        scalingConfigs_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
      } else {
        scalingConfigsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The autoscaling settings.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.ScalingConfig scaling_configs = 6;</code>
     */
    public Builder removeScalingConfigs(int index) {
      if (scalingConfigsBuilder_ == null) {
        ensureScalingConfigsIsMutable();
        scalingConfigs_.remove(index);
        onChanged();
      } else {
        scalingConfigsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The autoscaling settings.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.ScalingConfig scaling_configs = 6;</code>
     */
    public com.google.cloud.gaming.v1.ScalingConfig.Builder getScalingConfigsBuilder(int index) {
      return getScalingConfigsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The autoscaling settings.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.ScalingConfig scaling_configs = 6;</code>
     */
    public com.google.cloud.gaming.v1.ScalingConfigOrBuilder getScalingConfigsOrBuilder(int index) {
      if (scalingConfigsBuilder_ == null) {
        return scalingConfigs_.get(index);
      } else {
        return scalingConfigsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The autoscaling settings.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.ScalingConfig scaling_configs = 6;</code>
     */
    public java.util.List<? extends com.google.cloud.gaming.v1.ScalingConfigOrBuilder>
        getScalingConfigsOrBuilderList() {
      if (scalingConfigsBuilder_ != null) {
        return scalingConfigsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(scalingConfigs_);
      }
    }
    /**
     *
     *
     * <pre>
     * The autoscaling settings.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.ScalingConfig scaling_configs = 6;</code>
     */
    public com.google.cloud.gaming.v1.ScalingConfig.Builder addScalingConfigsBuilder() {
      return getScalingConfigsFieldBuilder()
          .addBuilder(com.google.cloud.gaming.v1.ScalingConfig.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The autoscaling settings.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.ScalingConfig scaling_configs = 6;</code>
     */
    public com.google.cloud.gaming.v1.ScalingConfig.Builder addScalingConfigsBuilder(int index) {
      return getScalingConfigsFieldBuilder()
          .addBuilder(index, com.google.cloud.gaming.v1.ScalingConfig.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The autoscaling settings.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.ScalingConfig scaling_configs = 6;</code>
     */
    public java.util.List<com.google.cloud.gaming.v1.ScalingConfig.Builder>
        getScalingConfigsBuilderList() {
      return getScalingConfigsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.gaming.v1.ScalingConfig,
            com.google.cloud.gaming.v1.ScalingConfig.Builder,
            com.google.cloud.gaming.v1.ScalingConfigOrBuilder>
        getScalingConfigsFieldBuilder() {
      if (scalingConfigsBuilder_ == null) {
        scalingConfigsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.gaming.v1.ScalingConfig,
                com.google.cloud.gaming.v1.ScalingConfig.Builder,
                com.google.cloud.gaming.v1.ScalingConfigOrBuilder>(
                scalingConfigs_,
                ((bitField0_ & 0x00000020) != 0),
                getParentForChildren(),
                isClean());
        scalingConfigs_ = null;
      }
      return scalingConfigsBuilder_;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * The description of the game server config.
     * </pre>
     *
     * <code>string description = 7;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The description of the game server config.
     * </pre>
     *
     * <code>string description = 7;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The description of the game server config.
     * </pre>
     *
     * <code>string description = 7;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The description of the game server config.
     * </pre>
     *
     * <code>string description = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The description of the game server config.
     * </pre>
     *
     * <code>string description = 7;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.gaming.v1.GameServerConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.gaming.v1.GameServerConfig)
  private static final com.google.cloud.gaming.v1.GameServerConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.gaming.v1.GameServerConfig();
  }

  public static com.google.cloud.gaming.v1.GameServerConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<GameServerConfig> PARSER =
      new com.google.protobuf.AbstractParser<GameServerConfig>() {
        @java.lang.Override
        public GameServerConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<GameServerConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<GameServerConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.gaming.v1.GameServerConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
