/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/gaming/v1/game_server_deployments.proto

package com.google.cloud.gaming.v1;

/**
 *
 *
 * <pre>
 * The game server deployment rollout which represents the desired rollout
 * state.
 * </pre>
 *
 * Protobuf type {@code google.cloud.gaming.v1.GameServerDeploymentRollout}
 */
public final class GameServerDeploymentRollout extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.gaming.v1.GameServerDeploymentRollout)
    GameServerDeploymentRolloutOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use GameServerDeploymentRollout.newBuilder() to construct.
  private GameServerDeploymentRollout(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private GameServerDeploymentRollout() {
    name_ = "";
    defaultGameServerConfig_ = "";
    gameServerConfigOverrides_ = java.util.Collections.emptyList();
    etag_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new GameServerDeploymentRollout();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.gaming.v1.GameServerDeployments
        .internal_static_google_cloud_gaming_v1_GameServerDeploymentRollout_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.gaming.v1.GameServerDeployments
        .internal_static_google_cloud_gaming_v1_GameServerDeploymentRollout_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.gaming.v1.GameServerDeploymentRollout.class,
            com.google.cloud.gaming.v1.GameServerDeploymentRollout.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The resource name of the game server deployment rollout, in the following
   * form:
   * `projects/{project}/locations/{location}/gameServerDeployments/{deployment}/rollout`.
   * For example,
   * `projects/my-project/locations/global/gameServerDeployments/my-deployment/rollout`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The resource name of the game server deployment rollout, in the following
   * form:
   * `projects/{project}/locations/{location}/gameServerDeployments/{deployment}/rollout`.
   * For example,
   * `projects/my-project/locations/global/gameServerDeployments/my-deployment/rollout`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The creation time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The creation time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The creation time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The last-modified time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The last-modified time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The last-modified time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int DEFAULT_GAME_SERVER_CONFIG_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object defaultGameServerConfig_ = "";
  /**
   *
   *
   * <pre>
   * The default game server config is applied to all realms unless overridden
   * in the rollout. For example,
   * `projects/my-project/locations/global/gameServerDeployments/my-game/configs/my-config`.
   * </pre>
   *
   * <code>string default_game_server_config = 4;</code>
   *
   * @return The defaultGameServerConfig.
   */
  @java.lang.Override
  public java.lang.String getDefaultGameServerConfig() {
    java.lang.Object ref = defaultGameServerConfig_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      defaultGameServerConfig_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The default game server config is applied to all realms unless overridden
   * in the rollout. For example,
   * `projects/my-project/locations/global/gameServerDeployments/my-game/configs/my-config`.
   * </pre>
   *
   * <code>string default_game_server_config = 4;</code>
   *
   * @return The bytes for defaultGameServerConfig.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDefaultGameServerConfigBytes() {
    java.lang.Object ref = defaultGameServerConfig_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      defaultGameServerConfig_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int GAME_SERVER_CONFIG_OVERRIDES_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.gaming.v1.GameServerConfigOverride>
      gameServerConfigOverrides_;
  /**
   *
   *
   * <pre>
   * Contains the game server config rollout overrides. Overrides are processed
   * in the order they are listed. Once a match is found for a realm, the rest
   * of the list is not processed.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.gaming.v1.GameServerConfigOverride game_server_config_overrides = 5;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.gaming.v1.GameServerConfigOverride>
      getGameServerConfigOverridesList() {
    return gameServerConfigOverrides_;
  }
  /**
   *
   *
   * <pre>
   * Contains the game server config rollout overrides. Overrides are processed
   * in the order they are listed. Once a match is found for a realm, the rest
   * of the list is not processed.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.gaming.v1.GameServerConfigOverride game_server_config_overrides = 5;
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.gaming.v1.GameServerConfigOverrideOrBuilder>
      getGameServerConfigOverridesOrBuilderList() {
    return gameServerConfigOverrides_;
  }
  /**
   *
   *
   * <pre>
   * Contains the game server config rollout overrides. Overrides are processed
   * in the order they are listed. Once a match is found for a realm, the rest
   * of the list is not processed.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.gaming.v1.GameServerConfigOverride game_server_config_overrides = 5;
   * </code>
   */
  @java.lang.Override
  public int getGameServerConfigOverridesCount() {
    return gameServerConfigOverrides_.size();
  }
  /**
   *
   *
   * <pre>
   * Contains the game server config rollout overrides. Overrides are processed
   * in the order they are listed. Once a match is found for a realm, the rest
   * of the list is not processed.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.gaming.v1.GameServerConfigOverride game_server_config_overrides = 5;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.gaming.v1.GameServerConfigOverride getGameServerConfigOverrides(
      int index) {
    return gameServerConfigOverrides_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Contains the game server config rollout overrides. Overrides are processed
   * in the order they are listed. Once a match is found for a realm, the rest
   * of the list is not processed.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.gaming.v1.GameServerConfigOverride game_server_config_overrides = 5;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.gaming.v1.GameServerConfigOverrideOrBuilder
      getGameServerConfigOverridesOrBuilder(int index) {
    return gameServerConfigOverrides_.get(index);
  }

  public static final int ETAG_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object etag_ = "";
  /**
   *
   *
   * <pre>
   * ETag of the resource.
   * </pre>
   *
   * <code>string etag = 6;</code>
   *
   * @return The etag.
   */
  @java.lang.Override
  public java.lang.String getEtag() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      etag_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * ETag of the resource.
   * </pre>
   *
   * <code>string etag = 6;</code>
   *
   * @return The bytes for etag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEtagBytes() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      etag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (createTime_ != null) {
      output.writeMessage(2, getCreateTime());
    }
    if (updateTime_ != null) {
      output.writeMessage(3, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(defaultGameServerConfig_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, defaultGameServerConfig_);
    }
    for (int i = 0; i < gameServerConfigOverrides_.size(); i++) {
      output.writeMessage(5, gameServerConfigOverrides_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, etag_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getCreateTime());
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(defaultGameServerConfig_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, defaultGameServerConfig_);
    }
    for (int i = 0; i < gameServerConfigOverrides_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, gameServerConfigOverrides_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, etag_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.gaming.v1.GameServerDeploymentRollout)) {
      return super.equals(obj);
    }
    com.google.cloud.gaming.v1.GameServerDeploymentRollout other =
        (com.google.cloud.gaming.v1.GameServerDeploymentRollout) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!getDefaultGameServerConfig().equals(other.getDefaultGameServerConfig())) return false;
    if (!getGameServerConfigOverridesList().equals(other.getGameServerConfigOverridesList()))
      return false;
    if (!getEtag().equals(other.getEtag())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    hash = (37 * hash) + DEFAULT_GAME_SERVER_CONFIG_FIELD_NUMBER;
    hash = (53 * hash) + getDefaultGameServerConfig().hashCode();
    if (getGameServerConfigOverridesCount() > 0) {
      hash = (37 * hash) + GAME_SERVER_CONFIG_OVERRIDES_FIELD_NUMBER;
      hash = (53 * hash) + getGameServerConfigOverridesList().hashCode();
    }
    hash = (37 * hash) + ETAG_FIELD_NUMBER;
    hash = (53 * hash) + getEtag().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.gaming.v1.GameServerDeploymentRollout parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gaming.v1.GameServerDeploymentRollout parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gaming.v1.GameServerDeploymentRollout parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gaming.v1.GameServerDeploymentRollout parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gaming.v1.GameServerDeploymentRollout parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gaming.v1.GameServerDeploymentRollout parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gaming.v1.GameServerDeploymentRollout parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.gaming.v1.GameServerDeploymentRollout parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.gaming.v1.GameServerDeploymentRollout parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.gaming.v1.GameServerDeploymentRollout parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.gaming.v1.GameServerDeploymentRollout parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.gaming.v1.GameServerDeploymentRollout parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.gaming.v1.GameServerDeploymentRollout prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The game server deployment rollout which represents the desired rollout
   * state.
   * </pre>
   *
   * Protobuf type {@code google.cloud.gaming.v1.GameServerDeploymentRollout}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.gaming.v1.GameServerDeploymentRollout)
      com.google.cloud.gaming.v1.GameServerDeploymentRolloutOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.gaming.v1.GameServerDeployments
          .internal_static_google_cloud_gaming_v1_GameServerDeploymentRollout_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.gaming.v1.GameServerDeployments
          .internal_static_google_cloud_gaming_v1_GameServerDeploymentRollout_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.gaming.v1.GameServerDeploymentRollout.class,
              com.google.cloud.gaming.v1.GameServerDeploymentRollout.Builder.class);
    }

    // Construct using com.google.cloud.gaming.v1.GameServerDeploymentRollout.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      defaultGameServerConfig_ = "";
      if (gameServerConfigOverridesBuilder_ == null) {
        gameServerConfigOverrides_ = java.util.Collections.emptyList();
      } else {
        gameServerConfigOverrides_ = null;
        gameServerConfigOverridesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000010);
      etag_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.gaming.v1.GameServerDeployments
          .internal_static_google_cloud_gaming_v1_GameServerDeploymentRollout_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.gaming.v1.GameServerDeploymentRollout getDefaultInstanceForType() {
      return com.google.cloud.gaming.v1.GameServerDeploymentRollout.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.gaming.v1.GameServerDeploymentRollout build() {
      com.google.cloud.gaming.v1.GameServerDeploymentRollout result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.gaming.v1.GameServerDeploymentRollout buildPartial() {
      com.google.cloud.gaming.v1.GameServerDeploymentRollout result =
          new com.google.cloud.gaming.v1.GameServerDeploymentRollout(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.gaming.v1.GameServerDeploymentRollout result) {
      if (gameServerConfigOverridesBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)) {
          gameServerConfigOverrides_ =
              java.util.Collections.unmodifiableList(gameServerConfigOverrides_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.gameServerConfigOverrides_ = gameServerConfigOverrides_;
      } else {
        result.gameServerConfigOverrides_ = gameServerConfigOverridesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.gaming.v1.GameServerDeploymentRollout result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.defaultGameServerConfig_ = defaultGameServerConfig_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.etag_ = etag_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.gaming.v1.GameServerDeploymentRollout) {
        return mergeFrom((com.google.cloud.gaming.v1.GameServerDeploymentRollout) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.gaming.v1.GameServerDeploymentRollout other) {
      if (other == com.google.cloud.gaming.v1.GameServerDeploymentRollout.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (!other.getDefaultGameServerConfig().isEmpty()) {
        defaultGameServerConfig_ = other.defaultGameServerConfig_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (gameServerConfigOverridesBuilder_ == null) {
        if (!other.gameServerConfigOverrides_.isEmpty()) {
          if (gameServerConfigOverrides_.isEmpty()) {
            gameServerConfigOverrides_ = other.gameServerConfigOverrides_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureGameServerConfigOverridesIsMutable();
            gameServerConfigOverrides_.addAll(other.gameServerConfigOverrides_);
          }
          onChanged();
        }
      } else {
        if (!other.gameServerConfigOverrides_.isEmpty()) {
          if (gameServerConfigOverridesBuilder_.isEmpty()) {
            gameServerConfigOverridesBuilder_.dispose();
            gameServerConfigOverridesBuilder_ = null;
            gameServerConfigOverrides_ = other.gameServerConfigOverrides_;
            bitField0_ = (bitField0_ & ~0x00000010);
            gameServerConfigOverridesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getGameServerConfigOverridesFieldBuilder()
                    : null;
          } else {
            gameServerConfigOverridesBuilder_.addAllMessages(other.gameServerConfigOverrides_);
          }
        }
      }
      if (!other.getEtag().isEmpty()) {
        etag_ = other.etag_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                defaultGameServerConfig_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                com.google.cloud.gaming.v1.GameServerConfigOverride m =
                    input.readMessage(
                        com.google.cloud.gaming.v1.GameServerConfigOverride.parser(),
                        extensionRegistry);
                if (gameServerConfigOverridesBuilder_ == null) {
                  ensureGameServerConfigOverridesIsMutable();
                  gameServerConfigOverrides_.add(m);
                } else {
                  gameServerConfigOverridesBuilder_.addMessage(m);
                }
                break;
              } // case 42
            case 50:
              {
                etag_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The resource name of the game server deployment rollout, in the following
     * form:
     * `projects/{project}/locations/{location}/gameServerDeployments/{deployment}/rollout`.
     * For example,
     * `projects/my-project/locations/global/gameServerDeployments/my-deployment/rollout`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the game server deployment rollout, in the following
     * form:
     * `projects/{project}/locations/{location}/gameServerDeployments/{deployment}/rollout`.
     * For example,
     * `projects/my-project/locations/global/gameServerDeployments/my-deployment/rollout`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the game server deployment rollout, in the following
     * form:
     * `projects/{project}/locations/{location}/gameServerDeployments/{deployment}/rollout`.
     * For example,
     * `projects/my-project/locations/global/gameServerDeployments/my-deployment/rollout`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the game server deployment rollout, in the following
     * form:
     * `projects/{project}/locations/{location}/gameServerDeployments/{deployment}/rollout`.
     * For example,
     * `projects/my-project/locations/global/gameServerDeployments/my-deployment/rollout`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the game server deployment rollout, in the following
     * form:
     * `projects/{project}/locations/{location}/gameServerDeployments/{deployment}/rollout`.
     * For example,
     * `projects/my-project/locations/global/gameServerDeployments/my-deployment/rollout`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000002);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The last-modified time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The last-modified time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The last-modified time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last-modified time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last-modified time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last-modified time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last-modified time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The last-modified time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The last-modified time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private java.lang.Object defaultGameServerConfig_ = "";
    /**
     *
     *
     * <pre>
     * The default game server config is applied to all realms unless overridden
     * in the rollout. For example,
     * `projects/my-project/locations/global/gameServerDeployments/my-game/configs/my-config`.
     * </pre>
     *
     * <code>string default_game_server_config = 4;</code>
     *
     * @return The defaultGameServerConfig.
     */
    public java.lang.String getDefaultGameServerConfig() {
      java.lang.Object ref = defaultGameServerConfig_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        defaultGameServerConfig_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The default game server config is applied to all realms unless overridden
     * in the rollout. For example,
     * `projects/my-project/locations/global/gameServerDeployments/my-game/configs/my-config`.
     * </pre>
     *
     * <code>string default_game_server_config = 4;</code>
     *
     * @return The bytes for defaultGameServerConfig.
     */
    public com.google.protobuf.ByteString getDefaultGameServerConfigBytes() {
      java.lang.Object ref = defaultGameServerConfig_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        defaultGameServerConfig_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The default game server config is applied to all realms unless overridden
     * in the rollout. For example,
     * `projects/my-project/locations/global/gameServerDeployments/my-game/configs/my-config`.
     * </pre>
     *
     * <code>string default_game_server_config = 4;</code>
     *
     * @param value The defaultGameServerConfig to set.
     * @return This builder for chaining.
     */
    public Builder setDefaultGameServerConfig(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      defaultGameServerConfig_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The default game server config is applied to all realms unless overridden
     * in the rollout. For example,
     * `projects/my-project/locations/global/gameServerDeployments/my-game/configs/my-config`.
     * </pre>
     *
     * <code>string default_game_server_config = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDefaultGameServerConfig() {
      defaultGameServerConfig_ = getDefaultInstance().getDefaultGameServerConfig();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The default game server config is applied to all realms unless overridden
     * in the rollout. For example,
     * `projects/my-project/locations/global/gameServerDeployments/my-game/configs/my-config`.
     * </pre>
     *
     * <code>string default_game_server_config = 4;</code>
     *
     * @param value The bytes for defaultGameServerConfig to set.
     * @return This builder for chaining.
     */
    public Builder setDefaultGameServerConfigBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      defaultGameServerConfig_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.gaming.v1.GameServerConfigOverride>
        gameServerConfigOverrides_ = java.util.Collections.emptyList();

    private void ensureGameServerConfigOverridesIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        gameServerConfigOverrides_ =
            new java.util.ArrayList<com.google.cloud.gaming.v1.GameServerConfigOverride>(
                gameServerConfigOverrides_);
        bitField0_ |= 0x00000010;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.gaming.v1.GameServerConfigOverride,
            com.google.cloud.gaming.v1.GameServerConfigOverride.Builder,
            com.google.cloud.gaming.v1.GameServerConfigOverrideOrBuilder>
        gameServerConfigOverridesBuilder_;

    /**
     *
     *
     * <pre>
     * Contains the game server config rollout overrides. Overrides are processed
     * in the order they are listed. Once a match is found for a realm, the rest
     * of the list is not processed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gaming.v1.GameServerConfigOverride game_server_config_overrides = 5;
     * </code>
     */
    public java.util.List<com.google.cloud.gaming.v1.GameServerConfigOverride>
        getGameServerConfigOverridesList() {
      if (gameServerConfigOverridesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(gameServerConfigOverrides_);
      } else {
        return gameServerConfigOverridesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Contains the game server config rollout overrides. Overrides are processed
     * in the order they are listed. Once a match is found for a realm, the rest
     * of the list is not processed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gaming.v1.GameServerConfigOverride game_server_config_overrides = 5;
     * </code>
     */
    public int getGameServerConfigOverridesCount() {
      if (gameServerConfigOverridesBuilder_ == null) {
        return gameServerConfigOverrides_.size();
      } else {
        return gameServerConfigOverridesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Contains the game server config rollout overrides. Overrides are processed
     * in the order they are listed. Once a match is found for a realm, the rest
     * of the list is not processed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gaming.v1.GameServerConfigOverride game_server_config_overrides = 5;
     * </code>
     */
    public com.google.cloud.gaming.v1.GameServerConfigOverride getGameServerConfigOverrides(
        int index) {
      if (gameServerConfigOverridesBuilder_ == null) {
        return gameServerConfigOverrides_.get(index);
      } else {
        return gameServerConfigOverridesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Contains the game server config rollout overrides. Overrides are processed
     * in the order they are listed. Once a match is found for a realm, the rest
     * of the list is not processed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gaming.v1.GameServerConfigOverride game_server_config_overrides = 5;
     * </code>
     */
    public Builder setGameServerConfigOverrides(
        int index, com.google.cloud.gaming.v1.GameServerConfigOverride value) {
      if (gameServerConfigOverridesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGameServerConfigOverridesIsMutable();
        gameServerConfigOverrides_.set(index, value);
        onChanged();
      } else {
        gameServerConfigOverridesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contains the game server config rollout overrides. Overrides are processed
     * in the order they are listed. Once a match is found for a realm, the rest
     * of the list is not processed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gaming.v1.GameServerConfigOverride game_server_config_overrides = 5;
     * </code>
     */
    public Builder setGameServerConfigOverrides(
        int index, com.google.cloud.gaming.v1.GameServerConfigOverride.Builder builderForValue) {
      if (gameServerConfigOverridesBuilder_ == null) {
        ensureGameServerConfigOverridesIsMutable();
        gameServerConfigOverrides_.set(index, builderForValue.build());
        onChanged();
      } else {
        gameServerConfigOverridesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contains the game server config rollout overrides. Overrides are processed
     * in the order they are listed. Once a match is found for a realm, the rest
     * of the list is not processed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gaming.v1.GameServerConfigOverride game_server_config_overrides = 5;
     * </code>
     */
    public Builder addGameServerConfigOverrides(
        com.google.cloud.gaming.v1.GameServerConfigOverride value) {
      if (gameServerConfigOverridesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGameServerConfigOverridesIsMutable();
        gameServerConfigOverrides_.add(value);
        onChanged();
      } else {
        gameServerConfigOverridesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contains the game server config rollout overrides. Overrides are processed
     * in the order they are listed. Once a match is found for a realm, the rest
     * of the list is not processed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gaming.v1.GameServerConfigOverride game_server_config_overrides = 5;
     * </code>
     */
    public Builder addGameServerConfigOverrides(
        int index, com.google.cloud.gaming.v1.GameServerConfigOverride value) {
      if (gameServerConfigOverridesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGameServerConfigOverridesIsMutable();
        gameServerConfigOverrides_.add(index, value);
        onChanged();
      } else {
        gameServerConfigOverridesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contains the game server config rollout overrides. Overrides are processed
     * in the order they are listed. Once a match is found for a realm, the rest
     * of the list is not processed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gaming.v1.GameServerConfigOverride game_server_config_overrides = 5;
     * </code>
     */
    public Builder addGameServerConfigOverrides(
        com.google.cloud.gaming.v1.GameServerConfigOverride.Builder builderForValue) {
      if (gameServerConfigOverridesBuilder_ == null) {
        ensureGameServerConfigOverridesIsMutable();
        gameServerConfigOverrides_.add(builderForValue.build());
        onChanged();
      } else {
        gameServerConfigOverridesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contains the game server config rollout overrides. Overrides are processed
     * in the order they are listed. Once a match is found for a realm, the rest
     * of the list is not processed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gaming.v1.GameServerConfigOverride game_server_config_overrides = 5;
     * </code>
     */
    public Builder addGameServerConfigOverrides(
        int index, com.google.cloud.gaming.v1.GameServerConfigOverride.Builder builderForValue) {
      if (gameServerConfigOverridesBuilder_ == null) {
        ensureGameServerConfigOverridesIsMutable();
        gameServerConfigOverrides_.add(index, builderForValue.build());
        onChanged();
      } else {
        gameServerConfigOverridesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contains the game server config rollout overrides. Overrides are processed
     * in the order they are listed. Once a match is found for a realm, the rest
     * of the list is not processed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gaming.v1.GameServerConfigOverride game_server_config_overrides = 5;
     * </code>
     */
    public Builder addAllGameServerConfigOverrides(
        java.lang.Iterable<? extends com.google.cloud.gaming.v1.GameServerConfigOverride> values) {
      if (gameServerConfigOverridesBuilder_ == null) {
        ensureGameServerConfigOverridesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, gameServerConfigOverrides_);
        onChanged();
      } else {
        gameServerConfigOverridesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contains the game server config rollout overrides. Overrides are processed
     * in the order they are listed. Once a match is found for a realm, the rest
     * of the list is not processed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gaming.v1.GameServerConfigOverride game_server_config_overrides = 5;
     * </code>
     */
    public Builder clearGameServerConfigOverrides() {
      if (gameServerConfigOverridesBuilder_ == null) {
        gameServerConfigOverrides_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        gameServerConfigOverridesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contains the game server config rollout overrides. Overrides are processed
     * in the order they are listed. Once a match is found for a realm, the rest
     * of the list is not processed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gaming.v1.GameServerConfigOverride game_server_config_overrides = 5;
     * </code>
     */
    public Builder removeGameServerConfigOverrides(int index) {
      if (gameServerConfigOverridesBuilder_ == null) {
        ensureGameServerConfigOverridesIsMutable();
        gameServerConfigOverrides_.remove(index);
        onChanged();
      } else {
        gameServerConfigOverridesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contains the game server config rollout overrides. Overrides are processed
     * in the order they are listed. Once a match is found for a realm, the rest
     * of the list is not processed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gaming.v1.GameServerConfigOverride game_server_config_overrides = 5;
     * </code>
     */
    public com.google.cloud.gaming.v1.GameServerConfigOverride.Builder
        getGameServerConfigOverridesBuilder(int index) {
      return getGameServerConfigOverridesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Contains the game server config rollout overrides. Overrides are processed
     * in the order they are listed. Once a match is found for a realm, the rest
     * of the list is not processed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gaming.v1.GameServerConfigOverride game_server_config_overrides = 5;
     * </code>
     */
    public com.google.cloud.gaming.v1.GameServerConfigOverrideOrBuilder
        getGameServerConfigOverridesOrBuilder(int index) {
      if (gameServerConfigOverridesBuilder_ == null) {
        return gameServerConfigOverrides_.get(index);
      } else {
        return gameServerConfigOverridesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Contains the game server config rollout overrides. Overrides are processed
     * in the order they are listed. Once a match is found for a realm, the rest
     * of the list is not processed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gaming.v1.GameServerConfigOverride game_server_config_overrides = 5;
     * </code>
     */
    public java.util.List<? extends com.google.cloud.gaming.v1.GameServerConfigOverrideOrBuilder>
        getGameServerConfigOverridesOrBuilderList() {
      if (gameServerConfigOverridesBuilder_ != null) {
        return gameServerConfigOverridesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(gameServerConfigOverrides_);
      }
    }
    /**
     *
     *
     * <pre>
     * Contains the game server config rollout overrides. Overrides are processed
     * in the order they are listed. Once a match is found for a realm, the rest
     * of the list is not processed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gaming.v1.GameServerConfigOverride game_server_config_overrides = 5;
     * </code>
     */
    public com.google.cloud.gaming.v1.GameServerConfigOverride.Builder
        addGameServerConfigOverridesBuilder() {
      return getGameServerConfigOverridesFieldBuilder()
          .addBuilder(com.google.cloud.gaming.v1.GameServerConfigOverride.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Contains the game server config rollout overrides. Overrides are processed
     * in the order they are listed. Once a match is found for a realm, the rest
     * of the list is not processed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gaming.v1.GameServerConfigOverride game_server_config_overrides = 5;
     * </code>
     */
    public com.google.cloud.gaming.v1.GameServerConfigOverride.Builder
        addGameServerConfigOverridesBuilder(int index) {
      return getGameServerConfigOverridesFieldBuilder()
          .addBuilder(
              index, com.google.cloud.gaming.v1.GameServerConfigOverride.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Contains the game server config rollout overrides. Overrides are processed
     * in the order they are listed. Once a match is found for a realm, the rest
     * of the list is not processed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gaming.v1.GameServerConfigOverride game_server_config_overrides = 5;
     * </code>
     */
    public java.util.List<com.google.cloud.gaming.v1.GameServerConfigOverride.Builder>
        getGameServerConfigOverridesBuilderList() {
      return getGameServerConfigOverridesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.gaming.v1.GameServerConfigOverride,
            com.google.cloud.gaming.v1.GameServerConfigOverride.Builder,
            com.google.cloud.gaming.v1.GameServerConfigOverrideOrBuilder>
        getGameServerConfigOverridesFieldBuilder() {
      if (gameServerConfigOverridesBuilder_ == null) {
        gameServerConfigOverridesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.gaming.v1.GameServerConfigOverride,
                com.google.cloud.gaming.v1.GameServerConfigOverride.Builder,
                com.google.cloud.gaming.v1.GameServerConfigOverrideOrBuilder>(
                gameServerConfigOverrides_,
                ((bitField0_ & 0x00000010) != 0),
                getParentForChildren(),
                isClean());
        gameServerConfigOverrides_ = null;
      }
      return gameServerConfigOverridesBuilder_;
    }

    private java.lang.Object etag_ = "";
    /**
     *
     *
     * <pre>
     * ETag of the resource.
     * </pre>
     *
     * <code>string etag = 6;</code>
     *
     * @return The etag.
     */
    public java.lang.String getEtag() {
      java.lang.Object ref = etag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        etag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * ETag of the resource.
     * </pre>
     *
     * <code>string etag = 6;</code>
     *
     * @return The bytes for etag.
     */
    public com.google.protobuf.ByteString getEtagBytes() {
      java.lang.Object ref = etag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        etag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * ETag of the resource.
     * </pre>
     *
     * <code>string etag = 6;</code>
     *
     * @param value The etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      etag_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * ETag of the resource.
     * </pre>
     *
     * <code>string etag = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEtag() {
      etag_ = getDefaultInstance().getEtag();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * ETag of the resource.
     * </pre>
     *
     * <code>string etag = 6;</code>
     *
     * @param value The bytes for etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      etag_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.gaming.v1.GameServerDeploymentRollout)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.gaming.v1.GameServerDeploymentRollout)
  private static final com.google.cloud.gaming.v1.GameServerDeploymentRollout DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.gaming.v1.GameServerDeploymentRollout();
  }

  public static com.google.cloud.gaming.v1.GameServerDeploymentRollout getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<GameServerDeploymentRollout> PARSER =
      new com.google.protobuf.AbstractParser<GameServerDeploymentRollout>() {
        @java.lang.Override
        public GameServerDeploymentRollout parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<GameServerDeploymentRollout> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<GameServerDeploymentRollout> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.gaming.v1.GameServerDeploymentRollout getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
