/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/gaming/v1/game_server_clusters.proto

package com.google.cloud.gaming.v1;

/**
 *
 *
 * <pre>
 * The state of the Kubernetes cluster.
 * </pre>
 *
 * Protobuf type {@code google.cloud.gaming.v1.KubernetesClusterState}
 */
public final class KubernetesClusterState extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.gaming.v1.KubernetesClusterState)
    KubernetesClusterStateOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use KubernetesClusterState.newBuilder() to construct.
  private KubernetesClusterState(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private KubernetesClusterState() {
    agonesVersionInstalled_ = "";
    kubernetesVersionInstalled_ = "";
    installationState_ = 0;
    versionInstalledErrorMessage_ = "";
    provider_ = "";
    agonesVersionTargeted_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new KubernetesClusterState();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.gaming.v1.GameServerClusters
        .internal_static_google_cloud_gaming_v1_KubernetesClusterState_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.gaming.v1.GameServerClusters
        .internal_static_google_cloud_gaming_v1_KubernetesClusterState_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.gaming.v1.KubernetesClusterState.class,
            com.google.cloud.gaming.v1.KubernetesClusterState.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The state of the installed versions of Agones/Kubernetes. See also
   * https://cloud.google.com/game-servers/docs/versions-and-upgrades.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.gaming.v1.KubernetesClusterState.InstallationState}
   */
  public enum InstallationState implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The default value. This value is used if the state is omitted.
     * </pre>
     *
     * <code>INSTALLATION_STATE_UNSPECIFIED = 0;</code>
     */
    INSTALLATION_STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The combination of Agones and Kubernetes versions is supported by Google
     * Cloud Game Servers.
     * </pre>
     *
     * <code>AGONES_KUBERNETES_VERSION_SUPPORTED = 1;</code>
     */
    AGONES_KUBERNETES_VERSION_SUPPORTED(1),
    /**
     *
     *
     * <pre>
     * The installed version of Agones is not supported by Google Cloud Game
     * Servers.
     * </pre>
     *
     * <code>AGONES_VERSION_UNSUPPORTED = 2;</code>
     */
    AGONES_VERSION_UNSUPPORTED(2),
    /**
     *
     *
     * <pre>
     * The installed version of Agones is supported by Google Cloud Game
     * Servers, but the installed version of Kubernetes is not recommended or
     * supported by the version of Agones.
     * </pre>
     *
     * <code>AGONES_KUBERNETES_VERSION_UNSUPPORTED = 3;</code>
     */
    AGONES_KUBERNETES_VERSION_UNSUPPORTED(3),
    /**
     *
     *
     * <pre>
     * The installed version of Agones is not recognized because the Agones
     * controller's image name does not have a version string reported as
     * {major}.{minor}(.{patch}).
     * </pre>
     *
     * <code>AGONES_VERSION_UNRECOGNIZED = 4;</code>
     */
    AGONES_VERSION_UNRECOGNIZED(4),
    /**
     *
     *
     * <pre>
     * The server version of Kubernetes cluster is not recognized because the
     * API server didn't return parsable version info on path/version.
     * </pre>
     *
     * <code>KUBERNETES_VERSION_UNRECOGNIZED = 5;</code>
     */
    KUBERNETES_VERSION_UNRECOGNIZED(5),
    /**
     *
     *
     * <pre>
     * Failed to read or verify the version of Agones or Kubernetes. See
     * version_installed_error_message for details.
     * </pre>
     *
     * <code>VERSION_VERIFICATION_FAILED = 6;</code>
     */
    VERSION_VERIFICATION_FAILED(6),
    /**
     *
     *
     * <pre>
     * Agones is not installed.
     * </pre>
     *
     * <code>AGONES_NOT_INSTALLED = 7;</code>
     */
    AGONES_NOT_INSTALLED(7),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The default value. This value is used if the state is omitted.
     * </pre>
     *
     * <code>INSTALLATION_STATE_UNSPECIFIED = 0;</code>
     */
    public static final int INSTALLATION_STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The combination of Agones and Kubernetes versions is supported by Google
     * Cloud Game Servers.
     * </pre>
     *
     * <code>AGONES_KUBERNETES_VERSION_SUPPORTED = 1;</code>
     */
    public static final int AGONES_KUBERNETES_VERSION_SUPPORTED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The installed version of Agones is not supported by Google Cloud Game
     * Servers.
     * </pre>
     *
     * <code>AGONES_VERSION_UNSUPPORTED = 2;</code>
     */
    public static final int AGONES_VERSION_UNSUPPORTED_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The installed version of Agones is supported by Google Cloud Game
     * Servers, but the installed version of Kubernetes is not recommended or
     * supported by the version of Agones.
     * </pre>
     *
     * <code>AGONES_KUBERNETES_VERSION_UNSUPPORTED = 3;</code>
     */
    public static final int AGONES_KUBERNETES_VERSION_UNSUPPORTED_VALUE = 3;
    /**
     *
     *
     * <pre>
     * The installed version of Agones is not recognized because the Agones
     * controller's image name does not have a version string reported as
     * {major}.{minor}(.{patch}).
     * </pre>
     *
     * <code>AGONES_VERSION_UNRECOGNIZED = 4;</code>
     */
    public static final int AGONES_VERSION_UNRECOGNIZED_VALUE = 4;
    /**
     *
     *
     * <pre>
     * The server version of Kubernetes cluster is not recognized because the
     * API server didn't return parsable version info on path/version.
     * </pre>
     *
     * <code>KUBERNETES_VERSION_UNRECOGNIZED = 5;</code>
     */
    public static final int KUBERNETES_VERSION_UNRECOGNIZED_VALUE = 5;
    /**
     *
     *
     * <pre>
     * Failed to read or verify the version of Agones or Kubernetes. See
     * version_installed_error_message for details.
     * </pre>
     *
     * <code>VERSION_VERIFICATION_FAILED = 6;</code>
     */
    public static final int VERSION_VERIFICATION_FAILED_VALUE = 6;
    /**
     *
     *
     * <pre>
     * Agones is not installed.
     * </pre>
     *
     * <code>AGONES_NOT_INSTALLED = 7;</code>
     */
    public static final int AGONES_NOT_INSTALLED_VALUE = 7;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static InstallationState valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static InstallationState forNumber(int value) {
      switch (value) {
        case 0:
          return INSTALLATION_STATE_UNSPECIFIED;
        case 1:
          return AGONES_KUBERNETES_VERSION_SUPPORTED;
        case 2:
          return AGONES_VERSION_UNSUPPORTED;
        case 3:
          return AGONES_KUBERNETES_VERSION_UNSUPPORTED;
        case 4:
          return AGONES_VERSION_UNRECOGNIZED;
        case 5:
          return KUBERNETES_VERSION_UNRECOGNIZED;
        case 6:
          return VERSION_VERIFICATION_FAILED;
        case 7:
          return AGONES_NOT_INSTALLED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<InstallationState>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<InstallationState>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<InstallationState>() {
              public InstallationState findValueByNumber(int number) {
                return InstallationState.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.gaming.v1.KubernetesClusterState.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final InstallationState[] VALUES = values();

    public static InstallationState valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private InstallationState(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.gaming.v1.KubernetesClusterState.InstallationState)
  }

  public static final int AGONES_VERSION_INSTALLED_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object agonesVersionInstalled_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The version of Agones currently installed in the registered Kubernetes
   * cluster.
   * </pre>
   *
   * <code>string agones_version_installed = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The agonesVersionInstalled.
   */
  @java.lang.Override
  public java.lang.String getAgonesVersionInstalled() {
    java.lang.Object ref = agonesVersionInstalled_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      agonesVersionInstalled_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The version of Agones currently installed in the registered Kubernetes
   * cluster.
   * </pre>
   *
   * <code>string agones_version_installed = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for agonesVersionInstalled.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAgonesVersionInstalledBytes() {
    java.lang.Object ref = agonesVersionInstalled_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      agonesVersionInstalled_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int KUBERNETES_VERSION_INSTALLED_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object kubernetesVersionInstalled_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The version of Kubernetes that is currently used in the registered
   * Kubernetes cluster (as detected by the Cloud Game Servers service).
   * </pre>
   *
   * <code>string kubernetes_version_installed = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The kubernetesVersionInstalled.
   */
  @java.lang.Override
  public java.lang.String getKubernetesVersionInstalled() {
    java.lang.Object ref = kubernetesVersionInstalled_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kubernetesVersionInstalled_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The version of Kubernetes that is currently used in the registered
   * Kubernetes cluster (as detected by the Cloud Game Servers service).
   * </pre>
   *
   * <code>string kubernetes_version_installed = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The bytes for kubernetesVersionInstalled.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKubernetesVersionInstalledBytes() {
    java.lang.Object ref = kubernetesVersionInstalled_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kubernetesVersionInstalled_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INSTALLATION_STATE_FIELD_NUMBER = 3;
  private int installationState_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The state for the installed versions of Agones/Kubernetes.
   * </pre>
   *
   * <code>
   * .google.cloud.gaming.v1.KubernetesClusterState.InstallationState installation_state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for installationState.
   */
  @java.lang.Override
  public int getInstallationStateValue() {
    return installationState_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The state for the installed versions of Agones/Kubernetes.
   * </pre>
   *
   * <code>
   * .google.cloud.gaming.v1.KubernetesClusterState.InstallationState installation_state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The installationState.
   */
  @java.lang.Override
  public com.google.cloud.gaming.v1.KubernetesClusterState.InstallationState
      getInstallationState() {
    com.google.cloud.gaming.v1.KubernetesClusterState.InstallationState result =
        com.google.cloud.gaming.v1.KubernetesClusterState.InstallationState.forNumber(
            installationState_);
    return result == null
        ? com.google.cloud.gaming.v1.KubernetesClusterState.InstallationState.UNRECOGNIZED
        : result;
  }

  public static final int VERSION_INSTALLED_ERROR_MESSAGE_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object versionInstalledErrorMessage_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The detailed error message for the installed versions of Agones/Kubernetes.
   * </pre>
   *
   * <code>string version_installed_error_message = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The versionInstalledErrorMessage.
   */
  @java.lang.Override
  public java.lang.String getVersionInstalledErrorMessage() {
    java.lang.Object ref = versionInstalledErrorMessage_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      versionInstalledErrorMessage_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The detailed error message for the installed versions of Agones/Kubernetes.
   * </pre>
   *
   * <code>string version_installed_error_message = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The bytes for versionInstalledErrorMessage.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getVersionInstalledErrorMessageBytes() {
    java.lang.Object ref = versionInstalledErrorMessage_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      versionInstalledErrorMessage_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PROVIDER_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object provider_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The cloud provider type reported by the first node's providerID in the list
   * of nodes on the Kubernetes endpoint. On Kubernetes platforms that support
   * zero-node clusters (like GKE-on-GCP), the provider type will be empty.
   * </pre>
   *
   * <code>string provider = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The provider.
   */
  @java.lang.Override
  public java.lang.String getProvider() {
    java.lang.Object ref = provider_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      provider_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The cloud provider type reported by the first node's providerID in the list
   * of nodes on the Kubernetes endpoint. On Kubernetes platforms that support
   * zero-node clusters (like GKE-on-GCP), the provider type will be empty.
   * </pre>
   *
   * <code>string provider = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for provider.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getProviderBytes() {
    java.lang.Object ref = provider_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      provider_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int AGONES_VERSION_TARGETED_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object agonesVersionTargeted_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The version of Agones that is targeted to be installed in the cluster.
   * </pre>
   *
   * <code>string agones_version_targeted = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The agonesVersionTargeted.
   */
  @java.lang.Override
  public java.lang.String getAgonesVersionTargeted() {
    java.lang.Object ref = agonesVersionTargeted_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      agonesVersionTargeted_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The version of Agones that is targeted to be installed in the cluster.
   * </pre>
   *
   * <code>string agones_version_targeted = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for agonesVersionTargeted.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAgonesVersionTargetedBytes() {
    java.lang.Object ref = agonesVersionTargeted_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      agonesVersionTargeted_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(agonesVersionInstalled_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, agonesVersionInstalled_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kubernetesVersionInstalled_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, kubernetesVersionInstalled_);
    }
    if (installationState_
        != com.google.cloud.gaming.v1.KubernetesClusterState.InstallationState
            .INSTALLATION_STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(3, installationState_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(versionInstalledErrorMessage_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, versionInstalledErrorMessage_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(provider_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, provider_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(agonesVersionTargeted_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, agonesVersionTargeted_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(agonesVersionInstalled_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, agonesVersionInstalled_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kubernetesVersionInstalled_)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(2, kubernetesVersionInstalled_);
    }
    if (installationState_
        != com.google.cloud.gaming.v1.KubernetesClusterState.InstallationState
            .INSTALLATION_STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, installationState_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(versionInstalledErrorMessage_)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              4, versionInstalledErrorMessage_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(provider_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, provider_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(agonesVersionTargeted_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, agonesVersionTargeted_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.gaming.v1.KubernetesClusterState)) {
      return super.equals(obj);
    }
    com.google.cloud.gaming.v1.KubernetesClusterState other =
        (com.google.cloud.gaming.v1.KubernetesClusterState) obj;

    if (!getAgonesVersionInstalled().equals(other.getAgonesVersionInstalled())) return false;
    if (!getKubernetesVersionInstalled().equals(other.getKubernetesVersionInstalled()))
      return false;
    if (installationState_ != other.installationState_) return false;
    if (!getVersionInstalledErrorMessage().equals(other.getVersionInstalledErrorMessage()))
      return false;
    if (!getProvider().equals(other.getProvider())) return false;
    if (!getAgonesVersionTargeted().equals(other.getAgonesVersionTargeted())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + AGONES_VERSION_INSTALLED_FIELD_NUMBER;
    hash = (53 * hash) + getAgonesVersionInstalled().hashCode();
    hash = (37 * hash) + KUBERNETES_VERSION_INSTALLED_FIELD_NUMBER;
    hash = (53 * hash) + getKubernetesVersionInstalled().hashCode();
    hash = (37 * hash) + INSTALLATION_STATE_FIELD_NUMBER;
    hash = (53 * hash) + installationState_;
    hash = (37 * hash) + VERSION_INSTALLED_ERROR_MESSAGE_FIELD_NUMBER;
    hash = (53 * hash) + getVersionInstalledErrorMessage().hashCode();
    hash = (37 * hash) + PROVIDER_FIELD_NUMBER;
    hash = (53 * hash) + getProvider().hashCode();
    hash = (37 * hash) + AGONES_VERSION_TARGETED_FIELD_NUMBER;
    hash = (53 * hash) + getAgonesVersionTargeted().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.gaming.v1.KubernetesClusterState parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gaming.v1.KubernetesClusterState parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gaming.v1.KubernetesClusterState parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gaming.v1.KubernetesClusterState parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gaming.v1.KubernetesClusterState parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gaming.v1.KubernetesClusterState parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gaming.v1.KubernetesClusterState parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.gaming.v1.KubernetesClusterState parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.gaming.v1.KubernetesClusterState parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.gaming.v1.KubernetesClusterState parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.gaming.v1.KubernetesClusterState parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.gaming.v1.KubernetesClusterState parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.gaming.v1.KubernetesClusterState prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The state of the Kubernetes cluster.
   * </pre>
   *
   * Protobuf type {@code google.cloud.gaming.v1.KubernetesClusterState}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.gaming.v1.KubernetesClusterState)
      com.google.cloud.gaming.v1.KubernetesClusterStateOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.gaming.v1.GameServerClusters
          .internal_static_google_cloud_gaming_v1_KubernetesClusterState_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.gaming.v1.GameServerClusters
          .internal_static_google_cloud_gaming_v1_KubernetesClusterState_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.gaming.v1.KubernetesClusterState.class,
              com.google.cloud.gaming.v1.KubernetesClusterState.Builder.class);
    }

    // Construct using com.google.cloud.gaming.v1.KubernetesClusterState.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      agonesVersionInstalled_ = "";
      kubernetesVersionInstalled_ = "";
      installationState_ = 0;
      versionInstalledErrorMessage_ = "";
      provider_ = "";
      agonesVersionTargeted_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.gaming.v1.GameServerClusters
          .internal_static_google_cloud_gaming_v1_KubernetesClusterState_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.gaming.v1.KubernetesClusterState getDefaultInstanceForType() {
      return com.google.cloud.gaming.v1.KubernetesClusterState.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.gaming.v1.KubernetesClusterState build() {
      com.google.cloud.gaming.v1.KubernetesClusterState result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.gaming.v1.KubernetesClusterState buildPartial() {
      com.google.cloud.gaming.v1.KubernetesClusterState result =
          new com.google.cloud.gaming.v1.KubernetesClusterState(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.gaming.v1.KubernetesClusterState result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.agonesVersionInstalled_ = agonesVersionInstalled_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.kubernetesVersionInstalled_ = kubernetesVersionInstalled_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.installationState_ = installationState_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.versionInstalledErrorMessage_ = versionInstalledErrorMessage_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.provider_ = provider_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.agonesVersionTargeted_ = agonesVersionTargeted_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.gaming.v1.KubernetesClusterState) {
        return mergeFrom((com.google.cloud.gaming.v1.KubernetesClusterState) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.gaming.v1.KubernetesClusterState other) {
      if (other == com.google.cloud.gaming.v1.KubernetesClusterState.getDefaultInstance())
        return this;
      if (!other.getAgonesVersionInstalled().isEmpty()) {
        agonesVersionInstalled_ = other.agonesVersionInstalled_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getKubernetesVersionInstalled().isEmpty()) {
        kubernetesVersionInstalled_ = other.kubernetesVersionInstalled_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.installationState_ != 0) {
        setInstallationStateValue(other.getInstallationStateValue());
      }
      if (!other.getVersionInstalledErrorMessage().isEmpty()) {
        versionInstalledErrorMessage_ = other.versionInstalledErrorMessage_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getProvider().isEmpty()) {
        provider_ = other.provider_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.getAgonesVersionTargeted().isEmpty()) {
        agonesVersionTargeted_ = other.agonesVersionTargeted_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                agonesVersionInstalled_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                kubernetesVersionInstalled_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                installationState_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 34:
              {
                versionInstalledErrorMessage_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                provider_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                agonesVersionTargeted_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object agonesVersionInstalled_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The version of Agones currently installed in the registered Kubernetes
     * cluster.
     * </pre>
     *
     * <code>string agones_version_installed = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The agonesVersionInstalled.
     */
    public java.lang.String getAgonesVersionInstalled() {
      java.lang.Object ref = agonesVersionInstalled_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        agonesVersionInstalled_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The version of Agones currently installed in the registered Kubernetes
     * cluster.
     * </pre>
     *
     * <code>string agones_version_installed = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The bytes for agonesVersionInstalled.
     */
    public com.google.protobuf.ByteString getAgonesVersionInstalledBytes() {
      java.lang.Object ref = agonesVersionInstalled_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        agonesVersionInstalled_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The version of Agones currently installed in the registered Kubernetes
     * cluster.
     * </pre>
     *
     * <code>string agones_version_installed = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The agonesVersionInstalled to set.
     * @return This builder for chaining.
     */
    public Builder setAgonesVersionInstalled(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      agonesVersionInstalled_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The version of Agones currently installed in the registered Kubernetes
     * cluster.
     * </pre>
     *
     * <code>string agones_version_installed = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAgonesVersionInstalled() {
      agonesVersionInstalled_ = getDefaultInstance().getAgonesVersionInstalled();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The version of Agones currently installed in the registered Kubernetes
     * cluster.
     * </pre>
     *
     * <code>string agones_version_installed = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The bytes for agonesVersionInstalled to set.
     * @return This builder for chaining.
     */
    public Builder setAgonesVersionInstalledBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      agonesVersionInstalled_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object kubernetesVersionInstalled_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The version of Kubernetes that is currently used in the registered
     * Kubernetes cluster (as detected by the Cloud Game Servers service).
     * </pre>
     *
     * <code>string kubernetes_version_installed = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The kubernetesVersionInstalled.
     */
    public java.lang.String getKubernetesVersionInstalled() {
      java.lang.Object ref = kubernetesVersionInstalled_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kubernetesVersionInstalled_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The version of Kubernetes that is currently used in the registered
     * Kubernetes cluster (as detected by the Cloud Game Servers service).
     * </pre>
     *
     * <code>string kubernetes_version_installed = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The bytes for kubernetesVersionInstalled.
     */
    public com.google.protobuf.ByteString getKubernetesVersionInstalledBytes() {
      java.lang.Object ref = kubernetesVersionInstalled_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kubernetesVersionInstalled_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The version of Kubernetes that is currently used in the registered
     * Kubernetes cluster (as detected by the Cloud Game Servers service).
     * </pre>
     *
     * <code>string kubernetes_version_installed = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The kubernetesVersionInstalled to set.
     * @return This builder for chaining.
     */
    public Builder setKubernetesVersionInstalled(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kubernetesVersionInstalled_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The version of Kubernetes that is currently used in the registered
     * Kubernetes cluster (as detected by the Cloud Game Servers service).
     * </pre>
     *
     * <code>string kubernetes_version_installed = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKubernetesVersionInstalled() {
      kubernetesVersionInstalled_ = getDefaultInstance().getKubernetesVersionInstalled();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The version of Kubernetes that is currently used in the registered
     * Kubernetes cluster (as detected by the Cloud Game Servers service).
     * </pre>
     *
     * <code>string kubernetes_version_installed = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The bytes for kubernetesVersionInstalled to set.
     * @return This builder for chaining.
     */
    public Builder setKubernetesVersionInstalledBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kubernetesVersionInstalled_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private int installationState_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The state for the installed versions of Agones/Kubernetes.
     * </pre>
     *
     * <code>
     * .google.cloud.gaming.v1.KubernetesClusterState.InstallationState installation_state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for installationState.
     */
    @java.lang.Override
    public int getInstallationStateValue() {
      return installationState_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state for the installed versions of Agones/Kubernetes.
     * </pre>
     *
     * <code>
     * .google.cloud.gaming.v1.KubernetesClusterState.InstallationState installation_state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for installationState to set.
     * @return This builder for chaining.
     */
    public Builder setInstallationStateValue(int value) {
      installationState_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state for the installed versions of Agones/Kubernetes.
     * </pre>
     *
     * <code>
     * .google.cloud.gaming.v1.KubernetesClusterState.InstallationState installation_state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The installationState.
     */
    @java.lang.Override
    public com.google.cloud.gaming.v1.KubernetesClusterState.InstallationState
        getInstallationState() {
      com.google.cloud.gaming.v1.KubernetesClusterState.InstallationState result =
          com.google.cloud.gaming.v1.KubernetesClusterState.InstallationState.forNumber(
              installationState_);
      return result == null
          ? com.google.cloud.gaming.v1.KubernetesClusterState.InstallationState.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state for the installed versions of Agones/Kubernetes.
     * </pre>
     *
     * <code>
     * .google.cloud.gaming.v1.KubernetesClusterState.InstallationState installation_state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The installationState to set.
     * @return This builder for chaining.
     */
    public Builder setInstallationState(
        com.google.cloud.gaming.v1.KubernetesClusterState.InstallationState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      installationState_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state for the installed versions of Agones/Kubernetes.
     * </pre>
     *
     * <code>
     * .google.cloud.gaming.v1.KubernetesClusterState.InstallationState installation_state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInstallationState() {
      bitField0_ = (bitField0_ & ~0x00000004);
      installationState_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object versionInstalledErrorMessage_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The detailed error message for the installed versions of Agones/Kubernetes.
     * </pre>
     *
     * <code>
     * string version_installed_error_message = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The versionInstalledErrorMessage.
     */
    public java.lang.String getVersionInstalledErrorMessage() {
      java.lang.Object ref = versionInstalledErrorMessage_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        versionInstalledErrorMessage_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The detailed error message for the installed versions of Agones/Kubernetes.
     * </pre>
     *
     * <code>
     * string version_installed_error_message = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The bytes for versionInstalledErrorMessage.
     */
    public com.google.protobuf.ByteString getVersionInstalledErrorMessageBytes() {
      java.lang.Object ref = versionInstalledErrorMessage_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        versionInstalledErrorMessage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The detailed error message for the installed versions of Agones/Kubernetes.
     * </pre>
     *
     * <code>
     * string version_installed_error_message = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The versionInstalledErrorMessage to set.
     * @return This builder for chaining.
     */
    public Builder setVersionInstalledErrorMessage(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      versionInstalledErrorMessage_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The detailed error message for the installed versions of Agones/Kubernetes.
     * </pre>
     *
     * <code>
     * string version_installed_error_message = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVersionInstalledErrorMessage() {
      versionInstalledErrorMessage_ = getDefaultInstance().getVersionInstalledErrorMessage();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The detailed error message for the installed versions of Agones/Kubernetes.
     * </pre>
     *
     * <code>
     * string version_installed_error_message = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The bytes for versionInstalledErrorMessage to set.
     * @return This builder for chaining.
     */
    public Builder setVersionInstalledErrorMessageBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      versionInstalledErrorMessage_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object provider_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The cloud provider type reported by the first node's providerID in the list
     * of nodes on the Kubernetes endpoint. On Kubernetes platforms that support
     * zero-node clusters (like GKE-on-GCP), the provider type will be empty.
     * </pre>
     *
     * <code>string provider = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The provider.
     */
    public java.lang.String getProvider() {
      java.lang.Object ref = provider_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        provider_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The cloud provider type reported by the first node's providerID in the list
     * of nodes on the Kubernetes endpoint. On Kubernetes platforms that support
     * zero-node clusters (like GKE-on-GCP), the provider type will be empty.
     * </pre>
     *
     * <code>string provider = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for provider.
     */
    public com.google.protobuf.ByteString getProviderBytes() {
      java.lang.Object ref = provider_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        provider_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The cloud provider type reported by the first node's providerID in the list
     * of nodes on the Kubernetes endpoint. On Kubernetes platforms that support
     * zero-node clusters (like GKE-on-GCP), the provider type will be empty.
     * </pre>
     *
     * <code>string provider = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The provider to set.
     * @return This builder for chaining.
     */
    public Builder setProvider(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      provider_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The cloud provider type reported by the first node's providerID in the list
     * of nodes on the Kubernetes endpoint. On Kubernetes platforms that support
     * zero-node clusters (like GKE-on-GCP), the provider type will be empty.
     * </pre>
     *
     * <code>string provider = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProvider() {
      provider_ = getDefaultInstance().getProvider();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The cloud provider type reported by the first node's providerID in the list
     * of nodes on the Kubernetes endpoint. On Kubernetes platforms that support
     * zero-node clusters (like GKE-on-GCP), the provider type will be empty.
     * </pre>
     *
     * <code>string provider = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for provider to set.
     * @return This builder for chaining.
     */
    public Builder setProviderBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      provider_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object agonesVersionTargeted_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The version of Agones that is targeted to be installed in the cluster.
     * </pre>
     *
     * <code>string agones_version_targeted = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The agonesVersionTargeted.
     */
    public java.lang.String getAgonesVersionTargeted() {
      java.lang.Object ref = agonesVersionTargeted_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        agonesVersionTargeted_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The version of Agones that is targeted to be installed in the cluster.
     * </pre>
     *
     * <code>string agones_version_targeted = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for agonesVersionTargeted.
     */
    public com.google.protobuf.ByteString getAgonesVersionTargetedBytes() {
      java.lang.Object ref = agonesVersionTargeted_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        agonesVersionTargeted_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The version of Agones that is targeted to be installed in the cluster.
     * </pre>
     *
     * <code>string agones_version_targeted = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The agonesVersionTargeted to set.
     * @return This builder for chaining.
     */
    public Builder setAgonesVersionTargeted(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      agonesVersionTargeted_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The version of Agones that is targeted to be installed in the cluster.
     * </pre>
     *
     * <code>string agones_version_targeted = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAgonesVersionTargeted() {
      agonesVersionTargeted_ = getDefaultInstance().getAgonesVersionTargeted();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The version of Agones that is targeted to be installed in the cluster.
     * </pre>
     *
     * <code>string agones_version_targeted = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for agonesVersionTargeted to set.
     * @return This builder for chaining.
     */
    public Builder setAgonesVersionTargetedBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      agonesVersionTargeted_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.gaming.v1.KubernetesClusterState)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.gaming.v1.KubernetesClusterState)
  private static final com.google.cloud.gaming.v1.KubernetesClusterState DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.gaming.v1.KubernetesClusterState();
  }

  public static com.google.cloud.gaming.v1.KubernetesClusterState getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<KubernetesClusterState> PARSER =
      new com.google.protobuf.AbstractParser<KubernetesClusterState>() {
        @java.lang.Override
        public KubernetesClusterState parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<KubernetesClusterState> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<KubernetesClusterState> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.gaming.v1.KubernetesClusterState getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
