/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/gaming/v1/game_server_deployments.proto

package com.google.cloud.gaming.v1;

/**
 *
 *
 * <pre>
 * Response message for GameServerDeploymentsService.ListGameServerDeployments.
 * </pre>
 *
 * Protobuf type {@code google.cloud.gaming.v1.ListGameServerDeploymentsResponse}
 */
public final class ListGameServerDeploymentsResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.gaming.v1.ListGameServerDeploymentsResponse)
    ListGameServerDeploymentsResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ListGameServerDeploymentsResponse.newBuilder() to construct.
  private ListGameServerDeploymentsResponse(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ListGameServerDeploymentsResponse() {
    gameServerDeployments_ = java.util.Collections.emptyList();
    nextPageToken_ = "";
    unreachable_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ListGameServerDeploymentsResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.gaming.v1.GameServerDeployments
        .internal_static_google_cloud_gaming_v1_ListGameServerDeploymentsResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.gaming.v1.GameServerDeployments
        .internal_static_google_cloud_gaming_v1_ListGameServerDeploymentsResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.gaming.v1.ListGameServerDeploymentsResponse.class,
            com.google.cloud.gaming.v1.ListGameServerDeploymentsResponse.Builder.class);
  }

  public static final int GAME_SERVER_DEPLOYMENTS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.gaming.v1.GameServerDeployment> gameServerDeployments_;
  /**
   *
   *
   * <pre>
   * The list of game server deployments.
   * </pre>
   *
   * <code>repeated .google.cloud.gaming.v1.GameServerDeployment game_server_deployments = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.gaming.v1.GameServerDeployment>
      getGameServerDeploymentsList() {
    return gameServerDeployments_;
  }
  /**
   *
   *
   * <pre>
   * The list of game server deployments.
   * </pre>
   *
   * <code>repeated .google.cloud.gaming.v1.GameServerDeployment game_server_deployments = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.gaming.v1.GameServerDeploymentOrBuilder>
      getGameServerDeploymentsOrBuilderList() {
    return gameServerDeployments_;
  }
  /**
   *
   *
   * <pre>
   * The list of game server deployments.
   * </pre>
   *
   * <code>repeated .google.cloud.gaming.v1.GameServerDeployment game_server_deployments = 1;</code>
   */
  @java.lang.Override
  public int getGameServerDeploymentsCount() {
    return gameServerDeployments_.size();
  }
  /**
   *
   *
   * <pre>
   * The list of game server deployments.
   * </pre>
   *
   * <code>repeated .google.cloud.gaming.v1.GameServerDeployment game_server_deployments = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.gaming.v1.GameServerDeployment getGameServerDeployments(int index) {
    return gameServerDeployments_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The list of game server deployments.
   * </pre>
   *
   * <code>repeated .google.cloud.gaming.v1.GameServerDeployment game_server_deployments = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.gaming.v1.GameServerDeploymentOrBuilder getGameServerDeploymentsOrBuilder(
      int index) {
    return gameServerDeployments_.get(index);
  }

  public static final int NEXT_PAGE_TOKEN_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object nextPageToken_ = "";
  /**
   *
   *
   * <pre>
   * Token to retrieve the next page of results, or empty if there are no more
   * results in the list.
   * </pre>
   *
   * <code>string next_page_token = 2;</code>
   *
   * @return The nextPageToken.
   */
  @java.lang.Override
  public java.lang.String getNextPageToken() {
    java.lang.Object ref = nextPageToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      nextPageToken_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Token to retrieve the next page of results, or empty if there are no more
   * results in the list.
   * </pre>
   *
   * <code>string next_page_token = 2;</code>
   *
   * @return The bytes for nextPageToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNextPageTokenBytes() {
    java.lang.Object ref = nextPageToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      nextPageToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int UNREACHABLE_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList unreachable_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * List of locations that could not be reached.
   * </pre>
   *
   * <code>repeated string unreachable = 4;</code>
   *
   * @return A list containing the unreachable.
   */
  public com.google.protobuf.ProtocolStringList getUnreachableList() {
    return unreachable_;
  }
  /**
   *
   *
   * <pre>
   * List of locations that could not be reached.
   * </pre>
   *
   * <code>repeated string unreachable = 4;</code>
   *
   * @return The count of unreachable.
   */
  public int getUnreachableCount() {
    return unreachable_.size();
  }
  /**
   *
   *
   * <pre>
   * List of locations that could not be reached.
   * </pre>
   *
   * <code>repeated string unreachable = 4;</code>
   *
   * @param index The index of the element to return.
   * @return The unreachable at the given index.
   */
  public java.lang.String getUnreachable(int index) {
    return unreachable_.get(index);
  }
  /**
   *
   *
   * <pre>
   * List of locations that could not be reached.
   * </pre>
   *
   * <code>repeated string unreachable = 4;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the unreachable at the given index.
   */
  public com.google.protobuf.ByteString getUnreachableBytes(int index) {
    return unreachable_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < gameServerDeployments_.size(); i++) {
      output.writeMessage(1, gameServerDeployments_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, nextPageToken_);
    }
    for (int i = 0; i < unreachable_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, unreachable_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < gameServerDeployments_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, gameServerDeployments_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, nextPageToken_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < unreachable_.size(); i++) {
        dataSize += computeStringSizeNoTag(unreachable_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getUnreachableList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.gaming.v1.ListGameServerDeploymentsResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.gaming.v1.ListGameServerDeploymentsResponse other =
        (com.google.cloud.gaming.v1.ListGameServerDeploymentsResponse) obj;

    if (!getGameServerDeploymentsList().equals(other.getGameServerDeploymentsList())) return false;
    if (!getNextPageToken().equals(other.getNextPageToken())) return false;
    if (!getUnreachableList().equals(other.getUnreachableList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getGameServerDeploymentsCount() > 0) {
      hash = (37 * hash) + GAME_SERVER_DEPLOYMENTS_FIELD_NUMBER;
      hash = (53 * hash) + getGameServerDeploymentsList().hashCode();
    }
    hash = (37 * hash) + NEXT_PAGE_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getNextPageToken().hashCode();
    if (getUnreachableCount() > 0) {
      hash = (37 * hash) + UNREACHABLE_FIELD_NUMBER;
      hash = (53 * hash) + getUnreachableList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.gaming.v1.ListGameServerDeploymentsResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gaming.v1.ListGameServerDeploymentsResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gaming.v1.ListGameServerDeploymentsResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gaming.v1.ListGameServerDeploymentsResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gaming.v1.ListGameServerDeploymentsResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gaming.v1.ListGameServerDeploymentsResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gaming.v1.ListGameServerDeploymentsResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.gaming.v1.ListGameServerDeploymentsResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.gaming.v1.ListGameServerDeploymentsResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.gaming.v1.ListGameServerDeploymentsResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.gaming.v1.ListGameServerDeploymentsResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.gaming.v1.ListGameServerDeploymentsResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.gaming.v1.ListGameServerDeploymentsResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Response message for GameServerDeploymentsService.ListGameServerDeployments.
   * </pre>
   *
   * Protobuf type {@code google.cloud.gaming.v1.ListGameServerDeploymentsResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.gaming.v1.ListGameServerDeploymentsResponse)
      com.google.cloud.gaming.v1.ListGameServerDeploymentsResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.gaming.v1.GameServerDeployments
          .internal_static_google_cloud_gaming_v1_ListGameServerDeploymentsResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.gaming.v1.GameServerDeployments
          .internal_static_google_cloud_gaming_v1_ListGameServerDeploymentsResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.gaming.v1.ListGameServerDeploymentsResponse.class,
              com.google.cloud.gaming.v1.ListGameServerDeploymentsResponse.Builder.class);
    }

    // Construct using com.google.cloud.gaming.v1.ListGameServerDeploymentsResponse.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (gameServerDeploymentsBuilder_ == null) {
        gameServerDeployments_ = java.util.Collections.emptyList();
      } else {
        gameServerDeployments_ = null;
        gameServerDeploymentsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      nextPageToken_ = "";
      unreachable_ = com.google.protobuf.LazyStringArrayList.emptyList();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.gaming.v1.GameServerDeployments
          .internal_static_google_cloud_gaming_v1_ListGameServerDeploymentsResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.gaming.v1.ListGameServerDeploymentsResponse
        getDefaultInstanceForType() {
      return com.google.cloud.gaming.v1.ListGameServerDeploymentsResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.gaming.v1.ListGameServerDeploymentsResponse build() {
      com.google.cloud.gaming.v1.ListGameServerDeploymentsResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.gaming.v1.ListGameServerDeploymentsResponse buildPartial() {
      com.google.cloud.gaming.v1.ListGameServerDeploymentsResponse result =
          new com.google.cloud.gaming.v1.ListGameServerDeploymentsResponse(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.gaming.v1.ListGameServerDeploymentsResponse result) {
      if (gameServerDeploymentsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          gameServerDeployments_ = java.util.Collections.unmodifiableList(gameServerDeployments_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.gameServerDeployments_ = gameServerDeployments_;
      } else {
        result.gameServerDeployments_ = gameServerDeploymentsBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.cloud.gaming.v1.ListGameServerDeploymentsResponse result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.nextPageToken_ = nextPageToken_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        unreachable_.makeImmutable();
        result.unreachable_ = unreachable_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.gaming.v1.ListGameServerDeploymentsResponse) {
        return mergeFrom((com.google.cloud.gaming.v1.ListGameServerDeploymentsResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.gaming.v1.ListGameServerDeploymentsResponse other) {
      if (other
          == com.google.cloud.gaming.v1.ListGameServerDeploymentsResponse.getDefaultInstance())
        return this;
      if (gameServerDeploymentsBuilder_ == null) {
        if (!other.gameServerDeployments_.isEmpty()) {
          if (gameServerDeployments_.isEmpty()) {
            gameServerDeployments_ = other.gameServerDeployments_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureGameServerDeploymentsIsMutable();
            gameServerDeployments_.addAll(other.gameServerDeployments_);
          }
          onChanged();
        }
      } else {
        if (!other.gameServerDeployments_.isEmpty()) {
          if (gameServerDeploymentsBuilder_.isEmpty()) {
            gameServerDeploymentsBuilder_.dispose();
            gameServerDeploymentsBuilder_ = null;
            gameServerDeployments_ = other.gameServerDeployments_;
            bitField0_ = (bitField0_ & ~0x00000001);
            gameServerDeploymentsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getGameServerDeploymentsFieldBuilder()
                    : null;
          } else {
            gameServerDeploymentsBuilder_.addAllMessages(other.gameServerDeployments_);
          }
        }
      }
      if (!other.getNextPageToken().isEmpty()) {
        nextPageToken_ = other.nextPageToken_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.unreachable_.isEmpty()) {
        if (unreachable_.isEmpty()) {
          unreachable_ = other.unreachable_;
          bitField0_ |= 0x00000004;
        } else {
          ensureUnreachableIsMutable();
          unreachable_.addAll(other.unreachable_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.gaming.v1.GameServerDeployment m =
                    input.readMessage(
                        com.google.cloud.gaming.v1.GameServerDeployment.parser(),
                        extensionRegistry);
                if (gameServerDeploymentsBuilder_ == null) {
                  ensureGameServerDeploymentsIsMutable();
                  gameServerDeployments_.add(m);
                } else {
                  gameServerDeploymentsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                nextPageToken_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 34:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureUnreachableIsMutable();
                unreachable_.add(s);
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.gaming.v1.GameServerDeployment> gameServerDeployments_ =
        java.util.Collections.emptyList();

    private void ensureGameServerDeploymentsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        gameServerDeployments_ =
            new java.util.ArrayList<com.google.cloud.gaming.v1.GameServerDeployment>(
                gameServerDeployments_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.gaming.v1.GameServerDeployment,
            com.google.cloud.gaming.v1.GameServerDeployment.Builder,
            com.google.cloud.gaming.v1.GameServerDeploymentOrBuilder>
        gameServerDeploymentsBuilder_;

    /**
     *
     *
     * <pre>
     * The list of game server deployments.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.GameServerDeployment game_server_deployments = 1;
     * </code>
     */
    public java.util.List<com.google.cloud.gaming.v1.GameServerDeployment>
        getGameServerDeploymentsList() {
      if (gameServerDeploymentsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(gameServerDeployments_);
      } else {
        return gameServerDeploymentsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of game server deployments.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.GameServerDeployment game_server_deployments = 1;
     * </code>
     */
    public int getGameServerDeploymentsCount() {
      if (gameServerDeploymentsBuilder_ == null) {
        return gameServerDeployments_.size();
      } else {
        return gameServerDeploymentsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of game server deployments.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.GameServerDeployment game_server_deployments = 1;
     * </code>
     */
    public com.google.cloud.gaming.v1.GameServerDeployment getGameServerDeployments(int index) {
      if (gameServerDeploymentsBuilder_ == null) {
        return gameServerDeployments_.get(index);
      } else {
        return gameServerDeploymentsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of game server deployments.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.GameServerDeployment game_server_deployments = 1;
     * </code>
     */
    public Builder setGameServerDeployments(
        int index, com.google.cloud.gaming.v1.GameServerDeployment value) {
      if (gameServerDeploymentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGameServerDeploymentsIsMutable();
        gameServerDeployments_.set(index, value);
        onChanged();
      } else {
        gameServerDeploymentsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of game server deployments.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.GameServerDeployment game_server_deployments = 1;
     * </code>
     */
    public Builder setGameServerDeployments(
        int index, com.google.cloud.gaming.v1.GameServerDeployment.Builder builderForValue) {
      if (gameServerDeploymentsBuilder_ == null) {
        ensureGameServerDeploymentsIsMutable();
        gameServerDeployments_.set(index, builderForValue.build());
        onChanged();
      } else {
        gameServerDeploymentsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of game server deployments.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.GameServerDeployment game_server_deployments = 1;
     * </code>
     */
    public Builder addGameServerDeployments(com.google.cloud.gaming.v1.GameServerDeployment value) {
      if (gameServerDeploymentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGameServerDeploymentsIsMutable();
        gameServerDeployments_.add(value);
        onChanged();
      } else {
        gameServerDeploymentsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of game server deployments.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.GameServerDeployment game_server_deployments = 1;
     * </code>
     */
    public Builder addGameServerDeployments(
        int index, com.google.cloud.gaming.v1.GameServerDeployment value) {
      if (gameServerDeploymentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGameServerDeploymentsIsMutable();
        gameServerDeployments_.add(index, value);
        onChanged();
      } else {
        gameServerDeploymentsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of game server deployments.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.GameServerDeployment game_server_deployments = 1;
     * </code>
     */
    public Builder addGameServerDeployments(
        com.google.cloud.gaming.v1.GameServerDeployment.Builder builderForValue) {
      if (gameServerDeploymentsBuilder_ == null) {
        ensureGameServerDeploymentsIsMutable();
        gameServerDeployments_.add(builderForValue.build());
        onChanged();
      } else {
        gameServerDeploymentsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of game server deployments.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.GameServerDeployment game_server_deployments = 1;
     * </code>
     */
    public Builder addGameServerDeployments(
        int index, com.google.cloud.gaming.v1.GameServerDeployment.Builder builderForValue) {
      if (gameServerDeploymentsBuilder_ == null) {
        ensureGameServerDeploymentsIsMutable();
        gameServerDeployments_.add(index, builderForValue.build());
        onChanged();
      } else {
        gameServerDeploymentsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of game server deployments.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.GameServerDeployment game_server_deployments = 1;
     * </code>
     */
    public Builder addAllGameServerDeployments(
        java.lang.Iterable<? extends com.google.cloud.gaming.v1.GameServerDeployment> values) {
      if (gameServerDeploymentsBuilder_ == null) {
        ensureGameServerDeploymentsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, gameServerDeployments_);
        onChanged();
      } else {
        gameServerDeploymentsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of game server deployments.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.GameServerDeployment game_server_deployments = 1;
     * </code>
     */
    public Builder clearGameServerDeployments() {
      if (gameServerDeploymentsBuilder_ == null) {
        gameServerDeployments_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        gameServerDeploymentsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of game server deployments.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.GameServerDeployment game_server_deployments = 1;
     * </code>
     */
    public Builder removeGameServerDeployments(int index) {
      if (gameServerDeploymentsBuilder_ == null) {
        ensureGameServerDeploymentsIsMutable();
        gameServerDeployments_.remove(index);
        onChanged();
      } else {
        gameServerDeploymentsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of game server deployments.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.GameServerDeployment game_server_deployments = 1;
     * </code>
     */
    public com.google.cloud.gaming.v1.GameServerDeployment.Builder getGameServerDeploymentsBuilder(
        int index) {
      return getGameServerDeploymentsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The list of game server deployments.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.GameServerDeployment game_server_deployments = 1;
     * </code>
     */
    public com.google.cloud.gaming.v1.GameServerDeploymentOrBuilder
        getGameServerDeploymentsOrBuilder(int index) {
      if (gameServerDeploymentsBuilder_ == null) {
        return gameServerDeployments_.get(index);
      } else {
        return gameServerDeploymentsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of game server deployments.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.GameServerDeployment game_server_deployments = 1;
     * </code>
     */
    public java.util.List<? extends com.google.cloud.gaming.v1.GameServerDeploymentOrBuilder>
        getGameServerDeploymentsOrBuilderList() {
      if (gameServerDeploymentsBuilder_ != null) {
        return gameServerDeploymentsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(gameServerDeployments_);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of game server deployments.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.GameServerDeployment game_server_deployments = 1;
     * </code>
     */
    public com.google.cloud.gaming.v1.GameServerDeployment.Builder
        addGameServerDeploymentsBuilder() {
      return getGameServerDeploymentsFieldBuilder()
          .addBuilder(com.google.cloud.gaming.v1.GameServerDeployment.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The list of game server deployments.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.GameServerDeployment game_server_deployments = 1;
     * </code>
     */
    public com.google.cloud.gaming.v1.GameServerDeployment.Builder addGameServerDeploymentsBuilder(
        int index) {
      return getGameServerDeploymentsFieldBuilder()
          .addBuilder(index, com.google.cloud.gaming.v1.GameServerDeployment.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The list of game server deployments.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.GameServerDeployment game_server_deployments = 1;
     * </code>
     */
    public java.util.List<com.google.cloud.gaming.v1.GameServerDeployment.Builder>
        getGameServerDeploymentsBuilderList() {
      return getGameServerDeploymentsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.gaming.v1.GameServerDeployment,
            com.google.cloud.gaming.v1.GameServerDeployment.Builder,
            com.google.cloud.gaming.v1.GameServerDeploymentOrBuilder>
        getGameServerDeploymentsFieldBuilder() {
      if (gameServerDeploymentsBuilder_ == null) {
        gameServerDeploymentsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.gaming.v1.GameServerDeployment,
                com.google.cloud.gaming.v1.GameServerDeployment.Builder,
                com.google.cloud.gaming.v1.GameServerDeploymentOrBuilder>(
                gameServerDeployments_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        gameServerDeployments_ = null;
      }
      return gameServerDeploymentsBuilder_;
    }

    private java.lang.Object nextPageToken_ = "";
    /**
     *
     *
     * <pre>
     * Token to retrieve the next page of results, or empty if there are no more
     * results in the list.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return The nextPageToken.
     */
    public java.lang.String getNextPageToken() {
      java.lang.Object ref = nextPageToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        nextPageToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Token to retrieve the next page of results, or empty if there are no more
     * results in the list.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return The bytes for nextPageToken.
     */
    public com.google.protobuf.ByteString getNextPageTokenBytes() {
      java.lang.Object ref = nextPageToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        nextPageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Token to retrieve the next page of results, or empty if there are no more
     * results in the list.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @param value The nextPageToken to set.
     * @return This builder for chaining.
     */
    public Builder setNextPageToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      nextPageToken_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Token to retrieve the next page of results, or empty if there are no more
     * results in the list.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNextPageToken() {
      nextPageToken_ = getDefaultInstance().getNextPageToken();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Token to retrieve the next page of results, or empty if there are no more
     * results in the list.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @param value The bytes for nextPageToken to set.
     * @return This builder for chaining.
     */
    public Builder setNextPageTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      nextPageToken_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList unreachable_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureUnreachableIsMutable() {
      if (!unreachable_.isModifiable()) {
        unreachable_ = new com.google.protobuf.LazyStringArrayList(unreachable_);
      }
      bitField0_ |= 0x00000004;
    }
    /**
     *
     *
     * <pre>
     * List of locations that could not be reached.
     * </pre>
     *
     * <code>repeated string unreachable = 4;</code>
     *
     * @return A list containing the unreachable.
     */
    public com.google.protobuf.ProtocolStringList getUnreachableList() {
      unreachable_.makeImmutable();
      return unreachable_;
    }
    /**
     *
     *
     * <pre>
     * List of locations that could not be reached.
     * </pre>
     *
     * <code>repeated string unreachable = 4;</code>
     *
     * @return The count of unreachable.
     */
    public int getUnreachableCount() {
      return unreachable_.size();
    }
    /**
     *
     *
     * <pre>
     * List of locations that could not be reached.
     * </pre>
     *
     * <code>repeated string unreachable = 4;</code>
     *
     * @param index The index of the element to return.
     * @return The unreachable at the given index.
     */
    public java.lang.String getUnreachable(int index) {
      return unreachable_.get(index);
    }
    /**
     *
     *
     * <pre>
     * List of locations that could not be reached.
     * </pre>
     *
     * <code>repeated string unreachable = 4;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the unreachable at the given index.
     */
    public com.google.protobuf.ByteString getUnreachableBytes(int index) {
      return unreachable_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * List of locations that could not be reached.
     * </pre>
     *
     * <code>repeated string unreachable = 4;</code>
     *
     * @param index The index to set the value at.
     * @param value The unreachable to set.
     * @return This builder for chaining.
     */
    public Builder setUnreachable(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureUnreachableIsMutable();
      unreachable_.set(index, value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of locations that could not be reached.
     * </pre>
     *
     * <code>repeated string unreachable = 4;</code>
     *
     * @param value The unreachable to add.
     * @return This builder for chaining.
     */
    public Builder addUnreachable(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureUnreachableIsMutable();
      unreachable_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of locations that could not be reached.
     * </pre>
     *
     * <code>repeated string unreachable = 4;</code>
     *
     * @param values The unreachable to add.
     * @return This builder for chaining.
     */
    public Builder addAllUnreachable(java.lang.Iterable<java.lang.String> values) {
      ensureUnreachableIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, unreachable_);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of locations that could not be reached.
     * </pre>
     *
     * <code>repeated string unreachable = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUnreachable() {
      unreachable_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of locations that could not be reached.
     * </pre>
     *
     * <code>repeated string unreachable = 4;</code>
     *
     * @param value The bytes of the unreachable to add.
     * @return This builder for chaining.
     */
    public Builder addUnreachableBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureUnreachableIsMutable();
      unreachable_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.gaming.v1.ListGameServerDeploymentsResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.gaming.v1.ListGameServerDeploymentsResponse)
  private static final com.google.cloud.gaming.v1.ListGameServerDeploymentsResponse
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.gaming.v1.ListGameServerDeploymentsResponse();
  }

  public static com.google.cloud.gaming.v1.ListGameServerDeploymentsResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ListGameServerDeploymentsResponse> PARSER =
      new com.google.protobuf.AbstractParser<ListGameServerDeploymentsResponse>() {
        @java.lang.Override
        public ListGameServerDeploymentsResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ListGameServerDeploymentsResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ListGameServerDeploymentsResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.gaming.v1.ListGameServerDeploymentsResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
