/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/gaming/v1/common.proto

package com.google.cloud.gaming.v1;

/** Protobuf type {@code google.cloud.gaming.v1.OperationStatus} */
public final class OperationStatus extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.gaming.v1.OperationStatus)
    OperationStatusOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use OperationStatus.newBuilder() to construct.
  private OperationStatus(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private OperationStatus() {
    errorCode_ = 0;
    errorMessage_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new OperationStatus();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.gaming.v1.Common
        .internal_static_google_cloud_gaming_v1_OperationStatus_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.gaming.v1.Common
        .internal_static_google_cloud_gaming_v1_OperationStatus_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.gaming.v1.OperationStatus.class,
            com.google.cloud.gaming.v1.OperationStatus.Builder.class);
  }

  /** Protobuf enum {@code google.cloud.gaming.v1.OperationStatus.ErrorCode} */
  public enum ErrorCode implements com.google.protobuf.ProtocolMessageEnum {
    /** <code>ERROR_CODE_UNSPECIFIED = 0;</code> */
    ERROR_CODE_UNSPECIFIED(0),
    /** <code>INTERNAL_ERROR = 1;</code> */
    INTERNAL_ERROR(1),
    /** <code>PERMISSION_DENIED = 2;</code> */
    PERMISSION_DENIED(2),
    /** <code>CLUSTER_CONNECTION = 3;</code> */
    CLUSTER_CONNECTION(3),
    UNRECOGNIZED(-1),
    ;

    /** <code>ERROR_CODE_UNSPECIFIED = 0;</code> */
    public static final int ERROR_CODE_UNSPECIFIED_VALUE = 0;
    /** <code>INTERNAL_ERROR = 1;</code> */
    public static final int INTERNAL_ERROR_VALUE = 1;
    /** <code>PERMISSION_DENIED = 2;</code> */
    public static final int PERMISSION_DENIED_VALUE = 2;
    /** <code>CLUSTER_CONNECTION = 3;</code> */
    public static final int CLUSTER_CONNECTION_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ErrorCode valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ErrorCode forNumber(int value) {
      switch (value) {
        case 0:
          return ERROR_CODE_UNSPECIFIED;
        case 1:
          return INTERNAL_ERROR;
        case 2:
          return PERMISSION_DENIED;
        case 3:
          return CLUSTER_CONNECTION;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ErrorCode> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ErrorCode> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<ErrorCode>() {
          public ErrorCode findValueByNumber(int number) {
            return ErrorCode.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.gaming.v1.OperationStatus.getDescriptor().getEnumTypes().get(0);
    }

    private static final ErrorCode[] VALUES = values();

    public static ErrorCode valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ErrorCode(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.gaming.v1.OperationStatus.ErrorCode)
  }

  public static final int DONE_FIELD_NUMBER = 1;
  private boolean done_ = false;
  /**
   *
   *
   * <pre>
   * Output only. Whether the operation is done or still in progress.
   * </pre>
   *
   * <code>bool done = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The done.
   */
  @java.lang.Override
  public boolean getDone() {
    return done_;
  }

  public static final int ERROR_CODE_FIELD_NUMBER = 2;
  private int errorCode_ = 0;
  /**
   *
   *
   * <pre>
   * The error code in case of failures.
   * </pre>
   *
   * <code>.google.cloud.gaming.v1.OperationStatus.ErrorCode error_code = 2;</code>
   *
   * @return The enum numeric value on the wire for errorCode.
   */
  @java.lang.Override
  public int getErrorCodeValue() {
    return errorCode_;
  }
  /**
   *
   *
   * <pre>
   * The error code in case of failures.
   * </pre>
   *
   * <code>.google.cloud.gaming.v1.OperationStatus.ErrorCode error_code = 2;</code>
   *
   * @return The errorCode.
   */
  @java.lang.Override
  public com.google.cloud.gaming.v1.OperationStatus.ErrorCode getErrorCode() {
    com.google.cloud.gaming.v1.OperationStatus.ErrorCode result =
        com.google.cloud.gaming.v1.OperationStatus.ErrorCode.forNumber(errorCode_);
    return result == null
        ? com.google.cloud.gaming.v1.OperationStatus.ErrorCode.UNRECOGNIZED
        : result;
  }

  public static final int ERROR_MESSAGE_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object errorMessage_ = "";
  /**
   *
   *
   * <pre>
   * The human-readable error message.
   * </pre>
   *
   * <code>string error_message = 3;</code>
   *
   * @return The errorMessage.
   */
  @java.lang.Override
  public java.lang.String getErrorMessage() {
    java.lang.Object ref = errorMessage_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      errorMessage_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The human-readable error message.
   * </pre>
   *
   * <code>string error_message = 3;</code>
   *
   * @return The bytes for errorMessage.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getErrorMessageBytes() {
    java.lang.Object ref = errorMessage_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      errorMessage_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (done_ != false) {
      output.writeBool(1, done_);
    }
    if (errorCode_
        != com.google.cloud.gaming.v1.OperationStatus.ErrorCode.ERROR_CODE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(2, errorCode_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(errorMessage_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, errorMessage_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (done_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, done_);
    }
    if (errorCode_
        != com.google.cloud.gaming.v1.OperationStatus.ErrorCode.ERROR_CODE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, errorCode_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(errorMessage_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, errorMessage_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.gaming.v1.OperationStatus)) {
      return super.equals(obj);
    }
    com.google.cloud.gaming.v1.OperationStatus other =
        (com.google.cloud.gaming.v1.OperationStatus) obj;

    if (getDone() != other.getDone()) return false;
    if (errorCode_ != other.errorCode_) return false;
    if (!getErrorMessage().equals(other.getErrorMessage())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + DONE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDone());
    hash = (37 * hash) + ERROR_CODE_FIELD_NUMBER;
    hash = (53 * hash) + errorCode_;
    hash = (37 * hash) + ERROR_MESSAGE_FIELD_NUMBER;
    hash = (53 * hash) + getErrorMessage().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.gaming.v1.OperationStatus parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gaming.v1.OperationStatus parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gaming.v1.OperationStatus parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gaming.v1.OperationStatus parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gaming.v1.OperationStatus parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gaming.v1.OperationStatus parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gaming.v1.OperationStatus parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.gaming.v1.OperationStatus parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.gaming.v1.OperationStatus parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.gaming.v1.OperationStatus parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.gaming.v1.OperationStatus parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.gaming.v1.OperationStatus parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.gaming.v1.OperationStatus prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /** Protobuf type {@code google.cloud.gaming.v1.OperationStatus} */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.gaming.v1.OperationStatus)
      com.google.cloud.gaming.v1.OperationStatusOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.gaming.v1.Common
          .internal_static_google_cloud_gaming_v1_OperationStatus_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.gaming.v1.Common
          .internal_static_google_cloud_gaming_v1_OperationStatus_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.gaming.v1.OperationStatus.class,
              com.google.cloud.gaming.v1.OperationStatus.Builder.class);
    }

    // Construct using com.google.cloud.gaming.v1.OperationStatus.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      done_ = false;
      errorCode_ = 0;
      errorMessage_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.gaming.v1.Common
          .internal_static_google_cloud_gaming_v1_OperationStatus_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.gaming.v1.OperationStatus getDefaultInstanceForType() {
      return com.google.cloud.gaming.v1.OperationStatus.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.gaming.v1.OperationStatus build() {
      com.google.cloud.gaming.v1.OperationStatus result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.gaming.v1.OperationStatus buildPartial() {
      com.google.cloud.gaming.v1.OperationStatus result =
          new com.google.cloud.gaming.v1.OperationStatus(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.gaming.v1.OperationStatus result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.done_ = done_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.errorCode_ = errorCode_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.errorMessage_ = errorMessage_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.gaming.v1.OperationStatus) {
        return mergeFrom((com.google.cloud.gaming.v1.OperationStatus) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.gaming.v1.OperationStatus other) {
      if (other == com.google.cloud.gaming.v1.OperationStatus.getDefaultInstance()) return this;
      if (other.getDone() != false) {
        setDone(other.getDone());
      }
      if (other.errorCode_ != 0) {
        setErrorCodeValue(other.getErrorCodeValue());
      }
      if (!other.getErrorMessage().isEmpty()) {
        errorMessage_ = other.errorMessage_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                done_ = input.readBool();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 16:
              {
                errorCode_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                errorMessage_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private boolean done_;
    /**
     *
     *
     * <pre>
     * Output only. Whether the operation is done or still in progress.
     * </pre>
     *
     * <code>bool done = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The done.
     */
    @java.lang.Override
    public boolean getDone() {
      return done_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Whether the operation is done or still in progress.
     * </pre>
     *
     * <code>bool done = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The done to set.
     * @return This builder for chaining.
     */
    public Builder setDone(boolean value) {

      done_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Whether the operation is done or still in progress.
     * </pre>
     *
     * <code>bool done = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDone() {
      bitField0_ = (bitField0_ & ~0x00000001);
      done_ = false;
      onChanged();
      return this;
    }

    private int errorCode_ = 0;
    /**
     *
     *
     * <pre>
     * The error code in case of failures.
     * </pre>
     *
     * <code>.google.cloud.gaming.v1.OperationStatus.ErrorCode error_code = 2;</code>
     *
     * @return The enum numeric value on the wire for errorCode.
     */
    @java.lang.Override
    public int getErrorCodeValue() {
      return errorCode_;
    }
    /**
     *
     *
     * <pre>
     * The error code in case of failures.
     * </pre>
     *
     * <code>.google.cloud.gaming.v1.OperationStatus.ErrorCode error_code = 2;</code>
     *
     * @param value The enum numeric value on the wire for errorCode to set.
     * @return This builder for chaining.
     */
    public Builder setErrorCodeValue(int value) {
      errorCode_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The error code in case of failures.
     * </pre>
     *
     * <code>.google.cloud.gaming.v1.OperationStatus.ErrorCode error_code = 2;</code>
     *
     * @return The errorCode.
     */
    @java.lang.Override
    public com.google.cloud.gaming.v1.OperationStatus.ErrorCode getErrorCode() {
      com.google.cloud.gaming.v1.OperationStatus.ErrorCode result =
          com.google.cloud.gaming.v1.OperationStatus.ErrorCode.forNumber(errorCode_);
      return result == null
          ? com.google.cloud.gaming.v1.OperationStatus.ErrorCode.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The error code in case of failures.
     * </pre>
     *
     * <code>.google.cloud.gaming.v1.OperationStatus.ErrorCode error_code = 2;</code>
     *
     * @param value The errorCode to set.
     * @return This builder for chaining.
     */
    public Builder setErrorCode(com.google.cloud.gaming.v1.OperationStatus.ErrorCode value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      errorCode_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The error code in case of failures.
     * </pre>
     *
     * <code>.google.cloud.gaming.v1.OperationStatus.ErrorCode error_code = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearErrorCode() {
      bitField0_ = (bitField0_ & ~0x00000002);
      errorCode_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object errorMessage_ = "";
    /**
     *
     *
     * <pre>
     * The human-readable error message.
     * </pre>
     *
     * <code>string error_message = 3;</code>
     *
     * @return The errorMessage.
     */
    public java.lang.String getErrorMessage() {
      java.lang.Object ref = errorMessage_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        errorMessage_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The human-readable error message.
     * </pre>
     *
     * <code>string error_message = 3;</code>
     *
     * @return The bytes for errorMessage.
     */
    public com.google.protobuf.ByteString getErrorMessageBytes() {
      java.lang.Object ref = errorMessage_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        errorMessage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The human-readable error message.
     * </pre>
     *
     * <code>string error_message = 3;</code>
     *
     * @param value The errorMessage to set.
     * @return This builder for chaining.
     */
    public Builder setErrorMessage(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      errorMessage_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The human-readable error message.
     * </pre>
     *
     * <code>string error_message = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearErrorMessage() {
      errorMessage_ = getDefaultInstance().getErrorMessage();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The human-readable error message.
     * </pre>
     *
     * <code>string error_message = 3;</code>
     *
     * @param value The bytes for errorMessage to set.
     * @return This builder for chaining.
     */
    public Builder setErrorMessageBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      errorMessage_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.gaming.v1.OperationStatus)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.gaming.v1.OperationStatus)
  private static final com.google.cloud.gaming.v1.OperationStatus DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.gaming.v1.OperationStatus();
  }

  public static com.google.cloud.gaming.v1.OperationStatus getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<OperationStatus> PARSER =
      new com.google.protobuf.AbstractParser<OperationStatus>() {
        @java.lang.Override
        public OperationStatus parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<OperationStatus> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<OperationStatus> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.gaming.v1.OperationStatus getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
