/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/gaming/v1/game_server_clusters.proto

package com.google.cloud.gaming.v1;

public interface PreviewCreateGameServerClusterRequestOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.gaming.v1.PreviewCreateGameServerClusterRequest)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Required. The parent resource name, in the following form:
   * `projects/{project}/locations/{location}/realms/{realm}`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  java.lang.String getParent();
  /**
   *
   *
   * <pre>
   * Required. The parent resource name, in the following form:
   * `projects/{project}/locations/{location}/realms/{realm}`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  com.google.protobuf.ByteString getParentBytes();

  /**
   *
   *
   * <pre>
   * Required. The ID of the game server cluster resource to be created.
   * </pre>
   *
   * <code>string game_server_cluster_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The gameServerClusterId.
   */
  java.lang.String getGameServerClusterId();
  /**
   *
   *
   * <pre>
   * Required. The ID of the game server cluster resource to be created.
   * </pre>
   *
   * <code>string game_server_cluster_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for gameServerClusterId.
   */
  com.google.protobuf.ByteString getGameServerClusterIdBytes();

  /**
   *
   *
   * <pre>
   * Required. The game server cluster resource to be created.
   * </pre>
   *
   * <code>
   * .google.cloud.gaming.v1.GameServerCluster game_server_cluster = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the gameServerCluster field is set.
   */
  boolean hasGameServerCluster();
  /**
   *
   *
   * <pre>
   * Required. The game server cluster resource to be created.
   * </pre>
   *
   * <code>
   * .google.cloud.gaming.v1.GameServerCluster game_server_cluster = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The gameServerCluster.
   */
  com.google.cloud.gaming.v1.GameServerCluster getGameServerCluster();
  /**
   *
   *
   * <pre>
   * Required. The game server cluster resource to be created.
   * </pre>
   *
   * <code>
   * .google.cloud.gaming.v1.GameServerCluster game_server_cluster = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  com.google.cloud.gaming.v1.GameServerClusterOrBuilder getGameServerClusterOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. The target timestamp to compute the preview.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp preview_time = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the previewTime field is set.
   */
  boolean hasPreviewTime();
  /**
   *
   *
   * <pre>
   * Optional. The target timestamp to compute the preview.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp preview_time = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The previewTime.
   */
  com.google.protobuf.Timestamp getPreviewTime();
  /**
   *
   *
   * <pre>
   * Optional. The target timestamp to compute the preview.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp preview_time = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getPreviewTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. This field is deprecated, preview will always return
   * KubernetesClusterState.
   * </pre>
   *
   * <code>
   * .google.cloud.gaming.v1.GameServerClusterView view = 6 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @deprecated google.cloud.gaming.v1.PreviewCreateGameServerClusterRequest.view is deprecated.
   *     See google/cloud/gaming/v1/game_server_clusters.proto;l=153
   * @return The enum numeric value on the wire for view.
   */
  @java.lang.Deprecated
  int getViewValue();
  /**
   *
   *
   * <pre>
   * Optional. This field is deprecated, preview will always return
   * KubernetesClusterState.
   * </pre>
   *
   * <code>
   * .google.cloud.gaming.v1.GameServerClusterView view = 6 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @deprecated google.cloud.gaming.v1.PreviewCreateGameServerClusterRequest.view is deprecated.
   *     See google/cloud/gaming/v1/game_server_clusters.proto;l=153
   * @return The view.
   */
  @java.lang.Deprecated
  com.google.cloud.gaming.v1.GameServerClusterView getView();
}
