/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/gaming/v1/game_server_configs.proto

package com.google.cloud.gaming.v1;

/**
 *
 *
 * <pre>
 * Autoscaling config for an Agones fleet.
 * </pre>
 *
 * Protobuf type {@code google.cloud.gaming.v1.ScalingConfig}
 */
public final class ScalingConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.gaming.v1.ScalingConfig)
    ScalingConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ScalingConfig.newBuilder() to construct.
  private ScalingConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ScalingConfig() {
    name_ = "";
    fleetAutoscalerSpec_ = "";
    selectors_ = java.util.Collections.emptyList();
    schedules_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ScalingConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.gaming.v1.GameServerConfigs
        .internal_static_google_cloud_gaming_v1_ScalingConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.gaming.v1.GameServerConfigs
        .internal_static_google_cloud_gaming_v1_ScalingConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.gaming.v1.ScalingConfig.class,
            com.google.cloud.gaming.v1.ScalingConfig.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Required. The name of the Scaling Config
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The name of the Scaling Config
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FLEET_AUTOSCALER_SPEC_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object fleetAutoscalerSpec_ = "";
  /**
   *
   *
   * <pre>
   * Required. Agones fleet autoscaler spec. Example spec:
   * https://agones.dev/site/docs/reference/fleetautoscaler/
   * </pre>
   *
   * <code>string fleet_autoscaler_spec = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The fleetAutoscalerSpec.
   */
  @java.lang.Override
  public java.lang.String getFleetAutoscalerSpec() {
    java.lang.Object ref = fleetAutoscalerSpec_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      fleetAutoscalerSpec_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Agones fleet autoscaler spec. Example spec:
   * https://agones.dev/site/docs/reference/fleetautoscaler/
   * </pre>
   *
   * <code>string fleet_autoscaler_spec = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for fleetAutoscalerSpec.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFleetAutoscalerSpecBytes() {
    java.lang.Object ref = fleetAutoscalerSpec_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      fleetAutoscalerSpec_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SELECTORS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.gaming.v1.LabelSelector> selectors_;
  /**
   *
   *
   * <pre>
   * Labels used to identify the game server clusters to which this Agones
   * scaling config applies. A game server cluster is subject to this Agones
   * scaling config if its labels match any of the selector entries.
   * </pre>
   *
   * <code>repeated .google.cloud.gaming.v1.LabelSelector selectors = 4;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.gaming.v1.LabelSelector> getSelectorsList() {
    return selectors_;
  }
  /**
   *
   *
   * <pre>
   * Labels used to identify the game server clusters to which this Agones
   * scaling config applies. A game server cluster is subject to this Agones
   * scaling config if its labels match any of the selector entries.
   * </pre>
   *
   * <code>repeated .google.cloud.gaming.v1.LabelSelector selectors = 4;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.gaming.v1.LabelSelectorOrBuilder>
      getSelectorsOrBuilderList() {
    return selectors_;
  }
  /**
   *
   *
   * <pre>
   * Labels used to identify the game server clusters to which this Agones
   * scaling config applies. A game server cluster is subject to this Agones
   * scaling config if its labels match any of the selector entries.
   * </pre>
   *
   * <code>repeated .google.cloud.gaming.v1.LabelSelector selectors = 4;</code>
   */
  @java.lang.Override
  public int getSelectorsCount() {
    return selectors_.size();
  }
  /**
   *
   *
   * <pre>
   * Labels used to identify the game server clusters to which this Agones
   * scaling config applies. A game server cluster is subject to this Agones
   * scaling config if its labels match any of the selector entries.
   * </pre>
   *
   * <code>repeated .google.cloud.gaming.v1.LabelSelector selectors = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.gaming.v1.LabelSelector getSelectors(int index) {
    return selectors_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Labels used to identify the game server clusters to which this Agones
   * scaling config applies. A game server cluster is subject to this Agones
   * scaling config if its labels match any of the selector entries.
   * </pre>
   *
   * <code>repeated .google.cloud.gaming.v1.LabelSelector selectors = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.gaming.v1.LabelSelectorOrBuilder getSelectorsOrBuilder(int index) {
    return selectors_.get(index);
  }

  public static final int SCHEDULES_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.gaming.v1.Schedule> schedules_;
  /**
   *
   *
   * <pre>
   * The schedules to which this Scaling Config applies.
   * </pre>
   *
   * <code>repeated .google.cloud.gaming.v1.Schedule schedules = 5;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.gaming.v1.Schedule> getSchedulesList() {
    return schedules_;
  }
  /**
   *
   *
   * <pre>
   * The schedules to which this Scaling Config applies.
   * </pre>
   *
   * <code>repeated .google.cloud.gaming.v1.Schedule schedules = 5;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.gaming.v1.ScheduleOrBuilder>
      getSchedulesOrBuilderList() {
    return schedules_;
  }
  /**
   *
   *
   * <pre>
   * The schedules to which this Scaling Config applies.
   * </pre>
   *
   * <code>repeated .google.cloud.gaming.v1.Schedule schedules = 5;</code>
   */
  @java.lang.Override
  public int getSchedulesCount() {
    return schedules_.size();
  }
  /**
   *
   *
   * <pre>
   * The schedules to which this Scaling Config applies.
   * </pre>
   *
   * <code>repeated .google.cloud.gaming.v1.Schedule schedules = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.gaming.v1.Schedule getSchedules(int index) {
    return schedules_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The schedules to which this Scaling Config applies.
   * </pre>
   *
   * <code>repeated .google.cloud.gaming.v1.Schedule schedules = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.gaming.v1.ScheduleOrBuilder getSchedulesOrBuilder(int index) {
    return schedules_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fleetAutoscalerSpec_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, fleetAutoscalerSpec_);
    }
    for (int i = 0; i < selectors_.size(); i++) {
      output.writeMessage(4, selectors_.get(i));
    }
    for (int i = 0; i < schedules_.size(); i++) {
      output.writeMessage(5, schedules_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fleetAutoscalerSpec_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, fleetAutoscalerSpec_);
    }
    for (int i = 0; i < selectors_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, selectors_.get(i));
    }
    for (int i = 0; i < schedules_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, schedules_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.gaming.v1.ScalingConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.gaming.v1.ScalingConfig other = (com.google.cloud.gaming.v1.ScalingConfig) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getFleetAutoscalerSpec().equals(other.getFleetAutoscalerSpec())) return false;
    if (!getSelectorsList().equals(other.getSelectorsList())) return false;
    if (!getSchedulesList().equals(other.getSchedulesList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + FLEET_AUTOSCALER_SPEC_FIELD_NUMBER;
    hash = (53 * hash) + getFleetAutoscalerSpec().hashCode();
    if (getSelectorsCount() > 0) {
      hash = (37 * hash) + SELECTORS_FIELD_NUMBER;
      hash = (53 * hash) + getSelectorsList().hashCode();
    }
    if (getSchedulesCount() > 0) {
      hash = (37 * hash) + SCHEDULES_FIELD_NUMBER;
      hash = (53 * hash) + getSchedulesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.gaming.v1.ScalingConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gaming.v1.ScalingConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gaming.v1.ScalingConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gaming.v1.ScalingConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gaming.v1.ScalingConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gaming.v1.ScalingConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gaming.v1.ScalingConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.gaming.v1.ScalingConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.gaming.v1.ScalingConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.gaming.v1.ScalingConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.gaming.v1.ScalingConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.gaming.v1.ScalingConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.gaming.v1.ScalingConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Autoscaling config for an Agones fleet.
   * </pre>
   *
   * Protobuf type {@code google.cloud.gaming.v1.ScalingConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.gaming.v1.ScalingConfig)
      com.google.cloud.gaming.v1.ScalingConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.gaming.v1.GameServerConfigs
          .internal_static_google_cloud_gaming_v1_ScalingConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.gaming.v1.GameServerConfigs
          .internal_static_google_cloud_gaming_v1_ScalingConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.gaming.v1.ScalingConfig.class,
              com.google.cloud.gaming.v1.ScalingConfig.Builder.class);
    }

    // Construct using com.google.cloud.gaming.v1.ScalingConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      fleetAutoscalerSpec_ = "";
      if (selectorsBuilder_ == null) {
        selectors_ = java.util.Collections.emptyList();
      } else {
        selectors_ = null;
        selectorsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      if (schedulesBuilder_ == null) {
        schedules_ = java.util.Collections.emptyList();
      } else {
        schedules_ = null;
        schedulesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.gaming.v1.GameServerConfigs
          .internal_static_google_cloud_gaming_v1_ScalingConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.gaming.v1.ScalingConfig getDefaultInstanceForType() {
      return com.google.cloud.gaming.v1.ScalingConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.gaming.v1.ScalingConfig build() {
      com.google.cloud.gaming.v1.ScalingConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.gaming.v1.ScalingConfig buildPartial() {
      com.google.cloud.gaming.v1.ScalingConfig result =
          new com.google.cloud.gaming.v1.ScalingConfig(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.gaming.v1.ScalingConfig result) {
      if (selectorsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          selectors_ = java.util.Collections.unmodifiableList(selectors_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.selectors_ = selectors_;
      } else {
        result.selectors_ = selectorsBuilder_.build();
      }
      if (schedulesBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          schedules_ = java.util.Collections.unmodifiableList(schedules_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.schedules_ = schedules_;
      } else {
        result.schedules_ = schedulesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.gaming.v1.ScalingConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.fleetAutoscalerSpec_ = fleetAutoscalerSpec_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.gaming.v1.ScalingConfig) {
        return mergeFrom((com.google.cloud.gaming.v1.ScalingConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.gaming.v1.ScalingConfig other) {
      if (other == com.google.cloud.gaming.v1.ScalingConfig.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getFleetAutoscalerSpec().isEmpty()) {
        fleetAutoscalerSpec_ = other.fleetAutoscalerSpec_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (selectorsBuilder_ == null) {
        if (!other.selectors_.isEmpty()) {
          if (selectors_.isEmpty()) {
            selectors_ = other.selectors_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureSelectorsIsMutable();
            selectors_.addAll(other.selectors_);
          }
          onChanged();
        }
      } else {
        if (!other.selectors_.isEmpty()) {
          if (selectorsBuilder_.isEmpty()) {
            selectorsBuilder_.dispose();
            selectorsBuilder_ = null;
            selectors_ = other.selectors_;
            bitField0_ = (bitField0_ & ~0x00000004);
            selectorsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getSelectorsFieldBuilder()
                    : null;
          } else {
            selectorsBuilder_.addAllMessages(other.selectors_);
          }
        }
      }
      if (schedulesBuilder_ == null) {
        if (!other.schedules_.isEmpty()) {
          if (schedules_.isEmpty()) {
            schedules_ = other.schedules_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureSchedulesIsMutable();
            schedules_.addAll(other.schedules_);
          }
          onChanged();
        }
      } else {
        if (!other.schedules_.isEmpty()) {
          if (schedulesBuilder_.isEmpty()) {
            schedulesBuilder_.dispose();
            schedulesBuilder_ = null;
            schedules_ = other.schedules_;
            bitField0_ = (bitField0_ & ~0x00000008);
            schedulesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getSchedulesFieldBuilder()
                    : null;
          } else {
            schedulesBuilder_.addAllMessages(other.schedules_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                fleetAutoscalerSpec_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 34:
              {
                com.google.cloud.gaming.v1.LabelSelector m =
                    input.readMessage(
                        com.google.cloud.gaming.v1.LabelSelector.parser(), extensionRegistry);
                if (selectorsBuilder_ == null) {
                  ensureSelectorsIsMutable();
                  selectors_.add(m);
                } else {
                  selectorsBuilder_.addMessage(m);
                }
                break;
              } // case 34
            case 42:
              {
                com.google.cloud.gaming.v1.Schedule m =
                    input.readMessage(
                        com.google.cloud.gaming.v1.Schedule.parser(), extensionRegistry);
                if (schedulesBuilder_ == null) {
                  ensureSchedulesIsMutable();
                  schedules_.add(m);
                } else {
                  schedulesBuilder_.addMessage(m);
                }
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. The name of the Scaling Config
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the Scaling Config
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the Scaling Config
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the Scaling Config
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the Scaling Config
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object fleetAutoscalerSpec_ = "";
    /**
     *
     *
     * <pre>
     * Required. Agones fleet autoscaler spec. Example spec:
     * https://agones.dev/site/docs/reference/fleetautoscaler/
     * </pre>
     *
     * <code>string fleet_autoscaler_spec = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The fleetAutoscalerSpec.
     */
    public java.lang.String getFleetAutoscalerSpec() {
      java.lang.Object ref = fleetAutoscalerSpec_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        fleetAutoscalerSpec_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Agones fleet autoscaler spec. Example spec:
     * https://agones.dev/site/docs/reference/fleetautoscaler/
     * </pre>
     *
     * <code>string fleet_autoscaler_spec = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for fleetAutoscalerSpec.
     */
    public com.google.protobuf.ByteString getFleetAutoscalerSpecBytes() {
      java.lang.Object ref = fleetAutoscalerSpec_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        fleetAutoscalerSpec_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Agones fleet autoscaler spec. Example spec:
     * https://agones.dev/site/docs/reference/fleetautoscaler/
     * </pre>
     *
     * <code>string fleet_autoscaler_spec = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The fleetAutoscalerSpec to set.
     * @return This builder for chaining.
     */
    public Builder setFleetAutoscalerSpec(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      fleetAutoscalerSpec_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Agones fleet autoscaler spec. Example spec:
     * https://agones.dev/site/docs/reference/fleetautoscaler/
     * </pre>
     *
     * <code>string fleet_autoscaler_spec = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFleetAutoscalerSpec() {
      fleetAutoscalerSpec_ = getDefaultInstance().getFleetAutoscalerSpec();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Agones fleet autoscaler spec. Example spec:
     * https://agones.dev/site/docs/reference/fleetautoscaler/
     * </pre>
     *
     * <code>string fleet_autoscaler_spec = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for fleetAutoscalerSpec to set.
     * @return This builder for chaining.
     */
    public Builder setFleetAutoscalerSpecBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      fleetAutoscalerSpec_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.gaming.v1.LabelSelector> selectors_ =
        java.util.Collections.emptyList();

    private void ensureSelectorsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        selectors_ = new java.util.ArrayList<com.google.cloud.gaming.v1.LabelSelector>(selectors_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.gaming.v1.LabelSelector,
            com.google.cloud.gaming.v1.LabelSelector.Builder,
            com.google.cloud.gaming.v1.LabelSelectorOrBuilder>
        selectorsBuilder_;

    /**
     *
     *
     * <pre>
     * Labels used to identify the game server clusters to which this Agones
     * scaling config applies. A game server cluster is subject to this Agones
     * scaling config if its labels match any of the selector entries.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.LabelSelector selectors = 4;</code>
     */
    public java.util.List<com.google.cloud.gaming.v1.LabelSelector> getSelectorsList() {
      if (selectorsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(selectors_);
      } else {
        return selectorsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Labels used to identify the game server clusters to which this Agones
     * scaling config applies. A game server cluster is subject to this Agones
     * scaling config if its labels match any of the selector entries.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.LabelSelector selectors = 4;</code>
     */
    public int getSelectorsCount() {
      if (selectorsBuilder_ == null) {
        return selectors_.size();
      } else {
        return selectorsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Labels used to identify the game server clusters to which this Agones
     * scaling config applies. A game server cluster is subject to this Agones
     * scaling config if its labels match any of the selector entries.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.LabelSelector selectors = 4;</code>
     */
    public com.google.cloud.gaming.v1.LabelSelector getSelectors(int index) {
      if (selectorsBuilder_ == null) {
        return selectors_.get(index);
      } else {
        return selectorsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Labels used to identify the game server clusters to which this Agones
     * scaling config applies. A game server cluster is subject to this Agones
     * scaling config if its labels match any of the selector entries.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.LabelSelector selectors = 4;</code>
     */
    public Builder setSelectors(int index, com.google.cloud.gaming.v1.LabelSelector value) {
      if (selectorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSelectorsIsMutable();
        selectors_.set(index, value);
        onChanged();
      } else {
        selectorsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels used to identify the game server clusters to which this Agones
     * scaling config applies. A game server cluster is subject to this Agones
     * scaling config if its labels match any of the selector entries.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.LabelSelector selectors = 4;</code>
     */
    public Builder setSelectors(
        int index, com.google.cloud.gaming.v1.LabelSelector.Builder builderForValue) {
      if (selectorsBuilder_ == null) {
        ensureSelectorsIsMutable();
        selectors_.set(index, builderForValue.build());
        onChanged();
      } else {
        selectorsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels used to identify the game server clusters to which this Agones
     * scaling config applies. A game server cluster is subject to this Agones
     * scaling config if its labels match any of the selector entries.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.LabelSelector selectors = 4;</code>
     */
    public Builder addSelectors(com.google.cloud.gaming.v1.LabelSelector value) {
      if (selectorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSelectorsIsMutable();
        selectors_.add(value);
        onChanged();
      } else {
        selectorsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels used to identify the game server clusters to which this Agones
     * scaling config applies. A game server cluster is subject to this Agones
     * scaling config if its labels match any of the selector entries.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.LabelSelector selectors = 4;</code>
     */
    public Builder addSelectors(int index, com.google.cloud.gaming.v1.LabelSelector value) {
      if (selectorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSelectorsIsMutable();
        selectors_.add(index, value);
        onChanged();
      } else {
        selectorsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels used to identify the game server clusters to which this Agones
     * scaling config applies. A game server cluster is subject to this Agones
     * scaling config if its labels match any of the selector entries.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.LabelSelector selectors = 4;</code>
     */
    public Builder addSelectors(com.google.cloud.gaming.v1.LabelSelector.Builder builderForValue) {
      if (selectorsBuilder_ == null) {
        ensureSelectorsIsMutable();
        selectors_.add(builderForValue.build());
        onChanged();
      } else {
        selectorsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels used to identify the game server clusters to which this Agones
     * scaling config applies. A game server cluster is subject to this Agones
     * scaling config if its labels match any of the selector entries.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.LabelSelector selectors = 4;</code>
     */
    public Builder addSelectors(
        int index, com.google.cloud.gaming.v1.LabelSelector.Builder builderForValue) {
      if (selectorsBuilder_ == null) {
        ensureSelectorsIsMutable();
        selectors_.add(index, builderForValue.build());
        onChanged();
      } else {
        selectorsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels used to identify the game server clusters to which this Agones
     * scaling config applies. A game server cluster is subject to this Agones
     * scaling config if its labels match any of the selector entries.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.LabelSelector selectors = 4;</code>
     */
    public Builder addAllSelectors(
        java.lang.Iterable<? extends com.google.cloud.gaming.v1.LabelSelector> values) {
      if (selectorsBuilder_ == null) {
        ensureSelectorsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, selectors_);
        onChanged();
      } else {
        selectorsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels used to identify the game server clusters to which this Agones
     * scaling config applies. A game server cluster is subject to this Agones
     * scaling config if its labels match any of the selector entries.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.LabelSelector selectors = 4;</code>
     */
    public Builder clearSelectors() {
      if (selectorsBuilder_ == null) {
        selectors_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        selectorsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels used to identify the game server clusters to which this Agones
     * scaling config applies. A game server cluster is subject to this Agones
     * scaling config if its labels match any of the selector entries.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.LabelSelector selectors = 4;</code>
     */
    public Builder removeSelectors(int index) {
      if (selectorsBuilder_ == null) {
        ensureSelectorsIsMutable();
        selectors_.remove(index);
        onChanged();
      } else {
        selectorsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels used to identify the game server clusters to which this Agones
     * scaling config applies. A game server cluster is subject to this Agones
     * scaling config if its labels match any of the selector entries.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.LabelSelector selectors = 4;</code>
     */
    public com.google.cloud.gaming.v1.LabelSelector.Builder getSelectorsBuilder(int index) {
      return getSelectorsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Labels used to identify the game server clusters to which this Agones
     * scaling config applies. A game server cluster is subject to this Agones
     * scaling config if its labels match any of the selector entries.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.LabelSelector selectors = 4;</code>
     */
    public com.google.cloud.gaming.v1.LabelSelectorOrBuilder getSelectorsOrBuilder(int index) {
      if (selectorsBuilder_ == null) {
        return selectors_.get(index);
      } else {
        return selectorsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Labels used to identify the game server clusters to which this Agones
     * scaling config applies. A game server cluster is subject to this Agones
     * scaling config if its labels match any of the selector entries.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.LabelSelector selectors = 4;</code>
     */
    public java.util.List<? extends com.google.cloud.gaming.v1.LabelSelectorOrBuilder>
        getSelectorsOrBuilderList() {
      if (selectorsBuilder_ != null) {
        return selectorsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(selectors_);
      }
    }
    /**
     *
     *
     * <pre>
     * Labels used to identify the game server clusters to which this Agones
     * scaling config applies. A game server cluster is subject to this Agones
     * scaling config if its labels match any of the selector entries.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.LabelSelector selectors = 4;</code>
     */
    public com.google.cloud.gaming.v1.LabelSelector.Builder addSelectorsBuilder() {
      return getSelectorsFieldBuilder()
          .addBuilder(com.google.cloud.gaming.v1.LabelSelector.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Labels used to identify the game server clusters to which this Agones
     * scaling config applies. A game server cluster is subject to this Agones
     * scaling config if its labels match any of the selector entries.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.LabelSelector selectors = 4;</code>
     */
    public com.google.cloud.gaming.v1.LabelSelector.Builder addSelectorsBuilder(int index) {
      return getSelectorsFieldBuilder()
          .addBuilder(index, com.google.cloud.gaming.v1.LabelSelector.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Labels used to identify the game server clusters to which this Agones
     * scaling config applies. A game server cluster is subject to this Agones
     * scaling config if its labels match any of the selector entries.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.LabelSelector selectors = 4;</code>
     */
    public java.util.List<com.google.cloud.gaming.v1.LabelSelector.Builder>
        getSelectorsBuilderList() {
      return getSelectorsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.gaming.v1.LabelSelector,
            com.google.cloud.gaming.v1.LabelSelector.Builder,
            com.google.cloud.gaming.v1.LabelSelectorOrBuilder>
        getSelectorsFieldBuilder() {
      if (selectorsBuilder_ == null) {
        selectorsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.gaming.v1.LabelSelector,
                com.google.cloud.gaming.v1.LabelSelector.Builder,
                com.google.cloud.gaming.v1.LabelSelectorOrBuilder>(
                selectors_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
        selectors_ = null;
      }
      return selectorsBuilder_;
    }

    private java.util.List<com.google.cloud.gaming.v1.Schedule> schedules_ =
        java.util.Collections.emptyList();

    private void ensureSchedulesIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        schedules_ = new java.util.ArrayList<com.google.cloud.gaming.v1.Schedule>(schedules_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.gaming.v1.Schedule,
            com.google.cloud.gaming.v1.Schedule.Builder,
            com.google.cloud.gaming.v1.ScheduleOrBuilder>
        schedulesBuilder_;

    /**
     *
     *
     * <pre>
     * The schedules to which this Scaling Config applies.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.Schedule schedules = 5;</code>
     */
    public java.util.List<com.google.cloud.gaming.v1.Schedule> getSchedulesList() {
      if (schedulesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(schedules_);
      } else {
        return schedulesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The schedules to which this Scaling Config applies.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.Schedule schedules = 5;</code>
     */
    public int getSchedulesCount() {
      if (schedulesBuilder_ == null) {
        return schedules_.size();
      } else {
        return schedulesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The schedules to which this Scaling Config applies.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.Schedule schedules = 5;</code>
     */
    public com.google.cloud.gaming.v1.Schedule getSchedules(int index) {
      if (schedulesBuilder_ == null) {
        return schedules_.get(index);
      } else {
        return schedulesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The schedules to which this Scaling Config applies.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.Schedule schedules = 5;</code>
     */
    public Builder setSchedules(int index, com.google.cloud.gaming.v1.Schedule value) {
      if (schedulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSchedulesIsMutable();
        schedules_.set(index, value);
        onChanged();
      } else {
        schedulesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The schedules to which this Scaling Config applies.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.Schedule schedules = 5;</code>
     */
    public Builder setSchedules(
        int index, com.google.cloud.gaming.v1.Schedule.Builder builderForValue) {
      if (schedulesBuilder_ == null) {
        ensureSchedulesIsMutable();
        schedules_.set(index, builderForValue.build());
        onChanged();
      } else {
        schedulesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The schedules to which this Scaling Config applies.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.Schedule schedules = 5;</code>
     */
    public Builder addSchedules(com.google.cloud.gaming.v1.Schedule value) {
      if (schedulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSchedulesIsMutable();
        schedules_.add(value);
        onChanged();
      } else {
        schedulesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The schedules to which this Scaling Config applies.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.Schedule schedules = 5;</code>
     */
    public Builder addSchedules(int index, com.google.cloud.gaming.v1.Schedule value) {
      if (schedulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSchedulesIsMutable();
        schedules_.add(index, value);
        onChanged();
      } else {
        schedulesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The schedules to which this Scaling Config applies.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.Schedule schedules = 5;</code>
     */
    public Builder addSchedules(com.google.cloud.gaming.v1.Schedule.Builder builderForValue) {
      if (schedulesBuilder_ == null) {
        ensureSchedulesIsMutable();
        schedules_.add(builderForValue.build());
        onChanged();
      } else {
        schedulesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The schedules to which this Scaling Config applies.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.Schedule schedules = 5;</code>
     */
    public Builder addSchedules(
        int index, com.google.cloud.gaming.v1.Schedule.Builder builderForValue) {
      if (schedulesBuilder_ == null) {
        ensureSchedulesIsMutable();
        schedules_.add(index, builderForValue.build());
        onChanged();
      } else {
        schedulesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The schedules to which this Scaling Config applies.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.Schedule schedules = 5;</code>
     */
    public Builder addAllSchedules(
        java.lang.Iterable<? extends com.google.cloud.gaming.v1.Schedule> values) {
      if (schedulesBuilder_ == null) {
        ensureSchedulesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, schedules_);
        onChanged();
      } else {
        schedulesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The schedules to which this Scaling Config applies.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.Schedule schedules = 5;</code>
     */
    public Builder clearSchedules() {
      if (schedulesBuilder_ == null) {
        schedules_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        schedulesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The schedules to which this Scaling Config applies.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.Schedule schedules = 5;</code>
     */
    public Builder removeSchedules(int index) {
      if (schedulesBuilder_ == null) {
        ensureSchedulesIsMutable();
        schedules_.remove(index);
        onChanged();
      } else {
        schedulesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The schedules to which this Scaling Config applies.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.Schedule schedules = 5;</code>
     */
    public com.google.cloud.gaming.v1.Schedule.Builder getSchedulesBuilder(int index) {
      return getSchedulesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The schedules to which this Scaling Config applies.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.Schedule schedules = 5;</code>
     */
    public com.google.cloud.gaming.v1.ScheduleOrBuilder getSchedulesOrBuilder(int index) {
      if (schedulesBuilder_ == null) {
        return schedules_.get(index);
      } else {
        return schedulesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The schedules to which this Scaling Config applies.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.Schedule schedules = 5;</code>
     */
    public java.util.List<? extends com.google.cloud.gaming.v1.ScheduleOrBuilder>
        getSchedulesOrBuilderList() {
      if (schedulesBuilder_ != null) {
        return schedulesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(schedules_);
      }
    }
    /**
     *
     *
     * <pre>
     * The schedules to which this Scaling Config applies.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.Schedule schedules = 5;</code>
     */
    public com.google.cloud.gaming.v1.Schedule.Builder addSchedulesBuilder() {
      return getSchedulesFieldBuilder()
          .addBuilder(com.google.cloud.gaming.v1.Schedule.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The schedules to which this Scaling Config applies.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.Schedule schedules = 5;</code>
     */
    public com.google.cloud.gaming.v1.Schedule.Builder addSchedulesBuilder(int index) {
      return getSchedulesFieldBuilder()
          .addBuilder(index, com.google.cloud.gaming.v1.Schedule.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The schedules to which this Scaling Config applies.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.Schedule schedules = 5;</code>
     */
    public java.util.List<com.google.cloud.gaming.v1.Schedule.Builder> getSchedulesBuilderList() {
      return getSchedulesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.gaming.v1.Schedule,
            com.google.cloud.gaming.v1.Schedule.Builder,
            com.google.cloud.gaming.v1.ScheduleOrBuilder>
        getSchedulesFieldBuilder() {
      if (schedulesBuilder_ == null) {
        schedulesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.gaming.v1.Schedule,
                com.google.cloud.gaming.v1.Schedule.Builder,
                com.google.cloud.gaming.v1.ScheduleOrBuilder>(
                schedules_, ((bitField0_ & 0x00000008) != 0), getParentForChildren(), isClean());
        schedules_ = null;
      }
      return schedulesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.gaming.v1.ScalingConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.gaming.v1.ScalingConfig)
  private static final com.google.cloud.gaming.v1.ScalingConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.gaming.v1.ScalingConfig();
  }

  public static com.google.cloud.gaming.v1.ScalingConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ScalingConfig> PARSER =
      new com.google.protobuf.AbstractParser<ScalingConfig>() {
        @java.lang.Override
        public ScalingConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ScalingConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ScalingConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.gaming.v1.ScalingConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
