/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/gaming/v1/common.proto

package com.google.cloud.gaming.v1;

/**
 *
 *
 * <pre>
 * The schedule of a recurring or one time event. The event's time span is
 * specified by start_time and end_time. If the scheduled event's timespan is
 * larger than the cron_spec + cron_job_duration, the event will be recurring.
 * If only cron_spec + cron_job_duration are specified, the event is effective
 * starting at the local time specified by cron_spec, and is recurring.
 *
 * ```
 * start_time|-------[cron job]-------[cron job]-------[cron job]---|end_time
 * cron job: cron spec start time + duration
 * ```
 * </pre>
 *
 * Protobuf type {@code google.cloud.gaming.v1.Schedule}
 */
public final class Schedule extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.gaming.v1.Schedule)
    ScheduleOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Schedule.newBuilder() to construct.
  private Schedule(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Schedule() {
    cronSpec_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Schedule();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.gaming.v1.Common
        .internal_static_google_cloud_gaming_v1_Schedule_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.gaming.v1.Common
        .internal_static_google_cloud_gaming_v1_Schedule_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.gaming.v1.Schedule.class,
            com.google.cloud.gaming.v1.Schedule.Builder.class);
  }

  public static final int START_TIME_FIELD_NUMBER = 1;
  private com.google.protobuf.Timestamp startTime_;
  /**
   *
   *
   * <pre>
   * The start time of the event.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 1;</code>
   *
   * @return Whether the startTime field is set.
   */
  @java.lang.Override
  public boolean hasStartTime() {
    return startTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * The start time of the event.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 1;</code>
   *
   * @return The startTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getStartTime() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }
  /**
   *
   *
   * <pre>
   * The start time of the event.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 1;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }

  public static final int END_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp endTime_;
  /**
   *
   *
   * <pre>
   * The end time of the event.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 2;</code>
   *
   * @return Whether the endTime field is set.
   */
  @java.lang.Override
  public boolean hasEndTime() {
    return endTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * The end time of the event.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 2;</code>
   *
   * @return The endTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getEndTime() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }
  /**
   *
   *
   * <pre>
   * The end time of the event.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 2;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }

  public static final int CRON_JOB_DURATION_FIELD_NUMBER = 3;
  private com.google.protobuf.Duration cronJobDuration_;
  /**
   *
   *
   * <pre>
   * The duration for the cron job event. The duration of the event is effective
   * after the cron job's start time.
   * </pre>
   *
   * <code>.google.protobuf.Duration cron_job_duration = 3;</code>
   *
   * @return Whether the cronJobDuration field is set.
   */
  @java.lang.Override
  public boolean hasCronJobDuration() {
    return cronJobDuration_ != null;
  }
  /**
   *
   *
   * <pre>
   * The duration for the cron job event. The duration of the event is effective
   * after the cron job's start time.
   * </pre>
   *
   * <code>.google.protobuf.Duration cron_job_duration = 3;</code>
   *
   * @return The cronJobDuration.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getCronJobDuration() {
    return cronJobDuration_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : cronJobDuration_;
  }
  /**
   *
   *
   * <pre>
   * The duration for the cron job event. The duration of the event is effective
   * after the cron job's start time.
   * </pre>
   *
   * <code>.google.protobuf.Duration cron_job_duration = 3;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getCronJobDurationOrBuilder() {
    return cronJobDuration_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : cronJobDuration_;
  }

  public static final int CRON_SPEC_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object cronSpec_ = "";
  /**
   *
   *
   * <pre>
   * The cron definition of the scheduled event. See
   * https://en.wikipedia.org/wiki/Cron. Cron spec specifies the local time as
   * defined by the realm.
   * </pre>
   *
   * <code>string cron_spec = 4;</code>
   *
   * @return The cronSpec.
   */
  @java.lang.Override
  public java.lang.String getCronSpec() {
    java.lang.Object ref = cronSpec_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      cronSpec_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The cron definition of the scheduled event. See
   * https://en.wikipedia.org/wiki/Cron. Cron spec specifies the local time as
   * defined by the realm.
   * </pre>
   *
   * <code>string cron_spec = 4;</code>
   *
   * @return The bytes for cronSpec.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCronSpecBytes() {
    java.lang.Object ref = cronSpec_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      cronSpec_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (startTime_ != null) {
      output.writeMessage(1, getStartTime());
    }
    if (endTime_ != null) {
      output.writeMessage(2, getEndTime());
    }
    if (cronJobDuration_ != null) {
      output.writeMessage(3, getCronJobDuration());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cronSpec_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, cronSpec_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (startTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getStartTime());
    }
    if (endTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getEndTime());
    }
    if (cronJobDuration_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getCronJobDuration());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cronSpec_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, cronSpec_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.gaming.v1.Schedule)) {
      return super.equals(obj);
    }
    com.google.cloud.gaming.v1.Schedule other = (com.google.cloud.gaming.v1.Schedule) obj;

    if (hasStartTime() != other.hasStartTime()) return false;
    if (hasStartTime()) {
      if (!getStartTime().equals(other.getStartTime())) return false;
    }
    if (hasEndTime() != other.hasEndTime()) return false;
    if (hasEndTime()) {
      if (!getEndTime().equals(other.getEndTime())) return false;
    }
    if (hasCronJobDuration() != other.hasCronJobDuration()) return false;
    if (hasCronJobDuration()) {
      if (!getCronJobDuration().equals(other.getCronJobDuration())) return false;
    }
    if (!getCronSpec().equals(other.getCronSpec())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasStartTime()) {
      hash = (37 * hash) + START_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getStartTime().hashCode();
    }
    if (hasEndTime()) {
      hash = (37 * hash) + END_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getEndTime().hashCode();
    }
    if (hasCronJobDuration()) {
      hash = (37 * hash) + CRON_JOB_DURATION_FIELD_NUMBER;
      hash = (53 * hash) + getCronJobDuration().hashCode();
    }
    hash = (37 * hash) + CRON_SPEC_FIELD_NUMBER;
    hash = (53 * hash) + getCronSpec().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.gaming.v1.Schedule parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gaming.v1.Schedule parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gaming.v1.Schedule parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gaming.v1.Schedule parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gaming.v1.Schedule parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gaming.v1.Schedule parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gaming.v1.Schedule parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.gaming.v1.Schedule parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.gaming.v1.Schedule parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.gaming.v1.Schedule parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.gaming.v1.Schedule parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.gaming.v1.Schedule parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.gaming.v1.Schedule prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The schedule of a recurring or one time event. The event's time span is
   * specified by start_time and end_time. If the scheduled event's timespan is
   * larger than the cron_spec + cron_job_duration, the event will be recurring.
   * If only cron_spec + cron_job_duration are specified, the event is effective
   * starting at the local time specified by cron_spec, and is recurring.
   *
   * ```
   * start_time|-------[cron job]-------[cron job]-------[cron job]---|end_time
   * cron job: cron spec start time + duration
   * ```
   * </pre>
   *
   * Protobuf type {@code google.cloud.gaming.v1.Schedule}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.gaming.v1.Schedule)
      com.google.cloud.gaming.v1.ScheduleOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.gaming.v1.Common
          .internal_static_google_cloud_gaming_v1_Schedule_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.gaming.v1.Common
          .internal_static_google_cloud_gaming_v1_Schedule_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.gaming.v1.Schedule.class,
              com.google.cloud.gaming.v1.Schedule.Builder.class);
    }

    // Construct using com.google.cloud.gaming.v1.Schedule.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      cronJobDuration_ = null;
      if (cronJobDurationBuilder_ != null) {
        cronJobDurationBuilder_.dispose();
        cronJobDurationBuilder_ = null;
      }
      cronSpec_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.gaming.v1.Common
          .internal_static_google_cloud_gaming_v1_Schedule_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.gaming.v1.Schedule getDefaultInstanceForType() {
      return com.google.cloud.gaming.v1.Schedule.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.gaming.v1.Schedule build() {
      com.google.cloud.gaming.v1.Schedule result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.gaming.v1.Schedule buildPartial() {
      com.google.cloud.gaming.v1.Schedule result = new com.google.cloud.gaming.v1.Schedule(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.gaming.v1.Schedule result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.startTime_ = startTimeBuilder_ == null ? startTime_ : startTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.endTime_ = endTimeBuilder_ == null ? endTime_ : endTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.cronJobDuration_ =
            cronJobDurationBuilder_ == null ? cronJobDuration_ : cronJobDurationBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.cronSpec_ = cronSpec_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.gaming.v1.Schedule) {
        return mergeFrom((com.google.cloud.gaming.v1.Schedule) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.gaming.v1.Schedule other) {
      if (other == com.google.cloud.gaming.v1.Schedule.getDefaultInstance()) return this;
      if (other.hasStartTime()) {
        mergeStartTime(other.getStartTime());
      }
      if (other.hasEndTime()) {
        mergeEndTime(other.getEndTime());
      }
      if (other.hasCronJobDuration()) {
        mergeCronJobDuration(other.getCronJobDuration());
      }
      if (!other.getCronSpec().isEmpty()) {
        cronSpec_ = other.cronSpec_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getStartTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getEndTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getCronJobDurationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                cronSpec_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.Timestamp startTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        startTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The start time of the event.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     *
     * @return Whether the startTime field is set.
     */
    public boolean hasStartTime() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The start time of the event.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     *
     * @return The startTime.
     */
    public com.google.protobuf.Timestamp getStartTime() {
      if (startTimeBuilder_ == null) {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      } else {
        return startTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The start time of the event.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        startTime_ = value;
      } else {
        startTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The start time of the event.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (startTimeBuilder_ == null) {
        startTime_ = builderForValue.build();
      } else {
        startTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The start time of the event.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    public Builder mergeStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && startTime_ != null
            && startTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getStartTimeBuilder().mergeFrom(value);
        } else {
          startTime_ = value;
        }
      } else {
        startTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The start time of the event.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    public Builder clearStartTime() {
      bitField0_ = (bitField0_ & ~0x00000001);
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The start time of the event.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    public com.google.protobuf.Timestamp.Builder getStartTimeBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getStartTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The start time of the event.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
      if (startTimeBuilder_ != null) {
        return startTimeBuilder_.getMessageOrBuilder();
      } else {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The start time of the event.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getStartTimeFieldBuilder() {
      if (startTimeBuilder_ == null) {
        startTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getStartTime(), getParentForChildren(), isClean());
        startTime_ = null;
      }
      return startTimeBuilder_;
    }

    private com.google.protobuf.Timestamp endTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        endTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The end time of the event.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     *
     * @return Whether the endTime field is set.
     */
    public boolean hasEndTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The end time of the event.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     *
     * @return The endTime.
     */
    public com.google.protobuf.Timestamp getEndTime() {
      if (endTimeBuilder_ == null) {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      } else {
        return endTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The end time of the event.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        endTime_ = value;
      } else {
        endTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The end time of the event.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (endTimeBuilder_ == null) {
        endTime_ = builderForValue.build();
      } else {
        endTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The end time of the event.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    public Builder mergeEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && endTime_ != null
            && endTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getEndTimeBuilder().mergeFrom(value);
        } else {
          endTime_ = value;
        }
      } else {
        endTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The end time of the event.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    public Builder clearEndTime() {
      bitField0_ = (bitField0_ & ~0x00000002);
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The end time of the event.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    public com.google.protobuf.Timestamp.Builder getEndTimeBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getEndTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The end time of the event.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
      if (endTimeBuilder_ != null) {
        return endTimeBuilder_.getMessageOrBuilder();
      } else {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The end time of the event.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getEndTimeFieldBuilder() {
      if (endTimeBuilder_ == null) {
        endTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getEndTime(), getParentForChildren(), isClean());
        endTime_ = null;
      }
      return endTimeBuilder_;
    }

    private com.google.protobuf.Duration cronJobDuration_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        cronJobDurationBuilder_;
    /**
     *
     *
     * <pre>
     * The duration for the cron job event. The duration of the event is effective
     * after the cron job's start time.
     * </pre>
     *
     * <code>.google.protobuf.Duration cron_job_duration = 3;</code>
     *
     * @return Whether the cronJobDuration field is set.
     */
    public boolean hasCronJobDuration() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * The duration for the cron job event. The duration of the event is effective
     * after the cron job's start time.
     * </pre>
     *
     * <code>.google.protobuf.Duration cron_job_duration = 3;</code>
     *
     * @return The cronJobDuration.
     */
    public com.google.protobuf.Duration getCronJobDuration() {
      if (cronJobDurationBuilder_ == null) {
        return cronJobDuration_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : cronJobDuration_;
      } else {
        return cronJobDurationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The duration for the cron job event. The duration of the event is effective
     * after the cron job's start time.
     * </pre>
     *
     * <code>.google.protobuf.Duration cron_job_duration = 3;</code>
     */
    public Builder setCronJobDuration(com.google.protobuf.Duration value) {
      if (cronJobDurationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        cronJobDuration_ = value;
      } else {
        cronJobDurationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The duration for the cron job event. The duration of the event is effective
     * after the cron job's start time.
     * </pre>
     *
     * <code>.google.protobuf.Duration cron_job_duration = 3;</code>
     */
    public Builder setCronJobDuration(com.google.protobuf.Duration.Builder builderForValue) {
      if (cronJobDurationBuilder_ == null) {
        cronJobDuration_ = builderForValue.build();
      } else {
        cronJobDurationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The duration for the cron job event. The duration of the event is effective
     * after the cron job's start time.
     * </pre>
     *
     * <code>.google.protobuf.Duration cron_job_duration = 3;</code>
     */
    public Builder mergeCronJobDuration(com.google.protobuf.Duration value) {
      if (cronJobDurationBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && cronJobDuration_ != null
            && cronJobDuration_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getCronJobDurationBuilder().mergeFrom(value);
        } else {
          cronJobDuration_ = value;
        }
      } else {
        cronJobDurationBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The duration for the cron job event. The duration of the event is effective
     * after the cron job's start time.
     * </pre>
     *
     * <code>.google.protobuf.Duration cron_job_duration = 3;</code>
     */
    public Builder clearCronJobDuration() {
      bitField0_ = (bitField0_ & ~0x00000004);
      cronJobDuration_ = null;
      if (cronJobDurationBuilder_ != null) {
        cronJobDurationBuilder_.dispose();
        cronJobDurationBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The duration for the cron job event. The duration of the event is effective
     * after the cron job's start time.
     * </pre>
     *
     * <code>.google.protobuf.Duration cron_job_duration = 3;</code>
     */
    public com.google.protobuf.Duration.Builder getCronJobDurationBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getCronJobDurationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The duration for the cron job event. The duration of the event is effective
     * after the cron job's start time.
     * </pre>
     *
     * <code>.google.protobuf.Duration cron_job_duration = 3;</code>
     */
    public com.google.protobuf.DurationOrBuilder getCronJobDurationOrBuilder() {
      if (cronJobDurationBuilder_ != null) {
        return cronJobDurationBuilder_.getMessageOrBuilder();
      } else {
        return cronJobDuration_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : cronJobDuration_;
      }
    }
    /**
     *
     *
     * <pre>
     * The duration for the cron job event. The duration of the event is effective
     * after the cron job's start time.
     * </pre>
     *
     * <code>.google.protobuf.Duration cron_job_duration = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getCronJobDurationFieldBuilder() {
      if (cronJobDurationBuilder_ == null) {
        cronJobDurationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getCronJobDuration(), getParentForChildren(), isClean());
        cronJobDuration_ = null;
      }
      return cronJobDurationBuilder_;
    }

    private java.lang.Object cronSpec_ = "";
    /**
     *
     *
     * <pre>
     * The cron definition of the scheduled event. See
     * https://en.wikipedia.org/wiki/Cron. Cron spec specifies the local time as
     * defined by the realm.
     * </pre>
     *
     * <code>string cron_spec = 4;</code>
     *
     * @return The cronSpec.
     */
    public java.lang.String getCronSpec() {
      java.lang.Object ref = cronSpec_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        cronSpec_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The cron definition of the scheduled event. See
     * https://en.wikipedia.org/wiki/Cron. Cron spec specifies the local time as
     * defined by the realm.
     * </pre>
     *
     * <code>string cron_spec = 4;</code>
     *
     * @return The bytes for cronSpec.
     */
    public com.google.protobuf.ByteString getCronSpecBytes() {
      java.lang.Object ref = cronSpec_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        cronSpec_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The cron definition of the scheduled event. See
     * https://en.wikipedia.org/wiki/Cron. Cron spec specifies the local time as
     * defined by the realm.
     * </pre>
     *
     * <code>string cron_spec = 4;</code>
     *
     * @param value The cronSpec to set.
     * @return This builder for chaining.
     */
    public Builder setCronSpec(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      cronSpec_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The cron definition of the scheduled event. See
     * https://en.wikipedia.org/wiki/Cron. Cron spec specifies the local time as
     * defined by the realm.
     * </pre>
     *
     * <code>string cron_spec = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCronSpec() {
      cronSpec_ = getDefaultInstance().getCronSpec();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The cron definition of the scheduled event. See
     * https://en.wikipedia.org/wiki/Cron. Cron spec specifies the local time as
     * defined by the realm.
     * </pre>
     *
     * <code>string cron_spec = 4;</code>
     *
     * @param value The bytes for cronSpec to set.
     * @return This builder for chaining.
     */
    public Builder setCronSpecBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      cronSpec_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.gaming.v1.Schedule)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.gaming.v1.Schedule)
  private static final com.google.cloud.gaming.v1.Schedule DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.gaming.v1.Schedule();
  }

  public static com.google.cloud.gaming.v1.Schedule getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Schedule> PARSER =
      new com.google.protobuf.AbstractParser<Schedule>() {
        @java.lang.Override
        public Schedule parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Schedule> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Schedule> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.gaming.v1.Schedule getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
