/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/gaming/v1/common.proto

package com.google.cloud.gaming.v1;

/**
 *
 *
 * <pre>
 * Details about the Agones resources.
 * </pre>
 *
 * Protobuf type {@code google.cloud.gaming.v1.TargetDetails}
 */
public final class TargetDetails extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.gaming.v1.TargetDetails)
    TargetDetailsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use TargetDetails.newBuilder() to construct.
  private TargetDetails(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TargetDetails() {
    gameServerClusterName_ = "";
    gameServerDeploymentName_ = "";
    fleetDetails_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TargetDetails();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.gaming.v1.Common
        .internal_static_google_cloud_gaming_v1_TargetDetails_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.gaming.v1.Common
        .internal_static_google_cloud_gaming_v1_TargetDetails_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.gaming.v1.TargetDetails.class,
            com.google.cloud.gaming.v1.TargetDetails.Builder.class);
  }

  public interface TargetFleetDetailsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.gaming.v1.TargetDetails.TargetFleetDetails)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Reference to target Agones fleet.
     * </pre>
     *
     * <code>.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleet fleet = 1;</code>
     *
     * @return Whether the fleet field is set.
     */
    boolean hasFleet();
    /**
     *
     *
     * <pre>
     * Reference to target Agones fleet.
     * </pre>
     *
     * <code>.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleet fleet = 1;</code>
     *
     * @return The fleet.
     */
    com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleet getFleet();
    /**
     *
     *
     * <pre>
     * Reference to target Agones fleet.
     * </pre>
     *
     * <code>.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleet fleet = 1;</code>
     */
    com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleetOrBuilder
        getFleetOrBuilder();

    /**
     *
     *
     * <pre>
     * Reference to target Agones fleet autoscaling policy.
     * </pre>
     *
     * <code>
     * .google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleetAutoscaler autoscaler = 2;
     * </code>
     *
     * @return Whether the autoscaler field is set.
     */
    boolean hasAutoscaler();
    /**
     *
     *
     * <pre>
     * Reference to target Agones fleet autoscaling policy.
     * </pre>
     *
     * <code>
     * .google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleetAutoscaler autoscaler = 2;
     * </code>
     *
     * @return The autoscaler.
     */
    com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleetAutoscaler
        getAutoscaler();
    /**
     *
     *
     * <pre>
     * Reference to target Agones fleet autoscaling policy.
     * </pre>
     *
     * <code>
     * .google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleetAutoscaler autoscaler = 2;
     * </code>
     */
    com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleetAutoscalerOrBuilder
        getAutoscalerOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Details of the target Agones fleet.
   * </pre>
   *
   * Protobuf type {@code google.cloud.gaming.v1.TargetDetails.TargetFleetDetails}
   */
  public static final class TargetFleetDetails extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.gaming.v1.TargetDetails.TargetFleetDetails)
      TargetFleetDetailsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use TargetFleetDetails.newBuilder() to construct.
    private TargetFleetDetails(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private TargetFleetDetails() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new TargetFleetDetails();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.gaming.v1.Common
          .internal_static_google_cloud_gaming_v1_TargetDetails_TargetFleetDetails_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.gaming.v1.Common
          .internal_static_google_cloud_gaming_v1_TargetDetails_TargetFleetDetails_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.class,
              com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.Builder.class);
    }

    public interface TargetFleetOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleet)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * The name of the Agones fleet.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The name.
       */
      java.lang.String getName();
      /**
       *
       *
       * <pre>
       * The name of the Agones fleet.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The bytes for name.
       */
      com.google.protobuf.ByteString getNameBytes();

      /**
       *
       *
       * <pre>
       * Encapsulates the source of the Agones fleet spec.
       * The Agones fleet spec source.
       * </pre>
       *
       * <code>.google.cloud.gaming.v1.SpecSource spec_source = 2;</code>
       *
       * @return Whether the specSource field is set.
       */
      boolean hasSpecSource();
      /**
       *
       *
       * <pre>
       * Encapsulates the source of the Agones fleet spec.
       * The Agones fleet spec source.
       * </pre>
       *
       * <code>.google.cloud.gaming.v1.SpecSource spec_source = 2;</code>
       *
       * @return The specSource.
       */
      com.google.cloud.gaming.v1.SpecSource getSpecSource();
      /**
       *
       *
       * <pre>
       * Encapsulates the source of the Agones fleet spec.
       * The Agones fleet spec source.
       * </pre>
       *
       * <code>.google.cloud.gaming.v1.SpecSource spec_source = 2;</code>
       */
      com.google.cloud.gaming.v1.SpecSourceOrBuilder getSpecSourceOrBuilder();
    }
    /**
     *
     *
     * <pre>
     * Target Agones fleet specification.
     * </pre>
     *
     * Protobuf type {@code google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleet}
     */
    public static final class TargetFleet extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleet)
        TargetFleetOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use TargetFleet.newBuilder() to construct.
      private TargetFleet(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private TargetFleet() {
        name_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new TargetFleet();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.gaming.v1.Common
            .internal_static_google_cloud_gaming_v1_TargetDetails_TargetFleetDetails_TargetFleet_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.gaming.v1.Common
            .internal_static_google_cloud_gaming_v1_TargetDetails_TargetFleetDetails_TargetFleet_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleet.class,
                com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleet.Builder
                    .class);
      }

      public static final int NAME_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object name_ = "";
      /**
       *
       *
       * <pre>
       * The name of the Agones fleet.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The name.
       */
      @java.lang.Override
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the Agones fleet.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The bytes for name.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int SPEC_SOURCE_FIELD_NUMBER = 2;
      private com.google.cloud.gaming.v1.SpecSource specSource_;
      /**
       *
       *
       * <pre>
       * Encapsulates the source of the Agones fleet spec.
       * The Agones fleet spec source.
       * </pre>
       *
       * <code>.google.cloud.gaming.v1.SpecSource spec_source = 2;</code>
       *
       * @return Whether the specSource field is set.
       */
      @java.lang.Override
      public boolean hasSpecSource() {
        return specSource_ != null;
      }
      /**
       *
       *
       * <pre>
       * Encapsulates the source of the Agones fleet spec.
       * The Agones fleet spec source.
       * </pre>
       *
       * <code>.google.cloud.gaming.v1.SpecSource spec_source = 2;</code>
       *
       * @return The specSource.
       */
      @java.lang.Override
      public com.google.cloud.gaming.v1.SpecSource getSpecSource() {
        return specSource_ == null
            ? com.google.cloud.gaming.v1.SpecSource.getDefaultInstance()
            : specSource_;
      }
      /**
       *
       *
       * <pre>
       * Encapsulates the source of the Agones fleet spec.
       * The Agones fleet spec source.
       * </pre>
       *
       * <code>.google.cloud.gaming.v1.SpecSource spec_source = 2;</code>
       */
      @java.lang.Override
      public com.google.cloud.gaming.v1.SpecSourceOrBuilder getSpecSourceOrBuilder() {
        return specSource_ == null
            ? com.google.cloud.gaming.v1.SpecSource.getDefaultInstance()
            : specSource_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
        }
        if (specSource_ != null) {
          output.writeMessage(2, getSpecSource());
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
        }
        if (specSource_ != null) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getSpecSource());
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleet)) {
          return super.equals(obj);
        }
        com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleet other =
            (com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleet) obj;

        if (!getName().equals(other.getName())) return false;
        if (hasSpecSource() != other.hasSpecSource()) return false;
        if (hasSpecSource()) {
          if (!getSpecSource().equals(other.getSpecSource())) return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + NAME_FIELD_NUMBER;
        hash = (53 * hash) + getName().hashCode();
        if (hasSpecSource()) {
          hash = (37 * hash) + SPEC_SOURCE_FIELD_NUMBER;
          hash = (53 * hash) + getSpecSource().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleet
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleet
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleet
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleet
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleet
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleet
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleet
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleet
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleet
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleet
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleet
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleet
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleet prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Target Agones fleet specification.
       * </pre>
       *
       * Protobuf type {@code google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleet}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleet)
          com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleetOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.gaming.v1.Common
              .internal_static_google_cloud_gaming_v1_TargetDetails_TargetFleetDetails_TargetFleet_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.gaming.v1.Common
              .internal_static_google_cloud_gaming_v1_TargetDetails_TargetFleetDetails_TargetFleet_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleet.class,
                  com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleet.Builder
                      .class);
        }

        // Construct using
        // com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleet.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          name_ = "";
          specSource_ = null;
          if (specSourceBuilder_ != null) {
            specSourceBuilder_.dispose();
            specSourceBuilder_ = null;
          }
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.gaming.v1.Common
              .internal_static_google_cloud_gaming_v1_TargetDetails_TargetFleetDetails_TargetFleet_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleet
            getDefaultInstanceForType() {
          return com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleet
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleet build() {
          com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleet result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleet
            buildPartial() {
          com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleet result =
              new com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleet(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleet result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.name_ = name_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.specSource_ =
                specSourceBuilder_ == null ? specSource_ : specSourceBuilder_.build();
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleet) {
            return mergeFrom(
                (com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleet) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleet other) {
          if (other
              == com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleet
                  .getDefaultInstance()) return this;
          if (!other.getName().isEmpty()) {
            name_ = other.name_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (other.hasSpecSource()) {
            mergeSpecSource(other.getSpecSource());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    name_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    input.readMessage(getSpecSourceFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 18
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object name_ = "";
        /**
         *
         *
         * <pre>
         * The name of the Agones fleet.
         * </pre>
         *
         * <code>string name = 1;</code>
         *
         * @return The name.
         */
        public java.lang.String getName() {
          java.lang.Object ref = name_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            name_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The name of the Agones fleet.
         * </pre>
         *
         * <code>string name = 1;</code>
         *
         * @return The bytes for name.
         */
        public com.google.protobuf.ByteString getNameBytes() {
          java.lang.Object ref = name_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            name_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The name of the Agones fleet.
         * </pre>
         *
         * <code>string name = 1;</code>
         *
         * @param value The name to set.
         * @return This builder for chaining.
         */
        public Builder setName(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          name_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The name of the Agones fleet.
         * </pre>
         *
         * <code>string name = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearName() {
          name_ = getDefaultInstance().getName();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The name of the Agones fleet.
         * </pre>
         *
         * <code>string name = 1;</code>
         *
         * @param value The bytes for name to set.
         * @return This builder for chaining.
         */
        public Builder setNameBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          name_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private com.google.cloud.gaming.v1.SpecSource specSource_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.gaming.v1.SpecSource,
                com.google.cloud.gaming.v1.SpecSource.Builder,
                com.google.cloud.gaming.v1.SpecSourceOrBuilder>
            specSourceBuilder_;
        /**
         *
         *
         * <pre>
         * Encapsulates the source of the Agones fleet spec.
         * The Agones fleet spec source.
         * </pre>
         *
         * <code>.google.cloud.gaming.v1.SpecSource spec_source = 2;</code>
         *
         * @return Whether the specSource field is set.
         */
        public boolean hasSpecSource() {
          return ((bitField0_ & 0x00000002) != 0);
        }
        /**
         *
         *
         * <pre>
         * Encapsulates the source of the Agones fleet spec.
         * The Agones fleet spec source.
         * </pre>
         *
         * <code>.google.cloud.gaming.v1.SpecSource spec_source = 2;</code>
         *
         * @return The specSource.
         */
        public com.google.cloud.gaming.v1.SpecSource getSpecSource() {
          if (specSourceBuilder_ == null) {
            return specSource_ == null
                ? com.google.cloud.gaming.v1.SpecSource.getDefaultInstance()
                : specSource_;
          } else {
            return specSourceBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * Encapsulates the source of the Agones fleet spec.
         * The Agones fleet spec source.
         * </pre>
         *
         * <code>.google.cloud.gaming.v1.SpecSource spec_source = 2;</code>
         */
        public Builder setSpecSource(com.google.cloud.gaming.v1.SpecSource value) {
          if (specSourceBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            specSource_ = value;
          } else {
            specSourceBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Encapsulates the source of the Agones fleet spec.
         * The Agones fleet spec source.
         * </pre>
         *
         * <code>.google.cloud.gaming.v1.SpecSource spec_source = 2;</code>
         */
        public Builder setSpecSource(
            com.google.cloud.gaming.v1.SpecSource.Builder builderForValue) {
          if (specSourceBuilder_ == null) {
            specSource_ = builderForValue.build();
          } else {
            specSourceBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Encapsulates the source of the Agones fleet spec.
         * The Agones fleet spec source.
         * </pre>
         *
         * <code>.google.cloud.gaming.v1.SpecSource spec_source = 2;</code>
         */
        public Builder mergeSpecSource(com.google.cloud.gaming.v1.SpecSource value) {
          if (specSourceBuilder_ == null) {
            if (((bitField0_ & 0x00000002) != 0)
                && specSource_ != null
                && specSource_ != com.google.cloud.gaming.v1.SpecSource.getDefaultInstance()) {
              getSpecSourceBuilder().mergeFrom(value);
            } else {
              specSource_ = value;
            }
          } else {
            specSourceBuilder_.mergeFrom(value);
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Encapsulates the source of the Agones fleet spec.
         * The Agones fleet spec source.
         * </pre>
         *
         * <code>.google.cloud.gaming.v1.SpecSource spec_source = 2;</code>
         */
        public Builder clearSpecSource() {
          bitField0_ = (bitField0_ & ~0x00000002);
          specSource_ = null;
          if (specSourceBuilder_ != null) {
            specSourceBuilder_.dispose();
            specSourceBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Encapsulates the source of the Agones fleet spec.
         * The Agones fleet spec source.
         * </pre>
         *
         * <code>.google.cloud.gaming.v1.SpecSource spec_source = 2;</code>
         */
        public com.google.cloud.gaming.v1.SpecSource.Builder getSpecSourceBuilder() {
          bitField0_ |= 0x00000002;
          onChanged();
          return getSpecSourceFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * Encapsulates the source of the Agones fleet spec.
         * The Agones fleet spec source.
         * </pre>
         *
         * <code>.google.cloud.gaming.v1.SpecSource spec_source = 2;</code>
         */
        public com.google.cloud.gaming.v1.SpecSourceOrBuilder getSpecSourceOrBuilder() {
          if (specSourceBuilder_ != null) {
            return specSourceBuilder_.getMessageOrBuilder();
          } else {
            return specSource_ == null
                ? com.google.cloud.gaming.v1.SpecSource.getDefaultInstance()
                : specSource_;
          }
        }
        /**
         *
         *
         * <pre>
         * Encapsulates the source of the Agones fleet spec.
         * The Agones fleet spec source.
         * </pre>
         *
         * <code>.google.cloud.gaming.v1.SpecSource spec_source = 2;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.gaming.v1.SpecSource,
                com.google.cloud.gaming.v1.SpecSource.Builder,
                com.google.cloud.gaming.v1.SpecSourceOrBuilder>
            getSpecSourceFieldBuilder() {
          if (specSourceBuilder_ == null) {
            specSourceBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.gaming.v1.SpecSource,
                    com.google.cloud.gaming.v1.SpecSource.Builder,
                    com.google.cloud.gaming.v1.SpecSourceOrBuilder>(
                    getSpecSource(), getParentForChildren(), isClean());
            specSource_ = null;
          }
          return specSourceBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleet)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleet)
      private static final com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleet
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleet();
      }

      public static com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleet
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<TargetFleet> PARSER =
          new com.google.protobuf.AbstractParser<TargetFleet>() {
            @java.lang.Override
            public TargetFleet parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<TargetFleet> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<TargetFleet> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleet
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface TargetFleetAutoscalerOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleetAutoscaler)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * The name of the Agones autoscaler.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The name.
       */
      java.lang.String getName();
      /**
       *
       *
       * <pre>
       * The name of the Agones autoscaler.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The bytes for name.
       */
      com.google.protobuf.ByteString getNameBytes();

      /**
       *
       *
       * <pre>
       * Encapsulates the source of the Agones fleet spec.
       * Details about the Agones autoscaler spec.
       * </pre>
       *
       * <code>.google.cloud.gaming.v1.SpecSource spec_source = 2;</code>
       *
       * @return Whether the specSource field is set.
       */
      boolean hasSpecSource();
      /**
       *
       *
       * <pre>
       * Encapsulates the source of the Agones fleet spec.
       * Details about the Agones autoscaler spec.
       * </pre>
       *
       * <code>.google.cloud.gaming.v1.SpecSource spec_source = 2;</code>
       *
       * @return The specSource.
       */
      com.google.cloud.gaming.v1.SpecSource getSpecSource();
      /**
       *
       *
       * <pre>
       * Encapsulates the source of the Agones fleet spec.
       * Details about the Agones autoscaler spec.
       * </pre>
       *
       * <code>.google.cloud.gaming.v1.SpecSource spec_source = 2;</code>
       */
      com.google.cloud.gaming.v1.SpecSourceOrBuilder getSpecSourceOrBuilder();
    }
    /**
     *
     *
     * <pre>
     * Target Agones autoscaler policy reference.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleetAutoscaler}
     */
    public static final class TargetFleetAutoscaler extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleetAutoscaler)
        TargetFleetAutoscalerOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use TargetFleetAutoscaler.newBuilder() to construct.
      private TargetFleetAutoscaler(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private TargetFleetAutoscaler() {
        name_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new TargetFleetAutoscaler();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.gaming.v1.Common
            .internal_static_google_cloud_gaming_v1_TargetDetails_TargetFleetDetails_TargetFleetAutoscaler_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.gaming.v1.Common
            .internal_static_google_cloud_gaming_v1_TargetDetails_TargetFleetDetails_TargetFleetAutoscaler_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleetAutoscaler
                    .class,
                com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleetAutoscaler
                    .Builder.class);
      }

      public static final int NAME_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object name_ = "";
      /**
       *
       *
       * <pre>
       * The name of the Agones autoscaler.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The name.
       */
      @java.lang.Override
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the Agones autoscaler.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The bytes for name.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int SPEC_SOURCE_FIELD_NUMBER = 2;
      private com.google.cloud.gaming.v1.SpecSource specSource_;
      /**
       *
       *
       * <pre>
       * Encapsulates the source of the Agones fleet spec.
       * Details about the Agones autoscaler spec.
       * </pre>
       *
       * <code>.google.cloud.gaming.v1.SpecSource spec_source = 2;</code>
       *
       * @return Whether the specSource field is set.
       */
      @java.lang.Override
      public boolean hasSpecSource() {
        return specSource_ != null;
      }
      /**
       *
       *
       * <pre>
       * Encapsulates the source of the Agones fleet spec.
       * Details about the Agones autoscaler spec.
       * </pre>
       *
       * <code>.google.cloud.gaming.v1.SpecSource spec_source = 2;</code>
       *
       * @return The specSource.
       */
      @java.lang.Override
      public com.google.cloud.gaming.v1.SpecSource getSpecSource() {
        return specSource_ == null
            ? com.google.cloud.gaming.v1.SpecSource.getDefaultInstance()
            : specSource_;
      }
      /**
       *
       *
       * <pre>
       * Encapsulates the source of the Agones fleet spec.
       * Details about the Agones autoscaler spec.
       * </pre>
       *
       * <code>.google.cloud.gaming.v1.SpecSource spec_source = 2;</code>
       */
      @java.lang.Override
      public com.google.cloud.gaming.v1.SpecSourceOrBuilder getSpecSourceOrBuilder() {
        return specSource_ == null
            ? com.google.cloud.gaming.v1.SpecSource.getDefaultInstance()
            : specSource_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
        }
        if (specSource_ != null) {
          output.writeMessage(2, getSpecSource());
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
        }
        if (specSource_ != null) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getSpecSource());
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleetAutoscaler)) {
          return super.equals(obj);
        }
        com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleetAutoscaler other =
            (com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleetAutoscaler) obj;

        if (!getName().equals(other.getName())) return false;
        if (hasSpecSource() != other.hasSpecSource()) return false;
        if (hasSpecSource()) {
          if (!getSpecSource().equals(other.getSpecSource())) return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + NAME_FIELD_NUMBER;
        hash = (53 * hash) + getName().hashCode();
        if (hasSpecSource()) {
          hash = (37 * hash) + SPEC_SOURCE_FIELD_NUMBER;
          hash = (53 * hash) + getSpecSource().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails
              .TargetFleetAutoscaler
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails
              .TargetFleetAutoscaler
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails
              .TargetFleetAutoscaler
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails
              .TargetFleetAutoscaler
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails
              .TargetFleetAutoscaler
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails
              .TargetFleetAutoscaler
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails
              .TargetFleetAutoscaler
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails
              .TargetFleetAutoscaler
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails
              .TargetFleetAutoscaler
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails
              .TargetFleetAutoscaler
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails
              .TargetFleetAutoscaler
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails
              .TargetFleetAutoscaler
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleetAutoscaler
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Target Agones autoscaler policy reference.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleetAutoscaler}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleetAutoscaler)
          com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails
              .TargetFleetAutoscalerOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.gaming.v1.Common
              .internal_static_google_cloud_gaming_v1_TargetDetails_TargetFleetDetails_TargetFleetAutoscaler_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.gaming.v1.Common
              .internal_static_google_cloud_gaming_v1_TargetDetails_TargetFleetDetails_TargetFleetAutoscaler_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleetAutoscaler
                      .class,
                  com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleetAutoscaler
                      .Builder.class);
        }

        // Construct using
        // com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleetAutoscaler.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          name_ = "";
          specSource_ = null;
          if (specSourceBuilder_ != null) {
            specSourceBuilder_.dispose();
            specSourceBuilder_ = null;
          }
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.gaming.v1.Common
              .internal_static_google_cloud_gaming_v1_TargetDetails_TargetFleetDetails_TargetFleetAutoscaler_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleetAutoscaler
            getDefaultInstanceForType() {
          return com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleetAutoscaler
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleetAutoscaler
            build() {
          com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleetAutoscaler result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleetAutoscaler
            buildPartial() {
          com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleetAutoscaler result =
              new com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleetAutoscaler(
                  this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleetAutoscaler
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.name_ = name_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.specSource_ =
                specSourceBuilder_ == null ? specSource_ : specSourceBuilder_.build();
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleetAutoscaler) {
            return mergeFrom(
                (com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleetAutoscaler)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleetAutoscaler
                other) {
          if (other
              == com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleetAutoscaler
                  .getDefaultInstance()) return this;
          if (!other.getName().isEmpty()) {
            name_ = other.name_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (other.hasSpecSource()) {
            mergeSpecSource(other.getSpecSource());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    name_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    input.readMessage(getSpecSourceFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 18
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object name_ = "";
        /**
         *
         *
         * <pre>
         * The name of the Agones autoscaler.
         * </pre>
         *
         * <code>string name = 1;</code>
         *
         * @return The name.
         */
        public java.lang.String getName() {
          java.lang.Object ref = name_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            name_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The name of the Agones autoscaler.
         * </pre>
         *
         * <code>string name = 1;</code>
         *
         * @return The bytes for name.
         */
        public com.google.protobuf.ByteString getNameBytes() {
          java.lang.Object ref = name_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            name_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The name of the Agones autoscaler.
         * </pre>
         *
         * <code>string name = 1;</code>
         *
         * @param value The name to set.
         * @return This builder for chaining.
         */
        public Builder setName(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          name_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The name of the Agones autoscaler.
         * </pre>
         *
         * <code>string name = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearName() {
          name_ = getDefaultInstance().getName();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The name of the Agones autoscaler.
         * </pre>
         *
         * <code>string name = 1;</code>
         *
         * @param value The bytes for name to set.
         * @return This builder for chaining.
         */
        public Builder setNameBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          name_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private com.google.cloud.gaming.v1.SpecSource specSource_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.gaming.v1.SpecSource,
                com.google.cloud.gaming.v1.SpecSource.Builder,
                com.google.cloud.gaming.v1.SpecSourceOrBuilder>
            specSourceBuilder_;
        /**
         *
         *
         * <pre>
         * Encapsulates the source of the Agones fleet spec.
         * Details about the Agones autoscaler spec.
         * </pre>
         *
         * <code>.google.cloud.gaming.v1.SpecSource spec_source = 2;</code>
         *
         * @return Whether the specSource field is set.
         */
        public boolean hasSpecSource() {
          return ((bitField0_ & 0x00000002) != 0);
        }
        /**
         *
         *
         * <pre>
         * Encapsulates the source of the Agones fleet spec.
         * Details about the Agones autoscaler spec.
         * </pre>
         *
         * <code>.google.cloud.gaming.v1.SpecSource spec_source = 2;</code>
         *
         * @return The specSource.
         */
        public com.google.cloud.gaming.v1.SpecSource getSpecSource() {
          if (specSourceBuilder_ == null) {
            return specSource_ == null
                ? com.google.cloud.gaming.v1.SpecSource.getDefaultInstance()
                : specSource_;
          } else {
            return specSourceBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * Encapsulates the source of the Agones fleet spec.
         * Details about the Agones autoscaler spec.
         * </pre>
         *
         * <code>.google.cloud.gaming.v1.SpecSource spec_source = 2;</code>
         */
        public Builder setSpecSource(com.google.cloud.gaming.v1.SpecSource value) {
          if (specSourceBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            specSource_ = value;
          } else {
            specSourceBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Encapsulates the source of the Agones fleet spec.
         * Details about the Agones autoscaler spec.
         * </pre>
         *
         * <code>.google.cloud.gaming.v1.SpecSource spec_source = 2;</code>
         */
        public Builder setSpecSource(
            com.google.cloud.gaming.v1.SpecSource.Builder builderForValue) {
          if (specSourceBuilder_ == null) {
            specSource_ = builderForValue.build();
          } else {
            specSourceBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Encapsulates the source of the Agones fleet spec.
         * Details about the Agones autoscaler spec.
         * </pre>
         *
         * <code>.google.cloud.gaming.v1.SpecSource spec_source = 2;</code>
         */
        public Builder mergeSpecSource(com.google.cloud.gaming.v1.SpecSource value) {
          if (specSourceBuilder_ == null) {
            if (((bitField0_ & 0x00000002) != 0)
                && specSource_ != null
                && specSource_ != com.google.cloud.gaming.v1.SpecSource.getDefaultInstance()) {
              getSpecSourceBuilder().mergeFrom(value);
            } else {
              specSource_ = value;
            }
          } else {
            specSourceBuilder_.mergeFrom(value);
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Encapsulates the source of the Agones fleet spec.
         * Details about the Agones autoscaler spec.
         * </pre>
         *
         * <code>.google.cloud.gaming.v1.SpecSource spec_source = 2;</code>
         */
        public Builder clearSpecSource() {
          bitField0_ = (bitField0_ & ~0x00000002);
          specSource_ = null;
          if (specSourceBuilder_ != null) {
            specSourceBuilder_.dispose();
            specSourceBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Encapsulates the source of the Agones fleet spec.
         * Details about the Agones autoscaler spec.
         * </pre>
         *
         * <code>.google.cloud.gaming.v1.SpecSource spec_source = 2;</code>
         */
        public com.google.cloud.gaming.v1.SpecSource.Builder getSpecSourceBuilder() {
          bitField0_ |= 0x00000002;
          onChanged();
          return getSpecSourceFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * Encapsulates the source of the Agones fleet spec.
         * Details about the Agones autoscaler spec.
         * </pre>
         *
         * <code>.google.cloud.gaming.v1.SpecSource spec_source = 2;</code>
         */
        public com.google.cloud.gaming.v1.SpecSourceOrBuilder getSpecSourceOrBuilder() {
          if (specSourceBuilder_ != null) {
            return specSourceBuilder_.getMessageOrBuilder();
          } else {
            return specSource_ == null
                ? com.google.cloud.gaming.v1.SpecSource.getDefaultInstance()
                : specSource_;
          }
        }
        /**
         *
         *
         * <pre>
         * Encapsulates the source of the Agones fleet spec.
         * Details about the Agones autoscaler spec.
         * </pre>
         *
         * <code>.google.cloud.gaming.v1.SpecSource spec_source = 2;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.gaming.v1.SpecSource,
                com.google.cloud.gaming.v1.SpecSource.Builder,
                com.google.cloud.gaming.v1.SpecSourceOrBuilder>
            getSpecSourceFieldBuilder() {
          if (specSourceBuilder_ == null) {
            specSourceBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.gaming.v1.SpecSource,
                    com.google.cloud.gaming.v1.SpecSource.Builder,
                    com.google.cloud.gaming.v1.SpecSourceOrBuilder>(
                    getSpecSource(), getParentForChildren(), isClean());
            specSource_ = null;
          }
          return specSourceBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleetAutoscaler)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleetAutoscaler)
      private static final com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails
              .TargetFleetAutoscaler
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleetAutoscaler();
      }

      public static com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails
              .TargetFleetAutoscaler
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<TargetFleetAutoscaler> PARSER =
          new com.google.protobuf.AbstractParser<TargetFleetAutoscaler>() {
            @java.lang.Override
            public TargetFleetAutoscaler parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<TargetFleetAutoscaler> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<TargetFleetAutoscaler> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleetAutoscaler
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public static final int FLEET_FIELD_NUMBER = 1;
    private com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleet fleet_;
    /**
     *
     *
     * <pre>
     * Reference to target Agones fleet.
     * </pre>
     *
     * <code>.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleet fleet = 1;</code>
     *
     * @return Whether the fleet field is set.
     */
    @java.lang.Override
    public boolean hasFleet() {
      return fleet_ != null;
    }
    /**
     *
     *
     * <pre>
     * Reference to target Agones fleet.
     * </pre>
     *
     * <code>.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleet fleet = 1;</code>
     *
     * @return The fleet.
     */
    @java.lang.Override
    public com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleet getFleet() {
      return fleet_ == null
          ? com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleet
              .getDefaultInstance()
          : fleet_;
    }
    /**
     *
     *
     * <pre>
     * Reference to target Agones fleet.
     * </pre>
     *
     * <code>.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleet fleet = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleetOrBuilder
        getFleetOrBuilder() {
      return fleet_ == null
          ? com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleet
              .getDefaultInstance()
          : fleet_;
    }

    public static final int AUTOSCALER_FIELD_NUMBER = 2;
    private com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleetAutoscaler
        autoscaler_;
    /**
     *
     *
     * <pre>
     * Reference to target Agones fleet autoscaling policy.
     * </pre>
     *
     * <code>
     * .google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleetAutoscaler autoscaler = 2;
     * </code>
     *
     * @return Whether the autoscaler field is set.
     */
    @java.lang.Override
    public boolean hasAutoscaler() {
      return autoscaler_ != null;
    }
    /**
     *
     *
     * <pre>
     * Reference to target Agones fleet autoscaling policy.
     * </pre>
     *
     * <code>
     * .google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleetAutoscaler autoscaler = 2;
     * </code>
     *
     * @return The autoscaler.
     */
    @java.lang.Override
    public com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleetAutoscaler
        getAutoscaler() {
      return autoscaler_ == null
          ? com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleetAutoscaler
              .getDefaultInstance()
          : autoscaler_;
    }
    /**
     *
     *
     * <pre>
     * Reference to target Agones fleet autoscaling policy.
     * </pre>
     *
     * <code>
     * .google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleetAutoscaler autoscaler = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails
            .TargetFleetAutoscalerOrBuilder
        getAutoscalerOrBuilder() {
      return autoscaler_ == null
          ? com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleetAutoscaler
              .getDefaultInstance()
          : autoscaler_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (fleet_ != null) {
        output.writeMessage(1, getFleet());
      }
      if (autoscaler_ != null) {
        output.writeMessage(2, getAutoscaler());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (fleet_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getFleet());
      }
      if (autoscaler_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getAutoscaler());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails)) {
        return super.equals(obj);
      }
      com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails other =
          (com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails) obj;

      if (hasFleet() != other.hasFleet()) return false;
      if (hasFleet()) {
        if (!getFleet().equals(other.getFleet())) return false;
      }
      if (hasAutoscaler() != other.hasAutoscaler()) return false;
      if (hasAutoscaler()) {
        if (!getAutoscaler().equals(other.getAutoscaler())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasFleet()) {
        hash = (37 * hash) + FLEET_FIELD_NUMBER;
        hash = (53 * hash) + getFleet().hashCode();
      }
      if (hasAutoscaler()) {
        hash = (37 * hash) + AUTOSCALER_FIELD_NUMBER;
        hash = (53 * hash) + getAutoscaler().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Details of the target Agones fleet.
     * </pre>
     *
     * Protobuf type {@code google.cloud.gaming.v1.TargetDetails.TargetFleetDetails}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.gaming.v1.TargetDetails.TargetFleetDetails)
        com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetailsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.gaming.v1.Common
            .internal_static_google_cloud_gaming_v1_TargetDetails_TargetFleetDetails_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.gaming.v1.Common
            .internal_static_google_cloud_gaming_v1_TargetDetails_TargetFleetDetails_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.class,
                com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.Builder.class);
      }

      // Construct using com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        fleet_ = null;
        if (fleetBuilder_ != null) {
          fleetBuilder_.dispose();
          fleetBuilder_ = null;
        }
        autoscaler_ = null;
        if (autoscalerBuilder_ != null) {
          autoscalerBuilder_.dispose();
          autoscalerBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.gaming.v1.Common
            .internal_static_google_cloud_gaming_v1_TargetDetails_TargetFleetDetails_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails
          getDefaultInstanceForType() {
        return com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails build() {
        com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails buildPartial() {
        com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails result =
            new com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.fleet_ = fleetBuilder_ == null ? fleet_ : fleetBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.autoscaler_ =
              autoscalerBuilder_ == null ? autoscaler_ : autoscalerBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails) {
          return mergeFrom((com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails other) {
        if (other
            == com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.getDefaultInstance())
          return this;
        if (other.hasFleet()) {
          mergeFleet(other.getFleet());
        }
        if (other.hasAutoscaler()) {
          mergeAutoscaler(other.getAutoscaler());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getFleetFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getAutoscalerFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleet fleet_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleet,
              com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleet.Builder,
              com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleetOrBuilder>
          fleetBuilder_;
      /**
       *
       *
       * <pre>
       * Reference to target Agones fleet.
       * </pre>
       *
       * <code>.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleet fleet = 1;
       * </code>
       *
       * @return Whether the fleet field is set.
       */
      public boolean hasFleet() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Reference to target Agones fleet.
       * </pre>
       *
       * <code>.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleet fleet = 1;
       * </code>
       *
       * @return The fleet.
       */
      public com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleet getFleet() {
        if (fleetBuilder_ == null) {
          return fleet_ == null
              ? com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleet
                  .getDefaultInstance()
              : fleet_;
        } else {
          return fleetBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Reference to target Agones fleet.
       * </pre>
       *
       * <code>.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleet fleet = 1;
       * </code>
       */
      public Builder setFleet(
          com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleet value) {
        if (fleetBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          fleet_ = value;
        } else {
          fleetBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Reference to target Agones fleet.
       * </pre>
       *
       * <code>.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleet fleet = 1;
       * </code>
       */
      public Builder setFleet(
          com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleet.Builder
              builderForValue) {
        if (fleetBuilder_ == null) {
          fleet_ = builderForValue.build();
        } else {
          fleetBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Reference to target Agones fleet.
       * </pre>
       *
       * <code>.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleet fleet = 1;
       * </code>
       */
      public Builder mergeFleet(
          com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleet value) {
        if (fleetBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && fleet_ != null
              && fleet_
                  != com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleet
                      .getDefaultInstance()) {
            getFleetBuilder().mergeFrom(value);
          } else {
            fleet_ = value;
          }
        } else {
          fleetBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Reference to target Agones fleet.
       * </pre>
       *
       * <code>.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleet fleet = 1;
       * </code>
       */
      public Builder clearFleet() {
        bitField0_ = (bitField0_ & ~0x00000001);
        fleet_ = null;
        if (fleetBuilder_ != null) {
          fleetBuilder_.dispose();
          fleetBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Reference to target Agones fleet.
       * </pre>
       *
       * <code>.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleet fleet = 1;
       * </code>
       */
      public com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleet.Builder
          getFleetBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getFleetFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Reference to target Agones fleet.
       * </pre>
       *
       * <code>.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleet fleet = 1;
       * </code>
       */
      public com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleetOrBuilder
          getFleetOrBuilder() {
        if (fleetBuilder_ != null) {
          return fleetBuilder_.getMessageOrBuilder();
        } else {
          return fleet_ == null
              ? com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleet
                  .getDefaultInstance()
              : fleet_;
        }
      }
      /**
       *
       *
       * <pre>
       * Reference to target Agones fleet.
       * </pre>
       *
       * <code>.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleet fleet = 1;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleet,
              com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleet.Builder,
              com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleetOrBuilder>
          getFleetFieldBuilder() {
        if (fleetBuilder_ == null) {
          fleetBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleet,
                  com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleet.Builder,
                  com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleetOrBuilder>(
                  getFleet(), getParentForChildren(), isClean());
          fleet_ = null;
        }
        return fleetBuilder_;
      }

      private com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleetAutoscaler
          autoscaler_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleetAutoscaler,
              com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleetAutoscaler
                  .Builder,
              com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails
                  .TargetFleetAutoscalerOrBuilder>
          autoscalerBuilder_;
      /**
       *
       *
       * <pre>
       * Reference to target Agones fleet autoscaling policy.
       * </pre>
       *
       * <code>
       * .google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleetAutoscaler autoscaler = 2;
       * </code>
       *
       * @return Whether the autoscaler field is set.
       */
      public boolean hasAutoscaler() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * Reference to target Agones fleet autoscaling policy.
       * </pre>
       *
       * <code>
       * .google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleetAutoscaler autoscaler = 2;
       * </code>
       *
       * @return The autoscaler.
       */
      public com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleetAutoscaler
          getAutoscaler() {
        if (autoscalerBuilder_ == null) {
          return autoscaler_ == null
              ? com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleetAutoscaler
                  .getDefaultInstance()
              : autoscaler_;
        } else {
          return autoscalerBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Reference to target Agones fleet autoscaling policy.
       * </pre>
       *
       * <code>
       * .google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleetAutoscaler autoscaler = 2;
       * </code>
       */
      public Builder setAutoscaler(
          com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleetAutoscaler value) {
        if (autoscalerBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          autoscaler_ = value;
        } else {
          autoscalerBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Reference to target Agones fleet autoscaling policy.
       * </pre>
       *
       * <code>
       * .google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleetAutoscaler autoscaler = 2;
       * </code>
       */
      public Builder setAutoscaler(
          com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleetAutoscaler.Builder
              builderForValue) {
        if (autoscalerBuilder_ == null) {
          autoscaler_ = builderForValue.build();
        } else {
          autoscalerBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Reference to target Agones fleet autoscaling policy.
       * </pre>
       *
       * <code>
       * .google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleetAutoscaler autoscaler = 2;
       * </code>
       */
      public Builder mergeAutoscaler(
          com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleetAutoscaler value) {
        if (autoscalerBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && autoscaler_ != null
              && autoscaler_
                  != com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails
                      .TargetFleetAutoscaler.getDefaultInstance()) {
            getAutoscalerBuilder().mergeFrom(value);
          } else {
            autoscaler_ = value;
          }
        } else {
          autoscalerBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Reference to target Agones fleet autoscaling policy.
       * </pre>
       *
       * <code>
       * .google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleetAutoscaler autoscaler = 2;
       * </code>
       */
      public Builder clearAutoscaler() {
        bitField0_ = (bitField0_ & ~0x00000002);
        autoscaler_ = null;
        if (autoscalerBuilder_ != null) {
          autoscalerBuilder_.dispose();
          autoscalerBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Reference to target Agones fleet autoscaling policy.
       * </pre>
       *
       * <code>
       * .google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleetAutoscaler autoscaler = 2;
       * </code>
       */
      public com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleetAutoscaler
              .Builder
          getAutoscalerBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getAutoscalerFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Reference to target Agones fleet autoscaling policy.
       * </pre>
       *
       * <code>
       * .google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleetAutoscaler autoscaler = 2;
       * </code>
       */
      public com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails
              .TargetFleetAutoscalerOrBuilder
          getAutoscalerOrBuilder() {
        if (autoscalerBuilder_ != null) {
          return autoscalerBuilder_.getMessageOrBuilder();
        } else {
          return autoscaler_ == null
              ? com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleetAutoscaler
                  .getDefaultInstance()
              : autoscaler_;
        }
      }
      /**
       *
       *
       * <pre>
       * Reference to target Agones fleet autoscaling policy.
       * </pre>
       *
       * <code>
       * .google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleetAutoscaler autoscaler = 2;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleetAutoscaler,
              com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleetAutoscaler
                  .Builder,
              com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails
                  .TargetFleetAutoscalerOrBuilder>
          getAutoscalerFieldBuilder() {
        if (autoscalerBuilder_ == null) {
          autoscalerBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleetAutoscaler,
                  com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.TargetFleetAutoscaler
                      .Builder,
                  com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails
                      .TargetFleetAutoscalerOrBuilder>(
                  getAutoscaler(), getParentForChildren(), isClean());
          autoscaler_ = null;
        }
        return autoscalerBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.gaming.v1.TargetDetails.TargetFleetDetails)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.gaming.v1.TargetDetails.TargetFleetDetails)
    private static final com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails();
    }

    public static com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<TargetFleetDetails> PARSER =
        new com.google.protobuf.AbstractParser<TargetFleetDetails>() {
          @java.lang.Override
          public TargetFleetDetails parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<TargetFleetDetails> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<TargetFleetDetails> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int GAME_SERVER_CLUSTER_NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object gameServerClusterName_ = "";
  /**
   *
   *
   * <pre>
   * The game server cluster name. Uses the form:
   * `projects/{project}/locations/{location}/realms/{realm}/gameServerClusters/{cluster}`.
   * </pre>
   *
   * <code>string game_server_cluster_name = 1;</code>
   *
   * @return The gameServerClusterName.
   */
  @java.lang.Override
  public java.lang.String getGameServerClusterName() {
    java.lang.Object ref = gameServerClusterName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      gameServerClusterName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The game server cluster name. Uses the form:
   * `projects/{project}/locations/{location}/realms/{realm}/gameServerClusters/{cluster}`.
   * </pre>
   *
   * <code>string game_server_cluster_name = 1;</code>
   *
   * @return The bytes for gameServerClusterName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getGameServerClusterNameBytes() {
    java.lang.Object ref = gameServerClusterName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      gameServerClusterName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int GAME_SERVER_DEPLOYMENT_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object gameServerDeploymentName_ = "";
  /**
   *
   *
   * <pre>
   * The game server deployment name. Uses the form:
   * `projects/{project}/locations/{location}/gameServerDeployments/{deployment_id}`.
   * </pre>
   *
   * <code>string game_server_deployment_name = 2;</code>
   *
   * @return The gameServerDeploymentName.
   */
  @java.lang.Override
  public java.lang.String getGameServerDeploymentName() {
    java.lang.Object ref = gameServerDeploymentName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      gameServerDeploymentName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The game server deployment name. Uses the form:
   * `projects/{project}/locations/{location}/gameServerDeployments/{deployment_id}`.
   * </pre>
   *
   * <code>string game_server_deployment_name = 2;</code>
   *
   * @return The bytes for gameServerDeploymentName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getGameServerDeploymentNameBytes() {
    java.lang.Object ref = gameServerDeploymentName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      gameServerDeploymentName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FLEET_DETAILS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails> fleetDetails_;
  /**
   *
   *
   * <pre>
   * Agones fleet details for game server clusters and game server deployments.
   * </pre>
   *
   * <code>repeated .google.cloud.gaming.v1.TargetDetails.TargetFleetDetails fleet_details = 3;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails>
      getFleetDetailsList() {
    return fleetDetails_;
  }
  /**
   *
   *
   * <pre>
   * Agones fleet details for game server clusters and game server deployments.
   * </pre>
   *
   * <code>repeated .google.cloud.gaming.v1.TargetDetails.TargetFleetDetails fleet_details = 3;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetailsOrBuilder>
      getFleetDetailsOrBuilderList() {
    return fleetDetails_;
  }
  /**
   *
   *
   * <pre>
   * Agones fleet details for game server clusters and game server deployments.
   * </pre>
   *
   * <code>repeated .google.cloud.gaming.v1.TargetDetails.TargetFleetDetails fleet_details = 3;
   * </code>
   */
  @java.lang.Override
  public int getFleetDetailsCount() {
    return fleetDetails_.size();
  }
  /**
   *
   *
   * <pre>
   * Agones fleet details for game server clusters and game server deployments.
   * </pre>
   *
   * <code>repeated .google.cloud.gaming.v1.TargetDetails.TargetFleetDetails fleet_details = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails getFleetDetails(int index) {
    return fleetDetails_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Agones fleet details for game server clusters and game server deployments.
   * </pre>
   *
   * <code>repeated .google.cloud.gaming.v1.TargetDetails.TargetFleetDetails fleet_details = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetailsOrBuilder
      getFleetDetailsOrBuilder(int index) {
    return fleetDetails_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(gameServerClusterName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, gameServerClusterName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(gameServerDeploymentName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, gameServerDeploymentName_);
    }
    for (int i = 0; i < fleetDetails_.size(); i++) {
      output.writeMessage(3, fleetDetails_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(gameServerClusterName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, gameServerClusterName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(gameServerDeploymentName_)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(2, gameServerDeploymentName_);
    }
    for (int i = 0; i < fleetDetails_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, fleetDetails_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.gaming.v1.TargetDetails)) {
      return super.equals(obj);
    }
    com.google.cloud.gaming.v1.TargetDetails other = (com.google.cloud.gaming.v1.TargetDetails) obj;

    if (!getGameServerClusterName().equals(other.getGameServerClusterName())) return false;
    if (!getGameServerDeploymentName().equals(other.getGameServerDeploymentName())) return false;
    if (!getFleetDetailsList().equals(other.getFleetDetailsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + GAME_SERVER_CLUSTER_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getGameServerClusterName().hashCode();
    hash = (37 * hash) + GAME_SERVER_DEPLOYMENT_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getGameServerDeploymentName().hashCode();
    if (getFleetDetailsCount() > 0) {
      hash = (37 * hash) + FLEET_DETAILS_FIELD_NUMBER;
      hash = (53 * hash) + getFleetDetailsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.gaming.v1.TargetDetails parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gaming.v1.TargetDetails parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gaming.v1.TargetDetails parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gaming.v1.TargetDetails parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gaming.v1.TargetDetails parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gaming.v1.TargetDetails parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gaming.v1.TargetDetails parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.gaming.v1.TargetDetails parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.gaming.v1.TargetDetails parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.gaming.v1.TargetDetails parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.gaming.v1.TargetDetails parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.gaming.v1.TargetDetails parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.gaming.v1.TargetDetails prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Details about the Agones resources.
   * </pre>
   *
   * Protobuf type {@code google.cloud.gaming.v1.TargetDetails}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.gaming.v1.TargetDetails)
      com.google.cloud.gaming.v1.TargetDetailsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.gaming.v1.Common
          .internal_static_google_cloud_gaming_v1_TargetDetails_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.gaming.v1.Common
          .internal_static_google_cloud_gaming_v1_TargetDetails_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.gaming.v1.TargetDetails.class,
              com.google.cloud.gaming.v1.TargetDetails.Builder.class);
    }

    // Construct using com.google.cloud.gaming.v1.TargetDetails.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      gameServerClusterName_ = "";
      gameServerDeploymentName_ = "";
      if (fleetDetailsBuilder_ == null) {
        fleetDetails_ = java.util.Collections.emptyList();
      } else {
        fleetDetails_ = null;
        fleetDetailsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.gaming.v1.Common
          .internal_static_google_cloud_gaming_v1_TargetDetails_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.gaming.v1.TargetDetails getDefaultInstanceForType() {
      return com.google.cloud.gaming.v1.TargetDetails.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.gaming.v1.TargetDetails build() {
      com.google.cloud.gaming.v1.TargetDetails result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.gaming.v1.TargetDetails buildPartial() {
      com.google.cloud.gaming.v1.TargetDetails result =
          new com.google.cloud.gaming.v1.TargetDetails(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.gaming.v1.TargetDetails result) {
      if (fleetDetailsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          fleetDetails_ = java.util.Collections.unmodifiableList(fleetDetails_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.fleetDetails_ = fleetDetails_;
      } else {
        result.fleetDetails_ = fleetDetailsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.gaming.v1.TargetDetails result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.gameServerClusterName_ = gameServerClusterName_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.gameServerDeploymentName_ = gameServerDeploymentName_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.gaming.v1.TargetDetails) {
        return mergeFrom((com.google.cloud.gaming.v1.TargetDetails) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.gaming.v1.TargetDetails other) {
      if (other == com.google.cloud.gaming.v1.TargetDetails.getDefaultInstance()) return this;
      if (!other.getGameServerClusterName().isEmpty()) {
        gameServerClusterName_ = other.gameServerClusterName_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getGameServerDeploymentName().isEmpty()) {
        gameServerDeploymentName_ = other.gameServerDeploymentName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (fleetDetailsBuilder_ == null) {
        if (!other.fleetDetails_.isEmpty()) {
          if (fleetDetails_.isEmpty()) {
            fleetDetails_ = other.fleetDetails_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureFleetDetailsIsMutable();
            fleetDetails_.addAll(other.fleetDetails_);
          }
          onChanged();
        }
      } else {
        if (!other.fleetDetails_.isEmpty()) {
          if (fleetDetailsBuilder_.isEmpty()) {
            fleetDetailsBuilder_.dispose();
            fleetDetailsBuilder_ = null;
            fleetDetails_ = other.fleetDetails_;
            bitField0_ = (bitField0_ & ~0x00000004);
            fleetDetailsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getFleetDetailsFieldBuilder()
                    : null;
          } else {
            fleetDetailsBuilder_.addAllMessages(other.fleetDetails_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                gameServerClusterName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                gameServerDeploymentName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails m =
                    input.readMessage(
                        com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.parser(),
                        extensionRegistry);
                if (fleetDetailsBuilder_ == null) {
                  ensureFleetDetailsIsMutable();
                  fleetDetails_.add(m);
                } else {
                  fleetDetailsBuilder_.addMessage(m);
                }
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object gameServerClusterName_ = "";
    /**
     *
     *
     * <pre>
     * The game server cluster name. Uses the form:
     * `projects/{project}/locations/{location}/realms/{realm}/gameServerClusters/{cluster}`.
     * </pre>
     *
     * <code>string game_server_cluster_name = 1;</code>
     *
     * @return The gameServerClusterName.
     */
    public java.lang.String getGameServerClusterName() {
      java.lang.Object ref = gameServerClusterName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        gameServerClusterName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The game server cluster name. Uses the form:
     * `projects/{project}/locations/{location}/realms/{realm}/gameServerClusters/{cluster}`.
     * </pre>
     *
     * <code>string game_server_cluster_name = 1;</code>
     *
     * @return The bytes for gameServerClusterName.
     */
    public com.google.protobuf.ByteString getGameServerClusterNameBytes() {
      java.lang.Object ref = gameServerClusterName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        gameServerClusterName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The game server cluster name. Uses the form:
     * `projects/{project}/locations/{location}/realms/{realm}/gameServerClusters/{cluster}`.
     * </pre>
     *
     * <code>string game_server_cluster_name = 1;</code>
     *
     * @param value The gameServerClusterName to set.
     * @return This builder for chaining.
     */
    public Builder setGameServerClusterName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      gameServerClusterName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The game server cluster name. Uses the form:
     * `projects/{project}/locations/{location}/realms/{realm}/gameServerClusters/{cluster}`.
     * </pre>
     *
     * <code>string game_server_cluster_name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearGameServerClusterName() {
      gameServerClusterName_ = getDefaultInstance().getGameServerClusterName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The game server cluster name. Uses the form:
     * `projects/{project}/locations/{location}/realms/{realm}/gameServerClusters/{cluster}`.
     * </pre>
     *
     * <code>string game_server_cluster_name = 1;</code>
     *
     * @param value The bytes for gameServerClusterName to set.
     * @return This builder for chaining.
     */
    public Builder setGameServerClusterNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      gameServerClusterName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object gameServerDeploymentName_ = "";
    /**
     *
     *
     * <pre>
     * The game server deployment name. Uses the form:
     * `projects/{project}/locations/{location}/gameServerDeployments/{deployment_id}`.
     * </pre>
     *
     * <code>string game_server_deployment_name = 2;</code>
     *
     * @return The gameServerDeploymentName.
     */
    public java.lang.String getGameServerDeploymentName() {
      java.lang.Object ref = gameServerDeploymentName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        gameServerDeploymentName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The game server deployment name. Uses the form:
     * `projects/{project}/locations/{location}/gameServerDeployments/{deployment_id}`.
     * </pre>
     *
     * <code>string game_server_deployment_name = 2;</code>
     *
     * @return The bytes for gameServerDeploymentName.
     */
    public com.google.protobuf.ByteString getGameServerDeploymentNameBytes() {
      java.lang.Object ref = gameServerDeploymentName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        gameServerDeploymentName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The game server deployment name. Uses the form:
     * `projects/{project}/locations/{location}/gameServerDeployments/{deployment_id}`.
     * </pre>
     *
     * <code>string game_server_deployment_name = 2;</code>
     *
     * @param value The gameServerDeploymentName to set.
     * @return This builder for chaining.
     */
    public Builder setGameServerDeploymentName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      gameServerDeploymentName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The game server deployment name. Uses the form:
     * `projects/{project}/locations/{location}/gameServerDeployments/{deployment_id}`.
     * </pre>
     *
     * <code>string game_server_deployment_name = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearGameServerDeploymentName() {
      gameServerDeploymentName_ = getDefaultInstance().getGameServerDeploymentName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The game server deployment name. Uses the form:
     * `projects/{project}/locations/{location}/gameServerDeployments/{deployment_id}`.
     * </pre>
     *
     * <code>string game_server_deployment_name = 2;</code>
     *
     * @param value The bytes for gameServerDeploymentName to set.
     * @return This builder for chaining.
     */
    public Builder setGameServerDeploymentNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      gameServerDeploymentName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails>
        fleetDetails_ = java.util.Collections.emptyList();

    private void ensureFleetDetailsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        fleetDetails_ =
            new java.util.ArrayList<com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails>(
                fleetDetails_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails,
            com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.Builder,
            com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetailsOrBuilder>
        fleetDetailsBuilder_;

    /**
     *
     *
     * <pre>
     * Agones fleet details for game server clusters and game server deployments.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.TargetDetails.TargetFleetDetails fleet_details = 3;
     * </code>
     */
    public java.util.List<com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails>
        getFleetDetailsList() {
      if (fleetDetailsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(fleetDetails_);
      } else {
        return fleetDetailsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Agones fleet details for game server clusters and game server deployments.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.TargetDetails.TargetFleetDetails fleet_details = 3;
     * </code>
     */
    public int getFleetDetailsCount() {
      if (fleetDetailsBuilder_ == null) {
        return fleetDetails_.size();
      } else {
        return fleetDetailsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Agones fleet details for game server clusters and game server deployments.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.TargetDetails.TargetFleetDetails fleet_details = 3;
     * </code>
     */
    public com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails getFleetDetails(int index) {
      if (fleetDetailsBuilder_ == null) {
        return fleetDetails_.get(index);
      } else {
        return fleetDetailsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Agones fleet details for game server clusters and game server deployments.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.TargetDetails.TargetFleetDetails fleet_details = 3;
     * </code>
     */
    public Builder setFleetDetails(
        int index, com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails value) {
      if (fleetDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFleetDetailsIsMutable();
        fleetDetails_.set(index, value);
        onChanged();
      } else {
        fleetDetailsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Agones fleet details for game server clusters and game server deployments.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.TargetDetails.TargetFleetDetails fleet_details = 3;
     * </code>
     */
    public Builder setFleetDetails(
        int index,
        com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.Builder builderForValue) {
      if (fleetDetailsBuilder_ == null) {
        ensureFleetDetailsIsMutable();
        fleetDetails_.set(index, builderForValue.build());
        onChanged();
      } else {
        fleetDetailsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Agones fleet details for game server clusters and game server deployments.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.TargetDetails.TargetFleetDetails fleet_details = 3;
     * </code>
     */
    public Builder addFleetDetails(
        com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails value) {
      if (fleetDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFleetDetailsIsMutable();
        fleetDetails_.add(value);
        onChanged();
      } else {
        fleetDetailsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Agones fleet details for game server clusters and game server deployments.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.TargetDetails.TargetFleetDetails fleet_details = 3;
     * </code>
     */
    public Builder addFleetDetails(
        int index, com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails value) {
      if (fleetDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFleetDetailsIsMutable();
        fleetDetails_.add(index, value);
        onChanged();
      } else {
        fleetDetailsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Agones fleet details for game server clusters and game server deployments.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.TargetDetails.TargetFleetDetails fleet_details = 3;
     * </code>
     */
    public Builder addFleetDetails(
        com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.Builder builderForValue) {
      if (fleetDetailsBuilder_ == null) {
        ensureFleetDetailsIsMutable();
        fleetDetails_.add(builderForValue.build());
        onChanged();
      } else {
        fleetDetailsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Agones fleet details for game server clusters and game server deployments.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.TargetDetails.TargetFleetDetails fleet_details = 3;
     * </code>
     */
    public Builder addFleetDetails(
        int index,
        com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.Builder builderForValue) {
      if (fleetDetailsBuilder_ == null) {
        ensureFleetDetailsIsMutable();
        fleetDetails_.add(index, builderForValue.build());
        onChanged();
      } else {
        fleetDetailsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Agones fleet details for game server clusters and game server deployments.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.TargetDetails.TargetFleetDetails fleet_details = 3;
     * </code>
     */
    public Builder addAllFleetDetails(
        java.lang.Iterable<? extends com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails>
            values) {
      if (fleetDetailsBuilder_ == null) {
        ensureFleetDetailsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, fleetDetails_);
        onChanged();
      } else {
        fleetDetailsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Agones fleet details for game server clusters and game server deployments.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.TargetDetails.TargetFleetDetails fleet_details = 3;
     * </code>
     */
    public Builder clearFleetDetails() {
      if (fleetDetailsBuilder_ == null) {
        fleetDetails_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        fleetDetailsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Agones fleet details for game server clusters and game server deployments.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.TargetDetails.TargetFleetDetails fleet_details = 3;
     * </code>
     */
    public Builder removeFleetDetails(int index) {
      if (fleetDetailsBuilder_ == null) {
        ensureFleetDetailsIsMutable();
        fleetDetails_.remove(index);
        onChanged();
      } else {
        fleetDetailsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Agones fleet details for game server clusters and game server deployments.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.TargetDetails.TargetFleetDetails fleet_details = 3;
     * </code>
     */
    public com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.Builder
        getFleetDetailsBuilder(int index) {
      return getFleetDetailsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Agones fleet details for game server clusters and game server deployments.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.TargetDetails.TargetFleetDetails fleet_details = 3;
     * </code>
     */
    public com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetailsOrBuilder
        getFleetDetailsOrBuilder(int index) {
      if (fleetDetailsBuilder_ == null) {
        return fleetDetails_.get(index);
      } else {
        return fleetDetailsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Agones fleet details for game server clusters and game server deployments.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.TargetDetails.TargetFleetDetails fleet_details = 3;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetailsOrBuilder>
        getFleetDetailsOrBuilderList() {
      if (fleetDetailsBuilder_ != null) {
        return fleetDetailsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(fleetDetails_);
      }
    }
    /**
     *
     *
     * <pre>
     * Agones fleet details for game server clusters and game server deployments.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.TargetDetails.TargetFleetDetails fleet_details = 3;
     * </code>
     */
    public com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.Builder
        addFleetDetailsBuilder() {
      return getFleetDetailsFieldBuilder()
          .addBuilder(
              com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Agones fleet details for game server clusters and game server deployments.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.TargetDetails.TargetFleetDetails fleet_details = 3;
     * </code>
     */
    public com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.Builder
        addFleetDetailsBuilder(int index) {
      return getFleetDetailsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Agones fleet details for game server clusters and game server deployments.
     * </pre>
     *
     * <code>repeated .google.cloud.gaming.v1.TargetDetails.TargetFleetDetails fleet_details = 3;
     * </code>
     */
    public java.util.List<com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.Builder>
        getFleetDetailsBuilderList() {
      return getFleetDetailsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails,
            com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.Builder,
            com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetailsOrBuilder>
        getFleetDetailsFieldBuilder() {
      if (fleetDetailsBuilder_ == null) {
        fleetDetailsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails,
                com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetails.Builder,
                com.google.cloud.gaming.v1.TargetDetails.TargetFleetDetailsOrBuilder>(
                fleetDetails_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
        fleetDetails_ = null;
      }
      return fleetDetailsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.gaming.v1.TargetDetails)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.gaming.v1.TargetDetails)
  private static final com.google.cloud.gaming.v1.TargetDetails DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.gaming.v1.TargetDetails();
  }

  public static com.google.cloud.gaming.v1.TargetDetails getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TargetDetails> PARSER =
      new com.google.protobuf.AbstractParser<TargetDetails>() {
        @java.lang.Override
        public TargetDetails parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<TargetDetails> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TargetDetails> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.gaming.v1.TargetDetails getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
