/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/gkebackup/v1/backup_plan.proto

package com.google.cloud.gkebackup.v1;

/**
 *
 *
 * <pre>
 * Defines the configuration and scheduling for a "line" of Backups.
 * </pre>
 *
 * Protobuf type {@code google.cloud.gkebackup.v1.BackupPlan}
 */
public final class BackupPlan extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.gkebackup.v1.BackupPlan)
    BackupPlanOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use BackupPlan.newBuilder() to construct.
  private BackupPlan(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BackupPlan() {
    name_ = "";
    uid_ = "";
    description_ = "";
    cluster_ = "";
    etag_ = "";
    state_ = 0;
    stateReason_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BackupPlan();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.gkebackup.v1.BackupPlanProto
        .internal_static_google_cloud_gkebackup_v1_BackupPlan_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 8:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.gkebackup.v1.BackupPlanProto
        .internal_static_google_cloud_gkebackup_v1_BackupPlan_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.gkebackup.v1.BackupPlan.class,
            com.google.cloud.gkebackup.v1.BackupPlan.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * State
   * </pre>
   *
   * Protobuf enum {@code google.cloud.gkebackup.v1.BackupPlan.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default first value for Enums.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Waiting for cluster state to be RUNNING.
     * </pre>
     *
     * <code>CLUSTER_PENDING = 1;</code>
     */
    CLUSTER_PENDING(1),
    /**
     *
     *
     * <pre>
     * The BackupPlan is in the process of being created.
     * </pre>
     *
     * <code>PROVISIONING = 2;</code>
     */
    PROVISIONING(2),
    /**
     *
     *
     * <pre>
     * The BackupPlan has successfully been created and is ready for Backups.
     * </pre>
     *
     * <code>READY = 3;</code>
     */
    READY(3),
    /**
     *
     *
     * <pre>
     * BackupPlan creation has failed.
     * </pre>
     *
     * <code>FAILED = 4;</code>
     */
    FAILED(4),
    /**
     *
     *
     * <pre>
     * The BackupPlan has been deactivated.
     * </pre>
     *
     * <code>DEACTIVATED = 5;</code>
     */
    DEACTIVATED(5),
    /**
     *
     *
     * <pre>
     * The BackupPlan is in the process of being deleted.
     * </pre>
     *
     * <code>DELETING = 6;</code>
     */
    DELETING(6),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default first value for Enums.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Waiting for cluster state to be RUNNING.
     * </pre>
     *
     * <code>CLUSTER_PENDING = 1;</code>
     */
    public static final int CLUSTER_PENDING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The BackupPlan is in the process of being created.
     * </pre>
     *
     * <code>PROVISIONING = 2;</code>
     */
    public static final int PROVISIONING_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The BackupPlan has successfully been created and is ready for Backups.
     * </pre>
     *
     * <code>READY = 3;</code>
     */
    public static final int READY_VALUE = 3;
    /**
     *
     *
     * <pre>
     * BackupPlan creation has failed.
     * </pre>
     *
     * <code>FAILED = 4;</code>
     */
    public static final int FAILED_VALUE = 4;
    /**
     *
     *
     * <pre>
     * The BackupPlan has been deactivated.
     * </pre>
     *
     * <code>DEACTIVATED = 5;</code>
     */
    public static final int DEACTIVATED_VALUE = 5;
    /**
     *
     *
     * <pre>
     * The BackupPlan is in the process of being deleted.
     * </pre>
     *
     * <code>DELETING = 6;</code>
     */
    public static final int DELETING_VALUE = 6;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return CLUSTER_PENDING;
        case 2:
          return PROVISIONING;
        case 3:
          return READY;
        case 4:
          return FAILED;
        case 5:
          return DEACTIVATED;
        case 6:
          return DELETING;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.gkebackup.v1.BackupPlan.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.gkebackup.v1.BackupPlan.State)
  }

  public interface RetentionPolicyOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Minimum age for Backups created via this BackupPlan (in days).
     * This field MUST be an integer value between 0-90 (inclusive).
     * A Backup created under this BackupPlan will NOT be deletable until it
     * reaches Backup's (create_time + backup_delete_lock_days).
     * Updating this field of a BackupPlan does NOT affect existing Backups
     * under it. Backups created AFTER a successful update will inherit
     * the new value.
     *
     * Default: 0 (no delete blocking)
     * </pre>
     *
     * <code>int32 backup_delete_lock_days = 1;</code>
     *
     * @return The backupDeleteLockDays.
     */
    int getBackupDeleteLockDays();

    /**
     *
     *
     * <pre>
     * The default maximum age of a Backup created via this BackupPlan.
     * This field MUST be an integer value &gt;= 0 and &lt;= 365.
     * If specified, a Backup created under this BackupPlan will be
     * automatically deleted after its age reaches (create_time +
     * backup_retain_days).
     * If not specified, Backups created under this BackupPlan will NOT be
     * subject to automatic deletion.
     * Updating this field does NOT affect existing Backups under it. Backups
     * created AFTER a successful update will automatically pick up the new
     * value.
     * NOTE: backup_retain_days must be &gt;=
     * [backup_delete_lock_days][google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy.backup_delete_lock_days].
     * If
     * [cron_schedule][google.cloud.gkebackup.v1.BackupPlan.Schedule.cron_schedule]
     * is defined, then this must be
     * &lt;= 360 * the creation interval.
     *
     * Default: 0 (no automatic deletion)
     * </pre>
     *
     * <code>int32 backup_retain_days = 2;</code>
     *
     * @return The backupRetainDays.
     */
    int getBackupRetainDays();

    /**
     *
     *
     * <pre>
     * This flag denotes whether the retention policy of this BackupPlan is
     * locked.  If set to True, no further update is allowed on this policy,
     * including the `locked` field itself.
     *
     * Default: False
     * </pre>
     *
     * <code>bool locked = 3;</code>
     *
     * @return The locked.
     */
    boolean getLocked();
  }
  /**
   *
   *
   * <pre>
   * RetentionPolicy defines a Backup retention policy for a BackupPlan.
   * </pre>
   *
   * Protobuf type {@code google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy}
   */
  public static final class RetentionPolicy extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy)
      RetentionPolicyOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use RetentionPolicy.newBuilder() to construct.
    private RetentionPolicy(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private RetentionPolicy() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new RetentionPolicy();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.gkebackup.v1.BackupPlanProto
          .internal_static_google_cloud_gkebackup_v1_BackupPlan_RetentionPolicy_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.gkebackup.v1.BackupPlanProto
          .internal_static_google_cloud_gkebackup_v1_BackupPlan_RetentionPolicy_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy.class,
              com.google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy.Builder.class);
    }

    public static final int BACKUP_DELETE_LOCK_DAYS_FIELD_NUMBER = 1;
    private int backupDeleteLockDays_ = 0;
    /**
     *
     *
     * <pre>
     * Minimum age for Backups created via this BackupPlan (in days).
     * This field MUST be an integer value between 0-90 (inclusive).
     * A Backup created under this BackupPlan will NOT be deletable until it
     * reaches Backup's (create_time + backup_delete_lock_days).
     * Updating this field of a BackupPlan does NOT affect existing Backups
     * under it. Backups created AFTER a successful update will inherit
     * the new value.
     *
     * Default: 0 (no delete blocking)
     * </pre>
     *
     * <code>int32 backup_delete_lock_days = 1;</code>
     *
     * @return The backupDeleteLockDays.
     */
    @java.lang.Override
    public int getBackupDeleteLockDays() {
      return backupDeleteLockDays_;
    }

    public static final int BACKUP_RETAIN_DAYS_FIELD_NUMBER = 2;
    private int backupRetainDays_ = 0;
    /**
     *
     *
     * <pre>
     * The default maximum age of a Backup created via this BackupPlan.
     * This field MUST be an integer value &gt;= 0 and &lt;= 365.
     * If specified, a Backup created under this BackupPlan will be
     * automatically deleted after its age reaches (create_time +
     * backup_retain_days).
     * If not specified, Backups created under this BackupPlan will NOT be
     * subject to automatic deletion.
     * Updating this field does NOT affect existing Backups under it. Backups
     * created AFTER a successful update will automatically pick up the new
     * value.
     * NOTE: backup_retain_days must be &gt;=
     * [backup_delete_lock_days][google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy.backup_delete_lock_days].
     * If
     * [cron_schedule][google.cloud.gkebackup.v1.BackupPlan.Schedule.cron_schedule]
     * is defined, then this must be
     * &lt;= 360 * the creation interval.
     *
     * Default: 0 (no automatic deletion)
     * </pre>
     *
     * <code>int32 backup_retain_days = 2;</code>
     *
     * @return The backupRetainDays.
     */
    @java.lang.Override
    public int getBackupRetainDays() {
      return backupRetainDays_;
    }

    public static final int LOCKED_FIELD_NUMBER = 3;
    private boolean locked_ = false;
    /**
     *
     *
     * <pre>
     * This flag denotes whether the retention policy of this BackupPlan is
     * locked.  If set to True, no further update is allowed on this policy,
     * including the `locked` field itself.
     *
     * Default: False
     * </pre>
     *
     * <code>bool locked = 3;</code>
     *
     * @return The locked.
     */
    @java.lang.Override
    public boolean getLocked() {
      return locked_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (backupDeleteLockDays_ != 0) {
        output.writeInt32(1, backupDeleteLockDays_);
      }
      if (backupRetainDays_ != 0) {
        output.writeInt32(2, backupRetainDays_);
      }
      if (locked_ != false) {
        output.writeBool(3, locked_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (backupDeleteLockDays_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, backupDeleteLockDays_);
      }
      if (backupRetainDays_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, backupRetainDays_);
      }
      if (locked_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, locked_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy)) {
        return super.equals(obj);
      }
      com.google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy other =
          (com.google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy) obj;

      if (getBackupDeleteLockDays() != other.getBackupDeleteLockDays()) return false;
      if (getBackupRetainDays() != other.getBackupRetainDays()) return false;
      if (getLocked() != other.getLocked()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + BACKUP_DELETE_LOCK_DAYS_FIELD_NUMBER;
      hash = (53 * hash) + getBackupDeleteLockDays();
      hash = (37 * hash) + BACKUP_RETAIN_DAYS_FIELD_NUMBER;
      hash = (53 * hash) + getBackupRetainDays();
      hash = (37 * hash) + LOCKED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getLocked());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * RetentionPolicy defines a Backup retention policy for a BackupPlan.
     * </pre>
     *
     * Protobuf type {@code google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy)
        com.google.cloud.gkebackup.v1.BackupPlan.RetentionPolicyOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.gkebackup.v1.BackupPlanProto
            .internal_static_google_cloud_gkebackup_v1_BackupPlan_RetentionPolicy_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.gkebackup.v1.BackupPlanProto
            .internal_static_google_cloud_gkebackup_v1_BackupPlan_RetentionPolicy_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy.class,
                com.google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy.Builder.class);
      }

      // Construct using com.google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        backupDeleteLockDays_ = 0;
        backupRetainDays_ = 0;
        locked_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.gkebackup.v1.BackupPlanProto
            .internal_static_google_cloud_gkebackup_v1_BackupPlan_RetentionPolicy_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy getDefaultInstanceForType() {
        return com.google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy build() {
        com.google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy buildPartial() {
        com.google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy result =
            new com.google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.backupDeleteLockDays_ = backupDeleteLockDays_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.backupRetainDays_ = backupRetainDays_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.locked_ = locked_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy) {
          return mergeFrom((com.google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy other) {
        if (other == com.google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy.getDefaultInstance())
          return this;
        if (other.getBackupDeleteLockDays() != 0) {
          setBackupDeleteLockDays(other.getBackupDeleteLockDays());
        }
        if (other.getBackupRetainDays() != 0) {
          setBackupRetainDays(other.getBackupRetainDays());
        }
        if (other.getLocked() != false) {
          setLocked(other.getLocked());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  backupDeleteLockDays_ = input.readInt32();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 16:
                {
                  backupRetainDays_ = input.readInt32();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 24:
                {
                  locked_ = input.readBool();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int backupDeleteLockDays_;
      /**
       *
       *
       * <pre>
       * Minimum age for Backups created via this BackupPlan (in days).
       * This field MUST be an integer value between 0-90 (inclusive).
       * A Backup created under this BackupPlan will NOT be deletable until it
       * reaches Backup's (create_time + backup_delete_lock_days).
       * Updating this field of a BackupPlan does NOT affect existing Backups
       * under it. Backups created AFTER a successful update will inherit
       * the new value.
       *
       * Default: 0 (no delete blocking)
       * </pre>
       *
       * <code>int32 backup_delete_lock_days = 1;</code>
       *
       * @return The backupDeleteLockDays.
       */
      @java.lang.Override
      public int getBackupDeleteLockDays() {
        return backupDeleteLockDays_;
      }
      /**
       *
       *
       * <pre>
       * Minimum age for Backups created via this BackupPlan (in days).
       * This field MUST be an integer value between 0-90 (inclusive).
       * A Backup created under this BackupPlan will NOT be deletable until it
       * reaches Backup's (create_time + backup_delete_lock_days).
       * Updating this field of a BackupPlan does NOT affect existing Backups
       * under it. Backups created AFTER a successful update will inherit
       * the new value.
       *
       * Default: 0 (no delete blocking)
       * </pre>
       *
       * <code>int32 backup_delete_lock_days = 1;</code>
       *
       * @param value The backupDeleteLockDays to set.
       * @return This builder for chaining.
       */
      public Builder setBackupDeleteLockDays(int value) {

        backupDeleteLockDays_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Minimum age for Backups created via this BackupPlan (in days).
       * This field MUST be an integer value between 0-90 (inclusive).
       * A Backup created under this BackupPlan will NOT be deletable until it
       * reaches Backup's (create_time + backup_delete_lock_days).
       * Updating this field of a BackupPlan does NOT affect existing Backups
       * under it. Backups created AFTER a successful update will inherit
       * the new value.
       *
       * Default: 0 (no delete blocking)
       * </pre>
       *
       * <code>int32 backup_delete_lock_days = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearBackupDeleteLockDays() {
        bitField0_ = (bitField0_ & ~0x00000001);
        backupDeleteLockDays_ = 0;
        onChanged();
        return this;
      }

      private int backupRetainDays_;
      /**
       *
       *
       * <pre>
       * The default maximum age of a Backup created via this BackupPlan.
       * This field MUST be an integer value &gt;= 0 and &lt;= 365.
       * If specified, a Backup created under this BackupPlan will be
       * automatically deleted after its age reaches (create_time +
       * backup_retain_days).
       * If not specified, Backups created under this BackupPlan will NOT be
       * subject to automatic deletion.
       * Updating this field does NOT affect existing Backups under it. Backups
       * created AFTER a successful update will automatically pick up the new
       * value.
       * NOTE: backup_retain_days must be &gt;=
       * [backup_delete_lock_days][google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy.backup_delete_lock_days].
       * If
       * [cron_schedule][google.cloud.gkebackup.v1.BackupPlan.Schedule.cron_schedule]
       * is defined, then this must be
       * &lt;= 360 * the creation interval.
       *
       * Default: 0 (no automatic deletion)
       * </pre>
       *
       * <code>int32 backup_retain_days = 2;</code>
       *
       * @return The backupRetainDays.
       */
      @java.lang.Override
      public int getBackupRetainDays() {
        return backupRetainDays_;
      }
      /**
       *
       *
       * <pre>
       * The default maximum age of a Backup created via this BackupPlan.
       * This field MUST be an integer value &gt;= 0 and &lt;= 365.
       * If specified, a Backup created under this BackupPlan will be
       * automatically deleted after its age reaches (create_time +
       * backup_retain_days).
       * If not specified, Backups created under this BackupPlan will NOT be
       * subject to automatic deletion.
       * Updating this field does NOT affect existing Backups under it. Backups
       * created AFTER a successful update will automatically pick up the new
       * value.
       * NOTE: backup_retain_days must be &gt;=
       * [backup_delete_lock_days][google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy.backup_delete_lock_days].
       * If
       * [cron_schedule][google.cloud.gkebackup.v1.BackupPlan.Schedule.cron_schedule]
       * is defined, then this must be
       * &lt;= 360 * the creation interval.
       *
       * Default: 0 (no automatic deletion)
       * </pre>
       *
       * <code>int32 backup_retain_days = 2;</code>
       *
       * @param value The backupRetainDays to set.
       * @return This builder for chaining.
       */
      public Builder setBackupRetainDays(int value) {

        backupRetainDays_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The default maximum age of a Backup created via this BackupPlan.
       * This field MUST be an integer value &gt;= 0 and &lt;= 365.
       * If specified, a Backup created under this BackupPlan will be
       * automatically deleted after its age reaches (create_time +
       * backup_retain_days).
       * If not specified, Backups created under this BackupPlan will NOT be
       * subject to automatic deletion.
       * Updating this field does NOT affect existing Backups under it. Backups
       * created AFTER a successful update will automatically pick up the new
       * value.
       * NOTE: backup_retain_days must be &gt;=
       * [backup_delete_lock_days][google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy.backup_delete_lock_days].
       * If
       * [cron_schedule][google.cloud.gkebackup.v1.BackupPlan.Schedule.cron_schedule]
       * is defined, then this must be
       * &lt;= 360 * the creation interval.
       *
       * Default: 0 (no automatic deletion)
       * </pre>
       *
       * <code>int32 backup_retain_days = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearBackupRetainDays() {
        bitField0_ = (bitField0_ & ~0x00000002);
        backupRetainDays_ = 0;
        onChanged();
        return this;
      }

      private boolean locked_;
      /**
       *
       *
       * <pre>
       * This flag denotes whether the retention policy of this BackupPlan is
       * locked.  If set to True, no further update is allowed on this policy,
       * including the `locked` field itself.
       *
       * Default: False
       * </pre>
       *
       * <code>bool locked = 3;</code>
       *
       * @return The locked.
       */
      @java.lang.Override
      public boolean getLocked() {
        return locked_;
      }
      /**
       *
       *
       * <pre>
       * This flag denotes whether the retention policy of this BackupPlan is
       * locked.  If set to True, no further update is allowed on this policy,
       * including the `locked` field itself.
       *
       * Default: False
       * </pre>
       *
       * <code>bool locked = 3;</code>
       *
       * @param value The locked to set.
       * @return This builder for chaining.
       */
      public Builder setLocked(boolean value) {

        locked_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * This flag denotes whether the retention policy of this BackupPlan is
       * locked.  If set to True, no further update is allowed on this policy,
       * including the `locked` field itself.
       *
       * Default: False
       * </pre>
       *
       * <code>bool locked = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearLocked() {
        bitField0_ = (bitField0_ & ~0x00000004);
        locked_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy)
    private static final com.google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy();
    }

    public static com.google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<RetentionPolicy> PARSER =
        new com.google.protobuf.AbstractParser<RetentionPolicy>() {
          @java.lang.Override
          public RetentionPolicy parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<RetentionPolicy> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<RetentionPolicy> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ScheduleOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.gkebackup.v1.BackupPlan.Schedule)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * A standard [cron](https://wikipedia.com/wiki/cron) string that defines a
     * repeating schedule for creating Backups via this BackupPlan. If this is
     * defined, then
     * [backup_retain_days][google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy.backup_retain_days]
     * must also be defined.
     *
     * Default (empty): no automatic backup creation will occur.
     * </pre>
     *
     * <code>string cron_schedule = 1;</code>
     *
     * @return The cronSchedule.
     */
    java.lang.String getCronSchedule();
    /**
     *
     *
     * <pre>
     * A standard [cron](https://wikipedia.com/wiki/cron) string that defines a
     * repeating schedule for creating Backups via this BackupPlan. If this is
     * defined, then
     * [backup_retain_days][google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy.backup_retain_days]
     * must also be defined.
     *
     * Default (empty): no automatic backup creation will occur.
     * </pre>
     *
     * <code>string cron_schedule = 1;</code>
     *
     * @return The bytes for cronSchedule.
     */
    com.google.protobuf.ByteString getCronScheduleBytes();

    /**
     *
     *
     * <pre>
     * This flag denotes whether automatic Backup creation is paused for this
     * BackupPlan.
     *
     * Default: False
     * </pre>
     *
     * <code>bool paused = 2;</code>
     *
     * @return The paused.
     */
    boolean getPaused();
  }
  /**
   *
   *
   * <pre>
   * Defines scheduling parameters for automatically creating Backups
   * via this BackupPlan.
   * </pre>
   *
   * Protobuf type {@code google.cloud.gkebackup.v1.BackupPlan.Schedule}
   */
  public static final class Schedule extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.gkebackup.v1.BackupPlan.Schedule)
      ScheduleOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Schedule.newBuilder() to construct.
    private Schedule(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Schedule() {
      cronSchedule_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Schedule();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.gkebackup.v1.BackupPlanProto
          .internal_static_google_cloud_gkebackup_v1_BackupPlan_Schedule_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.gkebackup.v1.BackupPlanProto
          .internal_static_google_cloud_gkebackup_v1_BackupPlan_Schedule_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.gkebackup.v1.BackupPlan.Schedule.class,
              com.google.cloud.gkebackup.v1.BackupPlan.Schedule.Builder.class);
    }

    public static final int CRON_SCHEDULE_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object cronSchedule_ = "";
    /**
     *
     *
     * <pre>
     * A standard [cron](https://wikipedia.com/wiki/cron) string that defines a
     * repeating schedule for creating Backups via this BackupPlan. If this is
     * defined, then
     * [backup_retain_days][google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy.backup_retain_days]
     * must also be defined.
     *
     * Default (empty): no automatic backup creation will occur.
     * </pre>
     *
     * <code>string cron_schedule = 1;</code>
     *
     * @return The cronSchedule.
     */
    @java.lang.Override
    public java.lang.String getCronSchedule() {
      java.lang.Object ref = cronSchedule_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        cronSchedule_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * A standard [cron](https://wikipedia.com/wiki/cron) string that defines a
     * repeating schedule for creating Backups via this BackupPlan. If this is
     * defined, then
     * [backup_retain_days][google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy.backup_retain_days]
     * must also be defined.
     *
     * Default (empty): no automatic backup creation will occur.
     * </pre>
     *
     * <code>string cron_schedule = 1;</code>
     *
     * @return The bytes for cronSchedule.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getCronScheduleBytes() {
      java.lang.Object ref = cronSchedule_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        cronSchedule_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PAUSED_FIELD_NUMBER = 2;
    private boolean paused_ = false;
    /**
     *
     *
     * <pre>
     * This flag denotes whether automatic Backup creation is paused for this
     * BackupPlan.
     *
     * Default: False
     * </pre>
     *
     * <code>bool paused = 2;</code>
     *
     * @return The paused.
     */
    @java.lang.Override
    public boolean getPaused() {
      return paused_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cronSchedule_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, cronSchedule_);
      }
      if (paused_ != false) {
        output.writeBool(2, paused_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cronSchedule_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, cronSchedule_);
      }
      if (paused_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, paused_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.gkebackup.v1.BackupPlan.Schedule)) {
        return super.equals(obj);
      }
      com.google.cloud.gkebackup.v1.BackupPlan.Schedule other =
          (com.google.cloud.gkebackup.v1.BackupPlan.Schedule) obj;

      if (!getCronSchedule().equals(other.getCronSchedule())) return false;
      if (getPaused() != other.getPaused()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + CRON_SCHEDULE_FIELD_NUMBER;
      hash = (53 * hash) + getCronSchedule().hashCode();
      hash = (37 * hash) + PAUSED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getPaused());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.gkebackup.v1.BackupPlan.Schedule parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.gkebackup.v1.BackupPlan.Schedule parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.gkebackup.v1.BackupPlan.Schedule parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.gkebackup.v1.BackupPlan.Schedule parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.gkebackup.v1.BackupPlan.Schedule parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.gkebackup.v1.BackupPlan.Schedule parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.gkebackup.v1.BackupPlan.Schedule parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.gkebackup.v1.BackupPlan.Schedule parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.gkebackup.v1.BackupPlan.Schedule parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.gkebackup.v1.BackupPlan.Schedule parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.gkebackup.v1.BackupPlan.Schedule parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.gkebackup.v1.BackupPlan.Schedule parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.cloud.gkebackup.v1.BackupPlan.Schedule prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Defines scheduling parameters for automatically creating Backups
     * via this BackupPlan.
     * </pre>
     *
     * Protobuf type {@code google.cloud.gkebackup.v1.BackupPlan.Schedule}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.gkebackup.v1.BackupPlan.Schedule)
        com.google.cloud.gkebackup.v1.BackupPlan.ScheduleOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.gkebackup.v1.BackupPlanProto
            .internal_static_google_cloud_gkebackup_v1_BackupPlan_Schedule_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.gkebackup.v1.BackupPlanProto
            .internal_static_google_cloud_gkebackup_v1_BackupPlan_Schedule_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.gkebackup.v1.BackupPlan.Schedule.class,
                com.google.cloud.gkebackup.v1.BackupPlan.Schedule.Builder.class);
      }

      // Construct using com.google.cloud.gkebackup.v1.BackupPlan.Schedule.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        cronSchedule_ = "";
        paused_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.gkebackup.v1.BackupPlanProto
            .internal_static_google_cloud_gkebackup_v1_BackupPlan_Schedule_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.gkebackup.v1.BackupPlan.Schedule getDefaultInstanceForType() {
        return com.google.cloud.gkebackup.v1.BackupPlan.Schedule.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.gkebackup.v1.BackupPlan.Schedule build() {
        com.google.cloud.gkebackup.v1.BackupPlan.Schedule result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.gkebackup.v1.BackupPlan.Schedule buildPartial() {
        com.google.cloud.gkebackup.v1.BackupPlan.Schedule result =
            new com.google.cloud.gkebackup.v1.BackupPlan.Schedule(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.gkebackup.v1.BackupPlan.Schedule result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.cronSchedule_ = cronSchedule_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.paused_ = paused_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.gkebackup.v1.BackupPlan.Schedule) {
          return mergeFrom((com.google.cloud.gkebackup.v1.BackupPlan.Schedule) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.gkebackup.v1.BackupPlan.Schedule other) {
        if (other == com.google.cloud.gkebackup.v1.BackupPlan.Schedule.getDefaultInstance())
          return this;
        if (!other.getCronSchedule().isEmpty()) {
          cronSchedule_ = other.cronSchedule_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.getPaused() != false) {
          setPaused(other.getPaused());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  cronSchedule_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 16:
                {
                  paused_ = input.readBool();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object cronSchedule_ = "";
      /**
       *
       *
       * <pre>
       * A standard [cron](https://wikipedia.com/wiki/cron) string that defines a
       * repeating schedule for creating Backups via this BackupPlan. If this is
       * defined, then
       * [backup_retain_days][google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy.backup_retain_days]
       * must also be defined.
       *
       * Default (empty): no automatic backup creation will occur.
       * </pre>
       *
       * <code>string cron_schedule = 1;</code>
       *
       * @return The cronSchedule.
       */
      public java.lang.String getCronSchedule() {
        java.lang.Object ref = cronSchedule_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          cronSchedule_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * A standard [cron](https://wikipedia.com/wiki/cron) string that defines a
       * repeating schedule for creating Backups via this BackupPlan. If this is
       * defined, then
       * [backup_retain_days][google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy.backup_retain_days]
       * must also be defined.
       *
       * Default (empty): no automatic backup creation will occur.
       * </pre>
       *
       * <code>string cron_schedule = 1;</code>
       *
       * @return The bytes for cronSchedule.
       */
      public com.google.protobuf.ByteString getCronScheduleBytes() {
        java.lang.Object ref = cronSchedule_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          cronSchedule_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * A standard [cron](https://wikipedia.com/wiki/cron) string that defines a
       * repeating schedule for creating Backups via this BackupPlan. If this is
       * defined, then
       * [backup_retain_days][google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy.backup_retain_days]
       * must also be defined.
       *
       * Default (empty): no automatic backup creation will occur.
       * </pre>
       *
       * <code>string cron_schedule = 1;</code>
       *
       * @param value The cronSchedule to set.
       * @return This builder for chaining.
       */
      public Builder setCronSchedule(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        cronSchedule_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A standard [cron](https://wikipedia.com/wiki/cron) string that defines a
       * repeating schedule for creating Backups via this BackupPlan. If this is
       * defined, then
       * [backup_retain_days][google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy.backup_retain_days]
       * must also be defined.
       *
       * Default (empty): no automatic backup creation will occur.
       * </pre>
       *
       * <code>string cron_schedule = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCronSchedule() {
        cronSchedule_ = getDefaultInstance().getCronSchedule();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A standard [cron](https://wikipedia.com/wiki/cron) string that defines a
       * repeating schedule for creating Backups via this BackupPlan. If this is
       * defined, then
       * [backup_retain_days][google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy.backup_retain_days]
       * must also be defined.
       *
       * Default (empty): no automatic backup creation will occur.
       * </pre>
       *
       * <code>string cron_schedule = 1;</code>
       *
       * @param value The bytes for cronSchedule to set.
       * @return This builder for chaining.
       */
      public Builder setCronScheduleBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        cronSchedule_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private boolean paused_;
      /**
       *
       *
       * <pre>
       * This flag denotes whether automatic Backup creation is paused for this
       * BackupPlan.
       *
       * Default: False
       * </pre>
       *
       * <code>bool paused = 2;</code>
       *
       * @return The paused.
       */
      @java.lang.Override
      public boolean getPaused() {
        return paused_;
      }
      /**
       *
       *
       * <pre>
       * This flag denotes whether automatic Backup creation is paused for this
       * BackupPlan.
       *
       * Default: False
       * </pre>
       *
       * <code>bool paused = 2;</code>
       *
       * @param value The paused to set.
       * @return This builder for chaining.
       */
      public Builder setPaused(boolean value) {

        paused_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * This flag denotes whether automatic Backup creation is paused for this
       * BackupPlan.
       *
       * Default: False
       * </pre>
       *
       * <code>bool paused = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPaused() {
        bitField0_ = (bitField0_ & ~0x00000002);
        paused_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.gkebackup.v1.BackupPlan.Schedule)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.gkebackup.v1.BackupPlan.Schedule)
    private static final com.google.cloud.gkebackup.v1.BackupPlan.Schedule DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.gkebackup.v1.BackupPlan.Schedule();
    }

    public static com.google.cloud.gkebackup.v1.BackupPlan.Schedule getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Schedule> PARSER =
        new com.google.protobuf.AbstractParser<Schedule>() {
          @java.lang.Override
          public Schedule parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Schedule> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Schedule> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.gkebackup.v1.BackupPlan.Schedule getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface BackupConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.gkebackup.v1.BackupPlan.BackupConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * If True, include all namespaced resources
     * </pre>
     *
     * <code>bool all_namespaces = 1;</code>
     *
     * @return Whether the allNamespaces field is set.
     */
    boolean hasAllNamespaces();
    /**
     *
     *
     * <pre>
     * If True, include all namespaced resources
     * </pre>
     *
     * <code>bool all_namespaces = 1;</code>
     *
     * @return The allNamespaces.
     */
    boolean getAllNamespaces();

    /**
     *
     *
     * <pre>
     * If set, include just the resources in the listed namespaces.
     * </pre>
     *
     * <code>.google.cloud.gkebackup.v1.Namespaces selected_namespaces = 2;</code>
     *
     * @return Whether the selectedNamespaces field is set.
     */
    boolean hasSelectedNamespaces();
    /**
     *
     *
     * <pre>
     * If set, include just the resources in the listed namespaces.
     * </pre>
     *
     * <code>.google.cloud.gkebackup.v1.Namespaces selected_namespaces = 2;</code>
     *
     * @return The selectedNamespaces.
     */
    com.google.cloud.gkebackup.v1.Namespaces getSelectedNamespaces();
    /**
     *
     *
     * <pre>
     * If set, include just the resources in the listed namespaces.
     * </pre>
     *
     * <code>.google.cloud.gkebackup.v1.Namespaces selected_namespaces = 2;</code>
     */
    com.google.cloud.gkebackup.v1.NamespacesOrBuilder getSelectedNamespacesOrBuilder();

    /**
     *
     *
     * <pre>
     * If set, include just the resources referenced by the listed
     * ProtectedApplications.
     * </pre>
     *
     * <code>.google.cloud.gkebackup.v1.NamespacedNames selected_applications = 3;</code>
     *
     * @return Whether the selectedApplications field is set.
     */
    boolean hasSelectedApplications();
    /**
     *
     *
     * <pre>
     * If set, include just the resources referenced by the listed
     * ProtectedApplications.
     * </pre>
     *
     * <code>.google.cloud.gkebackup.v1.NamespacedNames selected_applications = 3;</code>
     *
     * @return The selectedApplications.
     */
    com.google.cloud.gkebackup.v1.NamespacedNames getSelectedApplications();
    /**
     *
     *
     * <pre>
     * If set, include just the resources referenced by the listed
     * ProtectedApplications.
     * </pre>
     *
     * <code>.google.cloud.gkebackup.v1.NamespacedNames selected_applications = 3;</code>
     */
    com.google.cloud.gkebackup.v1.NamespacedNamesOrBuilder getSelectedApplicationsOrBuilder();

    /**
     *
     *
     * <pre>
     * This flag specifies whether volume data should be backed up when
     * PVCs are included in the scope of a Backup.
     *
     * Default: False
     * </pre>
     *
     * <code>bool include_volume_data = 4;</code>
     *
     * @return The includeVolumeData.
     */
    boolean getIncludeVolumeData();

    /**
     *
     *
     * <pre>
     * This flag specifies whether Kubernetes Secret resources should be
     * included when they fall into the scope of Backups.
     *
     * Default: False
     * </pre>
     *
     * <code>bool include_secrets = 5;</code>
     *
     * @return The includeSecrets.
     */
    boolean getIncludeSecrets();

    /**
     *
     *
     * <pre>
     * This defines a customer managed encryption key that will be used to
     * encrypt the "config" portion (the Kubernetes resources) of Backups
     * created via this plan.
     *
     * Default (empty): Config backup artifacts will not be encrypted.
     * </pre>
     *
     * <code>.google.cloud.gkebackup.v1.EncryptionKey encryption_key = 6;</code>
     *
     * @return Whether the encryptionKey field is set.
     */
    boolean hasEncryptionKey();
    /**
     *
     *
     * <pre>
     * This defines a customer managed encryption key that will be used to
     * encrypt the "config" portion (the Kubernetes resources) of Backups
     * created via this plan.
     *
     * Default (empty): Config backup artifacts will not be encrypted.
     * </pre>
     *
     * <code>.google.cloud.gkebackup.v1.EncryptionKey encryption_key = 6;</code>
     *
     * @return The encryptionKey.
     */
    com.google.cloud.gkebackup.v1.EncryptionKey getEncryptionKey();
    /**
     *
     *
     * <pre>
     * This defines a customer managed encryption key that will be used to
     * encrypt the "config" portion (the Kubernetes resources) of Backups
     * created via this plan.
     *
     * Default (empty): Config backup artifacts will not be encrypted.
     * </pre>
     *
     * <code>.google.cloud.gkebackup.v1.EncryptionKey encryption_key = 6;</code>
     */
    com.google.cloud.gkebackup.v1.EncryptionKeyOrBuilder getEncryptionKeyOrBuilder();

    com.google.cloud.gkebackup.v1.BackupPlan.BackupConfig.BackupScopeCase getBackupScopeCase();
  }
  /**
   *
   *
   * <pre>
   * BackupConfig defines the configuration of Backups created via this
   * BackupPlan.
   * </pre>
   *
   * Protobuf type {@code google.cloud.gkebackup.v1.BackupPlan.BackupConfig}
   */
  public static final class BackupConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.gkebackup.v1.BackupPlan.BackupConfig)
      BackupConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use BackupConfig.newBuilder() to construct.
    private BackupConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private BackupConfig() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new BackupConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.gkebackup.v1.BackupPlanProto
          .internal_static_google_cloud_gkebackup_v1_BackupPlan_BackupConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.gkebackup.v1.BackupPlanProto
          .internal_static_google_cloud_gkebackup_v1_BackupPlan_BackupConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.gkebackup.v1.BackupPlan.BackupConfig.class,
              com.google.cloud.gkebackup.v1.BackupPlan.BackupConfig.Builder.class);
    }

    private int backupScopeCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object backupScope_;

    public enum BackupScopeCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      ALL_NAMESPACES(1),
      SELECTED_NAMESPACES(2),
      SELECTED_APPLICATIONS(3),
      BACKUPSCOPE_NOT_SET(0);
      private final int value;

      private BackupScopeCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static BackupScopeCase valueOf(int value) {
        return forNumber(value);
      }

      public static BackupScopeCase forNumber(int value) {
        switch (value) {
          case 1:
            return ALL_NAMESPACES;
          case 2:
            return SELECTED_NAMESPACES;
          case 3:
            return SELECTED_APPLICATIONS;
          case 0:
            return BACKUPSCOPE_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public BackupScopeCase getBackupScopeCase() {
      return BackupScopeCase.forNumber(backupScopeCase_);
    }

    public static final int ALL_NAMESPACES_FIELD_NUMBER = 1;
    /**
     *
     *
     * <pre>
     * If True, include all namespaced resources
     * </pre>
     *
     * <code>bool all_namespaces = 1;</code>
     *
     * @return Whether the allNamespaces field is set.
     */
    @java.lang.Override
    public boolean hasAllNamespaces() {
      return backupScopeCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * If True, include all namespaced resources
     * </pre>
     *
     * <code>bool all_namespaces = 1;</code>
     *
     * @return The allNamespaces.
     */
    @java.lang.Override
    public boolean getAllNamespaces() {
      if (backupScopeCase_ == 1) {
        return (java.lang.Boolean) backupScope_;
      }
      return false;
    }

    public static final int SELECTED_NAMESPACES_FIELD_NUMBER = 2;
    /**
     *
     *
     * <pre>
     * If set, include just the resources in the listed namespaces.
     * </pre>
     *
     * <code>.google.cloud.gkebackup.v1.Namespaces selected_namespaces = 2;</code>
     *
     * @return Whether the selectedNamespaces field is set.
     */
    @java.lang.Override
    public boolean hasSelectedNamespaces() {
      return backupScopeCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * If set, include just the resources in the listed namespaces.
     * </pre>
     *
     * <code>.google.cloud.gkebackup.v1.Namespaces selected_namespaces = 2;</code>
     *
     * @return The selectedNamespaces.
     */
    @java.lang.Override
    public com.google.cloud.gkebackup.v1.Namespaces getSelectedNamespaces() {
      if (backupScopeCase_ == 2) {
        return (com.google.cloud.gkebackup.v1.Namespaces) backupScope_;
      }
      return com.google.cloud.gkebackup.v1.Namespaces.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * If set, include just the resources in the listed namespaces.
     * </pre>
     *
     * <code>.google.cloud.gkebackup.v1.Namespaces selected_namespaces = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.gkebackup.v1.NamespacesOrBuilder getSelectedNamespacesOrBuilder() {
      if (backupScopeCase_ == 2) {
        return (com.google.cloud.gkebackup.v1.Namespaces) backupScope_;
      }
      return com.google.cloud.gkebackup.v1.Namespaces.getDefaultInstance();
    }

    public static final int SELECTED_APPLICATIONS_FIELD_NUMBER = 3;
    /**
     *
     *
     * <pre>
     * If set, include just the resources referenced by the listed
     * ProtectedApplications.
     * </pre>
     *
     * <code>.google.cloud.gkebackup.v1.NamespacedNames selected_applications = 3;</code>
     *
     * @return Whether the selectedApplications field is set.
     */
    @java.lang.Override
    public boolean hasSelectedApplications() {
      return backupScopeCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * If set, include just the resources referenced by the listed
     * ProtectedApplications.
     * </pre>
     *
     * <code>.google.cloud.gkebackup.v1.NamespacedNames selected_applications = 3;</code>
     *
     * @return The selectedApplications.
     */
    @java.lang.Override
    public com.google.cloud.gkebackup.v1.NamespacedNames getSelectedApplications() {
      if (backupScopeCase_ == 3) {
        return (com.google.cloud.gkebackup.v1.NamespacedNames) backupScope_;
      }
      return com.google.cloud.gkebackup.v1.NamespacedNames.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * If set, include just the resources referenced by the listed
     * ProtectedApplications.
     * </pre>
     *
     * <code>.google.cloud.gkebackup.v1.NamespacedNames selected_applications = 3;</code>
     */
    @java.lang.Override
    public com.google.cloud.gkebackup.v1.NamespacedNamesOrBuilder
        getSelectedApplicationsOrBuilder() {
      if (backupScopeCase_ == 3) {
        return (com.google.cloud.gkebackup.v1.NamespacedNames) backupScope_;
      }
      return com.google.cloud.gkebackup.v1.NamespacedNames.getDefaultInstance();
    }

    public static final int INCLUDE_VOLUME_DATA_FIELD_NUMBER = 4;
    private boolean includeVolumeData_ = false;
    /**
     *
     *
     * <pre>
     * This flag specifies whether volume data should be backed up when
     * PVCs are included in the scope of a Backup.
     *
     * Default: False
     * </pre>
     *
     * <code>bool include_volume_data = 4;</code>
     *
     * @return The includeVolumeData.
     */
    @java.lang.Override
    public boolean getIncludeVolumeData() {
      return includeVolumeData_;
    }

    public static final int INCLUDE_SECRETS_FIELD_NUMBER = 5;
    private boolean includeSecrets_ = false;
    /**
     *
     *
     * <pre>
     * This flag specifies whether Kubernetes Secret resources should be
     * included when they fall into the scope of Backups.
     *
     * Default: False
     * </pre>
     *
     * <code>bool include_secrets = 5;</code>
     *
     * @return The includeSecrets.
     */
    @java.lang.Override
    public boolean getIncludeSecrets() {
      return includeSecrets_;
    }

    public static final int ENCRYPTION_KEY_FIELD_NUMBER = 6;
    private com.google.cloud.gkebackup.v1.EncryptionKey encryptionKey_;
    /**
     *
     *
     * <pre>
     * This defines a customer managed encryption key that will be used to
     * encrypt the "config" portion (the Kubernetes resources) of Backups
     * created via this plan.
     *
     * Default (empty): Config backup artifacts will not be encrypted.
     * </pre>
     *
     * <code>.google.cloud.gkebackup.v1.EncryptionKey encryption_key = 6;</code>
     *
     * @return Whether the encryptionKey field is set.
     */
    @java.lang.Override
    public boolean hasEncryptionKey() {
      return encryptionKey_ != null;
    }
    /**
     *
     *
     * <pre>
     * This defines a customer managed encryption key that will be used to
     * encrypt the "config" portion (the Kubernetes resources) of Backups
     * created via this plan.
     *
     * Default (empty): Config backup artifacts will not be encrypted.
     * </pre>
     *
     * <code>.google.cloud.gkebackup.v1.EncryptionKey encryption_key = 6;</code>
     *
     * @return The encryptionKey.
     */
    @java.lang.Override
    public com.google.cloud.gkebackup.v1.EncryptionKey getEncryptionKey() {
      return encryptionKey_ == null
          ? com.google.cloud.gkebackup.v1.EncryptionKey.getDefaultInstance()
          : encryptionKey_;
    }
    /**
     *
     *
     * <pre>
     * This defines a customer managed encryption key that will be used to
     * encrypt the "config" portion (the Kubernetes resources) of Backups
     * created via this plan.
     *
     * Default (empty): Config backup artifacts will not be encrypted.
     * </pre>
     *
     * <code>.google.cloud.gkebackup.v1.EncryptionKey encryption_key = 6;</code>
     */
    @java.lang.Override
    public com.google.cloud.gkebackup.v1.EncryptionKeyOrBuilder getEncryptionKeyOrBuilder() {
      return encryptionKey_ == null
          ? com.google.cloud.gkebackup.v1.EncryptionKey.getDefaultInstance()
          : encryptionKey_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (backupScopeCase_ == 1) {
        output.writeBool(1, (boolean) ((java.lang.Boolean) backupScope_));
      }
      if (backupScopeCase_ == 2) {
        output.writeMessage(2, (com.google.cloud.gkebackup.v1.Namespaces) backupScope_);
      }
      if (backupScopeCase_ == 3) {
        output.writeMessage(3, (com.google.cloud.gkebackup.v1.NamespacedNames) backupScope_);
      }
      if (includeVolumeData_ != false) {
        output.writeBool(4, includeVolumeData_);
      }
      if (includeSecrets_ != false) {
        output.writeBool(5, includeSecrets_);
      }
      if (encryptionKey_ != null) {
        output.writeMessage(6, getEncryptionKey());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (backupScopeCase_ == 1) {
        size +=
            com.google.protobuf.CodedOutputStream.computeBoolSize(
                1, (boolean) ((java.lang.Boolean) backupScope_));
      }
      if (backupScopeCase_ == 2) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                2, (com.google.cloud.gkebackup.v1.Namespaces) backupScope_);
      }
      if (backupScopeCase_ == 3) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                3, (com.google.cloud.gkebackup.v1.NamespacedNames) backupScope_);
      }
      if (includeVolumeData_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, includeVolumeData_);
      }
      if (includeSecrets_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(5, includeSecrets_);
      }
      if (encryptionKey_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getEncryptionKey());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.gkebackup.v1.BackupPlan.BackupConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.gkebackup.v1.BackupPlan.BackupConfig other =
          (com.google.cloud.gkebackup.v1.BackupPlan.BackupConfig) obj;

      if (getIncludeVolumeData() != other.getIncludeVolumeData()) return false;
      if (getIncludeSecrets() != other.getIncludeSecrets()) return false;
      if (hasEncryptionKey() != other.hasEncryptionKey()) return false;
      if (hasEncryptionKey()) {
        if (!getEncryptionKey().equals(other.getEncryptionKey())) return false;
      }
      if (!getBackupScopeCase().equals(other.getBackupScopeCase())) return false;
      switch (backupScopeCase_) {
        case 1:
          if (getAllNamespaces() != other.getAllNamespaces()) return false;
          break;
        case 2:
          if (!getSelectedNamespaces().equals(other.getSelectedNamespaces())) return false;
          break;
        case 3:
          if (!getSelectedApplications().equals(other.getSelectedApplications())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + INCLUDE_VOLUME_DATA_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIncludeVolumeData());
      hash = (37 * hash) + INCLUDE_SECRETS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIncludeSecrets());
      if (hasEncryptionKey()) {
        hash = (37 * hash) + ENCRYPTION_KEY_FIELD_NUMBER;
        hash = (53 * hash) + getEncryptionKey().hashCode();
      }
      switch (backupScopeCase_) {
        case 1:
          hash = (37 * hash) + ALL_NAMESPACES_FIELD_NUMBER;
          hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAllNamespaces());
          break;
        case 2:
          hash = (37 * hash) + SELECTED_NAMESPACES_FIELD_NUMBER;
          hash = (53 * hash) + getSelectedNamespaces().hashCode();
          break;
        case 3:
          hash = (37 * hash) + SELECTED_APPLICATIONS_FIELD_NUMBER;
          hash = (53 * hash) + getSelectedApplications().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.gkebackup.v1.BackupPlan.BackupConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.gkebackup.v1.BackupPlan.BackupConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.gkebackup.v1.BackupPlan.BackupConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.gkebackup.v1.BackupPlan.BackupConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.gkebackup.v1.BackupPlan.BackupConfig parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.gkebackup.v1.BackupPlan.BackupConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.gkebackup.v1.BackupPlan.BackupConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.gkebackup.v1.BackupPlan.BackupConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.gkebackup.v1.BackupPlan.BackupConfig parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.gkebackup.v1.BackupPlan.BackupConfig parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.gkebackup.v1.BackupPlan.BackupConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.gkebackup.v1.BackupPlan.BackupConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.gkebackup.v1.BackupPlan.BackupConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * BackupConfig defines the configuration of Backups created via this
     * BackupPlan.
     * </pre>
     *
     * Protobuf type {@code google.cloud.gkebackup.v1.BackupPlan.BackupConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.gkebackup.v1.BackupPlan.BackupConfig)
        com.google.cloud.gkebackup.v1.BackupPlan.BackupConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.gkebackup.v1.BackupPlanProto
            .internal_static_google_cloud_gkebackup_v1_BackupPlan_BackupConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.gkebackup.v1.BackupPlanProto
            .internal_static_google_cloud_gkebackup_v1_BackupPlan_BackupConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.gkebackup.v1.BackupPlan.BackupConfig.class,
                com.google.cloud.gkebackup.v1.BackupPlan.BackupConfig.Builder.class);
      }

      // Construct using com.google.cloud.gkebackup.v1.BackupPlan.BackupConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (selectedNamespacesBuilder_ != null) {
          selectedNamespacesBuilder_.clear();
        }
        if (selectedApplicationsBuilder_ != null) {
          selectedApplicationsBuilder_.clear();
        }
        includeVolumeData_ = false;
        includeSecrets_ = false;
        encryptionKey_ = null;
        if (encryptionKeyBuilder_ != null) {
          encryptionKeyBuilder_.dispose();
          encryptionKeyBuilder_ = null;
        }
        backupScopeCase_ = 0;
        backupScope_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.gkebackup.v1.BackupPlanProto
            .internal_static_google_cloud_gkebackup_v1_BackupPlan_BackupConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.gkebackup.v1.BackupPlan.BackupConfig getDefaultInstanceForType() {
        return com.google.cloud.gkebackup.v1.BackupPlan.BackupConfig.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.gkebackup.v1.BackupPlan.BackupConfig build() {
        com.google.cloud.gkebackup.v1.BackupPlan.BackupConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.gkebackup.v1.BackupPlan.BackupConfig buildPartial() {
        com.google.cloud.gkebackup.v1.BackupPlan.BackupConfig result =
            new com.google.cloud.gkebackup.v1.BackupPlan.BackupConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.gkebackup.v1.BackupPlan.BackupConfig result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.includeVolumeData_ = includeVolumeData_;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.includeSecrets_ = includeSecrets_;
        }
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.encryptionKey_ =
              encryptionKeyBuilder_ == null ? encryptionKey_ : encryptionKeyBuilder_.build();
        }
      }

      private void buildPartialOneofs(
          com.google.cloud.gkebackup.v1.BackupPlan.BackupConfig result) {
        result.backupScopeCase_ = backupScopeCase_;
        result.backupScope_ = this.backupScope_;
        if (backupScopeCase_ == 2 && selectedNamespacesBuilder_ != null) {
          result.backupScope_ = selectedNamespacesBuilder_.build();
        }
        if (backupScopeCase_ == 3 && selectedApplicationsBuilder_ != null) {
          result.backupScope_ = selectedApplicationsBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.gkebackup.v1.BackupPlan.BackupConfig) {
          return mergeFrom((com.google.cloud.gkebackup.v1.BackupPlan.BackupConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.gkebackup.v1.BackupPlan.BackupConfig other) {
        if (other == com.google.cloud.gkebackup.v1.BackupPlan.BackupConfig.getDefaultInstance())
          return this;
        if (other.getIncludeVolumeData() != false) {
          setIncludeVolumeData(other.getIncludeVolumeData());
        }
        if (other.getIncludeSecrets() != false) {
          setIncludeSecrets(other.getIncludeSecrets());
        }
        if (other.hasEncryptionKey()) {
          mergeEncryptionKey(other.getEncryptionKey());
        }
        switch (other.getBackupScopeCase()) {
          case ALL_NAMESPACES:
            {
              setAllNamespaces(other.getAllNamespaces());
              break;
            }
          case SELECTED_NAMESPACES:
            {
              mergeSelectedNamespaces(other.getSelectedNamespaces());
              break;
            }
          case SELECTED_APPLICATIONS:
            {
              mergeSelectedApplications(other.getSelectedApplications());
              break;
            }
          case BACKUPSCOPE_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  backupScope_ = input.readBool();
                  backupScopeCase_ = 1;
                  break;
                } // case 8
              case 18:
                {
                  input.readMessage(
                      getSelectedNamespacesFieldBuilder().getBuilder(), extensionRegistry);
                  backupScopeCase_ = 2;
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(
                      getSelectedApplicationsFieldBuilder().getBuilder(), extensionRegistry);
                  backupScopeCase_ = 3;
                  break;
                } // case 26
              case 32:
                {
                  includeVolumeData_ = input.readBool();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 32
              case 40:
                {
                  includeSecrets_ = input.readBool();
                  bitField0_ |= 0x00000010;
                  break;
                } // case 40
              case 50:
                {
                  input.readMessage(getEncryptionKeyFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000020;
                  break;
                } // case 50
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int backupScopeCase_ = 0;
      private java.lang.Object backupScope_;

      public BackupScopeCase getBackupScopeCase() {
        return BackupScopeCase.forNumber(backupScopeCase_);
      }

      public Builder clearBackupScope() {
        backupScopeCase_ = 0;
        backupScope_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      /**
       *
       *
       * <pre>
       * If True, include all namespaced resources
       * </pre>
       *
       * <code>bool all_namespaces = 1;</code>
       *
       * @return Whether the allNamespaces field is set.
       */
      public boolean hasAllNamespaces() {
        return backupScopeCase_ == 1;
      }
      /**
       *
       *
       * <pre>
       * If True, include all namespaced resources
       * </pre>
       *
       * <code>bool all_namespaces = 1;</code>
       *
       * @return The allNamespaces.
       */
      public boolean getAllNamespaces() {
        if (backupScopeCase_ == 1) {
          return (java.lang.Boolean) backupScope_;
        }
        return false;
      }
      /**
       *
       *
       * <pre>
       * If True, include all namespaced resources
       * </pre>
       *
       * <code>bool all_namespaces = 1;</code>
       *
       * @param value The allNamespaces to set.
       * @return This builder for chaining.
       */
      public Builder setAllNamespaces(boolean value) {

        backupScopeCase_ = 1;
        backupScope_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If True, include all namespaced resources
       * </pre>
       *
       * <code>bool all_namespaces = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAllNamespaces() {
        if (backupScopeCase_ == 1) {
          backupScopeCase_ = 0;
          backupScope_ = null;
          onChanged();
        }
        return this;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.gkebackup.v1.Namespaces,
              com.google.cloud.gkebackup.v1.Namespaces.Builder,
              com.google.cloud.gkebackup.v1.NamespacesOrBuilder>
          selectedNamespacesBuilder_;
      /**
       *
       *
       * <pre>
       * If set, include just the resources in the listed namespaces.
       * </pre>
       *
       * <code>.google.cloud.gkebackup.v1.Namespaces selected_namespaces = 2;</code>
       *
       * @return Whether the selectedNamespaces field is set.
       */
      @java.lang.Override
      public boolean hasSelectedNamespaces() {
        return backupScopeCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * If set, include just the resources in the listed namespaces.
       * </pre>
       *
       * <code>.google.cloud.gkebackup.v1.Namespaces selected_namespaces = 2;</code>
       *
       * @return The selectedNamespaces.
       */
      @java.lang.Override
      public com.google.cloud.gkebackup.v1.Namespaces getSelectedNamespaces() {
        if (selectedNamespacesBuilder_ == null) {
          if (backupScopeCase_ == 2) {
            return (com.google.cloud.gkebackup.v1.Namespaces) backupScope_;
          }
          return com.google.cloud.gkebackup.v1.Namespaces.getDefaultInstance();
        } else {
          if (backupScopeCase_ == 2) {
            return selectedNamespacesBuilder_.getMessage();
          }
          return com.google.cloud.gkebackup.v1.Namespaces.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * If set, include just the resources in the listed namespaces.
       * </pre>
       *
       * <code>.google.cloud.gkebackup.v1.Namespaces selected_namespaces = 2;</code>
       */
      public Builder setSelectedNamespaces(com.google.cloud.gkebackup.v1.Namespaces value) {
        if (selectedNamespacesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          backupScope_ = value;
          onChanged();
        } else {
          selectedNamespacesBuilder_.setMessage(value);
        }
        backupScopeCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * If set, include just the resources in the listed namespaces.
       * </pre>
       *
       * <code>.google.cloud.gkebackup.v1.Namespaces selected_namespaces = 2;</code>
       */
      public Builder setSelectedNamespaces(
          com.google.cloud.gkebackup.v1.Namespaces.Builder builderForValue) {
        if (selectedNamespacesBuilder_ == null) {
          backupScope_ = builderForValue.build();
          onChanged();
        } else {
          selectedNamespacesBuilder_.setMessage(builderForValue.build());
        }
        backupScopeCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * If set, include just the resources in the listed namespaces.
       * </pre>
       *
       * <code>.google.cloud.gkebackup.v1.Namespaces selected_namespaces = 2;</code>
       */
      public Builder mergeSelectedNamespaces(com.google.cloud.gkebackup.v1.Namespaces value) {
        if (selectedNamespacesBuilder_ == null) {
          if (backupScopeCase_ == 2
              && backupScope_ != com.google.cloud.gkebackup.v1.Namespaces.getDefaultInstance()) {
            backupScope_ =
                com.google.cloud.gkebackup.v1.Namespaces.newBuilder(
                        (com.google.cloud.gkebackup.v1.Namespaces) backupScope_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            backupScope_ = value;
          }
          onChanged();
        } else {
          if (backupScopeCase_ == 2) {
            selectedNamespacesBuilder_.mergeFrom(value);
          } else {
            selectedNamespacesBuilder_.setMessage(value);
          }
        }
        backupScopeCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * If set, include just the resources in the listed namespaces.
       * </pre>
       *
       * <code>.google.cloud.gkebackup.v1.Namespaces selected_namespaces = 2;</code>
       */
      public Builder clearSelectedNamespaces() {
        if (selectedNamespacesBuilder_ == null) {
          if (backupScopeCase_ == 2) {
            backupScopeCase_ = 0;
            backupScope_ = null;
            onChanged();
          }
        } else {
          if (backupScopeCase_ == 2) {
            backupScopeCase_ = 0;
            backupScope_ = null;
          }
          selectedNamespacesBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * If set, include just the resources in the listed namespaces.
       * </pre>
       *
       * <code>.google.cloud.gkebackup.v1.Namespaces selected_namespaces = 2;</code>
       */
      public com.google.cloud.gkebackup.v1.Namespaces.Builder getSelectedNamespacesBuilder() {
        return getSelectedNamespacesFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * If set, include just the resources in the listed namespaces.
       * </pre>
       *
       * <code>.google.cloud.gkebackup.v1.Namespaces selected_namespaces = 2;</code>
       */
      @java.lang.Override
      public com.google.cloud.gkebackup.v1.NamespacesOrBuilder getSelectedNamespacesOrBuilder() {
        if ((backupScopeCase_ == 2) && (selectedNamespacesBuilder_ != null)) {
          return selectedNamespacesBuilder_.getMessageOrBuilder();
        } else {
          if (backupScopeCase_ == 2) {
            return (com.google.cloud.gkebackup.v1.Namespaces) backupScope_;
          }
          return com.google.cloud.gkebackup.v1.Namespaces.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * If set, include just the resources in the listed namespaces.
       * </pre>
       *
       * <code>.google.cloud.gkebackup.v1.Namespaces selected_namespaces = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.gkebackup.v1.Namespaces,
              com.google.cloud.gkebackup.v1.Namespaces.Builder,
              com.google.cloud.gkebackup.v1.NamespacesOrBuilder>
          getSelectedNamespacesFieldBuilder() {
        if (selectedNamespacesBuilder_ == null) {
          if (!(backupScopeCase_ == 2)) {
            backupScope_ = com.google.cloud.gkebackup.v1.Namespaces.getDefaultInstance();
          }
          selectedNamespacesBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.gkebackup.v1.Namespaces,
                  com.google.cloud.gkebackup.v1.Namespaces.Builder,
                  com.google.cloud.gkebackup.v1.NamespacesOrBuilder>(
                  (com.google.cloud.gkebackup.v1.Namespaces) backupScope_,
                  getParentForChildren(),
                  isClean());
          backupScope_ = null;
        }
        backupScopeCase_ = 2;
        onChanged();
        return selectedNamespacesBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.gkebackup.v1.NamespacedNames,
              com.google.cloud.gkebackup.v1.NamespacedNames.Builder,
              com.google.cloud.gkebackup.v1.NamespacedNamesOrBuilder>
          selectedApplicationsBuilder_;
      /**
       *
       *
       * <pre>
       * If set, include just the resources referenced by the listed
       * ProtectedApplications.
       * </pre>
       *
       * <code>.google.cloud.gkebackup.v1.NamespacedNames selected_applications = 3;</code>
       *
       * @return Whether the selectedApplications field is set.
       */
      @java.lang.Override
      public boolean hasSelectedApplications() {
        return backupScopeCase_ == 3;
      }
      /**
       *
       *
       * <pre>
       * If set, include just the resources referenced by the listed
       * ProtectedApplications.
       * </pre>
       *
       * <code>.google.cloud.gkebackup.v1.NamespacedNames selected_applications = 3;</code>
       *
       * @return The selectedApplications.
       */
      @java.lang.Override
      public com.google.cloud.gkebackup.v1.NamespacedNames getSelectedApplications() {
        if (selectedApplicationsBuilder_ == null) {
          if (backupScopeCase_ == 3) {
            return (com.google.cloud.gkebackup.v1.NamespacedNames) backupScope_;
          }
          return com.google.cloud.gkebackup.v1.NamespacedNames.getDefaultInstance();
        } else {
          if (backupScopeCase_ == 3) {
            return selectedApplicationsBuilder_.getMessage();
          }
          return com.google.cloud.gkebackup.v1.NamespacedNames.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * If set, include just the resources referenced by the listed
       * ProtectedApplications.
       * </pre>
       *
       * <code>.google.cloud.gkebackup.v1.NamespacedNames selected_applications = 3;</code>
       */
      public Builder setSelectedApplications(com.google.cloud.gkebackup.v1.NamespacedNames value) {
        if (selectedApplicationsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          backupScope_ = value;
          onChanged();
        } else {
          selectedApplicationsBuilder_.setMessage(value);
        }
        backupScopeCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * If set, include just the resources referenced by the listed
       * ProtectedApplications.
       * </pre>
       *
       * <code>.google.cloud.gkebackup.v1.NamespacedNames selected_applications = 3;</code>
       */
      public Builder setSelectedApplications(
          com.google.cloud.gkebackup.v1.NamespacedNames.Builder builderForValue) {
        if (selectedApplicationsBuilder_ == null) {
          backupScope_ = builderForValue.build();
          onChanged();
        } else {
          selectedApplicationsBuilder_.setMessage(builderForValue.build());
        }
        backupScopeCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * If set, include just the resources referenced by the listed
       * ProtectedApplications.
       * </pre>
       *
       * <code>.google.cloud.gkebackup.v1.NamespacedNames selected_applications = 3;</code>
       */
      public Builder mergeSelectedApplications(
          com.google.cloud.gkebackup.v1.NamespacedNames value) {
        if (selectedApplicationsBuilder_ == null) {
          if (backupScopeCase_ == 3
              && backupScope_
                  != com.google.cloud.gkebackup.v1.NamespacedNames.getDefaultInstance()) {
            backupScope_ =
                com.google.cloud.gkebackup.v1.NamespacedNames.newBuilder(
                        (com.google.cloud.gkebackup.v1.NamespacedNames) backupScope_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            backupScope_ = value;
          }
          onChanged();
        } else {
          if (backupScopeCase_ == 3) {
            selectedApplicationsBuilder_.mergeFrom(value);
          } else {
            selectedApplicationsBuilder_.setMessage(value);
          }
        }
        backupScopeCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * If set, include just the resources referenced by the listed
       * ProtectedApplications.
       * </pre>
       *
       * <code>.google.cloud.gkebackup.v1.NamespacedNames selected_applications = 3;</code>
       */
      public Builder clearSelectedApplications() {
        if (selectedApplicationsBuilder_ == null) {
          if (backupScopeCase_ == 3) {
            backupScopeCase_ = 0;
            backupScope_ = null;
            onChanged();
          }
        } else {
          if (backupScopeCase_ == 3) {
            backupScopeCase_ = 0;
            backupScope_ = null;
          }
          selectedApplicationsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * If set, include just the resources referenced by the listed
       * ProtectedApplications.
       * </pre>
       *
       * <code>.google.cloud.gkebackup.v1.NamespacedNames selected_applications = 3;</code>
       */
      public com.google.cloud.gkebackup.v1.NamespacedNames.Builder
          getSelectedApplicationsBuilder() {
        return getSelectedApplicationsFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * If set, include just the resources referenced by the listed
       * ProtectedApplications.
       * </pre>
       *
       * <code>.google.cloud.gkebackup.v1.NamespacedNames selected_applications = 3;</code>
       */
      @java.lang.Override
      public com.google.cloud.gkebackup.v1.NamespacedNamesOrBuilder
          getSelectedApplicationsOrBuilder() {
        if ((backupScopeCase_ == 3) && (selectedApplicationsBuilder_ != null)) {
          return selectedApplicationsBuilder_.getMessageOrBuilder();
        } else {
          if (backupScopeCase_ == 3) {
            return (com.google.cloud.gkebackup.v1.NamespacedNames) backupScope_;
          }
          return com.google.cloud.gkebackup.v1.NamespacedNames.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * If set, include just the resources referenced by the listed
       * ProtectedApplications.
       * </pre>
       *
       * <code>.google.cloud.gkebackup.v1.NamespacedNames selected_applications = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.gkebackup.v1.NamespacedNames,
              com.google.cloud.gkebackup.v1.NamespacedNames.Builder,
              com.google.cloud.gkebackup.v1.NamespacedNamesOrBuilder>
          getSelectedApplicationsFieldBuilder() {
        if (selectedApplicationsBuilder_ == null) {
          if (!(backupScopeCase_ == 3)) {
            backupScope_ = com.google.cloud.gkebackup.v1.NamespacedNames.getDefaultInstance();
          }
          selectedApplicationsBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.gkebackup.v1.NamespacedNames,
                  com.google.cloud.gkebackup.v1.NamespacedNames.Builder,
                  com.google.cloud.gkebackup.v1.NamespacedNamesOrBuilder>(
                  (com.google.cloud.gkebackup.v1.NamespacedNames) backupScope_,
                  getParentForChildren(),
                  isClean());
          backupScope_ = null;
        }
        backupScopeCase_ = 3;
        onChanged();
        return selectedApplicationsBuilder_;
      }

      private boolean includeVolumeData_;
      /**
       *
       *
       * <pre>
       * This flag specifies whether volume data should be backed up when
       * PVCs are included in the scope of a Backup.
       *
       * Default: False
       * </pre>
       *
       * <code>bool include_volume_data = 4;</code>
       *
       * @return The includeVolumeData.
       */
      @java.lang.Override
      public boolean getIncludeVolumeData() {
        return includeVolumeData_;
      }
      /**
       *
       *
       * <pre>
       * This flag specifies whether volume data should be backed up when
       * PVCs are included in the scope of a Backup.
       *
       * Default: False
       * </pre>
       *
       * <code>bool include_volume_data = 4;</code>
       *
       * @param value The includeVolumeData to set.
       * @return This builder for chaining.
       */
      public Builder setIncludeVolumeData(boolean value) {

        includeVolumeData_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * This flag specifies whether volume data should be backed up when
       * PVCs are included in the scope of a Backup.
       *
       * Default: False
       * </pre>
       *
       * <code>bool include_volume_data = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearIncludeVolumeData() {
        bitField0_ = (bitField0_ & ~0x00000008);
        includeVolumeData_ = false;
        onChanged();
        return this;
      }

      private boolean includeSecrets_;
      /**
       *
       *
       * <pre>
       * This flag specifies whether Kubernetes Secret resources should be
       * included when they fall into the scope of Backups.
       *
       * Default: False
       * </pre>
       *
       * <code>bool include_secrets = 5;</code>
       *
       * @return The includeSecrets.
       */
      @java.lang.Override
      public boolean getIncludeSecrets() {
        return includeSecrets_;
      }
      /**
       *
       *
       * <pre>
       * This flag specifies whether Kubernetes Secret resources should be
       * included when they fall into the scope of Backups.
       *
       * Default: False
       * </pre>
       *
       * <code>bool include_secrets = 5;</code>
       *
       * @param value The includeSecrets to set.
       * @return This builder for chaining.
       */
      public Builder setIncludeSecrets(boolean value) {

        includeSecrets_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * This flag specifies whether Kubernetes Secret resources should be
       * included when they fall into the scope of Backups.
       *
       * Default: False
       * </pre>
       *
       * <code>bool include_secrets = 5;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearIncludeSecrets() {
        bitField0_ = (bitField0_ & ~0x00000010);
        includeSecrets_ = false;
        onChanged();
        return this;
      }

      private com.google.cloud.gkebackup.v1.EncryptionKey encryptionKey_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.gkebackup.v1.EncryptionKey,
              com.google.cloud.gkebackup.v1.EncryptionKey.Builder,
              com.google.cloud.gkebackup.v1.EncryptionKeyOrBuilder>
          encryptionKeyBuilder_;
      /**
       *
       *
       * <pre>
       * This defines a customer managed encryption key that will be used to
       * encrypt the "config" portion (the Kubernetes resources) of Backups
       * created via this plan.
       *
       * Default (empty): Config backup artifacts will not be encrypted.
       * </pre>
       *
       * <code>.google.cloud.gkebackup.v1.EncryptionKey encryption_key = 6;</code>
       *
       * @return Whether the encryptionKey field is set.
       */
      public boolean hasEncryptionKey() {
        return ((bitField0_ & 0x00000020) != 0);
      }
      /**
       *
       *
       * <pre>
       * This defines a customer managed encryption key that will be used to
       * encrypt the "config" portion (the Kubernetes resources) of Backups
       * created via this plan.
       *
       * Default (empty): Config backup artifacts will not be encrypted.
       * </pre>
       *
       * <code>.google.cloud.gkebackup.v1.EncryptionKey encryption_key = 6;</code>
       *
       * @return The encryptionKey.
       */
      public com.google.cloud.gkebackup.v1.EncryptionKey getEncryptionKey() {
        if (encryptionKeyBuilder_ == null) {
          return encryptionKey_ == null
              ? com.google.cloud.gkebackup.v1.EncryptionKey.getDefaultInstance()
              : encryptionKey_;
        } else {
          return encryptionKeyBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * This defines a customer managed encryption key that will be used to
       * encrypt the "config" portion (the Kubernetes resources) of Backups
       * created via this plan.
       *
       * Default (empty): Config backup artifacts will not be encrypted.
       * </pre>
       *
       * <code>.google.cloud.gkebackup.v1.EncryptionKey encryption_key = 6;</code>
       */
      public Builder setEncryptionKey(com.google.cloud.gkebackup.v1.EncryptionKey value) {
        if (encryptionKeyBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          encryptionKey_ = value;
        } else {
          encryptionKeyBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * This defines a customer managed encryption key that will be used to
       * encrypt the "config" portion (the Kubernetes resources) of Backups
       * created via this plan.
       *
       * Default (empty): Config backup artifacts will not be encrypted.
       * </pre>
       *
       * <code>.google.cloud.gkebackup.v1.EncryptionKey encryption_key = 6;</code>
       */
      public Builder setEncryptionKey(
          com.google.cloud.gkebackup.v1.EncryptionKey.Builder builderForValue) {
        if (encryptionKeyBuilder_ == null) {
          encryptionKey_ = builderForValue.build();
        } else {
          encryptionKeyBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * This defines a customer managed encryption key that will be used to
       * encrypt the "config" portion (the Kubernetes resources) of Backups
       * created via this plan.
       *
       * Default (empty): Config backup artifacts will not be encrypted.
       * </pre>
       *
       * <code>.google.cloud.gkebackup.v1.EncryptionKey encryption_key = 6;</code>
       */
      public Builder mergeEncryptionKey(com.google.cloud.gkebackup.v1.EncryptionKey value) {
        if (encryptionKeyBuilder_ == null) {
          if (((bitField0_ & 0x00000020) != 0)
              && encryptionKey_ != null
              && encryptionKey_
                  != com.google.cloud.gkebackup.v1.EncryptionKey.getDefaultInstance()) {
            getEncryptionKeyBuilder().mergeFrom(value);
          } else {
            encryptionKey_ = value;
          }
        } else {
          encryptionKeyBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * This defines a customer managed encryption key that will be used to
       * encrypt the "config" portion (the Kubernetes resources) of Backups
       * created via this plan.
       *
       * Default (empty): Config backup artifacts will not be encrypted.
       * </pre>
       *
       * <code>.google.cloud.gkebackup.v1.EncryptionKey encryption_key = 6;</code>
       */
      public Builder clearEncryptionKey() {
        bitField0_ = (bitField0_ & ~0x00000020);
        encryptionKey_ = null;
        if (encryptionKeyBuilder_ != null) {
          encryptionKeyBuilder_.dispose();
          encryptionKeyBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * This defines a customer managed encryption key that will be used to
       * encrypt the "config" portion (the Kubernetes resources) of Backups
       * created via this plan.
       *
       * Default (empty): Config backup artifacts will not be encrypted.
       * </pre>
       *
       * <code>.google.cloud.gkebackup.v1.EncryptionKey encryption_key = 6;</code>
       */
      public com.google.cloud.gkebackup.v1.EncryptionKey.Builder getEncryptionKeyBuilder() {
        bitField0_ |= 0x00000020;
        onChanged();
        return getEncryptionKeyFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * This defines a customer managed encryption key that will be used to
       * encrypt the "config" portion (the Kubernetes resources) of Backups
       * created via this plan.
       *
       * Default (empty): Config backup artifacts will not be encrypted.
       * </pre>
       *
       * <code>.google.cloud.gkebackup.v1.EncryptionKey encryption_key = 6;</code>
       */
      public com.google.cloud.gkebackup.v1.EncryptionKeyOrBuilder getEncryptionKeyOrBuilder() {
        if (encryptionKeyBuilder_ != null) {
          return encryptionKeyBuilder_.getMessageOrBuilder();
        } else {
          return encryptionKey_ == null
              ? com.google.cloud.gkebackup.v1.EncryptionKey.getDefaultInstance()
              : encryptionKey_;
        }
      }
      /**
       *
       *
       * <pre>
       * This defines a customer managed encryption key that will be used to
       * encrypt the "config" portion (the Kubernetes resources) of Backups
       * created via this plan.
       *
       * Default (empty): Config backup artifacts will not be encrypted.
       * </pre>
       *
       * <code>.google.cloud.gkebackup.v1.EncryptionKey encryption_key = 6;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.gkebackup.v1.EncryptionKey,
              com.google.cloud.gkebackup.v1.EncryptionKey.Builder,
              com.google.cloud.gkebackup.v1.EncryptionKeyOrBuilder>
          getEncryptionKeyFieldBuilder() {
        if (encryptionKeyBuilder_ == null) {
          encryptionKeyBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.gkebackup.v1.EncryptionKey,
                  com.google.cloud.gkebackup.v1.EncryptionKey.Builder,
                  com.google.cloud.gkebackup.v1.EncryptionKeyOrBuilder>(
                  getEncryptionKey(), getParentForChildren(), isClean());
          encryptionKey_ = null;
        }
        return encryptionKeyBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.gkebackup.v1.BackupPlan.BackupConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.gkebackup.v1.BackupPlan.BackupConfig)
    private static final com.google.cloud.gkebackup.v1.BackupPlan.BackupConfig DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.gkebackup.v1.BackupPlan.BackupConfig();
    }

    public static com.google.cloud.gkebackup.v1.BackupPlan.BackupConfig getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<BackupConfig> PARSER =
        new com.google.protobuf.AbstractParser<BackupConfig>() {
          @java.lang.Override
          public BackupConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<BackupConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<BackupConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.gkebackup.v1.BackupPlan.BackupConfig getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The full name of the BackupPlan resource.
   * Format: `projects/&#42;&#47;locations/&#42;&#47;backupPlans/&#42;`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The full name of the BackupPlan resource.
   * Format: `projects/&#42;&#47;locations/&#42;&#47;backupPlans/&#42;`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int UID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object uid_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Server generated global unique identifier of
   * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier) format.
   * </pre>
   *
   * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The uid.
   */
  @java.lang.Override
  public java.lang.String getUid() {
    java.lang.Object ref = uid_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      uid_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Server generated global unique identifier of
   * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier) format.
   * </pre>
   *
   * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for uid.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUidBytes() {
    java.lang.Object ref = uid_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      uid_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when this BackupPlan resource was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when this BackupPlan resource was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when this BackupPlan resource was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when this BackupPlan resource was last
   * updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when this BackupPlan resource was last
   * updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when this BackupPlan resource was last
   * updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * User specified descriptive string for this BackupPlan.
   * </pre>
   *
   * <code>string description = 5;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * User specified descriptive string for this BackupPlan.
   * </pre>
   *
   * <code>string description = 5;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CLUSTER_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object cluster_ = "";
  /**
   *
   *
   * <pre>
   * Required. Immutable. The source cluster from which Backups will be created
   * via this BackupPlan. Valid formats:
   *
   * - `projects/&#42;&#47;locations/&#42;&#47;clusters/&#42;`
   * - `projects/&#42;&#47;zones/&#42;&#47;clusters/&#42;`
   * </pre>
   *
   * <code>
   * string cluster = 6 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The cluster.
   */
  @java.lang.Override
  public java.lang.String getCluster() {
    java.lang.Object ref = cluster_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      cluster_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Immutable. The source cluster from which Backups will be created
   * via this BackupPlan. Valid formats:
   *
   * - `projects/&#42;&#47;locations/&#42;&#47;clusters/&#42;`
   * - `projects/&#42;&#47;zones/&#42;&#47;clusters/&#42;`
   * </pre>
   *
   * <code>
   * string cluster = 6 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for cluster.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getClusterBytes() {
    java.lang.Object ref = cluster_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      cluster_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RETENTION_POLICY_FIELD_NUMBER = 7;
  private com.google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy retentionPolicy_;
  /**
   *
   *
   * <pre>
   * RetentionPolicy governs lifecycle of Backups created under this plan.
   * </pre>
   *
   * <code>.google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy retention_policy = 7;</code>
   *
   * @return Whether the retentionPolicy field is set.
   */
  @java.lang.Override
  public boolean hasRetentionPolicy() {
    return retentionPolicy_ != null;
  }
  /**
   *
   *
   * <pre>
   * RetentionPolicy governs lifecycle of Backups created under this plan.
   * </pre>
   *
   * <code>.google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy retention_policy = 7;</code>
   *
   * @return The retentionPolicy.
   */
  @java.lang.Override
  public com.google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy getRetentionPolicy() {
    return retentionPolicy_ == null
        ? com.google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy.getDefaultInstance()
        : retentionPolicy_;
  }
  /**
   *
   *
   * <pre>
   * RetentionPolicy governs lifecycle of Backups created under this plan.
   * </pre>
   *
   * <code>.google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy retention_policy = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.gkebackup.v1.BackupPlan.RetentionPolicyOrBuilder
      getRetentionPolicyOrBuilder() {
    return retentionPolicy_ == null
        ? com.google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy.getDefaultInstance()
        : retentionPolicy_;
  }

  public static final int LABELS_FIELD_NUMBER = 8;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.gkebackup.v1.BackupPlanProto
                .internal_static_google_cloud_gkebackup_v1_BackupPlan_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * A set of custom labels supplied by user.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 8;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * A set of custom labels supplied by user.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 8;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * A set of custom labels supplied by user.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 8;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * A set of custom labels supplied by user.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 8;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int BACKUP_SCHEDULE_FIELD_NUMBER = 9;
  private com.google.cloud.gkebackup.v1.BackupPlan.Schedule backupSchedule_;
  /**
   *
   *
   * <pre>
   * Defines a schedule for automatic Backup creation via this BackupPlan.
   * </pre>
   *
   * <code>.google.cloud.gkebackup.v1.BackupPlan.Schedule backup_schedule = 9;</code>
   *
   * @return Whether the backupSchedule field is set.
   */
  @java.lang.Override
  public boolean hasBackupSchedule() {
    return backupSchedule_ != null;
  }
  /**
   *
   *
   * <pre>
   * Defines a schedule for automatic Backup creation via this BackupPlan.
   * </pre>
   *
   * <code>.google.cloud.gkebackup.v1.BackupPlan.Schedule backup_schedule = 9;</code>
   *
   * @return The backupSchedule.
   */
  @java.lang.Override
  public com.google.cloud.gkebackup.v1.BackupPlan.Schedule getBackupSchedule() {
    return backupSchedule_ == null
        ? com.google.cloud.gkebackup.v1.BackupPlan.Schedule.getDefaultInstance()
        : backupSchedule_;
  }
  /**
   *
   *
   * <pre>
   * Defines a schedule for automatic Backup creation via this BackupPlan.
   * </pre>
   *
   * <code>.google.cloud.gkebackup.v1.BackupPlan.Schedule backup_schedule = 9;</code>
   */
  @java.lang.Override
  public com.google.cloud.gkebackup.v1.BackupPlan.ScheduleOrBuilder getBackupScheduleOrBuilder() {
    return backupSchedule_ == null
        ? com.google.cloud.gkebackup.v1.BackupPlan.Schedule.getDefaultInstance()
        : backupSchedule_;
  }

  public static final int ETAG_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private volatile java.lang.Object etag_ = "";
  /**
   *
   *
   * <pre>
   * Output only. `etag` is used for optimistic concurrency control as a way to
   * help prevent simultaneous updates of a backup plan from overwriting each
   * other. It is strongly suggested that systems make use of the 'etag' in the
   * read-modify-write cycle to perform BackupPlan updates in order to avoid
   * race conditions: An `etag` is returned in the response to `GetBackupPlan`,
   * and systems are expected to put that etag in the request to
   * `UpdateBackupPlan` or `DeleteBackupPlan` to ensure that their change
   * will be applied to the same version of the resource.
   * </pre>
   *
   * <code>string etag = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The etag.
   */
  @java.lang.Override
  public java.lang.String getEtag() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      etag_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. `etag` is used for optimistic concurrency control as a way to
   * help prevent simultaneous updates of a backup plan from overwriting each
   * other. It is strongly suggested that systems make use of the 'etag' in the
   * read-modify-write cycle to perform BackupPlan updates in order to avoid
   * race conditions: An `etag` is returned in the response to `GetBackupPlan`,
   * and systems are expected to put that etag in the request to
   * `UpdateBackupPlan` or `DeleteBackupPlan` to ensure that their change
   * will be applied to the same version of the resource.
   * </pre>
   *
   * <code>string etag = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for etag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEtagBytes() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      etag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DEACTIVATED_FIELD_NUMBER = 11;
  private boolean deactivated_ = false;
  /**
   *
   *
   * <pre>
   * This flag indicates whether this BackupPlan has been deactivated.
   * Setting this field to True locks the BackupPlan such that no further
   * updates will be allowed (except deletes), including the deactivated field
   * itself. It also prevents any new Backups from being created via this
   * BackupPlan (including scheduled Backups).
   *
   * Default: False
   * </pre>
   *
   * <code>bool deactivated = 11;</code>
   *
   * @return The deactivated.
   */
  @java.lang.Override
  public boolean getDeactivated() {
    return deactivated_;
  }

  public static final int BACKUP_CONFIG_FIELD_NUMBER = 12;
  private com.google.cloud.gkebackup.v1.BackupPlan.BackupConfig backupConfig_;
  /**
   *
   *
   * <pre>
   * Defines the configuration of Backups created via this BackupPlan.
   * </pre>
   *
   * <code>.google.cloud.gkebackup.v1.BackupPlan.BackupConfig backup_config = 12;</code>
   *
   * @return Whether the backupConfig field is set.
   */
  @java.lang.Override
  public boolean hasBackupConfig() {
    return backupConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Defines the configuration of Backups created via this BackupPlan.
   * </pre>
   *
   * <code>.google.cloud.gkebackup.v1.BackupPlan.BackupConfig backup_config = 12;</code>
   *
   * @return The backupConfig.
   */
  @java.lang.Override
  public com.google.cloud.gkebackup.v1.BackupPlan.BackupConfig getBackupConfig() {
    return backupConfig_ == null
        ? com.google.cloud.gkebackup.v1.BackupPlan.BackupConfig.getDefaultInstance()
        : backupConfig_;
  }
  /**
   *
   *
   * <pre>
   * Defines the configuration of Backups created via this BackupPlan.
   * </pre>
   *
   * <code>.google.cloud.gkebackup.v1.BackupPlan.BackupConfig backup_config = 12;</code>
   */
  @java.lang.Override
  public com.google.cloud.gkebackup.v1.BackupPlan.BackupConfigOrBuilder getBackupConfigOrBuilder() {
    return backupConfig_ == null
        ? com.google.cloud.gkebackup.v1.BackupPlan.BackupConfig.getDefaultInstance()
        : backupConfig_;
  }

  public static final int PROTECTED_POD_COUNT_FIELD_NUMBER = 13;
  private int protectedPodCount_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The number of Kubernetes Pods backed up in the
   * last successful Backup created via this BackupPlan.
   * </pre>
   *
   * <code>int32 protected_pod_count = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The protectedPodCount.
   */
  @java.lang.Override
  public int getProtectedPodCount() {
    return protectedPodCount_;
  }

  public static final int STATE_FIELD_NUMBER = 14;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. State of the BackupPlan. This State field reflects the
   * various stages a BackupPlan can be in
   * during the Create operation. It will be set to "DEACTIVATED"
   * if the BackupPlan is deactivated on an Update
   * </pre>
   *
   * <code>
   * .google.cloud.gkebackup.v1.BackupPlan.State state = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. State of the BackupPlan. This State field reflects the
   * various stages a BackupPlan can be in
   * during the Create operation. It will be set to "DEACTIVATED"
   * if the BackupPlan is deactivated on an Update
   * </pre>
   *
   * <code>
   * .google.cloud.gkebackup.v1.BackupPlan.State state = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.gkebackup.v1.BackupPlan.State getState() {
    com.google.cloud.gkebackup.v1.BackupPlan.State result =
        com.google.cloud.gkebackup.v1.BackupPlan.State.forNumber(state_);
    return result == null ? com.google.cloud.gkebackup.v1.BackupPlan.State.UNRECOGNIZED : result;
  }

  public static final int STATE_REASON_FIELD_NUMBER = 15;

  @SuppressWarnings("serial")
  private volatile java.lang.Object stateReason_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Human-readable description of why BackupPlan is in the current
   * `state`
   * </pre>
   *
   * <code>string state_reason = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The stateReason.
   */
  @java.lang.Override
  public java.lang.String getStateReason() {
    java.lang.Object ref = stateReason_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      stateReason_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Human-readable description of why BackupPlan is in the current
   * `state`
   * </pre>
   *
   * <code>string state_reason = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for stateReason.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStateReasonBytes() {
    java.lang.Object ref = stateReason_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      stateReason_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uid_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, uid_);
    }
    if (createTime_ != null) {
      output.writeMessage(3, getCreateTime());
    }
    if (updateTime_ != null) {
      output.writeMessage(4, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, description_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cluster_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, cluster_);
    }
    if (retentionPolicy_ != null) {
      output.writeMessage(7, getRetentionPolicy());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 8);
    if (backupSchedule_ != null) {
      output.writeMessage(9, getBackupSchedule());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, etag_);
    }
    if (deactivated_ != false) {
      output.writeBool(11, deactivated_);
    }
    if (backupConfig_ != null) {
      output.writeMessage(12, getBackupConfig());
    }
    if (protectedPodCount_ != 0) {
      output.writeInt32(13, protectedPodCount_);
    }
    if (state_ != com.google.cloud.gkebackup.v1.BackupPlan.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(14, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(stateReason_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 15, stateReason_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uid_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, uid_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getCreateTime());
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, description_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cluster_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, cluster_);
    }
    if (retentionPolicy_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getRetentionPolicy());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, labels__);
    }
    if (backupSchedule_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getBackupSchedule());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, etag_);
    }
    if (deactivated_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(11, deactivated_);
    }
    if (backupConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, getBackupConfig());
    }
    if (protectedPodCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(13, protectedPodCount_);
    }
    if (state_ != com.google.cloud.gkebackup.v1.BackupPlan.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(14, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(stateReason_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(15, stateReason_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.gkebackup.v1.BackupPlan)) {
      return super.equals(obj);
    }
    com.google.cloud.gkebackup.v1.BackupPlan other = (com.google.cloud.gkebackup.v1.BackupPlan) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getUid().equals(other.getUid())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!getDescription().equals(other.getDescription())) return false;
    if (!getCluster().equals(other.getCluster())) return false;
    if (hasRetentionPolicy() != other.hasRetentionPolicy()) return false;
    if (hasRetentionPolicy()) {
      if (!getRetentionPolicy().equals(other.getRetentionPolicy())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (hasBackupSchedule() != other.hasBackupSchedule()) return false;
    if (hasBackupSchedule()) {
      if (!getBackupSchedule().equals(other.getBackupSchedule())) return false;
    }
    if (!getEtag().equals(other.getEtag())) return false;
    if (getDeactivated() != other.getDeactivated()) return false;
    if (hasBackupConfig() != other.hasBackupConfig()) return false;
    if (hasBackupConfig()) {
      if (!getBackupConfig().equals(other.getBackupConfig())) return false;
    }
    if (getProtectedPodCount() != other.getProtectedPodCount()) return false;
    if (state_ != other.state_) return false;
    if (!getStateReason().equals(other.getStateReason())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + UID_FIELD_NUMBER;
    hash = (53 * hash) + getUid().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + CLUSTER_FIELD_NUMBER;
    hash = (53 * hash) + getCluster().hashCode();
    if (hasRetentionPolicy()) {
      hash = (37 * hash) + RETENTION_POLICY_FIELD_NUMBER;
      hash = (53 * hash) + getRetentionPolicy().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (hasBackupSchedule()) {
      hash = (37 * hash) + BACKUP_SCHEDULE_FIELD_NUMBER;
      hash = (53 * hash) + getBackupSchedule().hashCode();
    }
    hash = (37 * hash) + ETAG_FIELD_NUMBER;
    hash = (53 * hash) + getEtag().hashCode();
    hash = (37 * hash) + DEACTIVATED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDeactivated());
    if (hasBackupConfig()) {
      hash = (37 * hash) + BACKUP_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getBackupConfig().hashCode();
    }
    hash = (37 * hash) + PROTECTED_POD_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getProtectedPodCount();
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (37 * hash) + STATE_REASON_FIELD_NUMBER;
    hash = (53 * hash) + getStateReason().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.gkebackup.v1.BackupPlan parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gkebackup.v1.BackupPlan parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gkebackup.v1.BackupPlan parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gkebackup.v1.BackupPlan parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gkebackup.v1.BackupPlan parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gkebackup.v1.BackupPlan parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gkebackup.v1.BackupPlan parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.gkebackup.v1.BackupPlan parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.gkebackup.v1.BackupPlan parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.gkebackup.v1.BackupPlan parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.gkebackup.v1.BackupPlan parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.gkebackup.v1.BackupPlan parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.gkebackup.v1.BackupPlan prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Defines the configuration and scheduling for a "line" of Backups.
   * </pre>
   *
   * Protobuf type {@code google.cloud.gkebackup.v1.BackupPlan}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.gkebackup.v1.BackupPlan)
      com.google.cloud.gkebackup.v1.BackupPlanOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.gkebackup.v1.BackupPlanProto
          .internal_static_google_cloud_gkebackup_v1_BackupPlan_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 8:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 8:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.gkebackup.v1.BackupPlanProto
          .internal_static_google_cloud_gkebackup_v1_BackupPlan_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.gkebackup.v1.BackupPlan.class,
              com.google.cloud.gkebackup.v1.BackupPlan.Builder.class);
    }

    // Construct using com.google.cloud.gkebackup.v1.BackupPlan.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      uid_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      description_ = "";
      cluster_ = "";
      retentionPolicy_ = null;
      if (retentionPolicyBuilder_ != null) {
        retentionPolicyBuilder_.dispose();
        retentionPolicyBuilder_ = null;
      }
      internalGetMutableLabels().clear();
      backupSchedule_ = null;
      if (backupScheduleBuilder_ != null) {
        backupScheduleBuilder_.dispose();
        backupScheduleBuilder_ = null;
      }
      etag_ = "";
      deactivated_ = false;
      backupConfig_ = null;
      if (backupConfigBuilder_ != null) {
        backupConfigBuilder_.dispose();
        backupConfigBuilder_ = null;
      }
      protectedPodCount_ = 0;
      state_ = 0;
      stateReason_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.gkebackup.v1.BackupPlanProto
          .internal_static_google_cloud_gkebackup_v1_BackupPlan_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.gkebackup.v1.BackupPlan getDefaultInstanceForType() {
      return com.google.cloud.gkebackup.v1.BackupPlan.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.gkebackup.v1.BackupPlan build() {
      com.google.cloud.gkebackup.v1.BackupPlan result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.gkebackup.v1.BackupPlan buildPartial() {
      com.google.cloud.gkebackup.v1.BackupPlan result =
          new com.google.cloud.gkebackup.v1.BackupPlan(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.gkebackup.v1.BackupPlan result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.uid_ = uid_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.cluster_ = cluster_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.retentionPolicy_ =
            retentionPolicyBuilder_ == null ? retentionPolicy_ : retentionPolicyBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.backupSchedule_ =
            backupScheduleBuilder_ == null ? backupSchedule_ : backupScheduleBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.etag_ = etag_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.deactivated_ = deactivated_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.backupConfig_ =
            backupConfigBuilder_ == null ? backupConfig_ : backupConfigBuilder_.build();
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.protectedPodCount_ = protectedPodCount_;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.stateReason_ = stateReason_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.gkebackup.v1.BackupPlan) {
        return mergeFrom((com.google.cloud.gkebackup.v1.BackupPlan) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.gkebackup.v1.BackupPlan other) {
      if (other == com.google.cloud.gkebackup.v1.BackupPlan.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getUid().isEmpty()) {
        uid_ = other.uid_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.getCluster().isEmpty()) {
        cluster_ = other.cluster_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.hasRetentionPolicy()) {
        mergeRetentionPolicy(other.getRetentionPolicy());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000080;
      if (other.hasBackupSchedule()) {
        mergeBackupSchedule(other.getBackupSchedule());
      }
      if (!other.getEtag().isEmpty()) {
        etag_ = other.etag_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (other.getDeactivated() != false) {
        setDeactivated(other.getDeactivated());
      }
      if (other.hasBackupConfig()) {
        mergeBackupConfig(other.getBackupConfig());
      }
      if (other.getProtectedPodCount() != 0) {
        setProtectedPodCount(other.getProtectedPodCount());
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (!other.getStateReason().isEmpty()) {
        stateReason_ = other.stateReason_;
        bitField0_ |= 0x00004000;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                uid_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                cluster_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getRetentionPolicyFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(getBackupScheduleFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 74
            case 82:
              {
                etag_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 82
            case 88:
              {
                deactivated_ = input.readBool();
                bitField0_ |= 0x00000400;
                break;
              } // case 88
            case 98:
              {
                input.readMessage(getBackupConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000800;
                break;
              } // case 98
            case 104:
              {
                protectedPodCount_ = input.readInt32();
                bitField0_ |= 0x00001000;
                break;
              } // case 104
            case 112:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00002000;
                break;
              } // case 112
            case 122:
              {
                stateReason_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00004000;
                break;
              } // case 122
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The full name of the BackupPlan resource.
     * Format: `projects/&#42;&#47;locations/&#42;&#47;backupPlans/&#42;`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The full name of the BackupPlan resource.
     * Format: `projects/&#42;&#47;locations/&#42;&#47;backupPlans/&#42;`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The full name of the BackupPlan resource.
     * Format: `projects/&#42;&#47;locations/&#42;&#47;backupPlans/&#42;`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The full name of the BackupPlan resource.
     * Format: `projects/&#42;&#47;locations/&#42;&#47;backupPlans/&#42;`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The full name of the BackupPlan resource.
     * Format: `projects/&#42;&#47;locations/&#42;&#47;backupPlans/&#42;`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object uid_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Server generated global unique identifier of
     * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier) format.
     * </pre>
     *
     * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The uid.
     */
    public java.lang.String getUid() {
      java.lang.Object ref = uid_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uid_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Server generated global unique identifier of
     * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier) format.
     * </pre>
     *
     * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for uid.
     */
    public com.google.protobuf.ByteString getUidBytes() {
      java.lang.Object ref = uid_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        uid_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Server generated global unique identifier of
     * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier) format.
     * </pre>
     *
     * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The uid to set.
     * @return This builder for chaining.
     */
    public Builder setUid(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      uid_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Server generated global unique identifier of
     * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier) format.
     * </pre>
     *
     * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUid() {
      uid_ = getDefaultInstance().getUid();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Server generated global unique identifier of
     * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier) format.
     * </pre>
     *
     * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for uid to set.
     * @return This builder for chaining.
     */
    public Builder setUidBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      uid_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this BackupPlan resource was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this BackupPlan resource was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this BackupPlan resource was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this BackupPlan resource was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this BackupPlan resource was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this BackupPlan resource was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this BackupPlan resource was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this BackupPlan resource was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this BackupPlan resource was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this BackupPlan resource was last
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this BackupPlan resource was last
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this BackupPlan resource was last
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this BackupPlan resource was last
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this BackupPlan resource was last
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this BackupPlan resource was last
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this BackupPlan resource was last
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this BackupPlan resource was last
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this BackupPlan resource was last
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * User specified descriptive string for this BackupPlan.
     * </pre>
     *
     * <code>string description = 5;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * User specified descriptive string for this BackupPlan.
     * </pre>
     *
     * <code>string description = 5;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * User specified descriptive string for this BackupPlan.
     * </pre>
     *
     * <code>string description = 5;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User specified descriptive string for this BackupPlan.
     * </pre>
     *
     * <code>string description = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User specified descriptive string for this BackupPlan.
     * </pre>
     *
     * <code>string description = 5;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object cluster_ = "";
    /**
     *
     *
     * <pre>
     * Required. Immutable. The source cluster from which Backups will be created
     * via this BackupPlan. Valid formats:
     *
     * - `projects/&#42;&#47;locations/&#42;&#47;clusters/&#42;`
     * - `projects/&#42;&#47;zones/&#42;&#47;clusters/&#42;`
     * </pre>
     *
     * <code>
     * string cluster = 6 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The cluster.
     */
    public java.lang.String getCluster() {
      java.lang.Object ref = cluster_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        cluster_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The source cluster from which Backups will be created
     * via this BackupPlan. Valid formats:
     *
     * - `projects/&#42;&#47;locations/&#42;&#47;clusters/&#42;`
     * - `projects/&#42;&#47;zones/&#42;&#47;clusters/&#42;`
     * </pre>
     *
     * <code>
     * string cluster = 6 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for cluster.
     */
    public com.google.protobuf.ByteString getClusterBytes() {
      java.lang.Object ref = cluster_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        cluster_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The source cluster from which Backups will be created
     * via this BackupPlan. Valid formats:
     *
     * - `projects/&#42;&#47;locations/&#42;&#47;clusters/&#42;`
     * - `projects/&#42;&#47;zones/&#42;&#47;clusters/&#42;`
     * </pre>
     *
     * <code>
     * string cluster = 6 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The cluster to set.
     * @return This builder for chaining.
     */
    public Builder setCluster(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      cluster_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The source cluster from which Backups will be created
     * via this BackupPlan. Valid formats:
     *
     * - `projects/&#42;&#47;locations/&#42;&#47;clusters/&#42;`
     * - `projects/&#42;&#47;zones/&#42;&#47;clusters/&#42;`
     * </pre>
     *
     * <code>
     * string cluster = 6 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCluster() {
      cluster_ = getDefaultInstance().getCluster();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The source cluster from which Backups will be created
     * via this BackupPlan. Valid formats:
     *
     * - `projects/&#42;&#47;locations/&#42;&#47;clusters/&#42;`
     * - `projects/&#42;&#47;zones/&#42;&#47;clusters/&#42;`
     * </pre>
     *
     * <code>
     * string cluster = 6 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for cluster to set.
     * @return This builder for chaining.
     */
    public Builder setClusterBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      cluster_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private com.google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy retentionPolicy_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy,
            com.google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy.Builder,
            com.google.cloud.gkebackup.v1.BackupPlan.RetentionPolicyOrBuilder>
        retentionPolicyBuilder_;
    /**
     *
     *
     * <pre>
     * RetentionPolicy governs lifecycle of Backups created under this plan.
     * </pre>
     *
     * <code>.google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy retention_policy = 7;</code>
     *
     * @return Whether the retentionPolicy field is set.
     */
    public boolean hasRetentionPolicy() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * RetentionPolicy governs lifecycle of Backups created under this plan.
     * </pre>
     *
     * <code>.google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy retention_policy = 7;</code>
     *
     * @return The retentionPolicy.
     */
    public com.google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy getRetentionPolicy() {
      if (retentionPolicyBuilder_ == null) {
        return retentionPolicy_ == null
            ? com.google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy.getDefaultInstance()
            : retentionPolicy_;
      } else {
        return retentionPolicyBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * RetentionPolicy governs lifecycle of Backups created under this plan.
     * </pre>
     *
     * <code>.google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy retention_policy = 7;</code>
     */
    public Builder setRetentionPolicy(
        com.google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy value) {
      if (retentionPolicyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        retentionPolicy_ = value;
      } else {
        retentionPolicyBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * RetentionPolicy governs lifecycle of Backups created under this plan.
     * </pre>
     *
     * <code>.google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy retention_policy = 7;</code>
     */
    public Builder setRetentionPolicy(
        com.google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy.Builder builderForValue) {
      if (retentionPolicyBuilder_ == null) {
        retentionPolicy_ = builderForValue.build();
      } else {
        retentionPolicyBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * RetentionPolicy governs lifecycle of Backups created under this plan.
     * </pre>
     *
     * <code>.google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy retention_policy = 7;</code>
     */
    public Builder mergeRetentionPolicy(
        com.google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy value) {
      if (retentionPolicyBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && retentionPolicy_ != null
            && retentionPolicy_
                != com.google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy.getDefaultInstance()) {
          getRetentionPolicyBuilder().mergeFrom(value);
        } else {
          retentionPolicy_ = value;
        }
      } else {
        retentionPolicyBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * RetentionPolicy governs lifecycle of Backups created under this plan.
     * </pre>
     *
     * <code>.google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy retention_policy = 7;</code>
     */
    public Builder clearRetentionPolicy() {
      bitField0_ = (bitField0_ & ~0x00000040);
      retentionPolicy_ = null;
      if (retentionPolicyBuilder_ != null) {
        retentionPolicyBuilder_.dispose();
        retentionPolicyBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * RetentionPolicy governs lifecycle of Backups created under this plan.
     * </pre>
     *
     * <code>.google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy retention_policy = 7;</code>
     */
    public com.google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy.Builder
        getRetentionPolicyBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getRetentionPolicyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * RetentionPolicy governs lifecycle of Backups created under this plan.
     * </pre>
     *
     * <code>.google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy retention_policy = 7;</code>
     */
    public com.google.cloud.gkebackup.v1.BackupPlan.RetentionPolicyOrBuilder
        getRetentionPolicyOrBuilder() {
      if (retentionPolicyBuilder_ != null) {
        return retentionPolicyBuilder_.getMessageOrBuilder();
      } else {
        return retentionPolicy_ == null
            ? com.google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy.getDefaultInstance()
            : retentionPolicy_;
      }
    }
    /**
     *
     *
     * <pre>
     * RetentionPolicy governs lifecycle of Backups created under this plan.
     * </pre>
     *
     * <code>.google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy retention_policy = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy,
            com.google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy.Builder,
            com.google.cloud.gkebackup.v1.BackupPlan.RetentionPolicyOrBuilder>
        getRetentionPolicyFieldBuilder() {
      if (retentionPolicyBuilder_ == null) {
        retentionPolicyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy,
                com.google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy.Builder,
                com.google.cloud.gkebackup.v1.BackupPlan.RetentionPolicyOrBuilder>(
                getRetentionPolicy(), getParentForChildren(), isClean());
        retentionPolicy_ = null;
      }
      return retentionPolicyBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * A set of custom labels supplied by user.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 8;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * A set of custom labels supplied by user.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 8;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * A set of custom labels supplied by user.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 8;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * A set of custom labels supplied by user.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 8;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000080);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A set of custom labels supplied by user.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 8;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000080;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * A set of custom labels supplied by user.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 8;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000080;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A set of custom labels supplied by user.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 8;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000080;
      return this;
    }

    private com.google.cloud.gkebackup.v1.BackupPlan.Schedule backupSchedule_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gkebackup.v1.BackupPlan.Schedule,
            com.google.cloud.gkebackup.v1.BackupPlan.Schedule.Builder,
            com.google.cloud.gkebackup.v1.BackupPlan.ScheduleOrBuilder>
        backupScheduleBuilder_;
    /**
     *
     *
     * <pre>
     * Defines a schedule for automatic Backup creation via this BackupPlan.
     * </pre>
     *
     * <code>.google.cloud.gkebackup.v1.BackupPlan.Schedule backup_schedule = 9;</code>
     *
     * @return Whether the backupSchedule field is set.
     */
    public boolean hasBackupSchedule() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Defines a schedule for automatic Backup creation via this BackupPlan.
     * </pre>
     *
     * <code>.google.cloud.gkebackup.v1.BackupPlan.Schedule backup_schedule = 9;</code>
     *
     * @return The backupSchedule.
     */
    public com.google.cloud.gkebackup.v1.BackupPlan.Schedule getBackupSchedule() {
      if (backupScheduleBuilder_ == null) {
        return backupSchedule_ == null
            ? com.google.cloud.gkebackup.v1.BackupPlan.Schedule.getDefaultInstance()
            : backupSchedule_;
      } else {
        return backupScheduleBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Defines a schedule for automatic Backup creation via this BackupPlan.
     * </pre>
     *
     * <code>.google.cloud.gkebackup.v1.BackupPlan.Schedule backup_schedule = 9;</code>
     */
    public Builder setBackupSchedule(com.google.cloud.gkebackup.v1.BackupPlan.Schedule value) {
      if (backupScheduleBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        backupSchedule_ = value;
      } else {
        backupScheduleBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines a schedule for automatic Backup creation via this BackupPlan.
     * </pre>
     *
     * <code>.google.cloud.gkebackup.v1.BackupPlan.Schedule backup_schedule = 9;</code>
     */
    public Builder setBackupSchedule(
        com.google.cloud.gkebackup.v1.BackupPlan.Schedule.Builder builderForValue) {
      if (backupScheduleBuilder_ == null) {
        backupSchedule_ = builderForValue.build();
      } else {
        backupScheduleBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines a schedule for automatic Backup creation via this BackupPlan.
     * </pre>
     *
     * <code>.google.cloud.gkebackup.v1.BackupPlan.Schedule backup_schedule = 9;</code>
     */
    public Builder mergeBackupSchedule(com.google.cloud.gkebackup.v1.BackupPlan.Schedule value) {
      if (backupScheduleBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && backupSchedule_ != null
            && backupSchedule_
                != com.google.cloud.gkebackup.v1.BackupPlan.Schedule.getDefaultInstance()) {
          getBackupScheduleBuilder().mergeFrom(value);
        } else {
          backupSchedule_ = value;
        }
      } else {
        backupScheduleBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines a schedule for automatic Backup creation via this BackupPlan.
     * </pre>
     *
     * <code>.google.cloud.gkebackup.v1.BackupPlan.Schedule backup_schedule = 9;</code>
     */
    public Builder clearBackupSchedule() {
      bitField0_ = (bitField0_ & ~0x00000100);
      backupSchedule_ = null;
      if (backupScheduleBuilder_ != null) {
        backupScheduleBuilder_.dispose();
        backupScheduleBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines a schedule for automatic Backup creation via this BackupPlan.
     * </pre>
     *
     * <code>.google.cloud.gkebackup.v1.BackupPlan.Schedule backup_schedule = 9;</code>
     */
    public com.google.cloud.gkebackup.v1.BackupPlan.Schedule.Builder getBackupScheduleBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getBackupScheduleFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Defines a schedule for automatic Backup creation via this BackupPlan.
     * </pre>
     *
     * <code>.google.cloud.gkebackup.v1.BackupPlan.Schedule backup_schedule = 9;</code>
     */
    public com.google.cloud.gkebackup.v1.BackupPlan.ScheduleOrBuilder getBackupScheduleOrBuilder() {
      if (backupScheduleBuilder_ != null) {
        return backupScheduleBuilder_.getMessageOrBuilder();
      } else {
        return backupSchedule_ == null
            ? com.google.cloud.gkebackup.v1.BackupPlan.Schedule.getDefaultInstance()
            : backupSchedule_;
      }
    }
    /**
     *
     *
     * <pre>
     * Defines a schedule for automatic Backup creation via this BackupPlan.
     * </pre>
     *
     * <code>.google.cloud.gkebackup.v1.BackupPlan.Schedule backup_schedule = 9;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gkebackup.v1.BackupPlan.Schedule,
            com.google.cloud.gkebackup.v1.BackupPlan.Schedule.Builder,
            com.google.cloud.gkebackup.v1.BackupPlan.ScheduleOrBuilder>
        getBackupScheduleFieldBuilder() {
      if (backupScheduleBuilder_ == null) {
        backupScheduleBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.gkebackup.v1.BackupPlan.Schedule,
                com.google.cloud.gkebackup.v1.BackupPlan.Schedule.Builder,
                com.google.cloud.gkebackup.v1.BackupPlan.ScheduleOrBuilder>(
                getBackupSchedule(), getParentForChildren(), isClean());
        backupSchedule_ = null;
      }
      return backupScheduleBuilder_;
    }

    private java.lang.Object etag_ = "";
    /**
     *
     *
     * <pre>
     * Output only. `etag` is used for optimistic concurrency control as a way to
     * help prevent simultaneous updates of a backup plan from overwriting each
     * other. It is strongly suggested that systems make use of the 'etag' in the
     * read-modify-write cycle to perform BackupPlan updates in order to avoid
     * race conditions: An `etag` is returned in the response to `GetBackupPlan`,
     * and systems are expected to put that etag in the request to
     * `UpdateBackupPlan` or `DeleteBackupPlan` to ensure that their change
     * will be applied to the same version of the resource.
     * </pre>
     *
     * <code>string etag = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The etag.
     */
    public java.lang.String getEtag() {
      java.lang.Object ref = etag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        etag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. `etag` is used for optimistic concurrency control as a way to
     * help prevent simultaneous updates of a backup plan from overwriting each
     * other. It is strongly suggested that systems make use of the 'etag' in the
     * read-modify-write cycle to perform BackupPlan updates in order to avoid
     * race conditions: An `etag` is returned in the response to `GetBackupPlan`,
     * and systems are expected to put that etag in the request to
     * `UpdateBackupPlan` or `DeleteBackupPlan` to ensure that their change
     * will be applied to the same version of the resource.
     * </pre>
     *
     * <code>string etag = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for etag.
     */
    public com.google.protobuf.ByteString getEtagBytes() {
      java.lang.Object ref = etag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        etag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. `etag` is used for optimistic concurrency control as a way to
     * help prevent simultaneous updates of a backup plan from overwriting each
     * other. It is strongly suggested that systems make use of the 'etag' in the
     * read-modify-write cycle to perform BackupPlan updates in order to avoid
     * race conditions: An `etag` is returned in the response to `GetBackupPlan`,
     * and systems are expected to put that etag in the request to
     * `UpdateBackupPlan` or `DeleteBackupPlan` to ensure that their change
     * will be applied to the same version of the resource.
     * </pre>
     *
     * <code>string etag = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      etag_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. `etag` is used for optimistic concurrency control as a way to
     * help prevent simultaneous updates of a backup plan from overwriting each
     * other. It is strongly suggested that systems make use of the 'etag' in the
     * read-modify-write cycle to perform BackupPlan updates in order to avoid
     * race conditions: An `etag` is returned in the response to `GetBackupPlan`,
     * and systems are expected to put that etag in the request to
     * `UpdateBackupPlan` or `DeleteBackupPlan` to ensure that their change
     * will be applied to the same version of the resource.
     * </pre>
     *
     * <code>string etag = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEtag() {
      etag_ = getDefaultInstance().getEtag();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. `etag` is used for optimistic concurrency control as a way to
     * help prevent simultaneous updates of a backup plan from overwriting each
     * other. It is strongly suggested that systems make use of the 'etag' in the
     * read-modify-write cycle to perform BackupPlan updates in order to avoid
     * race conditions: An `etag` is returned in the response to `GetBackupPlan`,
     * and systems are expected to put that etag in the request to
     * `UpdateBackupPlan` or `DeleteBackupPlan` to ensure that their change
     * will be applied to the same version of the resource.
     * </pre>
     *
     * <code>string etag = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      etag_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private boolean deactivated_;
    /**
     *
     *
     * <pre>
     * This flag indicates whether this BackupPlan has been deactivated.
     * Setting this field to True locks the BackupPlan such that no further
     * updates will be allowed (except deletes), including the deactivated field
     * itself. It also prevents any new Backups from being created via this
     * BackupPlan (including scheduled Backups).
     *
     * Default: False
     * </pre>
     *
     * <code>bool deactivated = 11;</code>
     *
     * @return The deactivated.
     */
    @java.lang.Override
    public boolean getDeactivated() {
      return deactivated_;
    }
    /**
     *
     *
     * <pre>
     * This flag indicates whether this BackupPlan has been deactivated.
     * Setting this field to True locks the BackupPlan such that no further
     * updates will be allowed (except deletes), including the deactivated field
     * itself. It also prevents any new Backups from being created via this
     * BackupPlan (including scheduled Backups).
     *
     * Default: False
     * </pre>
     *
     * <code>bool deactivated = 11;</code>
     *
     * @param value The deactivated to set.
     * @return This builder for chaining.
     */
    public Builder setDeactivated(boolean value) {

      deactivated_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This flag indicates whether this BackupPlan has been deactivated.
     * Setting this field to True locks the BackupPlan such that no further
     * updates will be allowed (except deletes), including the deactivated field
     * itself. It also prevents any new Backups from being created via this
     * BackupPlan (including scheduled Backups).
     *
     * Default: False
     * </pre>
     *
     * <code>bool deactivated = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDeactivated() {
      bitField0_ = (bitField0_ & ~0x00000400);
      deactivated_ = false;
      onChanged();
      return this;
    }

    private com.google.cloud.gkebackup.v1.BackupPlan.BackupConfig backupConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gkebackup.v1.BackupPlan.BackupConfig,
            com.google.cloud.gkebackup.v1.BackupPlan.BackupConfig.Builder,
            com.google.cloud.gkebackup.v1.BackupPlan.BackupConfigOrBuilder>
        backupConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Defines the configuration of Backups created via this BackupPlan.
     * </pre>
     *
     * <code>.google.cloud.gkebackup.v1.BackupPlan.BackupConfig backup_config = 12;</code>
     *
     * @return Whether the backupConfig field is set.
     */
    public boolean hasBackupConfig() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     *
     *
     * <pre>
     * Defines the configuration of Backups created via this BackupPlan.
     * </pre>
     *
     * <code>.google.cloud.gkebackup.v1.BackupPlan.BackupConfig backup_config = 12;</code>
     *
     * @return The backupConfig.
     */
    public com.google.cloud.gkebackup.v1.BackupPlan.BackupConfig getBackupConfig() {
      if (backupConfigBuilder_ == null) {
        return backupConfig_ == null
            ? com.google.cloud.gkebackup.v1.BackupPlan.BackupConfig.getDefaultInstance()
            : backupConfig_;
      } else {
        return backupConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Defines the configuration of Backups created via this BackupPlan.
     * </pre>
     *
     * <code>.google.cloud.gkebackup.v1.BackupPlan.BackupConfig backup_config = 12;</code>
     */
    public Builder setBackupConfig(com.google.cloud.gkebackup.v1.BackupPlan.BackupConfig value) {
      if (backupConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        backupConfig_ = value;
      } else {
        backupConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the configuration of Backups created via this BackupPlan.
     * </pre>
     *
     * <code>.google.cloud.gkebackup.v1.BackupPlan.BackupConfig backup_config = 12;</code>
     */
    public Builder setBackupConfig(
        com.google.cloud.gkebackup.v1.BackupPlan.BackupConfig.Builder builderForValue) {
      if (backupConfigBuilder_ == null) {
        backupConfig_ = builderForValue.build();
      } else {
        backupConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the configuration of Backups created via this BackupPlan.
     * </pre>
     *
     * <code>.google.cloud.gkebackup.v1.BackupPlan.BackupConfig backup_config = 12;</code>
     */
    public Builder mergeBackupConfig(com.google.cloud.gkebackup.v1.BackupPlan.BackupConfig value) {
      if (backupConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)
            && backupConfig_ != null
            && backupConfig_
                != com.google.cloud.gkebackup.v1.BackupPlan.BackupConfig.getDefaultInstance()) {
          getBackupConfigBuilder().mergeFrom(value);
        } else {
          backupConfig_ = value;
        }
      } else {
        backupConfigBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the configuration of Backups created via this BackupPlan.
     * </pre>
     *
     * <code>.google.cloud.gkebackup.v1.BackupPlan.BackupConfig backup_config = 12;</code>
     */
    public Builder clearBackupConfig() {
      bitField0_ = (bitField0_ & ~0x00000800);
      backupConfig_ = null;
      if (backupConfigBuilder_ != null) {
        backupConfigBuilder_.dispose();
        backupConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the configuration of Backups created via this BackupPlan.
     * </pre>
     *
     * <code>.google.cloud.gkebackup.v1.BackupPlan.BackupConfig backup_config = 12;</code>
     */
    public com.google.cloud.gkebackup.v1.BackupPlan.BackupConfig.Builder getBackupConfigBuilder() {
      bitField0_ |= 0x00000800;
      onChanged();
      return getBackupConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Defines the configuration of Backups created via this BackupPlan.
     * </pre>
     *
     * <code>.google.cloud.gkebackup.v1.BackupPlan.BackupConfig backup_config = 12;</code>
     */
    public com.google.cloud.gkebackup.v1.BackupPlan.BackupConfigOrBuilder
        getBackupConfigOrBuilder() {
      if (backupConfigBuilder_ != null) {
        return backupConfigBuilder_.getMessageOrBuilder();
      } else {
        return backupConfig_ == null
            ? com.google.cloud.gkebackup.v1.BackupPlan.BackupConfig.getDefaultInstance()
            : backupConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Defines the configuration of Backups created via this BackupPlan.
     * </pre>
     *
     * <code>.google.cloud.gkebackup.v1.BackupPlan.BackupConfig backup_config = 12;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gkebackup.v1.BackupPlan.BackupConfig,
            com.google.cloud.gkebackup.v1.BackupPlan.BackupConfig.Builder,
            com.google.cloud.gkebackup.v1.BackupPlan.BackupConfigOrBuilder>
        getBackupConfigFieldBuilder() {
      if (backupConfigBuilder_ == null) {
        backupConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.gkebackup.v1.BackupPlan.BackupConfig,
                com.google.cloud.gkebackup.v1.BackupPlan.BackupConfig.Builder,
                com.google.cloud.gkebackup.v1.BackupPlan.BackupConfigOrBuilder>(
                getBackupConfig(), getParentForChildren(), isClean());
        backupConfig_ = null;
      }
      return backupConfigBuilder_;
    }

    private int protectedPodCount_;
    /**
     *
     *
     * <pre>
     * Output only. The number of Kubernetes Pods backed up in the
     * last successful Backup created via this BackupPlan.
     * </pre>
     *
     * <code>int32 protected_pod_count = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The protectedPodCount.
     */
    @java.lang.Override
    public int getProtectedPodCount() {
      return protectedPodCount_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The number of Kubernetes Pods backed up in the
     * last successful Backup created via this BackupPlan.
     * </pre>
     *
     * <code>int32 protected_pod_count = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The protectedPodCount to set.
     * @return This builder for chaining.
     */
    public Builder setProtectedPodCount(int value) {

      protectedPodCount_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The number of Kubernetes Pods backed up in the
     * last successful Backup created via this BackupPlan.
     * </pre>
     *
     * <code>int32 protected_pod_count = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProtectedPodCount() {
      bitField0_ = (bitField0_ & ~0x00001000);
      protectedPodCount_ = 0;
      onChanged();
      return this;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. State of the BackupPlan. This State field reflects the
     * various stages a BackupPlan can be in
     * during the Create operation. It will be set to "DEACTIVATED"
     * if the BackupPlan is deactivated on an Update
     * </pre>
     *
     * <code>
     * .google.cloud.gkebackup.v1.BackupPlan.State state = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the BackupPlan. This State field reflects the
     * various stages a BackupPlan can be in
     * during the Create operation. It will be set to "DEACTIVATED"
     * if the BackupPlan is deactivated on an Update
     * </pre>
     *
     * <code>
     * .google.cloud.gkebackup.v1.BackupPlan.State state = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the BackupPlan. This State field reflects the
     * various stages a BackupPlan can be in
     * during the Create operation. It will be set to "DEACTIVATED"
     * if the BackupPlan is deactivated on an Update
     * </pre>
     *
     * <code>
     * .google.cloud.gkebackup.v1.BackupPlan.State state = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.gkebackup.v1.BackupPlan.State getState() {
      com.google.cloud.gkebackup.v1.BackupPlan.State result =
          com.google.cloud.gkebackup.v1.BackupPlan.State.forNumber(state_);
      return result == null ? com.google.cloud.gkebackup.v1.BackupPlan.State.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the BackupPlan. This State field reflects the
     * various stages a BackupPlan can be in
     * during the Create operation. It will be set to "DEACTIVATED"
     * if the BackupPlan is deactivated on an Update
     * </pre>
     *
     * <code>
     * .google.cloud.gkebackup.v1.BackupPlan.State state = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.gkebackup.v1.BackupPlan.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00002000;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the BackupPlan. This State field reflects the
     * various stages a BackupPlan can be in
     * during the Create operation. It will be set to "DEACTIVATED"
     * if the BackupPlan is deactivated on an Update
     * </pre>
     *
     * <code>
     * .google.cloud.gkebackup.v1.BackupPlan.State state = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00002000);
      state_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object stateReason_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Human-readable description of why BackupPlan is in the current
     * `state`
     * </pre>
     *
     * <code>string state_reason = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The stateReason.
     */
    public java.lang.String getStateReason() {
      java.lang.Object ref = stateReason_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        stateReason_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Human-readable description of why BackupPlan is in the current
     * `state`
     * </pre>
     *
     * <code>string state_reason = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for stateReason.
     */
    public com.google.protobuf.ByteString getStateReasonBytes() {
      java.lang.Object ref = stateReason_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        stateReason_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Human-readable description of why BackupPlan is in the current
     * `state`
     * </pre>
     *
     * <code>string state_reason = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The stateReason to set.
     * @return This builder for chaining.
     */
    public Builder setStateReason(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      stateReason_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Human-readable description of why BackupPlan is in the current
     * `state`
     * </pre>
     *
     * <code>string state_reason = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStateReason() {
      stateReason_ = getDefaultInstance().getStateReason();
      bitField0_ = (bitField0_ & ~0x00004000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Human-readable description of why BackupPlan is in the current
     * `state`
     * </pre>
     *
     * <code>string state_reason = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for stateReason to set.
     * @return This builder for chaining.
     */
    public Builder setStateReasonBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      stateReason_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.gkebackup.v1.BackupPlan)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.gkebackup.v1.BackupPlan)
  private static final com.google.cloud.gkebackup.v1.BackupPlan DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.gkebackup.v1.BackupPlan();
  }

  public static com.google.cloud.gkebackup.v1.BackupPlan getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BackupPlan> PARSER =
      new com.google.protobuf.AbstractParser<BackupPlan>() {
        @java.lang.Override
        public BackupPlan parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BackupPlan> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BackupPlan> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.gkebackup.v1.BackupPlan getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
