/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/gkebackup/v1/restore.proto

package com.google.cloud.gkebackup.v1;

/**
 *
 *
 * <pre>
 * Configuration of a restore.
 * Next id: 12
 * </pre>
 *
 * Protobuf type {@code google.cloud.gkebackup.v1.RestoreConfig}
 */
public final class RestoreConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.gkebackup.v1.RestoreConfig)
    RestoreConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RestoreConfig.newBuilder() to construct.
  private RestoreConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RestoreConfig() {
    volumeDataRestorePolicy_ = 0;
    clusterResourceConflictPolicy_ = 0;
    namespacedResourceRestoreMode_ = 0;
    substitutionRules_ = java.util.Collections.emptyList();
    transformationRules_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RestoreConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.gkebackup.v1.RestoreProto
        .internal_static_google_cloud_gkebackup_v1_RestoreConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.gkebackup.v1.RestoreProto
        .internal_static_google_cloud_gkebackup_v1_RestoreConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.gkebackup.v1.RestoreConfig.class,
            com.google.cloud.gkebackup.v1.RestoreConfig.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Defines how volume data should be restored.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.gkebackup.v1.RestoreConfig.VolumeDataRestorePolicy}
   */
  public enum VolumeDataRestorePolicy implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified (illegal).
     * </pre>
     *
     * <code>VOLUME_DATA_RESTORE_POLICY_UNSPECIFIED = 0;</code>
     */
    VOLUME_DATA_RESTORE_POLICY_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * For each PVC to be restored, create a new underlying volume and PV
     * from the corresponding VolumeBackup contained within the Backup.
     * </pre>
     *
     * <code>RESTORE_VOLUME_DATA_FROM_BACKUP = 1;</code>
     */
    RESTORE_VOLUME_DATA_FROM_BACKUP(1),
    /**
     *
     *
     * <pre>
     * For each PVC to be restored, attempt to reuse the original PV contained
     * in the Backup (with its original underlying volume). This option
     * is likely only usable when restoring a workload to its original cluster.
     * </pre>
     *
     * <code>REUSE_VOLUME_HANDLE_FROM_BACKUP = 2;</code>
     */
    REUSE_VOLUME_HANDLE_FROM_BACKUP(2),
    /**
     *
     *
     * <pre>
     * For each PVC to be restored, create PVC without any particular
     * action to restore data. In this case, the normal Kubernetes provisioning
     * logic would kick in, and this would likely result in either dynamically
     * provisioning blank PVs or binding to statically provisioned PVs.
     * </pre>
     *
     * <code>NO_VOLUME_DATA_RESTORATION = 3;</code>
     */
    NO_VOLUME_DATA_RESTORATION(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified (illegal).
     * </pre>
     *
     * <code>VOLUME_DATA_RESTORE_POLICY_UNSPECIFIED = 0;</code>
     */
    public static final int VOLUME_DATA_RESTORE_POLICY_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * For each PVC to be restored, create a new underlying volume and PV
     * from the corresponding VolumeBackup contained within the Backup.
     * </pre>
     *
     * <code>RESTORE_VOLUME_DATA_FROM_BACKUP = 1;</code>
     */
    public static final int RESTORE_VOLUME_DATA_FROM_BACKUP_VALUE = 1;
    /**
     *
     *
     * <pre>
     * For each PVC to be restored, attempt to reuse the original PV contained
     * in the Backup (with its original underlying volume). This option
     * is likely only usable when restoring a workload to its original cluster.
     * </pre>
     *
     * <code>REUSE_VOLUME_HANDLE_FROM_BACKUP = 2;</code>
     */
    public static final int REUSE_VOLUME_HANDLE_FROM_BACKUP_VALUE = 2;
    /**
     *
     *
     * <pre>
     * For each PVC to be restored, create PVC without any particular
     * action to restore data. In this case, the normal Kubernetes provisioning
     * logic would kick in, and this would likely result in either dynamically
     * provisioning blank PVs or binding to statically provisioned PVs.
     * </pre>
     *
     * <code>NO_VOLUME_DATA_RESTORATION = 3;</code>
     */
    public static final int NO_VOLUME_DATA_RESTORATION_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static VolumeDataRestorePolicy valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static VolumeDataRestorePolicy forNumber(int value) {
      switch (value) {
        case 0:
          return VOLUME_DATA_RESTORE_POLICY_UNSPECIFIED;
        case 1:
          return RESTORE_VOLUME_DATA_FROM_BACKUP;
        case 2:
          return REUSE_VOLUME_HANDLE_FROM_BACKUP;
        case 3:
          return NO_VOLUME_DATA_RESTORATION;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<VolumeDataRestorePolicy>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<VolumeDataRestorePolicy>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<VolumeDataRestorePolicy>() {
              public VolumeDataRestorePolicy findValueByNumber(int number) {
                return VolumeDataRestorePolicy.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.gkebackup.v1.RestoreConfig.getDescriptor().getEnumTypes().get(0);
    }

    private static final VolumeDataRestorePolicy[] VALUES = values();

    public static VolumeDataRestorePolicy valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private VolumeDataRestorePolicy(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.gkebackup.v1.RestoreConfig.VolumeDataRestorePolicy)
  }

  /**
   *
   *
   * <pre>
   * Defines the behavior for handling the situation where cluster-scoped
   * resources being restored already exist in the target cluster.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceConflictPolicy}
   */
  public enum ClusterResourceConflictPolicy implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified. Only allowed if no cluster-scoped resources will be
     * restored.
     * </pre>
     *
     * <code>CLUSTER_RESOURCE_CONFLICT_POLICY_UNSPECIFIED = 0;</code>
     */
    CLUSTER_RESOURCE_CONFLICT_POLICY_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Do not attempt to restore the conflicting resource.
     * </pre>
     *
     * <code>USE_EXISTING_VERSION = 1;</code>
     */
    USE_EXISTING_VERSION(1),
    /**
     *
     *
     * <pre>
     * Delete the existing version before re-creating it from the Backup.
     * This is a dangerous option which could cause unintentional
     * data loss if used inappropriately. For example, deleting a CRD will
     * cause Kubernetes to delete all CRs of that type.
     * </pre>
     *
     * <code>USE_BACKUP_VERSION = 2;</code>
     */
    USE_BACKUP_VERSION(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified. Only allowed if no cluster-scoped resources will be
     * restored.
     * </pre>
     *
     * <code>CLUSTER_RESOURCE_CONFLICT_POLICY_UNSPECIFIED = 0;</code>
     */
    public static final int CLUSTER_RESOURCE_CONFLICT_POLICY_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Do not attempt to restore the conflicting resource.
     * </pre>
     *
     * <code>USE_EXISTING_VERSION = 1;</code>
     */
    public static final int USE_EXISTING_VERSION_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Delete the existing version before re-creating it from the Backup.
     * This is a dangerous option which could cause unintentional
     * data loss if used inappropriately. For example, deleting a CRD will
     * cause Kubernetes to delete all CRs of that type.
     * </pre>
     *
     * <code>USE_BACKUP_VERSION = 2;</code>
     */
    public static final int USE_BACKUP_VERSION_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ClusterResourceConflictPolicy valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ClusterResourceConflictPolicy forNumber(int value) {
      switch (value) {
        case 0:
          return CLUSTER_RESOURCE_CONFLICT_POLICY_UNSPECIFIED;
        case 1:
          return USE_EXISTING_VERSION;
        case 2:
          return USE_BACKUP_VERSION;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ClusterResourceConflictPolicy>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ClusterResourceConflictPolicy>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<ClusterResourceConflictPolicy>() {
              public ClusterResourceConflictPolicy findValueByNumber(int number) {
                return ClusterResourceConflictPolicy.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.gkebackup.v1.RestoreConfig.getDescriptor().getEnumTypes().get(1);
    }

    private static final ClusterResourceConflictPolicy[] VALUES = values();

    public static ClusterResourceConflictPolicy valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ClusterResourceConflictPolicy(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceConflictPolicy)
  }

  /**
   *
   *
   * <pre>
   * Defines the behavior for handling the situation where sets of namespaced
   * resources being restored already exist in the target cluster.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.gkebackup.v1.RestoreConfig.NamespacedResourceRestoreMode}
   */
  public enum NamespacedResourceRestoreMode implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified (invalid).
     * </pre>
     *
     * <code>NAMESPACED_RESOURCE_RESTORE_MODE_UNSPECIFIED = 0;</code>
     */
    NAMESPACED_RESOURCE_RESTORE_MODE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * When conflicting top-level resources (either Namespaces or
     * ProtectedApplications, depending upon the scope) are encountered, this
     * will first trigger a delete of the conflicting resource AND ALL OF ITS
     * REFERENCED RESOURCES (e.g., all resources in the Namespace or all
     * resources referenced by the ProtectedApplication) before restoring the
     * resources from the Backup. This mode should only be used when you are
     * intending to revert some portion of a cluster to an earlier state.
     * </pre>
     *
     * <code>DELETE_AND_RESTORE = 1;</code>
     */
    DELETE_AND_RESTORE(1),
    /**
     *
     *
     * <pre>
     * If conflicting top-level resources (either Namespaces or
     * ProtectedApplications, depending upon the scope) are encountered at the
     * beginning of a restore process, the Restore will fail.  If a conflict
     * occurs during the restore process itself (e.g., because an out of band
     * process creates conflicting resources), a conflict will be reported.
     * </pre>
     *
     * <code>FAIL_ON_CONFLICT = 2;</code>
     */
    FAIL_ON_CONFLICT(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified (invalid).
     * </pre>
     *
     * <code>NAMESPACED_RESOURCE_RESTORE_MODE_UNSPECIFIED = 0;</code>
     */
    public static final int NAMESPACED_RESOURCE_RESTORE_MODE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * When conflicting top-level resources (either Namespaces or
     * ProtectedApplications, depending upon the scope) are encountered, this
     * will first trigger a delete of the conflicting resource AND ALL OF ITS
     * REFERENCED RESOURCES (e.g., all resources in the Namespace or all
     * resources referenced by the ProtectedApplication) before restoring the
     * resources from the Backup. This mode should only be used when you are
     * intending to revert some portion of a cluster to an earlier state.
     * </pre>
     *
     * <code>DELETE_AND_RESTORE = 1;</code>
     */
    public static final int DELETE_AND_RESTORE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * If conflicting top-level resources (either Namespaces or
     * ProtectedApplications, depending upon the scope) are encountered at the
     * beginning of a restore process, the Restore will fail.  If a conflict
     * occurs during the restore process itself (e.g., because an out of band
     * process creates conflicting resources), a conflict will be reported.
     * </pre>
     *
     * <code>FAIL_ON_CONFLICT = 2;</code>
     */
    public static final int FAIL_ON_CONFLICT_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static NamespacedResourceRestoreMode valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static NamespacedResourceRestoreMode forNumber(int value) {
      switch (value) {
        case 0:
          return NAMESPACED_RESOURCE_RESTORE_MODE_UNSPECIFIED;
        case 1:
          return DELETE_AND_RESTORE;
        case 2:
          return FAIL_ON_CONFLICT;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<NamespacedResourceRestoreMode>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<NamespacedResourceRestoreMode>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<NamespacedResourceRestoreMode>() {
              public NamespacedResourceRestoreMode findValueByNumber(int number) {
                return NamespacedResourceRestoreMode.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.gkebackup.v1.RestoreConfig.getDescriptor().getEnumTypes().get(2);
    }

    private static final NamespacedResourceRestoreMode[] VALUES = values();

    public static NamespacedResourceRestoreMode valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private NamespacedResourceRestoreMode(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.gkebackup.v1.RestoreConfig.NamespacedResourceRestoreMode)
  }

  public interface GroupKindOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.gkebackup.v1.RestoreConfig.GroupKind)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * API group string of a Kubernetes resource, e.g.
     * "apiextensions.k8s.io", "storage.k8s.io", etc.
     * Note: use empty string for core API group
     * </pre>
     *
     * <code>string resource_group = 1;</code>
     *
     * @return The resourceGroup.
     */
    java.lang.String getResourceGroup();
    /**
     *
     *
     * <pre>
     * API group string of a Kubernetes resource, e.g.
     * "apiextensions.k8s.io", "storage.k8s.io", etc.
     * Note: use empty string for core API group
     * </pre>
     *
     * <code>string resource_group = 1;</code>
     *
     * @return The bytes for resourceGroup.
     */
    com.google.protobuf.ByteString getResourceGroupBytes();

    /**
     *
     *
     * <pre>
     * Kind of a Kubernetes resource, e.g.
     * "CustomResourceDefinition", "StorageClass", etc.
     * </pre>
     *
     * <code>string resource_kind = 2;</code>
     *
     * @return The resourceKind.
     */
    java.lang.String getResourceKind();
    /**
     *
     *
     * <pre>
     * Kind of a Kubernetes resource, e.g.
     * "CustomResourceDefinition", "StorageClass", etc.
     * </pre>
     *
     * <code>string resource_kind = 2;</code>
     *
     * @return The bytes for resourceKind.
     */
    com.google.protobuf.ByteString getResourceKindBytes();
  }
  /**
   *
   *
   * <pre>
   * This is a direct map to the Kubernetes GroupKind type
   * [GroupKind](https://godoc.org/k8s.io/apimachinery/pkg/runtime/schema#GroupKind)
   * and is used for identifying specific "types" of resources to restore.
   * </pre>
   *
   * Protobuf type {@code google.cloud.gkebackup.v1.RestoreConfig.GroupKind}
   */
  public static final class GroupKind extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.gkebackup.v1.RestoreConfig.GroupKind)
      GroupKindOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use GroupKind.newBuilder() to construct.
    private GroupKind(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private GroupKind() {
      resourceGroup_ = "";
      resourceKind_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new GroupKind();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.gkebackup.v1.RestoreProto
          .internal_static_google_cloud_gkebackup_v1_RestoreConfig_GroupKind_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.gkebackup.v1.RestoreProto
          .internal_static_google_cloud_gkebackup_v1_RestoreConfig_GroupKind_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind.class,
              com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind.Builder.class);
    }

    public static final int RESOURCE_GROUP_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object resourceGroup_ = "";
    /**
     *
     *
     * <pre>
     * API group string of a Kubernetes resource, e.g.
     * "apiextensions.k8s.io", "storage.k8s.io", etc.
     * Note: use empty string for core API group
     * </pre>
     *
     * <code>string resource_group = 1;</code>
     *
     * @return The resourceGroup.
     */
    @java.lang.Override
    public java.lang.String getResourceGroup() {
      java.lang.Object ref = resourceGroup_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        resourceGroup_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * API group string of a Kubernetes resource, e.g.
     * "apiextensions.k8s.io", "storage.k8s.io", etc.
     * Note: use empty string for core API group
     * </pre>
     *
     * <code>string resource_group = 1;</code>
     *
     * @return The bytes for resourceGroup.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getResourceGroupBytes() {
      java.lang.Object ref = resourceGroup_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        resourceGroup_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int RESOURCE_KIND_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object resourceKind_ = "";
    /**
     *
     *
     * <pre>
     * Kind of a Kubernetes resource, e.g.
     * "CustomResourceDefinition", "StorageClass", etc.
     * </pre>
     *
     * <code>string resource_kind = 2;</code>
     *
     * @return The resourceKind.
     */
    @java.lang.Override
    public java.lang.String getResourceKind() {
      java.lang.Object ref = resourceKind_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        resourceKind_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Kind of a Kubernetes resource, e.g.
     * "CustomResourceDefinition", "StorageClass", etc.
     * </pre>
     *
     * <code>string resource_kind = 2;</code>
     *
     * @return The bytes for resourceKind.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getResourceKindBytes() {
      java.lang.Object ref = resourceKind_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        resourceKind_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceGroup_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, resourceGroup_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceKind_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, resourceKind_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceGroup_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, resourceGroup_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceKind_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, resourceKind_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind)) {
        return super.equals(obj);
      }
      com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind other =
          (com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind) obj;

      if (!getResourceGroup().equals(other.getResourceGroup())) return false;
      if (!getResourceKind().equals(other.getResourceKind())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + RESOURCE_GROUP_FIELD_NUMBER;
      hash = (53 * hash) + getResourceGroup().hashCode();
      hash = (37 * hash) + RESOURCE_KIND_FIELD_NUMBER;
      hash = (53 * hash) + getResourceKind().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * This is a direct map to the Kubernetes GroupKind type
     * [GroupKind](https://godoc.org/k8s.io/apimachinery/pkg/runtime/schema#GroupKind)
     * and is used for identifying specific "types" of resources to restore.
     * </pre>
     *
     * Protobuf type {@code google.cloud.gkebackup.v1.RestoreConfig.GroupKind}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.gkebackup.v1.RestoreConfig.GroupKind)
        com.google.cloud.gkebackup.v1.RestoreConfig.GroupKindOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.gkebackup.v1.RestoreProto
            .internal_static_google_cloud_gkebackup_v1_RestoreConfig_GroupKind_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.gkebackup.v1.RestoreProto
            .internal_static_google_cloud_gkebackup_v1_RestoreConfig_GroupKind_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind.class,
                com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind.Builder.class);
      }

      // Construct using com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        resourceGroup_ = "";
        resourceKind_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.gkebackup.v1.RestoreProto
            .internal_static_google_cloud_gkebackup_v1_RestoreConfig_GroupKind_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind getDefaultInstanceForType() {
        return com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind build() {
        com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind buildPartial() {
        com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind result =
            new com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.resourceGroup_ = resourceGroup_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.resourceKind_ = resourceKind_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind) {
          return mergeFrom((com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind other) {
        if (other == com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind.getDefaultInstance())
          return this;
        if (!other.getResourceGroup().isEmpty()) {
          resourceGroup_ = other.resourceGroup_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getResourceKind().isEmpty()) {
          resourceKind_ = other.resourceKind_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  resourceGroup_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  resourceKind_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object resourceGroup_ = "";
      /**
       *
       *
       * <pre>
       * API group string of a Kubernetes resource, e.g.
       * "apiextensions.k8s.io", "storage.k8s.io", etc.
       * Note: use empty string for core API group
       * </pre>
       *
       * <code>string resource_group = 1;</code>
       *
       * @return The resourceGroup.
       */
      public java.lang.String getResourceGroup() {
        java.lang.Object ref = resourceGroup_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          resourceGroup_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * API group string of a Kubernetes resource, e.g.
       * "apiextensions.k8s.io", "storage.k8s.io", etc.
       * Note: use empty string for core API group
       * </pre>
       *
       * <code>string resource_group = 1;</code>
       *
       * @return The bytes for resourceGroup.
       */
      public com.google.protobuf.ByteString getResourceGroupBytes() {
        java.lang.Object ref = resourceGroup_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          resourceGroup_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * API group string of a Kubernetes resource, e.g.
       * "apiextensions.k8s.io", "storage.k8s.io", etc.
       * Note: use empty string for core API group
       * </pre>
       *
       * <code>string resource_group = 1;</code>
       *
       * @param value The resourceGroup to set.
       * @return This builder for chaining.
       */
      public Builder setResourceGroup(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        resourceGroup_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * API group string of a Kubernetes resource, e.g.
       * "apiextensions.k8s.io", "storage.k8s.io", etc.
       * Note: use empty string for core API group
       * </pre>
       *
       * <code>string resource_group = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearResourceGroup() {
        resourceGroup_ = getDefaultInstance().getResourceGroup();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * API group string of a Kubernetes resource, e.g.
       * "apiextensions.k8s.io", "storage.k8s.io", etc.
       * Note: use empty string for core API group
       * </pre>
       *
       * <code>string resource_group = 1;</code>
       *
       * @param value The bytes for resourceGroup to set.
       * @return This builder for chaining.
       */
      public Builder setResourceGroupBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        resourceGroup_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object resourceKind_ = "";
      /**
       *
       *
       * <pre>
       * Kind of a Kubernetes resource, e.g.
       * "CustomResourceDefinition", "StorageClass", etc.
       * </pre>
       *
       * <code>string resource_kind = 2;</code>
       *
       * @return The resourceKind.
       */
      public java.lang.String getResourceKind() {
        java.lang.Object ref = resourceKind_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          resourceKind_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Kind of a Kubernetes resource, e.g.
       * "CustomResourceDefinition", "StorageClass", etc.
       * </pre>
       *
       * <code>string resource_kind = 2;</code>
       *
       * @return The bytes for resourceKind.
       */
      public com.google.protobuf.ByteString getResourceKindBytes() {
        java.lang.Object ref = resourceKind_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          resourceKind_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Kind of a Kubernetes resource, e.g.
       * "CustomResourceDefinition", "StorageClass", etc.
       * </pre>
       *
       * <code>string resource_kind = 2;</code>
       *
       * @param value The resourceKind to set.
       * @return This builder for chaining.
       */
      public Builder setResourceKind(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        resourceKind_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Kind of a Kubernetes resource, e.g.
       * "CustomResourceDefinition", "StorageClass", etc.
       * </pre>
       *
       * <code>string resource_kind = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearResourceKind() {
        resourceKind_ = getDefaultInstance().getResourceKind();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Kind of a Kubernetes resource, e.g.
       * "CustomResourceDefinition", "StorageClass", etc.
       * </pre>
       *
       * <code>string resource_kind = 2;</code>
       *
       * @param value The bytes for resourceKind to set.
       * @return This builder for chaining.
       */
      public Builder setResourceKindBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        resourceKind_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.gkebackup.v1.RestoreConfig.GroupKind)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.gkebackup.v1.RestoreConfig.GroupKind)
    private static final com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind();
    }

    public static com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<GroupKind> PARSER =
        new com.google.protobuf.AbstractParser<GroupKind>() {
          @java.lang.Override
          public GroupKind parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<GroupKind> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<GroupKind> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ClusterResourceRestoreScopeOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * A list of cluster-scoped resource group kinds to restore from the
     * backup. If specified, only the selected resources will be restored.
     * Mutually exclusive to any other field in the message.
     * </pre>
     *
     * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind selected_group_kinds = 1;
     * </code>
     */
    java.util.List<com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind>
        getSelectedGroupKindsList();
    /**
     *
     *
     * <pre>
     * A list of cluster-scoped resource group kinds to restore from the
     * backup. If specified, only the selected resources will be restored.
     * Mutually exclusive to any other field in the message.
     * </pre>
     *
     * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind selected_group_kinds = 1;
     * </code>
     */
    com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind getSelectedGroupKinds(int index);
    /**
     *
     *
     * <pre>
     * A list of cluster-scoped resource group kinds to restore from the
     * backup. If specified, only the selected resources will be restored.
     * Mutually exclusive to any other field in the message.
     * </pre>
     *
     * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind selected_group_kinds = 1;
     * </code>
     */
    int getSelectedGroupKindsCount();
    /**
     *
     *
     * <pre>
     * A list of cluster-scoped resource group kinds to restore from the
     * backup. If specified, only the selected resources will be restored.
     * Mutually exclusive to any other field in the message.
     * </pre>
     *
     * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind selected_group_kinds = 1;
     * </code>
     */
    java.util.List<? extends com.google.cloud.gkebackup.v1.RestoreConfig.GroupKindOrBuilder>
        getSelectedGroupKindsOrBuilderList();
    /**
     *
     *
     * <pre>
     * A list of cluster-scoped resource group kinds to restore from the
     * backup. If specified, only the selected resources will be restored.
     * Mutually exclusive to any other field in the message.
     * </pre>
     *
     * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind selected_group_kinds = 1;
     * </code>
     */
    com.google.cloud.gkebackup.v1.RestoreConfig.GroupKindOrBuilder getSelectedGroupKindsOrBuilder(
        int index);

    /**
     *
     *
     * <pre>
     * A list of cluster-scoped resource group kinds to NOT restore from the
     * backup. If specified, all valid cluster-scoped resources will be
     * restored except for those specified in the list.
     * Mutually exclusive to any other field in the message.
     * </pre>
     *
     * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind excluded_group_kinds = 2;
     * </code>
     */
    java.util.List<com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind>
        getExcludedGroupKindsList();
    /**
     *
     *
     * <pre>
     * A list of cluster-scoped resource group kinds to NOT restore from the
     * backup. If specified, all valid cluster-scoped resources will be
     * restored except for those specified in the list.
     * Mutually exclusive to any other field in the message.
     * </pre>
     *
     * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind excluded_group_kinds = 2;
     * </code>
     */
    com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind getExcludedGroupKinds(int index);
    /**
     *
     *
     * <pre>
     * A list of cluster-scoped resource group kinds to NOT restore from the
     * backup. If specified, all valid cluster-scoped resources will be
     * restored except for those specified in the list.
     * Mutually exclusive to any other field in the message.
     * </pre>
     *
     * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind excluded_group_kinds = 2;
     * </code>
     */
    int getExcludedGroupKindsCount();
    /**
     *
     *
     * <pre>
     * A list of cluster-scoped resource group kinds to NOT restore from the
     * backup. If specified, all valid cluster-scoped resources will be
     * restored except for those specified in the list.
     * Mutually exclusive to any other field in the message.
     * </pre>
     *
     * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind excluded_group_kinds = 2;
     * </code>
     */
    java.util.List<? extends com.google.cloud.gkebackup.v1.RestoreConfig.GroupKindOrBuilder>
        getExcludedGroupKindsOrBuilderList();
    /**
     *
     *
     * <pre>
     * A list of cluster-scoped resource group kinds to NOT restore from the
     * backup. If specified, all valid cluster-scoped resources will be
     * restored except for those specified in the list.
     * Mutually exclusive to any other field in the message.
     * </pre>
     *
     * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind excluded_group_kinds = 2;
     * </code>
     */
    com.google.cloud.gkebackup.v1.RestoreConfig.GroupKindOrBuilder getExcludedGroupKindsOrBuilder(
        int index);

    /**
     *
     *
     * <pre>
     * If True, all valid cluster-scoped resources will be restored.
     * Mutually exclusive to any other field in the message.
     * </pre>
     *
     * <code>bool all_group_kinds = 3;</code>
     *
     * @return The allGroupKinds.
     */
    boolean getAllGroupKinds();

    /**
     *
     *
     * <pre>
     * If True, no cluster-scoped resources will be restored.
     * This has the same restore scope as if the message is not defined.
     * Mutually exclusive to any other field in the message.
     * </pre>
     *
     * <code>bool no_group_kinds = 4;</code>
     *
     * @return The noGroupKinds.
     */
    boolean getNoGroupKinds();
  }
  /**
   *
   *
   * <pre>
   * Defines the scope of cluster-scoped resources to restore.
   *
   * Some group kinds are not reasonable choices for a restore, and will cause
   * an error if selected here. Any scope selection that would restore
   * "all valid" resources automatically excludes these group kinds.
   * - gkebackup.gke.io/BackupJob
   * - gkebackup.gke.io/RestoreJob
   * - metrics.k8s.io/NodeMetrics
   * - migration.k8s.io/StorageState
   * - migration.k8s.io/StorageVersionMigration
   * - Node
   * - snapshot.storage.k8s.io/VolumeSnapshotContent
   * - storage.k8s.io/CSINode
   *
   * Some group kinds are driven by restore configuration elsewhere,
   * and will cause an error if selected here.
   * - Namespace
   * - PersistentVolume
   * </pre>
   *
   * Protobuf type {@code google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope}
   */
  public static final class ClusterResourceRestoreScope
      extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope)
      ClusterResourceRestoreScopeOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ClusterResourceRestoreScope.newBuilder() to construct.
    private ClusterResourceRestoreScope(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ClusterResourceRestoreScope() {
      selectedGroupKinds_ = java.util.Collections.emptyList();
      excludedGroupKinds_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ClusterResourceRestoreScope();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.gkebackup.v1.RestoreProto
          .internal_static_google_cloud_gkebackup_v1_RestoreConfig_ClusterResourceRestoreScope_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.gkebackup.v1.RestoreProto
          .internal_static_google_cloud_gkebackup_v1_RestoreConfig_ClusterResourceRestoreScope_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope.class,
              com.google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope.Builder
                  .class);
    }

    public static final int SELECTED_GROUP_KINDS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind>
        selectedGroupKinds_;
    /**
     *
     *
     * <pre>
     * A list of cluster-scoped resource group kinds to restore from the
     * backup. If specified, only the selected resources will be restored.
     * Mutually exclusive to any other field in the message.
     * </pre>
     *
     * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind selected_group_kinds = 1;
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind>
        getSelectedGroupKindsList() {
      return selectedGroupKinds_;
    }
    /**
     *
     *
     * <pre>
     * A list of cluster-scoped resource group kinds to restore from the
     * backup. If specified, only the selected resources will be restored.
     * Mutually exclusive to any other field in the message.
     * </pre>
     *
     * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind selected_group_kinds = 1;
     * </code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.cloud.gkebackup.v1.RestoreConfig.GroupKindOrBuilder>
        getSelectedGroupKindsOrBuilderList() {
      return selectedGroupKinds_;
    }
    /**
     *
     *
     * <pre>
     * A list of cluster-scoped resource group kinds to restore from the
     * backup. If specified, only the selected resources will be restored.
     * Mutually exclusive to any other field in the message.
     * </pre>
     *
     * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind selected_group_kinds = 1;
     * </code>
     */
    @java.lang.Override
    public int getSelectedGroupKindsCount() {
      return selectedGroupKinds_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of cluster-scoped resource group kinds to restore from the
     * backup. If specified, only the selected resources will be restored.
     * Mutually exclusive to any other field in the message.
     * </pre>
     *
     * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind selected_group_kinds = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind getSelectedGroupKinds(int index) {
      return selectedGroupKinds_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A list of cluster-scoped resource group kinds to restore from the
     * backup. If specified, only the selected resources will be restored.
     * Mutually exclusive to any other field in the message.
     * </pre>
     *
     * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind selected_group_kinds = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.gkebackup.v1.RestoreConfig.GroupKindOrBuilder
        getSelectedGroupKindsOrBuilder(int index) {
      return selectedGroupKinds_.get(index);
    }

    public static final int EXCLUDED_GROUP_KINDS_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind>
        excludedGroupKinds_;
    /**
     *
     *
     * <pre>
     * A list of cluster-scoped resource group kinds to NOT restore from the
     * backup. If specified, all valid cluster-scoped resources will be
     * restored except for those specified in the list.
     * Mutually exclusive to any other field in the message.
     * </pre>
     *
     * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind excluded_group_kinds = 2;
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind>
        getExcludedGroupKindsList() {
      return excludedGroupKinds_;
    }
    /**
     *
     *
     * <pre>
     * A list of cluster-scoped resource group kinds to NOT restore from the
     * backup. If specified, all valid cluster-scoped resources will be
     * restored except for those specified in the list.
     * Mutually exclusive to any other field in the message.
     * </pre>
     *
     * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind excluded_group_kinds = 2;
     * </code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.cloud.gkebackup.v1.RestoreConfig.GroupKindOrBuilder>
        getExcludedGroupKindsOrBuilderList() {
      return excludedGroupKinds_;
    }
    /**
     *
     *
     * <pre>
     * A list of cluster-scoped resource group kinds to NOT restore from the
     * backup. If specified, all valid cluster-scoped resources will be
     * restored except for those specified in the list.
     * Mutually exclusive to any other field in the message.
     * </pre>
     *
     * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind excluded_group_kinds = 2;
     * </code>
     */
    @java.lang.Override
    public int getExcludedGroupKindsCount() {
      return excludedGroupKinds_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of cluster-scoped resource group kinds to NOT restore from the
     * backup. If specified, all valid cluster-scoped resources will be
     * restored except for those specified in the list.
     * Mutually exclusive to any other field in the message.
     * </pre>
     *
     * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind excluded_group_kinds = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind getExcludedGroupKinds(int index) {
      return excludedGroupKinds_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A list of cluster-scoped resource group kinds to NOT restore from the
     * backup. If specified, all valid cluster-scoped resources will be
     * restored except for those specified in the list.
     * Mutually exclusive to any other field in the message.
     * </pre>
     *
     * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind excluded_group_kinds = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.gkebackup.v1.RestoreConfig.GroupKindOrBuilder
        getExcludedGroupKindsOrBuilder(int index) {
      return excludedGroupKinds_.get(index);
    }

    public static final int ALL_GROUP_KINDS_FIELD_NUMBER = 3;
    private boolean allGroupKinds_ = false;
    /**
     *
     *
     * <pre>
     * If True, all valid cluster-scoped resources will be restored.
     * Mutually exclusive to any other field in the message.
     * </pre>
     *
     * <code>bool all_group_kinds = 3;</code>
     *
     * @return The allGroupKinds.
     */
    @java.lang.Override
    public boolean getAllGroupKinds() {
      return allGroupKinds_;
    }

    public static final int NO_GROUP_KINDS_FIELD_NUMBER = 4;
    private boolean noGroupKinds_ = false;
    /**
     *
     *
     * <pre>
     * If True, no cluster-scoped resources will be restored.
     * This has the same restore scope as if the message is not defined.
     * Mutually exclusive to any other field in the message.
     * </pre>
     *
     * <code>bool no_group_kinds = 4;</code>
     *
     * @return The noGroupKinds.
     */
    @java.lang.Override
    public boolean getNoGroupKinds() {
      return noGroupKinds_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < selectedGroupKinds_.size(); i++) {
        output.writeMessage(1, selectedGroupKinds_.get(i));
      }
      for (int i = 0; i < excludedGroupKinds_.size(); i++) {
        output.writeMessage(2, excludedGroupKinds_.get(i));
      }
      if (allGroupKinds_ != false) {
        output.writeBool(3, allGroupKinds_);
      }
      if (noGroupKinds_ != false) {
        output.writeBool(4, noGroupKinds_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < selectedGroupKinds_.size(); i++) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(1, selectedGroupKinds_.get(i));
      }
      for (int i = 0; i < excludedGroupKinds_.size(); i++) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(2, excludedGroupKinds_.get(i));
      }
      if (allGroupKinds_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, allGroupKinds_);
      }
      if (noGroupKinds_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, noGroupKinds_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope)) {
        return super.equals(obj);
      }
      com.google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope other =
          (com.google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope) obj;

      if (!getSelectedGroupKindsList().equals(other.getSelectedGroupKindsList())) return false;
      if (!getExcludedGroupKindsList().equals(other.getExcludedGroupKindsList())) return false;
      if (getAllGroupKinds() != other.getAllGroupKinds()) return false;
      if (getNoGroupKinds() != other.getNoGroupKinds()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getSelectedGroupKindsCount() > 0) {
        hash = (37 * hash) + SELECTED_GROUP_KINDS_FIELD_NUMBER;
        hash = (53 * hash) + getSelectedGroupKindsList().hashCode();
      }
      if (getExcludedGroupKindsCount() > 0) {
        hash = (37 * hash) + EXCLUDED_GROUP_KINDS_FIELD_NUMBER;
        hash = (53 * hash) + getExcludedGroupKindsList().hashCode();
      }
      hash = (37 * hash) + ALL_GROUP_KINDS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAllGroupKinds());
      hash = (37 * hash) + NO_GROUP_KINDS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getNoGroupKinds());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Defines the scope of cluster-scoped resources to restore.
     *
     * Some group kinds are not reasonable choices for a restore, and will cause
     * an error if selected here. Any scope selection that would restore
     * "all valid" resources automatically excludes these group kinds.
     * - gkebackup.gke.io/BackupJob
     * - gkebackup.gke.io/RestoreJob
     * - metrics.k8s.io/NodeMetrics
     * - migration.k8s.io/StorageState
     * - migration.k8s.io/StorageVersionMigration
     * - Node
     * - snapshot.storage.k8s.io/VolumeSnapshotContent
     * - storage.k8s.io/CSINode
     *
     * Some group kinds are driven by restore configuration elsewhere,
     * and will cause an error if selected here.
     * - Namespace
     * - PersistentVolume
     * </pre>
     *
     * Protobuf type {@code google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope)
        com.google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScopeOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.gkebackup.v1.RestoreProto
            .internal_static_google_cloud_gkebackup_v1_RestoreConfig_ClusterResourceRestoreScope_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.gkebackup.v1.RestoreProto
            .internal_static_google_cloud_gkebackup_v1_RestoreConfig_ClusterResourceRestoreScope_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope.class,
                com.google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (selectedGroupKindsBuilder_ == null) {
          selectedGroupKinds_ = java.util.Collections.emptyList();
        } else {
          selectedGroupKinds_ = null;
          selectedGroupKindsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        if (excludedGroupKindsBuilder_ == null) {
          excludedGroupKinds_ = java.util.Collections.emptyList();
        } else {
          excludedGroupKinds_ = null;
          excludedGroupKindsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        allGroupKinds_ = false;
        noGroupKinds_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.gkebackup.v1.RestoreProto
            .internal_static_google_cloud_gkebackup_v1_RestoreConfig_ClusterResourceRestoreScope_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope
          getDefaultInstanceForType() {
        return com.google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope build() {
        com.google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope
          buildPartial() {
        com.google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope result =
            new com.google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope result) {
        if (selectedGroupKindsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            selectedGroupKinds_ = java.util.Collections.unmodifiableList(selectedGroupKinds_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.selectedGroupKinds_ = selectedGroupKinds_;
        } else {
          result.selectedGroupKinds_ = selectedGroupKindsBuilder_.build();
        }
        if (excludedGroupKindsBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)) {
            excludedGroupKinds_ = java.util.Collections.unmodifiableList(excludedGroupKinds_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.excludedGroupKinds_ = excludedGroupKinds_;
        } else {
          result.excludedGroupKinds_ = excludedGroupKindsBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.allGroupKinds_ = allGroupKinds_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.noGroupKinds_ = noGroupKinds_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope) {
          return mergeFrom(
              (com.google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope other) {
        if (other
            == com.google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope
                .getDefaultInstance()) return this;
        if (selectedGroupKindsBuilder_ == null) {
          if (!other.selectedGroupKinds_.isEmpty()) {
            if (selectedGroupKinds_.isEmpty()) {
              selectedGroupKinds_ = other.selectedGroupKinds_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureSelectedGroupKindsIsMutable();
              selectedGroupKinds_.addAll(other.selectedGroupKinds_);
            }
            onChanged();
          }
        } else {
          if (!other.selectedGroupKinds_.isEmpty()) {
            if (selectedGroupKindsBuilder_.isEmpty()) {
              selectedGroupKindsBuilder_.dispose();
              selectedGroupKindsBuilder_ = null;
              selectedGroupKinds_ = other.selectedGroupKinds_;
              bitField0_ = (bitField0_ & ~0x00000001);
              selectedGroupKindsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getSelectedGroupKindsFieldBuilder()
                      : null;
            } else {
              selectedGroupKindsBuilder_.addAllMessages(other.selectedGroupKinds_);
            }
          }
        }
        if (excludedGroupKindsBuilder_ == null) {
          if (!other.excludedGroupKinds_.isEmpty()) {
            if (excludedGroupKinds_.isEmpty()) {
              excludedGroupKinds_ = other.excludedGroupKinds_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureExcludedGroupKindsIsMutable();
              excludedGroupKinds_.addAll(other.excludedGroupKinds_);
            }
            onChanged();
          }
        } else {
          if (!other.excludedGroupKinds_.isEmpty()) {
            if (excludedGroupKindsBuilder_.isEmpty()) {
              excludedGroupKindsBuilder_.dispose();
              excludedGroupKindsBuilder_ = null;
              excludedGroupKinds_ = other.excludedGroupKinds_;
              bitField0_ = (bitField0_ & ~0x00000002);
              excludedGroupKindsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getExcludedGroupKindsFieldBuilder()
                      : null;
            } else {
              excludedGroupKindsBuilder_.addAllMessages(other.excludedGroupKinds_);
            }
          }
        }
        if (other.getAllGroupKinds() != false) {
          setAllGroupKinds(other.getAllGroupKinds());
        }
        if (other.getNoGroupKinds() != false) {
          setNoGroupKinds(other.getNoGroupKinds());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind m =
                      input.readMessage(
                          com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind.parser(),
                          extensionRegistry);
                  if (selectedGroupKindsBuilder_ == null) {
                    ensureSelectedGroupKindsIsMutable();
                    selectedGroupKinds_.add(m);
                  } else {
                    selectedGroupKindsBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              case 18:
                {
                  com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind m =
                      input.readMessage(
                          com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind.parser(),
                          extensionRegistry);
                  if (excludedGroupKindsBuilder_ == null) {
                    ensureExcludedGroupKindsIsMutable();
                    excludedGroupKinds_.add(m);
                  } else {
                    excludedGroupKindsBuilder_.addMessage(m);
                  }
                  break;
                } // case 18
              case 24:
                {
                  allGroupKinds_ = input.readBool();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
              case 32:
                {
                  noGroupKinds_ = input.readBool();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 32
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind>
          selectedGroupKinds_ = java.util.Collections.emptyList();

      private void ensureSelectedGroupKindsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          selectedGroupKinds_ =
              new java.util.ArrayList<com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind>(
                  selectedGroupKinds_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind,
              com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind.Builder,
              com.google.cloud.gkebackup.v1.RestoreConfig.GroupKindOrBuilder>
          selectedGroupKindsBuilder_;

      /**
       *
       *
       * <pre>
       * A list of cluster-scoped resource group kinds to restore from the
       * backup. If specified, only the selected resources will be restored.
       * Mutually exclusive to any other field in the message.
       * </pre>
       *
       * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind selected_group_kinds = 1;
       * </code>
       */
      public java.util.List<com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind>
          getSelectedGroupKindsList() {
        if (selectedGroupKindsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(selectedGroupKinds_);
        } else {
          return selectedGroupKindsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * A list of cluster-scoped resource group kinds to restore from the
       * backup. If specified, only the selected resources will be restored.
       * Mutually exclusive to any other field in the message.
       * </pre>
       *
       * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind selected_group_kinds = 1;
       * </code>
       */
      public int getSelectedGroupKindsCount() {
        if (selectedGroupKindsBuilder_ == null) {
          return selectedGroupKinds_.size();
        } else {
          return selectedGroupKindsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * A list of cluster-scoped resource group kinds to restore from the
       * backup. If specified, only the selected resources will be restored.
       * Mutually exclusive to any other field in the message.
       * </pre>
       *
       * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind selected_group_kinds = 1;
       * </code>
       */
      public com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind getSelectedGroupKinds(
          int index) {
        if (selectedGroupKindsBuilder_ == null) {
          return selectedGroupKinds_.get(index);
        } else {
          return selectedGroupKindsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * A list of cluster-scoped resource group kinds to restore from the
       * backup. If specified, only the selected resources will be restored.
       * Mutually exclusive to any other field in the message.
       * </pre>
       *
       * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind selected_group_kinds = 1;
       * </code>
       */
      public Builder setSelectedGroupKinds(
          int index, com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind value) {
        if (selectedGroupKindsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureSelectedGroupKindsIsMutable();
          selectedGroupKinds_.set(index, value);
          onChanged();
        } else {
          selectedGroupKindsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of cluster-scoped resource group kinds to restore from the
       * backup. If specified, only the selected resources will be restored.
       * Mutually exclusive to any other field in the message.
       * </pre>
       *
       * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind selected_group_kinds = 1;
       * </code>
       */
      public Builder setSelectedGroupKinds(
          int index,
          com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind.Builder builderForValue) {
        if (selectedGroupKindsBuilder_ == null) {
          ensureSelectedGroupKindsIsMutable();
          selectedGroupKinds_.set(index, builderForValue.build());
          onChanged();
        } else {
          selectedGroupKindsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of cluster-scoped resource group kinds to restore from the
       * backup. If specified, only the selected resources will be restored.
       * Mutually exclusive to any other field in the message.
       * </pre>
       *
       * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind selected_group_kinds = 1;
       * </code>
       */
      public Builder addSelectedGroupKinds(
          com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind value) {
        if (selectedGroupKindsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureSelectedGroupKindsIsMutable();
          selectedGroupKinds_.add(value);
          onChanged();
        } else {
          selectedGroupKindsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of cluster-scoped resource group kinds to restore from the
       * backup. If specified, only the selected resources will be restored.
       * Mutually exclusive to any other field in the message.
       * </pre>
       *
       * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind selected_group_kinds = 1;
       * </code>
       */
      public Builder addSelectedGroupKinds(
          int index, com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind value) {
        if (selectedGroupKindsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureSelectedGroupKindsIsMutable();
          selectedGroupKinds_.add(index, value);
          onChanged();
        } else {
          selectedGroupKindsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of cluster-scoped resource group kinds to restore from the
       * backup. If specified, only the selected resources will be restored.
       * Mutually exclusive to any other field in the message.
       * </pre>
       *
       * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind selected_group_kinds = 1;
       * </code>
       */
      public Builder addSelectedGroupKinds(
          com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind.Builder builderForValue) {
        if (selectedGroupKindsBuilder_ == null) {
          ensureSelectedGroupKindsIsMutable();
          selectedGroupKinds_.add(builderForValue.build());
          onChanged();
        } else {
          selectedGroupKindsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of cluster-scoped resource group kinds to restore from the
       * backup. If specified, only the selected resources will be restored.
       * Mutually exclusive to any other field in the message.
       * </pre>
       *
       * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind selected_group_kinds = 1;
       * </code>
       */
      public Builder addSelectedGroupKinds(
          int index,
          com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind.Builder builderForValue) {
        if (selectedGroupKindsBuilder_ == null) {
          ensureSelectedGroupKindsIsMutable();
          selectedGroupKinds_.add(index, builderForValue.build());
          onChanged();
        } else {
          selectedGroupKindsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of cluster-scoped resource group kinds to restore from the
       * backup. If specified, only the selected resources will be restored.
       * Mutually exclusive to any other field in the message.
       * </pre>
       *
       * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind selected_group_kinds = 1;
       * </code>
       */
      public Builder addAllSelectedGroupKinds(
          java.lang.Iterable<? extends com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind>
              values) {
        if (selectedGroupKindsBuilder_ == null) {
          ensureSelectedGroupKindsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, selectedGroupKinds_);
          onChanged();
        } else {
          selectedGroupKindsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of cluster-scoped resource group kinds to restore from the
       * backup. If specified, only the selected resources will be restored.
       * Mutually exclusive to any other field in the message.
       * </pre>
       *
       * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind selected_group_kinds = 1;
       * </code>
       */
      public Builder clearSelectedGroupKinds() {
        if (selectedGroupKindsBuilder_ == null) {
          selectedGroupKinds_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          selectedGroupKindsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of cluster-scoped resource group kinds to restore from the
       * backup. If specified, only the selected resources will be restored.
       * Mutually exclusive to any other field in the message.
       * </pre>
       *
       * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind selected_group_kinds = 1;
       * </code>
       */
      public Builder removeSelectedGroupKinds(int index) {
        if (selectedGroupKindsBuilder_ == null) {
          ensureSelectedGroupKindsIsMutable();
          selectedGroupKinds_.remove(index);
          onChanged();
        } else {
          selectedGroupKindsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of cluster-scoped resource group kinds to restore from the
       * backup. If specified, only the selected resources will be restored.
       * Mutually exclusive to any other field in the message.
       * </pre>
       *
       * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind selected_group_kinds = 1;
       * </code>
       */
      public com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind.Builder
          getSelectedGroupKindsBuilder(int index) {
        return getSelectedGroupKindsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * A list of cluster-scoped resource group kinds to restore from the
       * backup. If specified, only the selected resources will be restored.
       * Mutually exclusive to any other field in the message.
       * </pre>
       *
       * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind selected_group_kinds = 1;
       * </code>
       */
      public com.google.cloud.gkebackup.v1.RestoreConfig.GroupKindOrBuilder
          getSelectedGroupKindsOrBuilder(int index) {
        if (selectedGroupKindsBuilder_ == null) {
          return selectedGroupKinds_.get(index);
        } else {
          return selectedGroupKindsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * A list of cluster-scoped resource group kinds to restore from the
       * backup. If specified, only the selected resources will be restored.
       * Mutually exclusive to any other field in the message.
       * </pre>
       *
       * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind selected_group_kinds = 1;
       * </code>
       */
      public java.util.List<
              ? extends com.google.cloud.gkebackup.v1.RestoreConfig.GroupKindOrBuilder>
          getSelectedGroupKindsOrBuilderList() {
        if (selectedGroupKindsBuilder_ != null) {
          return selectedGroupKindsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(selectedGroupKinds_);
        }
      }
      /**
       *
       *
       * <pre>
       * A list of cluster-scoped resource group kinds to restore from the
       * backup. If specified, only the selected resources will be restored.
       * Mutually exclusive to any other field in the message.
       * </pre>
       *
       * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind selected_group_kinds = 1;
       * </code>
       */
      public com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind.Builder
          addSelectedGroupKindsBuilder() {
        return getSelectedGroupKindsFieldBuilder()
            .addBuilder(com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * A list of cluster-scoped resource group kinds to restore from the
       * backup. If specified, only the selected resources will be restored.
       * Mutually exclusive to any other field in the message.
       * </pre>
       *
       * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind selected_group_kinds = 1;
       * </code>
       */
      public com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind.Builder
          addSelectedGroupKindsBuilder(int index) {
        return getSelectedGroupKindsFieldBuilder()
            .addBuilder(
                index, com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * A list of cluster-scoped resource group kinds to restore from the
       * backup. If specified, only the selected resources will be restored.
       * Mutually exclusive to any other field in the message.
       * </pre>
       *
       * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind selected_group_kinds = 1;
       * </code>
       */
      public java.util.List<com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind.Builder>
          getSelectedGroupKindsBuilderList() {
        return getSelectedGroupKindsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind,
              com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind.Builder,
              com.google.cloud.gkebackup.v1.RestoreConfig.GroupKindOrBuilder>
          getSelectedGroupKindsFieldBuilder() {
        if (selectedGroupKindsBuilder_ == null) {
          selectedGroupKindsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind,
                  com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind.Builder,
                  com.google.cloud.gkebackup.v1.RestoreConfig.GroupKindOrBuilder>(
                  selectedGroupKinds_,
                  ((bitField0_ & 0x00000001) != 0),
                  getParentForChildren(),
                  isClean());
          selectedGroupKinds_ = null;
        }
        return selectedGroupKindsBuilder_;
      }

      private java.util.List<com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind>
          excludedGroupKinds_ = java.util.Collections.emptyList();

      private void ensureExcludedGroupKindsIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          excludedGroupKinds_ =
              new java.util.ArrayList<com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind>(
                  excludedGroupKinds_);
          bitField0_ |= 0x00000002;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind,
              com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind.Builder,
              com.google.cloud.gkebackup.v1.RestoreConfig.GroupKindOrBuilder>
          excludedGroupKindsBuilder_;

      /**
       *
       *
       * <pre>
       * A list of cluster-scoped resource group kinds to NOT restore from the
       * backup. If specified, all valid cluster-scoped resources will be
       * restored except for those specified in the list.
       * Mutually exclusive to any other field in the message.
       * </pre>
       *
       * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind excluded_group_kinds = 2;
       * </code>
       */
      public java.util.List<com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind>
          getExcludedGroupKindsList() {
        if (excludedGroupKindsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(excludedGroupKinds_);
        } else {
          return excludedGroupKindsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * A list of cluster-scoped resource group kinds to NOT restore from the
       * backup. If specified, all valid cluster-scoped resources will be
       * restored except for those specified in the list.
       * Mutually exclusive to any other field in the message.
       * </pre>
       *
       * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind excluded_group_kinds = 2;
       * </code>
       */
      public int getExcludedGroupKindsCount() {
        if (excludedGroupKindsBuilder_ == null) {
          return excludedGroupKinds_.size();
        } else {
          return excludedGroupKindsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * A list of cluster-scoped resource group kinds to NOT restore from the
       * backup. If specified, all valid cluster-scoped resources will be
       * restored except for those specified in the list.
       * Mutually exclusive to any other field in the message.
       * </pre>
       *
       * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind excluded_group_kinds = 2;
       * </code>
       */
      public com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind getExcludedGroupKinds(
          int index) {
        if (excludedGroupKindsBuilder_ == null) {
          return excludedGroupKinds_.get(index);
        } else {
          return excludedGroupKindsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * A list of cluster-scoped resource group kinds to NOT restore from the
       * backup. If specified, all valid cluster-scoped resources will be
       * restored except for those specified in the list.
       * Mutually exclusive to any other field in the message.
       * </pre>
       *
       * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind excluded_group_kinds = 2;
       * </code>
       */
      public Builder setExcludedGroupKinds(
          int index, com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind value) {
        if (excludedGroupKindsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureExcludedGroupKindsIsMutable();
          excludedGroupKinds_.set(index, value);
          onChanged();
        } else {
          excludedGroupKindsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of cluster-scoped resource group kinds to NOT restore from the
       * backup. If specified, all valid cluster-scoped resources will be
       * restored except for those specified in the list.
       * Mutually exclusive to any other field in the message.
       * </pre>
       *
       * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind excluded_group_kinds = 2;
       * </code>
       */
      public Builder setExcludedGroupKinds(
          int index,
          com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind.Builder builderForValue) {
        if (excludedGroupKindsBuilder_ == null) {
          ensureExcludedGroupKindsIsMutable();
          excludedGroupKinds_.set(index, builderForValue.build());
          onChanged();
        } else {
          excludedGroupKindsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of cluster-scoped resource group kinds to NOT restore from the
       * backup. If specified, all valid cluster-scoped resources will be
       * restored except for those specified in the list.
       * Mutually exclusive to any other field in the message.
       * </pre>
       *
       * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind excluded_group_kinds = 2;
       * </code>
       */
      public Builder addExcludedGroupKinds(
          com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind value) {
        if (excludedGroupKindsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureExcludedGroupKindsIsMutable();
          excludedGroupKinds_.add(value);
          onChanged();
        } else {
          excludedGroupKindsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of cluster-scoped resource group kinds to NOT restore from the
       * backup. If specified, all valid cluster-scoped resources will be
       * restored except for those specified in the list.
       * Mutually exclusive to any other field in the message.
       * </pre>
       *
       * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind excluded_group_kinds = 2;
       * </code>
       */
      public Builder addExcludedGroupKinds(
          int index, com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind value) {
        if (excludedGroupKindsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureExcludedGroupKindsIsMutable();
          excludedGroupKinds_.add(index, value);
          onChanged();
        } else {
          excludedGroupKindsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of cluster-scoped resource group kinds to NOT restore from the
       * backup. If specified, all valid cluster-scoped resources will be
       * restored except for those specified in the list.
       * Mutually exclusive to any other field in the message.
       * </pre>
       *
       * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind excluded_group_kinds = 2;
       * </code>
       */
      public Builder addExcludedGroupKinds(
          com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind.Builder builderForValue) {
        if (excludedGroupKindsBuilder_ == null) {
          ensureExcludedGroupKindsIsMutable();
          excludedGroupKinds_.add(builderForValue.build());
          onChanged();
        } else {
          excludedGroupKindsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of cluster-scoped resource group kinds to NOT restore from the
       * backup. If specified, all valid cluster-scoped resources will be
       * restored except for those specified in the list.
       * Mutually exclusive to any other field in the message.
       * </pre>
       *
       * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind excluded_group_kinds = 2;
       * </code>
       */
      public Builder addExcludedGroupKinds(
          int index,
          com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind.Builder builderForValue) {
        if (excludedGroupKindsBuilder_ == null) {
          ensureExcludedGroupKindsIsMutable();
          excludedGroupKinds_.add(index, builderForValue.build());
          onChanged();
        } else {
          excludedGroupKindsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of cluster-scoped resource group kinds to NOT restore from the
       * backup. If specified, all valid cluster-scoped resources will be
       * restored except for those specified in the list.
       * Mutually exclusive to any other field in the message.
       * </pre>
       *
       * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind excluded_group_kinds = 2;
       * </code>
       */
      public Builder addAllExcludedGroupKinds(
          java.lang.Iterable<? extends com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind>
              values) {
        if (excludedGroupKindsBuilder_ == null) {
          ensureExcludedGroupKindsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, excludedGroupKinds_);
          onChanged();
        } else {
          excludedGroupKindsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of cluster-scoped resource group kinds to NOT restore from the
       * backup. If specified, all valid cluster-scoped resources will be
       * restored except for those specified in the list.
       * Mutually exclusive to any other field in the message.
       * </pre>
       *
       * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind excluded_group_kinds = 2;
       * </code>
       */
      public Builder clearExcludedGroupKinds() {
        if (excludedGroupKindsBuilder_ == null) {
          excludedGroupKinds_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          excludedGroupKindsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of cluster-scoped resource group kinds to NOT restore from the
       * backup. If specified, all valid cluster-scoped resources will be
       * restored except for those specified in the list.
       * Mutually exclusive to any other field in the message.
       * </pre>
       *
       * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind excluded_group_kinds = 2;
       * </code>
       */
      public Builder removeExcludedGroupKinds(int index) {
        if (excludedGroupKindsBuilder_ == null) {
          ensureExcludedGroupKindsIsMutable();
          excludedGroupKinds_.remove(index);
          onChanged();
        } else {
          excludedGroupKindsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of cluster-scoped resource group kinds to NOT restore from the
       * backup. If specified, all valid cluster-scoped resources will be
       * restored except for those specified in the list.
       * Mutually exclusive to any other field in the message.
       * </pre>
       *
       * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind excluded_group_kinds = 2;
       * </code>
       */
      public com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind.Builder
          getExcludedGroupKindsBuilder(int index) {
        return getExcludedGroupKindsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * A list of cluster-scoped resource group kinds to NOT restore from the
       * backup. If specified, all valid cluster-scoped resources will be
       * restored except for those specified in the list.
       * Mutually exclusive to any other field in the message.
       * </pre>
       *
       * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind excluded_group_kinds = 2;
       * </code>
       */
      public com.google.cloud.gkebackup.v1.RestoreConfig.GroupKindOrBuilder
          getExcludedGroupKindsOrBuilder(int index) {
        if (excludedGroupKindsBuilder_ == null) {
          return excludedGroupKinds_.get(index);
        } else {
          return excludedGroupKindsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * A list of cluster-scoped resource group kinds to NOT restore from the
       * backup. If specified, all valid cluster-scoped resources will be
       * restored except for those specified in the list.
       * Mutually exclusive to any other field in the message.
       * </pre>
       *
       * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind excluded_group_kinds = 2;
       * </code>
       */
      public java.util.List<
              ? extends com.google.cloud.gkebackup.v1.RestoreConfig.GroupKindOrBuilder>
          getExcludedGroupKindsOrBuilderList() {
        if (excludedGroupKindsBuilder_ != null) {
          return excludedGroupKindsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(excludedGroupKinds_);
        }
      }
      /**
       *
       *
       * <pre>
       * A list of cluster-scoped resource group kinds to NOT restore from the
       * backup. If specified, all valid cluster-scoped resources will be
       * restored except for those specified in the list.
       * Mutually exclusive to any other field in the message.
       * </pre>
       *
       * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind excluded_group_kinds = 2;
       * </code>
       */
      public com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind.Builder
          addExcludedGroupKindsBuilder() {
        return getExcludedGroupKindsFieldBuilder()
            .addBuilder(com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * A list of cluster-scoped resource group kinds to NOT restore from the
       * backup. If specified, all valid cluster-scoped resources will be
       * restored except for those specified in the list.
       * Mutually exclusive to any other field in the message.
       * </pre>
       *
       * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind excluded_group_kinds = 2;
       * </code>
       */
      public com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind.Builder
          addExcludedGroupKindsBuilder(int index) {
        return getExcludedGroupKindsFieldBuilder()
            .addBuilder(
                index, com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * A list of cluster-scoped resource group kinds to NOT restore from the
       * backup. If specified, all valid cluster-scoped resources will be
       * restored except for those specified in the list.
       * Mutually exclusive to any other field in the message.
       * </pre>
       *
       * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind excluded_group_kinds = 2;
       * </code>
       */
      public java.util.List<com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind.Builder>
          getExcludedGroupKindsBuilderList() {
        return getExcludedGroupKindsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind,
              com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind.Builder,
              com.google.cloud.gkebackup.v1.RestoreConfig.GroupKindOrBuilder>
          getExcludedGroupKindsFieldBuilder() {
        if (excludedGroupKindsBuilder_ == null) {
          excludedGroupKindsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind,
                  com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind.Builder,
                  com.google.cloud.gkebackup.v1.RestoreConfig.GroupKindOrBuilder>(
                  excludedGroupKinds_,
                  ((bitField0_ & 0x00000002) != 0),
                  getParentForChildren(),
                  isClean());
          excludedGroupKinds_ = null;
        }
        return excludedGroupKindsBuilder_;
      }

      private boolean allGroupKinds_;
      /**
       *
       *
       * <pre>
       * If True, all valid cluster-scoped resources will be restored.
       * Mutually exclusive to any other field in the message.
       * </pre>
       *
       * <code>bool all_group_kinds = 3;</code>
       *
       * @return The allGroupKinds.
       */
      @java.lang.Override
      public boolean getAllGroupKinds() {
        return allGroupKinds_;
      }
      /**
       *
       *
       * <pre>
       * If True, all valid cluster-scoped resources will be restored.
       * Mutually exclusive to any other field in the message.
       * </pre>
       *
       * <code>bool all_group_kinds = 3;</code>
       *
       * @param value The allGroupKinds to set.
       * @return This builder for chaining.
       */
      public Builder setAllGroupKinds(boolean value) {

        allGroupKinds_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If True, all valid cluster-scoped resources will be restored.
       * Mutually exclusive to any other field in the message.
       * </pre>
       *
       * <code>bool all_group_kinds = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAllGroupKinds() {
        bitField0_ = (bitField0_ & ~0x00000004);
        allGroupKinds_ = false;
        onChanged();
        return this;
      }

      private boolean noGroupKinds_;
      /**
       *
       *
       * <pre>
       * If True, no cluster-scoped resources will be restored.
       * This has the same restore scope as if the message is not defined.
       * Mutually exclusive to any other field in the message.
       * </pre>
       *
       * <code>bool no_group_kinds = 4;</code>
       *
       * @return The noGroupKinds.
       */
      @java.lang.Override
      public boolean getNoGroupKinds() {
        return noGroupKinds_;
      }
      /**
       *
       *
       * <pre>
       * If True, no cluster-scoped resources will be restored.
       * This has the same restore scope as if the message is not defined.
       * Mutually exclusive to any other field in the message.
       * </pre>
       *
       * <code>bool no_group_kinds = 4;</code>
       *
       * @param value The noGroupKinds to set.
       * @return This builder for chaining.
       */
      public Builder setNoGroupKinds(boolean value) {

        noGroupKinds_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If True, no cluster-scoped resources will be restored.
       * This has the same restore scope as if the message is not defined.
       * Mutually exclusive to any other field in the message.
       * </pre>
       *
       * <code>bool no_group_kinds = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearNoGroupKinds() {
        bitField0_ = (bitField0_ & ~0x00000008);
        noGroupKinds_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope)
    private static final com.google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope();
    }

    public static com.google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ClusterResourceRestoreScope> PARSER =
        new com.google.protobuf.AbstractParser<ClusterResourceRestoreScope>() {
          @java.lang.Override
          public ClusterResourceRestoreScope parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ClusterResourceRestoreScope> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ClusterResourceRestoreScope> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface SubstitutionRuleOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * (Filtering parameter) Any resource subject to substitution must be
     * contained within one of the listed Kubernetes Namespace in the Backup.
     * If this field is not provided, no namespace filtering will be performed
     * (all resources in all Namespaces, including all cluster-scoped resources,
     * will be candidates for substitution).
     * To mix cluster-scoped and namespaced resources in the same rule, use an
     * empty string ("") as one of the target namespaces.
     * </pre>
     *
     * <code>repeated string target_namespaces = 1;</code>
     *
     * @return A list containing the targetNamespaces.
     */
    java.util.List<java.lang.String> getTargetNamespacesList();
    /**
     *
     *
     * <pre>
     * (Filtering parameter) Any resource subject to substitution must be
     * contained within one of the listed Kubernetes Namespace in the Backup.
     * If this field is not provided, no namespace filtering will be performed
     * (all resources in all Namespaces, including all cluster-scoped resources,
     * will be candidates for substitution).
     * To mix cluster-scoped and namespaced resources in the same rule, use an
     * empty string ("") as one of the target namespaces.
     * </pre>
     *
     * <code>repeated string target_namespaces = 1;</code>
     *
     * @return The count of targetNamespaces.
     */
    int getTargetNamespacesCount();
    /**
     *
     *
     * <pre>
     * (Filtering parameter) Any resource subject to substitution must be
     * contained within one of the listed Kubernetes Namespace in the Backup.
     * If this field is not provided, no namespace filtering will be performed
     * (all resources in all Namespaces, including all cluster-scoped resources,
     * will be candidates for substitution).
     * To mix cluster-scoped and namespaced resources in the same rule, use an
     * empty string ("") as one of the target namespaces.
     * </pre>
     *
     * <code>repeated string target_namespaces = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The targetNamespaces at the given index.
     */
    java.lang.String getTargetNamespaces(int index);
    /**
     *
     *
     * <pre>
     * (Filtering parameter) Any resource subject to substitution must be
     * contained within one of the listed Kubernetes Namespace in the Backup.
     * If this field is not provided, no namespace filtering will be performed
     * (all resources in all Namespaces, including all cluster-scoped resources,
     * will be candidates for substitution).
     * To mix cluster-scoped and namespaced resources in the same rule, use an
     * empty string ("") as one of the target namespaces.
     * </pre>
     *
     * <code>repeated string target_namespaces = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the targetNamespaces at the given index.
     */
    com.google.protobuf.ByteString getTargetNamespacesBytes(int index);

    /**
     *
     *
     * <pre>
     * (Filtering parameter) Any resource subject to substitution must belong to
     * one of the listed "types".
     * If this field is not provided, no type filtering will be performed (all
     * resources of all types matching previous filtering parameters will be
     * candidates for substitution).
     * </pre>
     *
     * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind target_group_kinds = 2;
     * </code>
     */
    java.util.List<com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind> getTargetGroupKindsList();
    /**
     *
     *
     * <pre>
     * (Filtering parameter) Any resource subject to substitution must belong to
     * one of the listed "types".
     * If this field is not provided, no type filtering will be performed (all
     * resources of all types matching previous filtering parameters will be
     * candidates for substitution).
     * </pre>
     *
     * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind target_group_kinds = 2;
     * </code>
     */
    com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind getTargetGroupKinds(int index);
    /**
     *
     *
     * <pre>
     * (Filtering parameter) Any resource subject to substitution must belong to
     * one of the listed "types".
     * If this field is not provided, no type filtering will be performed (all
     * resources of all types matching previous filtering parameters will be
     * candidates for substitution).
     * </pre>
     *
     * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind target_group_kinds = 2;
     * </code>
     */
    int getTargetGroupKindsCount();
    /**
     *
     *
     * <pre>
     * (Filtering parameter) Any resource subject to substitution must belong to
     * one of the listed "types".
     * If this field is not provided, no type filtering will be performed (all
     * resources of all types matching previous filtering parameters will be
     * candidates for substitution).
     * </pre>
     *
     * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind target_group_kinds = 2;
     * </code>
     */
    java.util.List<? extends com.google.cloud.gkebackup.v1.RestoreConfig.GroupKindOrBuilder>
        getTargetGroupKindsOrBuilderList();
    /**
     *
     *
     * <pre>
     * (Filtering parameter) Any resource subject to substitution must belong to
     * one of the listed "types".
     * If this field is not provided, no type filtering will be performed (all
     * resources of all types matching previous filtering parameters will be
     * candidates for substitution).
     * </pre>
     *
     * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind target_group_kinds = 2;
     * </code>
     */
    com.google.cloud.gkebackup.v1.RestoreConfig.GroupKindOrBuilder getTargetGroupKindsOrBuilder(
        int index);

    /**
     *
     *
     * <pre>
     * Required. This is a [JSONPath]
     * (https://kubernetes.io/docs/reference/kubectl/jsonpath/)
     * expression that matches specific fields of candidate
     * resources and it operates as both a filtering parameter (resources that
     * are not matched with this expression will not be candidates for
     * substitution) as well as a field identifier (identifies exactly which
     * fields out of the candidate resources will be modified).
     * </pre>
     *
     * <code>string target_json_path = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The targetJsonPath.
     */
    java.lang.String getTargetJsonPath();
    /**
     *
     *
     * <pre>
     * Required. This is a [JSONPath]
     * (https://kubernetes.io/docs/reference/kubectl/jsonpath/)
     * expression that matches specific fields of candidate
     * resources and it operates as both a filtering parameter (resources that
     * are not matched with this expression will not be candidates for
     * substitution) as well as a field identifier (identifies exactly which
     * fields out of the candidate resources will be modified).
     * </pre>
     *
     * <code>string target_json_path = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for targetJsonPath.
     */
    com.google.protobuf.ByteString getTargetJsonPathBytes();

    /**
     *
     *
     * <pre>
     * (Filtering parameter) This is a [regular expression]
     * (https://en.wikipedia.org/wiki/Regular_expression)
     * that is compared against the fields matched by the target_json_path
     * expression (and must also have passed the previous filters).
     * Substitution will not be performed against fields whose
     * value does not match this expression. If this field is NOT specified,
     * then ALL fields matched by the target_json_path expression will undergo
     * substitution. Note that an empty (e.g., "", rather than unspecified)
     * value for this field will only match empty fields.
     * </pre>
     *
     * <code>string original_value_pattern = 4;</code>
     *
     * @return The originalValuePattern.
     */
    java.lang.String getOriginalValuePattern();
    /**
     *
     *
     * <pre>
     * (Filtering parameter) This is a [regular expression]
     * (https://en.wikipedia.org/wiki/Regular_expression)
     * that is compared against the fields matched by the target_json_path
     * expression (and must also have passed the previous filters).
     * Substitution will not be performed against fields whose
     * value does not match this expression. If this field is NOT specified,
     * then ALL fields matched by the target_json_path expression will undergo
     * substitution. Note that an empty (e.g., "", rather than unspecified)
     * value for this field will only match empty fields.
     * </pre>
     *
     * <code>string original_value_pattern = 4;</code>
     *
     * @return The bytes for originalValuePattern.
     */
    com.google.protobuf.ByteString getOriginalValuePatternBytes();

    /**
     *
     *
     * <pre>
     * This is the new value to set for any fields that pass the filtering and
     * selection criteria. To remove a value from a Kubernetes resource, either
     * leave this field unspecified, or set it to the empty string ("").
     * </pre>
     *
     * <code>string new_value = 5;</code>
     *
     * @return The newValue.
     */
    java.lang.String getNewValue();
    /**
     *
     *
     * <pre>
     * This is the new value to set for any fields that pass the filtering and
     * selection criteria. To remove a value from a Kubernetes resource, either
     * leave this field unspecified, or set it to the empty string ("").
     * </pre>
     *
     * <code>string new_value = 5;</code>
     *
     * @return The bytes for newValue.
     */
    com.google.protobuf.ByteString getNewValueBytes();
  }
  /**
   *
   *
   * <pre>
   * A transformation rule to be applied against Kubernetes resources as they
   * are selected for restoration from a Backup. A rule contains both filtering
   * logic (which resources are subject to substitution) and substitution logic.
   * </pre>
   *
   * Protobuf type {@code google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule}
   */
  public static final class SubstitutionRule extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule)
      SubstitutionRuleOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use SubstitutionRule.newBuilder() to construct.
    private SubstitutionRule(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private SubstitutionRule() {
      targetNamespaces_ = com.google.protobuf.LazyStringArrayList.emptyList();
      targetGroupKinds_ = java.util.Collections.emptyList();
      targetJsonPath_ = "";
      originalValuePattern_ = "";
      newValue_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new SubstitutionRule();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.gkebackup.v1.RestoreProto
          .internal_static_google_cloud_gkebackup_v1_RestoreConfig_SubstitutionRule_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.gkebackup.v1.RestoreProto
          .internal_static_google_cloud_gkebackup_v1_RestoreConfig_SubstitutionRule_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule.class,
              com.google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule.Builder.class);
    }

    public static final int TARGET_NAMESPACES_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList targetNamespaces_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * (Filtering parameter) Any resource subject to substitution must be
     * contained within one of the listed Kubernetes Namespace in the Backup.
     * If this field is not provided, no namespace filtering will be performed
     * (all resources in all Namespaces, including all cluster-scoped resources,
     * will be candidates for substitution).
     * To mix cluster-scoped and namespaced resources in the same rule, use an
     * empty string ("") as one of the target namespaces.
     * </pre>
     *
     * <code>repeated string target_namespaces = 1;</code>
     *
     * @return A list containing the targetNamespaces.
     */
    public com.google.protobuf.ProtocolStringList getTargetNamespacesList() {
      return targetNamespaces_;
    }
    /**
     *
     *
     * <pre>
     * (Filtering parameter) Any resource subject to substitution must be
     * contained within one of the listed Kubernetes Namespace in the Backup.
     * If this field is not provided, no namespace filtering will be performed
     * (all resources in all Namespaces, including all cluster-scoped resources,
     * will be candidates for substitution).
     * To mix cluster-scoped and namespaced resources in the same rule, use an
     * empty string ("") as one of the target namespaces.
     * </pre>
     *
     * <code>repeated string target_namespaces = 1;</code>
     *
     * @return The count of targetNamespaces.
     */
    public int getTargetNamespacesCount() {
      return targetNamespaces_.size();
    }
    /**
     *
     *
     * <pre>
     * (Filtering parameter) Any resource subject to substitution must be
     * contained within one of the listed Kubernetes Namespace in the Backup.
     * If this field is not provided, no namespace filtering will be performed
     * (all resources in all Namespaces, including all cluster-scoped resources,
     * will be candidates for substitution).
     * To mix cluster-scoped and namespaced resources in the same rule, use an
     * empty string ("") as one of the target namespaces.
     * </pre>
     *
     * <code>repeated string target_namespaces = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The targetNamespaces at the given index.
     */
    public java.lang.String getTargetNamespaces(int index) {
      return targetNamespaces_.get(index);
    }
    /**
     *
     *
     * <pre>
     * (Filtering parameter) Any resource subject to substitution must be
     * contained within one of the listed Kubernetes Namespace in the Backup.
     * If this field is not provided, no namespace filtering will be performed
     * (all resources in all Namespaces, including all cluster-scoped resources,
     * will be candidates for substitution).
     * To mix cluster-scoped and namespaced resources in the same rule, use an
     * empty string ("") as one of the target namespaces.
     * </pre>
     *
     * <code>repeated string target_namespaces = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the targetNamespaces at the given index.
     */
    public com.google.protobuf.ByteString getTargetNamespacesBytes(int index) {
      return targetNamespaces_.getByteString(index);
    }

    public static final int TARGET_GROUP_KINDS_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind> targetGroupKinds_;
    /**
     *
     *
     * <pre>
     * (Filtering parameter) Any resource subject to substitution must belong to
     * one of the listed "types".
     * If this field is not provided, no type filtering will be performed (all
     * resources of all types matching previous filtering parameters will be
     * candidates for substitution).
     * </pre>
     *
     * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind target_group_kinds = 2;
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind>
        getTargetGroupKindsList() {
      return targetGroupKinds_;
    }
    /**
     *
     *
     * <pre>
     * (Filtering parameter) Any resource subject to substitution must belong to
     * one of the listed "types".
     * If this field is not provided, no type filtering will be performed (all
     * resources of all types matching previous filtering parameters will be
     * candidates for substitution).
     * </pre>
     *
     * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind target_group_kinds = 2;
     * </code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.cloud.gkebackup.v1.RestoreConfig.GroupKindOrBuilder>
        getTargetGroupKindsOrBuilderList() {
      return targetGroupKinds_;
    }
    /**
     *
     *
     * <pre>
     * (Filtering parameter) Any resource subject to substitution must belong to
     * one of the listed "types".
     * If this field is not provided, no type filtering will be performed (all
     * resources of all types matching previous filtering parameters will be
     * candidates for substitution).
     * </pre>
     *
     * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind target_group_kinds = 2;
     * </code>
     */
    @java.lang.Override
    public int getTargetGroupKindsCount() {
      return targetGroupKinds_.size();
    }
    /**
     *
     *
     * <pre>
     * (Filtering parameter) Any resource subject to substitution must belong to
     * one of the listed "types".
     * If this field is not provided, no type filtering will be performed (all
     * resources of all types matching previous filtering parameters will be
     * candidates for substitution).
     * </pre>
     *
     * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind target_group_kinds = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind getTargetGroupKinds(int index) {
      return targetGroupKinds_.get(index);
    }
    /**
     *
     *
     * <pre>
     * (Filtering parameter) Any resource subject to substitution must belong to
     * one of the listed "types".
     * If this field is not provided, no type filtering will be performed (all
     * resources of all types matching previous filtering parameters will be
     * candidates for substitution).
     * </pre>
     *
     * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind target_group_kinds = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.gkebackup.v1.RestoreConfig.GroupKindOrBuilder
        getTargetGroupKindsOrBuilder(int index) {
      return targetGroupKinds_.get(index);
    }

    public static final int TARGET_JSON_PATH_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object targetJsonPath_ = "";
    /**
     *
     *
     * <pre>
     * Required. This is a [JSONPath]
     * (https://kubernetes.io/docs/reference/kubectl/jsonpath/)
     * expression that matches specific fields of candidate
     * resources and it operates as both a filtering parameter (resources that
     * are not matched with this expression will not be candidates for
     * substitution) as well as a field identifier (identifies exactly which
     * fields out of the candidate resources will be modified).
     * </pre>
     *
     * <code>string target_json_path = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The targetJsonPath.
     */
    @java.lang.Override
    public java.lang.String getTargetJsonPath() {
      java.lang.Object ref = targetJsonPath_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        targetJsonPath_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. This is a [JSONPath]
     * (https://kubernetes.io/docs/reference/kubectl/jsonpath/)
     * expression that matches specific fields of candidate
     * resources and it operates as both a filtering parameter (resources that
     * are not matched with this expression will not be candidates for
     * substitution) as well as a field identifier (identifies exactly which
     * fields out of the candidate resources will be modified).
     * </pre>
     *
     * <code>string target_json_path = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for targetJsonPath.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTargetJsonPathBytes() {
      java.lang.Object ref = targetJsonPath_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        targetJsonPath_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ORIGINAL_VALUE_PATTERN_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private volatile java.lang.Object originalValuePattern_ = "";
    /**
     *
     *
     * <pre>
     * (Filtering parameter) This is a [regular expression]
     * (https://en.wikipedia.org/wiki/Regular_expression)
     * that is compared against the fields matched by the target_json_path
     * expression (and must also have passed the previous filters).
     * Substitution will not be performed against fields whose
     * value does not match this expression. If this field is NOT specified,
     * then ALL fields matched by the target_json_path expression will undergo
     * substitution. Note that an empty (e.g., "", rather than unspecified)
     * value for this field will only match empty fields.
     * </pre>
     *
     * <code>string original_value_pattern = 4;</code>
     *
     * @return The originalValuePattern.
     */
    @java.lang.Override
    public java.lang.String getOriginalValuePattern() {
      java.lang.Object ref = originalValuePattern_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        originalValuePattern_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * (Filtering parameter) This is a [regular expression]
     * (https://en.wikipedia.org/wiki/Regular_expression)
     * that is compared against the fields matched by the target_json_path
     * expression (and must also have passed the previous filters).
     * Substitution will not be performed against fields whose
     * value does not match this expression. If this field is NOT specified,
     * then ALL fields matched by the target_json_path expression will undergo
     * substitution. Note that an empty (e.g., "", rather than unspecified)
     * value for this field will only match empty fields.
     * </pre>
     *
     * <code>string original_value_pattern = 4;</code>
     *
     * @return The bytes for originalValuePattern.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getOriginalValuePatternBytes() {
      java.lang.Object ref = originalValuePattern_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        originalValuePattern_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int NEW_VALUE_FIELD_NUMBER = 5;

    @SuppressWarnings("serial")
    private volatile java.lang.Object newValue_ = "";
    /**
     *
     *
     * <pre>
     * This is the new value to set for any fields that pass the filtering and
     * selection criteria. To remove a value from a Kubernetes resource, either
     * leave this field unspecified, or set it to the empty string ("").
     * </pre>
     *
     * <code>string new_value = 5;</code>
     *
     * @return The newValue.
     */
    @java.lang.Override
    public java.lang.String getNewValue() {
      java.lang.Object ref = newValue_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        newValue_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * This is the new value to set for any fields that pass the filtering and
     * selection criteria. To remove a value from a Kubernetes resource, either
     * leave this field unspecified, or set it to the empty string ("").
     * </pre>
     *
     * <code>string new_value = 5;</code>
     *
     * @return The bytes for newValue.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNewValueBytes() {
      java.lang.Object ref = newValue_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        newValue_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < targetNamespaces_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, targetNamespaces_.getRaw(i));
      }
      for (int i = 0; i < targetGroupKinds_.size(); i++) {
        output.writeMessage(2, targetGroupKinds_.get(i));
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(targetJsonPath_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, targetJsonPath_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(originalValuePattern_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, originalValuePattern_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(newValue_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, newValue_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      {
        int dataSize = 0;
        for (int i = 0; i < targetNamespaces_.size(); i++) {
          dataSize += computeStringSizeNoTag(targetNamespaces_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getTargetNamespacesList().size();
      }
      for (int i = 0; i < targetGroupKinds_.size(); i++) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(2, targetGroupKinds_.get(i));
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(targetJsonPath_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, targetJsonPath_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(originalValuePattern_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, originalValuePattern_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(newValue_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, newValue_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule)) {
        return super.equals(obj);
      }
      com.google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule other =
          (com.google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule) obj;

      if (!getTargetNamespacesList().equals(other.getTargetNamespacesList())) return false;
      if (!getTargetGroupKindsList().equals(other.getTargetGroupKindsList())) return false;
      if (!getTargetJsonPath().equals(other.getTargetJsonPath())) return false;
      if (!getOriginalValuePattern().equals(other.getOriginalValuePattern())) return false;
      if (!getNewValue().equals(other.getNewValue())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getTargetNamespacesCount() > 0) {
        hash = (37 * hash) + TARGET_NAMESPACES_FIELD_NUMBER;
        hash = (53 * hash) + getTargetNamespacesList().hashCode();
      }
      if (getTargetGroupKindsCount() > 0) {
        hash = (37 * hash) + TARGET_GROUP_KINDS_FIELD_NUMBER;
        hash = (53 * hash) + getTargetGroupKindsList().hashCode();
      }
      hash = (37 * hash) + TARGET_JSON_PATH_FIELD_NUMBER;
      hash = (53 * hash) + getTargetJsonPath().hashCode();
      hash = (37 * hash) + ORIGINAL_VALUE_PATTERN_FIELD_NUMBER;
      hash = (53 * hash) + getOriginalValuePattern().hashCode();
      hash = (37 * hash) + NEW_VALUE_FIELD_NUMBER;
      hash = (53 * hash) + getNewValue().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A transformation rule to be applied against Kubernetes resources as they
     * are selected for restoration from a Backup. A rule contains both filtering
     * logic (which resources are subject to substitution) and substitution logic.
     * </pre>
     *
     * Protobuf type {@code google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule)
        com.google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRuleOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.gkebackup.v1.RestoreProto
            .internal_static_google_cloud_gkebackup_v1_RestoreConfig_SubstitutionRule_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.gkebackup.v1.RestoreProto
            .internal_static_google_cloud_gkebackup_v1_RestoreConfig_SubstitutionRule_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule.class,
                com.google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule.Builder.class);
      }

      // Construct using com.google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        targetNamespaces_ = com.google.protobuf.LazyStringArrayList.emptyList();
        if (targetGroupKindsBuilder_ == null) {
          targetGroupKinds_ = java.util.Collections.emptyList();
        } else {
          targetGroupKinds_ = null;
          targetGroupKindsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        targetJsonPath_ = "";
        originalValuePattern_ = "";
        newValue_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.gkebackup.v1.RestoreProto
            .internal_static_google_cloud_gkebackup_v1_RestoreConfig_SubstitutionRule_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule
          getDefaultInstanceForType() {
        return com.google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule build() {
        com.google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule buildPartial() {
        com.google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule result =
            new com.google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule result) {
        if (targetGroupKindsBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)) {
            targetGroupKinds_ = java.util.Collections.unmodifiableList(targetGroupKinds_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.targetGroupKinds_ = targetGroupKinds_;
        } else {
          result.targetGroupKinds_ = targetGroupKindsBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          targetNamespaces_.makeImmutable();
          result.targetNamespaces_ = targetNamespaces_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.targetJsonPath_ = targetJsonPath_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.originalValuePattern_ = originalValuePattern_;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.newValue_ = newValue_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule) {
          return mergeFrom((com.google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule other) {
        if (other
            == com.google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule.getDefaultInstance())
          return this;
        if (!other.targetNamespaces_.isEmpty()) {
          if (targetNamespaces_.isEmpty()) {
            targetNamespaces_ = other.targetNamespaces_;
            bitField0_ |= 0x00000001;
          } else {
            ensureTargetNamespacesIsMutable();
            targetNamespaces_.addAll(other.targetNamespaces_);
          }
          onChanged();
        }
        if (targetGroupKindsBuilder_ == null) {
          if (!other.targetGroupKinds_.isEmpty()) {
            if (targetGroupKinds_.isEmpty()) {
              targetGroupKinds_ = other.targetGroupKinds_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureTargetGroupKindsIsMutable();
              targetGroupKinds_.addAll(other.targetGroupKinds_);
            }
            onChanged();
          }
        } else {
          if (!other.targetGroupKinds_.isEmpty()) {
            if (targetGroupKindsBuilder_.isEmpty()) {
              targetGroupKindsBuilder_.dispose();
              targetGroupKindsBuilder_ = null;
              targetGroupKinds_ = other.targetGroupKinds_;
              bitField0_ = (bitField0_ & ~0x00000002);
              targetGroupKindsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getTargetGroupKindsFieldBuilder()
                      : null;
            } else {
              targetGroupKindsBuilder_.addAllMessages(other.targetGroupKinds_);
            }
          }
        }
        if (!other.getTargetJsonPath().isEmpty()) {
          targetJsonPath_ = other.targetJsonPath_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        if (!other.getOriginalValuePattern().isEmpty()) {
          originalValuePattern_ = other.originalValuePattern_;
          bitField0_ |= 0x00000008;
          onChanged();
        }
        if (!other.getNewValue().isEmpty()) {
          newValue_ = other.newValue_;
          bitField0_ |= 0x00000010;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureTargetNamespacesIsMutable();
                  targetNamespaces_.add(s);
                  break;
                } // case 10
              case 18:
                {
                  com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind m =
                      input.readMessage(
                          com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind.parser(),
                          extensionRegistry);
                  if (targetGroupKindsBuilder_ == null) {
                    ensureTargetGroupKindsIsMutable();
                    targetGroupKinds_.add(m);
                  } else {
                    targetGroupKindsBuilder_.addMessage(m);
                  }
                  break;
                } // case 18
              case 26:
                {
                  targetJsonPath_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  originalValuePattern_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              case 42:
                {
                  newValue_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000010;
                  break;
                } // case 42
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.LazyStringArrayList targetNamespaces_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureTargetNamespacesIsMutable() {
        if (!targetNamespaces_.isModifiable()) {
          targetNamespaces_ = new com.google.protobuf.LazyStringArrayList(targetNamespaces_);
        }
        bitField0_ |= 0x00000001;
      }
      /**
       *
       *
       * <pre>
       * (Filtering parameter) Any resource subject to substitution must be
       * contained within one of the listed Kubernetes Namespace in the Backup.
       * If this field is not provided, no namespace filtering will be performed
       * (all resources in all Namespaces, including all cluster-scoped resources,
       * will be candidates for substitution).
       * To mix cluster-scoped and namespaced resources in the same rule, use an
       * empty string ("") as one of the target namespaces.
       * </pre>
       *
       * <code>repeated string target_namespaces = 1;</code>
       *
       * @return A list containing the targetNamespaces.
       */
      public com.google.protobuf.ProtocolStringList getTargetNamespacesList() {
        targetNamespaces_.makeImmutable();
        return targetNamespaces_;
      }
      /**
       *
       *
       * <pre>
       * (Filtering parameter) Any resource subject to substitution must be
       * contained within one of the listed Kubernetes Namespace in the Backup.
       * If this field is not provided, no namespace filtering will be performed
       * (all resources in all Namespaces, including all cluster-scoped resources,
       * will be candidates for substitution).
       * To mix cluster-scoped and namespaced resources in the same rule, use an
       * empty string ("") as one of the target namespaces.
       * </pre>
       *
       * <code>repeated string target_namespaces = 1;</code>
       *
       * @return The count of targetNamespaces.
       */
      public int getTargetNamespacesCount() {
        return targetNamespaces_.size();
      }
      /**
       *
       *
       * <pre>
       * (Filtering parameter) Any resource subject to substitution must be
       * contained within one of the listed Kubernetes Namespace in the Backup.
       * If this field is not provided, no namespace filtering will be performed
       * (all resources in all Namespaces, including all cluster-scoped resources,
       * will be candidates for substitution).
       * To mix cluster-scoped and namespaced resources in the same rule, use an
       * empty string ("") as one of the target namespaces.
       * </pre>
       *
       * <code>repeated string target_namespaces = 1;</code>
       *
       * @param index The index of the element to return.
       * @return The targetNamespaces at the given index.
       */
      public java.lang.String getTargetNamespaces(int index) {
        return targetNamespaces_.get(index);
      }
      /**
       *
       *
       * <pre>
       * (Filtering parameter) Any resource subject to substitution must be
       * contained within one of the listed Kubernetes Namespace in the Backup.
       * If this field is not provided, no namespace filtering will be performed
       * (all resources in all Namespaces, including all cluster-scoped resources,
       * will be candidates for substitution).
       * To mix cluster-scoped and namespaced resources in the same rule, use an
       * empty string ("") as one of the target namespaces.
       * </pre>
       *
       * <code>repeated string target_namespaces = 1;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the targetNamespaces at the given index.
       */
      public com.google.protobuf.ByteString getTargetNamespacesBytes(int index) {
        return targetNamespaces_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * (Filtering parameter) Any resource subject to substitution must be
       * contained within one of the listed Kubernetes Namespace in the Backup.
       * If this field is not provided, no namespace filtering will be performed
       * (all resources in all Namespaces, including all cluster-scoped resources,
       * will be candidates for substitution).
       * To mix cluster-scoped and namespaced resources in the same rule, use an
       * empty string ("") as one of the target namespaces.
       * </pre>
       *
       * <code>repeated string target_namespaces = 1;</code>
       *
       * @param index The index to set the value at.
       * @param value The targetNamespaces to set.
       * @return This builder for chaining.
       */
      public Builder setTargetNamespaces(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTargetNamespacesIsMutable();
        targetNamespaces_.set(index, value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * (Filtering parameter) Any resource subject to substitution must be
       * contained within one of the listed Kubernetes Namespace in the Backup.
       * If this field is not provided, no namespace filtering will be performed
       * (all resources in all Namespaces, including all cluster-scoped resources,
       * will be candidates for substitution).
       * To mix cluster-scoped and namespaced resources in the same rule, use an
       * empty string ("") as one of the target namespaces.
       * </pre>
       *
       * <code>repeated string target_namespaces = 1;</code>
       *
       * @param value The targetNamespaces to add.
       * @return This builder for chaining.
       */
      public Builder addTargetNamespaces(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTargetNamespacesIsMutable();
        targetNamespaces_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * (Filtering parameter) Any resource subject to substitution must be
       * contained within one of the listed Kubernetes Namespace in the Backup.
       * If this field is not provided, no namespace filtering will be performed
       * (all resources in all Namespaces, including all cluster-scoped resources,
       * will be candidates for substitution).
       * To mix cluster-scoped and namespaced resources in the same rule, use an
       * empty string ("") as one of the target namespaces.
       * </pre>
       *
       * <code>repeated string target_namespaces = 1;</code>
       *
       * @param values The targetNamespaces to add.
       * @return This builder for chaining.
       */
      public Builder addAllTargetNamespaces(java.lang.Iterable<java.lang.String> values) {
        ensureTargetNamespacesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, targetNamespaces_);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * (Filtering parameter) Any resource subject to substitution must be
       * contained within one of the listed Kubernetes Namespace in the Backup.
       * If this field is not provided, no namespace filtering will be performed
       * (all resources in all Namespaces, including all cluster-scoped resources,
       * will be candidates for substitution).
       * To mix cluster-scoped and namespaced resources in the same rule, use an
       * empty string ("") as one of the target namespaces.
       * </pre>
       *
       * <code>repeated string target_namespaces = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTargetNamespaces() {
        targetNamespaces_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * (Filtering parameter) Any resource subject to substitution must be
       * contained within one of the listed Kubernetes Namespace in the Backup.
       * If this field is not provided, no namespace filtering will be performed
       * (all resources in all Namespaces, including all cluster-scoped resources,
       * will be candidates for substitution).
       * To mix cluster-scoped and namespaced resources in the same rule, use an
       * empty string ("") as one of the target namespaces.
       * </pre>
       *
       * <code>repeated string target_namespaces = 1;</code>
       *
       * @param value The bytes of the targetNamespaces to add.
       * @return This builder for chaining.
       */
      public Builder addTargetNamespacesBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureTargetNamespacesIsMutable();
        targetNamespaces_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.util.List<com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind>
          targetGroupKinds_ = java.util.Collections.emptyList();

      private void ensureTargetGroupKindsIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          targetGroupKinds_ =
              new java.util.ArrayList<com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind>(
                  targetGroupKinds_);
          bitField0_ |= 0x00000002;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind,
              com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind.Builder,
              com.google.cloud.gkebackup.v1.RestoreConfig.GroupKindOrBuilder>
          targetGroupKindsBuilder_;

      /**
       *
       *
       * <pre>
       * (Filtering parameter) Any resource subject to substitution must belong to
       * one of the listed "types".
       * If this field is not provided, no type filtering will be performed (all
       * resources of all types matching previous filtering parameters will be
       * candidates for substitution).
       * </pre>
       *
       * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind target_group_kinds = 2;
       * </code>
       */
      public java.util.List<com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind>
          getTargetGroupKindsList() {
        if (targetGroupKindsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(targetGroupKinds_);
        } else {
          return targetGroupKindsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * (Filtering parameter) Any resource subject to substitution must belong to
       * one of the listed "types".
       * If this field is not provided, no type filtering will be performed (all
       * resources of all types matching previous filtering parameters will be
       * candidates for substitution).
       * </pre>
       *
       * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind target_group_kinds = 2;
       * </code>
       */
      public int getTargetGroupKindsCount() {
        if (targetGroupKindsBuilder_ == null) {
          return targetGroupKinds_.size();
        } else {
          return targetGroupKindsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * (Filtering parameter) Any resource subject to substitution must belong to
       * one of the listed "types".
       * If this field is not provided, no type filtering will be performed (all
       * resources of all types matching previous filtering parameters will be
       * candidates for substitution).
       * </pre>
       *
       * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind target_group_kinds = 2;
       * </code>
       */
      public com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind getTargetGroupKinds(int index) {
        if (targetGroupKindsBuilder_ == null) {
          return targetGroupKinds_.get(index);
        } else {
          return targetGroupKindsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * (Filtering parameter) Any resource subject to substitution must belong to
       * one of the listed "types".
       * If this field is not provided, no type filtering will be performed (all
       * resources of all types matching previous filtering parameters will be
       * candidates for substitution).
       * </pre>
       *
       * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind target_group_kinds = 2;
       * </code>
       */
      public Builder setTargetGroupKinds(
          int index, com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind value) {
        if (targetGroupKindsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureTargetGroupKindsIsMutable();
          targetGroupKinds_.set(index, value);
          onChanged();
        } else {
          targetGroupKindsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * (Filtering parameter) Any resource subject to substitution must belong to
       * one of the listed "types".
       * If this field is not provided, no type filtering will be performed (all
       * resources of all types matching previous filtering parameters will be
       * candidates for substitution).
       * </pre>
       *
       * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind target_group_kinds = 2;
       * </code>
       */
      public Builder setTargetGroupKinds(
          int index,
          com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind.Builder builderForValue) {
        if (targetGroupKindsBuilder_ == null) {
          ensureTargetGroupKindsIsMutable();
          targetGroupKinds_.set(index, builderForValue.build());
          onChanged();
        } else {
          targetGroupKindsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * (Filtering parameter) Any resource subject to substitution must belong to
       * one of the listed "types".
       * If this field is not provided, no type filtering will be performed (all
       * resources of all types matching previous filtering parameters will be
       * candidates for substitution).
       * </pre>
       *
       * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind target_group_kinds = 2;
       * </code>
       */
      public Builder addTargetGroupKinds(
          com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind value) {
        if (targetGroupKindsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureTargetGroupKindsIsMutable();
          targetGroupKinds_.add(value);
          onChanged();
        } else {
          targetGroupKindsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * (Filtering parameter) Any resource subject to substitution must belong to
       * one of the listed "types".
       * If this field is not provided, no type filtering will be performed (all
       * resources of all types matching previous filtering parameters will be
       * candidates for substitution).
       * </pre>
       *
       * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind target_group_kinds = 2;
       * </code>
       */
      public Builder addTargetGroupKinds(
          int index, com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind value) {
        if (targetGroupKindsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureTargetGroupKindsIsMutable();
          targetGroupKinds_.add(index, value);
          onChanged();
        } else {
          targetGroupKindsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * (Filtering parameter) Any resource subject to substitution must belong to
       * one of the listed "types".
       * If this field is not provided, no type filtering will be performed (all
       * resources of all types matching previous filtering parameters will be
       * candidates for substitution).
       * </pre>
       *
       * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind target_group_kinds = 2;
       * </code>
       */
      public Builder addTargetGroupKinds(
          com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind.Builder builderForValue) {
        if (targetGroupKindsBuilder_ == null) {
          ensureTargetGroupKindsIsMutable();
          targetGroupKinds_.add(builderForValue.build());
          onChanged();
        } else {
          targetGroupKindsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * (Filtering parameter) Any resource subject to substitution must belong to
       * one of the listed "types".
       * If this field is not provided, no type filtering will be performed (all
       * resources of all types matching previous filtering parameters will be
       * candidates for substitution).
       * </pre>
       *
       * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind target_group_kinds = 2;
       * </code>
       */
      public Builder addTargetGroupKinds(
          int index,
          com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind.Builder builderForValue) {
        if (targetGroupKindsBuilder_ == null) {
          ensureTargetGroupKindsIsMutable();
          targetGroupKinds_.add(index, builderForValue.build());
          onChanged();
        } else {
          targetGroupKindsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * (Filtering parameter) Any resource subject to substitution must belong to
       * one of the listed "types".
       * If this field is not provided, no type filtering will be performed (all
       * resources of all types matching previous filtering parameters will be
       * candidates for substitution).
       * </pre>
       *
       * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind target_group_kinds = 2;
       * </code>
       */
      public Builder addAllTargetGroupKinds(
          java.lang.Iterable<? extends com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind>
              values) {
        if (targetGroupKindsBuilder_ == null) {
          ensureTargetGroupKindsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, targetGroupKinds_);
          onChanged();
        } else {
          targetGroupKindsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * (Filtering parameter) Any resource subject to substitution must belong to
       * one of the listed "types".
       * If this field is not provided, no type filtering will be performed (all
       * resources of all types matching previous filtering parameters will be
       * candidates for substitution).
       * </pre>
       *
       * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind target_group_kinds = 2;
       * </code>
       */
      public Builder clearTargetGroupKinds() {
        if (targetGroupKindsBuilder_ == null) {
          targetGroupKinds_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          targetGroupKindsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * (Filtering parameter) Any resource subject to substitution must belong to
       * one of the listed "types".
       * If this field is not provided, no type filtering will be performed (all
       * resources of all types matching previous filtering parameters will be
       * candidates for substitution).
       * </pre>
       *
       * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind target_group_kinds = 2;
       * </code>
       */
      public Builder removeTargetGroupKinds(int index) {
        if (targetGroupKindsBuilder_ == null) {
          ensureTargetGroupKindsIsMutable();
          targetGroupKinds_.remove(index);
          onChanged();
        } else {
          targetGroupKindsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * (Filtering parameter) Any resource subject to substitution must belong to
       * one of the listed "types".
       * If this field is not provided, no type filtering will be performed (all
       * resources of all types matching previous filtering parameters will be
       * candidates for substitution).
       * </pre>
       *
       * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind target_group_kinds = 2;
       * </code>
       */
      public com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind.Builder
          getTargetGroupKindsBuilder(int index) {
        return getTargetGroupKindsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * (Filtering parameter) Any resource subject to substitution must belong to
       * one of the listed "types".
       * If this field is not provided, no type filtering will be performed (all
       * resources of all types matching previous filtering parameters will be
       * candidates for substitution).
       * </pre>
       *
       * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind target_group_kinds = 2;
       * </code>
       */
      public com.google.cloud.gkebackup.v1.RestoreConfig.GroupKindOrBuilder
          getTargetGroupKindsOrBuilder(int index) {
        if (targetGroupKindsBuilder_ == null) {
          return targetGroupKinds_.get(index);
        } else {
          return targetGroupKindsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * (Filtering parameter) Any resource subject to substitution must belong to
       * one of the listed "types".
       * If this field is not provided, no type filtering will be performed (all
       * resources of all types matching previous filtering parameters will be
       * candidates for substitution).
       * </pre>
       *
       * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind target_group_kinds = 2;
       * </code>
       */
      public java.util.List<
              ? extends com.google.cloud.gkebackup.v1.RestoreConfig.GroupKindOrBuilder>
          getTargetGroupKindsOrBuilderList() {
        if (targetGroupKindsBuilder_ != null) {
          return targetGroupKindsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(targetGroupKinds_);
        }
      }
      /**
       *
       *
       * <pre>
       * (Filtering parameter) Any resource subject to substitution must belong to
       * one of the listed "types".
       * If this field is not provided, no type filtering will be performed (all
       * resources of all types matching previous filtering parameters will be
       * candidates for substitution).
       * </pre>
       *
       * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind target_group_kinds = 2;
       * </code>
       */
      public com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind.Builder
          addTargetGroupKindsBuilder() {
        return getTargetGroupKindsFieldBuilder()
            .addBuilder(com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * (Filtering parameter) Any resource subject to substitution must belong to
       * one of the listed "types".
       * If this field is not provided, no type filtering will be performed (all
       * resources of all types matching previous filtering parameters will be
       * candidates for substitution).
       * </pre>
       *
       * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind target_group_kinds = 2;
       * </code>
       */
      public com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind.Builder
          addTargetGroupKindsBuilder(int index) {
        return getTargetGroupKindsFieldBuilder()
            .addBuilder(
                index, com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * (Filtering parameter) Any resource subject to substitution must belong to
       * one of the listed "types".
       * If this field is not provided, no type filtering will be performed (all
       * resources of all types matching previous filtering parameters will be
       * candidates for substitution).
       * </pre>
       *
       * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind target_group_kinds = 2;
       * </code>
       */
      public java.util.List<com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind.Builder>
          getTargetGroupKindsBuilderList() {
        return getTargetGroupKindsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind,
              com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind.Builder,
              com.google.cloud.gkebackup.v1.RestoreConfig.GroupKindOrBuilder>
          getTargetGroupKindsFieldBuilder() {
        if (targetGroupKindsBuilder_ == null) {
          targetGroupKindsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind,
                  com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind.Builder,
                  com.google.cloud.gkebackup.v1.RestoreConfig.GroupKindOrBuilder>(
                  targetGroupKinds_,
                  ((bitField0_ & 0x00000002) != 0),
                  getParentForChildren(),
                  isClean());
          targetGroupKinds_ = null;
        }
        return targetGroupKindsBuilder_;
      }

      private java.lang.Object targetJsonPath_ = "";
      /**
       *
       *
       * <pre>
       * Required. This is a [JSONPath]
       * (https://kubernetes.io/docs/reference/kubectl/jsonpath/)
       * expression that matches specific fields of candidate
       * resources and it operates as both a filtering parameter (resources that
       * are not matched with this expression will not be candidates for
       * substitution) as well as a field identifier (identifies exactly which
       * fields out of the candidate resources will be modified).
       * </pre>
       *
       * <code>string target_json_path = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The targetJsonPath.
       */
      public java.lang.String getTargetJsonPath() {
        java.lang.Object ref = targetJsonPath_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          targetJsonPath_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. This is a [JSONPath]
       * (https://kubernetes.io/docs/reference/kubectl/jsonpath/)
       * expression that matches specific fields of candidate
       * resources and it operates as both a filtering parameter (resources that
       * are not matched with this expression will not be candidates for
       * substitution) as well as a field identifier (identifies exactly which
       * fields out of the candidate resources will be modified).
       * </pre>
       *
       * <code>string target_json_path = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for targetJsonPath.
       */
      public com.google.protobuf.ByteString getTargetJsonPathBytes() {
        java.lang.Object ref = targetJsonPath_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          targetJsonPath_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. This is a [JSONPath]
       * (https://kubernetes.io/docs/reference/kubectl/jsonpath/)
       * expression that matches specific fields of candidate
       * resources and it operates as both a filtering parameter (resources that
       * are not matched with this expression will not be candidates for
       * substitution) as well as a field identifier (identifies exactly which
       * fields out of the candidate resources will be modified).
       * </pre>
       *
       * <code>string target_json_path = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The targetJsonPath to set.
       * @return This builder for chaining.
       */
      public Builder setTargetJsonPath(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        targetJsonPath_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. This is a [JSONPath]
       * (https://kubernetes.io/docs/reference/kubectl/jsonpath/)
       * expression that matches specific fields of candidate
       * resources and it operates as both a filtering parameter (resources that
       * are not matched with this expression will not be candidates for
       * substitution) as well as a field identifier (identifies exactly which
       * fields out of the candidate resources will be modified).
       * </pre>
       *
       * <code>string target_json_path = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTargetJsonPath() {
        targetJsonPath_ = getDefaultInstance().getTargetJsonPath();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. This is a [JSONPath]
       * (https://kubernetes.io/docs/reference/kubectl/jsonpath/)
       * expression that matches specific fields of candidate
       * resources and it operates as both a filtering parameter (resources that
       * are not matched with this expression will not be candidates for
       * substitution) as well as a field identifier (identifies exactly which
       * fields out of the candidate resources will be modified).
       * </pre>
       *
       * <code>string target_json_path = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for targetJsonPath to set.
       * @return This builder for chaining.
       */
      public Builder setTargetJsonPathBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        targetJsonPath_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private java.lang.Object originalValuePattern_ = "";
      /**
       *
       *
       * <pre>
       * (Filtering parameter) This is a [regular expression]
       * (https://en.wikipedia.org/wiki/Regular_expression)
       * that is compared against the fields matched by the target_json_path
       * expression (and must also have passed the previous filters).
       * Substitution will not be performed against fields whose
       * value does not match this expression. If this field is NOT specified,
       * then ALL fields matched by the target_json_path expression will undergo
       * substitution. Note that an empty (e.g., "", rather than unspecified)
       * value for this field will only match empty fields.
       * </pre>
       *
       * <code>string original_value_pattern = 4;</code>
       *
       * @return The originalValuePattern.
       */
      public java.lang.String getOriginalValuePattern() {
        java.lang.Object ref = originalValuePattern_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          originalValuePattern_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * (Filtering parameter) This is a [regular expression]
       * (https://en.wikipedia.org/wiki/Regular_expression)
       * that is compared against the fields matched by the target_json_path
       * expression (and must also have passed the previous filters).
       * Substitution will not be performed against fields whose
       * value does not match this expression. If this field is NOT specified,
       * then ALL fields matched by the target_json_path expression will undergo
       * substitution. Note that an empty (e.g., "", rather than unspecified)
       * value for this field will only match empty fields.
       * </pre>
       *
       * <code>string original_value_pattern = 4;</code>
       *
       * @return The bytes for originalValuePattern.
       */
      public com.google.protobuf.ByteString getOriginalValuePatternBytes() {
        java.lang.Object ref = originalValuePattern_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          originalValuePattern_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * (Filtering parameter) This is a [regular expression]
       * (https://en.wikipedia.org/wiki/Regular_expression)
       * that is compared against the fields matched by the target_json_path
       * expression (and must also have passed the previous filters).
       * Substitution will not be performed against fields whose
       * value does not match this expression. If this field is NOT specified,
       * then ALL fields matched by the target_json_path expression will undergo
       * substitution. Note that an empty (e.g., "", rather than unspecified)
       * value for this field will only match empty fields.
       * </pre>
       *
       * <code>string original_value_pattern = 4;</code>
       *
       * @param value The originalValuePattern to set.
       * @return This builder for chaining.
       */
      public Builder setOriginalValuePattern(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        originalValuePattern_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * (Filtering parameter) This is a [regular expression]
       * (https://en.wikipedia.org/wiki/Regular_expression)
       * that is compared against the fields matched by the target_json_path
       * expression (and must also have passed the previous filters).
       * Substitution will not be performed against fields whose
       * value does not match this expression. If this field is NOT specified,
       * then ALL fields matched by the target_json_path expression will undergo
       * substitution. Note that an empty (e.g., "", rather than unspecified)
       * value for this field will only match empty fields.
       * </pre>
       *
       * <code>string original_value_pattern = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearOriginalValuePattern() {
        originalValuePattern_ = getDefaultInstance().getOriginalValuePattern();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * (Filtering parameter) This is a [regular expression]
       * (https://en.wikipedia.org/wiki/Regular_expression)
       * that is compared against the fields matched by the target_json_path
       * expression (and must also have passed the previous filters).
       * Substitution will not be performed against fields whose
       * value does not match this expression. If this field is NOT specified,
       * then ALL fields matched by the target_json_path expression will undergo
       * substitution. Note that an empty (e.g., "", rather than unspecified)
       * value for this field will only match empty fields.
       * </pre>
       *
       * <code>string original_value_pattern = 4;</code>
       *
       * @param value The bytes for originalValuePattern to set.
       * @return This builder for chaining.
       */
      public Builder setOriginalValuePatternBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        originalValuePattern_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      private java.lang.Object newValue_ = "";
      /**
       *
       *
       * <pre>
       * This is the new value to set for any fields that pass the filtering and
       * selection criteria. To remove a value from a Kubernetes resource, either
       * leave this field unspecified, or set it to the empty string ("").
       * </pre>
       *
       * <code>string new_value = 5;</code>
       *
       * @return The newValue.
       */
      public java.lang.String getNewValue() {
        java.lang.Object ref = newValue_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          newValue_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * This is the new value to set for any fields that pass the filtering and
       * selection criteria. To remove a value from a Kubernetes resource, either
       * leave this field unspecified, or set it to the empty string ("").
       * </pre>
       *
       * <code>string new_value = 5;</code>
       *
       * @return The bytes for newValue.
       */
      public com.google.protobuf.ByteString getNewValueBytes() {
        java.lang.Object ref = newValue_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          newValue_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * This is the new value to set for any fields that pass the filtering and
       * selection criteria. To remove a value from a Kubernetes resource, either
       * leave this field unspecified, or set it to the empty string ("").
       * </pre>
       *
       * <code>string new_value = 5;</code>
       *
       * @param value The newValue to set.
       * @return This builder for chaining.
       */
      public Builder setNewValue(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        newValue_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * This is the new value to set for any fields that pass the filtering and
       * selection criteria. To remove a value from a Kubernetes resource, either
       * leave this field unspecified, or set it to the empty string ("").
       * </pre>
       *
       * <code>string new_value = 5;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearNewValue() {
        newValue_ = getDefaultInstance().getNewValue();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * This is the new value to set for any fields that pass the filtering and
       * selection criteria. To remove a value from a Kubernetes resource, either
       * leave this field unspecified, or set it to the empty string ("").
       * </pre>
       *
       * <code>string new_value = 5;</code>
       *
       * @param value The bytes for newValue to set.
       * @return This builder for chaining.
       */
      public Builder setNewValueBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        newValue_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule)
    private static final com.google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule();
    }

    public static com.google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SubstitutionRule> PARSER =
        new com.google.protobuf.AbstractParser<SubstitutionRule>() {
          @java.lang.Override
          public SubstitutionRule parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<SubstitutionRule> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SubstitutionRule> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface TransformationRuleActionOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. op specifies the operation to perform.
     * </pre>
     *
     * <code>
     * .google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction.Op op = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for op.
     */
    int getOpValue();
    /**
     *
     *
     * <pre>
     * Required. op specifies the operation to perform.
     * </pre>
     *
     * <code>
     * .google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction.Op op = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The op.
     */
    com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction.Op getOp();

    /**
     *
     *
     * <pre>
     * A string containing a JSON Pointer value that references the location in
     * the target document to move the value from.
     * </pre>
     *
     * <code>string from_path = 2;</code>
     *
     * @return The fromPath.
     */
    java.lang.String getFromPath();
    /**
     *
     *
     * <pre>
     * A string containing a JSON Pointer value that references the location in
     * the target document to move the value from.
     * </pre>
     *
     * <code>string from_path = 2;</code>
     *
     * @return The bytes for fromPath.
     */
    com.google.protobuf.ByteString getFromPathBytes();

    /**
     *
     *
     * <pre>
     * A string containing a JSON-Pointer value that references a location
     * within the target document where the operation is performed.
     * </pre>
     *
     * <code>string path = 3;</code>
     *
     * @return The path.
     */
    java.lang.String getPath();
    /**
     *
     *
     * <pre>
     * A string containing a JSON-Pointer value that references a location
     * within the target document where the operation is performed.
     * </pre>
     *
     * <code>string path = 3;</code>
     *
     * @return The bytes for path.
     */
    com.google.protobuf.ByteString getPathBytes();

    /**
     *
     *
     * <pre>
     * A string that specifies the desired value in string format to
     * use for transformation.
     * </pre>
     *
     * <code>string value = 4;</code>
     *
     * @return The value.
     */
    java.lang.String getValue();
    /**
     *
     *
     * <pre>
     * A string that specifies the desired value in string format to
     * use for transformation.
     * </pre>
     *
     * <code>string value = 4;</code>
     *
     * @return The bytes for value.
     */
    com.google.protobuf.ByteString getValueBytes();
  }
  /**
   *
   *
   * <pre>
   * TransformationRuleAction defines a TransformationRule action based on the
   * JSON Patch RFC (https://www.rfc-editor.org/rfc/rfc6902)
   * </pre>
   *
   * Protobuf type {@code google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction}
   */
  public static final class TransformationRuleAction extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction)
      TransformationRuleActionOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use TransformationRuleAction.newBuilder() to construct.
    private TransformationRuleAction(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private TransformationRuleAction() {
      op_ = 0;
      fromPath_ = "";
      path_ = "";
      value_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new TransformationRuleAction();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.gkebackup.v1.RestoreProto
          .internal_static_google_cloud_gkebackup_v1_RestoreConfig_TransformationRuleAction_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.gkebackup.v1.RestoreProto
          .internal_static_google_cloud_gkebackup_v1_RestoreConfig_TransformationRuleAction_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction.class,
              com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * Possible values for operations of a transformation rule action.
     * </pre>
     *
     * Protobuf enum {@code google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction.Op}
     */
    public enum Op implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Unspecified operation
       * </pre>
       *
       * <code>OP_UNSPECIFIED = 0;</code>
       */
      OP_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * The "remove" operation removes the value at the target location.
       * </pre>
       *
       * <code>REMOVE = 1;</code>
       */
      REMOVE(1),
      /**
       *
       *
       * <pre>
       * The "move" operation removes the value at a specified location and
       * adds it to the target location.
       * </pre>
       *
       * <code>MOVE = 2;</code>
       */
      MOVE(2),
      /**
       *
       *
       * <pre>
       * The "copy" operation copies the value at a specified location to the
       * target location.
       * </pre>
       *
       * <code>COPY = 3;</code>
       */
      COPY(3),
      /**
       *
       *
       * <pre>
       * The "add" operation performs one of the following functions,
       * depending upon what the target location references:
       * 1. If the target location specifies an array index, a new value is
       * inserted into the array at the specified index.
       * 2. If the target location specifies an object member that does not
       * already exist, a new member is added to the object.
       * 3. If the target location specifies an object member that does exist,
       * that member's value is replaced.
       * </pre>
       *
       * <code>ADD = 4;</code>
       */
      ADD(4),
      /**
       *
       *
       * <pre>
       * The "test" operation tests that a value at the target location is
       * equal to a specified value.
       * </pre>
       *
       * <code>TEST = 5;</code>
       */
      TEST(5),
      /**
       *
       *
       * <pre>
       * The "replace" operation replaces the value at the target location
       * with a new value.  The operation object MUST contain a "value" member
       * whose content specifies the replacement value.
       * </pre>
       *
       * <code>REPLACE = 6;</code>
       */
      REPLACE(6),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Unspecified operation
       * </pre>
       *
       * <code>OP_UNSPECIFIED = 0;</code>
       */
      public static final int OP_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * The "remove" operation removes the value at the target location.
       * </pre>
       *
       * <code>REMOVE = 1;</code>
       */
      public static final int REMOVE_VALUE = 1;
      /**
       *
       *
       * <pre>
       * The "move" operation removes the value at a specified location and
       * adds it to the target location.
       * </pre>
       *
       * <code>MOVE = 2;</code>
       */
      public static final int MOVE_VALUE = 2;
      /**
       *
       *
       * <pre>
       * The "copy" operation copies the value at a specified location to the
       * target location.
       * </pre>
       *
       * <code>COPY = 3;</code>
       */
      public static final int COPY_VALUE = 3;
      /**
       *
       *
       * <pre>
       * The "add" operation performs one of the following functions,
       * depending upon what the target location references:
       * 1. If the target location specifies an array index, a new value is
       * inserted into the array at the specified index.
       * 2. If the target location specifies an object member that does not
       * already exist, a new member is added to the object.
       * 3. If the target location specifies an object member that does exist,
       * that member's value is replaced.
       * </pre>
       *
       * <code>ADD = 4;</code>
       */
      public static final int ADD_VALUE = 4;
      /**
       *
       *
       * <pre>
       * The "test" operation tests that a value at the target location is
       * equal to a specified value.
       * </pre>
       *
       * <code>TEST = 5;</code>
       */
      public static final int TEST_VALUE = 5;
      /**
       *
       *
       * <pre>
       * The "replace" operation replaces the value at the target location
       * with a new value.  The operation object MUST contain a "value" member
       * whose content specifies the replacement value.
       * </pre>
       *
       * <code>REPLACE = 6;</code>
       */
      public static final int REPLACE_VALUE = 6;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static Op valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static Op forNumber(int value) {
        switch (value) {
          case 0:
            return OP_UNSPECIFIED;
          case 1:
            return REMOVE;
          case 2:
            return MOVE;
          case 3:
            return COPY;
          case 4:
            return ADD;
          case 5:
            return TEST;
          case 6:
            return REPLACE;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Op> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<Op> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<Op>() {
            public Op findValueByNumber(int number) {
              return Op.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final Op[] VALUES = values();

      public static Op valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private Op(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction.Op)
    }

    public static final int OP_FIELD_NUMBER = 1;
    private int op_ = 0;
    /**
     *
     *
     * <pre>
     * Required. op specifies the operation to perform.
     * </pre>
     *
     * <code>
     * .google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction.Op op = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for op.
     */
    @java.lang.Override
    public int getOpValue() {
      return op_;
    }
    /**
     *
     *
     * <pre>
     * Required. op specifies the operation to perform.
     * </pre>
     *
     * <code>
     * .google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction.Op op = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The op.
     */
    @java.lang.Override
    public com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction.Op getOp() {
      com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction.Op result =
          com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction.Op.forNumber(op_);
      return result == null
          ? com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction.Op.UNRECOGNIZED
          : result;
    }

    public static final int FROM_PATH_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object fromPath_ = "";
    /**
     *
     *
     * <pre>
     * A string containing a JSON Pointer value that references the location in
     * the target document to move the value from.
     * </pre>
     *
     * <code>string from_path = 2;</code>
     *
     * @return The fromPath.
     */
    @java.lang.Override
    public java.lang.String getFromPath() {
      java.lang.Object ref = fromPath_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        fromPath_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * A string containing a JSON Pointer value that references the location in
     * the target document to move the value from.
     * </pre>
     *
     * <code>string from_path = 2;</code>
     *
     * @return The bytes for fromPath.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getFromPathBytes() {
      java.lang.Object ref = fromPath_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        fromPath_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PATH_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object path_ = "";
    /**
     *
     *
     * <pre>
     * A string containing a JSON-Pointer value that references a location
     * within the target document where the operation is performed.
     * </pre>
     *
     * <code>string path = 3;</code>
     *
     * @return The path.
     */
    @java.lang.Override
    public java.lang.String getPath() {
      java.lang.Object ref = path_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        path_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * A string containing a JSON-Pointer value that references a location
     * within the target document where the operation is performed.
     * </pre>
     *
     * <code>string path = 3;</code>
     *
     * @return The bytes for path.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPathBytes() {
      java.lang.Object ref = path_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        path_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int VALUE_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private volatile java.lang.Object value_ = "";
    /**
     *
     *
     * <pre>
     * A string that specifies the desired value in string format to
     * use for transformation.
     * </pre>
     *
     * <code>string value = 4;</code>
     *
     * @return The value.
     */
    @java.lang.Override
    public java.lang.String getValue() {
      java.lang.Object ref = value_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        value_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * A string that specifies the desired value in string format to
     * use for transformation.
     * </pre>
     *
     * <code>string value = 4;</code>
     *
     * @return The bytes for value.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getValueBytes() {
      java.lang.Object ref = value_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        value_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (op_
          != com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction.Op.OP_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(1, op_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fromPath_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, fromPath_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(path_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, path_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(value_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, value_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (op_
          != com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction.Op.OP_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, op_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fromPath_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, fromPath_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(path_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, path_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(value_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, value_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction)) {
        return super.equals(obj);
      }
      com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction other =
          (com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction) obj;

      if (op_ != other.op_) return false;
      if (!getFromPath().equals(other.getFromPath())) return false;
      if (!getPath().equals(other.getPath())) return false;
      if (!getValue().equals(other.getValue())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + OP_FIELD_NUMBER;
      hash = (53 * hash) + op_;
      hash = (37 * hash) + FROM_PATH_FIELD_NUMBER;
      hash = (53 * hash) + getFromPath().hashCode();
      hash = (37 * hash) + PATH_FIELD_NUMBER;
      hash = (53 * hash) + getPath().hashCode();
      hash = (37 * hash) + VALUE_FIELD_NUMBER;
      hash = (53 * hash) + getValue().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * TransformationRuleAction defines a TransformationRule action based on the
     * JSON Patch RFC (https://www.rfc-editor.org/rfc/rfc6902)
     * </pre>
     *
     * Protobuf type {@code google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction)
        com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleActionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.gkebackup.v1.RestoreProto
            .internal_static_google_cloud_gkebackup_v1_RestoreConfig_TransformationRuleAction_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.gkebackup.v1.RestoreProto
            .internal_static_google_cloud_gkebackup_v1_RestoreConfig_TransformationRuleAction_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction.class,
                com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction.Builder.class);
      }

      // Construct using
      // com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        op_ = 0;
        fromPath_ = "";
        path_ = "";
        value_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.gkebackup.v1.RestoreProto
            .internal_static_google_cloud_gkebackup_v1_RestoreConfig_TransformationRuleAction_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction
          getDefaultInstanceForType() {
        return com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction build() {
        com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction buildPartial() {
        com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction result =
            new com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.op_ = op_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.fromPath_ = fromPath_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.path_ = path_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.value_ = value_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction) {
          return mergeFrom(
              (com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction other) {
        if (other
            == com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction
                .getDefaultInstance()) return this;
        if (other.op_ != 0) {
          setOpValue(other.getOpValue());
        }
        if (!other.getFromPath().isEmpty()) {
          fromPath_ = other.fromPath_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.getPath().isEmpty()) {
          path_ = other.path_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        if (!other.getValue().isEmpty()) {
          value_ = other.value_;
          bitField0_ |= 0x00000008;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  op_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 18:
                {
                  fromPath_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  path_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  value_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int op_ = 0;
      /**
       *
       *
       * <pre>
       * Required. op specifies the operation to perform.
       * </pre>
       *
       * <code>
       * .google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction.Op op = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The enum numeric value on the wire for op.
       */
      @java.lang.Override
      public int getOpValue() {
        return op_;
      }
      /**
       *
       *
       * <pre>
       * Required. op specifies the operation to perform.
       * </pre>
       *
       * <code>
       * .google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction.Op op = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @param value The enum numeric value on the wire for op to set.
       * @return This builder for chaining.
       */
      public Builder setOpValue(int value) {
        op_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. op specifies the operation to perform.
       * </pre>
       *
       * <code>
       * .google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction.Op op = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The op.
       */
      @java.lang.Override
      public com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction.Op getOp() {
        com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction.Op result =
            com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction.Op.forNumber(op_);
        return result == null
            ? com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction.Op.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Required. op specifies the operation to perform.
       * </pre>
       *
       * <code>
       * .google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction.Op op = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @param value The op to set.
       * @return This builder for chaining.
       */
      public Builder setOp(
          com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction.Op value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        op_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. op specifies the operation to perform.
       * </pre>
       *
       * <code>
       * .google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction.Op op = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearOp() {
        bitField0_ = (bitField0_ & ~0x00000001);
        op_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object fromPath_ = "";
      /**
       *
       *
       * <pre>
       * A string containing a JSON Pointer value that references the location in
       * the target document to move the value from.
       * </pre>
       *
       * <code>string from_path = 2;</code>
       *
       * @return The fromPath.
       */
      public java.lang.String getFromPath() {
        java.lang.Object ref = fromPath_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          fromPath_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * A string containing a JSON Pointer value that references the location in
       * the target document to move the value from.
       * </pre>
       *
       * <code>string from_path = 2;</code>
       *
       * @return The bytes for fromPath.
       */
      public com.google.protobuf.ByteString getFromPathBytes() {
        java.lang.Object ref = fromPath_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          fromPath_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * A string containing a JSON Pointer value that references the location in
       * the target document to move the value from.
       * </pre>
       *
       * <code>string from_path = 2;</code>
       *
       * @param value The fromPath to set.
       * @return This builder for chaining.
       */
      public Builder setFromPath(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        fromPath_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A string containing a JSON Pointer value that references the location in
       * the target document to move the value from.
       * </pre>
       *
       * <code>string from_path = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFromPath() {
        fromPath_ = getDefaultInstance().getFromPath();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A string containing a JSON Pointer value that references the location in
       * the target document to move the value from.
       * </pre>
       *
       * <code>string from_path = 2;</code>
       *
       * @param value The bytes for fromPath to set.
       * @return This builder for chaining.
       */
      public Builder setFromPathBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        fromPath_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object path_ = "";
      /**
       *
       *
       * <pre>
       * A string containing a JSON-Pointer value that references a location
       * within the target document where the operation is performed.
       * </pre>
       *
       * <code>string path = 3;</code>
       *
       * @return The path.
       */
      public java.lang.String getPath() {
        java.lang.Object ref = path_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          path_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * A string containing a JSON-Pointer value that references a location
       * within the target document where the operation is performed.
       * </pre>
       *
       * <code>string path = 3;</code>
       *
       * @return The bytes for path.
       */
      public com.google.protobuf.ByteString getPathBytes() {
        java.lang.Object ref = path_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          path_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * A string containing a JSON-Pointer value that references a location
       * within the target document where the operation is performed.
       * </pre>
       *
       * <code>string path = 3;</code>
       *
       * @param value The path to set.
       * @return This builder for chaining.
       */
      public Builder setPath(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        path_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A string containing a JSON-Pointer value that references a location
       * within the target document where the operation is performed.
       * </pre>
       *
       * <code>string path = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPath() {
        path_ = getDefaultInstance().getPath();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A string containing a JSON-Pointer value that references a location
       * within the target document where the operation is performed.
       * </pre>
       *
       * <code>string path = 3;</code>
       *
       * @param value The bytes for path to set.
       * @return This builder for chaining.
       */
      public Builder setPathBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        path_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private java.lang.Object value_ = "";
      /**
       *
       *
       * <pre>
       * A string that specifies the desired value in string format to
       * use for transformation.
       * </pre>
       *
       * <code>string value = 4;</code>
       *
       * @return The value.
       */
      public java.lang.String getValue() {
        java.lang.Object ref = value_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          value_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * A string that specifies the desired value in string format to
       * use for transformation.
       * </pre>
       *
       * <code>string value = 4;</code>
       *
       * @return The bytes for value.
       */
      public com.google.protobuf.ByteString getValueBytes() {
        java.lang.Object ref = value_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          value_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * A string that specifies the desired value in string format to
       * use for transformation.
       * </pre>
       *
       * <code>string value = 4;</code>
       *
       * @param value The value to set.
       * @return This builder for chaining.
       */
      public Builder setValue(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        value_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A string that specifies the desired value in string format to
       * use for transformation.
       * </pre>
       *
       * <code>string value = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearValue() {
        value_ = getDefaultInstance().getValue();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A string that specifies the desired value in string format to
       * use for transformation.
       * </pre>
       *
       * <code>string value = 4;</code>
       *
       * @param value The bytes for value to set.
       * @return This builder for chaining.
       */
      public Builder setValueBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        value_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction)
    private static final com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction();
    }

    public static com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<TransformationRuleAction> PARSER =
        new com.google.protobuf.AbstractParser<TransformationRuleAction>() {
          @java.lang.Override
          public TransformationRuleAction parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<TransformationRuleAction> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<TransformationRuleAction> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ResourceFilterOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * (Filtering parameter) Any resource subject to transformation must be
     * contained within one of the listed Kubernetes Namespace in the Backup.
     * If this field is not provided, no namespace filtering will be performed
     * (all resources in all Namespaces, including all cluster-scoped resources,
     * will be candidates for transformation).
     * To mix cluster-scoped and namespaced resources in the same rule, use an
     * empty string ("") as one of the target namespaces.
     * </pre>
     *
     * <code>repeated string namespaces = 1;</code>
     *
     * @return A list containing the namespaces.
     */
    java.util.List<java.lang.String> getNamespacesList();
    /**
     *
     *
     * <pre>
     * (Filtering parameter) Any resource subject to transformation must be
     * contained within one of the listed Kubernetes Namespace in the Backup.
     * If this field is not provided, no namespace filtering will be performed
     * (all resources in all Namespaces, including all cluster-scoped resources,
     * will be candidates for transformation).
     * To mix cluster-scoped and namespaced resources in the same rule, use an
     * empty string ("") as one of the target namespaces.
     * </pre>
     *
     * <code>repeated string namespaces = 1;</code>
     *
     * @return The count of namespaces.
     */
    int getNamespacesCount();
    /**
     *
     *
     * <pre>
     * (Filtering parameter) Any resource subject to transformation must be
     * contained within one of the listed Kubernetes Namespace in the Backup.
     * If this field is not provided, no namespace filtering will be performed
     * (all resources in all Namespaces, including all cluster-scoped resources,
     * will be candidates for transformation).
     * To mix cluster-scoped and namespaced resources in the same rule, use an
     * empty string ("") as one of the target namespaces.
     * </pre>
     *
     * <code>repeated string namespaces = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The namespaces at the given index.
     */
    java.lang.String getNamespaces(int index);
    /**
     *
     *
     * <pre>
     * (Filtering parameter) Any resource subject to transformation must be
     * contained within one of the listed Kubernetes Namespace in the Backup.
     * If this field is not provided, no namespace filtering will be performed
     * (all resources in all Namespaces, including all cluster-scoped resources,
     * will be candidates for transformation).
     * To mix cluster-scoped and namespaced resources in the same rule, use an
     * empty string ("") as one of the target namespaces.
     * </pre>
     *
     * <code>repeated string namespaces = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the namespaces at the given index.
     */
    com.google.protobuf.ByteString getNamespacesBytes(int index);

    /**
     *
     *
     * <pre>
     * (Filtering parameter) Any resource subject to transformation must belong
     * to one of the listed "types". If this field is not provided, no type
     * filtering will be performed (all resources of all types matching previous
     * filtering parameters will be candidates for transformation).
     * </pre>
     *
     * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind group_kinds = 2;</code>
     */
    java.util.List<com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind> getGroupKindsList();
    /**
     *
     *
     * <pre>
     * (Filtering parameter) Any resource subject to transformation must belong
     * to one of the listed "types". If this field is not provided, no type
     * filtering will be performed (all resources of all types matching previous
     * filtering parameters will be candidates for transformation).
     * </pre>
     *
     * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind group_kinds = 2;</code>
     */
    com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind getGroupKinds(int index);
    /**
     *
     *
     * <pre>
     * (Filtering parameter) Any resource subject to transformation must belong
     * to one of the listed "types". If this field is not provided, no type
     * filtering will be performed (all resources of all types matching previous
     * filtering parameters will be candidates for transformation).
     * </pre>
     *
     * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind group_kinds = 2;</code>
     */
    int getGroupKindsCount();
    /**
     *
     *
     * <pre>
     * (Filtering parameter) Any resource subject to transformation must belong
     * to one of the listed "types". If this field is not provided, no type
     * filtering will be performed (all resources of all types matching previous
     * filtering parameters will be candidates for transformation).
     * </pre>
     *
     * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind group_kinds = 2;</code>
     */
    java.util.List<? extends com.google.cloud.gkebackup.v1.RestoreConfig.GroupKindOrBuilder>
        getGroupKindsOrBuilderList();
    /**
     *
     *
     * <pre>
     * (Filtering parameter) Any resource subject to transformation must belong
     * to one of the listed "types". If this field is not provided, no type
     * filtering will be performed (all resources of all types matching previous
     * filtering parameters will be candidates for transformation).
     * </pre>
     *
     * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind group_kinds = 2;</code>
     */
    com.google.cloud.gkebackup.v1.RestoreConfig.GroupKindOrBuilder getGroupKindsOrBuilder(
        int index);

    /**
     *
     *
     * <pre>
     * This is a [JSONPath]
     * (https://github.com/json-path/JsonPath/blob/master/README.md)
     * expression that matches specific fields of candidate
     * resources and it operates as a filtering parameter (resources that
     * are not matched with this expression will not be candidates for
     * transformation).
     * </pre>
     *
     * <code>string json_path = 3;</code>
     *
     * @return The jsonPath.
     */
    java.lang.String getJsonPath();
    /**
     *
     *
     * <pre>
     * This is a [JSONPath]
     * (https://github.com/json-path/JsonPath/blob/master/README.md)
     * expression that matches specific fields of candidate
     * resources and it operates as a filtering parameter (resources that
     * are not matched with this expression will not be candidates for
     * transformation).
     * </pre>
     *
     * <code>string json_path = 3;</code>
     *
     * @return The bytes for jsonPath.
     */
    com.google.protobuf.ByteString getJsonPathBytes();
  }
  /**
   *
   *
   * <pre>
   * ResourceFilter specifies matching criteria to limit the scope of a
   * change to a specific set of kubernetes resources that are selected for
   * restoration from a backup.
   * </pre>
   *
   * Protobuf type {@code google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter}
   */
  public static final class ResourceFilter extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter)
      ResourceFilterOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ResourceFilter.newBuilder() to construct.
    private ResourceFilter(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ResourceFilter() {
      namespaces_ = com.google.protobuf.LazyStringArrayList.emptyList();
      groupKinds_ = java.util.Collections.emptyList();
      jsonPath_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ResourceFilter();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.gkebackup.v1.RestoreProto
          .internal_static_google_cloud_gkebackup_v1_RestoreConfig_ResourceFilter_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.gkebackup.v1.RestoreProto
          .internal_static_google_cloud_gkebackup_v1_RestoreConfig_ResourceFilter_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter.class,
              com.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter.Builder.class);
    }

    public static final int NAMESPACES_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList namespaces_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * (Filtering parameter) Any resource subject to transformation must be
     * contained within one of the listed Kubernetes Namespace in the Backup.
     * If this field is not provided, no namespace filtering will be performed
     * (all resources in all Namespaces, including all cluster-scoped resources,
     * will be candidates for transformation).
     * To mix cluster-scoped and namespaced resources in the same rule, use an
     * empty string ("") as one of the target namespaces.
     * </pre>
     *
     * <code>repeated string namespaces = 1;</code>
     *
     * @return A list containing the namespaces.
     */
    public com.google.protobuf.ProtocolStringList getNamespacesList() {
      return namespaces_;
    }
    /**
     *
     *
     * <pre>
     * (Filtering parameter) Any resource subject to transformation must be
     * contained within one of the listed Kubernetes Namespace in the Backup.
     * If this field is not provided, no namespace filtering will be performed
     * (all resources in all Namespaces, including all cluster-scoped resources,
     * will be candidates for transformation).
     * To mix cluster-scoped and namespaced resources in the same rule, use an
     * empty string ("") as one of the target namespaces.
     * </pre>
     *
     * <code>repeated string namespaces = 1;</code>
     *
     * @return The count of namespaces.
     */
    public int getNamespacesCount() {
      return namespaces_.size();
    }
    /**
     *
     *
     * <pre>
     * (Filtering parameter) Any resource subject to transformation must be
     * contained within one of the listed Kubernetes Namespace in the Backup.
     * If this field is not provided, no namespace filtering will be performed
     * (all resources in all Namespaces, including all cluster-scoped resources,
     * will be candidates for transformation).
     * To mix cluster-scoped and namespaced resources in the same rule, use an
     * empty string ("") as one of the target namespaces.
     * </pre>
     *
     * <code>repeated string namespaces = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The namespaces at the given index.
     */
    public java.lang.String getNamespaces(int index) {
      return namespaces_.get(index);
    }
    /**
     *
     *
     * <pre>
     * (Filtering parameter) Any resource subject to transformation must be
     * contained within one of the listed Kubernetes Namespace in the Backup.
     * If this field is not provided, no namespace filtering will be performed
     * (all resources in all Namespaces, including all cluster-scoped resources,
     * will be candidates for transformation).
     * To mix cluster-scoped and namespaced resources in the same rule, use an
     * empty string ("") as one of the target namespaces.
     * </pre>
     *
     * <code>repeated string namespaces = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the namespaces at the given index.
     */
    public com.google.protobuf.ByteString getNamespacesBytes(int index) {
      return namespaces_.getByteString(index);
    }

    public static final int GROUP_KINDS_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind> groupKinds_;
    /**
     *
     *
     * <pre>
     * (Filtering parameter) Any resource subject to transformation must belong
     * to one of the listed "types". If this field is not provided, no type
     * filtering will be performed (all resources of all types matching previous
     * filtering parameters will be candidates for transformation).
     * </pre>
     *
     * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind group_kinds = 2;</code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind>
        getGroupKindsList() {
      return groupKinds_;
    }
    /**
     *
     *
     * <pre>
     * (Filtering parameter) Any resource subject to transformation must belong
     * to one of the listed "types". If this field is not provided, no type
     * filtering will be performed (all resources of all types matching previous
     * filtering parameters will be candidates for transformation).
     * </pre>
     *
     * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind group_kinds = 2;</code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.cloud.gkebackup.v1.RestoreConfig.GroupKindOrBuilder>
        getGroupKindsOrBuilderList() {
      return groupKinds_;
    }
    /**
     *
     *
     * <pre>
     * (Filtering parameter) Any resource subject to transformation must belong
     * to one of the listed "types". If this field is not provided, no type
     * filtering will be performed (all resources of all types matching previous
     * filtering parameters will be candidates for transformation).
     * </pre>
     *
     * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind group_kinds = 2;</code>
     */
    @java.lang.Override
    public int getGroupKindsCount() {
      return groupKinds_.size();
    }
    /**
     *
     *
     * <pre>
     * (Filtering parameter) Any resource subject to transformation must belong
     * to one of the listed "types". If this field is not provided, no type
     * filtering will be performed (all resources of all types matching previous
     * filtering parameters will be candidates for transformation).
     * </pre>
     *
     * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind group_kinds = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind getGroupKinds(int index) {
      return groupKinds_.get(index);
    }
    /**
     *
     *
     * <pre>
     * (Filtering parameter) Any resource subject to transformation must belong
     * to one of the listed "types". If this field is not provided, no type
     * filtering will be performed (all resources of all types matching previous
     * filtering parameters will be candidates for transformation).
     * </pre>
     *
     * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind group_kinds = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.gkebackup.v1.RestoreConfig.GroupKindOrBuilder getGroupKindsOrBuilder(
        int index) {
      return groupKinds_.get(index);
    }

    public static final int JSON_PATH_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object jsonPath_ = "";
    /**
     *
     *
     * <pre>
     * This is a [JSONPath]
     * (https://github.com/json-path/JsonPath/blob/master/README.md)
     * expression that matches specific fields of candidate
     * resources and it operates as a filtering parameter (resources that
     * are not matched with this expression will not be candidates for
     * transformation).
     * </pre>
     *
     * <code>string json_path = 3;</code>
     *
     * @return The jsonPath.
     */
    @java.lang.Override
    public java.lang.String getJsonPath() {
      java.lang.Object ref = jsonPath_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        jsonPath_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * This is a [JSONPath]
     * (https://github.com/json-path/JsonPath/blob/master/README.md)
     * expression that matches specific fields of candidate
     * resources and it operates as a filtering parameter (resources that
     * are not matched with this expression will not be candidates for
     * transformation).
     * </pre>
     *
     * <code>string json_path = 3;</code>
     *
     * @return The bytes for jsonPath.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getJsonPathBytes() {
      java.lang.Object ref = jsonPath_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        jsonPath_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < namespaces_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, namespaces_.getRaw(i));
      }
      for (int i = 0; i < groupKinds_.size(); i++) {
        output.writeMessage(2, groupKinds_.get(i));
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(jsonPath_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, jsonPath_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      {
        int dataSize = 0;
        for (int i = 0; i < namespaces_.size(); i++) {
          dataSize += computeStringSizeNoTag(namespaces_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getNamespacesList().size();
      }
      for (int i = 0; i < groupKinds_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, groupKinds_.get(i));
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(jsonPath_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, jsonPath_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter)) {
        return super.equals(obj);
      }
      com.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter other =
          (com.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter) obj;

      if (!getNamespacesList().equals(other.getNamespacesList())) return false;
      if (!getGroupKindsList().equals(other.getGroupKindsList())) return false;
      if (!getJsonPath().equals(other.getJsonPath())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getNamespacesCount() > 0) {
        hash = (37 * hash) + NAMESPACES_FIELD_NUMBER;
        hash = (53 * hash) + getNamespacesList().hashCode();
      }
      if (getGroupKindsCount() > 0) {
        hash = (37 * hash) + GROUP_KINDS_FIELD_NUMBER;
        hash = (53 * hash) + getGroupKindsList().hashCode();
      }
      hash = (37 * hash) + JSON_PATH_FIELD_NUMBER;
      hash = (53 * hash) + getJsonPath().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * ResourceFilter specifies matching criteria to limit the scope of a
     * change to a specific set of kubernetes resources that are selected for
     * restoration from a backup.
     * </pre>
     *
     * Protobuf type {@code google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter)
        com.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilterOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.gkebackup.v1.RestoreProto
            .internal_static_google_cloud_gkebackup_v1_RestoreConfig_ResourceFilter_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.gkebackup.v1.RestoreProto
            .internal_static_google_cloud_gkebackup_v1_RestoreConfig_ResourceFilter_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter.class,
                com.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter.Builder.class);
      }

      // Construct using com.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        namespaces_ = com.google.protobuf.LazyStringArrayList.emptyList();
        if (groupKindsBuilder_ == null) {
          groupKinds_ = java.util.Collections.emptyList();
        } else {
          groupKinds_ = null;
          groupKindsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        jsonPath_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.gkebackup.v1.RestoreProto
            .internal_static_google_cloud_gkebackup_v1_RestoreConfig_ResourceFilter_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter
          getDefaultInstanceForType() {
        return com.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter build() {
        com.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter buildPartial() {
        com.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter result =
            new com.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter result) {
        if (groupKindsBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)) {
            groupKinds_ = java.util.Collections.unmodifiableList(groupKinds_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.groupKinds_ = groupKinds_;
        } else {
          result.groupKinds_ = groupKindsBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          namespaces_.makeImmutable();
          result.namespaces_ = namespaces_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.jsonPath_ = jsonPath_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter) {
          return mergeFrom((com.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter other) {
        if (other
            == com.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter.getDefaultInstance())
          return this;
        if (!other.namespaces_.isEmpty()) {
          if (namespaces_.isEmpty()) {
            namespaces_ = other.namespaces_;
            bitField0_ |= 0x00000001;
          } else {
            ensureNamespacesIsMutable();
            namespaces_.addAll(other.namespaces_);
          }
          onChanged();
        }
        if (groupKindsBuilder_ == null) {
          if (!other.groupKinds_.isEmpty()) {
            if (groupKinds_.isEmpty()) {
              groupKinds_ = other.groupKinds_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureGroupKindsIsMutable();
              groupKinds_.addAll(other.groupKinds_);
            }
            onChanged();
          }
        } else {
          if (!other.groupKinds_.isEmpty()) {
            if (groupKindsBuilder_.isEmpty()) {
              groupKindsBuilder_.dispose();
              groupKindsBuilder_ = null;
              groupKinds_ = other.groupKinds_;
              bitField0_ = (bitField0_ & ~0x00000002);
              groupKindsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getGroupKindsFieldBuilder()
                      : null;
            } else {
              groupKindsBuilder_.addAllMessages(other.groupKinds_);
            }
          }
        }
        if (!other.getJsonPath().isEmpty()) {
          jsonPath_ = other.jsonPath_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureNamespacesIsMutable();
                  namespaces_.add(s);
                  break;
                } // case 10
              case 18:
                {
                  com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind m =
                      input.readMessage(
                          com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind.parser(),
                          extensionRegistry);
                  if (groupKindsBuilder_ == null) {
                    ensureGroupKindsIsMutable();
                    groupKinds_.add(m);
                  } else {
                    groupKindsBuilder_.addMessage(m);
                  }
                  break;
                } // case 18
              case 26:
                {
                  jsonPath_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.LazyStringArrayList namespaces_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureNamespacesIsMutable() {
        if (!namespaces_.isModifiable()) {
          namespaces_ = new com.google.protobuf.LazyStringArrayList(namespaces_);
        }
        bitField0_ |= 0x00000001;
      }
      /**
       *
       *
       * <pre>
       * (Filtering parameter) Any resource subject to transformation must be
       * contained within one of the listed Kubernetes Namespace in the Backup.
       * If this field is not provided, no namespace filtering will be performed
       * (all resources in all Namespaces, including all cluster-scoped resources,
       * will be candidates for transformation).
       * To mix cluster-scoped and namespaced resources in the same rule, use an
       * empty string ("") as one of the target namespaces.
       * </pre>
       *
       * <code>repeated string namespaces = 1;</code>
       *
       * @return A list containing the namespaces.
       */
      public com.google.protobuf.ProtocolStringList getNamespacesList() {
        namespaces_.makeImmutable();
        return namespaces_;
      }
      /**
       *
       *
       * <pre>
       * (Filtering parameter) Any resource subject to transformation must be
       * contained within one of the listed Kubernetes Namespace in the Backup.
       * If this field is not provided, no namespace filtering will be performed
       * (all resources in all Namespaces, including all cluster-scoped resources,
       * will be candidates for transformation).
       * To mix cluster-scoped and namespaced resources in the same rule, use an
       * empty string ("") as one of the target namespaces.
       * </pre>
       *
       * <code>repeated string namespaces = 1;</code>
       *
       * @return The count of namespaces.
       */
      public int getNamespacesCount() {
        return namespaces_.size();
      }
      /**
       *
       *
       * <pre>
       * (Filtering parameter) Any resource subject to transformation must be
       * contained within one of the listed Kubernetes Namespace in the Backup.
       * If this field is not provided, no namespace filtering will be performed
       * (all resources in all Namespaces, including all cluster-scoped resources,
       * will be candidates for transformation).
       * To mix cluster-scoped and namespaced resources in the same rule, use an
       * empty string ("") as one of the target namespaces.
       * </pre>
       *
       * <code>repeated string namespaces = 1;</code>
       *
       * @param index The index of the element to return.
       * @return The namespaces at the given index.
       */
      public java.lang.String getNamespaces(int index) {
        return namespaces_.get(index);
      }
      /**
       *
       *
       * <pre>
       * (Filtering parameter) Any resource subject to transformation must be
       * contained within one of the listed Kubernetes Namespace in the Backup.
       * If this field is not provided, no namespace filtering will be performed
       * (all resources in all Namespaces, including all cluster-scoped resources,
       * will be candidates for transformation).
       * To mix cluster-scoped and namespaced resources in the same rule, use an
       * empty string ("") as one of the target namespaces.
       * </pre>
       *
       * <code>repeated string namespaces = 1;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the namespaces at the given index.
       */
      public com.google.protobuf.ByteString getNamespacesBytes(int index) {
        return namespaces_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * (Filtering parameter) Any resource subject to transformation must be
       * contained within one of the listed Kubernetes Namespace in the Backup.
       * If this field is not provided, no namespace filtering will be performed
       * (all resources in all Namespaces, including all cluster-scoped resources,
       * will be candidates for transformation).
       * To mix cluster-scoped and namespaced resources in the same rule, use an
       * empty string ("") as one of the target namespaces.
       * </pre>
       *
       * <code>repeated string namespaces = 1;</code>
       *
       * @param index The index to set the value at.
       * @param value The namespaces to set.
       * @return This builder for chaining.
       */
      public Builder setNamespaces(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNamespacesIsMutable();
        namespaces_.set(index, value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * (Filtering parameter) Any resource subject to transformation must be
       * contained within one of the listed Kubernetes Namespace in the Backup.
       * If this field is not provided, no namespace filtering will be performed
       * (all resources in all Namespaces, including all cluster-scoped resources,
       * will be candidates for transformation).
       * To mix cluster-scoped and namespaced resources in the same rule, use an
       * empty string ("") as one of the target namespaces.
       * </pre>
       *
       * <code>repeated string namespaces = 1;</code>
       *
       * @param value The namespaces to add.
       * @return This builder for chaining.
       */
      public Builder addNamespaces(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNamespacesIsMutable();
        namespaces_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * (Filtering parameter) Any resource subject to transformation must be
       * contained within one of the listed Kubernetes Namespace in the Backup.
       * If this field is not provided, no namespace filtering will be performed
       * (all resources in all Namespaces, including all cluster-scoped resources,
       * will be candidates for transformation).
       * To mix cluster-scoped and namespaced resources in the same rule, use an
       * empty string ("") as one of the target namespaces.
       * </pre>
       *
       * <code>repeated string namespaces = 1;</code>
       *
       * @param values The namespaces to add.
       * @return This builder for chaining.
       */
      public Builder addAllNamespaces(java.lang.Iterable<java.lang.String> values) {
        ensureNamespacesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, namespaces_);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * (Filtering parameter) Any resource subject to transformation must be
       * contained within one of the listed Kubernetes Namespace in the Backup.
       * If this field is not provided, no namespace filtering will be performed
       * (all resources in all Namespaces, including all cluster-scoped resources,
       * will be candidates for transformation).
       * To mix cluster-scoped and namespaced resources in the same rule, use an
       * empty string ("") as one of the target namespaces.
       * </pre>
       *
       * <code>repeated string namespaces = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearNamespaces() {
        namespaces_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * (Filtering parameter) Any resource subject to transformation must be
       * contained within one of the listed Kubernetes Namespace in the Backup.
       * If this field is not provided, no namespace filtering will be performed
       * (all resources in all Namespaces, including all cluster-scoped resources,
       * will be candidates for transformation).
       * To mix cluster-scoped and namespaced resources in the same rule, use an
       * empty string ("") as one of the target namespaces.
       * </pre>
       *
       * <code>repeated string namespaces = 1;</code>
       *
       * @param value The bytes of the namespaces to add.
       * @return This builder for chaining.
       */
      public Builder addNamespacesBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureNamespacesIsMutable();
        namespaces_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.util.List<com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind> groupKinds_ =
          java.util.Collections.emptyList();

      private void ensureGroupKindsIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          groupKinds_ =
              new java.util.ArrayList<com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind>(
                  groupKinds_);
          bitField0_ |= 0x00000002;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind,
              com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind.Builder,
              com.google.cloud.gkebackup.v1.RestoreConfig.GroupKindOrBuilder>
          groupKindsBuilder_;

      /**
       *
       *
       * <pre>
       * (Filtering parameter) Any resource subject to transformation must belong
       * to one of the listed "types". If this field is not provided, no type
       * filtering will be performed (all resources of all types matching previous
       * filtering parameters will be candidates for transformation).
       * </pre>
       *
       * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind group_kinds = 2;</code>
       */
      public java.util.List<com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind>
          getGroupKindsList() {
        if (groupKindsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(groupKinds_);
        } else {
          return groupKindsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * (Filtering parameter) Any resource subject to transformation must belong
       * to one of the listed "types". If this field is not provided, no type
       * filtering will be performed (all resources of all types matching previous
       * filtering parameters will be candidates for transformation).
       * </pre>
       *
       * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind group_kinds = 2;</code>
       */
      public int getGroupKindsCount() {
        if (groupKindsBuilder_ == null) {
          return groupKinds_.size();
        } else {
          return groupKindsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * (Filtering parameter) Any resource subject to transformation must belong
       * to one of the listed "types". If this field is not provided, no type
       * filtering will be performed (all resources of all types matching previous
       * filtering parameters will be candidates for transformation).
       * </pre>
       *
       * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind group_kinds = 2;</code>
       */
      public com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind getGroupKinds(int index) {
        if (groupKindsBuilder_ == null) {
          return groupKinds_.get(index);
        } else {
          return groupKindsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * (Filtering parameter) Any resource subject to transformation must belong
       * to one of the listed "types". If this field is not provided, no type
       * filtering will be performed (all resources of all types matching previous
       * filtering parameters will be candidates for transformation).
       * </pre>
       *
       * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind group_kinds = 2;</code>
       */
      public Builder setGroupKinds(
          int index, com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind value) {
        if (groupKindsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureGroupKindsIsMutable();
          groupKinds_.set(index, value);
          onChanged();
        } else {
          groupKindsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * (Filtering parameter) Any resource subject to transformation must belong
       * to one of the listed "types". If this field is not provided, no type
       * filtering will be performed (all resources of all types matching previous
       * filtering parameters will be candidates for transformation).
       * </pre>
       *
       * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind group_kinds = 2;</code>
       */
      public Builder setGroupKinds(
          int index,
          com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind.Builder builderForValue) {
        if (groupKindsBuilder_ == null) {
          ensureGroupKindsIsMutable();
          groupKinds_.set(index, builderForValue.build());
          onChanged();
        } else {
          groupKindsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * (Filtering parameter) Any resource subject to transformation must belong
       * to one of the listed "types". If this field is not provided, no type
       * filtering will be performed (all resources of all types matching previous
       * filtering parameters will be candidates for transformation).
       * </pre>
       *
       * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind group_kinds = 2;</code>
       */
      public Builder addGroupKinds(com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind value) {
        if (groupKindsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureGroupKindsIsMutable();
          groupKinds_.add(value);
          onChanged();
        } else {
          groupKindsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * (Filtering parameter) Any resource subject to transformation must belong
       * to one of the listed "types". If this field is not provided, no type
       * filtering will be performed (all resources of all types matching previous
       * filtering parameters will be candidates for transformation).
       * </pre>
       *
       * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind group_kinds = 2;</code>
       */
      public Builder addGroupKinds(
          int index, com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind value) {
        if (groupKindsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureGroupKindsIsMutable();
          groupKinds_.add(index, value);
          onChanged();
        } else {
          groupKindsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * (Filtering parameter) Any resource subject to transformation must belong
       * to one of the listed "types". If this field is not provided, no type
       * filtering will be performed (all resources of all types matching previous
       * filtering parameters will be candidates for transformation).
       * </pre>
       *
       * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind group_kinds = 2;</code>
       */
      public Builder addGroupKinds(
          com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind.Builder builderForValue) {
        if (groupKindsBuilder_ == null) {
          ensureGroupKindsIsMutable();
          groupKinds_.add(builderForValue.build());
          onChanged();
        } else {
          groupKindsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * (Filtering parameter) Any resource subject to transformation must belong
       * to one of the listed "types". If this field is not provided, no type
       * filtering will be performed (all resources of all types matching previous
       * filtering parameters will be candidates for transformation).
       * </pre>
       *
       * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind group_kinds = 2;</code>
       */
      public Builder addGroupKinds(
          int index,
          com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind.Builder builderForValue) {
        if (groupKindsBuilder_ == null) {
          ensureGroupKindsIsMutable();
          groupKinds_.add(index, builderForValue.build());
          onChanged();
        } else {
          groupKindsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * (Filtering parameter) Any resource subject to transformation must belong
       * to one of the listed "types". If this field is not provided, no type
       * filtering will be performed (all resources of all types matching previous
       * filtering parameters will be candidates for transformation).
       * </pre>
       *
       * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind group_kinds = 2;</code>
       */
      public Builder addAllGroupKinds(
          java.lang.Iterable<? extends com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind>
              values) {
        if (groupKindsBuilder_ == null) {
          ensureGroupKindsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, groupKinds_);
          onChanged();
        } else {
          groupKindsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * (Filtering parameter) Any resource subject to transformation must belong
       * to one of the listed "types". If this field is not provided, no type
       * filtering will be performed (all resources of all types matching previous
       * filtering parameters will be candidates for transformation).
       * </pre>
       *
       * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind group_kinds = 2;</code>
       */
      public Builder clearGroupKinds() {
        if (groupKindsBuilder_ == null) {
          groupKinds_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          groupKindsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * (Filtering parameter) Any resource subject to transformation must belong
       * to one of the listed "types". If this field is not provided, no type
       * filtering will be performed (all resources of all types matching previous
       * filtering parameters will be candidates for transformation).
       * </pre>
       *
       * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind group_kinds = 2;</code>
       */
      public Builder removeGroupKinds(int index) {
        if (groupKindsBuilder_ == null) {
          ensureGroupKindsIsMutable();
          groupKinds_.remove(index);
          onChanged();
        } else {
          groupKindsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * (Filtering parameter) Any resource subject to transformation must belong
       * to one of the listed "types". If this field is not provided, no type
       * filtering will be performed (all resources of all types matching previous
       * filtering parameters will be candidates for transformation).
       * </pre>
       *
       * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind group_kinds = 2;</code>
       */
      public com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind.Builder getGroupKindsBuilder(
          int index) {
        return getGroupKindsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * (Filtering parameter) Any resource subject to transformation must belong
       * to one of the listed "types". If this field is not provided, no type
       * filtering will be performed (all resources of all types matching previous
       * filtering parameters will be candidates for transformation).
       * </pre>
       *
       * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind group_kinds = 2;</code>
       */
      public com.google.cloud.gkebackup.v1.RestoreConfig.GroupKindOrBuilder getGroupKindsOrBuilder(
          int index) {
        if (groupKindsBuilder_ == null) {
          return groupKinds_.get(index);
        } else {
          return groupKindsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * (Filtering parameter) Any resource subject to transformation must belong
       * to one of the listed "types". If this field is not provided, no type
       * filtering will be performed (all resources of all types matching previous
       * filtering parameters will be candidates for transformation).
       * </pre>
       *
       * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind group_kinds = 2;</code>
       */
      public java.util.List<
              ? extends com.google.cloud.gkebackup.v1.RestoreConfig.GroupKindOrBuilder>
          getGroupKindsOrBuilderList() {
        if (groupKindsBuilder_ != null) {
          return groupKindsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(groupKinds_);
        }
      }
      /**
       *
       *
       * <pre>
       * (Filtering parameter) Any resource subject to transformation must belong
       * to one of the listed "types". If this field is not provided, no type
       * filtering will be performed (all resources of all types matching previous
       * filtering parameters will be candidates for transformation).
       * </pre>
       *
       * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind group_kinds = 2;</code>
       */
      public com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind.Builder addGroupKindsBuilder() {
        return getGroupKindsFieldBuilder()
            .addBuilder(com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * (Filtering parameter) Any resource subject to transformation must belong
       * to one of the listed "types". If this field is not provided, no type
       * filtering will be performed (all resources of all types matching previous
       * filtering parameters will be candidates for transformation).
       * </pre>
       *
       * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind group_kinds = 2;</code>
       */
      public com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind.Builder addGroupKindsBuilder(
          int index) {
        return getGroupKindsFieldBuilder()
            .addBuilder(
                index, com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * (Filtering parameter) Any resource subject to transformation must belong
       * to one of the listed "types". If this field is not provided, no type
       * filtering will be performed (all resources of all types matching previous
       * filtering parameters will be candidates for transformation).
       * </pre>
       *
       * <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind group_kinds = 2;</code>
       */
      public java.util.List<com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind.Builder>
          getGroupKindsBuilderList() {
        return getGroupKindsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind,
              com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind.Builder,
              com.google.cloud.gkebackup.v1.RestoreConfig.GroupKindOrBuilder>
          getGroupKindsFieldBuilder() {
        if (groupKindsBuilder_ == null) {
          groupKindsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind,
                  com.google.cloud.gkebackup.v1.RestoreConfig.GroupKind.Builder,
                  com.google.cloud.gkebackup.v1.RestoreConfig.GroupKindOrBuilder>(
                  groupKinds_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
          groupKinds_ = null;
        }
        return groupKindsBuilder_;
      }

      private java.lang.Object jsonPath_ = "";
      /**
       *
       *
       * <pre>
       * This is a [JSONPath]
       * (https://github.com/json-path/JsonPath/blob/master/README.md)
       * expression that matches specific fields of candidate
       * resources and it operates as a filtering parameter (resources that
       * are not matched with this expression will not be candidates for
       * transformation).
       * </pre>
       *
       * <code>string json_path = 3;</code>
       *
       * @return The jsonPath.
       */
      public java.lang.String getJsonPath() {
        java.lang.Object ref = jsonPath_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          jsonPath_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * This is a [JSONPath]
       * (https://github.com/json-path/JsonPath/blob/master/README.md)
       * expression that matches specific fields of candidate
       * resources and it operates as a filtering parameter (resources that
       * are not matched with this expression will not be candidates for
       * transformation).
       * </pre>
       *
       * <code>string json_path = 3;</code>
       *
       * @return The bytes for jsonPath.
       */
      public com.google.protobuf.ByteString getJsonPathBytes() {
        java.lang.Object ref = jsonPath_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          jsonPath_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * This is a [JSONPath]
       * (https://github.com/json-path/JsonPath/blob/master/README.md)
       * expression that matches specific fields of candidate
       * resources and it operates as a filtering parameter (resources that
       * are not matched with this expression will not be candidates for
       * transformation).
       * </pre>
       *
       * <code>string json_path = 3;</code>
       *
       * @param value The jsonPath to set.
       * @return This builder for chaining.
       */
      public Builder setJsonPath(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        jsonPath_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * This is a [JSONPath]
       * (https://github.com/json-path/JsonPath/blob/master/README.md)
       * expression that matches specific fields of candidate
       * resources and it operates as a filtering parameter (resources that
       * are not matched with this expression will not be candidates for
       * transformation).
       * </pre>
       *
       * <code>string json_path = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearJsonPath() {
        jsonPath_ = getDefaultInstance().getJsonPath();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * This is a [JSONPath]
       * (https://github.com/json-path/JsonPath/blob/master/README.md)
       * expression that matches specific fields of candidate
       * resources and it operates as a filtering parameter (resources that
       * are not matched with this expression will not be candidates for
       * transformation).
       * </pre>
       *
       * <code>string json_path = 3;</code>
       *
       * @param value The bytes for jsonPath to set.
       * @return This builder for chaining.
       */
      public Builder setJsonPathBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        jsonPath_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter)
    private static final com.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter();
    }

    public static com.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ResourceFilter> PARSER =
        new com.google.protobuf.AbstractParser<ResourceFilter>() {
          @java.lang.Override
          public ResourceFilter parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ResourceFilter> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ResourceFilter> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface TransformationRuleOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.gkebackup.v1.RestoreConfig.TransformationRule)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. A list of transformation rule actions to take against candidate
     * resources. Actions are executed in order defined - this order matters, as
     * they could potentially interfere with each other and the first operation
     * could affect the outcome of the second operation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction field_actions = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    java.util.List<com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction>
        getFieldActionsList();
    /**
     *
     *
     * <pre>
     * Required. A list of transformation rule actions to take against candidate
     * resources. Actions are executed in order defined - this order matters, as
     * they could potentially interfere with each other and the first operation
     * could affect the outcome of the second operation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction field_actions = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction getFieldActions(int index);
    /**
     *
     *
     * <pre>
     * Required. A list of transformation rule actions to take against candidate
     * resources. Actions are executed in order defined - this order matters, as
     * they could potentially interfere with each other and the first operation
     * could affect the outcome of the second operation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction field_actions = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    int getFieldActionsCount();
    /**
     *
     *
     * <pre>
     * Required. A list of transformation rule actions to take against candidate
     * resources. Actions are executed in order defined - this order matters, as
     * they could potentially interfere with each other and the first operation
     * could affect the outcome of the second operation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction field_actions = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    java.util.List<
            ? extends com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleActionOrBuilder>
        getFieldActionsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Required. A list of transformation rule actions to take against candidate
     * resources. Actions are executed in order defined - this order matters, as
     * they could potentially interfere with each other and the first operation
     * could affect the outcome of the second operation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction field_actions = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleActionOrBuilder
        getFieldActionsOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * This field is used to specify a set of fields that should be used to
     * determine which resources in backup should be acted upon by the supplied
     * transformation rule actions, and this will ensure that only specific
     * resources are affected by transformation rule actions.
     * </pre>
     *
     * <code>.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter resource_filter = 2;</code>
     *
     * @return Whether the resourceFilter field is set.
     */
    boolean hasResourceFilter();
    /**
     *
     *
     * <pre>
     * This field is used to specify a set of fields that should be used to
     * determine which resources in backup should be acted upon by the supplied
     * transformation rule actions, and this will ensure that only specific
     * resources are affected by transformation rule actions.
     * </pre>
     *
     * <code>.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter resource_filter = 2;</code>
     *
     * @return The resourceFilter.
     */
    com.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter getResourceFilter();
    /**
     *
     *
     * <pre>
     * This field is used to specify a set of fields that should be used to
     * determine which resources in backup should be acted upon by the supplied
     * transformation rule actions, and this will ensure that only specific
     * resources are affected by transformation rule actions.
     * </pre>
     *
     * <code>.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter resource_filter = 2;</code>
     */
    com.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilterOrBuilder
        getResourceFilterOrBuilder();

    /**
     *
     *
     * <pre>
     * The description is a user specified string description of the
     * transformation rule.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The description.
     */
    java.lang.String getDescription();
    /**
     *
     *
     * <pre>
     * The description is a user specified string description of the
     * transformation rule.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The bytes for description.
     */
    com.google.protobuf.ByteString getDescriptionBytes();
  }
  /**
   *
   *
   * <pre>
   * A transformation rule to be applied against Kubernetes resources as they
   * are selected for restoration from a Backup. A rule contains both filtering
   * logic (which resources are subject to transform) and transformation logic.
   * </pre>
   *
   * Protobuf type {@code google.cloud.gkebackup.v1.RestoreConfig.TransformationRule}
   */
  public static final class TransformationRule extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.gkebackup.v1.RestoreConfig.TransformationRule)
      TransformationRuleOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use TransformationRule.newBuilder() to construct.
    private TransformationRule(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private TransformationRule() {
      fieldActions_ = java.util.Collections.emptyList();
      description_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new TransformationRule();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.gkebackup.v1.RestoreProto
          .internal_static_google_cloud_gkebackup_v1_RestoreConfig_TransformationRule_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.gkebackup.v1.RestoreProto
          .internal_static_google_cloud_gkebackup_v1_RestoreConfig_TransformationRule_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRule.class,
              com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRule.Builder.class);
    }

    public static final int FIELD_ACTIONS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction>
        fieldActions_;
    /**
     *
     *
     * <pre>
     * Required. A list of transformation rule actions to take against candidate
     * resources. Actions are executed in order defined - this order matters, as
     * they could potentially interfere with each other and the first operation
     * could affect the outcome of the second operation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction field_actions = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction>
        getFieldActionsList() {
      return fieldActions_;
    }
    /**
     *
     *
     * <pre>
     * Required. A list of transformation rule actions to take against candidate
     * resources. Actions are executed in order defined - this order matters, as
     * they could potentially interfere with each other and the first operation
     * could affect the outcome of the second operation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction field_actions = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleActionOrBuilder>
        getFieldActionsOrBuilderList() {
      return fieldActions_;
    }
    /**
     *
     *
     * <pre>
     * Required. A list of transformation rule actions to take against candidate
     * resources. Actions are executed in order defined - this order matters, as
     * they could potentially interfere with each other and the first operation
     * could affect the outcome of the second operation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction field_actions = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public int getFieldActionsCount() {
      return fieldActions_.size();
    }
    /**
     *
     *
     * <pre>
     * Required. A list of transformation rule actions to take against candidate
     * resources. Actions are executed in order defined - this order matters, as
     * they could potentially interfere with each other and the first operation
     * could affect the outcome of the second operation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction field_actions = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction getFieldActions(
        int index) {
      return fieldActions_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Required. A list of transformation rule actions to take against candidate
     * resources. Actions are executed in order defined - this order matters, as
     * they could potentially interfere with each other and the first operation
     * could affect the outcome of the second operation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction field_actions = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleActionOrBuilder
        getFieldActionsOrBuilder(int index) {
      return fieldActions_.get(index);
    }

    public static final int RESOURCE_FILTER_FIELD_NUMBER = 2;
    private com.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter resourceFilter_;
    /**
     *
     *
     * <pre>
     * This field is used to specify a set of fields that should be used to
     * determine which resources in backup should be acted upon by the supplied
     * transformation rule actions, and this will ensure that only specific
     * resources are affected by transformation rule actions.
     * </pre>
     *
     * <code>.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter resource_filter = 2;</code>
     *
     * @return Whether the resourceFilter field is set.
     */
    @java.lang.Override
    public boolean hasResourceFilter() {
      return resourceFilter_ != null;
    }
    /**
     *
     *
     * <pre>
     * This field is used to specify a set of fields that should be used to
     * determine which resources in backup should be acted upon by the supplied
     * transformation rule actions, and this will ensure that only specific
     * resources are affected by transformation rule actions.
     * </pre>
     *
     * <code>.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter resource_filter = 2;</code>
     *
     * @return The resourceFilter.
     */
    @java.lang.Override
    public com.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter getResourceFilter() {
      return resourceFilter_ == null
          ? com.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter.getDefaultInstance()
          : resourceFilter_;
    }
    /**
     *
     *
     * <pre>
     * This field is used to specify a set of fields that should be used to
     * determine which resources in backup should be acted upon by the supplied
     * transformation rule actions, and this will ensure that only specific
     * resources are affected by transformation rule actions.
     * </pre>
     *
     * <code>.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter resource_filter = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilterOrBuilder
        getResourceFilterOrBuilder() {
      return resourceFilter_ == null
          ? com.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter.getDefaultInstance()
          : resourceFilter_;
    }

    public static final int DESCRIPTION_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * The description is a user specified string description of the
     * transformation rule.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The description.
     */
    @java.lang.Override
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The description is a user specified string description of the
     * transformation rule.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The bytes for description.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < fieldActions_.size(); i++) {
        output.writeMessage(1, fieldActions_.get(i));
      }
      if (resourceFilter_ != null) {
        output.writeMessage(2, getResourceFilter());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, description_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < fieldActions_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, fieldActions_.get(i));
      }
      if (resourceFilter_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getResourceFilter());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, description_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRule)) {
        return super.equals(obj);
      }
      com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRule other =
          (com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRule) obj;

      if (!getFieldActionsList().equals(other.getFieldActionsList())) return false;
      if (hasResourceFilter() != other.hasResourceFilter()) return false;
      if (hasResourceFilter()) {
        if (!getResourceFilter().equals(other.getResourceFilter())) return false;
      }
      if (!getDescription().equals(other.getDescription())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getFieldActionsCount() > 0) {
        hash = (37 * hash) + FIELD_ACTIONS_FIELD_NUMBER;
        hash = (53 * hash) + getFieldActionsList().hashCode();
      }
      if (hasResourceFilter()) {
        hash = (37 * hash) + RESOURCE_FILTER_FIELD_NUMBER;
        hash = (53 * hash) + getResourceFilter().hashCode();
      }
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRule parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRule parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRule parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRule parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRule parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRule parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRule parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRule parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRule parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRule parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRule parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRule parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRule prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A transformation rule to be applied against Kubernetes resources as they
     * are selected for restoration from a Backup. A rule contains both filtering
     * logic (which resources are subject to transform) and transformation logic.
     * </pre>
     *
     * Protobuf type {@code google.cloud.gkebackup.v1.RestoreConfig.TransformationRule}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.gkebackup.v1.RestoreConfig.TransformationRule)
        com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.gkebackup.v1.RestoreProto
            .internal_static_google_cloud_gkebackup_v1_RestoreConfig_TransformationRule_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.gkebackup.v1.RestoreProto
            .internal_static_google_cloud_gkebackup_v1_RestoreConfig_TransformationRule_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRule.class,
                com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRule.Builder.class);
      }

      // Construct using com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRule.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (fieldActionsBuilder_ == null) {
          fieldActions_ = java.util.Collections.emptyList();
        } else {
          fieldActions_ = null;
          fieldActionsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        resourceFilter_ = null;
        if (resourceFilterBuilder_ != null) {
          resourceFilterBuilder_.dispose();
          resourceFilterBuilder_ = null;
        }
        description_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.gkebackup.v1.RestoreProto
            .internal_static_google_cloud_gkebackup_v1_RestoreConfig_TransformationRule_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRule
          getDefaultInstanceForType() {
        return com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRule.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRule build() {
        com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRule result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRule buildPartial() {
        com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRule result =
            new com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRule(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRule result) {
        if (fieldActionsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            fieldActions_ = java.util.Collections.unmodifiableList(fieldActions_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.fieldActions_ = fieldActions_;
        } else {
          result.fieldActions_ = fieldActionsBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRule result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.resourceFilter_ =
              resourceFilterBuilder_ == null ? resourceFilter_ : resourceFilterBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.description_ = description_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRule) {
          return mergeFrom((com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRule) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRule other) {
        if (other
            == com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRule.getDefaultInstance())
          return this;
        if (fieldActionsBuilder_ == null) {
          if (!other.fieldActions_.isEmpty()) {
            if (fieldActions_.isEmpty()) {
              fieldActions_ = other.fieldActions_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureFieldActionsIsMutable();
              fieldActions_.addAll(other.fieldActions_);
            }
            onChanged();
          }
        } else {
          if (!other.fieldActions_.isEmpty()) {
            if (fieldActionsBuilder_.isEmpty()) {
              fieldActionsBuilder_.dispose();
              fieldActionsBuilder_ = null;
              fieldActions_ = other.fieldActions_;
              bitField0_ = (bitField0_ & ~0x00000001);
              fieldActionsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getFieldActionsFieldBuilder()
                      : null;
            } else {
              fieldActionsBuilder_.addAllMessages(other.fieldActions_);
            }
          }
        }
        if (other.hasResourceFilter()) {
          mergeResourceFilter(other.getResourceFilter());
        }
        if (!other.getDescription().isEmpty()) {
          description_ = other.description_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction m =
                      input.readMessage(
                          com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction
                              .parser(),
                          extensionRegistry);
                  if (fieldActionsBuilder_ == null) {
                    ensureFieldActionsIsMutable();
                    fieldActions_.add(m);
                  } else {
                    fieldActionsBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(
                      getResourceFilterFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  description_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction>
          fieldActions_ = java.util.Collections.emptyList();

      private void ensureFieldActionsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          fieldActions_ =
              new java.util.ArrayList<
                  com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction>(
                  fieldActions_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction,
              com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction.Builder,
              com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleActionOrBuilder>
          fieldActionsBuilder_;

      /**
       *
       *
       * <pre>
       * Required. A list of transformation rule actions to take against candidate
       * resources. Actions are executed in order defined - this order matters, as
       * they could potentially interfere with each other and the first operation
       * could affect the outcome of the second operation.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction field_actions = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public java.util.List<com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction>
          getFieldActionsList() {
        if (fieldActionsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(fieldActions_);
        } else {
          return fieldActionsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. A list of transformation rule actions to take against candidate
       * resources. Actions are executed in order defined - this order matters, as
       * they could potentially interfere with each other and the first operation
       * could affect the outcome of the second operation.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction field_actions = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public int getFieldActionsCount() {
        if (fieldActionsBuilder_ == null) {
          return fieldActions_.size();
        } else {
          return fieldActionsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. A list of transformation rule actions to take against candidate
       * resources. Actions are executed in order defined - this order matters, as
       * they could potentially interfere with each other and the first operation
       * could affect the outcome of the second operation.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction field_actions = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction getFieldActions(
          int index) {
        if (fieldActionsBuilder_ == null) {
          return fieldActions_.get(index);
        } else {
          return fieldActionsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Required. A list of transformation rule actions to take against candidate
       * resources. Actions are executed in order defined - this order matters, as
       * they could potentially interfere with each other and the first operation
       * could affect the outcome of the second operation.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction field_actions = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setFieldActions(
          int index, com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction value) {
        if (fieldActionsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFieldActionsIsMutable();
          fieldActions_.set(index, value);
          onChanged();
        } else {
          fieldActionsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. A list of transformation rule actions to take against candidate
       * resources. Actions are executed in order defined - this order matters, as
       * they could potentially interfere with each other and the first operation
       * could affect the outcome of the second operation.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction field_actions = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setFieldActions(
          int index,
          com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction.Builder
              builderForValue) {
        if (fieldActionsBuilder_ == null) {
          ensureFieldActionsIsMutable();
          fieldActions_.set(index, builderForValue.build());
          onChanged();
        } else {
          fieldActionsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. A list of transformation rule actions to take against candidate
       * resources. Actions are executed in order defined - this order matters, as
       * they could potentially interfere with each other and the first operation
       * could affect the outcome of the second operation.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction field_actions = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addFieldActions(
          com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction value) {
        if (fieldActionsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFieldActionsIsMutable();
          fieldActions_.add(value);
          onChanged();
        } else {
          fieldActionsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. A list of transformation rule actions to take against candidate
       * resources. Actions are executed in order defined - this order matters, as
       * they could potentially interfere with each other and the first operation
       * could affect the outcome of the second operation.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction field_actions = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addFieldActions(
          int index, com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction value) {
        if (fieldActionsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFieldActionsIsMutable();
          fieldActions_.add(index, value);
          onChanged();
        } else {
          fieldActionsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. A list of transformation rule actions to take against candidate
       * resources. Actions are executed in order defined - this order matters, as
       * they could potentially interfere with each other and the first operation
       * could affect the outcome of the second operation.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction field_actions = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addFieldActions(
          com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction.Builder
              builderForValue) {
        if (fieldActionsBuilder_ == null) {
          ensureFieldActionsIsMutable();
          fieldActions_.add(builderForValue.build());
          onChanged();
        } else {
          fieldActionsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. A list of transformation rule actions to take against candidate
       * resources. Actions are executed in order defined - this order matters, as
       * they could potentially interfere with each other and the first operation
       * could affect the outcome of the second operation.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction field_actions = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addFieldActions(
          int index,
          com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction.Builder
              builderForValue) {
        if (fieldActionsBuilder_ == null) {
          ensureFieldActionsIsMutable();
          fieldActions_.add(index, builderForValue.build());
          onChanged();
        } else {
          fieldActionsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. A list of transformation rule actions to take against candidate
       * resources. Actions are executed in order defined - this order matters, as
       * they could potentially interfere with each other and the first operation
       * could affect the outcome of the second operation.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction field_actions = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addAllFieldActions(
          java.lang.Iterable<
                  ? extends com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction>
              values) {
        if (fieldActionsBuilder_ == null) {
          ensureFieldActionsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, fieldActions_);
          onChanged();
        } else {
          fieldActionsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. A list of transformation rule actions to take against candidate
       * resources. Actions are executed in order defined - this order matters, as
       * they could potentially interfere with each other and the first operation
       * could affect the outcome of the second operation.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction field_actions = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearFieldActions() {
        if (fieldActionsBuilder_ == null) {
          fieldActions_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          fieldActionsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. A list of transformation rule actions to take against candidate
       * resources. Actions are executed in order defined - this order matters, as
       * they could potentially interfere with each other and the first operation
       * could affect the outcome of the second operation.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction field_actions = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder removeFieldActions(int index) {
        if (fieldActionsBuilder_ == null) {
          ensureFieldActionsIsMutable();
          fieldActions_.remove(index);
          onChanged();
        } else {
          fieldActionsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. A list of transformation rule actions to take against candidate
       * resources. Actions are executed in order defined - this order matters, as
       * they could potentially interfere with each other and the first operation
       * could affect the outcome of the second operation.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction field_actions = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction.Builder
          getFieldActionsBuilder(int index) {
        return getFieldActionsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Required. A list of transformation rule actions to take against candidate
       * resources. Actions are executed in order defined - this order matters, as
       * they could potentially interfere with each other and the first operation
       * could affect the outcome of the second operation.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction field_actions = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleActionOrBuilder
          getFieldActionsOrBuilder(int index) {
        if (fieldActionsBuilder_ == null) {
          return fieldActions_.get(index);
        } else {
          return fieldActionsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Required. A list of transformation rule actions to take against candidate
       * resources. Actions are executed in order defined - this order matters, as
       * they could potentially interfere with each other and the first operation
       * could affect the outcome of the second operation.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction field_actions = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleActionOrBuilder>
          getFieldActionsOrBuilderList() {
        if (fieldActionsBuilder_ != null) {
          return fieldActionsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(fieldActions_);
        }
      }
      /**
       *
       *
       * <pre>
       * Required. A list of transformation rule actions to take against candidate
       * resources. Actions are executed in order defined - this order matters, as
       * they could potentially interfere with each other and the first operation
       * could affect the outcome of the second operation.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction field_actions = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction.Builder
          addFieldActionsBuilder() {
        return getFieldActionsFieldBuilder()
            .addBuilder(
                com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Required. A list of transformation rule actions to take against candidate
       * resources. Actions are executed in order defined - this order matters, as
       * they could potentially interfere with each other and the first operation
       * could affect the outcome of the second operation.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction field_actions = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction.Builder
          addFieldActionsBuilder(int index) {
        return getFieldActionsFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Required. A list of transformation rule actions to take against candidate
       * resources. Actions are executed in order defined - this order matters, as
       * they could potentially interfere with each other and the first operation
       * could affect the outcome of the second operation.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction field_actions = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public java.util.List<
              com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction.Builder>
          getFieldActionsBuilderList() {
        return getFieldActionsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction,
              com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction.Builder,
              com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleActionOrBuilder>
          getFieldActionsFieldBuilder() {
        if (fieldActionsBuilder_ == null) {
          fieldActionsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction,
                  com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction.Builder,
                  com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleActionOrBuilder>(
                  fieldActions_,
                  ((bitField0_ & 0x00000001) != 0),
                  getParentForChildren(),
                  isClean());
          fieldActions_ = null;
        }
        return fieldActionsBuilder_;
      }

      private com.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter resourceFilter_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter,
              com.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter.Builder,
              com.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilterOrBuilder>
          resourceFilterBuilder_;
      /**
       *
       *
       * <pre>
       * This field is used to specify a set of fields that should be used to
       * determine which resources in backup should be acted upon by the supplied
       * transformation rule actions, and this will ensure that only specific
       * resources are affected by transformation rule actions.
       * </pre>
       *
       * <code>.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter resource_filter = 2;</code>
       *
       * @return Whether the resourceFilter field is set.
       */
      public boolean hasResourceFilter() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * This field is used to specify a set of fields that should be used to
       * determine which resources in backup should be acted upon by the supplied
       * transformation rule actions, and this will ensure that only specific
       * resources are affected by transformation rule actions.
       * </pre>
       *
       * <code>.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter resource_filter = 2;</code>
       *
       * @return The resourceFilter.
       */
      public com.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter getResourceFilter() {
        if (resourceFilterBuilder_ == null) {
          return resourceFilter_ == null
              ? com.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter.getDefaultInstance()
              : resourceFilter_;
        } else {
          return resourceFilterBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * This field is used to specify a set of fields that should be used to
       * determine which resources in backup should be acted upon by the supplied
       * transformation rule actions, and this will ensure that only specific
       * resources are affected by transformation rule actions.
       * </pre>
       *
       * <code>.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter resource_filter = 2;</code>
       */
      public Builder setResourceFilter(
          com.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter value) {
        if (resourceFilterBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          resourceFilter_ = value;
        } else {
          resourceFilterBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * This field is used to specify a set of fields that should be used to
       * determine which resources in backup should be acted upon by the supplied
       * transformation rule actions, and this will ensure that only specific
       * resources are affected by transformation rule actions.
       * </pre>
       *
       * <code>.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter resource_filter = 2;</code>
       */
      public Builder setResourceFilter(
          com.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter.Builder builderForValue) {
        if (resourceFilterBuilder_ == null) {
          resourceFilter_ = builderForValue.build();
        } else {
          resourceFilterBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * This field is used to specify a set of fields that should be used to
       * determine which resources in backup should be acted upon by the supplied
       * transformation rule actions, and this will ensure that only specific
       * resources are affected by transformation rule actions.
       * </pre>
       *
       * <code>.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter resource_filter = 2;</code>
       */
      public Builder mergeResourceFilter(
          com.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter value) {
        if (resourceFilterBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && resourceFilter_ != null
              && resourceFilter_
                  != com.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter
                      .getDefaultInstance()) {
            getResourceFilterBuilder().mergeFrom(value);
          } else {
            resourceFilter_ = value;
          }
        } else {
          resourceFilterBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * This field is used to specify a set of fields that should be used to
       * determine which resources in backup should be acted upon by the supplied
       * transformation rule actions, and this will ensure that only specific
       * resources are affected by transformation rule actions.
       * </pre>
       *
       * <code>.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter resource_filter = 2;</code>
       */
      public Builder clearResourceFilter() {
        bitField0_ = (bitField0_ & ~0x00000002);
        resourceFilter_ = null;
        if (resourceFilterBuilder_ != null) {
          resourceFilterBuilder_.dispose();
          resourceFilterBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * This field is used to specify a set of fields that should be used to
       * determine which resources in backup should be acted upon by the supplied
       * transformation rule actions, and this will ensure that only specific
       * resources are affected by transformation rule actions.
       * </pre>
       *
       * <code>.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter resource_filter = 2;</code>
       */
      public com.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter.Builder
          getResourceFilterBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getResourceFilterFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * This field is used to specify a set of fields that should be used to
       * determine which resources in backup should be acted upon by the supplied
       * transformation rule actions, and this will ensure that only specific
       * resources are affected by transformation rule actions.
       * </pre>
       *
       * <code>.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter resource_filter = 2;</code>
       */
      public com.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilterOrBuilder
          getResourceFilterOrBuilder() {
        if (resourceFilterBuilder_ != null) {
          return resourceFilterBuilder_.getMessageOrBuilder();
        } else {
          return resourceFilter_ == null
              ? com.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter.getDefaultInstance()
              : resourceFilter_;
        }
      }
      /**
       *
       *
       * <pre>
       * This field is used to specify a set of fields that should be used to
       * determine which resources in backup should be acted upon by the supplied
       * transformation rule actions, and this will ensure that only specific
       * resources are affected by transformation rule actions.
       * </pre>
       *
       * <code>.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter resource_filter = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter,
              com.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter.Builder,
              com.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilterOrBuilder>
          getResourceFilterFieldBuilder() {
        if (resourceFilterBuilder_ == null) {
          resourceFilterBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter,
                  com.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter.Builder,
                  com.google.cloud.gkebackup.v1.RestoreConfig.ResourceFilterOrBuilder>(
                  getResourceFilter(), getParentForChildren(), isClean());
          resourceFilter_ = null;
        }
        return resourceFilterBuilder_;
      }

      private java.lang.Object description_ = "";
      /**
       *
       *
       * <pre>
       * The description is a user specified string description of the
       * transformation rule.
       * </pre>
       *
       * <code>string description = 3;</code>
       *
       * @return The description.
       */
      public java.lang.String getDescription() {
        java.lang.Object ref = description_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          description_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The description is a user specified string description of the
       * transformation rule.
       * </pre>
       *
       * <code>string description = 3;</code>
       *
       * @return The bytes for description.
       */
      public com.google.protobuf.ByteString getDescriptionBytes() {
        java.lang.Object ref = description_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          description_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The description is a user specified string description of the
       * transformation rule.
       * </pre>
       *
       * <code>string description = 3;</code>
       *
       * @param value The description to set.
       * @return This builder for chaining.
       */
      public Builder setDescription(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        description_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The description is a user specified string description of the
       * transformation rule.
       * </pre>
       *
       * <code>string description = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDescription() {
        description_ = getDefaultInstance().getDescription();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The description is a user specified string description of the
       * transformation rule.
       * </pre>
       *
       * <code>string description = 3;</code>
       *
       * @param value The bytes for description to set.
       * @return This builder for chaining.
       */
      public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        description_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.gkebackup.v1.RestoreConfig.TransformationRule)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.gkebackup.v1.RestoreConfig.TransformationRule)
    private static final com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRule
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRule();
    }

    public static com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRule
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<TransformationRule> PARSER =
        new com.google.protobuf.AbstractParser<TransformationRule>() {
          @java.lang.Override
          public TransformationRule parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<TransformationRule> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<TransformationRule> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRule
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int namespacedResourceRestoreScopeCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object namespacedResourceRestoreScope_;

  public enum NamespacedResourceRestoreScopeCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    ALL_NAMESPACES(5),
    SELECTED_NAMESPACES(6),
    SELECTED_APPLICATIONS(7),
    NO_NAMESPACES(9),
    EXCLUDED_NAMESPACES(10),
    NAMESPACEDRESOURCERESTORESCOPE_NOT_SET(0);
    private final int value;

    private NamespacedResourceRestoreScopeCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static NamespacedResourceRestoreScopeCase valueOf(int value) {
      return forNumber(value);
    }

    public static NamespacedResourceRestoreScopeCase forNumber(int value) {
      switch (value) {
        case 5:
          return ALL_NAMESPACES;
        case 6:
          return SELECTED_NAMESPACES;
        case 7:
          return SELECTED_APPLICATIONS;
        case 9:
          return NO_NAMESPACES;
        case 10:
          return EXCLUDED_NAMESPACES;
        case 0:
          return NAMESPACEDRESOURCERESTORESCOPE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public NamespacedResourceRestoreScopeCase getNamespacedResourceRestoreScopeCase() {
    return NamespacedResourceRestoreScopeCase.forNumber(namespacedResourceRestoreScopeCase_);
  }

  public static final int VOLUME_DATA_RESTORE_POLICY_FIELD_NUMBER = 1;
  private int volumeDataRestorePolicy_ = 0;
  /**
   *
   *
   * <pre>
   * Specifies the mechanism to be used to restore volume data.
   * Default: VOLUME_DATA_RESTORE_POLICY_UNSPECIFIED (will be treated as
   * NO_VOLUME_DATA_RESTORATION).
   * </pre>
   *
   * <code>
   * .google.cloud.gkebackup.v1.RestoreConfig.VolumeDataRestorePolicy volume_data_restore_policy = 1;
   * </code>
   *
   * @return The enum numeric value on the wire for volumeDataRestorePolicy.
   */
  @java.lang.Override
  public int getVolumeDataRestorePolicyValue() {
    return volumeDataRestorePolicy_;
  }
  /**
   *
   *
   * <pre>
   * Specifies the mechanism to be used to restore volume data.
   * Default: VOLUME_DATA_RESTORE_POLICY_UNSPECIFIED (will be treated as
   * NO_VOLUME_DATA_RESTORATION).
   * </pre>
   *
   * <code>
   * .google.cloud.gkebackup.v1.RestoreConfig.VolumeDataRestorePolicy volume_data_restore_policy = 1;
   * </code>
   *
   * @return The volumeDataRestorePolicy.
   */
  @java.lang.Override
  public com.google.cloud.gkebackup.v1.RestoreConfig.VolumeDataRestorePolicy
      getVolumeDataRestorePolicy() {
    com.google.cloud.gkebackup.v1.RestoreConfig.VolumeDataRestorePolicy result =
        com.google.cloud.gkebackup.v1.RestoreConfig.VolumeDataRestorePolicy.forNumber(
            volumeDataRestorePolicy_);
    return result == null
        ? com.google.cloud.gkebackup.v1.RestoreConfig.VolumeDataRestorePolicy.UNRECOGNIZED
        : result;
  }

  public static final int CLUSTER_RESOURCE_CONFLICT_POLICY_FIELD_NUMBER = 2;
  private int clusterResourceConflictPolicy_ = 0;
  /**
   *
   *
   * <pre>
   * Defines the behavior for handling the situation where cluster-scoped
   * resources being restored already exist in the target cluster. This MUST be
   * set to a value other than CLUSTER_RESOURCE_CONFLICT_POLICY_UNSPECIFIED if
   * [cluster_resource_restore_scope][google.cloud.gkebackup.v1.RestoreConfig.cluster_resource_restore_scope]
   * is not empty.
   * </pre>
   *
   * <code>
   * .google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceConflictPolicy cluster_resource_conflict_policy = 2;
   * </code>
   *
   * @return The enum numeric value on the wire for clusterResourceConflictPolicy.
   */
  @java.lang.Override
  public int getClusterResourceConflictPolicyValue() {
    return clusterResourceConflictPolicy_;
  }
  /**
   *
   *
   * <pre>
   * Defines the behavior for handling the situation where cluster-scoped
   * resources being restored already exist in the target cluster. This MUST be
   * set to a value other than CLUSTER_RESOURCE_CONFLICT_POLICY_UNSPECIFIED if
   * [cluster_resource_restore_scope][google.cloud.gkebackup.v1.RestoreConfig.cluster_resource_restore_scope]
   * is not empty.
   * </pre>
   *
   * <code>
   * .google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceConflictPolicy cluster_resource_conflict_policy = 2;
   * </code>
   *
   * @return The clusterResourceConflictPolicy.
   */
  @java.lang.Override
  public com.google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceConflictPolicy
      getClusterResourceConflictPolicy() {
    com.google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceConflictPolicy result =
        com.google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceConflictPolicy.forNumber(
            clusterResourceConflictPolicy_);
    return result == null
        ? com.google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceConflictPolicy.UNRECOGNIZED
        : result;
  }

  public static final int NAMESPACED_RESOURCE_RESTORE_MODE_FIELD_NUMBER = 3;
  private int namespacedResourceRestoreMode_ = 0;
  /**
   *
   *
   * <pre>
   * Defines the behavior for handling the situation where sets of namespaced
   * resources being restored already exist in the target cluster. This MUST be
   * set to a value other than NAMESPACED_RESOURCE_RESTORE_MODE_UNSPECIFIED.
   * </pre>
   *
   * <code>
   * .google.cloud.gkebackup.v1.RestoreConfig.NamespacedResourceRestoreMode namespaced_resource_restore_mode = 3;
   * </code>
   *
   * @return The enum numeric value on the wire for namespacedResourceRestoreMode.
   */
  @java.lang.Override
  public int getNamespacedResourceRestoreModeValue() {
    return namespacedResourceRestoreMode_;
  }
  /**
   *
   *
   * <pre>
   * Defines the behavior for handling the situation where sets of namespaced
   * resources being restored already exist in the target cluster. This MUST be
   * set to a value other than NAMESPACED_RESOURCE_RESTORE_MODE_UNSPECIFIED.
   * </pre>
   *
   * <code>
   * .google.cloud.gkebackup.v1.RestoreConfig.NamespacedResourceRestoreMode namespaced_resource_restore_mode = 3;
   * </code>
   *
   * @return The namespacedResourceRestoreMode.
   */
  @java.lang.Override
  public com.google.cloud.gkebackup.v1.RestoreConfig.NamespacedResourceRestoreMode
      getNamespacedResourceRestoreMode() {
    com.google.cloud.gkebackup.v1.RestoreConfig.NamespacedResourceRestoreMode result =
        com.google.cloud.gkebackup.v1.RestoreConfig.NamespacedResourceRestoreMode.forNumber(
            namespacedResourceRestoreMode_);
    return result == null
        ? com.google.cloud.gkebackup.v1.RestoreConfig.NamespacedResourceRestoreMode.UNRECOGNIZED
        : result;
  }

  public static final int CLUSTER_RESOURCE_RESTORE_SCOPE_FIELD_NUMBER = 4;
  private com.google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope
      clusterResourceRestoreScope_;
  /**
   *
   *
   * <pre>
   * Identifies the cluster-scoped resources to restore from the Backup.
   * Not specifying it means NO cluster resource will be restored.
   * </pre>
   *
   * <code>
   * .google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope cluster_resource_restore_scope = 4;
   * </code>
   *
   * @return Whether the clusterResourceRestoreScope field is set.
   */
  @java.lang.Override
  public boolean hasClusterResourceRestoreScope() {
    return clusterResourceRestoreScope_ != null;
  }
  /**
   *
   *
   * <pre>
   * Identifies the cluster-scoped resources to restore from the Backup.
   * Not specifying it means NO cluster resource will be restored.
   * </pre>
   *
   * <code>
   * .google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope cluster_resource_restore_scope = 4;
   * </code>
   *
   * @return The clusterResourceRestoreScope.
   */
  @java.lang.Override
  public com.google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope
      getClusterResourceRestoreScope() {
    return clusterResourceRestoreScope_ == null
        ? com.google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope
            .getDefaultInstance()
        : clusterResourceRestoreScope_;
  }
  /**
   *
   *
   * <pre>
   * Identifies the cluster-scoped resources to restore from the Backup.
   * Not specifying it means NO cluster resource will be restored.
   * </pre>
   *
   * <code>
   * .google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope cluster_resource_restore_scope = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScopeOrBuilder
      getClusterResourceRestoreScopeOrBuilder() {
    return clusterResourceRestoreScope_ == null
        ? com.google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope
            .getDefaultInstance()
        : clusterResourceRestoreScope_;
  }

  public static final int ALL_NAMESPACES_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * Restore all namespaced resources in the Backup if set to "True".
   * Specifying this field to "False" is an error.
   * </pre>
   *
   * <code>bool all_namespaces = 5;</code>
   *
   * @return Whether the allNamespaces field is set.
   */
  @java.lang.Override
  public boolean hasAllNamespaces() {
    return namespacedResourceRestoreScopeCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * Restore all namespaced resources in the Backup if set to "True".
   * Specifying this field to "False" is an error.
   * </pre>
   *
   * <code>bool all_namespaces = 5;</code>
   *
   * @return The allNamespaces.
   */
  @java.lang.Override
  public boolean getAllNamespaces() {
    if (namespacedResourceRestoreScopeCase_ == 5) {
      return (java.lang.Boolean) namespacedResourceRestoreScope_;
    }
    return false;
  }

  public static final int SELECTED_NAMESPACES_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * A list of selected Namespaces to restore from the Backup. The listed
   * Namespaces and all resources contained in them will be restored.
   * </pre>
   *
   * <code>.google.cloud.gkebackup.v1.Namespaces selected_namespaces = 6;</code>
   *
   * @return Whether the selectedNamespaces field is set.
   */
  @java.lang.Override
  public boolean hasSelectedNamespaces() {
    return namespacedResourceRestoreScopeCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * A list of selected Namespaces to restore from the Backup. The listed
   * Namespaces and all resources contained in them will be restored.
   * </pre>
   *
   * <code>.google.cloud.gkebackup.v1.Namespaces selected_namespaces = 6;</code>
   *
   * @return The selectedNamespaces.
   */
  @java.lang.Override
  public com.google.cloud.gkebackup.v1.Namespaces getSelectedNamespaces() {
    if (namespacedResourceRestoreScopeCase_ == 6) {
      return (com.google.cloud.gkebackup.v1.Namespaces) namespacedResourceRestoreScope_;
    }
    return com.google.cloud.gkebackup.v1.Namespaces.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A list of selected Namespaces to restore from the Backup. The listed
   * Namespaces and all resources contained in them will be restored.
   * </pre>
   *
   * <code>.google.cloud.gkebackup.v1.Namespaces selected_namespaces = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.gkebackup.v1.NamespacesOrBuilder getSelectedNamespacesOrBuilder() {
    if (namespacedResourceRestoreScopeCase_ == 6) {
      return (com.google.cloud.gkebackup.v1.Namespaces) namespacedResourceRestoreScope_;
    }
    return com.google.cloud.gkebackup.v1.Namespaces.getDefaultInstance();
  }

  public static final int SELECTED_APPLICATIONS_FIELD_NUMBER = 7;
  /**
   *
   *
   * <pre>
   * A list of selected ProtectedApplications to restore. The listed
   * ProtectedApplications and all the resources to which they refer will be
   * restored.
   * </pre>
   *
   * <code>.google.cloud.gkebackup.v1.NamespacedNames selected_applications = 7;</code>
   *
   * @return Whether the selectedApplications field is set.
   */
  @java.lang.Override
  public boolean hasSelectedApplications() {
    return namespacedResourceRestoreScopeCase_ == 7;
  }
  /**
   *
   *
   * <pre>
   * A list of selected ProtectedApplications to restore. The listed
   * ProtectedApplications and all the resources to which they refer will be
   * restored.
   * </pre>
   *
   * <code>.google.cloud.gkebackup.v1.NamespacedNames selected_applications = 7;</code>
   *
   * @return The selectedApplications.
   */
  @java.lang.Override
  public com.google.cloud.gkebackup.v1.NamespacedNames getSelectedApplications() {
    if (namespacedResourceRestoreScopeCase_ == 7) {
      return (com.google.cloud.gkebackup.v1.NamespacedNames) namespacedResourceRestoreScope_;
    }
    return com.google.cloud.gkebackup.v1.NamespacedNames.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A list of selected ProtectedApplications to restore. The listed
   * ProtectedApplications and all the resources to which they refer will be
   * restored.
   * </pre>
   *
   * <code>.google.cloud.gkebackup.v1.NamespacedNames selected_applications = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.gkebackup.v1.NamespacedNamesOrBuilder getSelectedApplicationsOrBuilder() {
    if (namespacedResourceRestoreScopeCase_ == 7) {
      return (com.google.cloud.gkebackup.v1.NamespacedNames) namespacedResourceRestoreScope_;
    }
    return com.google.cloud.gkebackup.v1.NamespacedNames.getDefaultInstance();
  }

  public static final int NO_NAMESPACES_FIELD_NUMBER = 9;
  /**
   *
   *
   * <pre>
   * Do not restore any namespaced resources if set to "True".
   * Specifying this field to "False" is not allowed.
   * </pre>
   *
   * <code>bool no_namespaces = 9;</code>
   *
   * @return Whether the noNamespaces field is set.
   */
  @java.lang.Override
  public boolean hasNoNamespaces() {
    return namespacedResourceRestoreScopeCase_ == 9;
  }
  /**
   *
   *
   * <pre>
   * Do not restore any namespaced resources if set to "True".
   * Specifying this field to "False" is not allowed.
   * </pre>
   *
   * <code>bool no_namespaces = 9;</code>
   *
   * @return The noNamespaces.
   */
  @java.lang.Override
  public boolean getNoNamespaces() {
    if (namespacedResourceRestoreScopeCase_ == 9) {
      return (java.lang.Boolean) namespacedResourceRestoreScope_;
    }
    return false;
  }

  public static final int EXCLUDED_NAMESPACES_FIELD_NUMBER = 10;
  /**
   *
   *
   * <pre>
   * A list of selected namespaces excluded from restoration. All
   * namespaces except those in this list will be restored.
   * </pre>
   *
   * <code>.google.cloud.gkebackup.v1.Namespaces excluded_namespaces = 10;</code>
   *
   * @return Whether the excludedNamespaces field is set.
   */
  @java.lang.Override
  public boolean hasExcludedNamespaces() {
    return namespacedResourceRestoreScopeCase_ == 10;
  }
  /**
   *
   *
   * <pre>
   * A list of selected namespaces excluded from restoration. All
   * namespaces except those in this list will be restored.
   * </pre>
   *
   * <code>.google.cloud.gkebackup.v1.Namespaces excluded_namespaces = 10;</code>
   *
   * @return The excludedNamespaces.
   */
  @java.lang.Override
  public com.google.cloud.gkebackup.v1.Namespaces getExcludedNamespaces() {
    if (namespacedResourceRestoreScopeCase_ == 10) {
      return (com.google.cloud.gkebackup.v1.Namespaces) namespacedResourceRestoreScope_;
    }
    return com.google.cloud.gkebackup.v1.Namespaces.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A list of selected namespaces excluded from restoration. All
   * namespaces except those in this list will be restored.
   * </pre>
   *
   * <code>.google.cloud.gkebackup.v1.Namespaces excluded_namespaces = 10;</code>
   */
  @java.lang.Override
  public com.google.cloud.gkebackup.v1.NamespacesOrBuilder getExcludedNamespacesOrBuilder() {
    if (namespacedResourceRestoreScopeCase_ == 10) {
      return (com.google.cloud.gkebackup.v1.Namespaces) namespacedResourceRestoreScope_;
    }
    return com.google.cloud.gkebackup.v1.Namespaces.getDefaultInstance();
  }

  public static final int SUBSTITUTION_RULES_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule>
      substitutionRules_;
  /**
   *
   *
   * <pre>
   * A list of transformation rules to be applied against Kubernetes resources
   * as they are selected for restoration from a Backup. Rules are executed in
   * order defined - this order matters, as changes made by a rule may impact
   * the filtering logic of subsequent rules. An empty list means no
   * substitution will occur.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule substitution_rules = 8;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule>
      getSubstitutionRulesList() {
    return substitutionRules_;
  }
  /**
   *
   *
   * <pre>
   * A list of transformation rules to be applied against Kubernetes resources
   * as they are selected for restoration from a Backup. Rules are executed in
   * order defined - this order matters, as changes made by a rule may impact
   * the filtering logic of subsequent rules. An empty list means no
   * substitution will occur.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule substitution_rules = 8;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRuleOrBuilder>
      getSubstitutionRulesOrBuilderList() {
    return substitutionRules_;
  }
  /**
   *
   *
   * <pre>
   * A list of transformation rules to be applied against Kubernetes resources
   * as they are selected for restoration from a Backup. Rules are executed in
   * order defined - this order matters, as changes made by a rule may impact
   * the filtering logic of subsequent rules. An empty list means no
   * substitution will occur.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule substitution_rules = 8;
   * </code>
   */
  @java.lang.Override
  public int getSubstitutionRulesCount() {
    return substitutionRules_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of transformation rules to be applied against Kubernetes resources
   * as they are selected for restoration from a Backup. Rules are executed in
   * order defined - this order matters, as changes made by a rule may impact
   * the filtering logic of subsequent rules. An empty list means no
   * substitution will occur.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule substitution_rules = 8;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule getSubstitutionRules(
      int index) {
    return substitutionRules_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of transformation rules to be applied against Kubernetes resources
   * as they are selected for restoration from a Backup. Rules are executed in
   * order defined - this order matters, as changes made by a rule may impact
   * the filtering logic of subsequent rules. An empty list means no
   * substitution will occur.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule substitution_rules = 8;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRuleOrBuilder
      getSubstitutionRulesOrBuilder(int index) {
    return substitutionRules_.get(index);
  }

  public static final int TRANSFORMATION_RULES_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRule>
      transformationRules_;
  /**
   *
   *
   * <pre>
   * A list of transformation rules to be applied against Kubernetes resources
   * as they are selected for restoration from a Backup. Rules are executed in
   * order defined - this order matters, as changes made by a rule may impact
   * the filtering logic of subsequent rules. An empty list means no
   * transformation will occur.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.gkebackup.v1.RestoreConfig.TransformationRule transformation_rules = 11;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRule>
      getTransformationRulesList() {
    return transformationRules_;
  }
  /**
   *
   *
   * <pre>
   * A list of transformation rules to be applied against Kubernetes resources
   * as they are selected for restoration from a Backup. Rules are executed in
   * order defined - this order matters, as changes made by a rule may impact
   * the filtering logic of subsequent rules. An empty list means no
   * transformation will occur.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.gkebackup.v1.RestoreConfig.TransformationRule transformation_rules = 11;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleOrBuilder>
      getTransformationRulesOrBuilderList() {
    return transformationRules_;
  }
  /**
   *
   *
   * <pre>
   * A list of transformation rules to be applied against Kubernetes resources
   * as they are selected for restoration from a Backup. Rules are executed in
   * order defined - this order matters, as changes made by a rule may impact
   * the filtering logic of subsequent rules. An empty list means no
   * transformation will occur.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.gkebackup.v1.RestoreConfig.TransformationRule transformation_rules = 11;
   * </code>
   */
  @java.lang.Override
  public int getTransformationRulesCount() {
    return transformationRules_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of transformation rules to be applied against Kubernetes resources
   * as they are selected for restoration from a Backup. Rules are executed in
   * order defined - this order matters, as changes made by a rule may impact
   * the filtering logic of subsequent rules. An empty list means no
   * transformation will occur.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.gkebackup.v1.RestoreConfig.TransformationRule transformation_rules = 11;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRule getTransformationRules(
      int index) {
    return transformationRules_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of transformation rules to be applied against Kubernetes resources
   * as they are selected for restoration from a Backup. Rules are executed in
   * order defined - this order matters, as changes made by a rule may impact
   * the filtering logic of subsequent rules. An empty list means no
   * transformation will occur.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.gkebackup.v1.RestoreConfig.TransformationRule transformation_rules = 11;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleOrBuilder
      getTransformationRulesOrBuilder(int index) {
    return transformationRules_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (volumeDataRestorePolicy_
        != com.google.cloud.gkebackup.v1.RestoreConfig.VolumeDataRestorePolicy
            .VOLUME_DATA_RESTORE_POLICY_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(1, volumeDataRestorePolicy_);
    }
    if (clusterResourceConflictPolicy_
        != com.google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceConflictPolicy
            .CLUSTER_RESOURCE_CONFLICT_POLICY_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(2, clusterResourceConflictPolicy_);
    }
    if (namespacedResourceRestoreMode_
        != com.google.cloud.gkebackup.v1.RestoreConfig.NamespacedResourceRestoreMode
            .NAMESPACED_RESOURCE_RESTORE_MODE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(3, namespacedResourceRestoreMode_);
    }
    if (clusterResourceRestoreScope_ != null) {
      output.writeMessage(4, getClusterResourceRestoreScope());
    }
    if (namespacedResourceRestoreScopeCase_ == 5) {
      output.writeBool(5, (boolean) ((java.lang.Boolean) namespacedResourceRestoreScope_));
    }
    if (namespacedResourceRestoreScopeCase_ == 6) {
      output.writeMessage(
          6, (com.google.cloud.gkebackup.v1.Namespaces) namespacedResourceRestoreScope_);
    }
    if (namespacedResourceRestoreScopeCase_ == 7) {
      output.writeMessage(
          7, (com.google.cloud.gkebackup.v1.NamespacedNames) namespacedResourceRestoreScope_);
    }
    for (int i = 0; i < substitutionRules_.size(); i++) {
      output.writeMessage(8, substitutionRules_.get(i));
    }
    if (namespacedResourceRestoreScopeCase_ == 9) {
      output.writeBool(9, (boolean) ((java.lang.Boolean) namespacedResourceRestoreScope_));
    }
    if (namespacedResourceRestoreScopeCase_ == 10) {
      output.writeMessage(
          10, (com.google.cloud.gkebackup.v1.Namespaces) namespacedResourceRestoreScope_);
    }
    for (int i = 0; i < transformationRules_.size(); i++) {
      output.writeMessage(11, transformationRules_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (volumeDataRestorePolicy_
        != com.google.cloud.gkebackup.v1.RestoreConfig.VolumeDataRestorePolicy
            .VOLUME_DATA_RESTORE_POLICY_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, volumeDataRestorePolicy_);
    }
    if (clusterResourceConflictPolicy_
        != com.google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceConflictPolicy
            .CLUSTER_RESOURCE_CONFLICT_POLICY_UNSPECIFIED
            .getNumber()) {
      size +=
          com.google.protobuf.CodedOutputStream.computeEnumSize(2, clusterResourceConflictPolicy_);
    }
    if (namespacedResourceRestoreMode_
        != com.google.cloud.gkebackup.v1.RestoreConfig.NamespacedResourceRestoreMode
            .NAMESPACED_RESOURCE_RESTORE_MODE_UNSPECIFIED
            .getNumber()) {
      size +=
          com.google.protobuf.CodedOutputStream.computeEnumSize(3, namespacedResourceRestoreMode_);
    }
    if (clusterResourceRestoreScope_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, getClusterResourceRestoreScope());
    }
    if (namespacedResourceRestoreScopeCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(
              5, (boolean) ((java.lang.Boolean) namespacedResourceRestoreScope_));
    }
    if (namespacedResourceRestoreScopeCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.cloud.gkebackup.v1.Namespaces) namespacedResourceRestoreScope_);
    }
    if (namespacedResourceRestoreScopeCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, (com.google.cloud.gkebackup.v1.NamespacedNames) namespacedResourceRestoreScope_);
    }
    for (int i = 0; i < substitutionRules_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(8, substitutionRules_.get(i));
    }
    if (namespacedResourceRestoreScopeCase_ == 9) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(
              9, (boolean) ((java.lang.Boolean) namespacedResourceRestoreScope_));
    }
    if (namespacedResourceRestoreScopeCase_ == 10) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              10, (com.google.cloud.gkebackup.v1.Namespaces) namespacedResourceRestoreScope_);
    }
    for (int i = 0; i < transformationRules_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(11, transformationRules_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.gkebackup.v1.RestoreConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.gkebackup.v1.RestoreConfig other =
        (com.google.cloud.gkebackup.v1.RestoreConfig) obj;

    if (volumeDataRestorePolicy_ != other.volumeDataRestorePolicy_) return false;
    if (clusterResourceConflictPolicy_ != other.clusterResourceConflictPolicy_) return false;
    if (namespacedResourceRestoreMode_ != other.namespacedResourceRestoreMode_) return false;
    if (hasClusterResourceRestoreScope() != other.hasClusterResourceRestoreScope()) return false;
    if (hasClusterResourceRestoreScope()) {
      if (!getClusterResourceRestoreScope().equals(other.getClusterResourceRestoreScope()))
        return false;
    }
    if (!getSubstitutionRulesList().equals(other.getSubstitutionRulesList())) return false;
    if (!getTransformationRulesList().equals(other.getTransformationRulesList())) return false;
    if (!getNamespacedResourceRestoreScopeCase()
        .equals(other.getNamespacedResourceRestoreScopeCase())) return false;
    switch (namespacedResourceRestoreScopeCase_) {
      case 5:
        if (getAllNamespaces() != other.getAllNamespaces()) return false;
        break;
      case 6:
        if (!getSelectedNamespaces().equals(other.getSelectedNamespaces())) return false;
        break;
      case 7:
        if (!getSelectedApplications().equals(other.getSelectedApplications())) return false;
        break;
      case 9:
        if (getNoNamespaces() != other.getNoNamespaces()) return false;
        break;
      case 10:
        if (!getExcludedNamespaces().equals(other.getExcludedNamespaces())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + VOLUME_DATA_RESTORE_POLICY_FIELD_NUMBER;
    hash = (53 * hash) + volumeDataRestorePolicy_;
    hash = (37 * hash) + CLUSTER_RESOURCE_CONFLICT_POLICY_FIELD_NUMBER;
    hash = (53 * hash) + clusterResourceConflictPolicy_;
    hash = (37 * hash) + NAMESPACED_RESOURCE_RESTORE_MODE_FIELD_NUMBER;
    hash = (53 * hash) + namespacedResourceRestoreMode_;
    if (hasClusterResourceRestoreScope()) {
      hash = (37 * hash) + CLUSTER_RESOURCE_RESTORE_SCOPE_FIELD_NUMBER;
      hash = (53 * hash) + getClusterResourceRestoreScope().hashCode();
    }
    if (getSubstitutionRulesCount() > 0) {
      hash = (37 * hash) + SUBSTITUTION_RULES_FIELD_NUMBER;
      hash = (53 * hash) + getSubstitutionRulesList().hashCode();
    }
    if (getTransformationRulesCount() > 0) {
      hash = (37 * hash) + TRANSFORMATION_RULES_FIELD_NUMBER;
      hash = (53 * hash) + getTransformationRulesList().hashCode();
    }
    switch (namespacedResourceRestoreScopeCase_) {
      case 5:
        hash = (37 * hash) + ALL_NAMESPACES_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAllNamespaces());
        break;
      case 6:
        hash = (37 * hash) + SELECTED_NAMESPACES_FIELD_NUMBER;
        hash = (53 * hash) + getSelectedNamespaces().hashCode();
        break;
      case 7:
        hash = (37 * hash) + SELECTED_APPLICATIONS_FIELD_NUMBER;
        hash = (53 * hash) + getSelectedApplications().hashCode();
        break;
      case 9:
        hash = (37 * hash) + NO_NAMESPACES_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getNoNamespaces());
        break;
      case 10:
        hash = (37 * hash) + EXCLUDED_NAMESPACES_FIELD_NUMBER;
        hash = (53 * hash) + getExcludedNamespaces().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.gkebackup.v1.RestoreConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gkebackup.v1.RestoreConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gkebackup.v1.RestoreConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gkebackup.v1.RestoreConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gkebackup.v1.RestoreConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gkebackup.v1.RestoreConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gkebackup.v1.RestoreConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.gkebackup.v1.RestoreConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.gkebackup.v1.RestoreConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.gkebackup.v1.RestoreConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.gkebackup.v1.RestoreConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.gkebackup.v1.RestoreConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.gkebackup.v1.RestoreConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Configuration of a restore.
   * Next id: 12
   * </pre>
   *
   * Protobuf type {@code google.cloud.gkebackup.v1.RestoreConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.gkebackup.v1.RestoreConfig)
      com.google.cloud.gkebackup.v1.RestoreConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.gkebackup.v1.RestoreProto
          .internal_static_google_cloud_gkebackup_v1_RestoreConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.gkebackup.v1.RestoreProto
          .internal_static_google_cloud_gkebackup_v1_RestoreConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.gkebackup.v1.RestoreConfig.class,
              com.google.cloud.gkebackup.v1.RestoreConfig.Builder.class);
    }

    // Construct using com.google.cloud.gkebackup.v1.RestoreConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      volumeDataRestorePolicy_ = 0;
      clusterResourceConflictPolicy_ = 0;
      namespacedResourceRestoreMode_ = 0;
      clusterResourceRestoreScope_ = null;
      if (clusterResourceRestoreScopeBuilder_ != null) {
        clusterResourceRestoreScopeBuilder_.dispose();
        clusterResourceRestoreScopeBuilder_ = null;
      }
      if (selectedNamespacesBuilder_ != null) {
        selectedNamespacesBuilder_.clear();
      }
      if (selectedApplicationsBuilder_ != null) {
        selectedApplicationsBuilder_.clear();
      }
      if (excludedNamespacesBuilder_ != null) {
        excludedNamespacesBuilder_.clear();
      }
      if (substitutionRulesBuilder_ == null) {
        substitutionRules_ = java.util.Collections.emptyList();
      } else {
        substitutionRules_ = null;
        substitutionRulesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000200);
      if (transformationRulesBuilder_ == null) {
        transformationRules_ = java.util.Collections.emptyList();
      } else {
        transformationRules_ = null;
        transformationRulesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000400);
      namespacedResourceRestoreScopeCase_ = 0;
      namespacedResourceRestoreScope_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.gkebackup.v1.RestoreProto
          .internal_static_google_cloud_gkebackup_v1_RestoreConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.gkebackup.v1.RestoreConfig getDefaultInstanceForType() {
      return com.google.cloud.gkebackup.v1.RestoreConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.gkebackup.v1.RestoreConfig build() {
      com.google.cloud.gkebackup.v1.RestoreConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.gkebackup.v1.RestoreConfig buildPartial() {
      com.google.cloud.gkebackup.v1.RestoreConfig result =
          new com.google.cloud.gkebackup.v1.RestoreConfig(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.gkebackup.v1.RestoreConfig result) {
      if (substitutionRulesBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)) {
          substitutionRules_ = java.util.Collections.unmodifiableList(substitutionRules_);
          bitField0_ = (bitField0_ & ~0x00000200);
        }
        result.substitutionRules_ = substitutionRules_;
      } else {
        result.substitutionRules_ = substitutionRulesBuilder_.build();
      }
      if (transformationRulesBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)) {
          transformationRules_ = java.util.Collections.unmodifiableList(transformationRules_);
          bitField0_ = (bitField0_ & ~0x00000400);
        }
        result.transformationRules_ = transformationRules_;
      } else {
        result.transformationRules_ = transformationRulesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.gkebackup.v1.RestoreConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.volumeDataRestorePolicy_ = volumeDataRestorePolicy_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.clusterResourceConflictPolicy_ = clusterResourceConflictPolicy_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.namespacedResourceRestoreMode_ = namespacedResourceRestoreMode_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.clusterResourceRestoreScope_ =
            clusterResourceRestoreScopeBuilder_ == null
                ? clusterResourceRestoreScope_
                : clusterResourceRestoreScopeBuilder_.build();
      }
    }

    private void buildPartialOneofs(com.google.cloud.gkebackup.v1.RestoreConfig result) {
      result.namespacedResourceRestoreScopeCase_ = namespacedResourceRestoreScopeCase_;
      result.namespacedResourceRestoreScope_ = this.namespacedResourceRestoreScope_;
      if (namespacedResourceRestoreScopeCase_ == 6 && selectedNamespacesBuilder_ != null) {
        result.namespacedResourceRestoreScope_ = selectedNamespacesBuilder_.build();
      }
      if (namespacedResourceRestoreScopeCase_ == 7 && selectedApplicationsBuilder_ != null) {
        result.namespacedResourceRestoreScope_ = selectedApplicationsBuilder_.build();
      }
      if (namespacedResourceRestoreScopeCase_ == 10 && excludedNamespacesBuilder_ != null) {
        result.namespacedResourceRestoreScope_ = excludedNamespacesBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.gkebackup.v1.RestoreConfig) {
        return mergeFrom((com.google.cloud.gkebackup.v1.RestoreConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.gkebackup.v1.RestoreConfig other) {
      if (other == com.google.cloud.gkebackup.v1.RestoreConfig.getDefaultInstance()) return this;
      if (other.volumeDataRestorePolicy_ != 0) {
        setVolumeDataRestorePolicyValue(other.getVolumeDataRestorePolicyValue());
      }
      if (other.clusterResourceConflictPolicy_ != 0) {
        setClusterResourceConflictPolicyValue(other.getClusterResourceConflictPolicyValue());
      }
      if (other.namespacedResourceRestoreMode_ != 0) {
        setNamespacedResourceRestoreModeValue(other.getNamespacedResourceRestoreModeValue());
      }
      if (other.hasClusterResourceRestoreScope()) {
        mergeClusterResourceRestoreScope(other.getClusterResourceRestoreScope());
      }
      if (substitutionRulesBuilder_ == null) {
        if (!other.substitutionRules_.isEmpty()) {
          if (substitutionRules_.isEmpty()) {
            substitutionRules_ = other.substitutionRules_;
            bitField0_ = (bitField0_ & ~0x00000200);
          } else {
            ensureSubstitutionRulesIsMutable();
            substitutionRules_.addAll(other.substitutionRules_);
          }
          onChanged();
        }
      } else {
        if (!other.substitutionRules_.isEmpty()) {
          if (substitutionRulesBuilder_.isEmpty()) {
            substitutionRulesBuilder_.dispose();
            substitutionRulesBuilder_ = null;
            substitutionRules_ = other.substitutionRules_;
            bitField0_ = (bitField0_ & ~0x00000200);
            substitutionRulesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getSubstitutionRulesFieldBuilder()
                    : null;
          } else {
            substitutionRulesBuilder_.addAllMessages(other.substitutionRules_);
          }
        }
      }
      if (transformationRulesBuilder_ == null) {
        if (!other.transformationRules_.isEmpty()) {
          if (transformationRules_.isEmpty()) {
            transformationRules_ = other.transformationRules_;
            bitField0_ = (bitField0_ & ~0x00000400);
          } else {
            ensureTransformationRulesIsMutable();
            transformationRules_.addAll(other.transformationRules_);
          }
          onChanged();
        }
      } else {
        if (!other.transformationRules_.isEmpty()) {
          if (transformationRulesBuilder_.isEmpty()) {
            transformationRulesBuilder_.dispose();
            transformationRulesBuilder_ = null;
            transformationRules_ = other.transformationRules_;
            bitField0_ = (bitField0_ & ~0x00000400);
            transformationRulesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getTransformationRulesFieldBuilder()
                    : null;
          } else {
            transformationRulesBuilder_.addAllMessages(other.transformationRules_);
          }
        }
      }
      switch (other.getNamespacedResourceRestoreScopeCase()) {
        case ALL_NAMESPACES:
          {
            setAllNamespaces(other.getAllNamespaces());
            break;
          }
        case SELECTED_NAMESPACES:
          {
            mergeSelectedNamespaces(other.getSelectedNamespaces());
            break;
          }
        case SELECTED_APPLICATIONS:
          {
            mergeSelectedApplications(other.getSelectedApplications());
            break;
          }
        case NO_NAMESPACES:
          {
            setNoNamespaces(other.getNoNamespaces());
            break;
          }
        case EXCLUDED_NAMESPACES:
          {
            mergeExcludedNamespaces(other.getExcludedNamespaces());
            break;
          }
        case NAMESPACEDRESOURCERESTORESCOPE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                volumeDataRestorePolicy_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 16:
              {
                clusterResourceConflictPolicy_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 24:
              {
                namespacedResourceRestoreMode_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 34:
              {
                input.readMessage(
                    getClusterResourceRestoreScopeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 40:
              {
                namespacedResourceRestoreScope_ = input.readBool();
                namespacedResourceRestoreScopeCase_ = 5;
                break;
              } // case 40
            case 50:
              {
                input.readMessage(
                    getSelectedNamespacesFieldBuilder().getBuilder(), extensionRegistry);
                namespacedResourceRestoreScopeCase_ = 6;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(
                    getSelectedApplicationsFieldBuilder().getBuilder(), extensionRegistry);
                namespacedResourceRestoreScopeCase_ = 7;
                break;
              } // case 58
            case 66:
              {
                com.google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule m =
                    input.readMessage(
                        com.google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule.parser(),
                        extensionRegistry);
                if (substitutionRulesBuilder_ == null) {
                  ensureSubstitutionRulesIsMutable();
                  substitutionRules_.add(m);
                } else {
                  substitutionRulesBuilder_.addMessage(m);
                }
                break;
              } // case 66
            case 72:
              {
                namespacedResourceRestoreScope_ = input.readBool();
                namespacedResourceRestoreScopeCase_ = 9;
                break;
              } // case 72
            case 82:
              {
                input.readMessage(
                    getExcludedNamespacesFieldBuilder().getBuilder(), extensionRegistry);
                namespacedResourceRestoreScopeCase_ = 10;
                break;
              } // case 82
            case 90:
              {
                com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRule m =
                    input.readMessage(
                        com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRule.parser(),
                        extensionRegistry);
                if (transformationRulesBuilder_ == null) {
                  ensureTransformationRulesIsMutable();
                  transformationRules_.add(m);
                } else {
                  transformationRulesBuilder_.addMessage(m);
                }
                break;
              } // case 90
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int namespacedResourceRestoreScopeCase_ = 0;
    private java.lang.Object namespacedResourceRestoreScope_;

    public NamespacedResourceRestoreScopeCase getNamespacedResourceRestoreScopeCase() {
      return NamespacedResourceRestoreScopeCase.forNumber(namespacedResourceRestoreScopeCase_);
    }

    public Builder clearNamespacedResourceRestoreScope() {
      namespacedResourceRestoreScopeCase_ = 0;
      namespacedResourceRestoreScope_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private int volumeDataRestorePolicy_ = 0;
    /**
     *
     *
     * <pre>
     * Specifies the mechanism to be used to restore volume data.
     * Default: VOLUME_DATA_RESTORE_POLICY_UNSPECIFIED (will be treated as
     * NO_VOLUME_DATA_RESTORATION).
     * </pre>
     *
     * <code>
     * .google.cloud.gkebackup.v1.RestoreConfig.VolumeDataRestorePolicy volume_data_restore_policy = 1;
     * </code>
     *
     * @return The enum numeric value on the wire for volumeDataRestorePolicy.
     */
    @java.lang.Override
    public int getVolumeDataRestorePolicyValue() {
      return volumeDataRestorePolicy_;
    }
    /**
     *
     *
     * <pre>
     * Specifies the mechanism to be used to restore volume data.
     * Default: VOLUME_DATA_RESTORE_POLICY_UNSPECIFIED (will be treated as
     * NO_VOLUME_DATA_RESTORATION).
     * </pre>
     *
     * <code>
     * .google.cloud.gkebackup.v1.RestoreConfig.VolumeDataRestorePolicy volume_data_restore_policy = 1;
     * </code>
     *
     * @param value The enum numeric value on the wire for volumeDataRestorePolicy to set.
     * @return This builder for chaining.
     */
    public Builder setVolumeDataRestorePolicyValue(int value) {
      volumeDataRestorePolicy_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the mechanism to be used to restore volume data.
     * Default: VOLUME_DATA_RESTORE_POLICY_UNSPECIFIED (will be treated as
     * NO_VOLUME_DATA_RESTORATION).
     * </pre>
     *
     * <code>
     * .google.cloud.gkebackup.v1.RestoreConfig.VolumeDataRestorePolicy volume_data_restore_policy = 1;
     * </code>
     *
     * @return The volumeDataRestorePolicy.
     */
    @java.lang.Override
    public com.google.cloud.gkebackup.v1.RestoreConfig.VolumeDataRestorePolicy
        getVolumeDataRestorePolicy() {
      com.google.cloud.gkebackup.v1.RestoreConfig.VolumeDataRestorePolicy result =
          com.google.cloud.gkebackup.v1.RestoreConfig.VolumeDataRestorePolicy.forNumber(
              volumeDataRestorePolicy_);
      return result == null
          ? com.google.cloud.gkebackup.v1.RestoreConfig.VolumeDataRestorePolicy.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Specifies the mechanism to be used to restore volume data.
     * Default: VOLUME_DATA_RESTORE_POLICY_UNSPECIFIED (will be treated as
     * NO_VOLUME_DATA_RESTORATION).
     * </pre>
     *
     * <code>
     * .google.cloud.gkebackup.v1.RestoreConfig.VolumeDataRestorePolicy volume_data_restore_policy = 1;
     * </code>
     *
     * @param value The volumeDataRestorePolicy to set.
     * @return This builder for chaining.
     */
    public Builder setVolumeDataRestorePolicy(
        com.google.cloud.gkebackup.v1.RestoreConfig.VolumeDataRestorePolicy value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      volumeDataRestorePolicy_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the mechanism to be used to restore volume data.
     * Default: VOLUME_DATA_RESTORE_POLICY_UNSPECIFIED (will be treated as
     * NO_VOLUME_DATA_RESTORATION).
     * </pre>
     *
     * <code>
     * .google.cloud.gkebackup.v1.RestoreConfig.VolumeDataRestorePolicy volume_data_restore_policy = 1;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVolumeDataRestorePolicy() {
      bitField0_ = (bitField0_ & ~0x00000001);
      volumeDataRestorePolicy_ = 0;
      onChanged();
      return this;
    }

    private int clusterResourceConflictPolicy_ = 0;
    /**
     *
     *
     * <pre>
     * Defines the behavior for handling the situation where cluster-scoped
     * resources being restored already exist in the target cluster. This MUST be
     * set to a value other than CLUSTER_RESOURCE_CONFLICT_POLICY_UNSPECIFIED if
     * [cluster_resource_restore_scope][google.cloud.gkebackup.v1.RestoreConfig.cluster_resource_restore_scope]
     * is not empty.
     * </pre>
     *
     * <code>
     * .google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceConflictPolicy cluster_resource_conflict_policy = 2;
     * </code>
     *
     * @return The enum numeric value on the wire for clusterResourceConflictPolicy.
     */
    @java.lang.Override
    public int getClusterResourceConflictPolicyValue() {
      return clusterResourceConflictPolicy_;
    }
    /**
     *
     *
     * <pre>
     * Defines the behavior for handling the situation where cluster-scoped
     * resources being restored already exist in the target cluster. This MUST be
     * set to a value other than CLUSTER_RESOURCE_CONFLICT_POLICY_UNSPECIFIED if
     * [cluster_resource_restore_scope][google.cloud.gkebackup.v1.RestoreConfig.cluster_resource_restore_scope]
     * is not empty.
     * </pre>
     *
     * <code>
     * .google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceConflictPolicy cluster_resource_conflict_policy = 2;
     * </code>
     *
     * @param value The enum numeric value on the wire for clusterResourceConflictPolicy to set.
     * @return This builder for chaining.
     */
    public Builder setClusterResourceConflictPolicyValue(int value) {
      clusterResourceConflictPolicy_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the behavior for handling the situation where cluster-scoped
     * resources being restored already exist in the target cluster. This MUST be
     * set to a value other than CLUSTER_RESOURCE_CONFLICT_POLICY_UNSPECIFIED if
     * [cluster_resource_restore_scope][google.cloud.gkebackup.v1.RestoreConfig.cluster_resource_restore_scope]
     * is not empty.
     * </pre>
     *
     * <code>
     * .google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceConflictPolicy cluster_resource_conflict_policy = 2;
     * </code>
     *
     * @return The clusterResourceConflictPolicy.
     */
    @java.lang.Override
    public com.google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceConflictPolicy
        getClusterResourceConflictPolicy() {
      com.google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceConflictPolicy result =
          com.google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceConflictPolicy.forNumber(
              clusterResourceConflictPolicy_);
      return result == null
          ? com.google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceConflictPolicy.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Defines the behavior for handling the situation where cluster-scoped
     * resources being restored already exist in the target cluster. This MUST be
     * set to a value other than CLUSTER_RESOURCE_CONFLICT_POLICY_UNSPECIFIED if
     * [cluster_resource_restore_scope][google.cloud.gkebackup.v1.RestoreConfig.cluster_resource_restore_scope]
     * is not empty.
     * </pre>
     *
     * <code>
     * .google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceConflictPolicy cluster_resource_conflict_policy = 2;
     * </code>
     *
     * @param value The clusterResourceConflictPolicy to set.
     * @return This builder for chaining.
     */
    public Builder setClusterResourceConflictPolicy(
        com.google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceConflictPolicy value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      clusterResourceConflictPolicy_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the behavior for handling the situation where cluster-scoped
     * resources being restored already exist in the target cluster. This MUST be
     * set to a value other than CLUSTER_RESOURCE_CONFLICT_POLICY_UNSPECIFIED if
     * [cluster_resource_restore_scope][google.cloud.gkebackup.v1.RestoreConfig.cluster_resource_restore_scope]
     * is not empty.
     * </pre>
     *
     * <code>
     * .google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceConflictPolicy cluster_resource_conflict_policy = 2;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearClusterResourceConflictPolicy() {
      bitField0_ = (bitField0_ & ~0x00000002);
      clusterResourceConflictPolicy_ = 0;
      onChanged();
      return this;
    }

    private int namespacedResourceRestoreMode_ = 0;
    /**
     *
     *
     * <pre>
     * Defines the behavior for handling the situation where sets of namespaced
     * resources being restored already exist in the target cluster. This MUST be
     * set to a value other than NAMESPACED_RESOURCE_RESTORE_MODE_UNSPECIFIED.
     * </pre>
     *
     * <code>
     * .google.cloud.gkebackup.v1.RestoreConfig.NamespacedResourceRestoreMode namespaced_resource_restore_mode = 3;
     * </code>
     *
     * @return The enum numeric value on the wire for namespacedResourceRestoreMode.
     */
    @java.lang.Override
    public int getNamespacedResourceRestoreModeValue() {
      return namespacedResourceRestoreMode_;
    }
    /**
     *
     *
     * <pre>
     * Defines the behavior for handling the situation where sets of namespaced
     * resources being restored already exist in the target cluster. This MUST be
     * set to a value other than NAMESPACED_RESOURCE_RESTORE_MODE_UNSPECIFIED.
     * </pre>
     *
     * <code>
     * .google.cloud.gkebackup.v1.RestoreConfig.NamespacedResourceRestoreMode namespaced_resource_restore_mode = 3;
     * </code>
     *
     * @param value The enum numeric value on the wire for namespacedResourceRestoreMode to set.
     * @return This builder for chaining.
     */
    public Builder setNamespacedResourceRestoreModeValue(int value) {
      namespacedResourceRestoreMode_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the behavior for handling the situation where sets of namespaced
     * resources being restored already exist in the target cluster. This MUST be
     * set to a value other than NAMESPACED_RESOURCE_RESTORE_MODE_UNSPECIFIED.
     * </pre>
     *
     * <code>
     * .google.cloud.gkebackup.v1.RestoreConfig.NamespacedResourceRestoreMode namespaced_resource_restore_mode = 3;
     * </code>
     *
     * @return The namespacedResourceRestoreMode.
     */
    @java.lang.Override
    public com.google.cloud.gkebackup.v1.RestoreConfig.NamespacedResourceRestoreMode
        getNamespacedResourceRestoreMode() {
      com.google.cloud.gkebackup.v1.RestoreConfig.NamespacedResourceRestoreMode result =
          com.google.cloud.gkebackup.v1.RestoreConfig.NamespacedResourceRestoreMode.forNumber(
              namespacedResourceRestoreMode_);
      return result == null
          ? com.google.cloud.gkebackup.v1.RestoreConfig.NamespacedResourceRestoreMode.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Defines the behavior for handling the situation where sets of namespaced
     * resources being restored already exist in the target cluster. This MUST be
     * set to a value other than NAMESPACED_RESOURCE_RESTORE_MODE_UNSPECIFIED.
     * </pre>
     *
     * <code>
     * .google.cloud.gkebackup.v1.RestoreConfig.NamespacedResourceRestoreMode namespaced_resource_restore_mode = 3;
     * </code>
     *
     * @param value The namespacedResourceRestoreMode to set.
     * @return This builder for chaining.
     */
    public Builder setNamespacedResourceRestoreMode(
        com.google.cloud.gkebackup.v1.RestoreConfig.NamespacedResourceRestoreMode value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      namespacedResourceRestoreMode_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the behavior for handling the situation where sets of namespaced
     * resources being restored already exist in the target cluster. This MUST be
     * set to a value other than NAMESPACED_RESOURCE_RESTORE_MODE_UNSPECIFIED.
     * </pre>
     *
     * <code>
     * .google.cloud.gkebackup.v1.RestoreConfig.NamespacedResourceRestoreMode namespaced_resource_restore_mode = 3;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNamespacedResourceRestoreMode() {
      bitField0_ = (bitField0_ & ~0x00000004);
      namespacedResourceRestoreMode_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope
        clusterResourceRestoreScope_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope,
            com.google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope.Builder,
            com.google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScopeOrBuilder>
        clusterResourceRestoreScopeBuilder_;
    /**
     *
     *
     * <pre>
     * Identifies the cluster-scoped resources to restore from the Backup.
     * Not specifying it means NO cluster resource will be restored.
     * </pre>
     *
     * <code>
     * .google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope cluster_resource_restore_scope = 4;
     * </code>
     *
     * @return Whether the clusterResourceRestoreScope field is set.
     */
    public boolean hasClusterResourceRestoreScope() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Identifies the cluster-scoped resources to restore from the Backup.
     * Not specifying it means NO cluster resource will be restored.
     * </pre>
     *
     * <code>
     * .google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope cluster_resource_restore_scope = 4;
     * </code>
     *
     * @return The clusterResourceRestoreScope.
     */
    public com.google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope
        getClusterResourceRestoreScope() {
      if (clusterResourceRestoreScopeBuilder_ == null) {
        return clusterResourceRestoreScope_ == null
            ? com.google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope
                .getDefaultInstance()
            : clusterResourceRestoreScope_;
      } else {
        return clusterResourceRestoreScopeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Identifies the cluster-scoped resources to restore from the Backup.
     * Not specifying it means NO cluster resource will be restored.
     * </pre>
     *
     * <code>
     * .google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope cluster_resource_restore_scope = 4;
     * </code>
     */
    public Builder setClusterResourceRestoreScope(
        com.google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope value) {
      if (clusterResourceRestoreScopeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        clusterResourceRestoreScope_ = value;
      } else {
        clusterResourceRestoreScopeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Identifies the cluster-scoped resources to restore from the Backup.
     * Not specifying it means NO cluster resource will be restored.
     * </pre>
     *
     * <code>
     * .google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope cluster_resource_restore_scope = 4;
     * </code>
     */
    public Builder setClusterResourceRestoreScope(
        com.google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope.Builder
            builderForValue) {
      if (clusterResourceRestoreScopeBuilder_ == null) {
        clusterResourceRestoreScope_ = builderForValue.build();
      } else {
        clusterResourceRestoreScopeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Identifies the cluster-scoped resources to restore from the Backup.
     * Not specifying it means NO cluster resource will be restored.
     * </pre>
     *
     * <code>
     * .google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope cluster_resource_restore_scope = 4;
     * </code>
     */
    public Builder mergeClusterResourceRestoreScope(
        com.google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope value) {
      if (clusterResourceRestoreScopeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && clusterResourceRestoreScope_ != null
            && clusterResourceRestoreScope_
                != com.google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope
                    .getDefaultInstance()) {
          getClusterResourceRestoreScopeBuilder().mergeFrom(value);
        } else {
          clusterResourceRestoreScope_ = value;
        }
      } else {
        clusterResourceRestoreScopeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Identifies the cluster-scoped resources to restore from the Backup.
     * Not specifying it means NO cluster resource will be restored.
     * </pre>
     *
     * <code>
     * .google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope cluster_resource_restore_scope = 4;
     * </code>
     */
    public Builder clearClusterResourceRestoreScope() {
      bitField0_ = (bitField0_ & ~0x00000008);
      clusterResourceRestoreScope_ = null;
      if (clusterResourceRestoreScopeBuilder_ != null) {
        clusterResourceRestoreScopeBuilder_.dispose();
        clusterResourceRestoreScopeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Identifies the cluster-scoped resources to restore from the Backup.
     * Not specifying it means NO cluster resource will be restored.
     * </pre>
     *
     * <code>
     * .google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope cluster_resource_restore_scope = 4;
     * </code>
     */
    public com.google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope.Builder
        getClusterResourceRestoreScopeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getClusterResourceRestoreScopeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Identifies the cluster-scoped resources to restore from the Backup.
     * Not specifying it means NO cluster resource will be restored.
     * </pre>
     *
     * <code>
     * .google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope cluster_resource_restore_scope = 4;
     * </code>
     */
    public com.google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScopeOrBuilder
        getClusterResourceRestoreScopeOrBuilder() {
      if (clusterResourceRestoreScopeBuilder_ != null) {
        return clusterResourceRestoreScopeBuilder_.getMessageOrBuilder();
      } else {
        return clusterResourceRestoreScope_ == null
            ? com.google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope
                .getDefaultInstance()
            : clusterResourceRestoreScope_;
      }
    }
    /**
     *
     *
     * <pre>
     * Identifies the cluster-scoped resources to restore from the Backup.
     * Not specifying it means NO cluster resource will be restored.
     * </pre>
     *
     * <code>
     * .google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope cluster_resource_restore_scope = 4;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope,
            com.google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope.Builder,
            com.google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScopeOrBuilder>
        getClusterResourceRestoreScopeFieldBuilder() {
      if (clusterResourceRestoreScopeBuilder_ == null) {
        clusterResourceRestoreScopeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope,
                com.google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope.Builder,
                com.google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScopeOrBuilder>(
                getClusterResourceRestoreScope(), getParentForChildren(), isClean());
        clusterResourceRestoreScope_ = null;
      }
      return clusterResourceRestoreScopeBuilder_;
    }

    /**
     *
     *
     * <pre>
     * Restore all namespaced resources in the Backup if set to "True".
     * Specifying this field to "False" is an error.
     * </pre>
     *
     * <code>bool all_namespaces = 5;</code>
     *
     * @return Whether the allNamespaces field is set.
     */
    public boolean hasAllNamespaces() {
      return namespacedResourceRestoreScopeCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * Restore all namespaced resources in the Backup if set to "True".
     * Specifying this field to "False" is an error.
     * </pre>
     *
     * <code>bool all_namespaces = 5;</code>
     *
     * @return The allNamespaces.
     */
    public boolean getAllNamespaces() {
      if (namespacedResourceRestoreScopeCase_ == 5) {
        return (java.lang.Boolean) namespacedResourceRestoreScope_;
      }
      return false;
    }
    /**
     *
     *
     * <pre>
     * Restore all namespaced resources in the Backup if set to "True".
     * Specifying this field to "False" is an error.
     * </pre>
     *
     * <code>bool all_namespaces = 5;</code>
     *
     * @param value The allNamespaces to set.
     * @return This builder for chaining.
     */
    public Builder setAllNamespaces(boolean value) {

      namespacedResourceRestoreScopeCase_ = 5;
      namespacedResourceRestoreScope_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Restore all namespaced resources in the Backup if set to "True".
     * Specifying this field to "False" is an error.
     * </pre>
     *
     * <code>bool all_namespaces = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAllNamespaces() {
      if (namespacedResourceRestoreScopeCase_ == 5) {
        namespacedResourceRestoreScopeCase_ = 0;
        namespacedResourceRestoreScope_ = null;
        onChanged();
      }
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gkebackup.v1.Namespaces,
            com.google.cloud.gkebackup.v1.Namespaces.Builder,
            com.google.cloud.gkebackup.v1.NamespacesOrBuilder>
        selectedNamespacesBuilder_;
    /**
     *
     *
     * <pre>
     * A list of selected Namespaces to restore from the Backup. The listed
     * Namespaces and all resources contained in them will be restored.
     * </pre>
     *
     * <code>.google.cloud.gkebackup.v1.Namespaces selected_namespaces = 6;</code>
     *
     * @return Whether the selectedNamespaces field is set.
     */
    @java.lang.Override
    public boolean hasSelectedNamespaces() {
      return namespacedResourceRestoreScopeCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * A list of selected Namespaces to restore from the Backup. The listed
     * Namespaces and all resources contained in them will be restored.
     * </pre>
     *
     * <code>.google.cloud.gkebackup.v1.Namespaces selected_namespaces = 6;</code>
     *
     * @return The selectedNamespaces.
     */
    @java.lang.Override
    public com.google.cloud.gkebackup.v1.Namespaces getSelectedNamespaces() {
      if (selectedNamespacesBuilder_ == null) {
        if (namespacedResourceRestoreScopeCase_ == 6) {
          return (com.google.cloud.gkebackup.v1.Namespaces) namespacedResourceRestoreScope_;
        }
        return com.google.cloud.gkebackup.v1.Namespaces.getDefaultInstance();
      } else {
        if (namespacedResourceRestoreScopeCase_ == 6) {
          return selectedNamespacesBuilder_.getMessage();
        }
        return com.google.cloud.gkebackup.v1.Namespaces.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of selected Namespaces to restore from the Backup. The listed
     * Namespaces and all resources contained in them will be restored.
     * </pre>
     *
     * <code>.google.cloud.gkebackup.v1.Namespaces selected_namespaces = 6;</code>
     */
    public Builder setSelectedNamespaces(com.google.cloud.gkebackup.v1.Namespaces value) {
      if (selectedNamespacesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        namespacedResourceRestoreScope_ = value;
        onChanged();
      } else {
        selectedNamespacesBuilder_.setMessage(value);
      }
      namespacedResourceRestoreScopeCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of selected Namespaces to restore from the Backup. The listed
     * Namespaces and all resources contained in them will be restored.
     * </pre>
     *
     * <code>.google.cloud.gkebackup.v1.Namespaces selected_namespaces = 6;</code>
     */
    public Builder setSelectedNamespaces(
        com.google.cloud.gkebackup.v1.Namespaces.Builder builderForValue) {
      if (selectedNamespacesBuilder_ == null) {
        namespacedResourceRestoreScope_ = builderForValue.build();
        onChanged();
      } else {
        selectedNamespacesBuilder_.setMessage(builderForValue.build());
      }
      namespacedResourceRestoreScopeCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of selected Namespaces to restore from the Backup. The listed
     * Namespaces and all resources contained in them will be restored.
     * </pre>
     *
     * <code>.google.cloud.gkebackup.v1.Namespaces selected_namespaces = 6;</code>
     */
    public Builder mergeSelectedNamespaces(com.google.cloud.gkebackup.v1.Namespaces value) {
      if (selectedNamespacesBuilder_ == null) {
        if (namespacedResourceRestoreScopeCase_ == 6
            && namespacedResourceRestoreScope_
                != com.google.cloud.gkebackup.v1.Namespaces.getDefaultInstance()) {
          namespacedResourceRestoreScope_ =
              com.google.cloud.gkebackup.v1.Namespaces.newBuilder(
                      (com.google.cloud.gkebackup.v1.Namespaces) namespacedResourceRestoreScope_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          namespacedResourceRestoreScope_ = value;
        }
        onChanged();
      } else {
        if (namespacedResourceRestoreScopeCase_ == 6) {
          selectedNamespacesBuilder_.mergeFrom(value);
        } else {
          selectedNamespacesBuilder_.setMessage(value);
        }
      }
      namespacedResourceRestoreScopeCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of selected Namespaces to restore from the Backup. The listed
     * Namespaces and all resources contained in them will be restored.
     * </pre>
     *
     * <code>.google.cloud.gkebackup.v1.Namespaces selected_namespaces = 6;</code>
     */
    public Builder clearSelectedNamespaces() {
      if (selectedNamespacesBuilder_ == null) {
        if (namespacedResourceRestoreScopeCase_ == 6) {
          namespacedResourceRestoreScopeCase_ = 0;
          namespacedResourceRestoreScope_ = null;
          onChanged();
        }
      } else {
        if (namespacedResourceRestoreScopeCase_ == 6) {
          namespacedResourceRestoreScopeCase_ = 0;
          namespacedResourceRestoreScope_ = null;
        }
        selectedNamespacesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of selected Namespaces to restore from the Backup. The listed
     * Namespaces and all resources contained in them will be restored.
     * </pre>
     *
     * <code>.google.cloud.gkebackup.v1.Namespaces selected_namespaces = 6;</code>
     */
    public com.google.cloud.gkebackup.v1.Namespaces.Builder getSelectedNamespacesBuilder() {
      return getSelectedNamespacesFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A list of selected Namespaces to restore from the Backup. The listed
     * Namespaces and all resources contained in them will be restored.
     * </pre>
     *
     * <code>.google.cloud.gkebackup.v1.Namespaces selected_namespaces = 6;</code>
     */
    @java.lang.Override
    public com.google.cloud.gkebackup.v1.NamespacesOrBuilder getSelectedNamespacesOrBuilder() {
      if ((namespacedResourceRestoreScopeCase_ == 6) && (selectedNamespacesBuilder_ != null)) {
        return selectedNamespacesBuilder_.getMessageOrBuilder();
      } else {
        if (namespacedResourceRestoreScopeCase_ == 6) {
          return (com.google.cloud.gkebackup.v1.Namespaces) namespacedResourceRestoreScope_;
        }
        return com.google.cloud.gkebackup.v1.Namespaces.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of selected Namespaces to restore from the Backup. The listed
     * Namespaces and all resources contained in them will be restored.
     * </pre>
     *
     * <code>.google.cloud.gkebackup.v1.Namespaces selected_namespaces = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gkebackup.v1.Namespaces,
            com.google.cloud.gkebackup.v1.Namespaces.Builder,
            com.google.cloud.gkebackup.v1.NamespacesOrBuilder>
        getSelectedNamespacesFieldBuilder() {
      if (selectedNamespacesBuilder_ == null) {
        if (!(namespacedResourceRestoreScopeCase_ == 6)) {
          namespacedResourceRestoreScope_ =
              com.google.cloud.gkebackup.v1.Namespaces.getDefaultInstance();
        }
        selectedNamespacesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.gkebackup.v1.Namespaces,
                com.google.cloud.gkebackup.v1.Namespaces.Builder,
                com.google.cloud.gkebackup.v1.NamespacesOrBuilder>(
                (com.google.cloud.gkebackup.v1.Namespaces) namespacedResourceRestoreScope_,
                getParentForChildren(),
                isClean());
        namespacedResourceRestoreScope_ = null;
      }
      namespacedResourceRestoreScopeCase_ = 6;
      onChanged();
      return selectedNamespacesBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gkebackup.v1.NamespacedNames,
            com.google.cloud.gkebackup.v1.NamespacedNames.Builder,
            com.google.cloud.gkebackup.v1.NamespacedNamesOrBuilder>
        selectedApplicationsBuilder_;
    /**
     *
     *
     * <pre>
     * A list of selected ProtectedApplications to restore. The listed
     * ProtectedApplications and all the resources to which they refer will be
     * restored.
     * </pre>
     *
     * <code>.google.cloud.gkebackup.v1.NamespacedNames selected_applications = 7;</code>
     *
     * @return Whether the selectedApplications field is set.
     */
    @java.lang.Override
    public boolean hasSelectedApplications() {
      return namespacedResourceRestoreScopeCase_ == 7;
    }
    /**
     *
     *
     * <pre>
     * A list of selected ProtectedApplications to restore. The listed
     * ProtectedApplications and all the resources to which they refer will be
     * restored.
     * </pre>
     *
     * <code>.google.cloud.gkebackup.v1.NamespacedNames selected_applications = 7;</code>
     *
     * @return The selectedApplications.
     */
    @java.lang.Override
    public com.google.cloud.gkebackup.v1.NamespacedNames getSelectedApplications() {
      if (selectedApplicationsBuilder_ == null) {
        if (namespacedResourceRestoreScopeCase_ == 7) {
          return (com.google.cloud.gkebackup.v1.NamespacedNames) namespacedResourceRestoreScope_;
        }
        return com.google.cloud.gkebackup.v1.NamespacedNames.getDefaultInstance();
      } else {
        if (namespacedResourceRestoreScopeCase_ == 7) {
          return selectedApplicationsBuilder_.getMessage();
        }
        return com.google.cloud.gkebackup.v1.NamespacedNames.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of selected ProtectedApplications to restore. The listed
     * ProtectedApplications and all the resources to which they refer will be
     * restored.
     * </pre>
     *
     * <code>.google.cloud.gkebackup.v1.NamespacedNames selected_applications = 7;</code>
     */
    public Builder setSelectedApplications(com.google.cloud.gkebackup.v1.NamespacedNames value) {
      if (selectedApplicationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        namespacedResourceRestoreScope_ = value;
        onChanged();
      } else {
        selectedApplicationsBuilder_.setMessage(value);
      }
      namespacedResourceRestoreScopeCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of selected ProtectedApplications to restore. The listed
     * ProtectedApplications and all the resources to which they refer will be
     * restored.
     * </pre>
     *
     * <code>.google.cloud.gkebackup.v1.NamespacedNames selected_applications = 7;</code>
     */
    public Builder setSelectedApplications(
        com.google.cloud.gkebackup.v1.NamespacedNames.Builder builderForValue) {
      if (selectedApplicationsBuilder_ == null) {
        namespacedResourceRestoreScope_ = builderForValue.build();
        onChanged();
      } else {
        selectedApplicationsBuilder_.setMessage(builderForValue.build());
      }
      namespacedResourceRestoreScopeCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of selected ProtectedApplications to restore. The listed
     * ProtectedApplications and all the resources to which they refer will be
     * restored.
     * </pre>
     *
     * <code>.google.cloud.gkebackup.v1.NamespacedNames selected_applications = 7;</code>
     */
    public Builder mergeSelectedApplications(com.google.cloud.gkebackup.v1.NamespacedNames value) {
      if (selectedApplicationsBuilder_ == null) {
        if (namespacedResourceRestoreScopeCase_ == 7
            && namespacedResourceRestoreScope_
                != com.google.cloud.gkebackup.v1.NamespacedNames.getDefaultInstance()) {
          namespacedResourceRestoreScope_ =
              com.google.cloud.gkebackup.v1.NamespacedNames.newBuilder(
                      (com.google.cloud.gkebackup.v1.NamespacedNames)
                          namespacedResourceRestoreScope_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          namespacedResourceRestoreScope_ = value;
        }
        onChanged();
      } else {
        if (namespacedResourceRestoreScopeCase_ == 7) {
          selectedApplicationsBuilder_.mergeFrom(value);
        } else {
          selectedApplicationsBuilder_.setMessage(value);
        }
      }
      namespacedResourceRestoreScopeCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of selected ProtectedApplications to restore. The listed
     * ProtectedApplications and all the resources to which they refer will be
     * restored.
     * </pre>
     *
     * <code>.google.cloud.gkebackup.v1.NamespacedNames selected_applications = 7;</code>
     */
    public Builder clearSelectedApplications() {
      if (selectedApplicationsBuilder_ == null) {
        if (namespacedResourceRestoreScopeCase_ == 7) {
          namespacedResourceRestoreScopeCase_ = 0;
          namespacedResourceRestoreScope_ = null;
          onChanged();
        }
      } else {
        if (namespacedResourceRestoreScopeCase_ == 7) {
          namespacedResourceRestoreScopeCase_ = 0;
          namespacedResourceRestoreScope_ = null;
        }
        selectedApplicationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of selected ProtectedApplications to restore. The listed
     * ProtectedApplications and all the resources to which they refer will be
     * restored.
     * </pre>
     *
     * <code>.google.cloud.gkebackup.v1.NamespacedNames selected_applications = 7;</code>
     */
    public com.google.cloud.gkebackup.v1.NamespacedNames.Builder getSelectedApplicationsBuilder() {
      return getSelectedApplicationsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A list of selected ProtectedApplications to restore. The listed
     * ProtectedApplications and all the resources to which they refer will be
     * restored.
     * </pre>
     *
     * <code>.google.cloud.gkebackup.v1.NamespacedNames selected_applications = 7;</code>
     */
    @java.lang.Override
    public com.google.cloud.gkebackup.v1.NamespacedNamesOrBuilder
        getSelectedApplicationsOrBuilder() {
      if ((namespacedResourceRestoreScopeCase_ == 7) && (selectedApplicationsBuilder_ != null)) {
        return selectedApplicationsBuilder_.getMessageOrBuilder();
      } else {
        if (namespacedResourceRestoreScopeCase_ == 7) {
          return (com.google.cloud.gkebackup.v1.NamespacedNames) namespacedResourceRestoreScope_;
        }
        return com.google.cloud.gkebackup.v1.NamespacedNames.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of selected ProtectedApplications to restore. The listed
     * ProtectedApplications and all the resources to which they refer will be
     * restored.
     * </pre>
     *
     * <code>.google.cloud.gkebackup.v1.NamespacedNames selected_applications = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gkebackup.v1.NamespacedNames,
            com.google.cloud.gkebackup.v1.NamespacedNames.Builder,
            com.google.cloud.gkebackup.v1.NamespacedNamesOrBuilder>
        getSelectedApplicationsFieldBuilder() {
      if (selectedApplicationsBuilder_ == null) {
        if (!(namespacedResourceRestoreScopeCase_ == 7)) {
          namespacedResourceRestoreScope_ =
              com.google.cloud.gkebackup.v1.NamespacedNames.getDefaultInstance();
        }
        selectedApplicationsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.gkebackup.v1.NamespacedNames,
                com.google.cloud.gkebackup.v1.NamespacedNames.Builder,
                com.google.cloud.gkebackup.v1.NamespacedNamesOrBuilder>(
                (com.google.cloud.gkebackup.v1.NamespacedNames) namespacedResourceRestoreScope_,
                getParentForChildren(),
                isClean());
        namespacedResourceRestoreScope_ = null;
      }
      namespacedResourceRestoreScopeCase_ = 7;
      onChanged();
      return selectedApplicationsBuilder_;
    }

    /**
     *
     *
     * <pre>
     * Do not restore any namespaced resources if set to "True".
     * Specifying this field to "False" is not allowed.
     * </pre>
     *
     * <code>bool no_namespaces = 9;</code>
     *
     * @return Whether the noNamespaces field is set.
     */
    public boolean hasNoNamespaces() {
      return namespacedResourceRestoreScopeCase_ == 9;
    }
    /**
     *
     *
     * <pre>
     * Do not restore any namespaced resources if set to "True".
     * Specifying this field to "False" is not allowed.
     * </pre>
     *
     * <code>bool no_namespaces = 9;</code>
     *
     * @return The noNamespaces.
     */
    public boolean getNoNamespaces() {
      if (namespacedResourceRestoreScopeCase_ == 9) {
        return (java.lang.Boolean) namespacedResourceRestoreScope_;
      }
      return false;
    }
    /**
     *
     *
     * <pre>
     * Do not restore any namespaced resources if set to "True".
     * Specifying this field to "False" is not allowed.
     * </pre>
     *
     * <code>bool no_namespaces = 9;</code>
     *
     * @param value The noNamespaces to set.
     * @return This builder for chaining.
     */
    public Builder setNoNamespaces(boolean value) {

      namespacedResourceRestoreScopeCase_ = 9;
      namespacedResourceRestoreScope_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Do not restore any namespaced resources if set to "True".
     * Specifying this field to "False" is not allowed.
     * </pre>
     *
     * <code>bool no_namespaces = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNoNamespaces() {
      if (namespacedResourceRestoreScopeCase_ == 9) {
        namespacedResourceRestoreScopeCase_ = 0;
        namespacedResourceRestoreScope_ = null;
        onChanged();
      }
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gkebackup.v1.Namespaces,
            com.google.cloud.gkebackup.v1.Namespaces.Builder,
            com.google.cloud.gkebackup.v1.NamespacesOrBuilder>
        excludedNamespacesBuilder_;
    /**
     *
     *
     * <pre>
     * A list of selected namespaces excluded from restoration. All
     * namespaces except those in this list will be restored.
     * </pre>
     *
     * <code>.google.cloud.gkebackup.v1.Namespaces excluded_namespaces = 10;</code>
     *
     * @return Whether the excludedNamespaces field is set.
     */
    @java.lang.Override
    public boolean hasExcludedNamespaces() {
      return namespacedResourceRestoreScopeCase_ == 10;
    }
    /**
     *
     *
     * <pre>
     * A list of selected namespaces excluded from restoration. All
     * namespaces except those in this list will be restored.
     * </pre>
     *
     * <code>.google.cloud.gkebackup.v1.Namespaces excluded_namespaces = 10;</code>
     *
     * @return The excludedNamespaces.
     */
    @java.lang.Override
    public com.google.cloud.gkebackup.v1.Namespaces getExcludedNamespaces() {
      if (excludedNamespacesBuilder_ == null) {
        if (namespacedResourceRestoreScopeCase_ == 10) {
          return (com.google.cloud.gkebackup.v1.Namespaces) namespacedResourceRestoreScope_;
        }
        return com.google.cloud.gkebackup.v1.Namespaces.getDefaultInstance();
      } else {
        if (namespacedResourceRestoreScopeCase_ == 10) {
          return excludedNamespacesBuilder_.getMessage();
        }
        return com.google.cloud.gkebackup.v1.Namespaces.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of selected namespaces excluded from restoration. All
     * namespaces except those in this list will be restored.
     * </pre>
     *
     * <code>.google.cloud.gkebackup.v1.Namespaces excluded_namespaces = 10;</code>
     */
    public Builder setExcludedNamespaces(com.google.cloud.gkebackup.v1.Namespaces value) {
      if (excludedNamespacesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        namespacedResourceRestoreScope_ = value;
        onChanged();
      } else {
        excludedNamespacesBuilder_.setMessage(value);
      }
      namespacedResourceRestoreScopeCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of selected namespaces excluded from restoration. All
     * namespaces except those in this list will be restored.
     * </pre>
     *
     * <code>.google.cloud.gkebackup.v1.Namespaces excluded_namespaces = 10;</code>
     */
    public Builder setExcludedNamespaces(
        com.google.cloud.gkebackup.v1.Namespaces.Builder builderForValue) {
      if (excludedNamespacesBuilder_ == null) {
        namespacedResourceRestoreScope_ = builderForValue.build();
        onChanged();
      } else {
        excludedNamespacesBuilder_.setMessage(builderForValue.build());
      }
      namespacedResourceRestoreScopeCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of selected namespaces excluded from restoration. All
     * namespaces except those in this list will be restored.
     * </pre>
     *
     * <code>.google.cloud.gkebackup.v1.Namespaces excluded_namespaces = 10;</code>
     */
    public Builder mergeExcludedNamespaces(com.google.cloud.gkebackup.v1.Namespaces value) {
      if (excludedNamespacesBuilder_ == null) {
        if (namespacedResourceRestoreScopeCase_ == 10
            && namespacedResourceRestoreScope_
                != com.google.cloud.gkebackup.v1.Namespaces.getDefaultInstance()) {
          namespacedResourceRestoreScope_ =
              com.google.cloud.gkebackup.v1.Namespaces.newBuilder(
                      (com.google.cloud.gkebackup.v1.Namespaces) namespacedResourceRestoreScope_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          namespacedResourceRestoreScope_ = value;
        }
        onChanged();
      } else {
        if (namespacedResourceRestoreScopeCase_ == 10) {
          excludedNamespacesBuilder_.mergeFrom(value);
        } else {
          excludedNamespacesBuilder_.setMessage(value);
        }
      }
      namespacedResourceRestoreScopeCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of selected namespaces excluded from restoration. All
     * namespaces except those in this list will be restored.
     * </pre>
     *
     * <code>.google.cloud.gkebackup.v1.Namespaces excluded_namespaces = 10;</code>
     */
    public Builder clearExcludedNamespaces() {
      if (excludedNamespacesBuilder_ == null) {
        if (namespacedResourceRestoreScopeCase_ == 10) {
          namespacedResourceRestoreScopeCase_ = 0;
          namespacedResourceRestoreScope_ = null;
          onChanged();
        }
      } else {
        if (namespacedResourceRestoreScopeCase_ == 10) {
          namespacedResourceRestoreScopeCase_ = 0;
          namespacedResourceRestoreScope_ = null;
        }
        excludedNamespacesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of selected namespaces excluded from restoration. All
     * namespaces except those in this list will be restored.
     * </pre>
     *
     * <code>.google.cloud.gkebackup.v1.Namespaces excluded_namespaces = 10;</code>
     */
    public com.google.cloud.gkebackup.v1.Namespaces.Builder getExcludedNamespacesBuilder() {
      return getExcludedNamespacesFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A list of selected namespaces excluded from restoration. All
     * namespaces except those in this list will be restored.
     * </pre>
     *
     * <code>.google.cloud.gkebackup.v1.Namespaces excluded_namespaces = 10;</code>
     */
    @java.lang.Override
    public com.google.cloud.gkebackup.v1.NamespacesOrBuilder getExcludedNamespacesOrBuilder() {
      if ((namespacedResourceRestoreScopeCase_ == 10) && (excludedNamespacesBuilder_ != null)) {
        return excludedNamespacesBuilder_.getMessageOrBuilder();
      } else {
        if (namespacedResourceRestoreScopeCase_ == 10) {
          return (com.google.cloud.gkebackup.v1.Namespaces) namespacedResourceRestoreScope_;
        }
        return com.google.cloud.gkebackup.v1.Namespaces.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of selected namespaces excluded from restoration. All
     * namespaces except those in this list will be restored.
     * </pre>
     *
     * <code>.google.cloud.gkebackup.v1.Namespaces excluded_namespaces = 10;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gkebackup.v1.Namespaces,
            com.google.cloud.gkebackup.v1.Namespaces.Builder,
            com.google.cloud.gkebackup.v1.NamespacesOrBuilder>
        getExcludedNamespacesFieldBuilder() {
      if (excludedNamespacesBuilder_ == null) {
        if (!(namespacedResourceRestoreScopeCase_ == 10)) {
          namespacedResourceRestoreScope_ =
              com.google.cloud.gkebackup.v1.Namespaces.getDefaultInstance();
        }
        excludedNamespacesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.gkebackup.v1.Namespaces,
                com.google.cloud.gkebackup.v1.Namespaces.Builder,
                com.google.cloud.gkebackup.v1.NamespacesOrBuilder>(
                (com.google.cloud.gkebackup.v1.Namespaces) namespacedResourceRestoreScope_,
                getParentForChildren(),
                isClean());
        namespacedResourceRestoreScope_ = null;
      }
      namespacedResourceRestoreScopeCase_ = 10;
      onChanged();
      return excludedNamespacesBuilder_;
    }

    private java.util.List<com.google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule>
        substitutionRules_ = java.util.Collections.emptyList();

    private void ensureSubstitutionRulesIsMutable() {
      if (!((bitField0_ & 0x00000200) != 0)) {
        substitutionRules_ =
            new java.util.ArrayList<com.google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule>(
                substitutionRules_);
        bitField0_ |= 0x00000200;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule,
            com.google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule.Builder,
            com.google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRuleOrBuilder>
        substitutionRulesBuilder_;

    /**
     *
     *
     * <pre>
     * A list of transformation rules to be applied against Kubernetes resources
     * as they are selected for restoration from a Backup. Rules are executed in
     * order defined - this order matters, as changes made by a rule may impact
     * the filtering logic of subsequent rules. An empty list means no
     * substitution will occur.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule substitution_rules = 8;
     * </code>
     */
    public java.util.List<com.google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule>
        getSubstitutionRulesList() {
      if (substitutionRulesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(substitutionRules_);
      } else {
        return substitutionRulesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of transformation rules to be applied against Kubernetes resources
     * as they are selected for restoration from a Backup. Rules are executed in
     * order defined - this order matters, as changes made by a rule may impact
     * the filtering logic of subsequent rules. An empty list means no
     * substitution will occur.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule substitution_rules = 8;
     * </code>
     */
    public int getSubstitutionRulesCount() {
      if (substitutionRulesBuilder_ == null) {
        return substitutionRules_.size();
      } else {
        return substitutionRulesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of transformation rules to be applied against Kubernetes resources
     * as they are selected for restoration from a Backup. Rules are executed in
     * order defined - this order matters, as changes made by a rule may impact
     * the filtering logic of subsequent rules. An empty list means no
     * substitution will occur.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule substitution_rules = 8;
     * </code>
     */
    public com.google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule getSubstitutionRules(
        int index) {
      if (substitutionRulesBuilder_ == null) {
        return substitutionRules_.get(index);
      } else {
        return substitutionRulesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of transformation rules to be applied against Kubernetes resources
     * as they are selected for restoration from a Backup. Rules are executed in
     * order defined - this order matters, as changes made by a rule may impact
     * the filtering logic of subsequent rules. An empty list means no
     * substitution will occur.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule substitution_rules = 8;
     * </code>
     */
    public Builder setSubstitutionRules(
        int index, com.google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule value) {
      if (substitutionRulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSubstitutionRulesIsMutable();
        substitutionRules_.set(index, value);
        onChanged();
      } else {
        substitutionRulesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of transformation rules to be applied against Kubernetes resources
     * as they are selected for restoration from a Backup. Rules are executed in
     * order defined - this order matters, as changes made by a rule may impact
     * the filtering logic of subsequent rules. An empty list means no
     * substitution will occur.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule substitution_rules = 8;
     * </code>
     */
    public Builder setSubstitutionRules(
        int index,
        com.google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule.Builder builderForValue) {
      if (substitutionRulesBuilder_ == null) {
        ensureSubstitutionRulesIsMutable();
        substitutionRules_.set(index, builderForValue.build());
        onChanged();
      } else {
        substitutionRulesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of transformation rules to be applied against Kubernetes resources
     * as they are selected for restoration from a Backup. Rules are executed in
     * order defined - this order matters, as changes made by a rule may impact
     * the filtering logic of subsequent rules. An empty list means no
     * substitution will occur.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule substitution_rules = 8;
     * </code>
     */
    public Builder addSubstitutionRules(
        com.google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule value) {
      if (substitutionRulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSubstitutionRulesIsMutable();
        substitutionRules_.add(value);
        onChanged();
      } else {
        substitutionRulesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of transformation rules to be applied against Kubernetes resources
     * as they are selected for restoration from a Backup. Rules are executed in
     * order defined - this order matters, as changes made by a rule may impact
     * the filtering logic of subsequent rules. An empty list means no
     * substitution will occur.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule substitution_rules = 8;
     * </code>
     */
    public Builder addSubstitutionRules(
        int index, com.google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule value) {
      if (substitutionRulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSubstitutionRulesIsMutable();
        substitutionRules_.add(index, value);
        onChanged();
      } else {
        substitutionRulesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of transformation rules to be applied against Kubernetes resources
     * as they are selected for restoration from a Backup. Rules are executed in
     * order defined - this order matters, as changes made by a rule may impact
     * the filtering logic of subsequent rules. An empty list means no
     * substitution will occur.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule substitution_rules = 8;
     * </code>
     */
    public Builder addSubstitutionRules(
        com.google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule.Builder builderForValue) {
      if (substitutionRulesBuilder_ == null) {
        ensureSubstitutionRulesIsMutable();
        substitutionRules_.add(builderForValue.build());
        onChanged();
      } else {
        substitutionRulesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of transformation rules to be applied against Kubernetes resources
     * as they are selected for restoration from a Backup. Rules are executed in
     * order defined - this order matters, as changes made by a rule may impact
     * the filtering logic of subsequent rules. An empty list means no
     * substitution will occur.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule substitution_rules = 8;
     * </code>
     */
    public Builder addSubstitutionRules(
        int index,
        com.google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule.Builder builderForValue) {
      if (substitutionRulesBuilder_ == null) {
        ensureSubstitutionRulesIsMutable();
        substitutionRules_.add(index, builderForValue.build());
        onChanged();
      } else {
        substitutionRulesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of transformation rules to be applied against Kubernetes resources
     * as they are selected for restoration from a Backup. Rules are executed in
     * order defined - this order matters, as changes made by a rule may impact
     * the filtering logic of subsequent rules. An empty list means no
     * substitution will occur.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule substitution_rules = 8;
     * </code>
     */
    public Builder addAllSubstitutionRules(
        java.lang.Iterable<? extends com.google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule>
            values) {
      if (substitutionRulesBuilder_ == null) {
        ensureSubstitutionRulesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, substitutionRules_);
        onChanged();
      } else {
        substitutionRulesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of transformation rules to be applied against Kubernetes resources
     * as they are selected for restoration from a Backup. Rules are executed in
     * order defined - this order matters, as changes made by a rule may impact
     * the filtering logic of subsequent rules. An empty list means no
     * substitution will occur.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule substitution_rules = 8;
     * </code>
     */
    public Builder clearSubstitutionRules() {
      if (substitutionRulesBuilder_ == null) {
        substitutionRules_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000200);
        onChanged();
      } else {
        substitutionRulesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of transformation rules to be applied against Kubernetes resources
     * as they are selected for restoration from a Backup. Rules are executed in
     * order defined - this order matters, as changes made by a rule may impact
     * the filtering logic of subsequent rules. An empty list means no
     * substitution will occur.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule substitution_rules = 8;
     * </code>
     */
    public Builder removeSubstitutionRules(int index) {
      if (substitutionRulesBuilder_ == null) {
        ensureSubstitutionRulesIsMutable();
        substitutionRules_.remove(index);
        onChanged();
      } else {
        substitutionRulesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of transformation rules to be applied against Kubernetes resources
     * as they are selected for restoration from a Backup. Rules are executed in
     * order defined - this order matters, as changes made by a rule may impact
     * the filtering logic of subsequent rules. An empty list means no
     * substitution will occur.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule substitution_rules = 8;
     * </code>
     */
    public com.google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule.Builder
        getSubstitutionRulesBuilder(int index) {
      return getSubstitutionRulesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * A list of transformation rules to be applied against Kubernetes resources
     * as they are selected for restoration from a Backup. Rules are executed in
     * order defined - this order matters, as changes made by a rule may impact
     * the filtering logic of subsequent rules. An empty list means no
     * substitution will occur.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule substitution_rules = 8;
     * </code>
     */
    public com.google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRuleOrBuilder
        getSubstitutionRulesOrBuilder(int index) {
      if (substitutionRulesBuilder_ == null) {
        return substitutionRules_.get(index);
      } else {
        return substitutionRulesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of transformation rules to be applied against Kubernetes resources
     * as they are selected for restoration from a Backup. Rules are executed in
     * order defined - this order matters, as changes made by a rule may impact
     * the filtering logic of subsequent rules. An empty list means no
     * substitution will occur.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule substitution_rules = 8;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRuleOrBuilder>
        getSubstitutionRulesOrBuilderList() {
      if (substitutionRulesBuilder_ != null) {
        return substitutionRulesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(substitutionRules_);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of transformation rules to be applied against Kubernetes resources
     * as they are selected for restoration from a Backup. Rules are executed in
     * order defined - this order matters, as changes made by a rule may impact
     * the filtering logic of subsequent rules. An empty list means no
     * substitution will occur.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule substitution_rules = 8;
     * </code>
     */
    public com.google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule.Builder
        addSubstitutionRulesBuilder() {
      return getSubstitutionRulesFieldBuilder()
          .addBuilder(
              com.google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of transformation rules to be applied against Kubernetes resources
     * as they are selected for restoration from a Backup. Rules are executed in
     * order defined - this order matters, as changes made by a rule may impact
     * the filtering logic of subsequent rules. An empty list means no
     * substitution will occur.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule substitution_rules = 8;
     * </code>
     */
    public com.google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule.Builder
        addSubstitutionRulesBuilder(int index) {
      return getSubstitutionRulesFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of transformation rules to be applied against Kubernetes resources
     * as they are selected for restoration from a Backup. Rules are executed in
     * order defined - this order matters, as changes made by a rule may impact
     * the filtering logic of subsequent rules. An empty list means no
     * substitution will occur.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule substitution_rules = 8;
     * </code>
     */
    public java.util.List<com.google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule.Builder>
        getSubstitutionRulesBuilderList() {
      return getSubstitutionRulesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule,
            com.google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule.Builder,
            com.google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRuleOrBuilder>
        getSubstitutionRulesFieldBuilder() {
      if (substitutionRulesBuilder_ == null) {
        substitutionRulesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule,
                com.google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule.Builder,
                com.google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRuleOrBuilder>(
                substitutionRules_,
                ((bitField0_ & 0x00000200) != 0),
                getParentForChildren(),
                isClean());
        substitutionRules_ = null;
      }
      return substitutionRulesBuilder_;
    }

    private java.util.List<com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRule>
        transformationRules_ = java.util.Collections.emptyList();

    private void ensureTransformationRulesIsMutable() {
      if (!((bitField0_ & 0x00000400) != 0)) {
        transformationRules_ =
            new java.util.ArrayList<com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRule>(
                transformationRules_);
        bitField0_ |= 0x00000400;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRule,
            com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRule.Builder,
            com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleOrBuilder>
        transformationRulesBuilder_;

    /**
     *
     *
     * <pre>
     * A list of transformation rules to be applied against Kubernetes resources
     * as they are selected for restoration from a Backup. Rules are executed in
     * order defined - this order matters, as changes made by a rule may impact
     * the filtering logic of subsequent rules. An empty list means no
     * transformation will occur.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkebackup.v1.RestoreConfig.TransformationRule transformation_rules = 11;
     * </code>
     */
    public java.util.List<com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRule>
        getTransformationRulesList() {
      if (transformationRulesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(transformationRules_);
      } else {
        return transformationRulesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of transformation rules to be applied against Kubernetes resources
     * as they are selected for restoration from a Backup. Rules are executed in
     * order defined - this order matters, as changes made by a rule may impact
     * the filtering logic of subsequent rules. An empty list means no
     * transformation will occur.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkebackup.v1.RestoreConfig.TransformationRule transformation_rules = 11;
     * </code>
     */
    public int getTransformationRulesCount() {
      if (transformationRulesBuilder_ == null) {
        return transformationRules_.size();
      } else {
        return transformationRulesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of transformation rules to be applied against Kubernetes resources
     * as they are selected for restoration from a Backup. Rules are executed in
     * order defined - this order matters, as changes made by a rule may impact
     * the filtering logic of subsequent rules. An empty list means no
     * transformation will occur.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkebackup.v1.RestoreConfig.TransformationRule transformation_rules = 11;
     * </code>
     */
    public com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRule getTransformationRules(
        int index) {
      if (transformationRulesBuilder_ == null) {
        return transformationRules_.get(index);
      } else {
        return transformationRulesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of transformation rules to be applied against Kubernetes resources
     * as they are selected for restoration from a Backup. Rules are executed in
     * order defined - this order matters, as changes made by a rule may impact
     * the filtering logic of subsequent rules. An empty list means no
     * transformation will occur.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkebackup.v1.RestoreConfig.TransformationRule transformation_rules = 11;
     * </code>
     */
    public Builder setTransformationRules(
        int index, com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRule value) {
      if (transformationRulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTransformationRulesIsMutable();
        transformationRules_.set(index, value);
        onChanged();
      } else {
        transformationRulesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of transformation rules to be applied against Kubernetes resources
     * as they are selected for restoration from a Backup. Rules are executed in
     * order defined - this order matters, as changes made by a rule may impact
     * the filtering logic of subsequent rules. An empty list means no
     * transformation will occur.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkebackup.v1.RestoreConfig.TransformationRule transformation_rules = 11;
     * </code>
     */
    public Builder setTransformationRules(
        int index,
        com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRule.Builder builderForValue) {
      if (transformationRulesBuilder_ == null) {
        ensureTransformationRulesIsMutable();
        transformationRules_.set(index, builderForValue.build());
        onChanged();
      } else {
        transformationRulesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of transformation rules to be applied against Kubernetes resources
     * as they are selected for restoration from a Backup. Rules are executed in
     * order defined - this order matters, as changes made by a rule may impact
     * the filtering logic of subsequent rules. An empty list means no
     * transformation will occur.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkebackup.v1.RestoreConfig.TransformationRule transformation_rules = 11;
     * </code>
     */
    public Builder addTransformationRules(
        com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRule value) {
      if (transformationRulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTransformationRulesIsMutable();
        transformationRules_.add(value);
        onChanged();
      } else {
        transformationRulesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of transformation rules to be applied against Kubernetes resources
     * as they are selected for restoration from a Backup. Rules are executed in
     * order defined - this order matters, as changes made by a rule may impact
     * the filtering logic of subsequent rules. An empty list means no
     * transformation will occur.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkebackup.v1.RestoreConfig.TransformationRule transformation_rules = 11;
     * </code>
     */
    public Builder addTransformationRules(
        int index, com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRule value) {
      if (transformationRulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTransformationRulesIsMutable();
        transformationRules_.add(index, value);
        onChanged();
      } else {
        transformationRulesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of transformation rules to be applied against Kubernetes resources
     * as they are selected for restoration from a Backup. Rules are executed in
     * order defined - this order matters, as changes made by a rule may impact
     * the filtering logic of subsequent rules. An empty list means no
     * transformation will occur.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkebackup.v1.RestoreConfig.TransformationRule transformation_rules = 11;
     * </code>
     */
    public Builder addTransformationRules(
        com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRule.Builder builderForValue) {
      if (transformationRulesBuilder_ == null) {
        ensureTransformationRulesIsMutable();
        transformationRules_.add(builderForValue.build());
        onChanged();
      } else {
        transformationRulesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of transformation rules to be applied against Kubernetes resources
     * as they are selected for restoration from a Backup. Rules are executed in
     * order defined - this order matters, as changes made by a rule may impact
     * the filtering logic of subsequent rules. An empty list means no
     * transformation will occur.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkebackup.v1.RestoreConfig.TransformationRule transformation_rules = 11;
     * </code>
     */
    public Builder addTransformationRules(
        int index,
        com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRule.Builder builderForValue) {
      if (transformationRulesBuilder_ == null) {
        ensureTransformationRulesIsMutable();
        transformationRules_.add(index, builderForValue.build());
        onChanged();
      } else {
        transformationRulesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of transformation rules to be applied against Kubernetes resources
     * as they are selected for restoration from a Backup. Rules are executed in
     * order defined - this order matters, as changes made by a rule may impact
     * the filtering logic of subsequent rules. An empty list means no
     * transformation will occur.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkebackup.v1.RestoreConfig.TransformationRule transformation_rules = 11;
     * </code>
     */
    public Builder addAllTransformationRules(
        java.lang.Iterable<? extends com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRule>
            values) {
      if (transformationRulesBuilder_ == null) {
        ensureTransformationRulesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, transformationRules_);
        onChanged();
      } else {
        transformationRulesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of transformation rules to be applied against Kubernetes resources
     * as they are selected for restoration from a Backup. Rules are executed in
     * order defined - this order matters, as changes made by a rule may impact
     * the filtering logic of subsequent rules. An empty list means no
     * transformation will occur.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkebackup.v1.RestoreConfig.TransformationRule transformation_rules = 11;
     * </code>
     */
    public Builder clearTransformationRules() {
      if (transformationRulesBuilder_ == null) {
        transformationRules_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000400);
        onChanged();
      } else {
        transformationRulesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of transformation rules to be applied against Kubernetes resources
     * as they are selected for restoration from a Backup. Rules are executed in
     * order defined - this order matters, as changes made by a rule may impact
     * the filtering logic of subsequent rules. An empty list means no
     * transformation will occur.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkebackup.v1.RestoreConfig.TransformationRule transformation_rules = 11;
     * </code>
     */
    public Builder removeTransformationRules(int index) {
      if (transformationRulesBuilder_ == null) {
        ensureTransformationRulesIsMutable();
        transformationRules_.remove(index);
        onChanged();
      } else {
        transformationRulesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of transformation rules to be applied against Kubernetes resources
     * as they are selected for restoration from a Backup. Rules are executed in
     * order defined - this order matters, as changes made by a rule may impact
     * the filtering logic of subsequent rules. An empty list means no
     * transformation will occur.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkebackup.v1.RestoreConfig.TransformationRule transformation_rules = 11;
     * </code>
     */
    public com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRule.Builder
        getTransformationRulesBuilder(int index) {
      return getTransformationRulesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * A list of transformation rules to be applied against Kubernetes resources
     * as they are selected for restoration from a Backup. Rules are executed in
     * order defined - this order matters, as changes made by a rule may impact
     * the filtering logic of subsequent rules. An empty list means no
     * transformation will occur.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkebackup.v1.RestoreConfig.TransformationRule transformation_rules = 11;
     * </code>
     */
    public com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleOrBuilder
        getTransformationRulesOrBuilder(int index) {
      if (transformationRulesBuilder_ == null) {
        return transformationRules_.get(index);
      } else {
        return transformationRulesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of transformation rules to be applied against Kubernetes resources
     * as they are selected for restoration from a Backup. Rules are executed in
     * order defined - this order matters, as changes made by a rule may impact
     * the filtering logic of subsequent rules. An empty list means no
     * transformation will occur.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkebackup.v1.RestoreConfig.TransformationRule transformation_rules = 11;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleOrBuilder>
        getTransformationRulesOrBuilderList() {
      if (transformationRulesBuilder_ != null) {
        return transformationRulesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(transformationRules_);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of transformation rules to be applied against Kubernetes resources
     * as they are selected for restoration from a Backup. Rules are executed in
     * order defined - this order matters, as changes made by a rule may impact
     * the filtering logic of subsequent rules. An empty list means no
     * transformation will occur.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkebackup.v1.RestoreConfig.TransformationRule transformation_rules = 11;
     * </code>
     */
    public com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRule.Builder
        addTransformationRulesBuilder() {
      return getTransformationRulesFieldBuilder()
          .addBuilder(
              com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRule.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of transformation rules to be applied against Kubernetes resources
     * as they are selected for restoration from a Backup. Rules are executed in
     * order defined - this order matters, as changes made by a rule may impact
     * the filtering logic of subsequent rules. An empty list means no
     * transformation will occur.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkebackup.v1.RestoreConfig.TransformationRule transformation_rules = 11;
     * </code>
     */
    public com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRule.Builder
        addTransformationRulesBuilder(int index) {
      return getTransformationRulesFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRule.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of transformation rules to be applied against Kubernetes resources
     * as they are selected for restoration from a Backup. Rules are executed in
     * order defined - this order matters, as changes made by a rule may impact
     * the filtering logic of subsequent rules. An empty list means no
     * transformation will occur.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkebackup.v1.RestoreConfig.TransformationRule transformation_rules = 11;
     * </code>
     */
    public java.util.List<com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRule.Builder>
        getTransformationRulesBuilderList() {
      return getTransformationRulesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRule,
            com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRule.Builder,
            com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleOrBuilder>
        getTransformationRulesFieldBuilder() {
      if (transformationRulesBuilder_ == null) {
        transformationRulesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRule,
                com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRule.Builder,
                com.google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleOrBuilder>(
                transformationRules_,
                ((bitField0_ & 0x00000400) != 0),
                getParentForChildren(),
                isClean());
        transformationRules_ = null;
      }
      return transformationRulesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.gkebackup.v1.RestoreConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.gkebackup.v1.RestoreConfig)
  private static final com.google.cloud.gkebackup.v1.RestoreConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.gkebackup.v1.RestoreConfig();
  }

  public static com.google.cloud.gkebackup.v1.RestoreConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RestoreConfig> PARSER =
      new com.google.protobuf.AbstractParser<RestoreConfig>() {
        @java.lang.Override
        public RestoreConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RestoreConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RestoreConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.gkebackup.v1.RestoreConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
