/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/gkebackup/v1/restore.proto

package com.google.cloud.gkebackup.v1;

public interface RestoreOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.gkebackup.v1.Restore)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Output only. The full name of the Restore resource.
   * Format: `projects/&#42;&#47;locations/&#42;&#47;restorePlans/&#42;&#47;restores/&#42;`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  java.lang.String getName();
  /**
   *
   *
   * <pre>
   * Output only. The full name of the Restore resource.
   * Format: `projects/&#42;&#47;locations/&#42;&#47;restorePlans/&#42;&#47;restores/&#42;`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * Output only. Server generated global unique identifier of
   * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier) format.
   * </pre>
   *
   * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The uid.
   */
  java.lang.String getUid();
  /**
   *
   *
   * <pre>
   * Output only. Server generated global unique identifier of
   * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier) format.
   * </pre>
   *
   * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for uid.
   */
  com.google.protobuf.ByteString getUidBytes();

  /**
   *
   *
   * <pre>
   * Output only. The timestamp when this Restore resource was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  boolean hasCreateTime();
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when this Restore resource was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  com.google.protobuf.Timestamp getCreateTime();
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when this Restore resource was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. The timestamp when this Restore resource was last
   * updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  boolean hasUpdateTime();
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when this Restore resource was last
   * updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  com.google.protobuf.Timestamp getUpdateTime();
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when this Restore resource was last
   * updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * User specified descriptive string for this Restore.
   * </pre>
   *
   * <code>string description = 5;</code>
   *
   * @return The description.
   */
  java.lang.String getDescription();
  /**
   *
   *
   * <pre>
   * User specified descriptive string for this Restore.
   * </pre>
   *
   * <code>string description = 5;</code>
   *
   * @return The bytes for description.
   */
  com.google.protobuf.ByteString getDescriptionBytes();

  /**
   *
   *
   * <pre>
   * Required. Immutable. A reference to the
   * [Backup][google.cloud.gkebackup.v1.Backup] used as the source from which
   * this Restore will restore. Note that this Backup must be a sub-resource of
   * the RestorePlan's
   * [backup_plan][google.cloud.gkebackup.v1.RestorePlan.backup_plan]. Format:
   * `projects/&#42;&#47;locations/&#42;&#47;backupPlans/&#42;&#47;backups/&#42;`.
   * </pre>
   *
   * <code>
   * string backup = 6 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The backup.
   */
  java.lang.String getBackup();
  /**
   *
   *
   * <pre>
   * Required. Immutable. A reference to the
   * [Backup][google.cloud.gkebackup.v1.Backup] used as the source from which
   * this Restore will restore. Note that this Backup must be a sub-resource of
   * the RestorePlan's
   * [backup_plan][google.cloud.gkebackup.v1.RestorePlan.backup_plan]. Format:
   * `projects/&#42;&#47;locations/&#42;&#47;backupPlans/&#42;&#47;backups/&#42;`.
   * </pre>
   *
   * <code>
   * string backup = 6 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for backup.
   */
  com.google.protobuf.ByteString getBackupBytes();

  /**
   *
   *
   * <pre>
   * Output only. The target cluster into which this Restore will restore data.
   * Valid formats:
   *
   *   - `projects/&#42;&#47;locations/&#42;&#47;clusters/&#42;`
   *   - `projects/&#42;&#47;zones/&#42;&#47;clusters/&#42;`
   *
   * Inherited from parent RestorePlan's
   * [cluster][google.cloud.gkebackup.v1.RestorePlan.cluster] value.
   * </pre>
   *
   * <code>
   * string cluster = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The cluster.
   */
  java.lang.String getCluster();
  /**
   *
   *
   * <pre>
   * Output only. The target cluster into which this Restore will restore data.
   * Valid formats:
   *
   *   - `projects/&#42;&#47;locations/&#42;&#47;clusters/&#42;`
   *   - `projects/&#42;&#47;zones/&#42;&#47;clusters/&#42;`
   *
   * Inherited from parent RestorePlan's
   * [cluster][google.cloud.gkebackup.v1.RestorePlan.cluster] value.
   * </pre>
   *
   * <code>
   * string cluster = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for cluster.
   */
  com.google.protobuf.ByteString getClusterBytes();

  /**
   *
   *
   * <pre>
   * Output only. Configuration of the Restore.  Inherited from parent
   * RestorePlan's
   * [restore_config][google.cloud.gkebackup.v1.RestorePlan.restore_config].
   * </pre>
   *
   * <code>
   * .google.cloud.gkebackup.v1.RestoreConfig restore_config = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the restoreConfig field is set.
   */
  boolean hasRestoreConfig();
  /**
   *
   *
   * <pre>
   * Output only. Configuration of the Restore.  Inherited from parent
   * RestorePlan's
   * [restore_config][google.cloud.gkebackup.v1.RestorePlan.restore_config].
   * </pre>
   *
   * <code>
   * .google.cloud.gkebackup.v1.RestoreConfig restore_config = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The restoreConfig.
   */
  com.google.cloud.gkebackup.v1.RestoreConfig getRestoreConfig();
  /**
   *
   *
   * <pre>
   * Output only. Configuration of the Restore.  Inherited from parent
   * RestorePlan's
   * [restore_config][google.cloud.gkebackup.v1.RestorePlan.restore_config].
   * </pre>
   *
   * <code>
   * .google.cloud.gkebackup.v1.RestoreConfig restore_config = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.cloud.gkebackup.v1.RestoreConfigOrBuilder getRestoreConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * A set of custom labels supplied by user.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 9;</code>
   */
  int getLabelsCount();
  /**
   *
   *
   * <pre>
   * A set of custom labels supplied by user.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 9;</code>
   */
  boolean containsLabels(java.lang.String key);
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Deprecated
  java.util.Map<java.lang.String, java.lang.String> getLabels();
  /**
   *
   *
   * <pre>
   * A set of custom labels supplied by user.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 9;</code>
   */
  java.util.Map<java.lang.String, java.lang.String> getLabelsMap();
  /**
   *
   *
   * <pre>
   * A set of custom labels supplied by user.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 9;</code>
   */
  /* nullable */
  java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue);
  /**
   *
   *
   * <pre>
   * A set of custom labels supplied by user.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 9;</code>
   */
  java.lang.String getLabelsOrThrow(java.lang.String key);

  /**
   *
   *
   * <pre>
   * Output only. The current state of the Restore.
   * </pre>
   *
   * <code>
   * .google.cloud.gkebackup.v1.Restore.State state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  int getStateValue();
  /**
   *
   *
   * <pre>
   * Output only. The current state of the Restore.
   * </pre>
   *
   * <code>
   * .google.cloud.gkebackup.v1.Restore.State state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  com.google.cloud.gkebackup.v1.Restore.State getState();

  /**
   *
   *
   * <pre>
   * Output only. Human-readable description of why the Restore is in its
   * current state.
   * </pre>
   *
   * <code>string state_reason = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The stateReason.
   */
  java.lang.String getStateReason();
  /**
   *
   *
   * <pre>
   * Output only. Human-readable description of why the Restore is in its
   * current state.
   * </pre>
   *
   * <code>string state_reason = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for stateReason.
   */
  com.google.protobuf.ByteString getStateReasonBytes();

  /**
   *
   *
   * <pre>
   * Output only. Timestamp of when the restore operation completed.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp complete_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the completeTime field is set.
   */
  boolean hasCompleteTime();
  /**
   *
   *
   * <pre>
   * Output only. Timestamp of when the restore operation completed.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp complete_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The completeTime.
   */
  com.google.protobuf.Timestamp getCompleteTime();
  /**
   *
   *
   * <pre>
   * Output only. Timestamp of when the restore operation completed.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp complete_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getCompleteTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. Number of resources restored during the restore execution.
   * </pre>
   *
   * <code>int32 resources_restored_count = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The resourcesRestoredCount.
   */
  int getResourcesRestoredCount();

  /**
   *
   *
   * <pre>
   * Output only. Number of resources excluded during the restore execution.
   * </pre>
   *
   * <code>int32 resources_excluded_count = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The resourcesExcludedCount.
   */
  int getResourcesExcludedCount();

  /**
   *
   *
   * <pre>
   * Output only. Number of resources that failed to be restored during the
   * restore execution.
   * </pre>
   *
   * <code>int32 resources_failed_count = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The resourcesFailedCount.
   */
  int getResourcesFailedCount();

  /**
   *
   *
   * <pre>
   * Output only. Number of volumes restored during the restore execution.
   * </pre>
   *
   * <code>int32 volumes_restored_count = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The volumesRestoredCount.
   */
  int getVolumesRestoredCount();

  /**
   *
   *
   * <pre>
   * Output only. `etag` is used for optimistic concurrency control as a way to
   * help prevent simultaneous updates of a restore from overwriting each other.
   * It is strongly suggested that systems make use of the `etag` in the
   * read-modify-write cycle to perform restore updates in order to avoid
   * race conditions: An `etag` is returned in the response to `GetRestore`,
   * and systems are expected to put that etag in the request to
   * `UpdateRestore` or `DeleteRestore` to ensure that their change will be
   * applied to the same version of the resource.
   * </pre>
   *
   * <code>string etag = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The etag.
   */
  java.lang.String getEtag();
  /**
   *
   *
   * <pre>
   * Output only. `etag` is used for optimistic concurrency control as a way to
   * help prevent simultaneous updates of a restore from overwriting each other.
   * It is strongly suggested that systems make use of the `etag` in the
   * read-modify-write cycle to perform restore updates in order to avoid
   * race conditions: An `etag` is returned in the response to `GetRestore`,
   * and systems are expected to put that etag in the request to
   * `UpdateRestore` or `DeleteRestore` to ensure that their change will be
   * applied to the same version of the resource.
   * </pre>
   *
   * <code>string etag = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for etag.
   */
  com.google.protobuf.ByteString getEtagBytes();
}
