/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/gkebackup/v1/restore_plan.proto

package com.google.cloud.gkebackup.v1;

/**
 *
 *
 * <pre>
 * The configuration of a potential series of Restore operations to be performed
 * against Backups belong to a particular BackupPlan.
 * Next id: 13
 * </pre>
 *
 * Protobuf type {@code google.cloud.gkebackup.v1.RestorePlan}
 */
public final class RestorePlan extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.gkebackup.v1.RestorePlan)
    RestorePlanOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RestorePlan.newBuilder() to construct.
  private RestorePlan(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RestorePlan() {
    name_ = "";
    uid_ = "";
    description_ = "";
    backupPlan_ = "";
    cluster_ = "";
    etag_ = "";
    state_ = 0;
    stateReason_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RestorePlan();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.gkebackup.v1.RestorePlanProto
        .internal_static_google_cloud_gkebackup_v1_RestorePlan_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 9:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.gkebackup.v1.RestorePlanProto
        .internal_static_google_cloud_gkebackup_v1_RestorePlan_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.gkebackup.v1.RestorePlan.class,
            com.google.cloud.gkebackup.v1.RestorePlan.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * State
   * </pre>
   *
   * Protobuf enum {@code google.cloud.gkebackup.v1.RestorePlan.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default first value for Enums.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Waiting for cluster state to be RUNNING.
     * </pre>
     *
     * <code>CLUSTER_PENDING = 1;</code>
     */
    CLUSTER_PENDING(1),
    /**
     *
     *
     * <pre>
     * The RestorePlan has successfully been created and is ready for Restores.
     * </pre>
     *
     * <code>READY = 2;</code>
     */
    READY(2),
    /**
     *
     *
     * <pre>
     * RestorePlan creation has failed.
     * </pre>
     *
     * <code>FAILED = 3;</code>
     */
    FAILED(3),
    /**
     *
     *
     * <pre>
     * The RestorePlan is in the process of being deleted.
     * </pre>
     *
     * <code>DELETING = 4;</code>
     */
    DELETING(4),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default first value for Enums.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Waiting for cluster state to be RUNNING.
     * </pre>
     *
     * <code>CLUSTER_PENDING = 1;</code>
     */
    public static final int CLUSTER_PENDING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The RestorePlan has successfully been created and is ready for Restores.
     * </pre>
     *
     * <code>READY = 2;</code>
     */
    public static final int READY_VALUE = 2;
    /**
     *
     *
     * <pre>
     * RestorePlan creation has failed.
     * </pre>
     *
     * <code>FAILED = 3;</code>
     */
    public static final int FAILED_VALUE = 3;
    /**
     *
     *
     * <pre>
     * The RestorePlan is in the process of being deleted.
     * </pre>
     *
     * <code>DELETING = 4;</code>
     */
    public static final int DELETING_VALUE = 4;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return CLUSTER_PENDING;
        case 2:
          return READY;
        case 3:
          return FAILED;
        case 4:
          return DELETING;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.gkebackup.v1.RestorePlan.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.gkebackup.v1.RestorePlan.State)
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The full name of the RestorePlan resource.
   * Format: `projects/&#42;&#47;locations/&#42;&#47;restorePlans/&#42;`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The full name of the RestorePlan resource.
   * Format: `projects/&#42;&#47;locations/&#42;&#47;restorePlans/&#42;`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int UID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object uid_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Server generated global unique identifier of
   * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier) format.
   * </pre>
   *
   * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The uid.
   */
  @java.lang.Override
  public java.lang.String getUid() {
    java.lang.Object ref = uid_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      uid_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Server generated global unique identifier of
   * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier) format.
   * </pre>
   *
   * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for uid.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUidBytes() {
    java.lang.Object ref = uid_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      uid_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when this RestorePlan resource was
   * created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when this RestorePlan resource was
   * created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when this RestorePlan resource was
   * created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when this RestorePlan resource was last
   * updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when this RestorePlan resource was last
   * updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when this RestorePlan resource was last
   * updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * User specified descriptive string for this RestorePlan.
   * </pre>
   *
   * <code>string description = 5;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * User specified descriptive string for this RestorePlan.
   * </pre>
   *
   * <code>string description = 5;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int BACKUP_PLAN_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object backupPlan_ = "";
  /**
   *
   *
   * <pre>
   * Required. Immutable. A reference to the
   * [BackupPlan][google.cloud.gkebackup.v1.BackupPlan] from which Backups may
   * be used as the source for Restores created via this RestorePlan. Format:
   * `projects/&#42;&#47;locations/&#42;&#47;backupPlans/&#42;`.
   * </pre>
   *
   * <code>
   * string backup_plan = 6 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The backupPlan.
   */
  @java.lang.Override
  public java.lang.String getBackupPlan() {
    java.lang.Object ref = backupPlan_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      backupPlan_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Immutable. A reference to the
   * [BackupPlan][google.cloud.gkebackup.v1.BackupPlan] from which Backups may
   * be used as the source for Restores created via this RestorePlan. Format:
   * `projects/&#42;&#47;locations/&#42;&#47;backupPlans/&#42;`.
   * </pre>
   *
   * <code>
   * string backup_plan = 6 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for backupPlan.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBackupPlanBytes() {
    java.lang.Object ref = backupPlan_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      backupPlan_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CLUSTER_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object cluster_ = "";
  /**
   *
   *
   * <pre>
   * Required. Immutable. The target cluster into which Restores created via
   * this RestorePlan will restore data. NOTE: the cluster's region must be the
   * same as the RestorePlan. Valid formats:
   *
   *   - `projects/&#42;&#47;locations/&#42;&#47;clusters/&#42;`
   *   - `projects/&#42;&#47;zones/&#42;&#47;clusters/&#42;`
   * </pre>
   *
   * <code>
   * string cluster = 7 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The cluster.
   */
  @java.lang.Override
  public java.lang.String getCluster() {
    java.lang.Object ref = cluster_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      cluster_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Immutable. The target cluster into which Restores created via
   * this RestorePlan will restore data. NOTE: the cluster's region must be the
   * same as the RestorePlan. Valid formats:
   *
   *   - `projects/&#42;&#47;locations/&#42;&#47;clusters/&#42;`
   *   - `projects/&#42;&#47;zones/&#42;&#47;clusters/&#42;`
   * </pre>
   *
   * <code>
   * string cluster = 7 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for cluster.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getClusterBytes() {
    java.lang.Object ref = cluster_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      cluster_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RESTORE_CONFIG_FIELD_NUMBER = 8;
  private com.google.cloud.gkebackup.v1.RestoreConfig restoreConfig_;
  /**
   *
   *
   * <pre>
   * Required. Configuration of Restores created via this RestorePlan.
   * </pre>
   *
   * <code>
   * .google.cloud.gkebackup.v1.RestoreConfig restore_config = 8 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the restoreConfig field is set.
   */
  @java.lang.Override
  public boolean hasRestoreConfig() {
    return restoreConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. Configuration of Restores created via this RestorePlan.
   * </pre>
   *
   * <code>
   * .google.cloud.gkebackup.v1.RestoreConfig restore_config = 8 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The restoreConfig.
   */
  @java.lang.Override
  public com.google.cloud.gkebackup.v1.RestoreConfig getRestoreConfig() {
    return restoreConfig_ == null
        ? com.google.cloud.gkebackup.v1.RestoreConfig.getDefaultInstance()
        : restoreConfig_;
  }
  /**
   *
   *
   * <pre>
   * Required. Configuration of Restores created via this RestorePlan.
   * </pre>
   *
   * <code>
   * .google.cloud.gkebackup.v1.RestoreConfig restore_config = 8 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.gkebackup.v1.RestoreConfigOrBuilder getRestoreConfigOrBuilder() {
    return restoreConfig_ == null
        ? com.google.cloud.gkebackup.v1.RestoreConfig.getDefaultInstance()
        : restoreConfig_;
  }

  public static final int LABELS_FIELD_NUMBER = 9;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.gkebackup.v1.RestorePlanProto
                .internal_static_google_cloud_gkebackup_v1_RestorePlan_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * A set of custom labels supplied by user.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 9;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * A set of custom labels supplied by user.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 9;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * A set of custom labels supplied by user.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 9;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * A set of custom labels supplied by user.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 9;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int ETAG_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private volatile java.lang.Object etag_ = "";
  /**
   *
   *
   * <pre>
   * Output only. `etag` is used for optimistic concurrency control as a way to
   * help prevent simultaneous updates of a restore from overwriting each other.
   * It is strongly suggested that systems make use of the `etag` in the
   * read-modify-write cycle to perform restore updates in order to avoid
   * race conditions: An `etag` is returned in the response to `GetRestorePlan`,
   * and systems are expected to put that etag in the request to
   * `UpdateRestorePlan` or `DeleteRestorePlan` to ensure that their change
   * will be applied to the same version of the resource.
   * </pre>
   *
   * <code>string etag = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The etag.
   */
  @java.lang.Override
  public java.lang.String getEtag() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      etag_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. `etag` is used for optimistic concurrency control as a way to
   * help prevent simultaneous updates of a restore from overwriting each other.
   * It is strongly suggested that systems make use of the `etag` in the
   * read-modify-write cycle to perform restore updates in order to avoid
   * race conditions: An `etag` is returned in the response to `GetRestorePlan`,
   * and systems are expected to put that etag in the request to
   * `UpdateRestorePlan` or `DeleteRestorePlan` to ensure that their change
   * will be applied to the same version of the resource.
   * </pre>
   *
   * <code>string etag = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for etag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEtagBytes() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      etag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATE_FIELD_NUMBER = 11;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. State of the RestorePlan. This State field reflects the
   * various stages a RestorePlan can be in
   * during the Create operation.
   * </pre>
   *
   * <code>
   * .google.cloud.gkebackup.v1.RestorePlan.State state = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. State of the RestorePlan. This State field reflects the
   * various stages a RestorePlan can be in
   * during the Create operation.
   * </pre>
   *
   * <code>
   * .google.cloud.gkebackup.v1.RestorePlan.State state = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.gkebackup.v1.RestorePlan.State getState() {
    com.google.cloud.gkebackup.v1.RestorePlan.State result =
        com.google.cloud.gkebackup.v1.RestorePlan.State.forNumber(state_);
    return result == null ? com.google.cloud.gkebackup.v1.RestorePlan.State.UNRECOGNIZED : result;
  }

  public static final int STATE_REASON_FIELD_NUMBER = 12;

  @SuppressWarnings("serial")
  private volatile java.lang.Object stateReason_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Human-readable description of why RestorePlan is in the
   * current `state`
   * </pre>
   *
   * <code>string state_reason = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The stateReason.
   */
  @java.lang.Override
  public java.lang.String getStateReason() {
    java.lang.Object ref = stateReason_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      stateReason_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Human-readable description of why RestorePlan is in the
   * current `state`
   * </pre>
   *
   * <code>string state_reason = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for stateReason.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStateReasonBytes() {
    java.lang.Object ref = stateReason_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      stateReason_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uid_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, uid_);
    }
    if (createTime_ != null) {
      output.writeMessage(3, getCreateTime());
    }
    if (updateTime_ != null) {
      output.writeMessage(4, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, description_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(backupPlan_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, backupPlan_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cluster_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, cluster_);
    }
    if (restoreConfig_ != null) {
      output.writeMessage(8, getRestoreConfig());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 9);
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, etag_);
    }
    if (state_ != com.google.cloud.gkebackup.v1.RestorePlan.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(11, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(stateReason_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 12, stateReason_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uid_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, uid_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getCreateTime());
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, description_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(backupPlan_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, backupPlan_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cluster_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, cluster_);
    }
    if (restoreConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getRestoreConfig());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, labels__);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, etag_);
    }
    if (state_ != com.google.cloud.gkebackup.v1.RestorePlan.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(11, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(stateReason_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(12, stateReason_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.gkebackup.v1.RestorePlan)) {
      return super.equals(obj);
    }
    com.google.cloud.gkebackup.v1.RestorePlan other =
        (com.google.cloud.gkebackup.v1.RestorePlan) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getUid().equals(other.getUid())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!getDescription().equals(other.getDescription())) return false;
    if (!getBackupPlan().equals(other.getBackupPlan())) return false;
    if (!getCluster().equals(other.getCluster())) return false;
    if (hasRestoreConfig() != other.hasRestoreConfig()) return false;
    if (hasRestoreConfig()) {
      if (!getRestoreConfig().equals(other.getRestoreConfig())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!getEtag().equals(other.getEtag())) return false;
    if (state_ != other.state_) return false;
    if (!getStateReason().equals(other.getStateReason())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + UID_FIELD_NUMBER;
    hash = (53 * hash) + getUid().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + BACKUP_PLAN_FIELD_NUMBER;
    hash = (53 * hash) + getBackupPlan().hashCode();
    hash = (37 * hash) + CLUSTER_FIELD_NUMBER;
    hash = (53 * hash) + getCluster().hashCode();
    if (hasRestoreConfig()) {
      hash = (37 * hash) + RESTORE_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getRestoreConfig().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    hash = (37 * hash) + ETAG_FIELD_NUMBER;
    hash = (53 * hash) + getEtag().hashCode();
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (37 * hash) + STATE_REASON_FIELD_NUMBER;
    hash = (53 * hash) + getStateReason().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.gkebackup.v1.RestorePlan parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gkebackup.v1.RestorePlan parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gkebackup.v1.RestorePlan parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gkebackup.v1.RestorePlan parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gkebackup.v1.RestorePlan parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gkebackup.v1.RestorePlan parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gkebackup.v1.RestorePlan parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.gkebackup.v1.RestorePlan parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.gkebackup.v1.RestorePlan parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.gkebackup.v1.RestorePlan parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.gkebackup.v1.RestorePlan parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.gkebackup.v1.RestorePlan parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.gkebackup.v1.RestorePlan prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The configuration of a potential series of Restore operations to be performed
   * against Backups belong to a particular BackupPlan.
   * Next id: 13
   * </pre>
   *
   * Protobuf type {@code google.cloud.gkebackup.v1.RestorePlan}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.gkebackup.v1.RestorePlan)
      com.google.cloud.gkebackup.v1.RestorePlanOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.gkebackup.v1.RestorePlanProto
          .internal_static_google_cloud_gkebackup_v1_RestorePlan_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 9:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 9:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.gkebackup.v1.RestorePlanProto
          .internal_static_google_cloud_gkebackup_v1_RestorePlan_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.gkebackup.v1.RestorePlan.class,
              com.google.cloud.gkebackup.v1.RestorePlan.Builder.class);
    }

    // Construct using com.google.cloud.gkebackup.v1.RestorePlan.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      uid_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      description_ = "";
      backupPlan_ = "";
      cluster_ = "";
      restoreConfig_ = null;
      if (restoreConfigBuilder_ != null) {
        restoreConfigBuilder_.dispose();
        restoreConfigBuilder_ = null;
      }
      internalGetMutableLabels().clear();
      etag_ = "";
      state_ = 0;
      stateReason_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.gkebackup.v1.RestorePlanProto
          .internal_static_google_cloud_gkebackup_v1_RestorePlan_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.gkebackup.v1.RestorePlan getDefaultInstanceForType() {
      return com.google.cloud.gkebackup.v1.RestorePlan.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.gkebackup.v1.RestorePlan build() {
      com.google.cloud.gkebackup.v1.RestorePlan result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.gkebackup.v1.RestorePlan buildPartial() {
      com.google.cloud.gkebackup.v1.RestorePlan result =
          new com.google.cloud.gkebackup.v1.RestorePlan(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.gkebackup.v1.RestorePlan result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.uid_ = uid_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.backupPlan_ = backupPlan_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.cluster_ = cluster_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.restoreConfig_ =
            restoreConfigBuilder_ == null ? restoreConfig_ : restoreConfigBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.etag_ = etag_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.stateReason_ = stateReason_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.gkebackup.v1.RestorePlan) {
        return mergeFrom((com.google.cloud.gkebackup.v1.RestorePlan) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.gkebackup.v1.RestorePlan other) {
      if (other == com.google.cloud.gkebackup.v1.RestorePlan.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getUid().isEmpty()) {
        uid_ = other.uid_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.getBackupPlan().isEmpty()) {
        backupPlan_ = other.backupPlan_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (!other.getCluster().isEmpty()) {
        cluster_ = other.cluster_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (other.hasRestoreConfig()) {
        mergeRestoreConfig(other.getRestoreConfig());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000100;
      if (!other.getEtag().isEmpty()) {
        etag_ = other.etag_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (!other.getStateReason().isEmpty()) {
        stateReason_ = other.stateReason_;
        bitField0_ |= 0x00000800;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                uid_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                backupPlan_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                cluster_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getRestoreConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            case 74:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000100;
                break;
              } // case 74
            case 82:
              {
                etag_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 82
            case 88:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000400;
                break;
              } // case 88
            case 98:
              {
                stateReason_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000800;
                break;
              } // case 98
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The full name of the RestorePlan resource.
     * Format: `projects/&#42;&#47;locations/&#42;&#47;restorePlans/&#42;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The full name of the RestorePlan resource.
     * Format: `projects/&#42;&#47;locations/&#42;&#47;restorePlans/&#42;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The full name of the RestorePlan resource.
     * Format: `projects/&#42;&#47;locations/&#42;&#47;restorePlans/&#42;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The full name of the RestorePlan resource.
     * Format: `projects/&#42;&#47;locations/&#42;&#47;restorePlans/&#42;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The full name of the RestorePlan resource.
     * Format: `projects/&#42;&#47;locations/&#42;&#47;restorePlans/&#42;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object uid_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Server generated global unique identifier of
     * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier) format.
     * </pre>
     *
     * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The uid.
     */
    public java.lang.String getUid() {
      java.lang.Object ref = uid_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uid_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Server generated global unique identifier of
     * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier) format.
     * </pre>
     *
     * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for uid.
     */
    public com.google.protobuf.ByteString getUidBytes() {
      java.lang.Object ref = uid_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        uid_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Server generated global unique identifier of
     * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier) format.
     * </pre>
     *
     * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The uid to set.
     * @return This builder for chaining.
     */
    public Builder setUid(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      uid_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Server generated global unique identifier of
     * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier) format.
     * </pre>
     *
     * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUid() {
      uid_ = getDefaultInstance().getUid();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Server generated global unique identifier of
     * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier) format.
     * </pre>
     *
     * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for uid to set.
     * @return This builder for chaining.
     */
    public Builder setUidBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      uid_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this RestorePlan resource was
     * created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this RestorePlan resource was
     * created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this RestorePlan resource was
     * created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this RestorePlan resource was
     * created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this RestorePlan resource was
     * created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this RestorePlan resource was
     * created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this RestorePlan resource was
     * created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this RestorePlan resource was
     * created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this RestorePlan resource was
     * created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this RestorePlan resource was last
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this RestorePlan resource was last
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this RestorePlan resource was last
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this RestorePlan resource was last
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this RestorePlan resource was last
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this RestorePlan resource was last
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this RestorePlan resource was last
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this RestorePlan resource was last
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this RestorePlan resource was last
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * User specified descriptive string for this RestorePlan.
     * </pre>
     *
     * <code>string description = 5;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * User specified descriptive string for this RestorePlan.
     * </pre>
     *
     * <code>string description = 5;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * User specified descriptive string for this RestorePlan.
     * </pre>
     *
     * <code>string description = 5;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User specified descriptive string for this RestorePlan.
     * </pre>
     *
     * <code>string description = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User specified descriptive string for this RestorePlan.
     * </pre>
     *
     * <code>string description = 5;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object backupPlan_ = "";
    /**
     *
     *
     * <pre>
     * Required. Immutable. A reference to the
     * [BackupPlan][google.cloud.gkebackup.v1.BackupPlan] from which Backups may
     * be used as the source for Restores created via this RestorePlan. Format:
     * `projects/&#42;&#47;locations/&#42;&#47;backupPlans/&#42;`.
     * </pre>
     *
     * <code>
     * string backup_plan = 6 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The backupPlan.
     */
    public java.lang.String getBackupPlan() {
      java.lang.Object ref = backupPlan_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        backupPlan_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. A reference to the
     * [BackupPlan][google.cloud.gkebackup.v1.BackupPlan] from which Backups may
     * be used as the source for Restores created via this RestorePlan. Format:
     * `projects/&#42;&#47;locations/&#42;&#47;backupPlans/&#42;`.
     * </pre>
     *
     * <code>
     * string backup_plan = 6 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for backupPlan.
     */
    public com.google.protobuf.ByteString getBackupPlanBytes() {
      java.lang.Object ref = backupPlan_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        backupPlan_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. A reference to the
     * [BackupPlan][google.cloud.gkebackup.v1.BackupPlan] from which Backups may
     * be used as the source for Restores created via this RestorePlan. Format:
     * `projects/&#42;&#47;locations/&#42;&#47;backupPlans/&#42;`.
     * </pre>
     *
     * <code>
     * string backup_plan = 6 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The backupPlan to set.
     * @return This builder for chaining.
     */
    public Builder setBackupPlan(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      backupPlan_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. A reference to the
     * [BackupPlan][google.cloud.gkebackup.v1.BackupPlan] from which Backups may
     * be used as the source for Restores created via this RestorePlan. Format:
     * `projects/&#42;&#47;locations/&#42;&#47;backupPlans/&#42;`.
     * </pre>
     *
     * <code>
     * string backup_plan = 6 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBackupPlan() {
      backupPlan_ = getDefaultInstance().getBackupPlan();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. A reference to the
     * [BackupPlan][google.cloud.gkebackup.v1.BackupPlan] from which Backups may
     * be used as the source for Restores created via this RestorePlan. Format:
     * `projects/&#42;&#47;locations/&#42;&#47;backupPlans/&#42;`.
     * </pre>
     *
     * <code>
     * string backup_plan = 6 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for backupPlan to set.
     * @return This builder for chaining.
     */
    public Builder setBackupPlanBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      backupPlan_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object cluster_ = "";
    /**
     *
     *
     * <pre>
     * Required. Immutable. The target cluster into which Restores created via
     * this RestorePlan will restore data. NOTE: the cluster's region must be the
     * same as the RestorePlan. Valid formats:
     *
     *   - `projects/&#42;&#47;locations/&#42;&#47;clusters/&#42;`
     *   - `projects/&#42;&#47;zones/&#42;&#47;clusters/&#42;`
     * </pre>
     *
     * <code>
     * string cluster = 7 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The cluster.
     */
    public java.lang.String getCluster() {
      java.lang.Object ref = cluster_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        cluster_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The target cluster into which Restores created via
     * this RestorePlan will restore data. NOTE: the cluster's region must be the
     * same as the RestorePlan. Valid formats:
     *
     *   - `projects/&#42;&#47;locations/&#42;&#47;clusters/&#42;`
     *   - `projects/&#42;&#47;zones/&#42;&#47;clusters/&#42;`
     * </pre>
     *
     * <code>
     * string cluster = 7 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for cluster.
     */
    public com.google.protobuf.ByteString getClusterBytes() {
      java.lang.Object ref = cluster_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        cluster_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The target cluster into which Restores created via
     * this RestorePlan will restore data. NOTE: the cluster's region must be the
     * same as the RestorePlan. Valid formats:
     *
     *   - `projects/&#42;&#47;locations/&#42;&#47;clusters/&#42;`
     *   - `projects/&#42;&#47;zones/&#42;&#47;clusters/&#42;`
     * </pre>
     *
     * <code>
     * string cluster = 7 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The cluster to set.
     * @return This builder for chaining.
     */
    public Builder setCluster(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      cluster_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The target cluster into which Restores created via
     * this RestorePlan will restore data. NOTE: the cluster's region must be the
     * same as the RestorePlan. Valid formats:
     *
     *   - `projects/&#42;&#47;locations/&#42;&#47;clusters/&#42;`
     *   - `projects/&#42;&#47;zones/&#42;&#47;clusters/&#42;`
     * </pre>
     *
     * <code>
     * string cluster = 7 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCluster() {
      cluster_ = getDefaultInstance().getCluster();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The target cluster into which Restores created via
     * this RestorePlan will restore data. NOTE: the cluster's region must be the
     * same as the RestorePlan. Valid formats:
     *
     *   - `projects/&#42;&#47;locations/&#42;&#47;clusters/&#42;`
     *   - `projects/&#42;&#47;zones/&#42;&#47;clusters/&#42;`
     * </pre>
     *
     * <code>
     * string cluster = 7 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for cluster to set.
     * @return This builder for chaining.
     */
    public Builder setClusterBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      cluster_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private com.google.cloud.gkebackup.v1.RestoreConfig restoreConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gkebackup.v1.RestoreConfig,
            com.google.cloud.gkebackup.v1.RestoreConfig.Builder,
            com.google.cloud.gkebackup.v1.RestoreConfigOrBuilder>
        restoreConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Required. Configuration of Restores created via this RestorePlan.
     * </pre>
     *
     * <code>
     * .google.cloud.gkebackup.v1.RestoreConfig restore_config = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the restoreConfig field is set.
     */
    public boolean hasRestoreConfig() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. Configuration of Restores created via this RestorePlan.
     * </pre>
     *
     * <code>
     * .google.cloud.gkebackup.v1.RestoreConfig restore_config = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The restoreConfig.
     */
    public com.google.cloud.gkebackup.v1.RestoreConfig getRestoreConfig() {
      if (restoreConfigBuilder_ == null) {
        return restoreConfig_ == null
            ? com.google.cloud.gkebackup.v1.RestoreConfig.getDefaultInstance()
            : restoreConfig_;
      } else {
        return restoreConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Configuration of Restores created via this RestorePlan.
     * </pre>
     *
     * <code>
     * .google.cloud.gkebackup.v1.RestoreConfig restore_config = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setRestoreConfig(com.google.cloud.gkebackup.v1.RestoreConfig value) {
      if (restoreConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        restoreConfig_ = value;
      } else {
        restoreConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Configuration of Restores created via this RestorePlan.
     * </pre>
     *
     * <code>
     * .google.cloud.gkebackup.v1.RestoreConfig restore_config = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setRestoreConfig(
        com.google.cloud.gkebackup.v1.RestoreConfig.Builder builderForValue) {
      if (restoreConfigBuilder_ == null) {
        restoreConfig_ = builderForValue.build();
      } else {
        restoreConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Configuration of Restores created via this RestorePlan.
     * </pre>
     *
     * <code>
     * .google.cloud.gkebackup.v1.RestoreConfig restore_config = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeRestoreConfig(com.google.cloud.gkebackup.v1.RestoreConfig value) {
      if (restoreConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && restoreConfig_ != null
            && restoreConfig_ != com.google.cloud.gkebackup.v1.RestoreConfig.getDefaultInstance()) {
          getRestoreConfigBuilder().mergeFrom(value);
        } else {
          restoreConfig_ = value;
        }
      } else {
        restoreConfigBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Configuration of Restores created via this RestorePlan.
     * </pre>
     *
     * <code>
     * .google.cloud.gkebackup.v1.RestoreConfig restore_config = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearRestoreConfig() {
      bitField0_ = (bitField0_ & ~0x00000080);
      restoreConfig_ = null;
      if (restoreConfigBuilder_ != null) {
        restoreConfigBuilder_.dispose();
        restoreConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Configuration of Restores created via this RestorePlan.
     * </pre>
     *
     * <code>
     * .google.cloud.gkebackup.v1.RestoreConfig restore_config = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.gkebackup.v1.RestoreConfig.Builder getRestoreConfigBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getRestoreConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. Configuration of Restores created via this RestorePlan.
     * </pre>
     *
     * <code>
     * .google.cloud.gkebackup.v1.RestoreConfig restore_config = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.gkebackup.v1.RestoreConfigOrBuilder getRestoreConfigOrBuilder() {
      if (restoreConfigBuilder_ != null) {
        return restoreConfigBuilder_.getMessageOrBuilder();
      } else {
        return restoreConfig_ == null
            ? com.google.cloud.gkebackup.v1.RestoreConfig.getDefaultInstance()
            : restoreConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Configuration of Restores created via this RestorePlan.
     * </pre>
     *
     * <code>
     * .google.cloud.gkebackup.v1.RestoreConfig restore_config = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gkebackup.v1.RestoreConfig,
            com.google.cloud.gkebackup.v1.RestoreConfig.Builder,
            com.google.cloud.gkebackup.v1.RestoreConfigOrBuilder>
        getRestoreConfigFieldBuilder() {
      if (restoreConfigBuilder_ == null) {
        restoreConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.gkebackup.v1.RestoreConfig,
                com.google.cloud.gkebackup.v1.RestoreConfig.Builder,
                com.google.cloud.gkebackup.v1.RestoreConfigOrBuilder>(
                getRestoreConfig(), getParentForChildren(), isClean());
        restoreConfig_ = null;
      }
      return restoreConfigBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * A set of custom labels supplied by user.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 9;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * A set of custom labels supplied by user.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 9;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * A set of custom labels supplied by user.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 9;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * A set of custom labels supplied by user.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 9;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000100);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A set of custom labels supplied by user.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 9;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000100;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * A set of custom labels supplied by user.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 9;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000100;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A set of custom labels supplied by user.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 9;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000100;
      return this;
    }

    private java.lang.Object etag_ = "";
    /**
     *
     *
     * <pre>
     * Output only. `etag` is used for optimistic concurrency control as a way to
     * help prevent simultaneous updates of a restore from overwriting each other.
     * It is strongly suggested that systems make use of the `etag` in the
     * read-modify-write cycle to perform restore updates in order to avoid
     * race conditions: An `etag` is returned in the response to `GetRestorePlan`,
     * and systems are expected to put that etag in the request to
     * `UpdateRestorePlan` or `DeleteRestorePlan` to ensure that their change
     * will be applied to the same version of the resource.
     * </pre>
     *
     * <code>string etag = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The etag.
     */
    public java.lang.String getEtag() {
      java.lang.Object ref = etag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        etag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. `etag` is used for optimistic concurrency control as a way to
     * help prevent simultaneous updates of a restore from overwriting each other.
     * It is strongly suggested that systems make use of the `etag` in the
     * read-modify-write cycle to perform restore updates in order to avoid
     * race conditions: An `etag` is returned in the response to `GetRestorePlan`,
     * and systems are expected to put that etag in the request to
     * `UpdateRestorePlan` or `DeleteRestorePlan` to ensure that their change
     * will be applied to the same version of the resource.
     * </pre>
     *
     * <code>string etag = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for etag.
     */
    public com.google.protobuf.ByteString getEtagBytes() {
      java.lang.Object ref = etag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        etag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. `etag` is used for optimistic concurrency control as a way to
     * help prevent simultaneous updates of a restore from overwriting each other.
     * It is strongly suggested that systems make use of the `etag` in the
     * read-modify-write cycle to perform restore updates in order to avoid
     * race conditions: An `etag` is returned in the response to `GetRestorePlan`,
     * and systems are expected to put that etag in the request to
     * `UpdateRestorePlan` or `DeleteRestorePlan` to ensure that their change
     * will be applied to the same version of the resource.
     * </pre>
     *
     * <code>string etag = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      etag_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. `etag` is used for optimistic concurrency control as a way to
     * help prevent simultaneous updates of a restore from overwriting each other.
     * It is strongly suggested that systems make use of the `etag` in the
     * read-modify-write cycle to perform restore updates in order to avoid
     * race conditions: An `etag` is returned in the response to `GetRestorePlan`,
     * and systems are expected to put that etag in the request to
     * `UpdateRestorePlan` or `DeleteRestorePlan` to ensure that their change
     * will be applied to the same version of the resource.
     * </pre>
     *
     * <code>string etag = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEtag() {
      etag_ = getDefaultInstance().getEtag();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. `etag` is used for optimistic concurrency control as a way to
     * help prevent simultaneous updates of a restore from overwriting each other.
     * It is strongly suggested that systems make use of the `etag` in the
     * read-modify-write cycle to perform restore updates in order to avoid
     * race conditions: An `etag` is returned in the response to `GetRestorePlan`,
     * and systems are expected to put that etag in the request to
     * `UpdateRestorePlan` or `DeleteRestorePlan` to ensure that their change
     * will be applied to the same version of the resource.
     * </pre>
     *
     * <code>string etag = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      etag_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. State of the RestorePlan. This State field reflects the
     * various stages a RestorePlan can be in
     * during the Create operation.
     * </pre>
     *
     * <code>
     * .google.cloud.gkebackup.v1.RestorePlan.State state = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the RestorePlan. This State field reflects the
     * various stages a RestorePlan can be in
     * during the Create operation.
     * </pre>
     *
     * <code>
     * .google.cloud.gkebackup.v1.RestorePlan.State state = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the RestorePlan. This State field reflects the
     * various stages a RestorePlan can be in
     * during the Create operation.
     * </pre>
     *
     * <code>
     * .google.cloud.gkebackup.v1.RestorePlan.State state = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.gkebackup.v1.RestorePlan.State getState() {
      com.google.cloud.gkebackup.v1.RestorePlan.State result =
          com.google.cloud.gkebackup.v1.RestorePlan.State.forNumber(state_);
      return result == null ? com.google.cloud.gkebackup.v1.RestorePlan.State.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the RestorePlan. This State field reflects the
     * various stages a RestorePlan can be in
     * during the Create operation.
     * </pre>
     *
     * <code>
     * .google.cloud.gkebackup.v1.RestorePlan.State state = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.gkebackup.v1.RestorePlan.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000400;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the RestorePlan. This State field reflects the
     * various stages a RestorePlan can be in
     * during the Create operation.
     * </pre>
     *
     * <code>
     * .google.cloud.gkebackup.v1.RestorePlan.State state = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000400);
      state_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object stateReason_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Human-readable description of why RestorePlan is in the
     * current `state`
     * </pre>
     *
     * <code>string state_reason = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The stateReason.
     */
    public java.lang.String getStateReason() {
      java.lang.Object ref = stateReason_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        stateReason_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Human-readable description of why RestorePlan is in the
     * current `state`
     * </pre>
     *
     * <code>string state_reason = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for stateReason.
     */
    public com.google.protobuf.ByteString getStateReasonBytes() {
      java.lang.Object ref = stateReason_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        stateReason_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Human-readable description of why RestorePlan is in the
     * current `state`
     * </pre>
     *
     * <code>string state_reason = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The stateReason to set.
     * @return This builder for chaining.
     */
    public Builder setStateReason(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      stateReason_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Human-readable description of why RestorePlan is in the
     * current `state`
     * </pre>
     *
     * <code>string state_reason = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStateReason() {
      stateReason_ = getDefaultInstance().getStateReason();
      bitField0_ = (bitField0_ & ~0x00000800);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Human-readable description of why RestorePlan is in the
     * current `state`
     * </pre>
     *
     * <code>string state_reason = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for stateReason to set.
     * @return This builder for chaining.
     */
    public Builder setStateReasonBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      stateReason_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.gkebackup.v1.RestorePlan)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.gkebackup.v1.RestorePlan)
  private static final com.google.cloud.gkebackup.v1.RestorePlan DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.gkebackup.v1.RestorePlan();
  }

  public static com.google.cloud.gkebackup.v1.RestorePlan getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RestorePlan> PARSER =
      new com.google.protobuf.AbstractParser<RestorePlan>() {
        @java.lang.Override
        public RestorePlan parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RestorePlan> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RestorePlan> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.gkebackup.v1.RestorePlan getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
