/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/gkebackup/v1/volume.proto

package com.google.cloud.gkebackup.v1;

/**
 *
 *
 * <pre>
 * Represents the backup of a specific persistent volume as a component of a
 * Backup - both the record of the operation and a pointer to the underlying
 * storage-specific artifacts.
 * Next id: 14
 * </pre>
 *
 * Protobuf type {@code google.cloud.gkebackup.v1.VolumeBackup}
 */
public final class VolumeBackup extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.gkebackup.v1.VolumeBackup)
    VolumeBackupOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use VolumeBackup.newBuilder() to construct.
  private VolumeBackup(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private VolumeBackup() {
    name_ = "";
    uid_ = "";
    volumeBackupHandle_ = "";
    format_ = 0;
    state_ = 0;
    stateMessage_ = "";
    etag_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new VolumeBackup();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.gkebackup.v1.VolumeProto
        .internal_static_google_cloud_gkebackup_v1_VolumeBackup_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.gkebackup.v1.VolumeProto
        .internal_static_google_cloud_gkebackup_v1_VolumeBackup_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.gkebackup.v1.VolumeBackup.class,
            com.google.cloud.gkebackup.v1.VolumeBackup.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Identifies the format used for the volume backup.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.gkebackup.v1.VolumeBackup.VolumeBackupFormat}
   */
  public enum VolumeBackupFormat implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default value, not specified.
     * </pre>
     *
     * <code>VOLUME_BACKUP_FORMAT_UNSPECIFIED = 0;</code>
     */
    VOLUME_BACKUP_FORMAT_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Compute Engine Persistent Disk snapshot based volume backup.
     * </pre>
     *
     * <code>GCE_PERSISTENT_DISK = 1;</code>
     */
    GCE_PERSISTENT_DISK(1),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default value, not specified.
     * </pre>
     *
     * <code>VOLUME_BACKUP_FORMAT_UNSPECIFIED = 0;</code>
     */
    public static final int VOLUME_BACKUP_FORMAT_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Compute Engine Persistent Disk snapshot based volume backup.
     * </pre>
     *
     * <code>GCE_PERSISTENT_DISK = 1;</code>
     */
    public static final int GCE_PERSISTENT_DISK_VALUE = 1;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static VolumeBackupFormat valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static VolumeBackupFormat forNumber(int value) {
      switch (value) {
        case 0:
          return VOLUME_BACKUP_FORMAT_UNSPECIFIED;
        case 1:
          return GCE_PERSISTENT_DISK;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<VolumeBackupFormat>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<VolumeBackupFormat>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<VolumeBackupFormat>() {
              public VolumeBackupFormat findValueByNumber(int number) {
                return VolumeBackupFormat.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.gkebackup.v1.VolumeBackup.getDescriptor().getEnumTypes().get(0);
    }

    private static final VolumeBackupFormat[] VALUES = values();

    public static VolumeBackupFormat valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private VolumeBackupFormat(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.gkebackup.v1.VolumeBackup.VolumeBackupFormat)
  }

  /**
   *
   *
   * <pre>
   * The current state of a VolumeBackup
   * </pre>
   *
   * Protobuf enum {@code google.cloud.gkebackup.v1.VolumeBackup.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * This is an illegal state and should not be encountered.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * A volume for the backup was identified and backup process is about to
     * start.
     * </pre>
     *
     * <code>CREATING = 1;</code>
     */
    CREATING(1),
    /**
     *
     *
     * <pre>
     * The volume backup operation has begun and is in the initial "snapshot"
     * phase of the process. Any defined ProtectedApplication "pre" hooks will
     * be executed before entering this state and "post" hooks will be executed
     * upon leaving this state.
     * </pre>
     *
     * <code>SNAPSHOTTING = 2;</code>
     */
    SNAPSHOTTING(2),
    /**
     *
     *
     * <pre>
     * The snapshot phase of the volume backup operation has completed and
     * the snapshot is now being uploaded to backup storage.
     * </pre>
     *
     * <code>UPLOADING = 3;</code>
     */
    UPLOADING(3),
    /**
     *
     *
     * <pre>
     * The volume backup operation has completed successfully.
     * </pre>
     *
     * <code>SUCCEEDED = 4;</code>
     */
    SUCCEEDED(4),
    /**
     *
     *
     * <pre>
     * The volume backup operation has failed.
     * </pre>
     *
     * <code>FAILED = 5;</code>
     */
    FAILED(5),
    /**
     *
     *
     * <pre>
     * This VolumeBackup resource (and its associated artifacts) is in the
     * process of being deleted.
     * </pre>
     *
     * <code>DELETING = 6;</code>
     */
    DELETING(6),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * This is an illegal state and should not be encountered.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * A volume for the backup was identified and backup process is about to
     * start.
     * </pre>
     *
     * <code>CREATING = 1;</code>
     */
    public static final int CREATING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The volume backup operation has begun and is in the initial "snapshot"
     * phase of the process. Any defined ProtectedApplication "pre" hooks will
     * be executed before entering this state and "post" hooks will be executed
     * upon leaving this state.
     * </pre>
     *
     * <code>SNAPSHOTTING = 2;</code>
     */
    public static final int SNAPSHOTTING_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The snapshot phase of the volume backup operation has completed and
     * the snapshot is now being uploaded to backup storage.
     * </pre>
     *
     * <code>UPLOADING = 3;</code>
     */
    public static final int UPLOADING_VALUE = 3;
    /**
     *
     *
     * <pre>
     * The volume backup operation has completed successfully.
     * </pre>
     *
     * <code>SUCCEEDED = 4;</code>
     */
    public static final int SUCCEEDED_VALUE = 4;
    /**
     *
     *
     * <pre>
     * The volume backup operation has failed.
     * </pre>
     *
     * <code>FAILED = 5;</code>
     */
    public static final int FAILED_VALUE = 5;
    /**
     *
     *
     * <pre>
     * This VolumeBackup resource (and its associated artifacts) is in the
     * process of being deleted.
     * </pre>
     *
     * <code>DELETING = 6;</code>
     */
    public static final int DELETING_VALUE = 6;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return CREATING;
        case 2:
          return SNAPSHOTTING;
        case 3:
          return UPLOADING;
        case 4:
          return SUCCEEDED;
        case 5:
          return FAILED;
        case 6:
          return DELETING;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.gkebackup.v1.VolumeBackup.getDescriptor().getEnumTypes().get(1);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.gkebackup.v1.VolumeBackup.State)
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The full name of the VolumeBackup resource.
   * Format: `projects/&#42;&#47;locations/&#42;&#47;backupPlans/&#42;&#47;backups/&#42;&#47;volumeBackups/&#42;`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The full name of the VolumeBackup resource.
   * Format: `projects/&#42;&#47;locations/&#42;&#47;backupPlans/&#42;&#47;backups/&#42;&#47;volumeBackups/&#42;`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int UID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object uid_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Server generated global unique identifier of
   * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier) format.
   * </pre>
   *
   * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The uid.
   */
  @java.lang.Override
  public java.lang.String getUid() {
    java.lang.Object ref = uid_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      uid_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Server generated global unique identifier of
   * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier) format.
   * </pre>
   *
   * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for uid.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUidBytes() {
    java.lang.Object ref = uid_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      uid_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when this VolumeBackup resource was
   * created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when this VolumeBackup resource was
   * created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when this VolumeBackup resource was
   * created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when this VolumeBackup resource was last
   * updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when this VolumeBackup resource was last
   * updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when this VolumeBackup resource was last
   * updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int SOURCE_PVC_FIELD_NUMBER = 5;
  private com.google.cloud.gkebackup.v1.NamespacedName sourcePvc_;
  /**
   *
   *
   * <pre>
   * Output only. A reference to the source Kubernetes PVC from which this
   * VolumeBackup was created.
   * </pre>
   *
   * <code>
   * .google.cloud.gkebackup.v1.NamespacedName source_pvc = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the sourcePvc field is set.
   */
  @java.lang.Override
  public boolean hasSourcePvc() {
    return sourcePvc_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. A reference to the source Kubernetes PVC from which this
   * VolumeBackup was created.
   * </pre>
   *
   * <code>
   * .google.cloud.gkebackup.v1.NamespacedName source_pvc = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The sourcePvc.
   */
  @java.lang.Override
  public com.google.cloud.gkebackup.v1.NamespacedName getSourcePvc() {
    return sourcePvc_ == null
        ? com.google.cloud.gkebackup.v1.NamespacedName.getDefaultInstance()
        : sourcePvc_;
  }
  /**
   *
   *
   * <pre>
   * Output only. A reference to the source Kubernetes PVC from which this
   * VolumeBackup was created.
   * </pre>
   *
   * <code>
   * .google.cloud.gkebackup.v1.NamespacedName source_pvc = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.gkebackup.v1.NamespacedNameOrBuilder getSourcePvcOrBuilder() {
    return sourcePvc_ == null
        ? com.google.cloud.gkebackup.v1.NamespacedName.getDefaultInstance()
        : sourcePvc_;
  }

  public static final int VOLUME_BACKUP_HANDLE_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object volumeBackupHandle_ = "";
  /**
   *
   *
   * <pre>
   * Output only. A storage system-specific opaque handle to the underlying
   * volume backup.
   * </pre>
   *
   * <code>string volume_backup_handle = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The volumeBackupHandle.
   */
  @java.lang.Override
  public java.lang.String getVolumeBackupHandle() {
    java.lang.Object ref = volumeBackupHandle_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      volumeBackupHandle_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. A storage system-specific opaque handle to the underlying
   * volume backup.
   * </pre>
   *
   * <code>string volume_backup_handle = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for volumeBackupHandle.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getVolumeBackupHandleBytes() {
    java.lang.Object ref = volumeBackupHandle_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      volumeBackupHandle_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FORMAT_FIELD_NUMBER = 7;
  private int format_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The format used for the volume backup.
   * </pre>
   *
   * <code>
   * .google.cloud.gkebackup.v1.VolumeBackup.VolumeBackupFormat format = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for format.
   */
  @java.lang.Override
  public int getFormatValue() {
    return format_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The format used for the volume backup.
   * </pre>
   *
   * <code>
   * .google.cloud.gkebackup.v1.VolumeBackup.VolumeBackupFormat format = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The format.
   */
  @java.lang.Override
  public com.google.cloud.gkebackup.v1.VolumeBackup.VolumeBackupFormat getFormat() {
    com.google.cloud.gkebackup.v1.VolumeBackup.VolumeBackupFormat result =
        com.google.cloud.gkebackup.v1.VolumeBackup.VolumeBackupFormat.forNumber(format_);
    return result == null
        ? com.google.cloud.gkebackup.v1.VolumeBackup.VolumeBackupFormat.UNRECOGNIZED
        : result;
  }

  public static final int STORAGE_BYTES_FIELD_NUMBER = 8;
  private long storageBytes_ = 0L;
  /**
   *
   *
   * <pre>
   * Output only. The aggregate size of the underlying artifacts associated with
   * this VolumeBackup in the backup storage. This may change over time when
   * multiple backups of the same volume share the same backup storage
   * location. In particular, this is likely to increase in size when
   * the immediately preceding backup of the same volume is deleted.
   * </pre>
   *
   * <code>int64 storage_bytes = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The storageBytes.
   */
  @java.lang.Override
  public long getStorageBytes() {
    return storageBytes_;
  }

  public static final int DISK_SIZE_BYTES_FIELD_NUMBER = 9;
  private long diskSizeBytes_ = 0L;
  /**
   *
   *
   * <pre>
   * Output only. The minimum size of the disk to which this VolumeBackup can be
   * restored.
   * </pre>
   *
   * <code>int64 disk_size_bytes = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The diskSizeBytes.
   */
  @java.lang.Override
  public long getDiskSizeBytes() {
    return diskSizeBytes_;
  }

  public static final int COMPLETE_TIME_FIELD_NUMBER = 10;
  private com.google.protobuf.Timestamp completeTime_;
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when the associated underlying volume backup
   * operation completed.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp complete_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the completeTime field is set.
   */
  @java.lang.Override
  public boolean hasCompleteTime() {
    return completeTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when the associated underlying volume backup
   * operation completed.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp complete_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The completeTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCompleteTime() {
    return completeTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : completeTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when the associated underlying volume backup
   * operation completed.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp complete_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCompleteTimeOrBuilder() {
    return completeTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : completeTime_;
  }

  public static final int STATE_FIELD_NUMBER = 11;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The current state of this VolumeBackup.
   * </pre>
   *
   * <code>
   * .google.cloud.gkebackup.v1.VolumeBackup.State state = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The current state of this VolumeBackup.
   * </pre>
   *
   * <code>
   * .google.cloud.gkebackup.v1.VolumeBackup.State state = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.gkebackup.v1.VolumeBackup.State getState() {
    com.google.cloud.gkebackup.v1.VolumeBackup.State result =
        com.google.cloud.gkebackup.v1.VolumeBackup.State.forNumber(state_);
    return result == null ? com.google.cloud.gkebackup.v1.VolumeBackup.State.UNRECOGNIZED : result;
  }

  public static final int STATE_MESSAGE_FIELD_NUMBER = 12;

  @SuppressWarnings("serial")
  private volatile java.lang.Object stateMessage_ = "";
  /**
   *
   *
   * <pre>
   * Output only. A human readable message explaining why the VolumeBackup is in
   * its current state.
   * </pre>
   *
   * <code>string state_message = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The stateMessage.
   */
  @java.lang.Override
  public java.lang.String getStateMessage() {
    java.lang.Object ref = stateMessage_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      stateMessage_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. A human readable message explaining why the VolumeBackup is in
   * its current state.
   * </pre>
   *
   * <code>string state_message = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for stateMessage.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStateMessageBytes() {
    java.lang.Object ref = stateMessage_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      stateMessage_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ETAG_FIELD_NUMBER = 13;

  @SuppressWarnings("serial")
  private volatile java.lang.Object etag_ = "";
  /**
   *
   *
   * <pre>
   * Output only. `etag` is used for optimistic concurrency control as a way to
   * help prevent simultaneous updates of a volume backup from overwriting each
   * other. It is strongly suggested that systems make use of the `etag` in the
   * read-modify-write cycle to perform volume backup updates in order to avoid
   * race conditions.
   * </pre>
   *
   * <code>string etag = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The etag.
   */
  @java.lang.Override
  public java.lang.String getEtag() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      etag_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. `etag` is used for optimistic concurrency control as a way to
   * help prevent simultaneous updates of a volume backup from overwriting each
   * other. It is strongly suggested that systems make use of the `etag` in the
   * read-modify-write cycle to perform volume backup updates in order to avoid
   * race conditions.
   * </pre>
   *
   * <code>string etag = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for etag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEtagBytes() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      etag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uid_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, uid_);
    }
    if (createTime_ != null) {
      output.writeMessage(3, getCreateTime());
    }
    if (updateTime_ != null) {
      output.writeMessage(4, getUpdateTime());
    }
    if (sourcePvc_ != null) {
      output.writeMessage(5, getSourcePvc());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(volumeBackupHandle_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, volumeBackupHandle_);
    }
    if (format_
        != com.google.cloud.gkebackup.v1.VolumeBackup.VolumeBackupFormat
            .VOLUME_BACKUP_FORMAT_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(7, format_);
    }
    if (storageBytes_ != 0L) {
      output.writeInt64(8, storageBytes_);
    }
    if (diskSizeBytes_ != 0L) {
      output.writeInt64(9, diskSizeBytes_);
    }
    if (completeTime_ != null) {
      output.writeMessage(10, getCompleteTime());
    }
    if (state_ != com.google.cloud.gkebackup.v1.VolumeBackup.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(11, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(stateMessage_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 12, stateMessage_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 13, etag_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uid_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, uid_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getCreateTime());
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getUpdateTime());
    }
    if (sourcePvc_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getSourcePvc());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(volumeBackupHandle_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, volumeBackupHandle_);
    }
    if (format_
        != com.google.cloud.gkebackup.v1.VolumeBackup.VolumeBackupFormat
            .VOLUME_BACKUP_FORMAT_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(7, format_);
    }
    if (storageBytes_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(8, storageBytes_);
    }
    if (diskSizeBytes_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(9, diskSizeBytes_);
    }
    if (completeTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getCompleteTime());
    }
    if (state_ != com.google.cloud.gkebackup.v1.VolumeBackup.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(11, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(stateMessage_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(12, stateMessage_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(13, etag_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.gkebackup.v1.VolumeBackup)) {
      return super.equals(obj);
    }
    com.google.cloud.gkebackup.v1.VolumeBackup other =
        (com.google.cloud.gkebackup.v1.VolumeBackup) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getUid().equals(other.getUid())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (hasSourcePvc() != other.hasSourcePvc()) return false;
    if (hasSourcePvc()) {
      if (!getSourcePvc().equals(other.getSourcePvc())) return false;
    }
    if (!getVolumeBackupHandle().equals(other.getVolumeBackupHandle())) return false;
    if (format_ != other.format_) return false;
    if (getStorageBytes() != other.getStorageBytes()) return false;
    if (getDiskSizeBytes() != other.getDiskSizeBytes()) return false;
    if (hasCompleteTime() != other.hasCompleteTime()) return false;
    if (hasCompleteTime()) {
      if (!getCompleteTime().equals(other.getCompleteTime())) return false;
    }
    if (state_ != other.state_) return false;
    if (!getStateMessage().equals(other.getStateMessage())) return false;
    if (!getEtag().equals(other.getEtag())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + UID_FIELD_NUMBER;
    hash = (53 * hash) + getUid().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (hasSourcePvc()) {
      hash = (37 * hash) + SOURCE_PVC_FIELD_NUMBER;
      hash = (53 * hash) + getSourcePvc().hashCode();
    }
    hash = (37 * hash) + VOLUME_BACKUP_HANDLE_FIELD_NUMBER;
    hash = (53 * hash) + getVolumeBackupHandle().hashCode();
    hash = (37 * hash) + FORMAT_FIELD_NUMBER;
    hash = (53 * hash) + format_;
    hash = (37 * hash) + STORAGE_BYTES_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getStorageBytes());
    hash = (37 * hash) + DISK_SIZE_BYTES_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getDiskSizeBytes());
    if (hasCompleteTime()) {
      hash = (37 * hash) + COMPLETE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCompleteTime().hashCode();
    }
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (37 * hash) + STATE_MESSAGE_FIELD_NUMBER;
    hash = (53 * hash) + getStateMessage().hashCode();
    hash = (37 * hash) + ETAG_FIELD_NUMBER;
    hash = (53 * hash) + getEtag().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.gkebackup.v1.VolumeBackup parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gkebackup.v1.VolumeBackup parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gkebackup.v1.VolumeBackup parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gkebackup.v1.VolumeBackup parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gkebackup.v1.VolumeBackup parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gkebackup.v1.VolumeBackup parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gkebackup.v1.VolumeBackup parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.gkebackup.v1.VolumeBackup parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.gkebackup.v1.VolumeBackup parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.gkebackup.v1.VolumeBackup parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.gkebackup.v1.VolumeBackup parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.gkebackup.v1.VolumeBackup parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.gkebackup.v1.VolumeBackup prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents the backup of a specific persistent volume as a component of a
   * Backup - both the record of the operation and a pointer to the underlying
   * storage-specific artifacts.
   * Next id: 14
   * </pre>
   *
   * Protobuf type {@code google.cloud.gkebackup.v1.VolumeBackup}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.gkebackup.v1.VolumeBackup)
      com.google.cloud.gkebackup.v1.VolumeBackupOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.gkebackup.v1.VolumeProto
          .internal_static_google_cloud_gkebackup_v1_VolumeBackup_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.gkebackup.v1.VolumeProto
          .internal_static_google_cloud_gkebackup_v1_VolumeBackup_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.gkebackup.v1.VolumeBackup.class,
              com.google.cloud.gkebackup.v1.VolumeBackup.Builder.class);
    }

    // Construct using com.google.cloud.gkebackup.v1.VolumeBackup.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      uid_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      sourcePvc_ = null;
      if (sourcePvcBuilder_ != null) {
        sourcePvcBuilder_.dispose();
        sourcePvcBuilder_ = null;
      }
      volumeBackupHandle_ = "";
      format_ = 0;
      storageBytes_ = 0L;
      diskSizeBytes_ = 0L;
      completeTime_ = null;
      if (completeTimeBuilder_ != null) {
        completeTimeBuilder_.dispose();
        completeTimeBuilder_ = null;
      }
      state_ = 0;
      stateMessage_ = "";
      etag_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.gkebackup.v1.VolumeProto
          .internal_static_google_cloud_gkebackup_v1_VolumeBackup_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.gkebackup.v1.VolumeBackup getDefaultInstanceForType() {
      return com.google.cloud.gkebackup.v1.VolumeBackup.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.gkebackup.v1.VolumeBackup build() {
      com.google.cloud.gkebackup.v1.VolumeBackup result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.gkebackup.v1.VolumeBackup buildPartial() {
      com.google.cloud.gkebackup.v1.VolumeBackup result =
          new com.google.cloud.gkebackup.v1.VolumeBackup(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.gkebackup.v1.VolumeBackup result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.uid_ = uid_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.sourcePvc_ = sourcePvcBuilder_ == null ? sourcePvc_ : sourcePvcBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.volumeBackupHandle_ = volumeBackupHandle_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.format_ = format_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.storageBytes_ = storageBytes_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.diskSizeBytes_ = diskSizeBytes_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.completeTime_ =
            completeTimeBuilder_ == null ? completeTime_ : completeTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.stateMessage_ = stateMessage_;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.etag_ = etag_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.gkebackup.v1.VolumeBackup) {
        return mergeFrom((com.google.cloud.gkebackup.v1.VolumeBackup) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.gkebackup.v1.VolumeBackup other) {
      if (other == com.google.cloud.gkebackup.v1.VolumeBackup.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getUid().isEmpty()) {
        uid_ = other.uid_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (other.hasSourcePvc()) {
        mergeSourcePvc(other.getSourcePvc());
      }
      if (!other.getVolumeBackupHandle().isEmpty()) {
        volumeBackupHandle_ = other.volumeBackupHandle_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.format_ != 0) {
        setFormatValue(other.getFormatValue());
      }
      if (other.getStorageBytes() != 0L) {
        setStorageBytes(other.getStorageBytes());
      }
      if (other.getDiskSizeBytes() != 0L) {
        setDiskSizeBytes(other.getDiskSizeBytes());
      }
      if (other.hasCompleteTime()) {
        mergeCompleteTime(other.getCompleteTime());
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (!other.getStateMessage().isEmpty()) {
        stateMessage_ = other.stateMessage_;
        bitField0_ |= 0x00000800;
        onChanged();
      }
      if (!other.getEtag().isEmpty()) {
        etag_ = other.etag_;
        bitField0_ |= 0x00001000;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                uid_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getSourcePvcFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                volumeBackupHandle_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 56:
              {
                format_ = input.readEnum();
                bitField0_ |= 0x00000040;
                break;
              } // case 56
            case 64:
              {
                storageBytes_ = input.readInt64();
                bitField0_ |= 0x00000080;
                break;
              } // case 64
            case 72:
              {
                diskSizeBytes_ = input.readInt64();
                bitField0_ |= 0x00000100;
                break;
              } // case 72
            case 82:
              {
                input.readMessage(getCompleteTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 82
            case 88:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000400;
                break;
              } // case 88
            case 98:
              {
                stateMessage_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000800;
                break;
              } // case 98
            case 106:
              {
                etag_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00001000;
                break;
              } // case 106
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The full name of the VolumeBackup resource.
     * Format: `projects/&#42;&#47;locations/&#42;&#47;backupPlans/&#42;&#47;backups/&#42;&#47;volumeBackups/&#42;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The full name of the VolumeBackup resource.
     * Format: `projects/&#42;&#47;locations/&#42;&#47;backupPlans/&#42;&#47;backups/&#42;&#47;volumeBackups/&#42;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The full name of the VolumeBackup resource.
     * Format: `projects/&#42;&#47;locations/&#42;&#47;backupPlans/&#42;&#47;backups/&#42;&#47;volumeBackups/&#42;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The full name of the VolumeBackup resource.
     * Format: `projects/&#42;&#47;locations/&#42;&#47;backupPlans/&#42;&#47;backups/&#42;&#47;volumeBackups/&#42;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The full name of the VolumeBackup resource.
     * Format: `projects/&#42;&#47;locations/&#42;&#47;backupPlans/&#42;&#47;backups/&#42;&#47;volumeBackups/&#42;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object uid_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Server generated global unique identifier of
     * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier) format.
     * </pre>
     *
     * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The uid.
     */
    public java.lang.String getUid() {
      java.lang.Object ref = uid_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uid_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Server generated global unique identifier of
     * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier) format.
     * </pre>
     *
     * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for uid.
     */
    public com.google.protobuf.ByteString getUidBytes() {
      java.lang.Object ref = uid_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        uid_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Server generated global unique identifier of
     * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier) format.
     * </pre>
     *
     * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The uid to set.
     * @return This builder for chaining.
     */
    public Builder setUid(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      uid_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Server generated global unique identifier of
     * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier) format.
     * </pre>
     *
     * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUid() {
      uid_ = getDefaultInstance().getUid();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Server generated global unique identifier of
     * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier) format.
     * </pre>
     *
     * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for uid to set.
     * @return This builder for chaining.
     */
    public Builder setUidBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      uid_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this VolumeBackup resource was
     * created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this VolumeBackup resource was
     * created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this VolumeBackup resource was
     * created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this VolumeBackup resource was
     * created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this VolumeBackup resource was
     * created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this VolumeBackup resource was
     * created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this VolumeBackup resource was
     * created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this VolumeBackup resource was
     * created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this VolumeBackup resource was
     * created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this VolumeBackup resource was last
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this VolumeBackup resource was last
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this VolumeBackup resource was last
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this VolumeBackup resource was last
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this VolumeBackup resource was last
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this VolumeBackup resource was last
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this VolumeBackup resource was last
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this VolumeBackup resource was last
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this VolumeBackup resource was last
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.cloud.gkebackup.v1.NamespacedName sourcePvc_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gkebackup.v1.NamespacedName,
            com.google.cloud.gkebackup.v1.NamespacedName.Builder,
            com.google.cloud.gkebackup.v1.NamespacedNameOrBuilder>
        sourcePvcBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. A reference to the source Kubernetes PVC from which this
     * VolumeBackup was created.
     * </pre>
     *
     * <code>
     * .google.cloud.gkebackup.v1.NamespacedName source_pvc = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the sourcePvc field is set.
     */
    public boolean hasSourcePvc() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. A reference to the source Kubernetes PVC from which this
     * VolumeBackup was created.
     * </pre>
     *
     * <code>
     * .google.cloud.gkebackup.v1.NamespacedName source_pvc = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The sourcePvc.
     */
    public com.google.cloud.gkebackup.v1.NamespacedName getSourcePvc() {
      if (sourcePvcBuilder_ == null) {
        return sourcePvc_ == null
            ? com.google.cloud.gkebackup.v1.NamespacedName.getDefaultInstance()
            : sourcePvc_;
      } else {
        return sourcePvcBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A reference to the source Kubernetes PVC from which this
     * VolumeBackup was created.
     * </pre>
     *
     * <code>
     * .google.cloud.gkebackup.v1.NamespacedName source_pvc = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setSourcePvc(com.google.cloud.gkebackup.v1.NamespacedName value) {
      if (sourcePvcBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        sourcePvc_ = value;
      } else {
        sourcePvcBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A reference to the source Kubernetes PVC from which this
     * VolumeBackup was created.
     * </pre>
     *
     * <code>
     * .google.cloud.gkebackup.v1.NamespacedName source_pvc = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setSourcePvc(
        com.google.cloud.gkebackup.v1.NamespacedName.Builder builderForValue) {
      if (sourcePvcBuilder_ == null) {
        sourcePvc_ = builderForValue.build();
      } else {
        sourcePvcBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A reference to the source Kubernetes PVC from which this
     * VolumeBackup was created.
     * </pre>
     *
     * <code>
     * .google.cloud.gkebackup.v1.NamespacedName source_pvc = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeSourcePvc(com.google.cloud.gkebackup.v1.NamespacedName value) {
      if (sourcePvcBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && sourcePvc_ != null
            && sourcePvc_ != com.google.cloud.gkebackup.v1.NamespacedName.getDefaultInstance()) {
          getSourcePvcBuilder().mergeFrom(value);
        } else {
          sourcePvc_ = value;
        }
      } else {
        sourcePvcBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A reference to the source Kubernetes PVC from which this
     * VolumeBackup was created.
     * </pre>
     *
     * <code>
     * .google.cloud.gkebackup.v1.NamespacedName source_pvc = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearSourcePvc() {
      bitField0_ = (bitField0_ & ~0x00000010);
      sourcePvc_ = null;
      if (sourcePvcBuilder_ != null) {
        sourcePvcBuilder_.dispose();
        sourcePvcBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A reference to the source Kubernetes PVC from which this
     * VolumeBackup was created.
     * </pre>
     *
     * <code>
     * .google.cloud.gkebackup.v1.NamespacedName source_pvc = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.gkebackup.v1.NamespacedName.Builder getSourcePvcBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getSourcePvcFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. A reference to the source Kubernetes PVC from which this
     * VolumeBackup was created.
     * </pre>
     *
     * <code>
     * .google.cloud.gkebackup.v1.NamespacedName source_pvc = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.gkebackup.v1.NamespacedNameOrBuilder getSourcePvcOrBuilder() {
      if (sourcePvcBuilder_ != null) {
        return sourcePvcBuilder_.getMessageOrBuilder();
      } else {
        return sourcePvc_ == null
            ? com.google.cloud.gkebackup.v1.NamespacedName.getDefaultInstance()
            : sourcePvc_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A reference to the source Kubernetes PVC from which this
     * VolumeBackup was created.
     * </pre>
     *
     * <code>
     * .google.cloud.gkebackup.v1.NamespacedName source_pvc = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gkebackup.v1.NamespacedName,
            com.google.cloud.gkebackup.v1.NamespacedName.Builder,
            com.google.cloud.gkebackup.v1.NamespacedNameOrBuilder>
        getSourcePvcFieldBuilder() {
      if (sourcePvcBuilder_ == null) {
        sourcePvcBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.gkebackup.v1.NamespacedName,
                com.google.cloud.gkebackup.v1.NamespacedName.Builder,
                com.google.cloud.gkebackup.v1.NamespacedNameOrBuilder>(
                getSourcePvc(), getParentForChildren(), isClean());
        sourcePvc_ = null;
      }
      return sourcePvcBuilder_;
    }

    private java.lang.Object volumeBackupHandle_ = "";
    /**
     *
     *
     * <pre>
     * Output only. A storage system-specific opaque handle to the underlying
     * volume backup.
     * </pre>
     *
     * <code>string volume_backup_handle = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The volumeBackupHandle.
     */
    public java.lang.String getVolumeBackupHandle() {
      java.lang.Object ref = volumeBackupHandle_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        volumeBackupHandle_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A storage system-specific opaque handle to the underlying
     * volume backup.
     * </pre>
     *
     * <code>string volume_backup_handle = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for volumeBackupHandle.
     */
    public com.google.protobuf.ByteString getVolumeBackupHandleBytes() {
      java.lang.Object ref = volumeBackupHandle_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        volumeBackupHandle_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A storage system-specific opaque handle to the underlying
     * volume backup.
     * </pre>
     *
     * <code>string volume_backup_handle = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The volumeBackupHandle to set.
     * @return This builder for chaining.
     */
    public Builder setVolumeBackupHandle(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      volumeBackupHandle_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A storage system-specific opaque handle to the underlying
     * volume backup.
     * </pre>
     *
     * <code>string volume_backup_handle = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVolumeBackupHandle() {
      volumeBackupHandle_ = getDefaultInstance().getVolumeBackupHandle();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A storage system-specific opaque handle to the underlying
     * volume backup.
     * </pre>
     *
     * <code>string volume_backup_handle = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for volumeBackupHandle to set.
     * @return This builder for chaining.
     */
    public Builder setVolumeBackupHandleBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      volumeBackupHandle_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private int format_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The format used for the volume backup.
     * </pre>
     *
     * <code>
     * .google.cloud.gkebackup.v1.VolumeBackup.VolumeBackupFormat format = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for format.
     */
    @java.lang.Override
    public int getFormatValue() {
      return format_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The format used for the volume backup.
     * </pre>
     *
     * <code>
     * .google.cloud.gkebackup.v1.VolumeBackup.VolumeBackupFormat format = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for format to set.
     * @return This builder for chaining.
     */
    public Builder setFormatValue(int value) {
      format_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The format used for the volume backup.
     * </pre>
     *
     * <code>
     * .google.cloud.gkebackup.v1.VolumeBackup.VolumeBackupFormat format = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The format.
     */
    @java.lang.Override
    public com.google.cloud.gkebackup.v1.VolumeBackup.VolumeBackupFormat getFormat() {
      com.google.cloud.gkebackup.v1.VolumeBackup.VolumeBackupFormat result =
          com.google.cloud.gkebackup.v1.VolumeBackup.VolumeBackupFormat.forNumber(format_);
      return result == null
          ? com.google.cloud.gkebackup.v1.VolumeBackup.VolumeBackupFormat.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The format used for the volume backup.
     * </pre>
     *
     * <code>
     * .google.cloud.gkebackup.v1.VolumeBackup.VolumeBackupFormat format = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The format to set.
     * @return This builder for chaining.
     */
    public Builder setFormat(com.google.cloud.gkebackup.v1.VolumeBackup.VolumeBackupFormat value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000040;
      format_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The format used for the volume backup.
     * </pre>
     *
     * <code>
     * .google.cloud.gkebackup.v1.VolumeBackup.VolumeBackupFormat format = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFormat() {
      bitField0_ = (bitField0_ & ~0x00000040);
      format_ = 0;
      onChanged();
      return this;
    }

    private long storageBytes_;
    /**
     *
     *
     * <pre>
     * Output only. The aggregate size of the underlying artifacts associated with
     * this VolumeBackup in the backup storage. This may change over time when
     * multiple backups of the same volume share the same backup storage
     * location. In particular, this is likely to increase in size when
     * the immediately preceding backup of the same volume is deleted.
     * </pre>
     *
     * <code>int64 storage_bytes = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The storageBytes.
     */
    @java.lang.Override
    public long getStorageBytes() {
      return storageBytes_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The aggregate size of the underlying artifacts associated with
     * this VolumeBackup in the backup storage. This may change over time when
     * multiple backups of the same volume share the same backup storage
     * location. In particular, this is likely to increase in size when
     * the immediately preceding backup of the same volume is deleted.
     * </pre>
     *
     * <code>int64 storage_bytes = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The storageBytes to set.
     * @return This builder for chaining.
     */
    public Builder setStorageBytes(long value) {

      storageBytes_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The aggregate size of the underlying artifacts associated with
     * this VolumeBackup in the backup storage. This may change over time when
     * multiple backups of the same volume share the same backup storage
     * location. In particular, this is likely to increase in size when
     * the immediately preceding backup of the same volume is deleted.
     * </pre>
     *
     * <code>int64 storage_bytes = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStorageBytes() {
      bitField0_ = (bitField0_ & ~0x00000080);
      storageBytes_ = 0L;
      onChanged();
      return this;
    }

    private long diskSizeBytes_;
    /**
     *
     *
     * <pre>
     * Output only. The minimum size of the disk to which this VolumeBackup can be
     * restored.
     * </pre>
     *
     * <code>int64 disk_size_bytes = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The diskSizeBytes.
     */
    @java.lang.Override
    public long getDiskSizeBytes() {
      return diskSizeBytes_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The minimum size of the disk to which this VolumeBackup can be
     * restored.
     * </pre>
     *
     * <code>int64 disk_size_bytes = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The diskSizeBytes to set.
     * @return This builder for chaining.
     */
    public Builder setDiskSizeBytes(long value) {

      diskSizeBytes_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The minimum size of the disk to which this VolumeBackup can be
     * restored.
     * </pre>
     *
     * <code>int64 disk_size_bytes = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDiskSizeBytes() {
      bitField0_ = (bitField0_ & ~0x00000100);
      diskSizeBytes_ = 0L;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp completeTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        completeTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the associated underlying volume backup
     * operation completed.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp complete_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the completeTime field is set.
     */
    public boolean hasCompleteTime() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the associated underlying volume backup
     * operation completed.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp complete_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The completeTime.
     */
    public com.google.protobuf.Timestamp getCompleteTime() {
      if (completeTimeBuilder_ == null) {
        return completeTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : completeTime_;
      } else {
        return completeTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the associated underlying volume backup
     * operation completed.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp complete_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCompleteTime(com.google.protobuf.Timestamp value) {
      if (completeTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        completeTime_ = value;
      } else {
        completeTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the associated underlying volume backup
     * operation completed.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp complete_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCompleteTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (completeTimeBuilder_ == null) {
        completeTime_ = builderForValue.build();
      } else {
        completeTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the associated underlying volume backup
     * operation completed.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp complete_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCompleteTime(com.google.protobuf.Timestamp value) {
      if (completeTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && completeTime_ != null
            && completeTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCompleteTimeBuilder().mergeFrom(value);
        } else {
          completeTime_ = value;
        }
      } else {
        completeTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the associated underlying volume backup
     * operation completed.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp complete_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCompleteTime() {
      bitField0_ = (bitField0_ & ~0x00000200);
      completeTime_ = null;
      if (completeTimeBuilder_ != null) {
        completeTimeBuilder_.dispose();
        completeTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the associated underlying volume backup
     * operation completed.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp complete_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCompleteTimeBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getCompleteTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the associated underlying volume backup
     * operation completed.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp complete_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCompleteTimeOrBuilder() {
      if (completeTimeBuilder_ != null) {
        return completeTimeBuilder_.getMessageOrBuilder();
      } else {
        return completeTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : completeTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the associated underlying volume backup
     * operation completed.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp complete_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCompleteTimeFieldBuilder() {
      if (completeTimeBuilder_ == null) {
        completeTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCompleteTime(), getParentForChildren(), isClean());
        completeTime_ = null;
      }
      return completeTimeBuilder_;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The current state of this VolumeBackup.
     * </pre>
     *
     * <code>
     * .google.cloud.gkebackup.v1.VolumeBackup.State state = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of this VolumeBackup.
     * </pre>
     *
     * <code>
     * .google.cloud.gkebackup.v1.VolumeBackup.State state = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of this VolumeBackup.
     * </pre>
     *
     * <code>
     * .google.cloud.gkebackup.v1.VolumeBackup.State state = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.gkebackup.v1.VolumeBackup.State getState() {
      com.google.cloud.gkebackup.v1.VolumeBackup.State result =
          com.google.cloud.gkebackup.v1.VolumeBackup.State.forNumber(state_);
      return result == null
          ? com.google.cloud.gkebackup.v1.VolumeBackup.State.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of this VolumeBackup.
     * </pre>
     *
     * <code>
     * .google.cloud.gkebackup.v1.VolumeBackup.State state = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.gkebackup.v1.VolumeBackup.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000400;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of this VolumeBackup.
     * </pre>
     *
     * <code>
     * .google.cloud.gkebackup.v1.VolumeBackup.State state = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000400);
      state_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object stateMessage_ = "";
    /**
     *
     *
     * <pre>
     * Output only. A human readable message explaining why the VolumeBackup is in
     * its current state.
     * </pre>
     *
     * <code>string state_message = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The stateMessage.
     */
    public java.lang.String getStateMessage() {
      java.lang.Object ref = stateMessage_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        stateMessage_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A human readable message explaining why the VolumeBackup is in
     * its current state.
     * </pre>
     *
     * <code>string state_message = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for stateMessage.
     */
    public com.google.protobuf.ByteString getStateMessageBytes() {
      java.lang.Object ref = stateMessage_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        stateMessage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A human readable message explaining why the VolumeBackup is in
     * its current state.
     * </pre>
     *
     * <code>string state_message = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The stateMessage to set.
     * @return This builder for chaining.
     */
    public Builder setStateMessage(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      stateMessage_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A human readable message explaining why the VolumeBackup is in
     * its current state.
     * </pre>
     *
     * <code>string state_message = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStateMessage() {
      stateMessage_ = getDefaultInstance().getStateMessage();
      bitField0_ = (bitField0_ & ~0x00000800);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A human readable message explaining why the VolumeBackup is in
     * its current state.
     * </pre>
     *
     * <code>string state_message = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for stateMessage to set.
     * @return This builder for chaining.
     */
    public Builder setStateMessageBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      stateMessage_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    private java.lang.Object etag_ = "";
    /**
     *
     *
     * <pre>
     * Output only. `etag` is used for optimistic concurrency control as a way to
     * help prevent simultaneous updates of a volume backup from overwriting each
     * other. It is strongly suggested that systems make use of the `etag` in the
     * read-modify-write cycle to perform volume backup updates in order to avoid
     * race conditions.
     * </pre>
     *
     * <code>string etag = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The etag.
     */
    public java.lang.String getEtag() {
      java.lang.Object ref = etag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        etag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. `etag` is used for optimistic concurrency control as a way to
     * help prevent simultaneous updates of a volume backup from overwriting each
     * other. It is strongly suggested that systems make use of the `etag` in the
     * read-modify-write cycle to perform volume backup updates in order to avoid
     * race conditions.
     * </pre>
     *
     * <code>string etag = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for etag.
     */
    public com.google.protobuf.ByteString getEtagBytes() {
      java.lang.Object ref = etag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        etag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. `etag` is used for optimistic concurrency control as a way to
     * help prevent simultaneous updates of a volume backup from overwriting each
     * other. It is strongly suggested that systems make use of the `etag` in the
     * read-modify-write cycle to perform volume backup updates in order to avoid
     * race conditions.
     * </pre>
     *
     * <code>string etag = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      etag_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. `etag` is used for optimistic concurrency control as a way to
     * help prevent simultaneous updates of a volume backup from overwriting each
     * other. It is strongly suggested that systems make use of the `etag` in the
     * read-modify-write cycle to perform volume backup updates in order to avoid
     * race conditions.
     * </pre>
     *
     * <code>string etag = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEtag() {
      etag_ = getDefaultInstance().getEtag();
      bitField0_ = (bitField0_ & ~0x00001000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. `etag` is used for optimistic concurrency control as a way to
     * help prevent simultaneous updates of a volume backup from overwriting each
     * other. It is strongly suggested that systems make use of the `etag` in the
     * read-modify-write cycle to perform volume backup updates in order to avoid
     * race conditions.
     * </pre>
     *
     * <code>string etag = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      etag_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.gkebackup.v1.VolumeBackup)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.gkebackup.v1.VolumeBackup)
  private static final com.google.cloud.gkebackup.v1.VolumeBackup DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.gkebackup.v1.VolumeBackup();
  }

  public static com.google.cloud.gkebackup.v1.VolumeBackup getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<VolumeBackup> PARSER =
      new com.google.protobuf.AbstractParser<VolumeBackup>() {
        @java.lang.Override
        public VolumeBackup parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<VolumeBackup> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<VolumeBackup> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.gkebackup.v1.VolumeBackup getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
