/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/gkehub/v1/configmanagement/configmanagement.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.gkehub.configmanagement.v1;

/**
 *
 *
 * <pre>
 * The state of ConfigSync's deployment on a cluster
 * </pre>
 *
 * Protobuf type {@code google.cloud.gkehub.configmanagement.v1.ConfigSyncDeploymentState}
 */
public final class ConfigSyncDeploymentState extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.gkehub.configmanagement.v1.ConfigSyncDeploymentState)
    ConfigSyncDeploymentStateOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ConfigSyncDeploymentState.newBuilder() to construct.
  private ConfigSyncDeploymentState(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ConfigSyncDeploymentState() {
    importer_ = 0;
    syncer_ = 0;
    gitSync_ = 0;
    monitor_ = 0;
    reconcilerManager_ = 0;
    rootReconciler_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ConfigSyncDeploymentState();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.gkehub.configmanagement.v1.ConfigManagementProto
        .internal_static_google_cloud_gkehub_configmanagement_v1_ConfigSyncDeploymentState_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.gkehub.configmanagement.v1.ConfigManagementProto
        .internal_static_google_cloud_gkehub_configmanagement_v1_ConfigSyncDeploymentState_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.gkehub.configmanagement.v1.ConfigSyncDeploymentState.class,
            com.google.cloud.gkehub.configmanagement.v1.ConfigSyncDeploymentState.Builder.class);
  }

  public static final int IMPORTER_FIELD_NUMBER = 1;
  private int importer_ = 0;
  /**
   *
   *
   * <pre>
   * Deployment state of the importer pod
   * </pre>
   *
   * <code>.google.cloud.gkehub.configmanagement.v1.DeploymentState importer = 1;</code>
   *
   * @return The enum numeric value on the wire for importer.
   */
  @java.lang.Override
  public int getImporterValue() {
    return importer_;
  }
  /**
   *
   *
   * <pre>
   * Deployment state of the importer pod
   * </pre>
   *
   * <code>.google.cloud.gkehub.configmanagement.v1.DeploymentState importer = 1;</code>
   *
   * @return The importer.
   */
  @java.lang.Override
  public com.google.cloud.gkehub.configmanagement.v1.DeploymentState getImporter() {
    com.google.cloud.gkehub.configmanagement.v1.DeploymentState result =
        com.google.cloud.gkehub.configmanagement.v1.DeploymentState.forNumber(importer_);
    return result == null
        ? com.google.cloud.gkehub.configmanagement.v1.DeploymentState.UNRECOGNIZED
        : result;
  }

  public static final int SYNCER_FIELD_NUMBER = 2;
  private int syncer_ = 0;
  /**
   *
   *
   * <pre>
   * Deployment state of the syncer pod
   * </pre>
   *
   * <code>.google.cloud.gkehub.configmanagement.v1.DeploymentState syncer = 2;</code>
   *
   * @return The enum numeric value on the wire for syncer.
   */
  @java.lang.Override
  public int getSyncerValue() {
    return syncer_;
  }
  /**
   *
   *
   * <pre>
   * Deployment state of the syncer pod
   * </pre>
   *
   * <code>.google.cloud.gkehub.configmanagement.v1.DeploymentState syncer = 2;</code>
   *
   * @return The syncer.
   */
  @java.lang.Override
  public com.google.cloud.gkehub.configmanagement.v1.DeploymentState getSyncer() {
    com.google.cloud.gkehub.configmanagement.v1.DeploymentState result =
        com.google.cloud.gkehub.configmanagement.v1.DeploymentState.forNumber(syncer_);
    return result == null
        ? com.google.cloud.gkehub.configmanagement.v1.DeploymentState.UNRECOGNIZED
        : result;
  }

  public static final int GIT_SYNC_FIELD_NUMBER = 3;
  private int gitSync_ = 0;
  /**
   *
   *
   * <pre>
   * Deployment state of the git-sync pod
   * </pre>
   *
   * <code>.google.cloud.gkehub.configmanagement.v1.DeploymentState git_sync = 3;</code>
   *
   * @return The enum numeric value on the wire for gitSync.
   */
  @java.lang.Override
  public int getGitSyncValue() {
    return gitSync_;
  }
  /**
   *
   *
   * <pre>
   * Deployment state of the git-sync pod
   * </pre>
   *
   * <code>.google.cloud.gkehub.configmanagement.v1.DeploymentState git_sync = 3;</code>
   *
   * @return The gitSync.
   */
  @java.lang.Override
  public com.google.cloud.gkehub.configmanagement.v1.DeploymentState getGitSync() {
    com.google.cloud.gkehub.configmanagement.v1.DeploymentState result =
        com.google.cloud.gkehub.configmanagement.v1.DeploymentState.forNumber(gitSync_);
    return result == null
        ? com.google.cloud.gkehub.configmanagement.v1.DeploymentState.UNRECOGNIZED
        : result;
  }

  public static final int MONITOR_FIELD_NUMBER = 4;
  private int monitor_ = 0;
  /**
   *
   *
   * <pre>
   * Deployment state of the monitor pod
   * </pre>
   *
   * <code>.google.cloud.gkehub.configmanagement.v1.DeploymentState monitor = 4;</code>
   *
   * @return The enum numeric value on the wire for monitor.
   */
  @java.lang.Override
  public int getMonitorValue() {
    return monitor_;
  }
  /**
   *
   *
   * <pre>
   * Deployment state of the monitor pod
   * </pre>
   *
   * <code>.google.cloud.gkehub.configmanagement.v1.DeploymentState monitor = 4;</code>
   *
   * @return The monitor.
   */
  @java.lang.Override
  public com.google.cloud.gkehub.configmanagement.v1.DeploymentState getMonitor() {
    com.google.cloud.gkehub.configmanagement.v1.DeploymentState result =
        com.google.cloud.gkehub.configmanagement.v1.DeploymentState.forNumber(monitor_);
    return result == null
        ? com.google.cloud.gkehub.configmanagement.v1.DeploymentState.UNRECOGNIZED
        : result;
  }

  public static final int RECONCILER_MANAGER_FIELD_NUMBER = 5;
  private int reconcilerManager_ = 0;
  /**
   *
   *
   * <pre>
   * Deployment state of reconciler-manager pod
   * </pre>
   *
   * <code>.google.cloud.gkehub.configmanagement.v1.DeploymentState reconciler_manager = 5;</code>
   *
   * @return The enum numeric value on the wire for reconcilerManager.
   */
  @java.lang.Override
  public int getReconcilerManagerValue() {
    return reconcilerManager_;
  }
  /**
   *
   *
   * <pre>
   * Deployment state of reconciler-manager pod
   * </pre>
   *
   * <code>.google.cloud.gkehub.configmanagement.v1.DeploymentState reconciler_manager = 5;</code>
   *
   * @return The reconcilerManager.
   */
  @java.lang.Override
  public com.google.cloud.gkehub.configmanagement.v1.DeploymentState getReconcilerManager() {
    com.google.cloud.gkehub.configmanagement.v1.DeploymentState result =
        com.google.cloud.gkehub.configmanagement.v1.DeploymentState.forNumber(reconcilerManager_);
    return result == null
        ? com.google.cloud.gkehub.configmanagement.v1.DeploymentState.UNRECOGNIZED
        : result;
  }

  public static final int ROOT_RECONCILER_FIELD_NUMBER = 6;
  private int rootReconciler_ = 0;
  /**
   *
   *
   * <pre>
   * Deployment state of root-reconciler
   * </pre>
   *
   * <code>.google.cloud.gkehub.configmanagement.v1.DeploymentState root_reconciler = 6;</code>
   *
   * @return The enum numeric value on the wire for rootReconciler.
   */
  @java.lang.Override
  public int getRootReconcilerValue() {
    return rootReconciler_;
  }
  /**
   *
   *
   * <pre>
   * Deployment state of root-reconciler
   * </pre>
   *
   * <code>.google.cloud.gkehub.configmanagement.v1.DeploymentState root_reconciler = 6;</code>
   *
   * @return The rootReconciler.
   */
  @java.lang.Override
  public com.google.cloud.gkehub.configmanagement.v1.DeploymentState getRootReconciler() {
    com.google.cloud.gkehub.configmanagement.v1.DeploymentState result =
        com.google.cloud.gkehub.configmanagement.v1.DeploymentState.forNumber(rootReconciler_);
    return result == null
        ? com.google.cloud.gkehub.configmanagement.v1.DeploymentState.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (importer_
        != com.google.cloud.gkehub.configmanagement.v1.DeploymentState.DEPLOYMENT_STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(1, importer_);
    }
    if (syncer_
        != com.google.cloud.gkehub.configmanagement.v1.DeploymentState.DEPLOYMENT_STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(2, syncer_);
    }
    if (gitSync_
        != com.google.cloud.gkehub.configmanagement.v1.DeploymentState.DEPLOYMENT_STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(3, gitSync_);
    }
    if (monitor_
        != com.google.cloud.gkehub.configmanagement.v1.DeploymentState.DEPLOYMENT_STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(4, monitor_);
    }
    if (reconcilerManager_
        != com.google.cloud.gkehub.configmanagement.v1.DeploymentState.DEPLOYMENT_STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(5, reconcilerManager_);
    }
    if (rootReconciler_
        != com.google.cloud.gkehub.configmanagement.v1.DeploymentState.DEPLOYMENT_STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(6, rootReconciler_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (importer_
        != com.google.cloud.gkehub.configmanagement.v1.DeploymentState.DEPLOYMENT_STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, importer_);
    }
    if (syncer_
        != com.google.cloud.gkehub.configmanagement.v1.DeploymentState.DEPLOYMENT_STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, syncer_);
    }
    if (gitSync_
        != com.google.cloud.gkehub.configmanagement.v1.DeploymentState.DEPLOYMENT_STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, gitSync_);
    }
    if (monitor_
        != com.google.cloud.gkehub.configmanagement.v1.DeploymentState.DEPLOYMENT_STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, monitor_);
    }
    if (reconcilerManager_
        != com.google.cloud.gkehub.configmanagement.v1.DeploymentState.DEPLOYMENT_STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, reconcilerManager_);
    }
    if (rootReconciler_
        != com.google.cloud.gkehub.configmanagement.v1.DeploymentState.DEPLOYMENT_STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(6, rootReconciler_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.gkehub.configmanagement.v1.ConfigSyncDeploymentState)) {
      return super.equals(obj);
    }
    com.google.cloud.gkehub.configmanagement.v1.ConfigSyncDeploymentState other =
        (com.google.cloud.gkehub.configmanagement.v1.ConfigSyncDeploymentState) obj;

    if (importer_ != other.importer_) return false;
    if (syncer_ != other.syncer_) return false;
    if (gitSync_ != other.gitSync_) return false;
    if (monitor_ != other.monitor_) return false;
    if (reconcilerManager_ != other.reconcilerManager_) return false;
    if (rootReconciler_ != other.rootReconciler_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + IMPORTER_FIELD_NUMBER;
    hash = (53 * hash) + importer_;
    hash = (37 * hash) + SYNCER_FIELD_NUMBER;
    hash = (53 * hash) + syncer_;
    hash = (37 * hash) + GIT_SYNC_FIELD_NUMBER;
    hash = (53 * hash) + gitSync_;
    hash = (37 * hash) + MONITOR_FIELD_NUMBER;
    hash = (53 * hash) + monitor_;
    hash = (37 * hash) + RECONCILER_MANAGER_FIELD_NUMBER;
    hash = (53 * hash) + reconcilerManager_;
    hash = (37 * hash) + ROOT_RECONCILER_FIELD_NUMBER;
    hash = (53 * hash) + rootReconciler_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.gkehub.configmanagement.v1.ConfigSyncDeploymentState parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gkehub.configmanagement.v1.ConfigSyncDeploymentState parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gkehub.configmanagement.v1.ConfigSyncDeploymentState parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gkehub.configmanagement.v1.ConfigSyncDeploymentState parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gkehub.configmanagement.v1.ConfigSyncDeploymentState parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gkehub.configmanagement.v1.ConfigSyncDeploymentState parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gkehub.configmanagement.v1.ConfigSyncDeploymentState parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.gkehub.configmanagement.v1.ConfigSyncDeploymentState parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.gkehub.configmanagement.v1.ConfigSyncDeploymentState
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.gkehub.configmanagement.v1.ConfigSyncDeploymentState
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.gkehub.configmanagement.v1.ConfigSyncDeploymentState parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.gkehub.configmanagement.v1.ConfigSyncDeploymentState parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.gkehub.configmanagement.v1.ConfigSyncDeploymentState prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The state of ConfigSync's deployment on a cluster
   * </pre>
   *
   * Protobuf type {@code google.cloud.gkehub.configmanagement.v1.ConfigSyncDeploymentState}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.gkehub.configmanagement.v1.ConfigSyncDeploymentState)
      com.google.cloud.gkehub.configmanagement.v1.ConfigSyncDeploymentStateOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.gkehub.configmanagement.v1.ConfigManagementProto
          .internal_static_google_cloud_gkehub_configmanagement_v1_ConfigSyncDeploymentState_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.gkehub.configmanagement.v1.ConfigManagementProto
          .internal_static_google_cloud_gkehub_configmanagement_v1_ConfigSyncDeploymentState_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.gkehub.configmanagement.v1.ConfigSyncDeploymentState.class,
              com.google.cloud.gkehub.configmanagement.v1.ConfigSyncDeploymentState.Builder.class);
    }

    // Construct using
    // com.google.cloud.gkehub.configmanagement.v1.ConfigSyncDeploymentState.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      importer_ = 0;
      syncer_ = 0;
      gitSync_ = 0;
      monitor_ = 0;
      reconcilerManager_ = 0;
      rootReconciler_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.gkehub.configmanagement.v1.ConfigManagementProto
          .internal_static_google_cloud_gkehub_configmanagement_v1_ConfigSyncDeploymentState_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.gkehub.configmanagement.v1.ConfigSyncDeploymentState
        getDefaultInstanceForType() {
      return com.google.cloud.gkehub.configmanagement.v1.ConfigSyncDeploymentState
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.gkehub.configmanagement.v1.ConfigSyncDeploymentState build() {
      com.google.cloud.gkehub.configmanagement.v1.ConfigSyncDeploymentState result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.gkehub.configmanagement.v1.ConfigSyncDeploymentState buildPartial() {
      com.google.cloud.gkehub.configmanagement.v1.ConfigSyncDeploymentState result =
          new com.google.cloud.gkehub.configmanagement.v1.ConfigSyncDeploymentState(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.gkehub.configmanagement.v1.ConfigSyncDeploymentState result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.importer_ = importer_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.syncer_ = syncer_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.gitSync_ = gitSync_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.monitor_ = monitor_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.reconcilerManager_ = reconcilerManager_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.rootReconciler_ = rootReconciler_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.gkehub.configmanagement.v1.ConfigSyncDeploymentState) {
        return mergeFrom(
            (com.google.cloud.gkehub.configmanagement.v1.ConfigSyncDeploymentState) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.gkehub.configmanagement.v1.ConfigSyncDeploymentState other) {
      if (other
          == com.google.cloud.gkehub.configmanagement.v1.ConfigSyncDeploymentState
              .getDefaultInstance()) return this;
      if (other.importer_ != 0) {
        setImporterValue(other.getImporterValue());
      }
      if (other.syncer_ != 0) {
        setSyncerValue(other.getSyncerValue());
      }
      if (other.gitSync_ != 0) {
        setGitSyncValue(other.getGitSyncValue());
      }
      if (other.monitor_ != 0) {
        setMonitorValue(other.getMonitorValue());
      }
      if (other.reconcilerManager_ != 0) {
        setReconcilerManagerValue(other.getReconcilerManagerValue());
      }
      if (other.rootReconciler_ != 0) {
        setRootReconcilerValue(other.getRootReconcilerValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                importer_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 16:
              {
                syncer_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 24:
              {
                gitSync_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 32:
              {
                monitor_ = input.readEnum();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 40:
              {
                reconcilerManager_ = input.readEnum();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            case 48:
              {
                rootReconciler_ = input.readEnum();
                bitField0_ |= 0x00000020;
                break;
              } // case 48
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int importer_ = 0;
    /**
     *
     *
     * <pre>
     * Deployment state of the importer pod
     * </pre>
     *
     * <code>.google.cloud.gkehub.configmanagement.v1.DeploymentState importer = 1;</code>
     *
     * @return The enum numeric value on the wire for importer.
     */
    @java.lang.Override
    public int getImporterValue() {
      return importer_;
    }
    /**
     *
     *
     * <pre>
     * Deployment state of the importer pod
     * </pre>
     *
     * <code>.google.cloud.gkehub.configmanagement.v1.DeploymentState importer = 1;</code>
     *
     * @param value The enum numeric value on the wire for importer to set.
     * @return This builder for chaining.
     */
    public Builder setImporterValue(int value) {
      importer_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deployment state of the importer pod
     * </pre>
     *
     * <code>.google.cloud.gkehub.configmanagement.v1.DeploymentState importer = 1;</code>
     *
     * @return The importer.
     */
    @java.lang.Override
    public com.google.cloud.gkehub.configmanagement.v1.DeploymentState getImporter() {
      com.google.cloud.gkehub.configmanagement.v1.DeploymentState result =
          com.google.cloud.gkehub.configmanagement.v1.DeploymentState.forNumber(importer_);
      return result == null
          ? com.google.cloud.gkehub.configmanagement.v1.DeploymentState.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Deployment state of the importer pod
     * </pre>
     *
     * <code>.google.cloud.gkehub.configmanagement.v1.DeploymentState importer = 1;</code>
     *
     * @param value The importer to set.
     * @return This builder for chaining.
     */
    public Builder setImporter(com.google.cloud.gkehub.configmanagement.v1.DeploymentState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      importer_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deployment state of the importer pod
     * </pre>
     *
     * <code>.google.cloud.gkehub.configmanagement.v1.DeploymentState importer = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearImporter() {
      bitField0_ = (bitField0_ & ~0x00000001);
      importer_ = 0;
      onChanged();
      return this;
    }

    private int syncer_ = 0;
    /**
     *
     *
     * <pre>
     * Deployment state of the syncer pod
     * </pre>
     *
     * <code>.google.cloud.gkehub.configmanagement.v1.DeploymentState syncer = 2;</code>
     *
     * @return The enum numeric value on the wire for syncer.
     */
    @java.lang.Override
    public int getSyncerValue() {
      return syncer_;
    }
    /**
     *
     *
     * <pre>
     * Deployment state of the syncer pod
     * </pre>
     *
     * <code>.google.cloud.gkehub.configmanagement.v1.DeploymentState syncer = 2;</code>
     *
     * @param value The enum numeric value on the wire for syncer to set.
     * @return This builder for chaining.
     */
    public Builder setSyncerValue(int value) {
      syncer_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deployment state of the syncer pod
     * </pre>
     *
     * <code>.google.cloud.gkehub.configmanagement.v1.DeploymentState syncer = 2;</code>
     *
     * @return The syncer.
     */
    @java.lang.Override
    public com.google.cloud.gkehub.configmanagement.v1.DeploymentState getSyncer() {
      com.google.cloud.gkehub.configmanagement.v1.DeploymentState result =
          com.google.cloud.gkehub.configmanagement.v1.DeploymentState.forNumber(syncer_);
      return result == null
          ? com.google.cloud.gkehub.configmanagement.v1.DeploymentState.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Deployment state of the syncer pod
     * </pre>
     *
     * <code>.google.cloud.gkehub.configmanagement.v1.DeploymentState syncer = 2;</code>
     *
     * @param value The syncer to set.
     * @return This builder for chaining.
     */
    public Builder setSyncer(com.google.cloud.gkehub.configmanagement.v1.DeploymentState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      syncer_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deployment state of the syncer pod
     * </pre>
     *
     * <code>.google.cloud.gkehub.configmanagement.v1.DeploymentState syncer = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSyncer() {
      bitField0_ = (bitField0_ & ~0x00000002);
      syncer_ = 0;
      onChanged();
      return this;
    }

    private int gitSync_ = 0;
    /**
     *
     *
     * <pre>
     * Deployment state of the git-sync pod
     * </pre>
     *
     * <code>.google.cloud.gkehub.configmanagement.v1.DeploymentState git_sync = 3;</code>
     *
     * @return The enum numeric value on the wire for gitSync.
     */
    @java.lang.Override
    public int getGitSyncValue() {
      return gitSync_;
    }
    /**
     *
     *
     * <pre>
     * Deployment state of the git-sync pod
     * </pre>
     *
     * <code>.google.cloud.gkehub.configmanagement.v1.DeploymentState git_sync = 3;</code>
     *
     * @param value The enum numeric value on the wire for gitSync to set.
     * @return This builder for chaining.
     */
    public Builder setGitSyncValue(int value) {
      gitSync_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deployment state of the git-sync pod
     * </pre>
     *
     * <code>.google.cloud.gkehub.configmanagement.v1.DeploymentState git_sync = 3;</code>
     *
     * @return The gitSync.
     */
    @java.lang.Override
    public com.google.cloud.gkehub.configmanagement.v1.DeploymentState getGitSync() {
      com.google.cloud.gkehub.configmanagement.v1.DeploymentState result =
          com.google.cloud.gkehub.configmanagement.v1.DeploymentState.forNumber(gitSync_);
      return result == null
          ? com.google.cloud.gkehub.configmanagement.v1.DeploymentState.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Deployment state of the git-sync pod
     * </pre>
     *
     * <code>.google.cloud.gkehub.configmanagement.v1.DeploymentState git_sync = 3;</code>
     *
     * @param value The gitSync to set.
     * @return This builder for chaining.
     */
    public Builder setGitSync(com.google.cloud.gkehub.configmanagement.v1.DeploymentState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      gitSync_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deployment state of the git-sync pod
     * </pre>
     *
     * <code>.google.cloud.gkehub.configmanagement.v1.DeploymentState git_sync = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearGitSync() {
      bitField0_ = (bitField0_ & ~0x00000004);
      gitSync_ = 0;
      onChanged();
      return this;
    }

    private int monitor_ = 0;
    /**
     *
     *
     * <pre>
     * Deployment state of the monitor pod
     * </pre>
     *
     * <code>.google.cloud.gkehub.configmanagement.v1.DeploymentState monitor = 4;</code>
     *
     * @return The enum numeric value on the wire for monitor.
     */
    @java.lang.Override
    public int getMonitorValue() {
      return monitor_;
    }
    /**
     *
     *
     * <pre>
     * Deployment state of the monitor pod
     * </pre>
     *
     * <code>.google.cloud.gkehub.configmanagement.v1.DeploymentState monitor = 4;</code>
     *
     * @param value The enum numeric value on the wire for monitor to set.
     * @return This builder for chaining.
     */
    public Builder setMonitorValue(int value) {
      monitor_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deployment state of the monitor pod
     * </pre>
     *
     * <code>.google.cloud.gkehub.configmanagement.v1.DeploymentState monitor = 4;</code>
     *
     * @return The monitor.
     */
    @java.lang.Override
    public com.google.cloud.gkehub.configmanagement.v1.DeploymentState getMonitor() {
      com.google.cloud.gkehub.configmanagement.v1.DeploymentState result =
          com.google.cloud.gkehub.configmanagement.v1.DeploymentState.forNumber(monitor_);
      return result == null
          ? com.google.cloud.gkehub.configmanagement.v1.DeploymentState.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Deployment state of the monitor pod
     * </pre>
     *
     * <code>.google.cloud.gkehub.configmanagement.v1.DeploymentState monitor = 4;</code>
     *
     * @param value The monitor to set.
     * @return This builder for chaining.
     */
    public Builder setMonitor(com.google.cloud.gkehub.configmanagement.v1.DeploymentState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000008;
      monitor_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deployment state of the monitor pod
     * </pre>
     *
     * <code>.google.cloud.gkehub.configmanagement.v1.DeploymentState monitor = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMonitor() {
      bitField0_ = (bitField0_ & ~0x00000008);
      monitor_ = 0;
      onChanged();
      return this;
    }

    private int reconcilerManager_ = 0;
    /**
     *
     *
     * <pre>
     * Deployment state of reconciler-manager pod
     * </pre>
     *
     * <code>.google.cloud.gkehub.configmanagement.v1.DeploymentState reconciler_manager = 5;</code>
     *
     * @return The enum numeric value on the wire for reconcilerManager.
     */
    @java.lang.Override
    public int getReconcilerManagerValue() {
      return reconcilerManager_;
    }
    /**
     *
     *
     * <pre>
     * Deployment state of reconciler-manager pod
     * </pre>
     *
     * <code>.google.cloud.gkehub.configmanagement.v1.DeploymentState reconciler_manager = 5;</code>
     *
     * @param value The enum numeric value on the wire for reconcilerManager to set.
     * @return This builder for chaining.
     */
    public Builder setReconcilerManagerValue(int value) {
      reconcilerManager_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deployment state of reconciler-manager pod
     * </pre>
     *
     * <code>.google.cloud.gkehub.configmanagement.v1.DeploymentState reconciler_manager = 5;</code>
     *
     * @return The reconcilerManager.
     */
    @java.lang.Override
    public com.google.cloud.gkehub.configmanagement.v1.DeploymentState getReconcilerManager() {
      com.google.cloud.gkehub.configmanagement.v1.DeploymentState result =
          com.google.cloud.gkehub.configmanagement.v1.DeploymentState.forNumber(reconcilerManager_);
      return result == null
          ? com.google.cloud.gkehub.configmanagement.v1.DeploymentState.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Deployment state of reconciler-manager pod
     * </pre>
     *
     * <code>.google.cloud.gkehub.configmanagement.v1.DeploymentState reconciler_manager = 5;</code>
     *
     * @param value The reconcilerManager to set.
     * @return This builder for chaining.
     */
    public Builder setReconcilerManager(
        com.google.cloud.gkehub.configmanagement.v1.DeploymentState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000010;
      reconcilerManager_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deployment state of reconciler-manager pod
     * </pre>
     *
     * <code>.google.cloud.gkehub.configmanagement.v1.DeploymentState reconciler_manager = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReconcilerManager() {
      bitField0_ = (bitField0_ & ~0x00000010);
      reconcilerManager_ = 0;
      onChanged();
      return this;
    }

    private int rootReconciler_ = 0;
    /**
     *
     *
     * <pre>
     * Deployment state of root-reconciler
     * </pre>
     *
     * <code>.google.cloud.gkehub.configmanagement.v1.DeploymentState root_reconciler = 6;</code>
     *
     * @return The enum numeric value on the wire for rootReconciler.
     */
    @java.lang.Override
    public int getRootReconcilerValue() {
      return rootReconciler_;
    }
    /**
     *
     *
     * <pre>
     * Deployment state of root-reconciler
     * </pre>
     *
     * <code>.google.cloud.gkehub.configmanagement.v1.DeploymentState root_reconciler = 6;</code>
     *
     * @param value The enum numeric value on the wire for rootReconciler to set.
     * @return This builder for chaining.
     */
    public Builder setRootReconcilerValue(int value) {
      rootReconciler_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deployment state of root-reconciler
     * </pre>
     *
     * <code>.google.cloud.gkehub.configmanagement.v1.DeploymentState root_reconciler = 6;</code>
     *
     * @return The rootReconciler.
     */
    @java.lang.Override
    public com.google.cloud.gkehub.configmanagement.v1.DeploymentState getRootReconciler() {
      com.google.cloud.gkehub.configmanagement.v1.DeploymentState result =
          com.google.cloud.gkehub.configmanagement.v1.DeploymentState.forNumber(rootReconciler_);
      return result == null
          ? com.google.cloud.gkehub.configmanagement.v1.DeploymentState.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Deployment state of root-reconciler
     * </pre>
     *
     * <code>.google.cloud.gkehub.configmanagement.v1.DeploymentState root_reconciler = 6;</code>
     *
     * @param value The rootReconciler to set.
     * @return This builder for chaining.
     */
    public Builder setRootReconciler(
        com.google.cloud.gkehub.configmanagement.v1.DeploymentState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000020;
      rootReconciler_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deployment state of root-reconciler
     * </pre>
     *
     * <code>.google.cloud.gkehub.configmanagement.v1.DeploymentState root_reconciler = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRootReconciler() {
      bitField0_ = (bitField0_ & ~0x00000020);
      rootReconciler_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.gkehub.configmanagement.v1.ConfigSyncDeploymentState)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.gkehub.configmanagement.v1.ConfigSyncDeploymentState)
  private static final com.google.cloud.gkehub.configmanagement.v1.ConfigSyncDeploymentState
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.gkehub.configmanagement.v1.ConfigSyncDeploymentState();
  }

  public static com.google.cloud.gkehub.configmanagement.v1.ConfigSyncDeploymentState
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ConfigSyncDeploymentState> PARSER =
      new com.google.protobuf.AbstractParser<ConfigSyncDeploymentState>() {
        @java.lang.Override
        public ConfigSyncDeploymentState parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ConfigSyncDeploymentState> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ConfigSyncDeploymentState> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.gkehub.configmanagement.v1.ConfigSyncDeploymentState
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
