/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/gkehub/v1/configmanagement/configmanagement.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.gkehub.configmanagement.v1;

/**
 *
 *
 * <pre>
 * Git repo configuration for a single cluster.
 * </pre>
 *
 * Protobuf type {@code google.cloud.gkehub.configmanagement.v1.GitConfig}
 */
public final class GitConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.gkehub.configmanagement.v1.GitConfig)
    GitConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use GitConfig.newBuilder() to construct.
  private GitConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private GitConfig() {
    syncRepo_ = "";
    syncBranch_ = "";
    policyDir_ = "";
    syncRev_ = "";
    secretType_ = "";
    httpsProxy_ = "";
    gcpServiceAccountEmail_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new GitConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.gkehub.configmanagement.v1.ConfigManagementProto
        .internal_static_google_cloud_gkehub_configmanagement_v1_GitConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.gkehub.configmanagement.v1.ConfigManagementProto
        .internal_static_google_cloud_gkehub_configmanagement_v1_GitConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.gkehub.configmanagement.v1.GitConfig.class,
            com.google.cloud.gkehub.configmanagement.v1.GitConfig.Builder.class);
  }

  public static final int SYNC_REPO_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object syncRepo_ = "";
  /**
   *
   *
   * <pre>
   * The URL of the Git repository to use as the source of truth.
   * </pre>
   *
   * <code>string sync_repo = 1;</code>
   *
   * @return The syncRepo.
   */
  @java.lang.Override
  public java.lang.String getSyncRepo() {
    java.lang.Object ref = syncRepo_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      syncRepo_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The URL of the Git repository to use as the source of truth.
   * </pre>
   *
   * <code>string sync_repo = 1;</code>
   *
   * @return The bytes for syncRepo.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSyncRepoBytes() {
    java.lang.Object ref = syncRepo_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      syncRepo_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SYNC_BRANCH_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object syncBranch_ = "";
  /**
   *
   *
   * <pre>
   * The branch of the repository to sync from. Default: master.
   * </pre>
   *
   * <code>string sync_branch = 2;</code>
   *
   * @return The syncBranch.
   */
  @java.lang.Override
  public java.lang.String getSyncBranch() {
    java.lang.Object ref = syncBranch_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      syncBranch_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The branch of the repository to sync from. Default: master.
   * </pre>
   *
   * <code>string sync_branch = 2;</code>
   *
   * @return The bytes for syncBranch.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSyncBranchBytes() {
    java.lang.Object ref = syncBranch_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      syncBranch_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int POLICY_DIR_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object policyDir_ = "";
  /**
   *
   *
   * <pre>
   * The path within the Git repository that represents the top level of the
   * repo to sync. Default: the root directory of the repository.
   * </pre>
   *
   * <code>string policy_dir = 3;</code>
   *
   * @return The policyDir.
   */
  @java.lang.Override
  public java.lang.String getPolicyDir() {
    java.lang.Object ref = policyDir_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      policyDir_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The path within the Git repository that represents the top level of the
   * repo to sync. Default: the root directory of the repository.
   * </pre>
   *
   * <code>string policy_dir = 3;</code>
   *
   * @return The bytes for policyDir.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPolicyDirBytes() {
    java.lang.Object ref = policyDir_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      policyDir_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SYNC_WAIT_SECS_FIELD_NUMBER = 4;
  private long syncWaitSecs_ = 0L;
  /**
   *
   *
   * <pre>
   * Period in seconds between consecutive syncs. Default: 15.
   * </pre>
   *
   * <code>int64 sync_wait_secs = 4;</code>
   *
   * @return The syncWaitSecs.
   */
  @java.lang.Override
  public long getSyncWaitSecs() {
    return syncWaitSecs_;
  }

  public static final int SYNC_REV_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object syncRev_ = "";
  /**
   *
   *
   * <pre>
   * Git revision (tag or hash) to check out. Default HEAD.
   * </pre>
   *
   * <code>string sync_rev = 5;</code>
   *
   * @return The syncRev.
   */
  @java.lang.Override
  public java.lang.String getSyncRev() {
    java.lang.Object ref = syncRev_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      syncRev_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Git revision (tag or hash) to check out. Default HEAD.
   * </pre>
   *
   * <code>string sync_rev = 5;</code>
   *
   * @return The bytes for syncRev.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSyncRevBytes() {
    java.lang.Object ref = syncRev_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      syncRev_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SECRET_TYPE_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object secretType_ = "";
  /**
   *
   *
   * <pre>
   * Type of secret configured for access to the Git repo.
   * </pre>
   *
   * <code>string secret_type = 6;</code>
   *
   * @return The secretType.
   */
  @java.lang.Override
  public java.lang.String getSecretType() {
    java.lang.Object ref = secretType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      secretType_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Type of secret configured for access to the Git repo.
   * </pre>
   *
   * <code>string secret_type = 6;</code>
   *
   * @return The bytes for secretType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSecretTypeBytes() {
    java.lang.Object ref = secretType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      secretType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int HTTPS_PROXY_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object httpsProxy_ = "";
  /**
   *
   *
   * <pre>
   * URL for the HTTPS proxy to be used when communicating with the Git repo.
   * </pre>
   *
   * <code>string https_proxy = 7;</code>
   *
   * @return The httpsProxy.
   */
  @java.lang.Override
  public java.lang.String getHttpsProxy() {
    java.lang.Object ref = httpsProxy_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      httpsProxy_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * URL for the HTTPS proxy to be used when communicating with the Git repo.
   * </pre>
   *
   * <code>string https_proxy = 7;</code>
   *
   * @return The bytes for httpsProxy.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getHttpsProxyBytes() {
    java.lang.Object ref = httpsProxy_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      httpsProxy_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int GCP_SERVICE_ACCOUNT_EMAIL_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object gcpServiceAccountEmail_ = "";
  /**
   *
   *
   * <pre>
   * The GCP Service Account Email used for auth when secret_type is
   * gcpServiceAccount.
   * </pre>
   *
   * <code>string gcp_service_account_email = 8;</code>
   *
   * @return The gcpServiceAccountEmail.
   */
  @java.lang.Override
  public java.lang.String getGcpServiceAccountEmail() {
    java.lang.Object ref = gcpServiceAccountEmail_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      gcpServiceAccountEmail_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The GCP Service Account Email used for auth when secret_type is
   * gcpServiceAccount.
   * </pre>
   *
   * <code>string gcp_service_account_email = 8;</code>
   *
   * @return The bytes for gcpServiceAccountEmail.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getGcpServiceAccountEmailBytes() {
    java.lang.Object ref = gcpServiceAccountEmail_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      gcpServiceAccountEmail_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(syncRepo_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, syncRepo_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(syncBranch_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, syncBranch_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(policyDir_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, policyDir_);
    }
    if (syncWaitSecs_ != 0L) {
      output.writeInt64(4, syncWaitSecs_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(syncRev_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, syncRev_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(secretType_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, secretType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(httpsProxy_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, httpsProxy_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(gcpServiceAccountEmail_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, gcpServiceAccountEmail_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(syncRepo_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, syncRepo_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(syncBranch_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, syncBranch_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(policyDir_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, policyDir_);
    }
    if (syncWaitSecs_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(4, syncWaitSecs_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(syncRev_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, syncRev_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(secretType_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, secretType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(httpsProxy_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, httpsProxy_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(gcpServiceAccountEmail_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, gcpServiceAccountEmail_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.gkehub.configmanagement.v1.GitConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.gkehub.configmanagement.v1.GitConfig other =
        (com.google.cloud.gkehub.configmanagement.v1.GitConfig) obj;

    if (!getSyncRepo().equals(other.getSyncRepo())) return false;
    if (!getSyncBranch().equals(other.getSyncBranch())) return false;
    if (!getPolicyDir().equals(other.getPolicyDir())) return false;
    if (getSyncWaitSecs() != other.getSyncWaitSecs()) return false;
    if (!getSyncRev().equals(other.getSyncRev())) return false;
    if (!getSecretType().equals(other.getSecretType())) return false;
    if (!getHttpsProxy().equals(other.getHttpsProxy())) return false;
    if (!getGcpServiceAccountEmail().equals(other.getGcpServiceAccountEmail())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SYNC_REPO_FIELD_NUMBER;
    hash = (53 * hash) + getSyncRepo().hashCode();
    hash = (37 * hash) + SYNC_BRANCH_FIELD_NUMBER;
    hash = (53 * hash) + getSyncBranch().hashCode();
    hash = (37 * hash) + POLICY_DIR_FIELD_NUMBER;
    hash = (53 * hash) + getPolicyDir().hashCode();
    hash = (37 * hash) + SYNC_WAIT_SECS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getSyncWaitSecs());
    hash = (37 * hash) + SYNC_REV_FIELD_NUMBER;
    hash = (53 * hash) + getSyncRev().hashCode();
    hash = (37 * hash) + SECRET_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getSecretType().hashCode();
    hash = (37 * hash) + HTTPS_PROXY_FIELD_NUMBER;
    hash = (53 * hash) + getHttpsProxy().hashCode();
    hash = (37 * hash) + GCP_SERVICE_ACCOUNT_EMAIL_FIELD_NUMBER;
    hash = (53 * hash) + getGcpServiceAccountEmail().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.gkehub.configmanagement.v1.GitConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gkehub.configmanagement.v1.GitConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gkehub.configmanagement.v1.GitConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gkehub.configmanagement.v1.GitConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gkehub.configmanagement.v1.GitConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gkehub.configmanagement.v1.GitConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gkehub.configmanagement.v1.GitConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.gkehub.configmanagement.v1.GitConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.gkehub.configmanagement.v1.GitConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.gkehub.configmanagement.v1.GitConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.gkehub.configmanagement.v1.GitConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.gkehub.configmanagement.v1.GitConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.gkehub.configmanagement.v1.GitConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Git repo configuration for a single cluster.
   * </pre>
   *
   * Protobuf type {@code google.cloud.gkehub.configmanagement.v1.GitConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.gkehub.configmanagement.v1.GitConfig)
      com.google.cloud.gkehub.configmanagement.v1.GitConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.gkehub.configmanagement.v1.ConfigManagementProto
          .internal_static_google_cloud_gkehub_configmanagement_v1_GitConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.gkehub.configmanagement.v1.ConfigManagementProto
          .internal_static_google_cloud_gkehub_configmanagement_v1_GitConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.gkehub.configmanagement.v1.GitConfig.class,
              com.google.cloud.gkehub.configmanagement.v1.GitConfig.Builder.class);
    }

    // Construct using com.google.cloud.gkehub.configmanagement.v1.GitConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      syncRepo_ = "";
      syncBranch_ = "";
      policyDir_ = "";
      syncWaitSecs_ = 0L;
      syncRev_ = "";
      secretType_ = "";
      httpsProxy_ = "";
      gcpServiceAccountEmail_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.gkehub.configmanagement.v1.ConfigManagementProto
          .internal_static_google_cloud_gkehub_configmanagement_v1_GitConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.gkehub.configmanagement.v1.GitConfig getDefaultInstanceForType() {
      return com.google.cloud.gkehub.configmanagement.v1.GitConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.gkehub.configmanagement.v1.GitConfig build() {
      com.google.cloud.gkehub.configmanagement.v1.GitConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.gkehub.configmanagement.v1.GitConfig buildPartial() {
      com.google.cloud.gkehub.configmanagement.v1.GitConfig result =
          new com.google.cloud.gkehub.configmanagement.v1.GitConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.gkehub.configmanagement.v1.GitConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.syncRepo_ = syncRepo_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.syncBranch_ = syncBranch_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.policyDir_ = policyDir_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.syncWaitSecs_ = syncWaitSecs_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.syncRev_ = syncRev_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.secretType_ = secretType_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.httpsProxy_ = httpsProxy_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.gcpServiceAccountEmail_ = gcpServiceAccountEmail_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.gkehub.configmanagement.v1.GitConfig) {
        return mergeFrom((com.google.cloud.gkehub.configmanagement.v1.GitConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.gkehub.configmanagement.v1.GitConfig other) {
      if (other == com.google.cloud.gkehub.configmanagement.v1.GitConfig.getDefaultInstance())
        return this;
      if (!other.getSyncRepo().isEmpty()) {
        syncRepo_ = other.syncRepo_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getSyncBranch().isEmpty()) {
        syncBranch_ = other.syncBranch_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getPolicyDir().isEmpty()) {
        policyDir_ = other.policyDir_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.getSyncWaitSecs() != 0L) {
        setSyncWaitSecs(other.getSyncWaitSecs());
      }
      if (!other.getSyncRev().isEmpty()) {
        syncRev_ = other.syncRev_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.getSecretType().isEmpty()) {
        secretType_ = other.secretType_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (!other.getHttpsProxy().isEmpty()) {
        httpsProxy_ = other.httpsProxy_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (!other.getGcpServiceAccountEmail().isEmpty()) {
        gcpServiceAccountEmail_ = other.gcpServiceAccountEmail_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                syncRepo_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                syncBranch_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                policyDir_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 32:
              {
                syncWaitSecs_ = input.readInt64();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 42:
              {
                syncRev_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                secretType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                httpsProxy_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                gcpServiceAccountEmail_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object syncRepo_ = "";
    /**
     *
     *
     * <pre>
     * The URL of the Git repository to use as the source of truth.
     * </pre>
     *
     * <code>string sync_repo = 1;</code>
     *
     * @return The syncRepo.
     */
    public java.lang.String getSyncRepo() {
      java.lang.Object ref = syncRepo_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        syncRepo_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URL of the Git repository to use as the source of truth.
     * </pre>
     *
     * <code>string sync_repo = 1;</code>
     *
     * @return The bytes for syncRepo.
     */
    public com.google.protobuf.ByteString getSyncRepoBytes() {
      java.lang.Object ref = syncRepo_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        syncRepo_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URL of the Git repository to use as the source of truth.
     * </pre>
     *
     * <code>string sync_repo = 1;</code>
     *
     * @param value The syncRepo to set.
     * @return This builder for chaining.
     */
    public Builder setSyncRepo(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      syncRepo_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URL of the Git repository to use as the source of truth.
     * </pre>
     *
     * <code>string sync_repo = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSyncRepo() {
      syncRepo_ = getDefaultInstance().getSyncRepo();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URL of the Git repository to use as the source of truth.
     * </pre>
     *
     * <code>string sync_repo = 1;</code>
     *
     * @param value The bytes for syncRepo to set.
     * @return This builder for chaining.
     */
    public Builder setSyncRepoBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      syncRepo_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object syncBranch_ = "";
    /**
     *
     *
     * <pre>
     * The branch of the repository to sync from. Default: master.
     * </pre>
     *
     * <code>string sync_branch = 2;</code>
     *
     * @return The syncBranch.
     */
    public java.lang.String getSyncBranch() {
      java.lang.Object ref = syncBranch_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        syncBranch_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The branch of the repository to sync from. Default: master.
     * </pre>
     *
     * <code>string sync_branch = 2;</code>
     *
     * @return The bytes for syncBranch.
     */
    public com.google.protobuf.ByteString getSyncBranchBytes() {
      java.lang.Object ref = syncBranch_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        syncBranch_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The branch of the repository to sync from. Default: master.
     * </pre>
     *
     * <code>string sync_branch = 2;</code>
     *
     * @param value The syncBranch to set.
     * @return This builder for chaining.
     */
    public Builder setSyncBranch(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      syncBranch_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The branch of the repository to sync from. Default: master.
     * </pre>
     *
     * <code>string sync_branch = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSyncBranch() {
      syncBranch_ = getDefaultInstance().getSyncBranch();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The branch of the repository to sync from. Default: master.
     * </pre>
     *
     * <code>string sync_branch = 2;</code>
     *
     * @param value The bytes for syncBranch to set.
     * @return This builder for chaining.
     */
    public Builder setSyncBranchBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      syncBranch_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object policyDir_ = "";
    /**
     *
     *
     * <pre>
     * The path within the Git repository that represents the top level of the
     * repo to sync. Default: the root directory of the repository.
     * </pre>
     *
     * <code>string policy_dir = 3;</code>
     *
     * @return The policyDir.
     */
    public java.lang.String getPolicyDir() {
      java.lang.Object ref = policyDir_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        policyDir_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The path within the Git repository that represents the top level of the
     * repo to sync. Default: the root directory of the repository.
     * </pre>
     *
     * <code>string policy_dir = 3;</code>
     *
     * @return The bytes for policyDir.
     */
    public com.google.protobuf.ByteString getPolicyDirBytes() {
      java.lang.Object ref = policyDir_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        policyDir_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The path within the Git repository that represents the top level of the
     * repo to sync. Default: the root directory of the repository.
     * </pre>
     *
     * <code>string policy_dir = 3;</code>
     *
     * @param value The policyDir to set.
     * @return This builder for chaining.
     */
    public Builder setPolicyDir(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      policyDir_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The path within the Git repository that represents the top level of the
     * repo to sync. Default: the root directory of the repository.
     * </pre>
     *
     * <code>string policy_dir = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPolicyDir() {
      policyDir_ = getDefaultInstance().getPolicyDir();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The path within the Git repository that represents the top level of the
     * repo to sync. Default: the root directory of the repository.
     * </pre>
     *
     * <code>string policy_dir = 3;</code>
     *
     * @param value The bytes for policyDir to set.
     * @return This builder for chaining.
     */
    public Builder setPolicyDirBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      policyDir_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private long syncWaitSecs_;
    /**
     *
     *
     * <pre>
     * Period in seconds between consecutive syncs. Default: 15.
     * </pre>
     *
     * <code>int64 sync_wait_secs = 4;</code>
     *
     * @return The syncWaitSecs.
     */
    @java.lang.Override
    public long getSyncWaitSecs() {
      return syncWaitSecs_;
    }
    /**
     *
     *
     * <pre>
     * Period in seconds between consecutive syncs. Default: 15.
     * </pre>
     *
     * <code>int64 sync_wait_secs = 4;</code>
     *
     * @param value The syncWaitSecs to set.
     * @return This builder for chaining.
     */
    public Builder setSyncWaitSecs(long value) {

      syncWaitSecs_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Period in seconds between consecutive syncs. Default: 15.
     * </pre>
     *
     * <code>int64 sync_wait_secs = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSyncWaitSecs() {
      bitField0_ = (bitField0_ & ~0x00000008);
      syncWaitSecs_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object syncRev_ = "";
    /**
     *
     *
     * <pre>
     * Git revision (tag or hash) to check out. Default HEAD.
     * </pre>
     *
     * <code>string sync_rev = 5;</code>
     *
     * @return The syncRev.
     */
    public java.lang.String getSyncRev() {
      java.lang.Object ref = syncRev_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        syncRev_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Git revision (tag or hash) to check out. Default HEAD.
     * </pre>
     *
     * <code>string sync_rev = 5;</code>
     *
     * @return The bytes for syncRev.
     */
    public com.google.protobuf.ByteString getSyncRevBytes() {
      java.lang.Object ref = syncRev_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        syncRev_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Git revision (tag or hash) to check out. Default HEAD.
     * </pre>
     *
     * <code>string sync_rev = 5;</code>
     *
     * @param value The syncRev to set.
     * @return This builder for chaining.
     */
    public Builder setSyncRev(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      syncRev_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Git revision (tag or hash) to check out. Default HEAD.
     * </pre>
     *
     * <code>string sync_rev = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSyncRev() {
      syncRev_ = getDefaultInstance().getSyncRev();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Git revision (tag or hash) to check out. Default HEAD.
     * </pre>
     *
     * <code>string sync_rev = 5;</code>
     *
     * @param value The bytes for syncRev to set.
     * @return This builder for chaining.
     */
    public Builder setSyncRevBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      syncRev_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object secretType_ = "";
    /**
     *
     *
     * <pre>
     * Type of secret configured for access to the Git repo.
     * </pre>
     *
     * <code>string secret_type = 6;</code>
     *
     * @return The secretType.
     */
    public java.lang.String getSecretType() {
      java.lang.Object ref = secretType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        secretType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Type of secret configured for access to the Git repo.
     * </pre>
     *
     * <code>string secret_type = 6;</code>
     *
     * @return The bytes for secretType.
     */
    public com.google.protobuf.ByteString getSecretTypeBytes() {
      java.lang.Object ref = secretType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        secretType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Type of secret configured for access to the Git repo.
     * </pre>
     *
     * <code>string secret_type = 6;</code>
     *
     * @param value The secretType to set.
     * @return This builder for chaining.
     */
    public Builder setSecretType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      secretType_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type of secret configured for access to the Git repo.
     * </pre>
     *
     * <code>string secret_type = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSecretType() {
      secretType_ = getDefaultInstance().getSecretType();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type of secret configured for access to the Git repo.
     * </pre>
     *
     * <code>string secret_type = 6;</code>
     *
     * @param value The bytes for secretType to set.
     * @return This builder for chaining.
     */
    public Builder setSecretTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      secretType_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object httpsProxy_ = "";
    /**
     *
     *
     * <pre>
     * URL for the HTTPS proxy to be used when communicating with the Git repo.
     * </pre>
     *
     * <code>string https_proxy = 7;</code>
     *
     * @return The httpsProxy.
     */
    public java.lang.String getHttpsProxy() {
      java.lang.Object ref = httpsProxy_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        httpsProxy_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URL for the HTTPS proxy to be used when communicating with the Git repo.
     * </pre>
     *
     * <code>string https_proxy = 7;</code>
     *
     * @return The bytes for httpsProxy.
     */
    public com.google.protobuf.ByteString getHttpsProxyBytes() {
      java.lang.Object ref = httpsProxy_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        httpsProxy_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URL for the HTTPS proxy to be used when communicating with the Git repo.
     * </pre>
     *
     * <code>string https_proxy = 7;</code>
     *
     * @param value The httpsProxy to set.
     * @return This builder for chaining.
     */
    public Builder setHttpsProxy(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      httpsProxy_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URL for the HTTPS proxy to be used when communicating with the Git repo.
     * </pre>
     *
     * <code>string https_proxy = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHttpsProxy() {
      httpsProxy_ = getDefaultInstance().getHttpsProxy();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URL for the HTTPS proxy to be used when communicating with the Git repo.
     * </pre>
     *
     * <code>string https_proxy = 7;</code>
     *
     * @param value The bytes for httpsProxy to set.
     * @return This builder for chaining.
     */
    public Builder setHttpsProxyBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      httpsProxy_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private java.lang.Object gcpServiceAccountEmail_ = "";
    /**
     *
     *
     * <pre>
     * The GCP Service Account Email used for auth when secret_type is
     * gcpServiceAccount.
     * </pre>
     *
     * <code>string gcp_service_account_email = 8;</code>
     *
     * @return The gcpServiceAccountEmail.
     */
    public java.lang.String getGcpServiceAccountEmail() {
      java.lang.Object ref = gcpServiceAccountEmail_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        gcpServiceAccountEmail_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The GCP Service Account Email used for auth when secret_type is
     * gcpServiceAccount.
     * </pre>
     *
     * <code>string gcp_service_account_email = 8;</code>
     *
     * @return The bytes for gcpServiceAccountEmail.
     */
    public com.google.protobuf.ByteString getGcpServiceAccountEmailBytes() {
      java.lang.Object ref = gcpServiceAccountEmail_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        gcpServiceAccountEmail_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The GCP Service Account Email used for auth when secret_type is
     * gcpServiceAccount.
     * </pre>
     *
     * <code>string gcp_service_account_email = 8;</code>
     *
     * @param value The gcpServiceAccountEmail to set.
     * @return This builder for chaining.
     */
    public Builder setGcpServiceAccountEmail(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      gcpServiceAccountEmail_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The GCP Service Account Email used for auth when secret_type is
     * gcpServiceAccount.
     * </pre>
     *
     * <code>string gcp_service_account_email = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearGcpServiceAccountEmail() {
      gcpServiceAccountEmail_ = getDefaultInstance().getGcpServiceAccountEmail();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The GCP Service Account Email used for auth when secret_type is
     * gcpServiceAccount.
     * </pre>
     *
     * <code>string gcp_service_account_email = 8;</code>
     *
     * @param value The bytes for gcpServiceAccountEmail to set.
     * @return This builder for chaining.
     */
    public Builder setGcpServiceAccountEmailBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      gcpServiceAccountEmail_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.gkehub.configmanagement.v1.GitConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.gkehub.configmanagement.v1.GitConfig)
  private static final com.google.cloud.gkehub.configmanagement.v1.GitConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.gkehub.configmanagement.v1.GitConfig();
  }

  public static com.google.cloud.gkehub.configmanagement.v1.GitConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<GitConfig> PARSER =
      new com.google.protobuf.AbstractParser<GitConfig>() {
        @java.lang.Override
        public GitConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<GitConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<GitConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.gkehub.configmanagement.v1.GitConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
