/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/gkehub/v1/configmanagement/configmanagement.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.gkehub.configmanagement.v1;

/**
 *
 *
 * <pre>
 * **Anthos Config Management**: State for a single cluster.
 * </pre>
 *
 * Protobuf type {@code google.cloud.gkehub.configmanagement.v1.MembershipState}
 */
public final class MembershipState extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.gkehub.configmanagement.v1.MembershipState)
    MembershipStateOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use MembershipState.newBuilder() to construct.
  private MembershipState(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private MembershipState() {
    clusterName_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new MembershipState();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.gkehub.configmanagement.v1.ConfigManagementProto
        .internal_static_google_cloud_gkehub_configmanagement_v1_MembershipState_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.gkehub.configmanagement.v1.ConfigManagementProto
        .internal_static_google_cloud_gkehub_configmanagement_v1_MembershipState_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.gkehub.configmanagement.v1.MembershipState.class,
            com.google.cloud.gkehub.configmanagement.v1.MembershipState.Builder.class);
  }

  private int bitField0_;
  public static final int CLUSTER_NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object clusterName_ = "";
  /**
   *
   *
   * <pre>
   * The user-defined name for the cluster used by ClusterSelectors to group
   * clusters together. This should match Membership's membership_name,
   * unless the user installed ACM on the cluster manually prior to enabling
   * the ACM hub feature.
   * Unique within a Anthos Config Management installation.
   * </pre>
   *
   * <code>string cluster_name = 1;</code>
   *
   * @return The clusterName.
   */
  @java.lang.Override
  public java.lang.String getClusterName() {
    java.lang.Object ref = clusterName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      clusterName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The user-defined name for the cluster used by ClusterSelectors to group
   * clusters together. This should match Membership's membership_name,
   * unless the user installed ACM on the cluster manually prior to enabling
   * the ACM hub feature.
   * Unique within a Anthos Config Management installation.
   * </pre>
   *
   * <code>string cluster_name = 1;</code>
   *
   * @return The bytes for clusterName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getClusterNameBytes() {
    java.lang.Object ref = clusterName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      clusterName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MEMBERSHIP_SPEC_FIELD_NUMBER = 2;
  private com.google.cloud.gkehub.configmanagement.v1.MembershipSpec membershipSpec_;
  /**
   *
   *
   * <pre>
   * Membership configuration in the cluster. This represents the actual state
   * in the cluster, while the MembershipSpec in the FeatureSpec represents
   * the intended state
   * </pre>
   *
   * <code>.google.cloud.gkehub.configmanagement.v1.MembershipSpec membership_spec = 2;</code>
   *
   * @return Whether the membershipSpec field is set.
   */
  @java.lang.Override
  public boolean hasMembershipSpec() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Membership configuration in the cluster. This represents the actual state
   * in the cluster, while the MembershipSpec in the FeatureSpec represents
   * the intended state
   * </pre>
   *
   * <code>.google.cloud.gkehub.configmanagement.v1.MembershipSpec membership_spec = 2;</code>
   *
   * @return The membershipSpec.
   */
  @java.lang.Override
  public com.google.cloud.gkehub.configmanagement.v1.MembershipSpec getMembershipSpec() {
    return membershipSpec_ == null
        ? com.google.cloud.gkehub.configmanagement.v1.MembershipSpec.getDefaultInstance()
        : membershipSpec_;
  }
  /**
   *
   *
   * <pre>
   * Membership configuration in the cluster. This represents the actual state
   * in the cluster, while the MembershipSpec in the FeatureSpec represents
   * the intended state
   * </pre>
   *
   * <code>.google.cloud.gkehub.configmanagement.v1.MembershipSpec membership_spec = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.gkehub.configmanagement.v1.MembershipSpecOrBuilder
      getMembershipSpecOrBuilder() {
    return membershipSpec_ == null
        ? com.google.cloud.gkehub.configmanagement.v1.MembershipSpec.getDefaultInstance()
        : membershipSpec_;
  }

  public static final int OPERATOR_STATE_FIELD_NUMBER = 3;
  private com.google.cloud.gkehub.configmanagement.v1.OperatorState operatorState_;
  /**
   *
   *
   * <pre>
   * Current install status of ACM's Operator
   * </pre>
   *
   * <code>.google.cloud.gkehub.configmanagement.v1.OperatorState operator_state = 3;</code>
   *
   * @return Whether the operatorState field is set.
   */
  @java.lang.Override
  public boolean hasOperatorState() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Current install status of ACM's Operator
   * </pre>
   *
   * <code>.google.cloud.gkehub.configmanagement.v1.OperatorState operator_state = 3;</code>
   *
   * @return The operatorState.
   */
  @java.lang.Override
  public com.google.cloud.gkehub.configmanagement.v1.OperatorState getOperatorState() {
    return operatorState_ == null
        ? com.google.cloud.gkehub.configmanagement.v1.OperatorState.getDefaultInstance()
        : operatorState_;
  }
  /**
   *
   *
   * <pre>
   * Current install status of ACM's Operator
   * </pre>
   *
   * <code>.google.cloud.gkehub.configmanagement.v1.OperatorState operator_state = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.gkehub.configmanagement.v1.OperatorStateOrBuilder
      getOperatorStateOrBuilder() {
    return operatorState_ == null
        ? com.google.cloud.gkehub.configmanagement.v1.OperatorState.getDefaultInstance()
        : operatorState_;
  }

  public static final int CONFIG_SYNC_STATE_FIELD_NUMBER = 4;
  private com.google.cloud.gkehub.configmanagement.v1.ConfigSyncState configSyncState_;
  /**
   *
   *
   * <pre>
   * Current sync status
   * </pre>
   *
   * <code>.google.cloud.gkehub.configmanagement.v1.ConfigSyncState config_sync_state = 4;</code>
   *
   * @return Whether the configSyncState field is set.
   */
  @java.lang.Override
  public boolean hasConfigSyncState() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Current sync status
   * </pre>
   *
   * <code>.google.cloud.gkehub.configmanagement.v1.ConfigSyncState config_sync_state = 4;</code>
   *
   * @return The configSyncState.
   */
  @java.lang.Override
  public com.google.cloud.gkehub.configmanagement.v1.ConfigSyncState getConfigSyncState() {
    return configSyncState_ == null
        ? com.google.cloud.gkehub.configmanagement.v1.ConfigSyncState.getDefaultInstance()
        : configSyncState_;
  }
  /**
   *
   *
   * <pre>
   * Current sync status
   * </pre>
   *
   * <code>.google.cloud.gkehub.configmanagement.v1.ConfigSyncState config_sync_state = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.gkehub.configmanagement.v1.ConfigSyncStateOrBuilder
      getConfigSyncStateOrBuilder() {
    return configSyncState_ == null
        ? com.google.cloud.gkehub.configmanagement.v1.ConfigSyncState.getDefaultInstance()
        : configSyncState_;
  }

  public static final int POLICY_CONTROLLER_STATE_FIELD_NUMBER = 5;
  private com.google.cloud.gkehub.configmanagement.v1.PolicyControllerState policyControllerState_;
  /**
   *
   *
   * <pre>
   * PolicyController status
   * </pre>
   *
   * <code>
   * .google.cloud.gkehub.configmanagement.v1.PolicyControllerState policy_controller_state = 5;
   * </code>
   *
   * @return Whether the policyControllerState field is set.
   */
  @java.lang.Override
  public boolean hasPolicyControllerState() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * PolicyController status
   * </pre>
   *
   * <code>
   * .google.cloud.gkehub.configmanagement.v1.PolicyControllerState policy_controller_state = 5;
   * </code>
   *
   * @return The policyControllerState.
   */
  @java.lang.Override
  public com.google.cloud.gkehub.configmanagement.v1.PolicyControllerState
      getPolicyControllerState() {
    return policyControllerState_ == null
        ? com.google.cloud.gkehub.configmanagement.v1.PolicyControllerState.getDefaultInstance()
        : policyControllerState_;
  }
  /**
   *
   *
   * <pre>
   * PolicyController status
   * </pre>
   *
   * <code>
   * .google.cloud.gkehub.configmanagement.v1.PolicyControllerState policy_controller_state = 5;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.gkehub.configmanagement.v1.PolicyControllerStateOrBuilder
      getPolicyControllerStateOrBuilder() {
    return policyControllerState_ == null
        ? com.google.cloud.gkehub.configmanagement.v1.PolicyControllerState.getDefaultInstance()
        : policyControllerState_;
  }

  public static final int HIERARCHY_CONTROLLER_STATE_FIELD_NUMBER = 7;
  private com.google.cloud.gkehub.configmanagement.v1.HierarchyControllerState
      hierarchyControllerState_;
  /**
   *
   *
   * <pre>
   * Hierarchy Controller status
   * </pre>
   *
   * <code>
   * .google.cloud.gkehub.configmanagement.v1.HierarchyControllerState hierarchy_controller_state = 7;
   * </code>
   *
   * @return Whether the hierarchyControllerState field is set.
   */
  @java.lang.Override
  public boolean hasHierarchyControllerState() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * Hierarchy Controller status
   * </pre>
   *
   * <code>
   * .google.cloud.gkehub.configmanagement.v1.HierarchyControllerState hierarchy_controller_state = 7;
   * </code>
   *
   * @return The hierarchyControllerState.
   */
  @java.lang.Override
  public com.google.cloud.gkehub.configmanagement.v1.HierarchyControllerState
      getHierarchyControllerState() {
    return hierarchyControllerState_ == null
        ? com.google.cloud.gkehub.configmanagement.v1.HierarchyControllerState.getDefaultInstance()
        : hierarchyControllerState_;
  }
  /**
   *
   *
   * <pre>
   * Hierarchy Controller status
   * </pre>
   *
   * <code>
   * .google.cloud.gkehub.configmanagement.v1.HierarchyControllerState hierarchy_controller_state = 7;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.gkehub.configmanagement.v1.HierarchyControllerStateOrBuilder
      getHierarchyControllerStateOrBuilder() {
    return hierarchyControllerState_ == null
        ? com.google.cloud.gkehub.configmanagement.v1.HierarchyControllerState.getDefaultInstance()
        : hierarchyControllerState_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clusterName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, clusterName_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getMembershipSpec());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(3, getOperatorState());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(4, getConfigSyncState());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(5, getPolicyControllerState());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(7, getHierarchyControllerState());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clusterName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, clusterName_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getMembershipSpec());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getOperatorState());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getConfigSyncState());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(5, getPolicyControllerState());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, getHierarchyControllerState());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.gkehub.configmanagement.v1.MembershipState)) {
      return super.equals(obj);
    }
    com.google.cloud.gkehub.configmanagement.v1.MembershipState other =
        (com.google.cloud.gkehub.configmanagement.v1.MembershipState) obj;

    if (!getClusterName().equals(other.getClusterName())) return false;
    if (hasMembershipSpec() != other.hasMembershipSpec()) return false;
    if (hasMembershipSpec()) {
      if (!getMembershipSpec().equals(other.getMembershipSpec())) return false;
    }
    if (hasOperatorState() != other.hasOperatorState()) return false;
    if (hasOperatorState()) {
      if (!getOperatorState().equals(other.getOperatorState())) return false;
    }
    if (hasConfigSyncState() != other.hasConfigSyncState()) return false;
    if (hasConfigSyncState()) {
      if (!getConfigSyncState().equals(other.getConfigSyncState())) return false;
    }
    if (hasPolicyControllerState() != other.hasPolicyControllerState()) return false;
    if (hasPolicyControllerState()) {
      if (!getPolicyControllerState().equals(other.getPolicyControllerState())) return false;
    }
    if (hasHierarchyControllerState() != other.hasHierarchyControllerState()) return false;
    if (hasHierarchyControllerState()) {
      if (!getHierarchyControllerState().equals(other.getHierarchyControllerState())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + CLUSTER_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getClusterName().hashCode();
    if (hasMembershipSpec()) {
      hash = (37 * hash) + MEMBERSHIP_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getMembershipSpec().hashCode();
    }
    if (hasOperatorState()) {
      hash = (37 * hash) + OPERATOR_STATE_FIELD_NUMBER;
      hash = (53 * hash) + getOperatorState().hashCode();
    }
    if (hasConfigSyncState()) {
      hash = (37 * hash) + CONFIG_SYNC_STATE_FIELD_NUMBER;
      hash = (53 * hash) + getConfigSyncState().hashCode();
    }
    if (hasPolicyControllerState()) {
      hash = (37 * hash) + POLICY_CONTROLLER_STATE_FIELD_NUMBER;
      hash = (53 * hash) + getPolicyControllerState().hashCode();
    }
    if (hasHierarchyControllerState()) {
      hash = (37 * hash) + HIERARCHY_CONTROLLER_STATE_FIELD_NUMBER;
      hash = (53 * hash) + getHierarchyControllerState().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.gkehub.configmanagement.v1.MembershipState parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gkehub.configmanagement.v1.MembershipState parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gkehub.configmanagement.v1.MembershipState parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gkehub.configmanagement.v1.MembershipState parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gkehub.configmanagement.v1.MembershipState parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gkehub.configmanagement.v1.MembershipState parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gkehub.configmanagement.v1.MembershipState parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.gkehub.configmanagement.v1.MembershipState parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.gkehub.configmanagement.v1.MembershipState parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.gkehub.configmanagement.v1.MembershipState parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.gkehub.configmanagement.v1.MembershipState parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.gkehub.configmanagement.v1.MembershipState parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.gkehub.configmanagement.v1.MembershipState prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * **Anthos Config Management**: State for a single cluster.
   * </pre>
   *
   * Protobuf type {@code google.cloud.gkehub.configmanagement.v1.MembershipState}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.gkehub.configmanagement.v1.MembershipState)
      com.google.cloud.gkehub.configmanagement.v1.MembershipStateOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.gkehub.configmanagement.v1.ConfigManagementProto
          .internal_static_google_cloud_gkehub_configmanagement_v1_MembershipState_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.gkehub.configmanagement.v1.ConfigManagementProto
          .internal_static_google_cloud_gkehub_configmanagement_v1_MembershipState_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.gkehub.configmanagement.v1.MembershipState.class,
              com.google.cloud.gkehub.configmanagement.v1.MembershipState.Builder.class);
    }

    // Construct using com.google.cloud.gkehub.configmanagement.v1.MembershipState.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getMembershipSpecFieldBuilder();
        getOperatorStateFieldBuilder();
        getConfigSyncStateFieldBuilder();
        getPolicyControllerStateFieldBuilder();
        getHierarchyControllerStateFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      clusterName_ = "";
      membershipSpec_ = null;
      if (membershipSpecBuilder_ != null) {
        membershipSpecBuilder_.dispose();
        membershipSpecBuilder_ = null;
      }
      operatorState_ = null;
      if (operatorStateBuilder_ != null) {
        operatorStateBuilder_.dispose();
        operatorStateBuilder_ = null;
      }
      configSyncState_ = null;
      if (configSyncStateBuilder_ != null) {
        configSyncStateBuilder_.dispose();
        configSyncStateBuilder_ = null;
      }
      policyControllerState_ = null;
      if (policyControllerStateBuilder_ != null) {
        policyControllerStateBuilder_.dispose();
        policyControllerStateBuilder_ = null;
      }
      hierarchyControllerState_ = null;
      if (hierarchyControllerStateBuilder_ != null) {
        hierarchyControllerStateBuilder_.dispose();
        hierarchyControllerStateBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.gkehub.configmanagement.v1.ConfigManagementProto
          .internal_static_google_cloud_gkehub_configmanagement_v1_MembershipState_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.gkehub.configmanagement.v1.MembershipState getDefaultInstanceForType() {
      return com.google.cloud.gkehub.configmanagement.v1.MembershipState.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.gkehub.configmanagement.v1.MembershipState build() {
      com.google.cloud.gkehub.configmanagement.v1.MembershipState result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.gkehub.configmanagement.v1.MembershipState buildPartial() {
      com.google.cloud.gkehub.configmanagement.v1.MembershipState result =
          new com.google.cloud.gkehub.configmanagement.v1.MembershipState(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.gkehub.configmanagement.v1.MembershipState result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.clusterName_ = clusterName_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.membershipSpec_ =
            membershipSpecBuilder_ == null ? membershipSpec_ : membershipSpecBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.operatorState_ =
            operatorStateBuilder_ == null ? operatorState_ : operatorStateBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.configSyncState_ =
            configSyncStateBuilder_ == null ? configSyncState_ : configSyncStateBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.policyControllerState_ =
            policyControllerStateBuilder_ == null
                ? policyControllerState_
                : policyControllerStateBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.hierarchyControllerState_ =
            hierarchyControllerStateBuilder_ == null
                ? hierarchyControllerState_
                : hierarchyControllerStateBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.gkehub.configmanagement.v1.MembershipState) {
        return mergeFrom((com.google.cloud.gkehub.configmanagement.v1.MembershipState) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.gkehub.configmanagement.v1.MembershipState other) {
      if (other == com.google.cloud.gkehub.configmanagement.v1.MembershipState.getDefaultInstance())
        return this;
      if (!other.getClusterName().isEmpty()) {
        clusterName_ = other.clusterName_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasMembershipSpec()) {
        mergeMembershipSpec(other.getMembershipSpec());
      }
      if (other.hasOperatorState()) {
        mergeOperatorState(other.getOperatorState());
      }
      if (other.hasConfigSyncState()) {
        mergeConfigSyncState(other.getConfigSyncState());
      }
      if (other.hasPolicyControllerState()) {
        mergePolicyControllerState(other.getPolicyControllerState());
      }
      if (other.hasHierarchyControllerState()) {
        mergeHierarchyControllerState(other.getHierarchyControllerState());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                clusterName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getMembershipSpecFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getOperatorStateFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getConfigSyncStateFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(
                    getPolicyControllerStateFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 58:
              {
                input.readMessage(
                    getHierarchyControllerStateFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object clusterName_ = "";
    /**
     *
     *
     * <pre>
     * The user-defined name for the cluster used by ClusterSelectors to group
     * clusters together. This should match Membership's membership_name,
     * unless the user installed ACM on the cluster manually prior to enabling
     * the ACM hub feature.
     * Unique within a Anthos Config Management installation.
     * </pre>
     *
     * <code>string cluster_name = 1;</code>
     *
     * @return The clusterName.
     */
    public java.lang.String getClusterName() {
      java.lang.Object ref = clusterName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        clusterName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The user-defined name for the cluster used by ClusterSelectors to group
     * clusters together. This should match Membership's membership_name,
     * unless the user installed ACM on the cluster manually prior to enabling
     * the ACM hub feature.
     * Unique within a Anthos Config Management installation.
     * </pre>
     *
     * <code>string cluster_name = 1;</code>
     *
     * @return The bytes for clusterName.
     */
    public com.google.protobuf.ByteString getClusterNameBytes() {
      java.lang.Object ref = clusterName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        clusterName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The user-defined name for the cluster used by ClusterSelectors to group
     * clusters together. This should match Membership's membership_name,
     * unless the user installed ACM on the cluster manually prior to enabling
     * the ACM hub feature.
     * Unique within a Anthos Config Management installation.
     * </pre>
     *
     * <code>string cluster_name = 1;</code>
     *
     * @param value The clusterName to set.
     * @return This builder for chaining.
     */
    public Builder setClusterName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      clusterName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The user-defined name for the cluster used by ClusterSelectors to group
     * clusters together. This should match Membership's membership_name,
     * unless the user installed ACM on the cluster manually prior to enabling
     * the ACM hub feature.
     * Unique within a Anthos Config Management installation.
     * </pre>
     *
     * <code>string cluster_name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearClusterName() {
      clusterName_ = getDefaultInstance().getClusterName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The user-defined name for the cluster used by ClusterSelectors to group
     * clusters together. This should match Membership's membership_name,
     * unless the user installed ACM on the cluster manually prior to enabling
     * the ACM hub feature.
     * Unique within a Anthos Config Management installation.
     * </pre>
     *
     * <code>string cluster_name = 1;</code>
     *
     * @param value The bytes for clusterName to set.
     * @return This builder for chaining.
     */
    public Builder setClusterNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      clusterName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.cloud.gkehub.configmanagement.v1.MembershipSpec membershipSpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gkehub.configmanagement.v1.MembershipSpec,
            com.google.cloud.gkehub.configmanagement.v1.MembershipSpec.Builder,
            com.google.cloud.gkehub.configmanagement.v1.MembershipSpecOrBuilder>
        membershipSpecBuilder_;
    /**
     *
     *
     * <pre>
     * Membership configuration in the cluster. This represents the actual state
     * in the cluster, while the MembershipSpec in the FeatureSpec represents
     * the intended state
     * </pre>
     *
     * <code>.google.cloud.gkehub.configmanagement.v1.MembershipSpec membership_spec = 2;</code>
     *
     * @return Whether the membershipSpec field is set.
     */
    public boolean hasMembershipSpec() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Membership configuration in the cluster. This represents the actual state
     * in the cluster, while the MembershipSpec in the FeatureSpec represents
     * the intended state
     * </pre>
     *
     * <code>.google.cloud.gkehub.configmanagement.v1.MembershipSpec membership_spec = 2;</code>
     *
     * @return The membershipSpec.
     */
    public com.google.cloud.gkehub.configmanagement.v1.MembershipSpec getMembershipSpec() {
      if (membershipSpecBuilder_ == null) {
        return membershipSpec_ == null
            ? com.google.cloud.gkehub.configmanagement.v1.MembershipSpec.getDefaultInstance()
            : membershipSpec_;
      } else {
        return membershipSpecBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Membership configuration in the cluster. This represents the actual state
     * in the cluster, while the MembershipSpec in the FeatureSpec represents
     * the intended state
     * </pre>
     *
     * <code>.google.cloud.gkehub.configmanagement.v1.MembershipSpec membership_spec = 2;</code>
     */
    public Builder setMembershipSpec(
        com.google.cloud.gkehub.configmanagement.v1.MembershipSpec value) {
      if (membershipSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        membershipSpec_ = value;
      } else {
        membershipSpecBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Membership configuration in the cluster. This represents the actual state
     * in the cluster, while the MembershipSpec in the FeatureSpec represents
     * the intended state
     * </pre>
     *
     * <code>.google.cloud.gkehub.configmanagement.v1.MembershipSpec membership_spec = 2;</code>
     */
    public Builder setMembershipSpec(
        com.google.cloud.gkehub.configmanagement.v1.MembershipSpec.Builder builderForValue) {
      if (membershipSpecBuilder_ == null) {
        membershipSpec_ = builderForValue.build();
      } else {
        membershipSpecBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Membership configuration in the cluster. This represents the actual state
     * in the cluster, while the MembershipSpec in the FeatureSpec represents
     * the intended state
     * </pre>
     *
     * <code>.google.cloud.gkehub.configmanagement.v1.MembershipSpec membership_spec = 2;</code>
     */
    public Builder mergeMembershipSpec(
        com.google.cloud.gkehub.configmanagement.v1.MembershipSpec value) {
      if (membershipSpecBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && membershipSpec_ != null
            && membershipSpec_
                != com.google.cloud.gkehub.configmanagement.v1.MembershipSpec
                    .getDefaultInstance()) {
          getMembershipSpecBuilder().mergeFrom(value);
        } else {
          membershipSpec_ = value;
        }
      } else {
        membershipSpecBuilder_.mergeFrom(value);
      }
      if (membershipSpec_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Membership configuration in the cluster. This represents the actual state
     * in the cluster, while the MembershipSpec in the FeatureSpec represents
     * the intended state
     * </pre>
     *
     * <code>.google.cloud.gkehub.configmanagement.v1.MembershipSpec membership_spec = 2;</code>
     */
    public Builder clearMembershipSpec() {
      bitField0_ = (bitField0_ & ~0x00000002);
      membershipSpec_ = null;
      if (membershipSpecBuilder_ != null) {
        membershipSpecBuilder_.dispose();
        membershipSpecBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Membership configuration in the cluster. This represents the actual state
     * in the cluster, while the MembershipSpec in the FeatureSpec represents
     * the intended state
     * </pre>
     *
     * <code>.google.cloud.gkehub.configmanagement.v1.MembershipSpec membership_spec = 2;</code>
     */
    public com.google.cloud.gkehub.configmanagement.v1.MembershipSpec.Builder
        getMembershipSpecBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getMembershipSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Membership configuration in the cluster. This represents the actual state
     * in the cluster, while the MembershipSpec in the FeatureSpec represents
     * the intended state
     * </pre>
     *
     * <code>.google.cloud.gkehub.configmanagement.v1.MembershipSpec membership_spec = 2;</code>
     */
    public com.google.cloud.gkehub.configmanagement.v1.MembershipSpecOrBuilder
        getMembershipSpecOrBuilder() {
      if (membershipSpecBuilder_ != null) {
        return membershipSpecBuilder_.getMessageOrBuilder();
      } else {
        return membershipSpec_ == null
            ? com.google.cloud.gkehub.configmanagement.v1.MembershipSpec.getDefaultInstance()
            : membershipSpec_;
      }
    }
    /**
     *
     *
     * <pre>
     * Membership configuration in the cluster. This represents the actual state
     * in the cluster, while the MembershipSpec in the FeatureSpec represents
     * the intended state
     * </pre>
     *
     * <code>.google.cloud.gkehub.configmanagement.v1.MembershipSpec membership_spec = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gkehub.configmanagement.v1.MembershipSpec,
            com.google.cloud.gkehub.configmanagement.v1.MembershipSpec.Builder,
            com.google.cloud.gkehub.configmanagement.v1.MembershipSpecOrBuilder>
        getMembershipSpecFieldBuilder() {
      if (membershipSpecBuilder_ == null) {
        membershipSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.gkehub.configmanagement.v1.MembershipSpec,
                com.google.cloud.gkehub.configmanagement.v1.MembershipSpec.Builder,
                com.google.cloud.gkehub.configmanagement.v1.MembershipSpecOrBuilder>(
                getMembershipSpec(), getParentForChildren(), isClean());
        membershipSpec_ = null;
      }
      return membershipSpecBuilder_;
    }

    private com.google.cloud.gkehub.configmanagement.v1.OperatorState operatorState_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gkehub.configmanagement.v1.OperatorState,
            com.google.cloud.gkehub.configmanagement.v1.OperatorState.Builder,
            com.google.cloud.gkehub.configmanagement.v1.OperatorStateOrBuilder>
        operatorStateBuilder_;
    /**
     *
     *
     * <pre>
     * Current install status of ACM's Operator
     * </pre>
     *
     * <code>.google.cloud.gkehub.configmanagement.v1.OperatorState operator_state = 3;</code>
     *
     * @return Whether the operatorState field is set.
     */
    public boolean hasOperatorState() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Current install status of ACM's Operator
     * </pre>
     *
     * <code>.google.cloud.gkehub.configmanagement.v1.OperatorState operator_state = 3;</code>
     *
     * @return The operatorState.
     */
    public com.google.cloud.gkehub.configmanagement.v1.OperatorState getOperatorState() {
      if (operatorStateBuilder_ == null) {
        return operatorState_ == null
            ? com.google.cloud.gkehub.configmanagement.v1.OperatorState.getDefaultInstance()
            : operatorState_;
      } else {
        return operatorStateBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Current install status of ACM's Operator
     * </pre>
     *
     * <code>.google.cloud.gkehub.configmanagement.v1.OperatorState operator_state = 3;</code>
     */
    public Builder setOperatorState(
        com.google.cloud.gkehub.configmanagement.v1.OperatorState value) {
      if (operatorStateBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        operatorState_ = value;
      } else {
        operatorStateBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Current install status of ACM's Operator
     * </pre>
     *
     * <code>.google.cloud.gkehub.configmanagement.v1.OperatorState operator_state = 3;</code>
     */
    public Builder setOperatorState(
        com.google.cloud.gkehub.configmanagement.v1.OperatorState.Builder builderForValue) {
      if (operatorStateBuilder_ == null) {
        operatorState_ = builderForValue.build();
      } else {
        operatorStateBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Current install status of ACM's Operator
     * </pre>
     *
     * <code>.google.cloud.gkehub.configmanagement.v1.OperatorState operator_state = 3;</code>
     */
    public Builder mergeOperatorState(
        com.google.cloud.gkehub.configmanagement.v1.OperatorState value) {
      if (operatorStateBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && operatorState_ != null
            && operatorState_
                != com.google.cloud.gkehub.configmanagement.v1.OperatorState.getDefaultInstance()) {
          getOperatorStateBuilder().mergeFrom(value);
        } else {
          operatorState_ = value;
        }
      } else {
        operatorStateBuilder_.mergeFrom(value);
      }
      if (operatorState_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Current install status of ACM's Operator
     * </pre>
     *
     * <code>.google.cloud.gkehub.configmanagement.v1.OperatorState operator_state = 3;</code>
     */
    public Builder clearOperatorState() {
      bitField0_ = (bitField0_ & ~0x00000004);
      operatorState_ = null;
      if (operatorStateBuilder_ != null) {
        operatorStateBuilder_.dispose();
        operatorStateBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Current install status of ACM's Operator
     * </pre>
     *
     * <code>.google.cloud.gkehub.configmanagement.v1.OperatorState operator_state = 3;</code>
     */
    public com.google.cloud.gkehub.configmanagement.v1.OperatorState.Builder
        getOperatorStateBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getOperatorStateFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Current install status of ACM's Operator
     * </pre>
     *
     * <code>.google.cloud.gkehub.configmanagement.v1.OperatorState operator_state = 3;</code>
     */
    public com.google.cloud.gkehub.configmanagement.v1.OperatorStateOrBuilder
        getOperatorStateOrBuilder() {
      if (operatorStateBuilder_ != null) {
        return operatorStateBuilder_.getMessageOrBuilder();
      } else {
        return operatorState_ == null
            ? com.google.cloud.gkehub.configmanagement.v1.OperatorState.getDefaultInstance()
            : operatorState_;
      }
    }
    /**
     *
     *
     * <pre>
     * Current install status of ACM's Operator
     * </pre>
     *
     * <code>.google.cloud.gkehub.configmanagement.v1.OperatorState operator_state = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gkehub.configmanagement.v1.OperatorState,
            com.google.cloud.gkehub.configmanagement.v1.OperatorState.Builder,
            com.google.cloud.gkehub.configmanagement.v1.OperatorStateOrBuilder>
        getOperatorStateFieldBuilder() {
      if (operatorStateBuilder_ == null) {
        operatorStateBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.gkehub.configmanagement.v1.OperatorState,
                com.google.cloud.gkehub.configmanagement.v1.OperatorState.Builder,
                com.google.cloud.gkehub.configmanagement.v1.OperatorStateOrBuilder>(
                getOperatorState(), getParentForChildren(), isClean());
        operatorState_ = null;
      }
      return operatorStateBuilder_;
    }

    private com.google.cloud.gkehub.configmanagement.v1.ConfigSyncState configSyncState_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gkehub.configmanagement.v1.ConfigSyncState,
            com.google.cloud.gkehub.configmanagement.v1.ConfigSyncState.Builder,
            com.google.cloud.gkehub.configmanagement.v1.ConfigSyncStateOrBuilder>
        configSyncStateBuilder_;
    /**
     *
     *
     * <pre>
     * Current sync status
     * </pre>
     *
     * <code>.google.cloud.gkehub.configmanagement.v1.ConfigSyncState config_sync_state = 4;</code>
     *
     * @return Whether the configSyncState field is set.
     */
    public boolean hasConfigSyncState() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Current sync status
     * </pre>
     *
     * <code>.google.cloud.gkehub.configmanagement.v1.ConfigSyncState config_sync_state = 4;</code>
     *
     * @return The configSyncState.
     */
    public com.google.cloud.gkehub.configmanagement.v1.ConfigSyncState getConfigSyncState() {
      if (configSyncStateBuilder_ == null) {
        return configSyncState_ == null
            ? com.google.cloud.gkehub.configmanagement.v1.ConfigSyncState.getDefaultInstance()
            : configSyncState_;
      } else {
        return configSyncStateBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Current sync status
     * </pre>
     *
     * <code>.google.cloud.gkehub.configmanagement.v1.ConfigSyncState config_sync_state = 4;</code>
     */
    public Builder setConfigSyncState(
        com.google.cloud.gkehub.configmanagement.v1.ConfigSyncState value) {
      if (configSyncStateBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        configSyncState_ = value;
      } else {
        configSyncStateBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Current sync status
     * </pre>
     *
     * <code>.google.cloud.gkehub.configmanagement.v1.ConfigSyncState config_sync_state = 4;</code>
     */
    public Builder setConfigSyncState(
        com.google.cloud.gkehub.configmanagement.v1.ConfigSyncState.Builder builderForValue) {
      if (configSyncStateBuilder_ == null) {
        configSyncState_ = builderForValue.build();
      } else {
        configSyncStateBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Current sync status
     * </pre>
     *
     * <code>.google.cloud.gkehub.configmanagement.v1.ConfigSyncState config_sync_state = 4;</code>
     */
    public Builder mergeConfigSyncState(
        com.google.cloud.gkehub.configmanagement.v1.ConfigSyncState value) {
      if (configSyncStateBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && configSyncState_ != null
            && configSyncState_
                != com.google.cloud.gkehub.configmanagement.v1.ConfigSyncState
                    .getDefaultInstance()) {
          getConfigSyncStateBuilder().mergeFrom(value);
        } else {
          configSyncState_ = value;
        }
      } else {
        configSyncStateBuilder_.mergeFrom(value);
      }
      if (configSyncState_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Current sync status
     * </pre>
     *
     * <code>.google.cloud.gkehub.configmanagement.v1.ConfigSyncState config_sync_state = 4;</code>
     */
    public Builder clearConfigSyncState() {
      bitField0_ = (bitField0_ & ~0x00000008);
      configSyncState_ = null;
      if (configSyncStateBuilder_ != null) {
        configSyncStateBuilder_.dispose();
        configSyncStateBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Current sync status
     * </pre>
     *
     * <code>.google.cloud.gkehub.configmanagement.v1.ConfigSyncState config_sync_state = 4;</code>
     */
    public com.google.cloud.gkehub.configmanagement.v1.ConfigSyncState.Builder
        getConfigSyncStateBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getConfigSyncStateFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Current sync status
     * </pre>
     *
     * <code>.google.cloud.gkehub.configmanagement.v1.ConfigSyncState config_sync_state = 4;</code>
     */
    public com.google.cloud.gkehub.configmanagement.v1.ConfigSyncStateOrBuilder
        getConfigSyncStateOrBuilder() {
      if (configSyncStateBuilder_ != null) {
        return configSyncStateBuilder_.getMessageOrBuilder();
      } else {
        return configSyncState_ == null
            ? com.google.cloud.gkehub.configmanagement.v1.ConfigSyncState.getDefaultInstance()
            : configSyncState_;
      }
    }
    /**
     *
     *
     * <pre>
     * Current sync status
     * </pre>
     *
     * <code>.google.cloud.gkehub.configmanagement.v1.ConfigSyncState config_sync_state = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gkehub.configmanagement.v1.ConfigSyncState,
            com.google.cloud.gkehub.configmanagement.v1.ConfigSyncState.Builder,
            com.google.cloud.gkehub.configmanagement.v1.ConfigSyncStateOrBuilder>
        getConfigSyncStateFieldBuilder() {
      if (configSyncStateBuilder_ == null) {
        configSyncStateBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.gkehub.configmanagement.v1.ConfigSyncState,
                com.google.cloud.gkehub.configmanagement.v1.ConfigSyncState.Builder,
                com.google.cloud.gkehub.configmanagement.v1.ConfigSyncStateOrBuilder>(
                getConfigSyncState(), getParentForChildren(), isClean());
        configSyncState_ = null;
      }
      return configSyncStateBuilder_;
    }

    private com.google.cloud.gkehub.configmanagement.v1.PolicyControllerState
        policyControllerState_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gkehub.configmanagement.v1.PolicyControllerState,
            com.google.cloud.gkehub.configmanagement.v1.PolicyControllerState.Builder,
            com.google.cloud.gkehub.configmanagement.v1.PolicyControllerStateOrBuilder>
        policyControllerStateBuilder_;
    /**
     *
     *
     * <pre>
     * PolicyController status
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.configmanagement.v1.PolicyControllerState policy_controller_state = 5;
     * </code>
     *
     * @return Whether the policyControllerState field is set.
     */
    public boolean hasPolicyControllerState() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * PolicyController status
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.configmanagement.v1.PolicyControllerState policy_controller_state = 5;
     * </code>
     *
     * @return The policyControllerState.
     */
    public com.google.cloud.gkehub.configmanagement.v1.PolicyControllerState
        getPolicyControllerState() {
      if (policyControllerStateBuilder_ == null) {
        return policyControllerState_ == null
            ? com.google.cloud.gkehub.configmanagement.v1.PolicyControllerState.getDefaultInstance()
            : policyControllerState_;
      } else {
        return policyControllerStateBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * PolicyController status
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.configmanagement.v1.PolicyControllerState policy_controller_state = 5;
     * </code>
     */
    public Builder setPolicyControllerState(
        com.google.cloud.gkehub.configmanagement.v1.PolicyControllerState value) {
      if (policyControllerStateBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        policyControllerState_ = value;
      } else {
        policyControllerStateBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * PolicyController status
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.configmanagement.v1.PolicyControllerState policy_controller_state = 5;
     * </code>
     */
    public Builder setPolicyControllerState(
        com.google.cloud.gkehub.configmanagement.v1.PolicyControllerState.Builder builderForValue) {
      if (policyControllerStateBuilder_ == null) {
        policyControllerState_ = builderForValue.build();
      } else {
        policyControllerStateBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * PolicyController status
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.configmanagement.v1.PolicyControllerState policy_controller_state = 5;
     * </code>
     */
    public Builder mergePolicyControllerState(
        com.google.cloud.gkehub.configmanagement.v1.PolicyControllerState value) {
      if (policyControllerStateBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && policyControllerState_ != null
            && policyControllerState_
                != com.google.cloud.gkehub.configmanagement.v1.PolicyControllerState
                    .getDefaultInstance()) {
          getPolicyControllerStateBuilder().mergeFrom(value);
        } else {
          policyControllerState_ = value;
        }
      } else {
        policyControllerStateBuilder_.mergeFrom(value);
      }
      if (policyControllerState_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * PolicyController status
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.configmanagement.v1.PolicyControllerState policy_controller_state = 5;
     * </code>
     */
    public Builder clearPolicyControllerState() {
      bitField0_ = (bitField0_ & ~0x00000010);
      policyControllerState_ = null;
      if (policyControllerStateBuilder_ != null) {
        policyControllerStateBuilder_.dispose();
        policyControllerStateBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * PolicyController status
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.configmanagement.v1.PolicyControllerState policy_controller_state = 5;
     * </code>
     */
    public com.google.cloud.gkehub.configmanagement.v1.PolicyControllerState.Builder
        getPolicyControllerStateBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getPolicyControllerStateFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * PolicyController status
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.configmanagement.v1.PolicyControllerState policy_controller_state = 5;
     * </code>
     */
    public com.google.cloud.gkehub.configmanagement.v1.PolicyControllerStateOrBuilder
        getPolicyControllerStateOrBuilder() {
      if (policyControllerStateBuilder_ != null) {
        return policyControllerStateBuilder_.getMessageOrBuilder();
      } else {
        return policyControllerState_ == null
            ? com.google.cloud.gkehub.configmanagement.v1.PolicyControllerState.getDefaultInstance()
            : policyControllerState_;
      }
    }
    /**
     *
     *
     * <pre>
     * PolicyController status
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.configmanagement.v1.PolicyControllerState policy_controller_state = 5;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gkehub.configmanagement.v1.PolicyControllerState,
            com.google.cloud.gkehub.configmanagement.v1.PolicyControllerState.Builder,
            com.google.cloud.gkehub.configmanagement.v1.PolicyControllerStateOrBuilder>
        getPolicyControllerStateFieldBuilder() {
      if (policyControllerStateBuilder_ == null) {
        policyControllerStateBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.gkehub.configmanagement.v1.PolicyControllerState,
                com.google.cloud.gkehub.configmanagement.v1.PolicyControllerState.Builder,
                com.google.cloud.gkehub.configmanagement.v1.PolicyControllerStateOrBuilder>(
                getPolicyControllerState(), getParentForChildren(), isClean());
        policyControllerState_ = null;
      }
      return policyControllerStateBuilder_;
    }

    private com.google.cloud.gkehub.configmanagement.v1.HierarchyControllerState
        hierarchyControllerState_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gkehub.configmanagement.v1.HierarchyControllerState,
            com.google.cloud.gkehub.configmanagement.v1.HierarchyControllerState.Builder,
            com.google.cloud.gkehub.configmanagement.v1.HierarchyControllerStateOrBuilder>
        hierarchyControllerStateBuilder_;
    /**
     *
     *
     * <pre>
     * Hierarchy Controller status
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.configmanagement.v1.HierarchyControllerState hierarchy_controller_state = 7;
     * </code>
     *
     * @return Whether the hierarchyControllerState field is set.
     */
    public boolean hasHierarchyControllerState() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Hierarchy Controller status
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.configmanagement.v1.HierarchyControllerState hierarchy_controller_state = 7;
     * </code>
     *
     * @return The hierarchyControllerState.
     */
    public com.google.cloud.gkehub.configmanagement.v1.HierarchyControllerState
        getHierarchyControllerState() {
      if (hierarchyControllerStateBuilder_ == null) {
        return hierarchyControllerState_ == null
            ? com.google.cloud.gkehub.configmanagement.v1.HierarchyControllerState
                .getDefaultInstance()
            : hierarchyControllerState_;
      } else {
        return hierarchyControllerStateBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Hierarchy Controller status
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.configmanagement.v1.HierarchyControllerState hierarchy_controller_state = 7;
     * </code>
     */
    public Builder setHierarchyControllerState(
        com.google.cloud.gkehub.configmanagement.v1.HierarchyControllerState value) {
      if (hierarchyControllerStateBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        hierarchyControllerState_ = value;
      } else {
        hierarchyControllerStateBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Hierarchy Controller status
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.configmanagement.v1.HierarchyControllerState hierarchy_controller_state = 7;
     * </code>
     */
    public Builder setHierarchyControllerState(
        com.google.cloud.gkehub.configmanagement.v1.HierarchyControllerState.Builder
            builderForValue) {
      if (hierarchyControllerStateBuilder_ == null) {
        hierarchyControllerState_ = builderForValue.build();
      } else {
        hierarchyControllerStateBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Hierarchy Controller status
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.configmanagement.v1.HierarchyControllerState hierarchy_controller_state = 7;
     * </code>
     */
    public Builder mergeHierarchyControllerState(
        com.google.cloud.gkehub.configmanagement.v1.HierarchyControllerState value) {
      if (hierarchyControllerStateBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && hierarchyControllerState_ != null
            && hierarchyControllerState_
                != com.google.cloud.gkehub.configmanagement.v1.HierarchyControllerState
                    .getDefaultInstance()) {
          getHierarchyControllerStateBuilder().mergeFrom(value);
        } else {
          hierarchyControllerState_ = value;
        }
      } else {
        hierarchyControllerStateBuilder_.mergeFrom(value);
      }
      if (hierarchyControllerState_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Hierarchy Controller status
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.configmanagement.v1.HierarchyControllerState hierarchy_controller_state = 7;
     * </code>
     */
    public Builder clearHierarchyControllerState() {
      bitField0_ = (bitField0_ & ~0x00000020);
      hierarchyControllerState_ = null;
      if (hierarchyControllerStateBuilder_ != null) {
        hierarchyControllerStateBuilder_.dispose();
        hierarchyControllerStateBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Hierarchy Controller status
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.configmanagement.v1.HierarchyControllerState hierarchy_controller_state = 7;
     * </code>
     */
    public com.google.cloud.gkehub.configmanagement.v1.HierarchyControllerState.Builder
        getHierarchyControllerStateBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getHierarchyControllerStateFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Hierarchy Controller status
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.configmanagement.v1.HierarchyControllerState hierarchy_controller_state = 7;
     * </code>
     */
    public com.google.cloud.gkehub.configmanagement.v1.HierarchyControllerStateOrBuilder
        getHierarchyControllerStateOrBuilder() {
      if (hierarchyControllerStateBuilder_ != null) {
        return hierarchyControllerStateBuilder_.getMessageOrBuilder();
      } else {
        return hierarchyControllerState_ == null
            ? com.google.cloud.gkehub.configmanagement.v1.HierarchyControllerState
                .getDefaultInstance()
            : hierarchyControllerState_;
      }
    }
    /**
     *
     *
     * <pre>
     * Hierarchy Controller status
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.configmanagement.v1.HierarchyControllerState hierarchy_controller_state = 7;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gkehub.configmanagement.v1.HierarchyControllerState,
            com.google.cloud.gkehub.configmanagement.v1.HierarchyControllerState.Builder,
            com.google.cloud.gkehub.configmanagement.v1.HierarchyControllerStateOrBuilder>
        getHierarchyControllerStateFieldBuilder() {
      if (hierarchyControllerStateBuilder_ == null) {
        hierarchyControllerStateBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.gkehub.configmanagement.v1.HierarchyControllerState,
                com.google.cloud.gkehub.configmanagement.v1.HierarchyControllerState.Builder,
                com.google.cloud.gkehub.configmanagement.v1.HierarchyControllerStateOrBuilder>(
                getHierarchyControllerState(), getParentForChildren(), isClean());
        hierarchyControllerState_ = null;
      }
      return hierarchyControllerStateBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.gkehub.configmanagement.v1.MembershipState)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.gkehub.configmanagement.v1.MembershipState)
  private static final com.google.cloud.gkehub.configmanagement.v1.MembershipState DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.gkehub.configmanagement.v1.MembershipState();
  }

  public static com.google.cloud.gkehub.configmanagement.v1.MembershipState getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<MembershipState> PARSER =
      new com.google.protobuf.AbstractParser<MembershipState>() {
        @java.lang.Override
        public MembershipState parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<MembershipState> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<MembershipState> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.gkehub.configmanagement.v1.MembershipState getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
