/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/gkehub/v1/service.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.gkehub.v1;

/**
 *
 *
 * <pre>
 * Request message for `GkeHub.GenerateConnectManifest`
 * method.
 * .
 * </pre>
 *
 * Protobuf type {@code google.cloud.gkehub.v1.GenerateConnectManifestRequest}
 */
public final class GenerateConnectManifestRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.gkehub.v1.GenerateConnectManifestRequest)
    GenerateConnectManifestRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use GenerateConnectManifestRequest.newBuilder() to construct.
  private GenerateConnectManifestRequest(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private GenerateConnectManifestRequest() {
    name_ = "";
    namespace_ = "";
    proxy_ = com.google.protobuf.ByteString.EMPTY;
    version_ = "";
    registry_ = "";
    imagePullSecretContent_ = com.google.protobuf.ByteString.EMPTY;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new GenerateConnectManifestRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.gkehub.v1.ServiceProto
        .internal_static_google_cloud_gkehub_v1_GenerateConnectManifestRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.gkehub.v1.ServiceProto
        .internal_static_google_cloud_gkehub_v1_GenerateConnectManifestRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.gkehub.v1.GenerateConnectManifestRequest.class,
            com.google.cloud.gkehub.v1.GenerateConnectManifestRequest.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Required. The Membership resource name the Agent will associate with, in
   * the format `projects/&#42;&#47;locations/&#42;&#47;memberships/&#42;`.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The Membership resource name the Agent will associate with, in
   * the format `projects/&#42;&#47;locations/&#42;&#47;memberships/&#42;`.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NAMESPACE_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object namespace_ = "";
  /**
   *
   *
   * <pre>
   * Optional. Namespace for GKE Connect agent resources. Defaults to
   * `gke-connect`.
   *
   * The Connect Agent is authorized automatically when run in the default
   * namespace. Otherwise, explicit authorization must be granted with an
   * additional IAM binding.
   * </pre>
   *
   * <code>string namespace = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The namespace.
   */
  @java.lang.Override
  public java.lang.String getNamespace() {
    java.lang.Object ref = namespace_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      namespace_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Namespace for GKE Connect agent resources. Defaults to
   * `gke-connect`.
   *
   * The Connect Agent is authorized automatically when run in the default
   * namespace. Otherwise, explicit authorization must be granted with an
   * additional IAM binding.
   * </pre>
   *
   * <code>string namespace = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for namespace.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNamespaceBytes() {
    java.lang.Object ref = namespace_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      namespace_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PROXY_FIELD_NUMBER = 3;
  private com.google.protobuf.ByteString proxy_ = com.google.protobuf.ByteString.EMPTY;
  /**
   *
   *
   * <pre>
   * Optional. URI of a proxy if connectivity from the agent to
   * gkeconnect.googleapis.com requires the use of a proxy. Format must be in
   * the form `http(s)://{proxy_address}`, depending on the HTTP/HTTPS protocol
   * supported by the proxy. This will direct the connect agent's outbound
   * traffic through a HTTP(S) proxy.
   * </pre>
   *
   * <code>bytes proxy = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The proxy.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getProxy() {
    return proxy_;
  }

  public static final int VERSION_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object version_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The Connect agent version to use. Defaults to the most current
   * version.
   * </pre>
   *
   * <code>string version = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The version.
   */
  @java.lang.Override
  public java.lang.String getVersion() {
    java.lang.Object ref = version_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      version_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The Connect agent version to use. Defaults to the most current
   * version.
   * </pre>
   *
   * <code>string version = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for version.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getVersionBytes() {
    java.lang.Object ref = version_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      version_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int IS_UPGRADE_FIELD_NUMBER = 5;
  private boolean isUpgrade_ = false;
  /**
   *
   *
   * <pre>
   * Optional. If true, generate the resources for upgrade only. Some resources
   * generated only for installation (e.g. secrets) will be excluded.
   * </pre>
   *
   * <code>bool is_upgrade = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The isUpgrade.
   */
  @java.lang.Override
  public boolean getIsUpgrade() {
    return isUpgrade_;
  }

  public static final int REGISTRY_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object registry_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The registry to fetch the connect agent image from. Defaults to
   * gcr.io/gkeconnect.
   * </pre>
   *
   * <code>string registry = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The registry.
   */
  @java.lang.Override
  public java.lang.String getRegistry() {
    java.lang.Object ref = registry_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      registry_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The registry to fetch the connect agent image from. Defaults to
   * gcr.io/gkeconnect.
   * </pre>
   *
   * <code>string registry = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for registry.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRegistryBytes() {
    java.lang.Object ref = registry_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      registry_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int IMAGE_PULL_SECRET_CONTENT_FIELD_NUMBER = 7;
  private com.google.protobuf.ByteString imagePullSecretContent_ =
      com.google.protobuf.ByteString.EMPTY;
  /**
   *
   *
   * <pre>
   * Optional. The image pull secret content for the registry, if not public.
   * </pre>
   *
   * <code>bytes image_pull_secret_content = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The imagePullSecretContent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getImagePullSecretContent() {
    return imagePullSecretContent_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(namespace_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, namespace_);
    }
    if (!proxy_.isEmpty()) {
      output.writeBytes(3, proxy_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(version_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, version_);
    }
    if (isUpgrade_ != false) {
      output.writeBool(5, isUpgrade_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(registry_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, registry_);
    }
    if (!imagePullSecretContent_.isEmpty()) {
      output.writeBytes(7, imagePullSecretContent_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(namespace_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, namespace_);
    }
    if (!proxy_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream.computeBytesSize(3, proxy_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(version_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, version_);
    }
    if (isUpgrade_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(5, isUpgrade_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(registry_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, registry_);
    }
    if (!imagePullSecretContent_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream.computeBytesSize(7, imagePullSecretContent_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.gkehub.v1.GenerateConnectManifestRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.gkehub.v1.GenerateConnectManifestRequest other =
        (com.google.cloud.gkehub.v1.GenerateConnectManifestRequest) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getNamespace().equals(other.getNamespace())) return false;
    if (!getProxy().equals(other.getProxy())) return false;
    if (!getVersion().equals(other.getVersion())) return false;
    if (getIsUpgrade() != other.getIsUpgrade()) return false;
    if (!getRegistry().equals(other.getRegistry())) return false;
    if (!getImagePullSecretContent().equals(other.getImagePullSecretContent())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + NAMESPACE_FIELD_NUMBER;
    hash = (53 * hash) + getNamespace().hashCode();
    hash = (37 * hash) + PROXY_FIELD_NUMBER;
    hash = (53 * hash) + getProxy().hashCode();
    hash = (37 * hash) + VERSION_FIELD_NUMBER;
    hash = (53 * hash) + getVersion().hashCode();
    hash = (37 * hash) + IS_UPGRADE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIsUpgrade());
    hash = (37 * hash) + REGISTRY_FIELD_NUMBER;
    hash = (53 * hash) + getRegistry().hashCode();
    hash = (37 * hash) + IMAGE_PULL_SECRET_CONTENT_FIELD_NUMBER;
    hash = (53 * hash) + getImagePullSecretContent().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.gkehub.v1.GenerateConnectManifestRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gkehub.v1.GenerateConnectManifestRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gkehub.v1.GenerateConnectManifestRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gkehub.v1.GenerateConnectManifestRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gkehub.v1.GenerateConnectManifestRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gkehub.v1.GenerateConnectManifestRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gkehub.v1.GenerateConnectManifestRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.gkehub.v1.GenerateConnectManifestRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.gkehub.v1.GenerateConnectManifestRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.gkehub.v1.GenerateConnectManifestRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.gkehub.v1.GenerateConnectManifestRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.gkehub.v1.GenerateConnectManifestRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.gkehub.v1.GenerateConnectManifestRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for `GkeHub.GenerateConnectManifest`
   * method.
   * .
   * </pre>
   *
   * Protobuf type {@code google.cloud.gkehub.v1.GenerateConnectManifestRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.gkehub.v1.GenerateConnectManifestRequest)
      com.google.cloud.gkehub.v1.GenerateConnectManifestRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.gkehub.v1.ServiceProto
          .internal_static_google_cloud_gkehub_v1_GenerateConnectManifestRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.gkehub.v1.ServiceProto
          .internal_static_google_cloud_gkehub_v1_GenerateConnectManifestRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.gkehub.v1.GenerateConnectManifestRequest.class,
              com.google.cloud.gkehub.v1.GenerateConnectManifestRequest.Builder.class);
    }

    // Construct using com.google.cloud.gkehub.v1.GenerateConnectManifestRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      namespace_ = "";
      proxy_ = com.google.protobuf.ByteString.EMPTY;
      version_ = "";
      isUpgrade_ = false;
      registry_ = "";
      imagePullSecretContent_ = com.google.protobuf.ByteString.EMPTY;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.gkehub.v1.ServiceProto
          .internal_static_google_cloud_gkehub_v1_GenerateConnectManifestRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.gkehub.v1.GenerateConnectManifestRequest getDefaultInstanceForType() {
      return com.google.cloud.gkehub.v1.GenerateConnectManifestRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.gkehub.v1.GenerateConnectManifestRequest build() {
      com.google.cloud.gkehub.v1.GenerateConnectManifestRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.gkehub.v1.GenerateConnectManifestRequest buildPartial() {
      com.google.cloud.gkehub.v1.GenerateConnectManifestRequest result =
          new com.google.cloud.gkehub.v1.GenerateConnectManifestRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.gkehub.v1.GenerateConnectManifestRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.namespace_ = namespace_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.proxy_ = proxy_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.version_ = version_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.isUpgrade_ = isUpgrade_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.registry_ = registry_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.imagePullSecretContent_ = imagePullSecretContent_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.gkehub.v1.GenerateConnectManifestRequest) {
        return mergeFrom((com.google.cloud.gkehub.v1.GenerateConnectManifestRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.gkehub.v1.GenerateConnectManifestRequest other) {
      if (other == com.google.cloud.gkehub.v1.GenerateConnectManifestRequest.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getNamespace().isEmpty()) {
        namespace_ = other.namespace_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.getProxy() != com.google.protobuf.ByteString.EMPTY) {
        setProxy(other.getProxy());
      }
      if (!other.getVersion().isEmpty()) {
        version_ = other.version_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.getIsUpgrade() != false) {
        setIsUpgrade(other.getIsUpgrade());
      }
      if (!other.getRegistry().isEmpty()) {
        registry_ = other.registry_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.getImagePullSecretContent() != com.google.protobuf.ByteString.EMPTY) {
        setImagePullSecretContent(other.getImagePullSecretContent());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                namespace_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                proxy_ = input.readBytes();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                version_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 40:
              {
                isUpgrade_ = input.readBool();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            case 50:
              {
                registry_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                imagePullSecretContent_ = input.readBytes();
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. The Membership resource name the Agent will associate with, in
     * the format `projects/&#42;&#47;locations/&#42;&#47;memberships/&#42;`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The Membership resource name the Agent will associate with, in
     * the format `projects/&#42;&#47;locations/&#42;&#47;memberships/&#42;`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The Membership resource name the Agent will associate with, in
     * the format `projects/&#42;&#47;locations/&#42;&#47;memberships/&#42;`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Membership resource name the Agent will associate with, in
     * the format `projects/&#42;&#47;locations/&#42;&#47;memberships/&#42;`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Membership resource name the Agent will associate with, in
     * the format `projects/&#42;&#47;locations/&#42;&#47;memberships/&#42;`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object namespace_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Namespace for GKE Connect agent resources. Defaults to
     * `gke-connect`.
     *
     * The Connect Agent is authorized automatically when run in the default
     * namespace. Otherwise, explicit authorization must be granted with an
     * additional IAM binding.
     * </pre>
     *
     * <code>string namespace = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The namespace.
     */
    public java.lang.String getNamespace() {
      java.lang.Object ref = namespace_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        namespace_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Namespace for GKE Connect agent resources. Defaults to
     * `gke-connect`.
     *
     * The Connect Agent is authorized automatically when run in the default
     * namespace. Otherwise, explicit authorization must be granted with an
     * additional IAM binding.
     * </pre>
     *
     * <code>string namespace = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for namespace.
     */
    public com.google.protobuf.ByteString getNamespaceBytes() {
      java.lang.Object ref = namespace_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        namespace_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Namespace for GKE Connect agent resources. Defaults to
     * `gke-connect`.
     *
     * The Connect Agent is authorized automatically when run in the default
     * namespace. Otherwise, explicit authorization must be granted with an
     * additional IAM binding.
     * </pre>
     *
     * <code>string namespace = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The namespace to set.
     * @return This builder for chaining.
     */
    public Builder setNamespace(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      namespace_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Namespace for GKE Connect agent resources. Defaults to
     * `gke-connect`.
     *
     * The Connect Agent is authorized automatically when run in the default
     * namespace. Otherwise, explicit authorization must be granted with an
     * additional IAM binding.
     * </pre>
     *
     * <code>string namespace = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNamespace() {
      namespace_ = getDefaultInstance().getNamespace();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Namespace for GKE Connect agent resources. Defaults to
     * `gke-connect`.
     *
     * The Connect Agent is authorized automatically when run in the default
     * namespace. Otherwise, explicit authorization must be granted with an
     * additional IAM binding.
     * </pre>
     *
     * <code>string namespace = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for namespace to set.
     * @return This builder for chaining.
     */
    public Builder setNamespaceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      namespace_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.ByteString proxy_ = com.google.protobuf.ByteString.EMPTY;
    /**
     *
     *
     * <pre>
     * Optional. URI of a proxy if connectivity from the agent to
     * gkeconnect.googleapis.com requires the use of a proxy. Format must be in
     * the form `http(s)://{proxy_address}`, depending on the HTTP/HTTPS protocol
     * supported by the proxy. This will direct the connect agent's outbound
     * traffic through a HTTP(S) proxy.
     * </pre>
     *
     * <code>bytes proxy = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The proxy.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getProxy() {
      return proxy_;
    }
    /**
     *
     *
     * <pre>
     * Optional. URI of a proxy if connectivity from the agent to
     * gkeconnect.googleapis.com requires the use of a proxy. Format must be in
     * the form `http(s)://{proxy_address}`, depending on the HTTP/HTTPS protocol
     * supported by the proxy. This will direct the connect agent's outbound
     * traffic through a HTTP(S) proxy.
     * </pre>
     *
     * <code>bytes proxy = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The proxy to set.
     * @return This builder for chaining.
     */
    public Builder setProxy(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      proxy_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. URI of a proxy if connectivity from the agent to
     * gkeconnect.googleapis.com requires the use of a proxy. Format must be in
     * the form `http(s)://{proxy_address}`, depending on the HTTP/HTTPS protocol
     * supported by the proxy. This will direct the connect agent's outbound
     * traffic through a HTTP(S) proxy.
     * </pre>
     *
     * <code>bytes proxy = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProxy() {
      bitField0_ = (bitField0_ & ~0x00000004);
      proxy_ = getDefaultInstance().getProxy();
      onChanged();
      return this;
    }

    private java.lang.Object version_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The Connect agent version to use. Defaults to the most current
     * version.
     * </pre>
     *
     * <code>string version = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The version.
     */
    public java.lang.String getVersion() {
      java.lang.Object ref = version_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        version_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The Connect agent version to use. Defaults to the most current
     * version.
     * </pre>
     *
     * <code>string version = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for version.
     */
    public com.google.protobuf.ByteString getVersionBytes() {
      java.lang.Object ref = version_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        version_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The Connect agent version to use. Defaults to the most current
     * version.
     * </pre>
     *
     * <code>string version = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The version to set.
     * @return This builder for chaining.
     */
    public Builder setVersion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      version_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Connect agent version to use. Defaults to the most current
     * version.
     * </pre>
     *
     * <code>string version = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVersion() {
      version_ = getDefaultInstance().getVersion();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Connect agent version to use. Defaults to the most current
     * version.
     * </pre>
     *
     * <code>string version = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for version to set.
     * @return This builder for chaining.
     */
    public Builder setVersionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      version_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private boolean isUpgrade_;
    /**
     *
     *
     * <pre>
     * Optional. If true, generate the resources for upgrade only. Some resources
     * generated only for installation (e.g. secrets) will be excluded.
     * </pre>
     *
     * <code>bool is_upgrade = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The isUpgrade.
     */
    @java.lang.Override
    public boolean getIsUpgrade() {
      return isUpgrade_;
    }
    /**
     *
     *
     * <pre>
     * Optional. If true, generate the resources for upgrade only. Some resources
     * generated only for installation (e.g. secrets) will be excluded.
     * </pre>
     *
     * <code>bool is_upgrade = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The isUpgrade to set.
     * @return This builder for chaining.
     */
    public Builder setIsUpgrade(boolean value) {

      isUpgrade_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If true, generate the resources for upgrade only. Some resources
     * generated only for installation (e.g. secrets) will be excluded.
     * </pre>
     *
     * <code>bool is_upgrade = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIsUpgrade() {
      bitField0_ = (bitField0_ & ~0x00000010);
      isUpgrade_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object registry_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The registry to fetch the connect agent image from. Defaults to
     * gcr.io/gkeconnect.
     * </pre>
     *
     * <code>string registry = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The registry.
     */
    public java.lang.String getRegistry() {
      java.lang.Object ref = registry_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        registry_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The registry to fetch the connect agent image from. Defaults to
     * gcr.io/gkeconnect.
     * </pre>
     *
     * <code>string registry = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for registry.
     */
    public com.google.protobuf.ByteString getRegistryBytes() {
      java.lang.Object ref = registry_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        registry_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The registry to fetch the connect agent image from. Defaults to
     * gcr.io/gkeconnect.
     * </pre>
     *
     * <code>string registry = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The registry to set.
     * @return This builder for chaining.
     */
    public Builder setRegistry(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      registry_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The registry to fetch the connect agent image from. Defaults to
     * gcr.io/gkeconnect.
     * </pre>
     *
     * <code>string registry = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRegistry() {
      registry_ = getDefaultInstance().getRegistry();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The registry to fetch the connect agent image from. Defaults to
     * gcr.io/gkeconnect.
     * </pre>
     *
     * <code>string registry = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for registry to set.
     * @return This builder for chaining.
     */
    public Builder setRegistryBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      registry_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private com.google.protobuf.ByteString imagePullSecretContent_ =
        com.google.protobuf.ByteString.EMPTY;
    /**
     *
     *
     * <pre>
     * Optional. The image pull secret content for the registry, if not public.
     * </pre>
     *
     * <code>bytes image_pull_secret_content = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The imagePullSecretContent.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getImagePullSecretContent() {
      return imagePullSecretContent_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The image pull secret content for the registry, if not public.
     * </pre>
     *
     * <code>bytes image_pull_secret_content = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The imagePullSecretContent to set.
     * @return This builder for chaining.
     */
    public Builder setImagePullSecretContent(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      imagePullSecretContent_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The image pull secret content for the registry, if not public.
     * </pre>
     *
     * <code>bytes image_pull_secret_content = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearImagePullSecretContent() {
      bitField0_ = (bitField0_ & ~0x00000040);
      imagePullSecretContent_ = getDefaultInstance().getImagePullSecretContent();
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.gkehub.v1.GenerateConnectManifestRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.gkehub.v1.GenerateConnectManifestRequest)
  private static final com.google.cloud.gkehub.v1.GenerateConnectManifestRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.gkehub.v1.GenerateConnectManifestRequest();
  }

  public static com.google.cloud.gkehub.v1.GenerateConnectManifestRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<GenerateConnectManifestRequest> PARSER =
      new com.google.protobuf.AbstractParser<GenerateConnectManifestRequest>() {
        @java.lang.Override
        public GenerateConnectManifestRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<GenerateConnectManifestRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<GenerateConnectManifestRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.gkehub.v1.GenerateConnectManifestRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
