/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/gkehub/v1/membership.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.gkehub.v1;

/**
 *
 *
 * <pre>
 * MembershipEndpoint contains information needed to contact a Kubernetes API,
 * endpoint and any additional Kubernetes metadata.
 * </pre>
 *
 * Protobuf type {@code google.cloud.gkehub.v1.MembershipEndpoint}
 */
public final class MembershipEndpoint extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.gkehub.v1.MembershipEndpoint)
    MembershipEndpointOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use MembershipEndpoint.newBuilder() to construct.
  private MembershipEndpoint(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private MembershipEndpoint() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new MembershipEndpoint();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.gkehub.v1.MembershipProto
        .internal_static_google_cloud_gkehub_v1_MembershipEndpoint_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.gkehub.v1.MembershipProto
        .internal_static_google_cloud_gkehub_v1_MembershipEndpoint_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.gkehub.v1.MembershipEndpoint.class,
            com.google.cloud.gkehub.v1.MembershipEndpoint.Builder.class);
  }

  private int bitField0_;
  public static final int GKE_CLUSTER_FIELD_NUMBER = 1;
  private com.google.cloud.gkehub.v1.GkeCluster gkeCluster_;
  /**
   *
   *
   * <pre>
   * Optional. GKE-specific information. Only present if this Membership is a GKE cluster.
   * </pre>
   *
   * <code>
   * .google.cloud.gkehub.v1.GkeCluster gke_cluster = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the gkeCluster field is set.
   */
  @java.lang.Override
  public boolean hasGkeCluster() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. GKE-specific information. Only present if this Membership is a GKE cluster.
   * </pre>
   *
   * <code>
   * .google.cloud.gkehub.v1.GkeCluster gke_cluster = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The gkeCluster.
   */
  @java.lang.Override
  public com.google.cloud.gkehub.v1.GkeCluster getGkeCluster() {
    return gkeCluster_ == null
        ? com.google.cloud.gkehub.v1.GkeCluster.getDefaultInstance()
        : gkeCluster_;
  }
  /**
   *
   *
   * <pre>
   * Optional. GKE-specific information. Only present if this Membership is a GKE cluster.
   * </pre>
   *
   * <code>
   * .google.cloud.gkehub.v1.GkeCluster gke_cluster = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.gkehub.v1.GkeClusterOrBuilder getGkeClusterOrBuilder() {
    return gkeCluster_ == null
        ? com.google.cloud.gkehub.v1.GkeCluster.getDefaultInstance()
        : gkeCluster_;
  }

  public static final int KUBERNETES_METADATA_FIELD_NUMBER = 2;
  private com.google.cloud.gkehub.v1.KubernetesMetadata kubernetesMetadata_;
  /**
   *
   *
   * <pre>
   * Output only. Useful Kubernetes-specific metadata.
   * </pre>
   *
   * <code>
   * .google.cloud.gkehub.v1.KubernetesMetadata kubernetes_metadata = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the kubernetesMetadata field is set.
   */
  @java.lang.Override
  public boolean hasKubernetesMetadata() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Useful Kubernetes-specific metadata.
   * </pre>
   *
   * <code>
   * .google.cloud.gkehub.v1.KubernetesMetadata kubernetes_metadata = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The kubernetesMetadata.
   */
  @java.lang.Override
  public com.google.cloud.gkehub.v1.KubernetesMetadata getKubernetesMetadata() {
    return kubernetesMetadata_ == null
        ? com.google.cloud.gkehub.v1.KubernetesMetadata.getDefaultInstance()
        : kubernetesMetadata_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Useful Kubernetes-specific metadata.
   * </pre>
   *
   * <code>
   * .google.cloud.gkehub.v1.KubernetesMetadata kubernetes_metadata = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.gkehub.v1.KubernetesMetadataOrBuilder getKubernetesMetadataOrBuilder() {
    return kubernetesMetadata_ == null
        ? com.google.cloud.gkehub.v1.KubernetesMetadata.getDefaultInstance()
        : kubernetesMetadata_;
  }

  public static final int KUBERNETES_RESOURCE_FIELD_NUMBER = 3;
  private com.google.cloud.gkehub.v1.KubernetesResource kubernetesResource_;
  /**
   *
   *
   * <pre>
   * Optional. The in-cluster Kubernetes Resources that should be applied for a
   * correctly registered cluster, in the steady state. These resources:
   *
   *   * Ensure that the cluster is exclusively registered to one and only one
   *     Hub Membership.
   *   * Propagate Workload Pool Information available in the Membership
   *     Authority field.
   *   * Ensure proper initial configuration of default Hub Features.
   * </pre>
   *
   * <code>
   * .google.cloud.gkehub.v1.KubernetesResource kubernetes_resource = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the kubernetesResource field is set.
   */
  @java.lang.Override
  public boolean hasKubernetesResource() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. The in-cluster Kubernetes Resources that should be applied for a
   * correctly registered cluster, in the steady state. These resources:
   *
   *   * Ensure that the cluster is exclusively registered to one and only one
   *     Hub Membership.
   *   * Propagate Workload Pool Information available in the Membership
   *     Authority field.
   *   * Ensure proper initial configuration of default Hub Features.
   * </pre>
   *
   * <code>
   * .google.cloud.gkehub.v1.KubernetesResource kubernetes_resource = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The kubernetesResource.
   */
  @java.lang.Override
  public com.google.cloud.gkehub.v1.KubernetesResource getKubernetesResource() {
    return kubernetesResource_ == null
        ? com.google.cloud.gkehub.v1.KubernetesResource.getDefaultInstance()
        : kubernetesResource_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The in-cluster Kubernetes Resources that should be applied for a
   * correctly registered cluster, in the steady state. These resources:
   *
   *   * Ensure that the cluster is exclusively registered to one and only one
   *     Hub Membership.
   *   * Propagate Workload Pool Information available in the Membership
   *     Authority field.
   *   * Ensure proper initial configuration of default Hub Features.
   * </pre>
   *
   * <code>
   * .google.cloud.gkehub.v1.KubernetesResource kubernetes_resource = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.gkehub.v1.KubernetesResourceOrBuilder getKubernetesResourceOrBuilder() {
    return kubernetesResource_ == null
        ? com.google.cloud.gkehub.v1.KubernetesResource.getDefaultInstance()
        : kubernetesResource_;
  }

  public static final int GOOGLE_MANAGED_FIELD_NUMBER = 8;
  private boolean googleManaged_ = false;
  /**
   *
   *
   * <pre>
   * Output only. Whether the lifecycle of this membership is managed by a
   * google cluster platform service.
   * </pre>
   *
   * <code>bool google_managed = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The googleManaged.
   */
  @java.lang.Override
  public boolean getGoogleManaged() {
    return googleManaged_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getGkeCluster());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(2, getKubernetesMetadata());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(3, getKubernetesResource());
    }
    if (googleManaged_ != false) {
      output.writeBool(8, googleManaged_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getGkeCluster());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getKubernetesMetadata());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getKubernetesResource());
    }
    if (googleManaged_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(8, googleManaged_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.gkehub.v1.MembershipEndpoint)) {
      return super.equals(obj);
    }
    com.google.cloud.gkehub.v1.MembershipEndpoint other =
        (com.google.cloud.gkehub.v1.MembershipEndpoint) obj;

    if (hasGkeCluster() != other.hasGkeCluster()) return false;
    if (hasGkeCluster()) {
      if (!getGkeCluster().equals(other.getGkeCluster())) return false;
    }
    if (hasKubernetesMetadata() != other.hasKubernetesMetadata()) return false;
    if (hasKubernetesMetadata()) {
      if (!getKubernetesMetadata().equals(other.getKubernetesMetadata())) return false;
    }
    if (hasKubernetesResource() != other.hasKubernetesResource()) return false;
    if (hasKubernetesResource()) {
      if (!getKubernetesResource().equals(other.getKubernetesResource())) return false;
    }
    if (getGoogleManaged() != other.getGoogleManaged()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasGkeCluster()) {
      hash = (37 * hash) + GKE_CLUSTER_FIELD_NUMBER;
      hash = (53 * hash) + getGkeCluster().hashCode();
    }
    if (hasKubernetesMetadata()) {
      hash = (37 * hash) + KUBERNETES_METADATA_FIELD_NUMBER;
      hash = (53 * hash) + getKubernetesMetadata().hashCode();
    }
    if (hasKubernetesResource()) {
      hash = (37 * hash) + KUBERNETES_RESOURCE_FIELD_NUMBER;
      hash = (53 * hash) + getKubernetesResource().hashCode();
    }
    hash = (37 * hash) + GOOGLE_MANAGED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getGoogleManaged());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.gkehub.v1.MembershipEndpoint parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gkehub.v1.MembershipEndpoint parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gkehub.v1.MembershipEndpoint parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gkehub.v1.MembershipEndpoint parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gkehub.v1.MembershipEndpoint parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gkehub.v1.MembershipEndpoint parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gkehub.v1.MembershipEndpoint parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.gkehub.v1.MembershipEndpoint parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.gkehub.v1.MembershipEndpoint parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.gkehub.v1.MembershipEndpoint parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.gkehub.v1.MembershipEndpoint parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.gkehub.v1.MembershipEndpoint parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.gkehub.v1.MembershipEndpoint prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * MembershipEndpoint contains information needed to contact a Kubernetes API,
   * endpoint and any additional Kubernetes metadata.
   * </pre>
   *
   * Protobuf type {@code google.cloud.gkehub.v1.MembershipEndpoint}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.gkehub.v1.MembershipEndpoint)
      com.google.cloud.gkehub.v1.MembershipEndpointOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.gkehub.v1.MembershipProto
          .internal_static_google_cloud_gkehub_v1_MembershipEndpoint_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.gkehub.v1.MembershipProto
          .internal_static_google_cloud_gkehub_v1_MembershipEndpoint_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.gkehub.v1.MembershipEndpoint.class,
              com.google.cloud.gkehub.v1.MembershipEndpoint.Builder.class);
    }

    // Construct using com.google.cloud.gkehub.v1.MembershipEndpoint.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getGkeClusterFieldBuilder();
        getKubernetesMetadataFieldBuilder();
        getKubernetesResourceFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      gkeCluster_ = null;
      if (gkeClusterBuilder_ != null) {
        gkeClusterBuilder_.dispose();
        gkeClusterBuilder_ = null;
      }
      kubernetesMetadata_ = null;
      if (kubernetesMetadataBuilder_ != null) {
        kubernetesMetadataBuilder_.dispose();
        kubernetesMetadataBuilder_ = null;
      }
      kubernetesResource_ = null;
      if (kubernetesResourceBuilder_ != null) {
        kubernetesResourceBuilder_.dispose();
        kubernetesResourceBuilder_ = null;
      }
      googleManaged_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.gkehub.v1.MembershipProto
          .internal_static_google_cloud_gkehub_v1_MembershipEndpoint_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.gkehub.v1.MembershipEndpoint getDefaultInstanceForType() {
      return com.google.cloud.gkehub.v1.MembershipEndpoint.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.gkehub.v1.MembershipEndpoint build() {
      com.google.cloud.gkehub.v1.MembershipEndpoint result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.gkehub.v1.MembershipEndpoint buildPartial() {
      com.google.cloud.gkehub.v1.MembershipEndpoint result =
          new com.google.cloud.gkehub.v1.MembershipEndpoint(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.gkehub.v1.MembershipEndpoint result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.gkeCluster_ = gkeClusterBuilder_ == null ? gkeCluster_ : gkeClusterBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.kubernetesMetadata_ =
            kubernetesMetadataBuilder_ == null
                ? kubernetesMetadata_
                : kubernetesMetadataBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.kubernetesResource_ =
            kubernetesResourceBuilder_ == null
                ? kubernetesResource_
                : kubernetesResourceBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.googleManaged_ = googleManaged_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.gkehub.v1.MembershipEndpoint) {
        return mergeFrom((com.google.cloud.gkehub.v1.MembershipEndpoint) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.gkehub.v1.MembershipEndpoint other) {
      if (other == com.google.cloud.gkehub.v1.MembershipEndpoint.getDefaultInstance()) return this;
      if (other.hasGkeCluster()) {
        mergeGkeCluster(other.getGkeCluster());
      }
      if (other.hasKubernetesMetadata()) {
        mergeKubernetesMetadata(other.getKubernetesMetadata());
      }
      if (other.hasKubernetesResource()) {
        mergeKubernetesResource(other.getKubernetesResource());
      }
      if (other.getGoogleManaged() != false) {
        setGoogleManaged(other.getGoogleManaged());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getGkeClusterFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(
                    getKubernetesMetadataFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getKubernetesResourceFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 64:
              {
                googleManaged_ = input.readBool();
                bitField0_ |= 0x00000008;
                break;
              } // case 64
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.gkehub.v1.GkeCluster gkeCluster_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gkehub.v1.GkeCluster,
            com.google.cloud.gkehub.v1.GkeCluster.Builder,
            com.google.cloud.gkehub.v1.GkeClusterOrBuilder>
        gkeClusterBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. GKE-specific information. Only present if this Membership is a GKE cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1.GkeCluster gke_cluster = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the gkeCluster field is set.
     */
    public boolean hasGkeCluster() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. GKE-specific information. Only present if this Membership is a GKE cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1.GkeCluster gke_cluster = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The gkeCluster.
     */
    public com.google.cloud.gkehub.v1.GkeCluster getGkeCluster() {
      if (gkeClusterBuilder_ == null) {
        return gkeCluster_ == null
            ? com.google.cloud.gkehub.v1.GkeCluster.getDefaultInstance()
            : gkeCluster_;
      } else {
        return gkeClusterBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. GKE-specific information. Only present if this Membership is a GKE cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1.GkeCluster gke_cluster = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setGkeCluster(com.google.cloud.gkehub.v1.GkeCluster value) {
      if (gkeClusterBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        gkeCluster_ = value;
      } else {
        gkeClusterBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. GKE-specific information. Only present if this Membership is a GKE cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1.GkeCluster gke_cluster = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setGkeCluster(com.google.cloud.gkehub.v1.GkeCluster.Builder builderForValue) {
      if (gkeClusterBuilder_ == null) {
        gkeCluster_ = builderForValue.build();
      } else {
        gkeClusterBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. GKE-specific information. Only present if this Membership is a GKE cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1.GkeCluster gke_cluster = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeGkeCluster(com.google.cloud.gkehub.v1.GkeCluster value) {
      if (gkeClusterBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && gkeCluster_ != null
            && gkeCluster_ != com.google.cloud.gkehub.v1.GkeCluster.getDefaultInstance()) {
          getGkeClusterBuilder().mergeFrom(value);
        } else {
          gkeCluster_ = value;
        }
      } else {
        gkeClusterBuilder_.mergeFrom(value);
      }
      if (gkeCluster_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. GKE-specific information. Only present if this Membership is a GKE cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1.GkeCluster gke_cluster = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearGkeCluster() {
      bitField0_ = (bitField0_ & ~0x00000001);
      gkeCluster_ = null;
      if (gkeClusterBuilder_ != null) {
        gkeClusterBuilder_.dispose();
        gkeClusterBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. GKE-specific information. Only present if this Membership is a GKE cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1.GkeCluster gke_cluster = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.gkehub.v1.GkeCluster.Builder getGkeClusterBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getGkeClusterFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. GKE-specific information. Only present if this Membership is a GKE cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1.GkeCluster gke_cluster = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.gkehub.v1.GkeClusterOrBuilder getGkeClusterOrBuilder() {
      if (gkeClusterBuilder_ != null) {
        return gkeClusterBuilder_.getMessageOrBuilder();
      } else {
        return gkeCluster_ == null
            ? com.google.cloud.gkehub.v1.GkeCluster.getDefaultInstance()
            : gkeCluster_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. GKE-specific information. Only present if this Membership is a GKE cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1.GkeCluster gke_cluster = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gkehub.v1.GkeCluster,
            com.google.cloud.gkehub.v1.GkeCluster.Builder,
            com.google.cloud.gkehub.v1.GkeClusterOrBuilder>
        getGkeClusterFieldBuilder() {
      if (gkeClusterBuilder_ == null) {
        gkeClusterBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.gkehub.v1.GkeCluster,
                com.google.cloud.gkehub.v1.GkeCluster.Builder,
                com.google.cloud.gkehub.v1.GkeClusterOrBuilder>(
                getGkeCluster(), getParentForChildren(), isClean());
        gkeCluster_ = null;
      }
      return gkeClusterBuilder_;
    }

    private com.google.cloud.gkehub.v1.KubernetesMetadata kubernetesMetadata_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gkehub.v1.KubernetesMetadata,
            com.google.cloud.gkehub.v1.KubernetesMetadata.Builder,
            com.google.cloud.gkehub.v1.KubernetesMetadataOrBuilder>
        kubernetesMetadataBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Useful Kubernetes-specific metadata.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1.KubernetesMetadata kubernetes_metadata = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the kubernetesMetadata field is set.
     */
    public boolean hasKubernetesMetadata() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Useful Kubernetes-specific metadata.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1.KubernetesMetadata kubernetes_metadata = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The kubernetesMetadata.
     */
    public com.google.cloud.gkehub.v1.KubernetesMetadata getKubernetesMetadata() {
      if (kubernetesMetadataBuilder_ == null) {
        return kubernetesMetadata_ == null
            ? com.google.cloud.gkehub.v1.KubernetesMetadata.getDefaultInstance()
            : kubernetesMetadata_;
      } else {
        return kubernetesMetadataBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Useful Kubernetes-specific metadata.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1.KubernetesMetadata kubernetes_metadata = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setKubernetesMetadata(com.google.cloud.gkehub.v1.KubernetesMetadata value) {
      if (kubernetesMetadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        kubernetesMetadata_ = value;
      } else {
        kubernetesMetadataBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Useful Kubernetes-specific metadata.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1.KubernetesMetadata kubernetes_metadata = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setKubernetesMetadata(
        com.google.cloud.gkehub.v1.KubernetesMetadata.Builder builderForValue) {
      if (kubernetesMetadataBuilder_ == null) {
        kubernetesMetadata_ = builderForValue.build();
      } else {
        kubernetesMetadataBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Useful Kubernetes-specific metadata.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1.KubernetesMetadata kubernetes_metadata = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeKubernetesMetadata(com.google.cloud.gkehub.v1.KubernetesMetadata value) {
      if (kubernetesMetadataBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && kubernetesMetadata_ != null
            && kubernetesMetadata_
                != com.google.cloud.gkehub.v1.KubernetesMetadata.getDefaultInstance()) {
          getKubernetesMetadataBuilder().mergeFrom(value);
        } else {
          kubernetesMetadata_ = value;
        }
      } else {
        kubernetesMetadataBuilder_.mergeFrom(value);
      }
      if (kubernetesMetadata_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Useful Kubernetes-specific metadata.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1.KubernetesMetadata kubernetes_metadata = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearKubernetesMetadata() {
      bitField0_ = (bitField0_ & ~0x00000002);
      kubernetesMetadata_ = null;
      if (kubernetesMetadataBuilder_ != null) {
        kubernetesMetadataBuilder_.dispose();
        kubernetesMetadataBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Useful Kubernetes-specific metadata.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1.KubernetesMetadata kubernetes_metadata = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.gkehub.v1.KubernetesMetadata.Builder getKubernetesMetadataBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getKubernetesMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Useful Kubernetes-specific metadata.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1.KubernetesMetadata kubernetes_metadata = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.gkehub.v1.KubernetesMetadataOrBuilder getKubernetesMetadataOrBuilder() {
      if (kubernetesMetadataBuilder_ != null) {
        return kubernetesMetadataBuilder_.getMessageOrBuilder();
      } else {
        return kubernetesMetadata_ == null
            ? com.google.cloud.gkehub.v1.KubernetesMetadata.getDefaultInstance()
            : kubernetesMetadata_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Useful Kubernetes-specific metadata.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1.KubernetesMetadata kubernetes_metadata = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gkehub.v1.KubernetesMetadata,
            com.google.cloud.gkehub.v1.KubernetesMetadata.Builder,
            com.google.cloud.gkehub.v1.KubernetesMetadataOrBuilder>
        getKubernetesMetadataFieldBuilder() {
      if (kubernetesMetadataBuilder_ == null) {
        kubernetesMetadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.gkehub.v1.KubernetesMetadata,
                com.google.cloud.gkehub.v1.KubernetesMetadata.Builder,
                com.google.cloud.gkehub.v1.KubernetesMetadataOrBuilder>(
                getKubernetesMetadata(), getParentForChildren(), isClean());
        kubernetesMetadata_ = null;
      }
      return kubernetesMetadataBuilder_;
    }

    private com.google.cloud.gkehub.v1.KubernetesResource kubernetesResource_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gkehub.v1.KubernetesResource,
            com.google.cloud.gkehub.v1.KubernetesResource.Builder,
            com.google.cloud.gkehub.v1.KubernetesResourceOrBuilder>
        kubernetesResourceBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The in-cluster Kubernetes Resources that should be applied for a
     * correctly registered cluster, in the steady state. These resources:
     *
     *   * Ensure that the cluster is exclusively registered to one and only one
     *     Hub Membership.
     *   * Propagate Workload Pool Information available in the Membership
     *     Authority field.
     *   * Ensure proper initial configuration of default Hub Features.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1.KubernetesResource kubernetes_resource = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the kubernetesResource field is set.
     */
    public boolean hasKubernetesResource() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The in-cluster Kubernetes Resources that should be applied for a
     * correctly registered cluster, in the steady state. These resources:
     *
     *   * Ensure that the cluster is exclusively registered to one and only one
     *     Hub Membership.
     *   * Propagate Workload Pool Information available in the Membership
     *     Authority field.
     *   * Ensure proper initial configuration of default Hub Features.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1.KubernetesResource kubernetes_resource = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The kubernetesResource.
     */
    public com.google.cloud.gkehub.v1.KubernetesResource getKubernetesResource() {
      if (kubernetesResourceBuilder_ == null) {
        return kubernetesResource_ == null
            ? com.google.cloud.gkehub.v1.KubernetesResource.getDefaultInstance()
            : kubernetesResource_;
      } else {
        return kubernetesResourceBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The in-cluster Kubernetes Resources that should be applied for a
     * correctly registered cluster, in the steady state. These resources:
     *
     *   * Ensure that the cluster is exclusively registered to one and only one
     *     Hub Membership.
     *   * Propagate Workload Pool Information available in the Membership
     *     Authority field.
     *   * Ensure proper initial configuration of default Hub Features.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1.KubernetesResource kubernetes_resource = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setKubernetesResource(com.google.cloud.gkehub.v1.KubernetesResource value) {
      if (kubernetesResourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        kubernetesResource_ = value;
      } else {
        kubernetesResourceBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The in-cluster Kubernetes Resources that should be applied for a
     * correctly registered cluster, in the steady state. These resources:
     *
     *   * Ensure that the cluster is exclusively registered to one and only one
     *     Hub Membership.
     *   * Propagate Workload Pool Information available in the Membership
     *     Authority field.
     *   * Ensure proper initial configuration of default Hub Features.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1.KubernetesResource kubernetes_resource = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setKubernetesResource(
        com.google.cloud.gkehub.v1.KubernetesResource.Builder builderForValue) {
      if (kubernetesResourceBuilder_ == null) {
        kubernetesResource_ = builderForValue.build();
      } else {
        kubernetesResourceBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The in-cluster Kubernetes Resources that should be applied for a
     * correctly registered cluster, in the steady state. These resources:
     *
     *   * Ensure that the cluster is exclusively registered to one and only one
     *     Hub Membership.
     *   * Propagate Workload Pool Information available in the Membership
     *     Authority field.
     *   * Ensure proper initial configuration of default Hub Features.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1.KubernetesResource kubernetes_resource = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeKubernetesResource(com.google.cloud.gkehub.v1.KubernetesResource value) {
      if (kubernetesResourceBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && kubernetesResource_ != null
            && kubernetesResource_
                != com.google.cloud.gkehub.v1.KubernetesResource.getDefaultInstance()) {
          getKubernetesResourceBuilder().mergeFrom(value);
        } else {
          kubernetesResource_ = value;
        }
      } else {
        kubernetesResourceBuilder_.mergeFrom(value);
      }
      if (kubernetesResource_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The in-cluster Kubernetes Resources that should be applied for a
     * correctly registered cluster, in the steady state. These resources:
     *
     *   * Ensure that the cluster is exclusively registered to one and only one
     *     Hub Membership.
     *   * Propagate Workload Pool Information available in the Membership
     *     Authority field.
     *   * Ensure proper initial configuration of default Hub Features.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1.KubernetesResource kubernetes_resource = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearKubernetesResource() {
      bitField0_ = (bitField0_ & ~0x00000004);
      kubernetesResource_ = null;
      if (kubernetesResourceBuilder_ != null) {
        kubernetesResourceBuilder_.dispose();
        kubernetesResourceBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The in-cluster Kubernetes Resources that should be applied for a
     * correctly registered cluster, in the steady state. These resources:
     *
     *   * Ensure that the cluster is exclusively registered to one and only one
     *     Hub Membership.
     *   * Propagate Workload Pool Information available in the Membership
     *     Authority field.
     *   * Ensure proper initial configuration of default Hub Features.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1.KubernetesResource kubernetes_resource = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.gkehub.v1.KubernetesResource.Builder getKubernetesResourceBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getKubernetesResourceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The in-cluster Kubernetes Resources that should be applied for a
     * correctly registered cluster, in the steady state. These resources:
     *
     *   * Ensure that the cluster is exclusively registered to one and only one
     *     Hub Membership.
     *   * Propagate Workload Pool Information available in the Membership
     *     Authority field.
     *   * Ensure proper initial configuration of default Hub Features.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1.KubernetesResource kubernetes_resource = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.gkehub.v1.KubernetesResourceOrBuilder getKubernetesResourceOrBuilder() {
      if (kubernetesResourceBuilder_ != null) {
        return kubernetesResourceBuilder_.getMessageOrBuilder();
      } else {
        return kubernetesResource_ == null
            ? com.google.cloud.gkehub.v1.KubernetesResource.getDefaultInstance()
            : kubernetesResource_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The in-cluster Kubernetes Resources that should be applied for a
     * correctly registered cluster, in the steady state. These resources:
     *
     *   * Ensure that the cluster is exclusively registered to one and only one
     *     Hub Membership.
     *   * Propagate Workload Pool Information available in the Membership
     *     Authority field.
     *   * Ensure proper initial configuration of default Hub Features.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1.KubernetesResource kubernetes_resource = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gkehub.v1.KubernetesResource,
            com.google.cloud.gkehub.v1.KubernetesResource.Builder,
            com.google.cloud.gkehub.v1.KubernetesResourceOrBuilder>
        getKubernetesResourceFieldBuilder() {
      if (kubernetesResourceBuilder_ == null) {
        kubernetesResourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.gkehub.v1.KubernetesResource,
                com.google.cloud.gkehub.v1.KubernetesResource.Builder,
                com.google.cloud.gkehub.v1.KubernetesResourceOrBuilder>(
                getKubernetesResource(), getParentForChildren(), isClean());
        kubernetesResource_ = null;
      }
      return kubernetesResourceBuilder_;
    }

    private boolean googleManaged_;
    /**
     *
     *
     * <pre>
     * Output only. Whether the lifecycle of this membership is managed by a
     * google cluster platform service.
     * </pre>
     *
     * <code>bool google_managed = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The googleManaged.
     */
    @java.lang.Override
    public boolean getGoogleManaged() {
      return googleManaged_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Whether the lifecycle of this membership is managed by a
     * google cluster platform service.
     * </pre>
     *
     * <code>bool google_managed = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The googleManaged to set.
     * @return This builder for chaining.
     */
    public Builder setGoogleManaged(boolean value) {

      googleManaged_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Whether the lifecycle of this membership is managed by a
     * google cluster platform service.
     * </pre>
     *
     * <code>bool google_managed = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearGoogleManaged() {
      bitField0_ = (bitField0_ & ~0x00000008);
      googleManaged_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.gkehub.v1.MembershipEndpoint)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.gkehub.v1.MembershipEndpoint)
  private static final com.google.cloud.gkehub.v1.MembershipEndpoint DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.gkehub.v1.MembershipEndpoint();
  }

  public static com.google.cloud.gkehub.v1.MembershipEndpoint getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<MembershipEndpoint> PARSER =
      new com.google.protobuf.AbstractParser<MembershipEndpoint>() {
        @java.lang.Override
        public MembershipEndpoint parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<MembershipEndpoint> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<MembershipEndpoint> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.gkehub.v1.MembershipEndpoint getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
