/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gkehub.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class FeatureName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_FEATURE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/features/{feature}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String feature;

    @Deprecated
    protected FeatureName() {
        this.project = null;
        this.location = null;
        this.feature = null;
    }

    private FeatureName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.feature = (String)Preconditions.checkNotNull((Object)builder.getFeature());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getFeature() {
        return this.feature;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static FeatureName of(String project, String location, String feature) {
        return FeatureName.newBuilder().setProject(project).setLocation(location).setFeature(feature).build();
    }

    public static String format(String project, String location, String feature) {
        return FeatureName.newBuilder().setProject(project).setLocation(location).setFeature(feature).build().toString();
    }

    public static FeatureName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_FEATURE.validatedMatch(formattedString, "FeatureName.parse: formattedString not in valid format");
        return FeatureName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("feature"));
    }

    public static List<FeatureName> parseList(List<String> formattedStrings) {
        ArrayList<FeatureName> list = new ArrayList<FeatureName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(FeatureName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<FeatureName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (FeatureName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_FEATURE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            FeatureName featureName = this;
            synchronized (featureName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.feature != null) {
                        fieldMapBuilder.put((Object)"feature", (Object)this.feature);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_FEATURE.instantiate(new String[]{"project", this.project, "location", this.location, "feature", this.feature});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            FeatureName that = (FeatureName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.feature, that.feature);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.feature);
    }

    public static class Builder {
        private String project;
        private String location;
        private String feature;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getFeature() {
            return this.feature;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setFeature(String feature) {
            this.feature = feature;
            return this;
        }

        private Builder(FeatureName featureName) {
            this.project = featureName.project;
            this.location = featureName.location;
            this.feature = featureName.feature;
        }

        public FeatureName build() {
            return new FeatureName(this);
        }
    }
}

