/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/gkehub/v1alpha/configmanagement/configmanagement.proto

package com.google.cloud.gkehub.configmanagement.v1alpha;

/**
 *
 *
 * <pre>
 * State indicating an ACM's progress syncing configurations to a cluster
 * </pre>
 *
 * Protobuf type {@code google.cloud.gkehub.configmanagement.v1alpha.SyncState}
 */
public final class SyncState extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.gkehub.configmanagement.v1alpha.SyncState)
    SyncStateOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SyncState.newBuilder() to construct.
  private SyncState(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SyncState() {
    sourceToken_ = "";
    importToken_ = "";
    syncToken_ = "";
    lastSync_ = "";
    code_ = 0;
    errors_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SyncState();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.gkehub.configmanagement.v1alpha.ConfigManagementProto
        .internal_static_google_cloud_gkehub_configmanagement_v1alpha_SyncState_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.gkehub.configmanagement.v1alpha.ConfigManagementProto
        .internal_static_google_cloud_gkehub_configmanagement_v1alpha_SyncState_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.gkehub.configmanagement.v1alpha.SyncState.class,
            com.google.cloud.gkehub.configmanagement.v1alpha.SyncState.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * An enum representing an ACM's status syncing configs to a cluster
   * </pre>
   *
   * Protobuf enum {@code google.cloud.gkehub.configmanagement.v1alpha.SyncState.SyncCode}
   */
  public enum SyncCode implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * ACM cannot determine a sync code
     * </pre>
     *
     * <code>SYNC_CODE_UNSPECIFIED = 0;</code>
     */
    SYNC_CODE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * ACM successfully synced the git Repo with the cluster
     * </pre>
     *
     * <code>SYNCED = 1;</code>
     */
    SYNCED(1),
    /**
     *
     *
     * <pre>
     * ACM is in the progress of syncing a new change
     * </pre>
     *
     * <code>PENDING = 2;</code>
     */
    PENDING(2),
    /**
     *
     *
     * <pre>
     * Indicates an error configuring ACM, and user action is required
     * </pre>
     *
     * <code>ERROR = 3;</code>
     */
    ERROR(3),
    /**
     *
     *
     * <pre>
     * ACM has been installed (operator manifest deployed),
     * but not configured.
     * </pre>
     *
     * <code>NOT_CONFIGURED = 4;</code>
     */
    NOT_CONFIGURED(4),
    /**
     *
     *
     * <pre>
     * ACM has not been installed (no operator pod found)
     * </pre>
     *
     * <code>NOT_INSTALLED = 5;</code>
     */
    NOT_INSTALLED(5),
    /**
     *
     *
     * <pre>
     * Error authorizing with the cluster
     * </pre>
     *
     * <code>UNAUTHORIZED = 6;</code>
     */
    UNAUTHORIZED(6),
    /**
     *
     *
     * <pre>
     * Cluster could not be reached
     * </pre>
     *
     * <code>UNREACHABLE = 7;</code>
     */
    UNREACHABLE(7),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * ACM cannot determine a sync code
     * </pre>
     *
     * <code>SYNC_CODE_UNSPECIFIED = 0;</code>
     */
    public static final int SYNC_CODE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * ACM successfully synced the git Repo with the cluster
     * </pre>
     *
     * <code>SYNCED = 1;</code>
     */
    public static final int SYNCED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * ACM is in the progress of syncing a new change
     * </pre>
     *
     * <code>PENDING = 2;</code>
     */
    public static final int PENDING_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Indicates an error configuring ACM, and user action is required
     * </pre>
     *
     * <code>ERROR = 3;</code>
     */
    public static final int ERROR_VALUE = 3;
    /**
     *
     *
     * <pre>
     * ACM has been installed (operator manifest deployed),
     * but not configured.
     * </pre>
     *
     * <code>NOT_CONFIGURED = 4;</code>
     */
    public static final int NOT_CONFIGURED_VALUE = 4;
    /**
     *
     *
     * <pre>
     * ACM has not been installed (no operator pod found)
     * </pre>
     *
     * <code>NOT_INSTALLED = 5;</code>
     */
    public static final int NOT_INSTALLED_VALUE = 5;
    /**
     *
     *
     * <pre>
     * Error authorizing with the cluster
     * </pre>
     *
     * <code>UNAUTHORIZED = 6;</code>
     */
    public static final int UNAUTHORIZED_VALUE = 6;
    /**
     *
     *
     * <pre>
     * Cluster could not be reached
     * </pre>
     *
     * <code>UNREACHABLE = 7;</code>
     */
    public static final int UNREACHABLE_VALUE = 7;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SyncCode valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static SyncCode forNumber(int value) {
      switch (value) {
        case 0:
          return SYNC_CODE_UNSPECIFIED;
        case 1:
          return SYNCED;
        case 2:
          return PENDING;
        case 3:
          return ERROR;
        case 4:
          return NOT_CONFIGURED;
        case 5:
          return NOT_INSTALLED;
        case 6:
          return UNAUTHORIZED;
        case 7:
          return UNREACHABLE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<SyncCode> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<SyncCode> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<SyncCode>() {
          public SyncCode findValueByNumber(int number) {
            return SyncCode.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.gkehub.configmanagement.v1alpha.SyncState.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final SyncCode[] VALUES = values();

    public static SyncCode valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private SyncCode(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.gkehub.configmanagement.v1alpha.SyncState.SyncCode)
  }

  public static final int SOURCE_TOKEN_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object sourceToken_ = "";
  /**
   *
   *
   * <pre>
   * Token indicating the state of the repo.
   * </pre>
   *
   * <code>string source_token = 1;</code>
   *
   * @return The sourceToken.
   */
  @java.lang.Override
  public java.lang.String getSourceToken() {
    java.lang.Object ref = sourceToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      sourceToken_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Token indicating the state of the repo.
   * </pre>
   *
   * <code>string source_token = 1;</code>
   *
   * @return The bytes for sourceToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSourceTokenBytes() {
    java.lang.Object ref = sourceToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      sourceToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int IMPORT_TOKEN_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object importToken_ = "";
  /**
   *
   *
   * <pre>
   * Token indicating the state of the importer.
   * </pre>
   *
   * <code>string import_token = 2;</code>
   *
   * @return The importToken.
   */
  @java.lang.Override
  public java.lang.String getImportToken() {
    java.lang.Object ref = importToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      importToken_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Token indicating the state of the importer.
   * </pre>
   *
   * <code>string import_token = 2;</code>
   *
   * @return The bytes for importToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getImportTokenBytes() {
    java.lang.Object ref = importToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      importToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SYNC_TOKEN_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object syncToken_ = "";
  /**
   *
   *
   * <pre>
   * Token indicating the state of the syncer.
   * </pre>
   *
   * <code>string sync_token = 3;</code>
   *
   * @return The syncToken.
   */
  @java.lang.Override
  public java.lang.String getSyncToken() {
    java.lang.Object ref = syncToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      syncToken_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Token indicating the state of the syncer.
   * </pre>
   *
   * <code>string sync_token = 3;</code>
   *
   * @return The bytes for syncToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSyncTokenBytes() {
    java.lang.Object ref = syncToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      syncToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LAST_SYNC_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object lastSync_ = "";
  /**
   *
   *
   * <pre>
   * Deprecated: use last_sync_time instead.
   * Timestamp of when ACM last successfully synced the repo
   * The time format is specified in https://golang.org/pkg/time/#Time.String
   * </pre>
   *
   * <code>string last_sync = 4 [deprecated = true];</code>
   *
   * @deprecated google.cloud.gkehub.configmanagement.v1alpha.SyncState.last_sync is deprecated. See
   *     google/cloud/gkehub/v1alpha/configmanagement/configmanagement.proto;l=320
   * @return The lastSync.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.lang.String getLastSync() {
    java.lang.Object ref = lastSync_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      lastSync_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Deprecated: use last_sync_time instead.
   * Timestamp of when ACM last successfully synced the repo
   * The time format is specified in https://golang.org/pkg/time/#Time.String
   * </pre>
   *
   * <code>string last_sync = 4 [deprecated = true];</code>
   *
   * @deprecated google.cloud.gkehub.configmanagement.v1alpha.SyncState.last_sync is deprecated. See
   *     google/cloud/gkehub/v1alpha/configmanagement/configmanagement.proto;l=320
   * @return The bytes for lastSync.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.protobuf.ByteString getLastSyncBytes() {
    java.lang.Object ref = lastSync_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      lastSync_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LAST_SYNC_TIME_FIELD_NUMBER = 7;
  private com.google.protobuf.Timestamp lastSyncTime_;
  /**
   *
   *
   * <pre>
   * Timestamp type of when ACM last successfully synced the repo
   * </pre>
   *
   * <code>.google.protobuf.Timestamp last_sync_time = 7;</code>
   *
   * @return Whether the lastSyncTime field is set.
   */
  @java.lang.Override
  public boolean hasLastSyncTime() {
    return lastSyncTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Timestamp type of when ACM last successfully synced the repo
   * </pre>
   *
   * <code>.google.protobuf.Timestamp last_sync_time = 7;</code>
   *
   * @return The lastSyncTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getLastSyncTime() {
    return lastSyncTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : lastSyncTime_;
  }
  /**
   *
   *
   * <pre>
   * Timestamp type of when ACM last successfully synced the repo
   * </pre>
   *
   * <code>.google.protobuf.Timestamp last_sync_time = 7;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getLastSyncTimeOrBuilder() {
    return lastSyncTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : lastSyncTime_;
  }

  public static final int CODE_FIELD_NUMBER = 5;
  private int code_ = 0;
  /**
   *
   *
   * <pre>
   * Sync status code
   * </pre>
   *
   * <code>.google.cloud.gkehub.configmanagement.v1alpha.SyncState.SyncCode code = 5;</code>
   *
   * @return The enum numeric value on the wire for code.
   */
  @java.lang.Override
  public int getCodeValue() {
    return code_;
  }
  /**
   *
   *
   * <pre>
   * Sync status code
   * </pre>
   *
   * <code>.google.cloud.gkehub.configmanagement.v1alpha.SyncState.SyncCode code = 5;</code>
   *
   * @return The code.
   */
  @java.lang.Override
  public com.google.cloud.gkehub.configmanagement.v1alpha.SyncState.SyncCode getCode() {
    com.google.cloud.gkehub.configmanagement.v1alpha.SyncState.SyncCode result =
        com.google.cloud.gkehub.configmanagement.v1alpha.SyncState.SyncCode.forNumber(code_);
    return result == null
        ? com.google.cloud.gkehub.configmanagement.v1alpha.SyncState.SyncCode.UNRECOGNIZED
        : result;
  }

  public static final int ERRORS_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.gkehub.configmanagement.v1alpha.SyncError> errors_;
  /**
   *
   *
   * <pre>
   * A list of errors resulting from problematic configs.
   * This list will be truncated after 100 errors, although it is
   * unlikely for that many errors to simultaneously exist.
   * </pre>
   *
   * <code>repeated .google.cloud.gkehub.configmanagement.v1alpha.SyncError errors = 6;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.gkehub.configmanagement.v1alpha.SyncError>
      getErrorsList() {
    return errors_;
  }
  /**
   *
   *
   * <pre>
   * A list of errors resulting from problematic configs.
   * This list will be truncated after 100 errors, although it is
   * unlikely for that many errors to simultaneously exist.
   * </pre>
   *
   * <code>repeated .google.cloud.gkehub.configmanagement.v1alpha.SyncError errors = 6;</code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.gkehub.configmanagement.v1alpha.SyncErrorOrBuilder>
      getErrorsOrBuilderList() {
    return errors_;
  }
  /**
   *
   *
   * <pre>
   * A list of errors resulting from problematic configs.
   * This list will be truncated after 100 errors, although it is
   * unlikely for that many errors to simultaneously exist.
   * </pre>
   *
   * <code>repeated .google.cloud.gkehub.configmanagement.v1alpha.SyncError errors = 6;</code>
   */
  @java.lang.Override
  public int getErrorsCount() {
    return errors_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of errors resulting from problematic configs.
   * This list will be truncated after 100 errors, although it is
   * unlikely for that many errors to simultaneously exist.
   * </pre>
   *
   * <code>repeated .google.cloud.gkehub.configmanagement.v1alpha.SyncError errors = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.gkehub.configmanagement.v1alpha.SyncError getErrors(int index) {
    return errors_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of errors resulting from problematic configs.
   * This list will be truncated after 100 errors, although it is
   * unlikely for that many errors to simultaneously exist.
   * </pre>
   *
   * <code>repeated .google.cloud.gkehub.configmanagement.v1alpha.SyncError errors = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.gkehub.configmanagement.v1alpha.SyncErrorOrBuilder getErrorsOrBuilder(
      int index) {
    return errors_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourceToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, sourceToken_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(importToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, importToken_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(syncToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, syncToken_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(lastSync_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, lastSync_);
    }
    if (code_
        != com.google.cloud.gkehub.configmanagement.v1alpha.SyncState.SyncCode.SYNC_CODE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(5, code_);
    }
    for (int i = 0; i < errors_.size(); i++) {
      output.writeMessage(6, errors_.get(i));
    }
    if (lastSyncTime_ != null) {
      output.writeMessage(7, getLastSyncTime());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourceToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, sourceToken_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(importToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, importToken_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(syncToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, syncToken_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(lastSync_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, lastSync_);
    }
    if (code_
        != com.google.cloud.gkehub.configmanagement.v1alpha.SyncState.SyncCode.SYNC_CODE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, code_);
    }
    for (int i = 0; i < errors_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, errors_.get(i));
    }
    if (lastSyncTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getLastSyncTime());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.gkehub.configmanagement.v1alpha.SyncState)) {
      return super.equals(obj);
    }
    com.google.cloud.gkehub.configmanagement.v1alpha.SyncState other =
        (com.google.cloud.gkehub.configmanagement.v1alpha.SyncState) obj;

    if (!getSourceToken().equals(other.getSourceToken())) return false;
    if (!getImportToken().equals(other.getImportToken())) return false;
    if (!getSyncToken().equals(other.getSyncToken())) return false;
    if (!getLastSync().equals(other.getLastSync())) return false;
    if (hasLastSyncTime() != other.hasLastSyncTime()) return false;
    if (hasLastSyncTime()) {
      if (!getLastSyncTime().equals(other.getLastSyncTime())) return false;
    }
    if (code_ != other.code_) return false;
    if (!getErrorsList().equals(other.getErrorsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SOURCE_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getSourceToken().hashCode();
    hash = (37 * hash) + IMPORT_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getImportToken().hashCode();
    hash = (37 * hash) + SYNC_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getSyncToken().hashCode();
    hash = (37 * hash) + LAST_SYNC_FIELD_NUMBER;
    hash = (53 * hash) + getLastSync().hashCode();
    if (hasLastSyncTime()) {
      hash = (37 * hash) + LAST_SYNC_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getLastSyncTime().hashCode();
    }
    hash = (37 * hash) + CODE_FIELD_NUMBER;
    hash = (53 * hash) + code_;
    if (getErrorsCount() > 0) {
      hash = (37 * hash) + ERRORS_FIELD_NUMBER;
      hash = (53 * hash) + getErrorsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.gkehub.configmanagement.v1alpha.SyncState parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gkehub.configmanagement.v1alpha.SyncState parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gkehub.configmanagement.v1alpha.SyncState parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gkehub.configmanagement.v1alpha.SyncState parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gkehub.configmanagement.v1alpha.SyncState parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gkehub.configmanagement.v1alpha.SyncState parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gkehub.configmanagement.v1alpha.SyncState parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.gkehub.configmanagement.v1alpha.SyncState parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.gkehub.configmanagement.v1alpha.SyncState parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.gkehub.configmanagement.v1alpha.SyncState parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.gkehub.configmanagement.v1alpha.SyncState parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.gkehub.configmanagement.v1alpha.SyncState parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.gkehub.configmanagement.v1alpha.SyncState prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * State indicating an ACM's progress syncing configurations to a cluster
   * </pre>
   *
   * Protobuf type {@code google.cloud.gkehub.configmanagement.v1alpha.SyncState}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.gkehub.configmanagement.v1alpha.SyncState)
      com.google.cloud.gkehub.configmanagement.v1alpha.SyncStateOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.gkehub.configmanagement.v1alpha.ConfigManagementProto
          .internal_static_google_cloud_gkehub_configmanagement_v1alpha_SyncState_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.gkehub.configmanagement.v1alpha.ConfigManagementProto
          .internal_static_google_cloud_gkehub_configmanagement_v1alpha_SyncState_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.gkehub.configmanagement.v1alpha.SyncState.class,
              com.google.cloud.gkehub.configmanagement.v1alpha.SyncState.Builder.class);
    }

    // Construct using com.google.cloud.gkehub.configmanagement.v1alpha.SyncState.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      sourceToken_ = "";
      importToken_ = "";
      syncToken_ = "";
      lastSync_ = "";
      lastSyncTime_ = null;
      if (lastSyncTimeBuilder_ != null) {
        lastSyncTimeBuilder_.dispose();
        lastSyncTimeBuilder_ = null;
      }
      code_ = 0;
      if (errorsBuilder_ == null) {
        errors_ = java.util.Collections.emptyList();
      } else {
        errors_ = null;
        errorsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000040);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.gkehub.configmanagement.v1alpha.ConfigManagementProto
          .internal_static_google_cloud_gkehub_configmanagement_v1alpha_SyncState_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.gkehub.configmanagement.v1alpha.SyncState getDefaultInstanceForType() {
      return com.google.cloud.gkehub.configmanagement.v1alpha.SyncState.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.gkehub.configmanagement.v1alpha.SyncState build() {
      com.google.cloud.gkehub.configmanagement.v1alpha.SyncState result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.gkehub.configmanagement.v1alpha.SyncState buildPartial() {
      com.google.cloud.gkehub.configmanagement.v1alpha.SyncState result =
          new com.google.cloud.gkehub.configmanagement.v1alpha.SyncState(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.gkehub.configmanagement.v1alpha.SyncState result) {
      if (errorsBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)) {
          errors_ = java.util.Collections.unmodifiableList(errors_);
          bitField0_ = (bitField0_ & ~0x00000040);
        }
        result.errors_ = errors_;
      } else {
        result.errors_ = errorsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.gkehub.configmanagement.v1alpha.SyncState result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.sourceToken_ = sourceToken_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.importToken_ = importToken_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.syncToken_ = syncToken_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.lastSync_ = lastSync_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.lastSyncTime_ =
            lastSyncTimeBuilder_ == null ? lastSyncTime_ : lastSyncTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.code_ = code_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.gkehub.configmanagement.v1alpha.SyncState) {
        return mergeFrom((com.google.cloud.gkehub.configmanagement.v1alpha.SyncState) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.gkehub.configmanagement.v1alpha.SyncState other) {
      if (other == com.google.cloud.gkehub.configmanagement.v1alpha.SyncState.getDefaultInstance())
        return this;
      if (!other.getSourceToken().isEmpty()) {
        sourceToken_ = other.sourceToken_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getImportToken().isEmpty()) {
        importToken_ = other.importToken_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getSyncToken().isEmpty()) {
        syncToken_ = other.syncToken_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getLastSync().isEmpty()) {
        lastSync_ = other.lastSync_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasLastSyncTime()) {
        mergeLastSyncTime(other.getLastSyncTime());
      }
      if (other.code_ != 0) {
        setCodeValue(other.getCodeValue());
      }
      if (errorsBuilder_ == null) {
        if (!other.errors_.isEmpty()) {
          if (errors_.isEmpty()) {
            errors_ = other.errors_;
            bitField0_ = (bitField0_ & ~0x00000040);
          } else {
            ensureErrorsIsMutable();
            errors_.addAll(other.errors_);
          }
          onChanged();
        }
      } else {
        if (!other.errors_.isEmpty()) {
          if (errorsBuilder_.isEmpty()) {
            errorsBuilder_.dispose();
            errorsBuilder_ = null;
            errors_ = other.errors_;
            bitField0_ = (bitField0_ & ~0x00000040);
            errorsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getErrorsFieldBuilder()
                    : null;
          } else {
            errorsBuilder_.addAllMessages(other.errors_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                sourceToken_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                importToken_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                syncToken_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                lastSync_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 40:
              {
                code_ = input.readEnum();
                bitField0_ |= 0x00000020;
                break;
              } // case 40
            case 50:
              {
                com.google.cloud.gkehub.configmanagement.v1alpha.SyncError m =
                    input.readMessage(
                        com.google.cloud.gkehub.configmanagement.v1alpha.SyncError.parser(),
                        extensionRegistry);
                if (errorsBuilder_ == null) {
                  ensureErrorsIsMutable();
                  errors_.add(m);
                } else {
                  errorsBuilder_.addMessage(m);
                }
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getLastSyncTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object sourceToken_ = "";
    /**
     *
     *
     * <pre>
     * Token indicating the state of the repo.
     * </pre>
     *
     * <code>string source_token = 1;</code>
     *
     * @return The sourceToken.
     */
    public java.lang.String getSourceToken() {
      java.lang.Object ref = sourceToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sourceToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Token indicating the state of the repo.
     * </pre>
     *
     * <code>string source_token = 1;</code>
     *
     * @return The bytes for sourceToken.
     */
    public com.google.protobuf.ByteString getSourceTokenBytes() {
      java.lang.Object ref = sourceToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sourceToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Token indicating the state of the repo.
     * </pre>
     *
     * <code>string source_token = 1;</code>
     *
     * @param value The sourceToken to set.
     * @return This builder for chaining.
     */
    public Builder setSourceToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      sourceToken_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Token indicating the state of the repo.
     * </pre>
     *
     * <code>string source_token = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSourceToken() {
      sourceToken_ = getDefaultInstance().getSourceToken();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Token indicating the state of the repo.
     * </pre>
     *
     * <code>string source_token = 1;</code>
     *
     * @param value The bytes for sourceToken to set.
     * @return This builder for chaining.
     */
    public Builder setSourceTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      sourceToken_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object importToken_ = "";
    /**
     *
     *
     * <pre>
     * Token indicating the state of the importer.
     * </pre>
     *
     * <code>string import_token = 2;</code>
     *
     * @return The importToken.
     */
    public java.lang.String getImportToken() {
      java.lang.Object ref = importToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        importToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Token indicating the state of the importer.
     * </pre>
     *
     * <code>string import_token = 2;</code>
     *
     * @return The bytes for importToken.
     */
    public com.google.protobuf.ByteString getImportTokenBytes() {
      java.lang.Object ref = importToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        importToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Token indicating the state of the importer.
     * </pre>
     *
     * <code>string import_token = 2;</code>
     *
     * @param value The importToken to set.
     * @return This builder for chaining.
     */
    public Builder setImportToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      importToken_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Token indicating the state of the importer.
     * </pre>
     *
     * <code>string import_token = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearImportToken() {
      importToken_ = getDefaultInstance().getImportToken();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Token indicating the state of the importer.
     * </pre>
     *
     * <code>string import_token = 2;</code>
     *
     * @param value The bytes for importToken to set.
     * @return This builder for chaining.
     */
    public Builder setImportTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      importToken_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object syncToken_ = "";
    /**
     *
     *
     * <pre>
     * Token indicating the state of the syncer.
     * </pre>
     *
     * <code>string sync_token = 3;</code>
     *
     * @return The syncToken.
     */
    public java.lang.String getSyncToken() {
      java.lang.Object ref = syncToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        syncToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Token indicating the state of the syncer.
     * </pre>
     *
     * <code>string sync_token = 3;</code>
     *
     * @return The bytes for syncToken.
     */
    public com.google.protobuf.ByteString getSyncTokenBytes() {
      java.lang.Object ref = syncToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        syncToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Token indicating the state of the syncer.
     * </pre>
     *
     * <code>string sync_token = 3;</code>
     *
     * @param value The syncToken to set.
     * @return This builder for chaining.
     */
    public Builder setSyncToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      syncToken_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Token indicating the state of the syncer.
     * </pre>
     *
     * <code>string sync_token = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSyncToken() {
      syncToken_ = getDefaultInstance().getSyncToken();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Token indicating the state of the syncer.
     * </pre>
     *
     * <code>string sync_token = 3;</code>
     *
     * @param value The bytes for syncToken to set.
     * @return This builder for chaining.
     */
    public Builder setSyncTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      syncToken_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object lastSync_ = "";
    /**
     *
     *
     * <pre>
     * Deprecated: use last_sync_time instead.
     * Timestamp of when ACM last successfully synced the repo
     * The time format is specified in https://golang.org/pkg/time/#Time.String
     * </pre>
     *
     * <code>string last_sync = 4 [deprecated = true];</code>
     *
     * @deprecated google.cloud.gkehub.configmanagement.v1alpha.SyncState.last_sync is deprecated.
     *     See google/cloud/gkehub/v1alpha/configmanagement/configmanagement.proto;l=320
     * @return The lastSync.
     */
    @java.lang.Deprecated
    public java.lang.String getLastSync() {
      java.lang.Object ref = lastSync_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        lastSync_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated: use last_sync_time instead.
     * Timestamp of when ACM last successfully synced the repo
     * The time format is specified in https://golang.org/pkg/time/#Time.String
     * </pre>
     *
     * <code>string last_sync = 4 [deprecated = true];</code>
     *
     * @deprecated google.cloud.gkehub.configmanagement.v1alpha.SyncState.last_sync is deprecated.
     *     See google/cloud/gkehub/v1alpha/configmanagement/configmanagement.proto;l=320
     * @return The bytes for lastSync.
     */
    @java.lang.Deprecated
    public com.google.protobuf.ByteString getLastSyncBytes() {
      java.lang.Object ref = lastSync_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        lastSync_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated: use last_sync_time instead.
     * Timestamp of when ACM last successfully synced the repo
     * The time format is specified in https://golang.org/pkg/time/#Time.String
     * </pre>
     *
     * <code>string last_sync = 4 [deprecated = true];</code>
     *
     * @deprecated google.cloud.gkehub.configmanagement.v1alpha.SyncState.last_sync is deprecated.
     *     See google/cloud/gkehub/v1alpha/configmanagement/configmanagement.proto;l=320
     * @param value The lastSync to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setLastSync(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      lastSync_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: use last_sync_time instead.
     * Timestamp of when ACM last successfully synced the repo
     * The time format is specified in https://golang.org/pkg/time/#Time.String
     * </pre>
     *
     * <code>string last_sync = 4 [deprecated = true];</code>
     *
     * @deprecated google.cloud.gkehub.configmanagement.v1alpha.SyncState.last_sync is deprecated.
     *     See google/cloud/gkehub/v1alpha/configmanagement/configmanagement.proto;l=320
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearLastSync() {
      lastSync_ = getDefaultInstance().getLastSync();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: use last_sync_time instead.
     * Timestamp of when ACM last successfully synced the repo
     * The time format is specified in https://golang.org/pkg/time/#Time.String
     * </pre>
     *
     * <code>string last_sync = 4 [deprecated = true];</code>
     *
     * @deprecated google.cloud.gkehub.configmanagement.v1alpha.SyncState.last_sync is deprecated.
     *     See google/cloud/gkehub/v1alpha/configmanagement/configmanagement.proto;l=320
     * @param value The bytes for lastSync to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setLastSyncBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      lastSync_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp lastSyncTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        lastSyncTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Timestamp type of when ACM last successfully synced the repo
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_sync_time = 7;</code>
     *
     * @return Whether the lastSyncTime field is set.
     */
    public boolean hasLastSyncTime() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Timestamp type of when ACM last successfully synced the repo
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_sync_time = 7;</code>
     *
     * @return The lastSyncTime.
     */
    public com.google.protobuf.Timestamp getLastSyncTime() {
      if (lastSyncTimeBuilder_ == null) {
        return lastSyncTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : lastSyncTime_;
      } else {
        return lastSyncTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Timestamp type of when ACM last successfully synced the repo
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_sync_time = 7;</code>
     */
    public Builder setLastSyncTime(com.google.protobuf.Timestamp value) {
      if (lastSyncTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        lastSyncTime_ = value;
      } else {
        lastSyncTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Timestamp type of when ACM last successfully synced the repo
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_sync_time = 7;</code>
     */
    public Builder setLastSyncTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (lastSyncTimeBuilder_ == null) {
        lastSyncTime_ = builderForValue.build();
      } else {
        lastSyncTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Timestamp type of when ACM last successfully synced the repo
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_sync_time = 7;</code>
     */
    public Builder mergeLastSyncTime(com.google.protobuf.Timestamp value) {
      if (lastSyncTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && lastSyncTime_ != null
            && lastSyncTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getLastSyncTimeBuilder().mergeFrom(value);
        } else {
          lastSyncTime_ = value;
        }
      } else {
        lastSyncTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Timestamp type of when ACM last successfully synced the repo
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_sync_time = 7;</code>
     */
    public Builder clearLastSyncTime() {
      bitField0_ = (bitField0_ & ~0x00000010);
      lastSyncTime_ = null;
      if (lastSyncTimeBuilder_ != null) {
        lastSyncTimeBuilder_.dispose();
        lastSyncTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Timestamp type of when ACM last successfully synced the repo
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_sync_time = 7;</code>
     */
    public com.google.protobuf.Timestamp.Builder getLastSyncTimeBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getLastSyncTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Timestamp type of when ACM last successfully synced the repo
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_sync_time = 7;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getLastSyncTimeOrBuilder() {
      if (lastSyncTimeBuilder_ != null) {
        return lastSyncTimeBuilder_.getMessageOrBuilder();
      } else {
        return lastSyncTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : lastSyncTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Timestamp type of when ACM last successfully synced the repo
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_sync_time = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getLastSyncTimeFieldBuilder() {
      if (lastSyncTimeBuilder_ == null) {
        lastSyncTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getLastSyncTime(), getParentForChildren(), isClean());
        lastSyncTime_ = null;
      }
      return lastSyncTimeBuilder_;
    }

    private int code_ = 0;
    /**
     *
     *
     * <pre>
     * Sync status code
     * </pre>
     *
     * <code>.google.cloud.gkehub.configmanagement.v1alpha.SyncState.SyncCode code = 5;</code>
     *
     * @return The enum numeric value on the wire for code.
     */
    @java.lang.Override
    public int getCodeValue() {
      return code_;
    }
    /**
     *
     *
     * <pre>
     * Sync status code
     * </pre>
     *
     * <code>.google.cloud.gkehub.configmanagement.v1alpha.SyncState.SyncCode code = 5;</code>
     *
     * @param value The enum numeric value on the wire for code to set.
     * @return This builder for chaining.
     */
    public Builder setCodeValue(int value) {
      code_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sync status code
     * </pre>
     *
     * <code>.google.cloud.gkehub.configmanagement.v1alpha.SyncState.SyncCode code = 5;</code>
     *
     * @return The code.
     */
    @java.lang.Override
    public com.google.cloud.gkehub.configmanagement.v1alpha.SyncState.SyncCode getCode() {
      com.google.cloud.gkehub.configmanagement.v1alpha.SyncState.SyncCode result =
          com.google.cloud.gkehub.configmanagement.v1alpha.SyncState.SyncCode.forNumber(code_);
      return result == null
          ? com.google.cloud.gkehub.configmanagement.v1alpha.SyncState.SyncCode.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Sync status code
     * </pre>
     *
     * <code>.google.cloud.gkehub.configmanagement.v1alpha.SyncState.SyncCode code = 5;</code>
     *
     * @param value The code to set.
     * @return This builder for chaining.
     */
    public Builder setCode(
        com.google.cloud.gkehub.configmanagement.v1alpha.SyncState.SyncCode value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000020;
      code_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sync status code
     * </pre>
     *
     * <code>.google.cloud.gkehub.configmanagement.v1alpha.SyncState.SyncCode code = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCode() {
      bitField0_ = (bitField0_ & ~0x00000020);
      code_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.gkehub.configmanagement.v1alpha.SyncError> errors_ =
        java.util.Collections.emptyList();

    private void ensureErrorsIsMutable() {
      if (!((bitField0_ & 0x00000040) != 0)) {
        errors_ =
            new java.util.ArrayList<com.google.cloud.gkehub.configmanagement.v1alpha.SyncError>(
                errors_);
        bitField0_ |= 0x00000040;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.gkehub.configmanagement.v1alpha.SyncError,
            com.google.cloud.gkehub.configmanagement.v1alpha.SyncError.Builder,
            com.google.cloud.gkehub.configmanagement.v1alpha.SyncErrorOrBuilder>
        errorsBuilder_;

    /**
     *
     *
     * <pre>
     * A list of errors resulting from problematic configs.
     * This list will be truncated after 100 errors, although it is
     * unlikely for that many errors to simultaneously exist.
     * </pre>
     *
     * <code>repeated .google.cloud.gkehub.configmanagement.v1alpha.SyncError errors = 6;</code>
     */
    public java.util.List<com.google.cloud.gkehub.configmanagement.v1alpha.SyncError>
        getErrorsList() {
      if (errorsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(errors_);
      } else {
        return errorsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of errors resulting from problematic configs.
     * This list will be truncated after 100 errors, although it is
     * unlikely for that many errors to simultaneously exist.
     * </pre>
     *
     * <code>repeated .google.cloud.gkehub.configmanagement.v1alpha.SyncError errors = 6;</code>
     */
    public int getErrorsCount() {
      if (errorsBuilder_ == null) {
        return errors_.size();
      } else {
        return errorsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of errors resulting from problematic configs.
     * This list will be truncated after 100 errors, although it is
     * unlikely for that many errors to simultaneously exist.
     * </pre>
     *
     * <code>repeated .google.cloud.gkehub.configmanagement.v1alpha.SyncError errors = 6;</code>
     */
    public com.google.cloud.gkehub.configmanagement.v1alpha.SyncError getErrors(int index) {
      if (errorsBuilder_ == null) {
        return errors_.get(index);
      } else {
        return errorsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of errors resulting from problematic configs.
     * This list will be truncated after 100 errors, although it is
     * unlikely for that many errors to simultaneously exist.
     * </pre>
     *
     * <code>repeated .google.cloud.gkehub.configmanagement.v1alpha.SyncError errors = 6;</code>
     */
    public Builder setErrors(
        int index, com.google.cloud.gkehub.configmanagement.v1alpha.SyncError value) {
      if (errorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureErrorsIsMutable();
        errors_.set(index, value);
        onChanged();
      } else {
        errorsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of errors resulting from problematic configs.
     * This list will be truncated after 100 errors, although it is
     * unlikely for that many errors to simultaneously exist.
     * </pre>
     *
     * <code>repeated .google.cloud.gkehub.configmanagement.v1alpha.SyncError errors = 6;</code>
     */
    public Builder setErrors(
        int index,
        com.google.cloud.gkehub.configmanagement.v1alpha.SyncError.Builder builderForValue) {
      if (errorsBuilder_ == null) {
        ensureErrorsIsMutable();
        errors_.set(index, builderForValue.build());
        onChanged();
      } else {
        errorsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of errors resulting from problematic configs.
     * This list will be truncated after 100 errors, although it is
     * unlikely for that many errors to simultaneously exist.
     * </pre>
     *
     * <code>repeated .google.cloud.gkehub.configmanagement.v1alpha.SyncError errors = 6;</code>
     */
    public Builder addErrors(com.google.cloud.gkehub.configmanagement.v1alpha.SyncError value) {
      if (errorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureErrorsIsMutable();
        errors_.add(value);
        onChanged();
      } else {
        errorsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of errors resulting from problematic configs.
     * This list will be truncated after 100 errors, although it is
     * unlikely for that many errors to simultaneously exist.
     * </pre>
     *
     * <code>repeated .google.cloud.gkehub.configmanagement.v1alpha.SyncError errors = 6;</code>
     */
    public Builder addErrors(
        int index, com.google.cloud.gkehub.configmanagement.v1alpha.SyncError value) {
      if (errorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureErrorsIsMutable();
        errors_.add(index, value);
        onChanged();
      } else {
        errorsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of errors resulting from problematic configs.
     * This list will be truncated after 100 errors, although it is
     * unlikely for that many errors to simultaneously exist.
     * </pre>
     *
     * <code>repeated .google.cloud.gkehub.configmanagement.v1alpha.SyncError errors = 6;</code>
     */
    public Builder addErrors(
        com.google.cloud.gkehub.configmanagement.v1alpha.SyncError.Builder builderForValue) {
      if (errorsBuilder_ == null) {
        ensureErrorsIsMutable();
        errors_.add(builderForValue.build());
        onChanged();
      } else {
        errorsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of errors resulting from problematic configs.
     * This list will be truncated after 100 errors, although it is
     * unlikely for that many errors to simultaneously exist.
     * </pre>
     *
     * <code>repeated .google.cloud.gkehub.configmanagement.v1alpha.SyncError errors = 6;</code>
     */
    public Builder addErrors(
        int index,
        com.google.cloud.gkehub.configmanagement.v1alpha.SyncError.Builder builderForValue) {
      if (errorsBuilder_ == null) {
        ensureErrorsIsMutable();
        errors_.add(index, builderForValue.build());
        onChanged();
      } else {
        errorsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of errors resulting from problematic configs.
     * This list will be truncated after 100 errors, although it is
     * unlikely for that many errors to simultaneously exist.
     * </pre>
     *
     * <code>repeated .google.cloud.gkehub.configmanagement.v1alpha.SyncError errors = 6;</code>
     */
    public Builder addAllErrors(
        java.lang.Iterable<? extends com.google.cloud.gkehub.configmanagement.v1alpha.SyncError>
            values) {
      if (errorsBuilder_ == null) {
        ensureErrorsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, errors_);
        onChanged();
      } else {
        errorsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of errors resulting from problematic configs.
     * This list will be truncated after 100 errors, although it is
     * unlikely for that many errors to simultaneously exist.
     * </pre>
     *
     * <code>repeated .google.cloud.gkehub.configmanagement.v1alpha.SyncError errors = 6;</code>
     */
    public Builder clearErrors() {
      if (errorsBuilder_ == null) {
        errors_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000040);
        onChanged();
      } else {
        errorsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of errors resulting from problematic configs.
     * This list will be truncated after 100 errors, although it is
     * unlikely for that many errors to simultaneously exist.
     * </pre>
     *
     * <code>repeated .google.cloud.gkehub.configmanagement.v1alpha.SyncError errors = 6;</code>
     */
    public Builder removeErrors(int index) {
      if (errorsBuilder_ == null) {
        ensureErrorsIsMutable();
        errors_.remove(index);
        onChanged();
      } else {
        errorsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of errors resulting from problematic configs.
     * This list will be truncated after 100 errors, although it is
     * unlikely for that many errors to simultaneously exist.
     * </pre>
     *
     * <code>repeated .google.cloud.gkehub.configmanagement.v1alpha.SyncError errors = 6;</code>
     */
    public com.google.cloud.gkehub.configmanagement.v1alpha.SyncError.Builder getErrorsBuilder(
        int index) {
      return getErrorsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * A list of errors resulting from problematic configs.
     * This list will be truncated after 100 errors, although it is
     * unlikely for that many errors to simultaneously exist.
     * </pre>
     *
     * <code>repeated .google.cloud.gkehub.configmanagement.v1alpha.SyncError errors = 6;</code>
     */
    public com.google.cloud.gkehub.configmanagement.v1alpha.SyncErrorOrBuilder getErrorsOrBuilder(
        int index) {
      if (errorsBuilder_ == null) {
        return errors_.get(index);
      } else {
        return errorsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of errors resulting from problematic configs.
     * This list will be truncated after 100 errors, although it is
     * unlikely for that many errors to simultaneously exist.
     * </pre>
     *
     * <code>repeated .google.cloud.gkehub.configmanagement.v1alpha.SyncError errors = 6;</code>
     */
    public java.util.List<
            ? extends com.google.cloud.gkehub.configmanagement.v1alpha.SyncErrorOrBuilder>
        getErrorsOrBuilderList() {
      if (errorsBuilder_ != null) {
        return errorsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(errors_);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of errors resulting from problematic configs.
     * This list will be truncated after 100 errors, although it is
     * unlikely for that many errors to simultaneously exist.
     * </pre>
     *
     * <code>repeated .google.cloud.gkehub.configmanagement.v1alpha.SyncError errors = 6;</code>
     */
    public com.google.cloud.gkehub.configmanagement.v1alpha.SyncError.Builder addErrorsBuilder() {
      return getErrorsFieldBuilder()
          .addBuilder(
              com.google.cloud.gkehub.configmanagement.v1alpha.SyncError.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of errors resulting from problematic configs.
     * This list will be truncated after 100 errors, although it is
     * unlikely for that many errors to simultaneously exist.
     * </pre>
     *
     * <code>repeated .google.cloud.gkehub.configmanagement.v1alpha.SyncError errors = 6;</code>
     */
    public com.google.cloud.gkehub.configmanagement.v1alpha.SyncError.Builder addErrorsBuilder(
        int index) {
      return getErrorsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.gkehub.configmanagement.v1alpha.SyncError.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of errors resulting from problematic configs.
     * This list will be truncated after 100 errors, although it is
     * unlikely for that many errors to simultaneously exist.
     * </pre>
     *
     * <code>repeated .google.cloud.gkehub.configmanagement.v1alpha.SyncError errors = 6;</code>
     */
    public java.util.List<com.google.cloud.gkehub.configmanagement.v1alpha.SyncError.Builder>
        getErrorsBuilderList() {
      return getErrorsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.gkehub.configmanagement.v1alpha.SyncError,
            com.google.cloud.gkehub.configmanagement.v1alpha.SyncError.Builder,
            com.google.cloud.gkehub.configmanagement.v1alpha.SyncErrorOrBuilder>
        getErrorsFieldBuilder() {
      if (errorsBuilder_ == null) {
        errorsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.gkehub.configmanagement.v1alpha.SyncError,
                com.google.cloud.gkehub.configmanagement.v1alpha.SyncError.Builder,
                com.google.cloud.gkehub.configmanagement.v1alpha.SyncErrorOrBuilder>(
                errors_, ((bitField0_ & 0x00000040) != 0), getParentForChildren(), isClean());
        errors_ = null;
      }
      return errorsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.gkehub.configmanagement.v1alpha.SyncState)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.gkehub.configmanagement.v1alpha.SyncState)
  private static final com.google.cloud.gkehub.configmanagement.v1alpha.SyncState DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.gkehub.configmanagement.v1alpha.SyncState();
  }

  public static com.google.cloud.gkehub.configmanagement.v1alpha.SyncState getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SyncState> PARSER =
      new com.google.protobuf.AbstractParser<SyncState>() {
        @java.lang.Override
        public SyncState parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SyncState> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SyncState> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.gkehub.configmanagement.v1alpha.SyncState getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
