/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/gkehub/v1alpha/servicemesh/servicemesh.proto

package com.google.cloud.gkehub.servicemesh.v1alpha;

/**
 *
 *
 * <pre>
 * AnalysisMessage is a single message produced by an analyzer, and
 * it used to communicate to the end user about the state of their Service
 * Mesh configuration.
 * </pre>
 *
 * Protobuf type {@code google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessage}
 */
public final class AnalysisMessage extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessage)
    AnalysisMessageOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AnalysisMessage.newBuilder() to construct.
  private AnalysisMessage(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AnalysisMessage() {
    description_ = "";
    resourcePaths_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AnalysisMessage();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.gkehub.servicemesh.v1alpha.ServiceMeshProto
        .internal_static_google_cloud_gkehub_servicemesh_v1alpha_AnalysisMessage_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.gkehub.servicemesh.v1alpha.ServiceMeshProto
        .internal_static_google_cloud_gkehub_servicemesh_v1alpha_AnalysisMessage_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessage.class,
            com.google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessage.Builder.class);
  }

  public static final int MESSAGE_BASE_FIELD_NUMBER = 1;
  private com.google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessageBase messageBase_;
  /**
   *
   *
   * <pre>
   * Details common to all types of Istio and ServiceMesh analysis messages.
   * </pre>
   *
   * <code>.google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessageBase message_base = 1;</code>
   *
   * @return Whether the messageBase field is set.
   */
  @java.lang.Override
  public boolean hasMessageBase() {
    return messageBase_ != null;
  }
  /**
   *
   *
   * <pre>
   * Details common to all types of Istio and ServiceMesh analysis messages.
   * </pre>
   *
   * <code>.google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessageBase message_base = 1;</code>
   *
   * @return The messageBase.
   */
  @java.lang.Override
  public com.google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessageBase getMessageBase() {
    return messageBase_ == null
        ? com.google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessageBase.getDefaultInstance()
        : messageBase_;
  }
  /**
   *
   *
   * <pre>
   * Details common to all types of Istio and ServiceMesh analysis messages.
   * </pre>
   *
   * <code>.google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessageBase message_base = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessageBaseOrBuilder
      getMessageBaseOrBuilder() {
    return messageBase_ == null
        ? com.google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessageBase.getDefaultInstance()
        : messageBase_;
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * A human readable description of what the error means. It is suitable for
   * non-internationalize display purposes.
   * </pre>
   *
   * <code>string description = 2;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A human readable description of what the error means. It is suitable for
   * non-internationalize display purposes.
   * </pre>
   *
   * <code>string description = 2;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RESOURCE_PATHS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList resourcePaths_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * A list of strings specifying the resource identifiers that were the cause
   * of message generation.
   * A "path" here may be:
   * * MEMBERSHIP_ID if the cause is a specific member cluster
   * * MEMBERSHIP_ID/(NAMESPACE&#92;/)?RESOURCETYPE/NAME if the cause is a resource
   * in a cluster
   * </pre>
   *
   * <code>repeated string resource_paths = 3;</code>
   *
   * @return A list containing the resourcePaths.
   */
  public com.google.protobuf.ProtocolStringList getResourcePathsList() {
    return resourcePaths_;
  }
  /**
   *
   *
   * <pre>
   * A list of strings specifying the resource identifiers that were the cause
   * of message generation.
   * A "path" here may be:
   * * MEMBERSHIP_ID if the cause is a specific member cluster
   * * MEMBERSHIP_ID/(NAMESPACE&#92;/)?RESOURCETYPE/NAME if the cause is a resource
   * in a cluster
   * </pre>
   *
   * <code>repeated string resource_paths = 3;</code>
   *
   * @return The count of resourcePaths.
   */
  public int getResourcePathsCount() {
    return resourcePaths_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of strings specifying the resource identifiers that were the cause
   * of message generation.
   * A "path" here may be:
   * * MEMBERSHIP_ID if the cause is a specific member cluster
   * * MEMBERSHIP_ID/(NAMESPACE&#92;/)?RESOURCETYPE/NAME if the cause is a resource
   * in a cluster
   * </pre>
   *
   * <code>repeated string resource_paths = 3;</code>
   *
   * @param index The index of the element to return.
   * @return The resourcePaths at the given index.
   */
  public java.lang.String getResourcePaths(int index) {
    return resourcePaths_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of strings specifying the resource identifiers that were the cause
   * of message generation.
   * A "path" here may be:
   * * MEMBERSHIP_ID if the cause is a specific member cluster
   * * MEMBERSHIP_ID/(NAMESPACE&#92;/)?RESOURCETYPE/NAME if the cause is a resource
   * in a cluster
   * </pre>
   *
   * <code>repeated string resource_paths = 3;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the resourcePaths at the given index.
   */
  public com.google.protobuf.ByteString getResourcePathsBytes(int index) {
    return resourcePaths_.getByteString(index);
  }

  public static final int ARGS_FIELD_NUMBER = 4;
  private com.google.protobuf.Struct args_;
  /**
   *
   *
   * <pre>
   * A UI can combine these args with a template (based on message_base.type)
   * to produce an internationalized message.
   * </pre>
   *
   * <code>.google.protobuf.Struct args = 4;</code>
   *
   * @return Whether the args field is set.
   */
  @java.lang.Override
  public boolean hasArgs() {
    return args_ != null;
  }
  /**
   *
   *
   * <pre>
   * A UI can combine these args with a template (based on message_base.type)
   * to produce an internationalized message.
   * </pre>
   *
   * <code>.google.protobuf.Struct args = 4;</code>
   *
   * @return The args.
   */
  @java.lang.Override
  public com.google.protobuf.Struct getArgs() {
    return args_ == null ? com.google.protobuf.Struct.getDefaultInstance() : args_;
  }
  /**
   *
   *
   * <pre>
   * A UI can combine these args with a template (based on message_base.type)
   * to produce an internationalized message.
   * </pre>
   *
   * <code>.google.protobuf.Struct args = 4;</code>
   */
  @java.lang.Override
  public com.google.protobuf.StructOrBuilder getArgsOrBuilder() {
    return args_ == null ? com.google.protobuf.Struct.getDefaultInstance() : args_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (messageBase_ != null) {
      output.writeMessage(1, getMessageBase());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, description_);
    }
    for (int i = 0; i < resourcePaths_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, resourcePaths_.getRaw(i));
    }
    if (args_ != null) {
      output.writeMessage(4, getArgs());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (messageBase_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getMessageBase());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, description_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < resourcePaths_.size(); i++) {
        dataSize += computeStringSizeNoTag(resourcePaths_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getResourcePathsList().size();
    }
    if (args_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getArgs());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessage)) {
      return super.equals(obj);
    }
    com.google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessage other =
        (com.google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessage) obj;

    if (hasMessageBase() != other.hasMessageBase()) return false;
    if (hasMessageBase()) {
      if (!getMessageBase().equals(other.getMessageBase())) return false;
    }
    if (!getDescription().equals(other.getDescription())) return false;
    if (!getResourcePathsList().equals(other.getResourcePathsList())) return false;
    if (hasArgs() != other.hasArgs()) return false;
    if (hasArgs()) {
      if (!getArgs().equals(other.getArgs())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasMessageBase()) {
      hash = (37 * hash) + MESSAGE_BASE_FIELD_NUMBER;
      hash = (53 * hash) + getMessageBase().hashCode();
    }
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    if (getResourcePathsCount() > 0) {
      hash = (37 * hash) + RESOURCE_PATHS_FIELD_NUMBER;
      hash = (53 * hash) + getResourcePathsList().hashCode();
    }
    if (hasArgs()) {
      hash = (37 * hash) + ARGS_FIELD_NUMBER;
      hash = (53 * hash) + getArgs().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessage parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessage parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessage parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessage parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessage parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessage parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessage parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessage parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessage parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessage parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessage parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessage parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessage prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * AnalysisMessage is a single message produced by an analyzer, and
   * it used to communicate to the end user about the state of their Service
   * Mesh configuration.
   * </pre>
   *
   * Protobuf type {@code google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessage}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessage)
      com.google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessageOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.gkehub.servicemesh.v1alpha.ServiceMeshProto
          .internal_static_google_cloud_gkehub_servicemesh_v1alpha_AnalysisMessage_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.gkehub.servicemesh.v1alpha.ServiceMeshProto
          .internal_static_google_cloud_gkehub_servicemesh_v1alpha_AnalysisMessage_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessage.class,
              com.google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessage.Builder.class);
    }

    // Construct using com.google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessage.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      messageBase_ = null;
      if (messageBaseBuilder_ != null) {
        messageBaseBuilder_.dispose();
        messageBaseBuilder_ = null;
      }
      description_ = "";
      resourcePaths_ = com.google.protobuf.LazyStringArrayList.emptyList();
      args_ = null;
      if (argsBuilder_ != null) {
        argsBuilder_.dispose();
        argsBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.gkehub.servicemesh.v1alpha.ServiceMeshProto
          .internal_static_google_cloud_gkehub_servicemesh_v1alpha_AnalysisMessage_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessage getDefaultInstanceForType() {
      return com.google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessage.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessage build() {
      com.google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessage result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessage buildPartial() {
      com.google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessage result =
          new com.google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessage(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessage result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.messageBase_ =
            messageBaseBuilder_ == null ? messageBase_ : messageBaseBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        resourcePaths_.makeImmutable();
        result.resourcePaths_ = resourcePaths_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.args_ = argsBuilder_ == null ? args_ : argsBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessage) {
        return mergeFrom((com.google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessage) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessage other) {
      if (other == com.google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessage.getDefaultInstance())
        return this;
      if (other.hasMessageBase()) {
        mergeMessageBase(other.getMessageBase());
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.resourcePaths_.isEmpty()) {
        if (resourcePaths_.isEmpty()) {
          resourcePaths_ = other.resourcePaths_;
          bitField0_ |= 0x00000004;
        } else {
          ensureResourcePathsIsMutable();
          resourcePaths_.addAll(other.resourcePaths_);
        }
        onChanged();
      }
      if (other.hasArgs()) {
        mergeArgs(other.getArgs());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getMessageBaseFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureResourcePathsIsMutable();
                resourcePaths_.add(s);
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getArgsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessageBase messageBase_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessageBase,
            com.google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessageBase.Builder,
            com.google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessageBaseOrBuilder>
        messageBaseBuilder_;
    /**
     *
     *
     * <pre>
     * Details common to all types of Istio and ServiceMesh analysis messages.
     * </pre>
     *
     * <code>.google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessageBase message_base = 1;</code>
     *
     * @return Whether the messageBase field is set.
     */
    public boolean hasMessageBase() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Details common to all types of Istio and ServiceMesh analysis messages.
     * </pre>
     *
     * <code>.google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessageBase message_base = 1;</code>
     *
     * @return The messageBase.
     */
    public com.google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessageBase getMessageBase() {
      if (messageBaseBuilder_ == null) {
        return messageBase_ == null
            ? com.google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessageBase.getDefaultInstance()
            : messageBase_;
      } else {
        return messageBaseBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Details common to all types of Istio and ServiceMesh analysis messages.
     * </pre>
     *
     * <code>.google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessageBase message_base = 1;</code>
     */
    public Builder setMessageBase(
        com.google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessageBase value) {
      if (messageBaseBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        messageBase_ = value;
      } else {
        messageBaseBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details common to all types of Istio and ServiceMesh analysis messages.
     * </pre>
     *
     * <code>.google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessageBase message_base = 1;</code>
     */
    public Builder setMessageBase(
        com.google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessageBase.Builder builderForValue) {
      if (messageBaseBuilder_ == null) {
        messageBase_ = builderForValue.build();
      } else {
        messageBaseBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details common to all types of Istio and ServiceMesh analysis messages.
     * </pre>
     *
     * <code>.google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessageBase message_base = 1;</code>
     */
    public Builder mergeMessageBase(
        com.google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessageBase value) {
      if (messageBaseBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && messageBase_ != null
            && messageBase_
                != com.google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessageBase
                    .getDefaultInstance()) {
          getMessageBaseBuilder().mergeFrom(value);
        } else {
          messageBase_ = value;
        }
      } else {
        messageBaseBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details common to all types of Istio and ServiceMesh analysis messages.
     * </pre>
     *
     * <code>.google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessageBase message_base = 1;</code>
     */
    public Builder clearMessageBase() {
      bitField0_ = (bitField0_ & ~0x00000001);
      messageBase_ = null;
      if (messageBaseBuilder_ != null) {
        messageBaseBuilder_.dispose();
        messageBaseBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details common to all types of Istio and ServiceMesh analysis messages.
     * </pre>
     *
     * <code>.google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessageBase message_base = 1;</code>
     */
    public com.google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessageBase.Builder
        getMessageBaseBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getMessageBaseFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Details common to all types of Istio and ServiceMesh analysis messages.
     * </pre>
     *
     * <code>.google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessageBase message_base = 1;</code>
     */
    public com.google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessageBaseOrBuilder
        getMessageBaseOrBuilder() {
      if (messageBaseBuilder_ != null) {
        return messageBaseBuilder_.getMessageOrBuilder();
      } else {
        return messageBase_ == null
            ? com.google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessageBase.getDefaultInstance()
            : messageBase_;
      }
    }
    /**
     *
     *
     * <pre>
     * Details common to all types of Istio and ServiceMesh analysis messages.
     * </pre>
     *
     * <code>.google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessageBase message_base = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessageBase,
            com.google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessageBase.Builder,
            com.google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessageBaseOrBuilder>
        getMessageBaseFieldBuilder() {
      if (messageBaseBuilder_ == null) {
        messageBaseBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessageBase,
                com.google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessageBase.Builder,
                com.google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessageBaseOrBuilder>(
                getMessageBase(), getParentForChildren(), isClean());
        messageBase_ = null;
      }
      return messageBaseBuilder_;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * A human readable description of what the error means. It is suitable for
     * non-internationalize display purposes.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A human readable description of what the error means. It is suitable for
     * non-internationalize display purposes.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A human readable description of what the error means. It is suitable for
     * non-internationalize display purposes.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A human readable description of what the error means. It is suitable for
     * non-internationalize display purposes.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A human readable description of what the error means. It is suitable for
     * non-internationalize display purposes.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList resourcePaths_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureResourcePathsIsMutable() {
      if (!resourcePaths_.isModifiable()) {
        resourcePaths_ = new com.google.protobuf.LazyStringArrayList(resourcePaths_);
      }
      bitField0_ |= 0x00000004;
    }
    /**
     *
     *
     * <pre>
     * A list of strings specifying the resource identifiers that were the cause
     * of message generation.
     * A "path" here may be:
     * * MEMBERSHIP_ID if the cause is a specific member cluster
     * * MEMBERSHIP_ID/(NAMESPACE&#92;/)?RESOURCETYPE/NAME if the cause is a resource
     * in a cluster
     * </pre>
     *
     * <code>repeated string resource_paths = 3;</code>
     *
     * @return A list containing the resourcePaths.
     */
    public com.google.protobuf.ProtocolStringList getResourcePathsList() {
      resourcePaths_.makeImmutable();
      return resourcePaths_;
    }
    /**
     *
     *
     * <pre>
     * A list of strings specifying the resource identifiers that were the cause
     * of message generation.
     * A "path" here may be:
     * * MEMBERSHIP_ID if the cause is a specific member cluster
     * * MEMBERSHIP_ID/(NAMESPACE&#92;/)?RESOURCETYPE/NAME if the cause is a resource
     * in a cluster
     * </pre>
     *
     * <code>repeated string resource_paths = 3;</code>
     *
     * @return The count of resourcePaths.
     */
    public int getResourcePathsCount() {
      return resourcePaths_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of strings specifying the resource identifiers that were the cause
     * of message generation.
     * A "path" here may be:
     * * MEMBERSHIP_ID if the cause is a specific member cluster
     * * MEMBERSHIP_ID/(NAMESPACE&#92;/)?RESOURCETYPE/NAME if the cause is a resource
     * in a cluster
     * </pre>
     *
     * <code>repeated string resource_paths = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The resourcePaths at the given index.
     */
    public java.lang.String getResourcePaths(int index) {
      return resourcePaths_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A list of strings specifying the resource identifiers that were the cause
     * of message generation.
     * A "path" here may be:
     * * MEMBERSHIP_ID if the cause is a specific member cluster
     * * MEMBERSHIP_ID/(NAMESPACE&#92;/)?RESOURCETYPE/NAME if the cause is a resource
     * in a cluster
     * </pre>
     *
     * <code>repeated string resource_paths = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the resourcePaths at the given index.
     */
    public com.google.protobuf.ByteString getResourcePathsBytes(int index) {
      return resourcePaths_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * A list of strings specifying the resource identifiers that were the cause
     * of message generation.
     * A "path" here may be:
     * * MEMBERSHIP_ID if the cause is a specific member cluster
     * * MEMBERSHIP_ID/(NAMESPACE&#92;/)?RESOURCETYPE/NAME if the cause is a resource
     * in a cluster
     * </pre>
     *
     * <code>repeated string resource_paths = 3;</code>
     *
     * @param index The index to set the value at.
     * @param value The resourcePaths to set.
     * @return This builder for chaining.
     */
    public Builder setResourcePaths(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureResourcePathsIsMutable();
      resourcePaths_.set(index, value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of strings specifying the resource identifiers that were the cause
     * of message generation.
     * A "path" here may be:
     * * MEMBERSHIP_ID if the cause is a specific member cluster
     * * MEMBERSHIP_ID/(NAMESPACE&#92;/)?RESOURCETYPE/NAME if the cause is a resource
     * in a cluster
     * </pre>
     *
     * <code>repeated string resource_paths = 3;</code>
     *
     * @param value The resourcePaths to add.
     * @return This builder for chaining.
     */
    public Builder addResourcePaths(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureResourcePathsIsMutable();
      resourcePaths_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of strings specifying the resource identifiers that were the cause
     * of message generation.
     * A "path" here may be:
     * * MEMBERSHIP_ID if the cause is a specific member cluster
     * * MEMBERSHIP_ID/(NAMESPACE&#92;/)?RESOURCETYPE/NAME if the cause is a resource
     * in a cluster
     * </pre>
     *
     * <code>repeated string resource_paths = 3;</code>
     *
     * @param values The resourcePaths to add.
     * @return This builder for chaining.
     */
    public Builder addAllResourcePaths(java.lang.Iterable<java.lang.String> values) {
      ensureResourcePathsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, resourcePaths_);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of strings specifying the resource identifiers that were the cause
     * of message generation.
     * A "path" here may be:
     * * MEMBERSHIP_ID if the cause is a specific member cluster
     * * MEMBERSHIP_ID/(NAMESPACE&#92;/)?RESOURCETYPE/NAME if the cause is a resource
     * in a cluster
     * </pre>
     *
     * <code>repeated string resource_paths = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearResourcePaths() {
      resourcePaths_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of strings specifying the resource identifiers that were the cause
     * of message generation.
     * A "path" here may be:
     * * MEMBERSHIP_ID if the cause is a specific member cluster
     * * MEMBERSHIP_ID/(NAMESPACE&#92;/)?RESOURCETYPE/NAME if the cause is a resource
     * in a cluster
     * </pre>
     *
     * <code>repeated string resource_paths = 3;</code>
     *
     * @param value The bytes of the resourcePaths to add.
     * @return This builder for chaining.
     */
    public Builder addResourcePathsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureResourcePathsIsMutable();
      resourcePaths_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.Struct args_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        argsBuilder_;
    /**
     *
     *
     * <pre>
     * A UI can combine these args with a template (based on message_base.type)
     * to produce an internationalized message.
     * </pre>
     *
     * <code>.google.protobuf.Struct args = 4;</code>
     *
     * @return Whether the args field is set.
     */
    public boolean hasArgs() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * A UI can combine these args with a template (based on message_base.type)
     * to produce an internationalized message.
     * </pre>
     *
     * <code>.google.protobuf.Struct args = 4;</code>
     *
     * @return The args.
     */
    public com.google.protobuf.Struct getArgs() {
      if (argsBuilder_ == null) {
        return args_ == null ? com.google.protobuf.Struct.getDefaultInstance() : args_;
      } else {
        return argsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * A UI can combine these args with a template (based on message_base.type)
     * to produce an internationalized message.
     * </pre>
     *
     * <code>.google.protobuf.Struct args = 4;</code>
     */
    public Builder setArgs(com.google.protobuf.Struct value) {
      if (argsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        args_ = value;
      } else {
        argsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A UI can combine these args with a template (based on message_base.type)
     * to produce an internationalized message.
     * </pre>
     *
     * <code>.google.protobuf.Struct args = 4;</code>
     */
    public Builder setArgs(com.google.protobuf.Struct.Builder builderForValue) {
      if (argsBuilder_ == null) {
        args_ = builderForValue.build();
      } else {
        argsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A UI can combine these args with a template (based on message_base.type)
     * to produce an internationalized message.
     * </pre>
     *
     * <code>.google.protobuf.Struct args = 4;</code>
     */
    public Builder mergeArgs(com.google.protobuf.Struct value) {
      if (argsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && args_ != null
            && args_ != com.google.protobuf.Struct.getDefaultInstance()) {
          getArgsBuilder().mergeFrom(value);
        } else {
          args_ = value;
        }
      } else {
        argsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A UI can combine these args with a template (based on message_base.type)
     * to produce an internationalized message.
     * </pre>
     *
     * <code>.google.protobuf.Struct args = 4;</code>
     */
    public Builder clearArgs() {
      bitField0_ = (bitField0_ & ~0x00000008);
      args_ = null;
      if (argsBuilder_ != null) {
        argsBuilder_.dispose();
        argsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A UI can combine these args with a template (based on message_base.type)
     * to produce an internationalized message.
     * </pre>
     *
     * <code>.google.protobuf.Struct args = 4;</code>
     */
    public com.google.protobuf.Struct.Builder getArgsBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getArgsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A UI can combine these args with a template (based on message_base.type)
     * to produce an internationalized message.
     * </pre>
     *
     * <code>.google.protobuf.Struct args = 4;</code>
     */
    public com.google.protobuf.StructOrBuilder getArgsOrBuilder() {
      if (argsBuilder_ != null) {
        return argsBuilder_.getMessageOrBuilder();
      } else {
        return args_ == null ? com.google.protobuf.Struct.getDefaultInstance() : args_;
      }
    }
    /**
     *
     *
     * <pre>
     * A UI can combine these args with a template (based on message_base.type)
     * to produce an internationalized message.
     * </pre>
     *
     * <code>.google.protobuf.Struct args = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        getArgsFieldBuilder() {
      if (argsBuilder_ == null) {
        argsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Struct,
                com.google.protobuf.Struct.Builder,
                com.google.protobuf.StructOrBuilder>(getArgs(), getParentForChildren(), isClean());
        args_ = null;
      }
      return argsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessage)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessage)
  private static final com.google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessage DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessage();
  }

  public static com.google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessage getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AnalysisMessage> PARSER =
      new com.google.protobuf.AbstractParser<AnalysisMessage>() {
        @java.lang.Override
        public AnalysisMessage parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AnalysisMessage> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AnalysisMessage> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessage getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
