/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gkehub.v1alpha2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class MembershipName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_MEMBERSHIP = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/memberships/{membership}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String membership;

    @Deprecated
    protected MembershipName() {
        this.project = null;
        this.location = null;
        this.membership = null;
    }

    private MembershipName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.membership = (String)Preconditions.checkNotNull((Object)builder.getMembership());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getMembership() {
        return this.membership;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static MembershipName of(String project, String location, String membership) {
        return MembershipName.newBuilder().setProject(project).setLocation(location).setMembership(membership).build();
    }

    public static String format(String project, String location, String membership) {
        return MembershipName.newBuilder().setProject(project).setLocation(location).setMembership(membership).build().toString();
    }

    public static MembershipName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_MEMBERSHIP.validatedMatch(formattedString, "MembershipName.parse: formattedString not in valid format");
        return MembershipName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("membership"));
    }

    public static List<MembershipName> parseList(List<String> formattedStrings) {
        ArrayList<MembershipName> list = new ArrayList<MembershipName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(MembershipName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<MembershipName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (MembershipName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_MEMBERSHIP.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            MembershipName membershipName = this;
            synchronized (membershipName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.membership != null) {
                        fieldMapBuilder.put((Object)"membership", (Object)this.membership);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_MEMBERSHIP.instantiate(new String[]{"project", this.project, "location", this.location, "membership", this.membership});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            MembershipName that = (MembershipName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.membership, that.membership);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.membership);
    }

    public static class Builder {
        private String project;
        private String location;
        private String membership;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getMembership() {
            return this.membership;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setMembership(String membership) {
            this.membership = membership;
            return this;
        }

        private Builder(MembershipName membershipName) {
            this.project = membershipName.project;
            this.location = membershipName.location;
            this.membership = membershipName.membership;
        }

        public MembershipName build() {
            return new MembershipName(this);
        }
    }
}

