/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/gkehub/v1alpha2/membership.proto

package com.google.cloud.gkehub.v1alpha2;

/**
 *
 *
 * <pre>
 * KubernetesMetadata provides informational metadata for Memberships
 * that are created from Kubernetes Endpoints (currently, these are equivalent
 * to Kubernetes clusters).
 * </pre>
 *
 * Protobuf type {@code google.cloud.gkehub.v1alpha2.KubernetesMetadata}
 */
public final class KubernetesMetadata extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.gkehub.v1alpha2.KubernetesMetadata)
    KubernetesMetadataOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use KubernetesMetadata.newBuilder() to construct.
  private KubernetesMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private KubernetesMetadata() {
    kubernetesApiServerVersion_ = "";
    nodeProviderId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new KubernetesMetadata();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.gkehub.v1alpha2.MembershipProto
        .internal_static_google_cloud_gkehub_v1alpha2_KubernetesMetadata_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.gkehub.v1alpha2.MembershipProto
        .internal_static_google_cloud_gkehub_v1alpha2_KubernetesMetadata_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.gkehub.v1alpha2.KubernetesMetadata.class,
            com.google.cloud.gkehub.v1alpha2.KubernetesMetadata.Builder.class);
  }

  public static final int KUBERNETES_API_SERVER_VERSION_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object kubernetesApiServerVersion_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Kubernetes API server version string as reported by '/version'.
   * </pre>
   *
   * <code>string kubernetes_api_server_version = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The kubernetesApiServerVersion.
   */
  @java.lang.Override
  public java.lang.String getKubernetesApiServerVersion() {
    java.lang.Object ref = kubernetesApiServerVersion_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kubernetesApiServerVersion_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Kubernetes API server version string as reported by '/version'.
   * </pre>
   *
   * <code>string kubernetes_api_server_version = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The bytes for kubernetesApiServerVersion.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKubernetesApiServerVersionBytes() {
    java.lang.Object ref = kubernetesApiServerVersion_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kubernetesApiServerVersion_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NODE_PROVIDER_ID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object nodeProviderId_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Node providerID as reported by the first node in the list of nodes on
   * the Kubernetes endpoint. On Kubernetes platforms that support zero-node
   * clusters (like GKE-on-GCP), the node_count will be zero and the
   * node_provider_id will be empty.
   * </pre>
   *
   * <code>string node_provider_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The nodeProviderId.
   */
  @java.lang.Override
  public java.lang.String getNodeProviderId() {
    java.lang.Object ref = nodeProviderId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      nodeProviderId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Node providerID as reported by the first node in the list of nodes on
   * the Kubernetes endpoint. On Kubernetes platforms that support zero-node
   * clusters (like GKE-on-GCP), the node_count will be zero and the
   * node_provider_id will be empty.
   * </pre>
   *
   * <code>string node_provider_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for nodeProviderId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNodeProviderIdBytes() {
    java.lang.Object ref = nodeProviderId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      nodeProviderId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NODE_COUNT_FIELD_NUMBER = 3;
  private int nodeCount_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. Node count as reported by Kubernetes nodes resources.
   * </pre>
   *
   * <code>int32 node_count = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The nodeCount.
   */
  @java.lang.Override
  public int getNodeCount() {
    return nodeCount_;
  }

  public static final int VCPU_COUNT_FIELD_NUMBER = 4;
  private int vcpuCount_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. vCPU count as reported by Kubernetes nodes resources.
   * </pre>
   *
   * <code>int32 vcpu_count = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The vcpuCount.
   */
  @java.lang.Override
  public int getVcpuCount() {
    return vcpuCount_;
  }

  public static final int MEMORY_MB_FIELD_NUMBER = 5;
  private int memoryMb_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The total memory capacity as reported by the sum of all Kubernetes nodes
   * resources, defined in MB.
   * </pre>
   *
   * <code>int32 memory_mb = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The memoryMb.
   */
  @java.lang.Override
  public int getMemoryMb() {
    return memoryMb_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 100;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time at which these details were last updated. This update_time is
   * different from the Membership-level update_time since EndpointDetails are
   * updated internally for API consumers.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp update_time = 100 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time at which these details were last updated. This update_time is
   * different from the Membership-level update_time since EndpointDetails are
   * updated internally for API consumers.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp update_time = 100 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time at which these details were last updated. This update_time is
   * different from the Membership-level update_time since EndpointDetails are
   * updated internally for API consumers.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp update_time = 100 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kubernetesApiServerVersion_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, kubernetesApiServerVersion_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nodeProviderId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, nodeProviderId_);
    }
    if (nodeCount_ != 0) {
      output.writeInt32(3, nodeCount_);
    }
    if (vcpuCount_ != 0) {
      output.writeInt32(4, vcpuCount_);
    }
    if (memoryMb_ != 0) {
      output.writeInt32(5, memoryMb_);
    }
    if (updateTime_ != null) {
      output.writeMessage(100, getUpdateTime());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kubernetesApiServerVersion_)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(1, kubernetesApiServerVersion_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nodeProviderId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, nodeProviderId_);
    }
    if (nodeCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, nodeCount_);
    }
    if (vcpuCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, vcpuCount_);
    }
    if (memoryMb_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(5, memoryMb_);
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(100, getUpdateTime());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.gkehub.v1alpha2.KubernetesMetadata)) {
      return super.equals(obj);
    }
    com.google.cloud.gkehub.v1alpha2.KubernetesMetadata other =
        (com.google.cloud.gkehub.v1alpha2.KubernetesMetadata) obj;

    if (!getKubernetesApiServerVersion().equals(other.getKubernetesApiServerVersion()))
      return false;
    if (!getNodeProviderId().equals(other.getNodeProviderId())) return false;
    if (getNodeCount() != other.getNodeCount()) return false;
    if (getVcpuCount() != other.getVcpuCount()) return false;
    if (getMemoryMb() != other.getMemoryMb()) return false;
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + KUBERNETES_API_SERVER_VERSION_FIELD_NUMBER;
    hash = (53 * hash) + getKubernetesApiServerVersion().hashCode();
    hash = (37 * hash) + NODE_PROVIDER_ID_FIELD_NUMBER;
    hash = (53 * hash) + getNodeProviderId().hashCode();
    hash = (37 * hash) + NODE_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getNodeCount();
    hash = (37 * hash) + VCPU_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getVcpuCount();
    hash = (37 * hash) + MEMORY_MB_FIELD_NUMBER;
    hash = (53 * hash) + getMemoryMb();
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.gkehub.v1alpha2.KubernetesMetadata parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gkehub.v1alpha2.KubernetesMetadata parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gkehub.v1alpha2.KubernetesMetadata parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gkehub.v1alpha2.KubernetesMetadata parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gkehub.v1alpha2.KubernetesMetadata parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gkehub.v1alpha2.KubernetesMetadata parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gkehub.v1alpha2.KubernetesMetadata parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.gkehub.v1alpha2.KubernetesMetadata parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.gkehub.v1alpha2.KubernetesMetadata parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.gkehub.v1alpha2.KubernetesMetadata parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.gkehub.v1alpha2.KubernetesMetadata parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.gkehub.v1alpha2.KubernetesMetadata parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.gkehub.v1alpha2.KubernetesMetadata prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * KubernetesMetadata provides informational metadata for Memberships
   * that are created from Kubernetes Endpoints (currently, these are equivalent
   * to Kubernetes clusters).
   * </pre>
   *
   * Protobuf type {@code google.cloud.gkehub.v1alpha2.KubernetesMetadata}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.gkehub.v1alpha2.KubernetesMetadata)
      com.google.cloud.gkehub.v1alpha2.KubernetesMetadataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.gkehub.v1alpha2.MembershipProto
          .internal_static_google_cloud_gkehub_v1alpha2_KubernetesMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.gkehub.v1alpha2.MembershipProto
          .internal_static_google_cloud_gkehub_v1alpha2_KubernetesMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.gkehub.v1alpha2.KubernetesMetadata.class,
              com.google.cloud.gkehub.v1alpha2.KubernetesMetadata.Builder.class);
    }

    // Construct using com.google.cloud.gkehub.v1alpha2.KubernetesMetadata.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      kubernetesApiServerVersion_ = "";
      nodeProviderId_ = "";
      nodeCount_ = 0;
      vcpuCount_ = 0;
      memoryMb_ = 0;
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.gkehub.v1alpha2.MembershipProto
          .internal_static_google_cloud_gkehub_v1alpha2_KubernetesMetadata_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.gkehub.v1alpha2.KubernetesMetadata getDefaultInstanceForType() {
      return com.google.cloud.gkehub.v1alpha2.KubernetesMetadata.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.gkehub.v1alpha2.KubernetesMetadata build() {
      com.google.cloud.gkehub.v1alpha2.KubernetesMetadata result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.gkehub.v1alpha2.KubernetesMetadata buildPartial() {
      com.google.cloud.gkehub.v1alpha2.KubernetesMetadata result =
          new com.google.cloud.gkehub.v1alpha2.KubernetesMetadata(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.gkehub.v1alpha2.KubernetesMetadata result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.kubernetesApiServerVersion_ = kubernetesApiServerVersion_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.nodeProviderId_ = nodeProviderId_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.nodeCount_ = nodeCount_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.vcpuCount_ = vcpuCount_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.memoryMb_ = memoryMb_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.gkehub.v1alpha2.KubernetesMetadata) {
        return mergeFrom((com.google.cloud.gkehub.v1alpha2.KubernetesMetadata) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.gkehub.v1alpha2.KubernetesMetadata other) {
      if (other == com.google.cloud.gkehub.v1alpha2.KubernetesMetadata.getDefaultInstance())
        return this;
      if (!other.getKubernetesApiServerVersion().isEmpty()) {
        kubernetesApiServerVersion_ = other.kubernetesApiServerVersion_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getNodeProviderId().isEmpty()) {
        nodeProviderId_ = other.nodeProviderId_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.getNodeCount() != 0) {
        setNodeCount(other.getNodeCount());
      }
      if (other.getVcpuCount() != 0) {
        setVcpuCount(other.getVcpuCount());
      }
      if (other.getMemoryMb() != 0) {
        setMemoryMb(other.getMemoryMb());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                kubernetesApiServerVersion_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                nodeProviderId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                nodeCount_ = input.readInt32();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 32:
              {
                vcpuCount_ = input.readInt32();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 40:
              {
                memoryMb_ = input.readInt32();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            case 802:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 802
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object kubernetesApiServerVersion_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Kubernetes API server version string as reported by '/version'.
     * </pre>
     *
     * <code>string kubernetes_api_server_version = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The kubernetesApiServerVersion.
     */
    public java.lang.String getKubernetesApiServerVersion() {
      java.lang.Object ref = kubernetesApiServerVersion_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kubernetesApiServerVersion_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Kubernetes API server version string as reported by '/version'.
     * </pre>
     *
     * <code>string kubernetes_api_server_version = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The bytes for kubernetesApiServerVersion.
     */
    public com.google.protobuf.ByteString getKubernetesApiServerVersionBytes() {
      java.lang.Object ref = kubernetesApiServerVersion_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kubernetesApiServerVersion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Kubernetes API server version string as reported by '/version'.
     * </pre>
     *
     * <code>string kubernetes_api_server_version = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The kubernetesApiServerVersion to set.
     * @return This builder for chaining.
     */
    public Builder setKubernetesApiServerVersion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kubernetesApiServerVersion_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Kubernetes API server version string as reported by '/version'.
     * </pre>
     *
     * <code>string kubernetes_api_server_version = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKubernetesApiServerVersion() {
      kubernetesApiServerVersion_ = getDefaultInstance().getKubernetesApiServerVersion();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Kubernetes API server version string as reported by '/version'.
     * </pre>
     *
     * <code>string kubernetes_api_server_version = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The bytes for kubernetesApiServerVersion to set.
     * @return This builder for chaining.
     */
    public Builder setKubernetesApiServerVersionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kubernetesApiServerVersion_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object nodeProviderId_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Node providerID as reported by the first node in the list of nodes on
     * the Kubernetes endpoint. On Kubernetes platforms that support zero-node
     * clusters (like GKE-on-GCP), the node_count will be zero and the
     * node_provider_id will be empty.
     * </pre>
     *
     * <code>string node_provider_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The nodeProviderId.
     */
    public java.lang.String getNodeProviderId() {
      java.lang.Object ref = nodeProviderId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        nodeProviderId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Node providerID as reported by the first node in the list of nodes on
     * the Kubernetes endpoint. On Kubernetes platforms that support zero-node
     * clusters (like GKE-on-GCP), the node_count will be zero and the
     * node_provider_id will be empty.
     * </pre>
     *
     * <code>string node_provider_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for nodeProviderId.
     */
    public com.google.protobuf.ByteString getNodeProviderIdBytes() {
      java.lang.Object ref = nodeProviderId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        nodeProviderId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Node providerID as reported by the first node in the list of nodes on
     * the Kubernetes endpoint. On Kubernetes platforms that support zero-node
     * clusters (like GKE-on-GCP), the node_count will be zero and the
     * node_provider_id will be empty.
     * </pre>
     *
     * <code>string node_provider_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The nodeProviderId to set.
     * @return This builder for chaining.
     */
    public Builder setNodeProviderId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      nodeProviderId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Node providerID as reported by the first node in the list of nodes on
     * the Kubernetes endpoint. On Kubernetes platforms that support zero-node
     * clusters (like GKE-on-GCP), the node_count will be zero and the
     * node_provider_id will be empty.
     * </pre>
     *
     * <code>string node_provider_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNodeProviderId() {
      nodeProviderId_ = getDefaultInstance().getNodeProviderId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Node providerID as reported by the first node in the list of nodes on
     * the Kubernetes endpoint. On Kubernetes platforms that support zero-node
     * clusters (like GKE-on-GCP), the node_count will be zero and the
     * node_provider_id will be empty.
     * </pre>
     *
     * <code>string node_provider_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for nodeProviderId to set.
     * @return This builder for chaining.
     */
    public Builder setNodeProviderIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      nodeProviderId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private int nodeCount_;
    /**
     *
     *
     * <pre>
     * Output only. Node count as reported by Kubernetes nodes resources.
     * </pre>
     *
     * <code>int32 node_count = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The nodeCount.
     */
    @java.lang.Override
    public int getNodeCount() {
      return nodeCount_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Node count as reported by Kubernetes nodes resources.
     * </pre>
     *
     * <code>int32 node_count = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The nodeCount to set.
     * @return This builder for chaining.
     */
    public Builder setNodeCount(int value) {

      nodeCount_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Node count as reported by Kubernetes nodes resources.
     * </pre>
     *
     * <code>int32 node_count = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNodeCount() {
      bitField0_ = (bitField0_ & ~0x00000004);
      nodeCount_ = 0;
      onChanged();
      return this;
    }

    private int vcpuCount_;
    /**
     *
     *
     * <pre>
     * Output only. vCPU count as reported by Kubernetes nodes resources.
     * </pre>
     *
     * <code>int32 vcpu_count = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The vcpuCount.
     */
    @java.lang.Override
    public int getVcpuCount() {
      return vcpuCount_;
    }
    /**
     *
     *
     * <pre>
     * Output only. vCPU count as reported by Kubernetes nodes resources.
     * </pre>
     *
     * <code>int32 vcpu_count = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The vcpuCount to set.
     * @return This builder for chaining.
     */
    public Builder setVcpuCount(int value) {

      vcpuCount_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. vCPU count as reported by Kubernetes nodes resources.
     * </pre>
     *
     * <code>int32 vcpu_count = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVcpuCount() {
      bitField0_ = (bitField0_ & ~0x00000008);
      vcpuCount_ = 0;
      onChanged();
      return this;
    }

    private int memoryMb_;
    /**
     *
     *
     * <pre>
     * Output only. The total memory capacity as reported by the sum of all Kubernetes nodes
     * resources, defined in MB.
     * </pre>
     *
     * <code>int32 memory_mb = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The memoryMb.
     */
    @java.lang.Override
    public int getMemoryMb() {
      return memoryMb_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The total memory capacity as reported by the sum of all Kubernetes nodes
     * resources, defined in MB.
     * </pre>
     *
     * <code>int32 memory_mb = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The memoryMb to set.
     * @return This builder for chaining.
     */
    public Builder setMemoryMb(int value) {

      memoryMb_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The total memory capacity as reported by the sum of all Kubernetes nodes
     * resources, defined in MB.
     * </pre>
     *
     * <code>int32 memory_mb = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMemoryMb() {
      bitField0_ = (bitField0_ & ~0x00000010);
      memoryMb_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time at which these details were last updated. This update_time is
     * different from the Membership-level update_time since EndpointDetails are
     * updated internally for API consumers.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 100 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which these details were last updated. This update_time is
     * different from the Membership-level update_time since EndpointDetails are
     * updated internally for API consumers.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 100 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which these details were last updated. This update_time is
     * different from the Membership-level update_time since EndpointDetails are
     * updated internally for API consumers.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 100 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which these details were last updated. This update_time is
     * different from the Membership-level update_time since EndpointDetails are
     * updated internally for API consumers.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 100 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which these details were last updated. This update_time is
     * different from the Membership-level update_time since EndpointDetails are
     * updated internally for API consumers.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 100 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which these details were last updated. This update_time is
     * different from the Membership-level update_time since EndpointDetails are
     * updated internally for API consumers.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 100 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000020);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which these details were last updated. This update_time is
     * different from the Membership-level update_time since EndpointDetails are
     * updated internally for API consumers.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 100 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which these details were last updated. This update_time is
     * different from the Membership-level update_time since EndpointDetails are
     * updated internally for API consumers.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 100 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which these details were last updated. This update_time is
     * different from the Membership-level update_time since EndpointDetails are
     * updated internally for API consumers.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 100 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.gkehub.v1alpha2.KubernetesMetadata)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.gkehub.v1alpha2.KubernetesMetadata)
  private static final com.google.cloud.gkehub.v1alpha2.KubernetesMetadata DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.gkehub.v1alpha2.KubernetesMetadata();
  }

  public static com.google.cloud.gkehub.v1alpha2.KubernetesMetadata getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<KubernetesMetadata> PARSER =
      new com.google.protobuf.AbstractParser<KubernetesMetadata>() {
        @java.lang.Override
        public KubernetesMetadata parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<KubernetesMetadata> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<KubernetesMetadata> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.gkehub.v1alpha2.KubernetesMetadata getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
