/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/gkehub/v1alpha2/membership.proto

package com.google.cloud.gkehub.v1alpha2;

/**
 *
 *
 * <pre>
 * MembershipEndpoint contains information needed to contact a Kubernetes API,
 * endpoint and any additional Kubernetes metadata.
 * </pre>
 *
 * Protobuf type {@code google.cloud.gkehub.v1alpha2.MembershipEndpoint}
 */
public final class MembershipEndpoint extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.gkehub.v1alpha2.MembershipEndpoint)
    MembershipEndpointOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use MembershipEndpoint.newBuilder() to construct.
  private MembershipEndpoint(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private MembershipEndpoint() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new MembershipEndpoint();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.gkehub.v1alpha2.MembershipProto
        .internal_static_google_cloud_gkehub_v1alpha2_MembershipEndpoint_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.gkehub.v1alpha2.MembershipProto
        .internal_static_google_cloud_gkehub_v1alpha2_MembershipEndpoint_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.gkehub.v1alpha2.MembershipEndpoint.class,
            com.google.cloud.gkehub.v1alpha2.MembershipEndpoint.Builder.class);
  }

  private int typeCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object type_;

  public enum TypeCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    GKE_CLUSTER(1),
    ON_PREM_CLUSTER(4),
    MULTI_CLOUD_CLUSTER(5),
    TYPE_NOT_SET(0);
    private final int value;

    private TypeCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TypeCase valueOf(int value) {
      return forNumber(value);
    }

    public static TypeCase forNumber(int value) {
      switch (value) {
        case 1:
          return GKE_CLUSTER;
        case 4:
          return ON_PREM_CLUSTER;
        case 5:
          return MULTI_CLOUD_CLUSTER;
        case 0:
          return TYPE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public TypeCase getTypeCase() {
    return TypeCase.forNumber(typeCase_);
  }

  public static final int GKE_CLUSTER_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * Optional. Specific information for a GKE-on-GCP cluster.
   * </pre>
   *
   * <code>
   * .google.cloud.gkehub.v1alpha2.GkeCluster gke_cluster = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the gkeCluster field is set.
   */
  @java.lang.Override
  public boolean hasGkeCluster() {
    return typeCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * Optional. Specific information for a GKE-on-GCP cluster.
   * </pre>
   *
   * <code>
   * .google.cloud.gkehub.v1alpha2.GkeCluster gke_cluster = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The gkeCluster.
   */
  @java.lang.Override
  public com.google.cloud.gkehub.v1alpha2.GkeCluster getGkeCluster() {
    if (typeCase_ == 1) {
      return (com.google.cloud.gkehub.v1alpha2.GkeCluster) type_;
    }
    return com.google.cloud.gkehub.v1alpha2.GkeCluster.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. Specific information for a GKE-on-GCP cluster.
   * </pre>
   *
   * <code>
   * .google.cloud.gkehub.v1alpha2.GkeCluster gke_cluster = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.gkehub.v1alpha2.GkeClusterOrBuilder getGkeClusterOrBuilder() {
    if (typeCase_ == 1) {
      return (com.google.cloud.gkehub.v1alpha2.GkeCluster) type_;
    }
    return com.google.cloud.gkehub.v1alpha2.GkeCluster.getDefaultInstance();
  }

  public static final int ON_PREM_CLUSTER_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Optional. Specific information for a GKE On-Prem cluster.
   * </pre>
   *
   * <code>
   * .google.cloud.gkehub.v1alpha2.OnPremCluster on_prem_cluster = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the onPremCluster field is set.
   */
  @java.lang.Override
  public boolean hasOnPremCluster() {
    return typeCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Optional. Specific information for a GKE On-Prem cluster.
   * </pre>
   *
   * <code>
   * .google.cloud.gkehub.v1alpha2.OnPremCluster on_prem_cluster = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The onPremCluster.
   */
  @java.lang.Override
  public com.google.cloud.gkehub.v1alpha2.OnPremCluster getOnPremCluster() {
    if (typeCase_ == 4) {
      return (com.google.cloud.gkehub.v1alpha2.OnPremCluster) type_;
    }
    return com.google.cloud.gkehub.v1alpha2.OnPremCluster.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. Specific information for a GKE On-Prem cluster.
   * </pre>
   *
   * <code>
   * .google.cloud.gkehub.v1alpha2.OnPremCluster on_prem_cluster = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.gkehub.v1alpha2.OnPremClusterOrBuilder getOnPremClusterOrBuilder() {
    if (typeCase_ == 4) {
      return (com.google.cloud.gkehub.v1alpha2.OnPremCluster) type_;
    }
    return com.google.cloud.gkehub.v1alpha2.OnPremCluster.getDefaultInstance();
  }

  public static final int MULTI_CLOUD_CLUSTER_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * Optional. Specific information for a GKE Multi-Cloud cluster.
   * </pre>
   *
   * <code>
   * .google.cloud.gkehub.v1alpha2.MultiCloudCluster multi_cloud_cluster = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the multiCloudCluster field is set.
   */
  @java.lang.Override
  public boolean hasMultiCloudCluster() {
    return typeCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * Optional. Specific information for a GKE Multi-Cloud cluster.
   * </pre>
   *
   * <code>
   * .google.cloud.gkehub.v1alpha2.MultiCloudCluster multi_cloud_cluster = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The multiCloudCluster.
   */
  @java.lang.Override
  public com.google.cloud.gkehub.v1alpha2.MultiCloudCluster getMultiCloudCluster() {
    if (typeCase_ == 5) {
      return (com.google.cloud.gkehub.v1alpha2.MultiCloudCluster) type_;
    }
    return com.google.cloud.gkehub.v1alpha2.MultiCloudCluster.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. Specific information for a GKE Multi-Cloud cluster.
   * </pre>
   *
   * <code>
   * .google.cloud.gkehub.v1alpha2.MultiCloudCluster multi_cloud_cluster = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.gkehub.v1alpha2.MultiCloudClusterOrBuilder
      getMultiCloudClusterOrBuilder() {
    if (typeCase_ == 5) {
      return (com.google.cloud.gkehub.v1alpha2.MultiCloudCluster) type_;
    }
    return com.google.cloud.gkehub.v1alpha2.MultiCloudCluster.getDefaultInstance();
  }

  public static final int KUBERNETES_METADATA_FIELD_NUMBER = 2;
  private com.google.cloud.gkehub.v1alpha2.KubernetesMetadata kubernetesMetadata_;
  /**
   *
   *
   * <pre>
   * Output only. Useful Kubernetes-specific metadata.
   * </pre>
   *
   * <code>
   * .google.cloud.gkehub.v1alpha2.KubernetesMetadata kubernetes_metadata = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the kubernetesMetadata field is set.
   */
  @java.lang.Override
  public boolean hasKubernetesMetadata() {
    return kubernetesMetadata_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Useful Kubernetes-specific metadata.
   * </pre>
   *
   * <code>
   * .google.cloud.gkehub.v1alpha2.KubernetesMetadata kubernetes_metadata = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The kubernetesMetadata.
   */
  @java.lang.Override
  public com.google.cloud.gkehub.v1alpha2.KubernetesMetadata getKubernetesMetadata() {
    return kubernetesMetadata_ == null
        ? com.google.cloud.gkehub.v1alpha2.KubernetesMetadata.getDefaultInstance()
        : kubernetesMetadata_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Useful Kubernetes-specific metadata.
   * </pre>
   *
   * <code>
   * .google.cloud.gkehub.v1alpha2.KubernetesMetadata kubernetes_metadata = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.gkehub.v1alpha2.KubernetesMetadataOrBuilder
      getKubernetesMetadataOrBuilder() {
    return kubernetesMetadata_ == null
        ? com.google.cloud.gkehub.v1alpha2.KubernetesMetadata.getDefaultInstance()
        : kubernetesMetadata_;
  }

  public static final int KUBERNETES_RESOURCE_FIELD_NUMBER = 3;
  private com.google.cloud.gkehub.v1alpha2.KubernetesResource kubernetesResource_;
  /**
   *
   *
   * <pre>
   * Optional. The in-cluster Kubernetes Resources that should be applied for a correctly
   * registered cluster, in the steady state. These resources:
   *
   *   * Ensure that the cluster is exclusively registered to one and only one
   *     Hub Membership.
   *   * Propagate Workload Pool Information available in the Membership
   *     Authority field.
   *   * Ensure proper initial configuration of default Hub Features.
   * </pre>
   *
   * <code>
   * .google.cloud.gkehub.v1alpha2.KubernetesResource kubernetes_resource = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the kubernetesResource field is set.
   */
  @java.lang.Override
  public boolean hasKubernetesResource() {
    return kubernetesResource_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. The in-cluster Kubernetes Resources that should be applied for a correctly
   * registered cluster, in the steady state. These resources:
   *
   *   * Ensure that the cluster is exclusively registered to one and only one
   *     Hub Membership.
   *   * Propagate Workload Pool Information available in the Membership
   *     Authority field.
   *   * Ensure proper initial configuration of default Hub Features.
   * </pre>
   *
   * <code>
   * .google.cloud.gkehub.v1alpha2.KubernetesResource kubernetes_resource = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The kubernetesResource.
   */
  @java.lang.Override
  public com.google.cloud.gkehub.v1alpha2.KubernetesResource getKubernetesResource() {
    return kubernetesResource_ == null
        ? com.google.cloud.gkehub.v1alpha2.KubernetesResource.getDefaultInstance()
        : kubernetesResource_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The in-cluster Kubernetes Resources that should be applied for a correctly
   * registered cluster, in the steady state. These resources:
   *
   *   * Ensure that the cluster is exclusively registered to one and only one
   *     Hub Membership.
   *   * Propagate Workload Pool Information available in the Membership
   *     Authority field.
   *   * Ensure proper initial configuration of default Hub Features.
   * </pre>
   *
   * <code>
   * .google.cloud.gkehub.v1alpha2.KubernetesResource kubernetes_resource = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.gkehub.v1alpha2.KubernetesResourceOrBuilder
      getKubernetesResourceOrBuilder() {
    return kubernetesResource_ == null
        ? com.google.cloud.gkehub.v1alpha2.KubernetesResource.getDefaultInstance()
        : kubernetesResource_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (typeCase_ == 1) {
      output.writeMessage(1, (com.google.cloud.gkehub.v1alpha2.GkeCluster) type_);
    }
    if (kubernetesMetadata_ != null) {
      output.writeMessage(2, getKubernetesMetadata());
    }
    if (kubernetesResource_ != null) {
      output.writeMessage(3, getKubernetesResource());
    }
    if (typeCase_ == 4) {
      output.writeMessage(4, (com.google.cloud.gkehub.v1alpha2.OnPremCluster) type_);
    }
    if (typeCase_ == 5) {
      output.writeMessage(5, (com.google.cloud.gkehub.v1alpha2.MultiCloudCluster) type_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (typeCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.cloud.gkehub.v1alpha2.GkeCluster) type_);
    }
    if (kubernetesMetadata_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getKubernetesMetadata());
    }
    if (kubernetesResource_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getKubernetesResource());
    }
    if (typeCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.cloud.gkehub.v1alpha2.OnPremCluster) type_);
    }
    if (typeCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.cloud.gkehub.v1alpha2.MultiCloudCluster) type_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.gkehub.v1alpha2.MembershipEndpoint)) {
      return super.equals(obj);
    }
    com.google.cloud.gkehub.v1alpha2.MembershipEndpoint other =
        (com.google.cloud.gkehub.v1alpha2.MembershipEndpoint) obj;

    if (hasKubernetesMetadata() != other.hasKubernetesMetadata()) return false;
    if (hasKubernetesMetadata()) {
      if (!getKubernetesMetadata().equals(other.getKubernetesMetadata())) return false;
    }
    if (hasKubernetesResource() != other.hasKubernetesResource()) return false;
    if (hasKubernetesResource()) {
      if (!getKubernetesResource().equals(other.getKubernetesResource())) return false;
    }
    if (!getTypeCase().equals(other.getTypeCase())) return false;
    switch (typeCase_) {
      case 1:
        if (!getGkeCluster().equals(other.getGkeCluster())) return false;
        break;
      case 4:
        if (!getOnPremCluster().equals(other.getOnPremCluster())) return false;
        break;
      case 5:
        if (!getMultiCloudCluster().equals(other.getMultiCloudCluster())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasKubernetesMetadata()) {
      hash = (37 * hash) + KUBERNETES_METADATA_FIELD_NUMBER;
      hash = (53 * hash) + getKubernetesMetadata().hashCode();
    }
    if (hasKubernetesResource()) {
      hash = (37 * hash) + KUBERNETES_RESOURCE_FIELD_NUMBER;
      hash = (53 * hash) + getKubernetesResource().hashCode();
    }
    switch (typeCase_) {
      case 1:
        hash = (37 * hash) + GKE_CLUSTER_FIELD_NUMBER;
        hash = (53 * hash) + getGkeCluster().hashCode();
        break;
      case 4:
        hash = (37 * hash) + ON_PREM_CLUSTER_FIELD_NUMBER;
        hash = (53 * hash) + getOnPremCluster().hashCode();
        break;
      case 5:
        hash = (37 * hash) + MULTI_CLOUD_CLUSTER_FIELD_NUMBER;
        hash = (53 * hash) + getMultiCloudCluster().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.gkehub.v1alpha2.MembershipEndpoint parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gkehub.v1alpha2.MembershipEndpoint parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gkehub.v1alpha2.MembershipEndpoint parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gkehub.v1alpha2.MembershipEndpoint parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gkehub.v1alpha2.MembershipEndpoint parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gkehub.v1alpha2.MembershipEndpoint parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gkehub.v1alpha2.MembershipEndpoint parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.gkehub.v1alpha2.MembershipEndpoint parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.gkehub.v1alpha2.MembershipEndpoint parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.gkehub.v1alpha2.MembershipEndpoint parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.gkehub.v1alpha2.MembershipEndpoint parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.gkehub.v1alpha2.MembershipEndpoint parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.gkehub.v1alpha2.MembershipEndpoint prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * MembershipEndpoint contains information needed to contact a Kubernetes API,
   * endpoint and any additional Kubernetes metadata.
   * </pre>
   *
   * Protobuf type {@code google.cloud.gkehub.v1alpha2.MembershipEndpoint}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.gkehub.v1alpha2.MembershipEndpoint)
      com.google.cloud.gkehub.v1alpha2.MembershipEndpointOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.gkehub.v1alpha2.MembershipProto
          .internal_static_google_cloud_gkehub_v1alpha2_MembershipEndpoint_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.gkehub.v1alpha2.MembershipProto
          .internal_static_google_cloud_gkehub_v1alpha2_MembershipEndpoint_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.gkehub.v1alpha2.MembershipEndpoint.class,
              com.google.cloud.gkehub.v1alpha2.MembershipEndpoint.Builder.class);
    }

    // Construct using com.google.cloud.gkehub.v1alpha2.MembershipEndpoint.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (gkeClusterBuilder_ != null) {
        gkeClusterBuilder_.clear();
      }
      if (onPremClusterBuilder_ != null) {
        onPremClusterBuilder_.clear();
      }
      if (multiCloudClusterBuilder_ != null) {
        multiCloudClusterBuilder_.clear();
      }
      kubernetesMetadata_ = null;
      if (kubernetesMetadataBuilder_ != null) {
        kubernetesMetadataBuilder_.dispose();
        kubernetesMetadataBuilder_ = null;
      }
      kubernetesResource_ = null;
      if (kubernetesResourceBuilder_ != null) {
        kubernetesResourceBuilder_.dispose();
        kubernetesResourceBuilder_ = null;
      }
      typeCase_ = 0;
      type_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.gkehub.v1alpha2.MembershipProto
          .internal_static_google_cloud_gkehub_v1alpha2_MembershipEndpoint_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.gkehub.v1alpha2.MembershipEndpoint getDefaultInstanceForType() {
      return com.google.cloud.gkehub.v1alpha2.MembershipEndpoint.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.gkehub.v1alpha2.MembershipEndpoint build() {
      com.google.cloud.gkehub.v1alpha2.MembershipEndpoint result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.gkehub.v1alpha2.MembershipEndpoint buildPartial() {
      com.google.cloud.gkehub.v1alpha2.MembershipEndpoint result =
          new com.google.cloud.gkehub.v1alpha2.MembershipEndpoint(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.gkehub.v1alpha2.MembershipEndpoint result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.kubernetesMetadata_ =
            kubernetesMetadataBuilder_ == null
                ? kubernetesMetadata_
                : kubernetesMetadataBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.kubernetesResource_ =
            kubernetesResourceBuilder_ == null
                ? kubernetesResource_
                : kubernetesResourceBuilder_.build();
      }
    }

    private void buildPartialOneofs(com.google.cloud.gkehub.v1alpha2.MembershipEndpoint result) {
      result.typeCase_ = typeCase_;
      result.type_ = this.type_;
      if (typeCase_ == 1 && gkeClusterBuilder_ != null) {
        result.type_ = gkeClusterBuilder_.build();
      }
      if (typeCase_ == 4 && onPremClusterBuilder_ != null) {
        result.type_ = onPremClusterBuilder_.build();
      }
      if (typeCase_ == 5 && multiCloudClusterBuilder_ != null) {
        result.type_ = multiCloudClusterBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.gkehub.v1alpha2.MembershipEndpoint) {
        return mergeFrom((com.google.cloud.gkehub.v1alpha2.MembershipEndpoint) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.gkehub.v1alpha2.MembershipEndpoint other) {
      if (other == com.google.cloud.gkehub.v1alpha2.MembershipEndpoint.getDefaultInstance())
        return this;
      if (other.hasKubernetesMetadata()) {
        mergeKubernetesMetadata(other.getKubernetesMetadata());
      }
      if (other.hasKubernetesResource()) {
        mergeKubernetesResource(other.getKubernetesResource());
      }
      switch (other.getTypeCase()) {
        case GKE_CLUSTER:
          {
            mergeGkeCluster(other.getGkeCluster());
            break;
          }
        case ON_PREM_CLUSTER:
          {
            mergeOnPremCluster(other.getOnPremCluster());
            break;
          }
        case MULTI_CLOUD_CLUSTER:
          {
            mergeMultiCloudCluster(other.getMultiCloudCluster());
            break;
          }
        case TYPE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getGkeClusterFieldBuilder().getBuilder(), extensionRegistry);
                typeCase_ = 1;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(
                    getKubernetesMetadataFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getKubernetesResourceFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getOnPremClusterFieldBuilder().getBuilder(), extensionRegistry);
                typeCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(
                    getMultiCloudClusterFieldBuilder().getBuilder(), extensionRegistry);
                typeCase_ = 5;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int typeCase_ = 0;
    private java.lang.Object type_;

    public TypeCase getTypeCase() {
      return TypeCase.forNumber(typeCase_);
    }

    public Builder clearType() {
      typeCase_ = 0;
      type_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gkehub.v1alpha2.GkeCluster,
            com.google.cloud.gkehub.v1alpha2.GkeCluster.Builder,
            com.google.cloud.gkehub.v1alpha2.GkeClusterOrBuilder>
        gkeClusterBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Specific information for a GKE-on-GCP cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1alpha2.GkeCluster gke_cluster = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the gkeCluster field is set.
     */
    @java.lang.Override
    public boolean hasGkeCluster() {
      return typeCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specific information for a GKE-on-GCP cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1alpha2.GkeCluster gke_cluster = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The gkeCluster.
     */
    @java.lang.Override
    public com.google.cloud.gkehub.v1alpha2.GkeCluster getGkeCluster() {
      if (gkeClusterBuilder_ == null) {
        if (typeCase_ == 1) {
          return (com.google.cloud.gkehub.v1alpha2.GkeCluster) type_;
        }
        return com.google.cloud.gkehub.v1alpha2.GkeCluster.getDefaultInstance();
      } else {
        if (typeCase_ == 1) {
          return gkeClusterBuilder_.getMessage();
        }
        return com.google.cloud.gkehub.v1alpha2.GkeCluster.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Specific information for a GKE-on-GCP cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1alpha2.GkeCluster gke_cluster = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setGkeCluster(com.google.cloud.gkehub.v1alpha2.GkeCluster value) {
      if (gkeClusterBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        type_ = value;
        onChanged();
      } else {
        gkeClusterBuilder_.setMessage(value);
      }
      typeCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specific information for a GKE-on-GCP cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1alpha2.GkeCluster gke_cluster = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setGkeCluster(
        com.google.cloud.gkehub.v1alpha2.GkeCluster.Builder builderForValue) {
      if (gkeClusterBuilder_ == null) {
        type_ = builderForValue.build();
        onChanged();
      } else {
        gkeClusterBuilder_.setMessage(builderForValue.build());
      }
      typeCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specific information for a GKE-on-GCP cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1alpha2.GkeCluster gke_cluster = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeGkeCluster(com.google.cloud.gkehub.v1alpha2.GkeCluster value) {
      if (gkeClusterBuilder_ == null) {
        if (typeCase_ == 1
            && type_ != com.google.cloud.gkehub.v1alpha2.GkeCluster.getDefaultInstance()) {
          type_ =
              com.google.cloud.gkehub.v1alpha2.GkeCluster.newBuilder(
                      (com.google.cloud.gkehub.v1alpha2.GkeCluster) type_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          type_ = value;
        }
        onChanged();
      } else {
        if (typeCase_ == 1) {
          gkeClusterBuilder_.mergeFrom(value);
        } else {
          gkeClusterBuilder_.setMessage(value);
        }
      }
      typeCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specific information for a GKE-on-GCP cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1alpha2.GkeCluster gke_cluster = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearGkeCluster() {
      if (gkeClusterBuilder_ == null) {
        if (typeCase_ == 1) {
          typeCase_ = 0;
          type_ = null;
          onChanged();
        }
      } else {
        if (typeCase_ == 1) {
          typeCase_ = 0;
          type_ = null;
        }
        gkeClusterBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specific information for a GKE-on-GCP cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1alpha2.GkeCluster gke_cluster = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.gkehub.v1alpha2.GkeCluster.Builder getGkeClusterBuilder() {
      return getGkeClusterFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Specific information for a GKE-on-GCP cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1alpha2.GkeCluster gke_cluster = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.gkehub.v1alpha2.GkeClusterOrBuilder getGkeClusterOrBuilder() {
      if ((typeCase_ == 1) && (gkeClusterBuilder_ != null)) {
        return gkeClusterBuilder_.getMessageOrBuilder();
      } else {
        if (typeCase_ == 1) {
          return (com.google.cloud.gkehub.v1alpha2.GkeCluster) type_;
        }
        return com.google.cloud.gkehub.v1alpha2.GkeCluster.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Specific information for a GKE-on-GCP cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1alpha2.GkeCluster gke_cluster = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gkehub.v1alpha2.GkeCluster,
            com.google.cloud.gkehub.v1alpha2.GkeCluster.Builder,
            com.google.cloud.gkehub.v1alpha2.GkeClusterOrBuilder>
        getGkeClusterFieldBuilder() {
      if (gkeClusterBuilder_ == null) {
        if (!(typeCase_ == 1)) {
          type_ = com.google.cloud.gkehub.v1alpha2.GkeCluster.getDefaultInstance();
        }
        gkeClusterBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.gkehub.v1alpha2.GkeCluster,
                com.google.cloud.gkehub.v1alpha2.GkeCluster.Builder,
                com.google.cloud.gkehub.v1alpha2.GkeClusterOrBuilder>(
                (com.google.cloud.gkehub.v1alpha2.GkeCluster) type_,
                getParentForChildren(),
                isClean());
        type_ = null;
      }
      typeCase_ = 1;
      onChanged();
      return gkeClusterBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gkehub.v1alpha2.OnPremCluster,
            com.google.cloud.gkehub.v1alpha2.OnPremCluster.Builder,
            com.google.cloud.gkehub.v1alpha2.OnPremClusterOrBuilder>
        onPremClusterBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Specific information for a GKE On-Prem cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1alpha2.OnPremCluster on_prem_cluster = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the onPremCluster field is set.
     */
    @java.lang.Override
    public boolean hasOnPremCluster() {
      return typeCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specific information for a GKE On-Prem cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1alpha2.OnPremCluster on_prem_cluster = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The onPremCluster.
     */
    @java.lang.Override
    public com.google.cloud.gkehub.v1alpha2.OnPremCluster getOnPremCluster() {
      if (onPremClusterBuilder_ == null) {
        if (typeCase_ == 4) {
          return (com.google.cloud.gkehub.v1alpha2.OnPremCluster) type_;
        }
        return com.google.cloud.gkehub.v1alpha2.OnPremCluster.getDefaultInstance();
      } else {
        if (typeCase_ == 4) {
          return onPremClusterBuilder_.getMessage();
        }
        return com.google.cloud.gkehub.v1alpha2.OnPremCluster.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Specific information for a GKE On-Prem cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1alpha2.OnPremCluster on_prem_cluster = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setOnPremCluster(com.google.cloud.gkehub.v1alpha2.OnPremCluster value) {
      if (onPremClusterBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        type_ = value;
        onChanged();
      } else {
        onPremClusterBuilder_.setMessage(value);
      }
      typeCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specific information for a GKE On-Prem cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1alpha2.OnPremCluster on_prem_cluster = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setOnPremCluster(
        com.google.cloud.gkehub.v1alpha2.OnPremCluster.Builder builderForValue) {
      if (onPremClusterBuilder_ == null) {
        type_ = builderForValue.build();
        onChanged();
      } else {
        onPremClusterBuilder_.setMessage(builderForValue.build());
      }
      typeCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specific information for a GKE On-Prem cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1alpha2.OnPremCluster on_prem_cluster = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeOnPremCluster(com.google.cloud.gkehub.v1alpha2.OnPremCluster value) {
      if (onPremClusterBuilder_ == null) {
        if (typeCase_ == 4
            && type_ != com.google.cloud.gkehub.v1alpha2.OnPremCluster.getDefaultInstance()) {
          type_ =
              com.google.cloud.gkehub.v1alpha2.OnPremCluster.newBuilder(
                      (com.google.cloud.gkehub.v1alpha2.OnPremCluster) type_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          type_ = value;
        }
        onChanged();
      } else {
        if (typeCase_ == 4) {
          onPremClusterBuilder_.mergeFrom(value);
        } else {
          onPremClusterBuilder_.setMessage(value);
        }
      }
      typeCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specific information for a GKE On-Prem cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1alpha2.OnPremCluster on_prem_cluster = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearOnPremCluster() {
      if (onPremClusterBuilder_ == null) {
        if (typeCase_ == 4) {
          typeCase_ = 0;
          type_ = null;
          onChanged();
        }
      } else {
        if (typeCase_ == 4) {
          typeCase_ = 0;
          type_ = null;
        }
        onPremClusterBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specific information for a GKE On-Prem cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1alpha2.OnPremCluster on_prem_cluster = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.gkehub.v1alpha2.OnPremCluster.Builder getOnPremClusterBuilder() {
      return getOnPremClusterFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Specific information for a GKE On-Prem cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1alpha2.OnPremCluster on_prem_cluster = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.gkehub.v1alpha2.OnPremClusterOrBuilder getOnPremClusterOrBuilder() {
      if ((typeCase_ == 4) && (onPremClusterBuilder_ != null)) {
        return onPremClusterBuilder_.getMessageOrBuilder();
      } else {
        if (typeCase_ == 4) {
          return (com.google.cloud.gkehub.v1alpha2.OnPremCluster) type_;
        }
        return com.google.cloud.gkehub.v1alpha2.OnPremCluster.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Specific information for a GKE On-Prem cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1alpha2.OnPremCluster on_prem_cluster = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gkehub.v1alpha2.OnPremCluster,
            com.google.cloud.gkehub.v1alpha2.OnPremCluster.Builder,
            com.google.cloud.gkehub.v1alpha2.OnPremClusterOrBuilder>
        getOnPremClusterFieldBuilder() {
      if (onPremClusterBuilder_ == null) {
        if (!(typeCase_ == 4)) {
          type_ = com.google.cloud.gkehub.v1alpha2.OnPremCluster.getDefaultInstance();
        }
        onPremClusterBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.gkehub.v1alpha2.OnPremCluster,
                com.google.cloud.gkehub.v1alpha2.OnPremCluster.Builder,
                com.google.cloud.gkehub.v1alpha2.OnPremClusterOrBuilder>(
                (com.google.cloud.gkehub.v1alpha2.OnPremCluster) type_,
                getParentForChildren(),
                isClean());
        type_ = null;
      }
      typeCase_ = 4;
      onChanged();
      return onPremClusterBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gkehub.v1alpha2.MultiCloudCluster,
            com.google.cloud.gkehub.v1alpha2.MultiCloudCluster.Builder,
            com.google.cloud.gkehub.v1alpha2.MultiCloudClusterOrBuilder>
        multiCloudClusterBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Specific information for a GKE Multi-Cloud cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1alpha2.MultiCloudCluster multi_cloud_cluster = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the multiCloudCluster field is set.
     */
    @java.lang.Override
    public boolean hasMultiCloudCluster() {
      return typeCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specific information for a GKE Multi-Cloud cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1alpha2.MultiCloudCluster multi_cloud_cluster = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The multiCloudCluster.
     */
    @java.lang.Override
    public com.google.cloud.gkehub.v1alpha2.MultiCloudCluster getMultiCloudCluster() {
      if (multiCloudClusterBuilder_ == null) {
        if (typeCase_ == 5) {
          return (com.google.cloud.gkehub.v1alpha2.MultiCloudCluster) type_;
        }
        return com.google.cloud.gkehub.v1alpha2.MultiCloudCluster.getDefaultInstance();
      } else {
        if (typeCase_ == 5) {
          return multiCloudClusterBuilder_.getMessage();
        }
        return com.google.cloud.gkehub.v1alpha2.MultiCloudCluster.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Specific information for a GKE Multi-Cloud cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1alpha2.MultiCloudCluster multi_cloud_cluster = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setMultiCloudCluster(com.google.cloud.gkehub.v1alpha2.MultiCloudCluster value) {
      if (multiCloudClusterBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        type_ = value;
        onChanged();
      } else {
        multiCloudClusterBuilder_.setMessage(value);
      }
      typeCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specific information for a GKE Multi-Cloud cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1alpha2.MultiCloudCluster multi_cloud_cluster = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setMultiCloudCluster(
        com.google.cloud.gkehub.v1alpha2.MultiCloudCluster.Builder builderForValue) {
      if (multiCloudClusterBuilder_ == null) {
        type_ = builderForValue.build();
        onChanged();
      } else {
        multiCloudClusterBuilder_.setMessage(builderForValue.build());
      }
      typeCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specific information for a GKE Multi-Cloud cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1alpha2.MultiCloudCluster multi_cloud_cluster = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeMultiCloudCluster(
        com.google.cloud.gkehub.v1alpha2.MultiCloudCluster value) {
      if (multiCloudClusterBuilder_ == null) {
        if (typeCase_ == 5
            && type_ != com.google.cloud.gkehub.v1alpha2.MultiCloudCluster.getDefaultInstance()) {
          type_ =
              com.google.cloud.gkehub.v1alpha2.MultiCloudCluster.newBuilder(
                      (com.google.cloud.gkehub.v1alpha2.MultiCloudCluster) type_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          type_ = value;
        }
        onChanged();
      } else {
        if (typeCase_ == 5) {
          multiCloudClusterBuilder_.mergeFrom(value);
        } else {
          multiCloudClusterBuilder_.setMessage(value);
        }
      }
      typeCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specific information for a GKE Multi-Cloud cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1alpha2.MultiCloudCluster multi_cloud_cluster = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearMultiCloudCluster() {
      if (multiCloudClusterBuilder_ == null) {
        if (typeCase_ == 5) {
          typeCase_ = 0;
          type_ = null;
          onChanged();
        }
      } else {
        if (typeCase_ == 5) {
          typeCase_ = 0;
          type_ = null;
        }
        multiCloudClusterBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specific information for a GKE Multi-Cloud cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1alpha2.MultiCloudCluster multi_cloud_cluster = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.gkehub.v1alpha2.MultiCloudCluster.Builder
        getMultiCloudClusterBuilder() {
      return getMultiCloudClusterFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Specific information for a GKE Multi-Cloud cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1alpha2.MultiCloudCluster multi_cloud_cluster = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.gkehub.v1alpha2.MultiCloudClusterOrBuilder
        getMultiCloudClusterOrBuilder() {
      if ((typeCase_ == 5) && (multiCloudClusterBuilder_ != null)) {
        return multiCloudClusterBuilder_.getMessageOrBuilder();
      } else {
        if (typeCase_ == 5) {
          return (com.google.cloud.gkehub.v1alpha2.MultiCloudCluster) type_;
        }
        return com.google.cloud.gkehub.v1alpha2.MultiCloudCluster.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Specific information for a GKE Multi-Cloud cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1alpha2.MultiCloudCluster multi_cloud_cluster = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gkehub.v1alpha2.MultiCloudCluster,
            com.google.cloud.gkehub.v1alpha2.MultiCloudCluster.Builder,
            com.google.cloud.gkehub.v1alpha2.MultiCloudClusterOrBuilder>
        getMultiCloudClusterFieldBuilder() {
      if (multiCloudClusterBuilder_ == null) {
        if (!(typeCase_ == 5)) {
          type_ = com.google.cloud.gkehub.v1alpha2.MultiCloudCluster.getDefaultInstance();
        }
        multiCloudClusterBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.gkehub.v1alpha2.MultiCloudCluster,
                com.google.cloud.gkehub.v1alpha2.MultiCloudCluster.Builder,
                com.google.cloud.gkehub.v1alpha2.MultiCloudClusterOrBuilder>(
                (com.google.cloud.gkehub.v1alpha2.MultiCloudCluster) type_,
                getParentForChildren(),
                isClean());
        type_ = null;
      }
      typeCase_ = 5;
      onChanged();
      return multiCloudClusterBuilder_;
    }

    private com.google.cloud.gkehub.v1alpha2.KubernetesMetadata kubernetesMetadata_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gkehub.v1alpha2.KubernetesMetadata,
            com.google.cloud.gkehub.v1alpha2.KubernetesMetadata.Builder,
            com.google.cloud.gkehub.v1alpha2.KubernetesMetadataOrBuilder>
        kubernetesMetadataBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Useful Kubernetes-specific metadata.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1alpha2.KubernetesMetadata kubernetes_metadata = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the kubernetesMetadata field is set.
     */
    public boolean hasKubernetesMetadata() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Useful Kubernetes-specific metadata.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1alpha2.KubernetesMetadata kubernetes_metadata = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The kubernetesMetadata.
     */
    public com.google.cloud.gkehub.v1alpha2.KubernetesMetadata getKubernetesMetadata() {
      if (kubernetesMetadataBuilder_ == null) {
        return kubernetesMetadata_ == null
            ? com.google.cloud.gkehub.v1alpha2.KubernetesMetadata.getDefaultInstance()
            : kubernetesMetadata_;
      } else {
        return kubernetesMetadataBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Useful Kubernetes-specific metadata.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1alpha2.KubernetesMetadata kubernetes_metadata = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setKubernetesMetadata(
        com.google.cloud.gkehub.v1alpha2.KubernetesMetadata value) {
      if (kubernetesMetadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        kubernetesMetadata_ = value;
      } else {
        kubernetesMetadataBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Useful Kubernetes-specific metadata.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1alpha2.KubernetesMetadata kubernetes_metadata = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setKubernetesMetadata(
        com.google.cloud.gkehub.v1alpha2.KubernetesMetadata.Builder builderForValue) {
      if (kubernetesMetadataBuilder_ == null) {
        kubernetesMetadata_ = builderForValue.build();
      } else {
        kubernetesMetadataBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Useful Kubernetes-specific metadata.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1alpha2.KubernetesMetadata kubernetes_metadata = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeKubernetesMetadata(
        com.google.cloud.gkehub.v1alpha2.KubernetesMetadata value) {
      if (kubernetesMetadataBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && kubernetesMetadata_ != null
            && kubernetesMetadata_
                != com.google.cloud.gkehub.v1alpha2.KubernetesMetadata.getDefaultInstance()) {
          getKubernetesMetadataBuilder().mergeFrom(value);
        } else {
          kubernetesMetadata_ = value;
        }
      } else {
        kubernetesMetadataBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Useful Kubernetes-specific metadata.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1alpha2.KubernetesMetadata kubernetes_metadata = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearKubernetesMetadata() {
      bitField0_ = (bitField0_ & ~0x00000008);
      kubernetesMetadata_ = null;
      if (kubernetesMetadataBuilder_ != null) {
        kubernetesMetadataBuilder_.dispose();
        kubernetesMetadataBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Useful Kubernetes-specific metadata.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1alpha2.KubernetesMetadata kubernetes_metadata = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.gkehub.v1alpha2.KubernetesMetadata.Builder
        getKubernetesMetadataBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getKubernetesMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Useful Kubernetes-specific metadata.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1alpha2.KubernetesMetadata kubernetes_metadata = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.gkehub.v1alpha2.KubernetesMetadataOrBuilder
        getKubernetesMetadataOrBuilder() {
      if (kubernetesMetadataBuilder_ != null) {
        return kubernetesMetadataBuilder_.getMessageOrBuilder();
      } else {
        return kubernetesMetadata_ == null
            ? com.google.cloud.gkehub.v1alpha2.KubernetesMetadata.getDefaultInstance()
            : kubernetesMetadata_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Useful Kubernetes-specific metadata.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1alpha2.KubernetesMetadata kubernetes_metadata = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gkehub.v1alpha2.KubernetesMetadata,
            com.google.cloud.gkehub.v1alpha2.KubernetesMetadata.Builder,
            com.google.cloud.gkehub.v1alpha2.KubernetesMetadataOrBuilder>
        getKubernetesMetadataFieldBuilder() {
      if (kubernetesMetadataBuilder_ == null) {
        kubernetesMetadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.gkehub.v1alpha2.KubernetesMetadata,
                com.google.cloud.gkehub.v1alpha2.KubernetesMetadata.Builder,
                com.google.cloud.gkehub.v1alpha2.KubernetesMetadataOrBuilder>(
                getKubernetesMetadata(), getParentForChildren(), isClean());
        kubernetesMetadata_ = null;
      }
      return kubernetesMetadataBuilder_;
    }

    private com.google.cloud.gkehub.v1alpha2.KubernetesResource kubernetesResource_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gkehub.v1alpha2.KubernetesResource,
            com.google.cloud.gkehub.v1alpha2.KubernetesResource.Builder,
            com.google.cloud.gkehub.v1alpha2.KubernetesResourceOrBuilder>
        kubernetesResourceBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The in-cluster Kubernetes Resources that should be applied for a correctly
     * registered cluster, in the steady state. These resources:
     *
     *   * Ensure that the cluster is exclusively registered to one and only one
     *     Hub Membership.
     *   * Propagate Workload Pool Information available in the Membership
     *     Authority field.
     *   * Ensure proper initial configuration of default Hub Features.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1alpha2.KubernetesResource kubernetes_resource = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the kubernetesResource field is set.
     */
    public boolean hasKubernetesResource() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The in-cluster Kubernetes Resources that should be applied for a correctly
     * registered cluster, in the steady state. These resources:
     *
     *   * Ensure that the cluster is exclusively registered to one and only one
     *     Hub Membership.
     *   * Propagate Workload Pool Information available in the Membership
     *     Authority field.
     *   * Ensure proper initial configuration of default Hub Features.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1alpha2.KubernetesResource kubernetes_resource = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The kubernetesResource.
     */
    public com.google.cloud.gkehub.v1alpha2.KubernetesResource getKubernetesResource() {
      if (kubernetesResourceBuilder_ == null) {
        return kubernetesResource_ == null
            ? com.google.cloud.gkehub.v1alpha2.KubernetesResource.getDefaultInstance()
            : kubernetesResource_;
      } else {
        return kubernetesResourceBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The in-cluster Kubernetes Resources that should be applied for a correctly
     * registered cluster, in the steady state. These resources:
     *
     *   * Ensure that the cluster is exclusively registered to one and only one
     *     Hub Membership.
     *   * Propagate Workload Pool Information available in the Membership
     *     Authority field.
     *   * Ensure proper initial configuration of default Hub Features.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1alpha2.KubernetesResource kubernetes_resource = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setKubernetesResource(
        com.google.cloud.gkehub.v1alpha2.KubernetesResource value) {
      if (kubernetesResourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        kubernetesResource_ = value;
      } else {
        kubernetesResourceBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The in-cluster Kubernetes Resources that should be applied for a correctly
     * registered cluster, in the steady state. These resources:
     *
     *   * Ensure that the cluster is exclusively registered to one and only one
     *     Hub Membership.
     *   * Propagate Workload Pool Information available in the Membership
     *     Authority field.
     *   * Ensure proper initial configuration of default Hub Features.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1alpha2.KubernetesResource kubernetes_resource = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setKubernetesResource(
        com.google.cloud.gkehub.v1alpha2.KubernetesResource.Builder builderForValue) {
      if (kubernetesResourceBuilder_ == null) {
        kubernetesResource_ = builderForValue.build();
      } else {
        kubernetesResourceBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The in-cluster Kubernetes Resources that should be applied for a correctly
     * registered cluster, in the steady state. These resources:
     *
     *   * Ensure that the cluster is exclusively registered to one and only one
     *     Hub Membership.
     *   * Propagate Workload Pool Information available in the Membership
     *     Authority field.
     *   * Ensure proper initial configuration of default Hub Features.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1alpha2.KubernetesResource kubernetes_resource = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeKubernetesResource(
        com.google.cloud.gkehub.v1alpha2.KubernetesResource value) {
      if (kubernetesResourceBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && kubernetesResource_ != null
            && kubernetesResource_
                != com.google.cloud.gkehub.v1alpha2.KubernetesResource.getDefaultInstance()) {
          getKubernetesResourceBuilder().mergeFrom(value);
        } else {
          kubernetesResource_ = value;
        }
      } else {
        kubernetesResourceBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The in-cluster Kubernetes Resources that should be applied for a correctly
     * registered cluster, in the steady state. These resources:
     *
     *   * Ensure that the cluster is exclusively registered to one and only one
     *     Hub Membership.
     *   * Propagate Workload Pool Information available in the Membership
     *     Authority field.
     *   * Ensure proper initial configuration of default Hub Features.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1alpha2.KubernetesResource kubernetes_resource = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearKubernetesResource() {
      bitField0_ = (bitField0_ & ~0x00000010);
      kubernetesResource_ = null;
      if (kubernetesResourceBuilder_ != null) {
        kubernetesResourceBuilder_.dispose();
        kubernetesResourceBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The in-cluster Kubernetes Resources that should be applied for a correctly
     * registered cluster, in the steady state. These resources:
     *
     *   * Ensure that the cluster is exclusively registered to one and only one
     *     Hub Membership.
     *   * Propagate Workload Pool Information available in the Membership
     *     Authority field.
     *   * Ensure proper initial configuration of default Hub Features.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1alpha2.KubernetesResource kubernetes_resource = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.gkehub.v1alpha2.KubernetesResource.Builder
        getKubernetesResourceBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getKubernetesResourceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The in-cluster Kubernetes Resources that should be applied for a correctly
     * registered cluster, in the steady state. These resources:
     *
     *   * Ensure that the cluster is exclusively registered to one and only one
     *     Hub Membership.
     *   * Propagate Workload Pool Information available in the Membership
     *     Authority field.
     *   * Ensure proper initial configuration of default Hub Features.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1alpha2.KubernetesResource kubernetes_resource = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.gkehub.v1alpha2.KubernetesResourceOrBuilder
        getKubernetesResourceOrBuilder() {
      if (kubernetesResourceBuilder_ != null) {
        return kubernetesResourceBuilder_.getMessageOrBuilder();
      } else {
        return kubernetesResource_ == null
            ? com.google.cloud.gkehub.v1alpha2.KubernetesResource.getDefaultInstance()
            : kubernetesResource_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The in-cluster Kubernetes Resources that should be applied for a correctly
     * registered cluster, in the steady state. These resources:
     *
     *   * Ensure that the cluster is exclusively registered to one and only one
     *     Hub Membership.
     *   * Propagate Workload Pool Information available in the Membership
     *     Authority field.
     *   * Ensure proper initial configuration of default Hub Features.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1alpha2.KubernetesResource kubernetes_resource = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gkehub.v1alpha2.KubernetesResource,
            com.google.cloud.gkehub.v1alpha2.KubernetesResource.Builder,
            com.google.cloud.gkehub.v1alpha2.KubernetesResourceOrBuilder>
        getKubernetesResourceFieldBuilder() {
      if (kubernetesResourceBuilder_ == null) {
        kubernetesResourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.gkehub.v1alpha2.KubernetesResource,
                com.google.cloud.gkehub.v1alpha2.KubernetesResource.Builder,
                com.google.cloud.gkehub.v1alpha2.KubernetesResourceOrBuilder>(
                getKubernetesResource(), getParentForChildren(), isClean());
        kubernetesResource_ = null;
      }
      return kubernetesResourceBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.gkehub.v1alpha2.MembershipEndpoint)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.gkehub.v1alpha2.MembershipEndpoint)
  private static final com.google.cloud.gkehub.v1alpha2.MembershipEndpoint DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.gkehub.v1alpha2.MembershipEndpoint();
  }

  public static com.google.cloud.gkehub.v1alpha2.MembershipEndpoint getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<MembershipEndpoint> PARSER =
      new com.google.protobuf.AbstractParser<MembershipEndpoint>() {
        @java.lang.Override
        public MembershipEndpoint parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<MembershipEndpoint> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<MembershipEndpoint> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.gkehub.v1alpha2.MembershipEndpoint getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
