/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/gkehub/v1beta/feature.proto

package com.google.cloud.gkehub.v1beta;

/**
 *
 *
 * <pre>
 * Feature represents the settings and status of any Hub Feature.
 * </pre>
 *
 * Protobuf type {@code google.cloud.gkehub.v1beta.Feature}
 */
public final class Feature extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.gkehub.v1beta.Feature)
    FeatureOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Feature.newBuilder() to construct.
  private Feature(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Feature() {
    name_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Feature();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.gkehub.v1beta.FeatureProto
        .internal_static_google_cloud_gkehub_v1beta_Feature_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 2:
        return internalGetLabels();
      case 5:
        return internalGetMembershipSpecs();
      case 7:
        return internalGetMembershipStates();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.gkehub.v1beta.FeatureProto
        .internal_static_google_cloud_gkehub_v1beta_Feature_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.gkehub.v1beta.Feature.class,
            com.google.cloud.gkehub.v1beta.Feature.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The full, unique name of this Feature resource in the format
   * `projects/&#42;&#47;locations/&#42;&#47;features/&#42;`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The full, unique name of this Feature resource in the format
   * `projects/&#42;&#47;locations/&#42;&#47;features/&#42;`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LABELS_FIELD_NUMBER = 2;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.gkehub.v1beta.FeatureProto
                .internal_static_google_cloud_gkehub_v1beta_Feature_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * GCP labels for this Feature.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 2;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * GCP labels for this Feature.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 2;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * GCP labels for this Feature.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 2;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * GCP labels for this Feature.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 2;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int RESOURCE_STATE_FIELD_NUMBER = 3;
  private com.google.cloud.gkehub.v1beta.FeatureResourceState resourceState_;
  /**
   *
   *
   * <pre>
   * Output only. State of the Feature resource itself.
   * </pre>
   *
   * <code>
   * .google.cloud.gkehub.v1beta.FeatureResourceState resource_state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the resourceState field is set.
   */
  @java.lang.Override
  public boolean hasResourceState() {
    return resourceState_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. State of the Feature resource itself.
   * </pre>
   *
   * <code>
   * .google.cloud.gkehub.v1beta.FeatureResourceState resource_state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The resourceState.
   */
  @java.lang.Override
  public com.google.cloud.gkehub.v1beta.FeatureResourceState getResourceState() {
    return resourceState_ == null
        ? com.google.cloud.gkehub.v1beta.FeatureResourceState.getDefaultInstance()
        : resourceState_;
  }
  /**
   *
   *
   * <pre>
   * Output only. State of the Feature resource itself.
   * </pre>
   *
   * <code>
   * .google.cloud.gkehub.v1beta.FeatureResourceState resource_state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.gkehub.v1beta.FeatureResourceStateOrBuilder getResourceStateOrBuilder() {
    return resourceState_ == null
        ? com.google.cloud.gkehub.v1beta.FeatureResourceState.getDefaultInstance()
        : resourceState_;
  }

  public static final int SPEC_FIELD_NUMBER = 4;
  private com.google.cloud.gkehub.v1beta.CommonFeatureSpec spec_;
  /**
   *
   *
   * <pre>
   * Optional. Hub-wide Feature configuration. If this Feature does not support any
   * Hub-wide configuration, this field may be unused.
   * </pre>
   *
   * <code>
   * .google.cloud.gkehub.v1beta.CommonFeatureSpec spec = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the spec field is set.
   */
  @java.lang.Override
  public boolean hasSpec() {
    return spec_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. Hub-wide Feature configuration. If this Feature does not support any
   * Hub-wide configuration, this field may be unused.
   * </pre>
   *
   * <code>
   * .google.cloud.gkehub.v1beta.CommonFeatureSpec spec = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The spec.
   */
  @java.lang.Override
  public com.google.cloud.gkehub.v1beta.CommonFeatureSpec getSpec() {
    return spec_ == null
        ? com.google.cloud.gkehub.v1beta.CommonFeatureSpec.getDefaultInstance()
        : spec_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Hub-wide Feature configuration. If this Feature does not support any
   * Hub-wide configuration, this field may be unused.
   * </pre>
   *
   * <code>
   * .google.cloud.gkehub.v1beta.CommonFeatureSpec spec = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.gkehub.v1beta.CommonFeatureSpecOrBuilder getSpecOrBuilder() {
    return spec_ == null
        ? com.google.cloud.gkehub.v1beta.CommonFeatureSpec.getDefaultInstance()
        : spec_;
  }

  public static final int MEMBERSHIP_SPECS_FIELD_NUMBER = 5;

  private static final class MembershipSpecsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
            java.lang.String, com.google.cloud.gkehub.v1beta.MembershipFeatureSpec>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String, com.google.cloud.gkehub.v1beta.MembershipFeatureSpec>
                    newDefaultInstance(
                        com.google.cloud.gkehub.v1beta.FeatureProto
                            .internal_static_google_cloud_gkehub_v1beta_Feature_MembershipSpecsEntry_descriptor,
                        com.google.protobuf.WireFormat.FieldType.STRING,
                        "",
                        com.google.protobuf.WireFormat.FieldType.MESSAGE,
                        com.google.cloud.gkehub.v1beta.MembershipFeatureSpec.getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.gkehub.v1beta.MembershipFeatureSpec>
      membershipSpecs_;

  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.gkehub.v1beta.MembershipFeatureSpec>
      internalGetMembershipSpecs() {
    if (membershipSpecs_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          MembershipSpecsDefaultEntryHolder.defaultEntry);
    }
    return membershipSpecs_;
  }

  public int getMembershipSpecsCount() {
    return internalGetMembershipSpecs().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Membership-specific configuration for this Feature. If this Feature does
   * not support any per-Membership configuration, this field may be unused.
   *
   * The keys indicate which Membership the configuration is for, in the form:
   *
   *     projects/{p}/locations/{l}/memberships/{m}
   *
   * Where {p} is the project, {l} is a valid location and {m} is a valid
   * Membership in this project at that location. {p} WILL match the Feature's
   * project.
   *
   * {p} will always be returned as the project number, but the project ID is
   * also accepted during input. If the same Membership is specified in the map
   * twice (using the project ID form, and the project number form), exactly
   * ONE of the entries will be saved, with no guarantees as to which. For this
   * reason, it is recommended the same format be used for all entries when
   * mutating a Feature.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.gkehub.v1beta.MembershipFeatureSpec&gt; membership_specs = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public boolean containsMembershipSpecs(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetMembershipSpecs().getMap().containsKey(key);
  }
  /** Use {@link #getMembershipSpecsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, com.google.cloud.gkehub.v1beta.MembershipFeatureSpec>
      getMembershipSpecs() {
    return getMembershipSpecsMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. Membership-specific configuration for this Feature. If this Feature does
   * not support any per-Membership configuration, this field may be unused.
   *
   * The keys indicate which Membership the configuration is for, in the form:
   *
   *     projects/{p}/locations/{l}/memberships/{m}
   *
   * Where {p} is the project, {l} is a valid location and {m} is a valid
   * Membership in this project at that location. {p} WILL match the Feature's
   * project.
   *
   * {p} will always be returned as the project number, but the project ID is
   * also accepted during input. If the same Membership is specified in the map
   * twice (using the project ID form, and the project number form), exactly
   * ONE of the entries will be saved, with no guarantees as to which. For this
   * reason, it is recommended the same format be used for all entries when
   * mutating a Feature.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.gkehub.v1beta.MembershipFeatureSpec&gt; membership_specs = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, com.google.cloud.gkehub.v1beta.MembershipFeatureSpec>
      getMembershipSpecsMap() {
    return internalGetMembershipSpecs().getMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. Membership-specific configuration for this Feature. If this Feature does
   * not support any per-Membership configuration, this field may be unused.
   *
   * The keys indicate which Membership the configuration is for, in the form:
   *
   *     projects/{p}/locations/{l}/memberships/{m}
   *
   * Where {p} is the project, {l} is a valid location and {m} is a valid
   * Membership in this project at that location. {p} WILL match the Feature's
   * project.
   *
   * {p} will always be returned as the project number, but the project ID is
   * also accepted during input. If the same Membership is specified in the map
   * twice (using the project ID form, and the project number form), exactly
   * ONE of the entries will be saved, with no guarantees as to which. For this
   * reason, it is recommended the same format be used for all entries when
   * mutating a Feature.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.gkehub.v1beta.MembershipFeatureSpec&gt; membership_specs = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public /* nullable */ com.google.cloud.gkehub.v1beta.MembershipFeatureSpec
      getMembershipSpecsOrDefault(
          java.lang.String key,
          /* nullable */
          com.google.cloud.gkehub.v1beta.MembershipFeatureSpec defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.gkehub.v1beta.MembershipFeatureSpec> map =
        internalGetMembershipSpecs().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Optional. Membership-specific configuration for this Feature. If this Feature does
   * not support any per-Membership configuration, this field may be unused.
   *
   * The keys indicate which Membership the configuration is for, in the form:
   *
   *     projects/{p}/locations/{l}/memberships/{m}
   *
   * Where {p} is the project, {l} is a valid location and {m} is a valid
   * Membership in this project at that location. {p} WILL match the Feature's
   * project.
   *
   * {p} will always be returned as the project number, but the project ID is
   * also accepted during input. If the same Membership is specified in the map
   * twice (using the project ID form, and the project number form), exactly
   * ONE of the entries will be saved, with no guarantees as to which. For this
   * reason, it is recommended the same format be used for all entries when
   * mutating a Feature.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.gkehub.v1beta.MembershipFeatureSpec&gt; membership_specs = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.gkehub.v1beta.MembershipFeatureSpec getMembershipSpecsOrThrow(
      java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.gkehub.v1beta.MembershipFeatureSpec> map =
        internalGetMembershipSpecs().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int STATE_FIELD_NUMBER = 6;
  private com.google.cloud.gkehub.v1beta.CommonFeatureState state_;
  /**
   *
   *
   * <pre>
   * Output only. The Hub-wide Feature state.
   * </pre>
   *
   * <code>
   * .google.cloud.gkehub.v1beta.CommonFeatureState state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the state field is set.
   */
  @java.lang.Override
  public boolean hasState() {
    return state_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The Hub-wide Feature state.
   * </pre>
   *
   * <code>
   * .google.cloud.gkehub.v1beta.CommonFeatureState state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.gkehub.v1beta.CommonFeatureState getState() {
    return state_ == null
        ? com.google.cloud.gkehub.v1beta.CommonFeatureState.getDefaultInstance()
        : state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The Hub-wide Feature state.
   * </pre>
   *
   * <code>
   * .google.cloud.gkehub.v1beta.CommonFeatureState state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.gkehub.v1beta.CommonFeatureStateOrBuilder getStateOrBuilder() {
    return state_ == null
        ? com.google.cloud.gkehub.v1beta.CommonFeatureState.getDefaultInstance()
        : state_;
  }

  public static final int MEMBERSHIP_STATES_FIELD_NUMBER = 7;

  private static final class MembershipStatesDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
            java.lang.String, com.google.cloud.gkehub.v1beta.MembershipFeatureState>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String, com.google.cloud.gkehub.v1beta.MembershipFeatureState>
                    newDefaultInstance(
                        com.google.cloud.gkehub.v1beta.FeatureProto
                            .internal_static_google_cloud_gkehub_v1beta_Feature_MembershipStatesEntry_descriptor,
                        com.google.protobuf.WireFormat.FieldType.STRING,
                        "",
                        com.google.protobuf.WireFormat.FieldType.MESSAGE,
                        com.google.cloud.gkehub.v1beta.MembershipFeatureState.getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.gkehub.v1beta.MembershipFeatureState>
      membershipStates_;

  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.gkehub.v1beta.MembershipFeatureState>
      internalGetMembershipStates() {
    if (membershipStates_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          MembershipStatesDefaultEntryHolder.defaultEntry);
    }
    return membershipStates_;
  }

  public int getMembershipStatesCount() {
    return internalGetMembershipStates().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Membership-specific Feature status. If this Feature does
   * report any per-Membership status, this field may be unused.
   *
   * The keys indicate which Membership the state is for, in the form:
   *
   *     projects/{p}/locations/{l}/memberships/{m}
   *
   * Where {p} is the project number, {l} is a valid location and {m} is a valid
   * Membership in this project at that location. {p} MUST match the Feature's
   * project number.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.gkehub.v1beta.MembershipFeatureState&gt; membership_states = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public boolean containsMembershipStates(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetMembershipStates().getMap().containsKey(key);
  }
  /** Use {@link #getMembershipStatesMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, com.google.cloud.gkehub.v1beta.MembershipFeatureState>
      getMembershipStates() {
    return getMembershipStatesMap();
  }
  /**
   *
   *
   * <pre>
   * Output only. Membership-specific Feature status. If this Feature does
   * report any per-Membership status, this field may be unused.
   *
   * The keys indicate which Membership the state is for, in the form:
   *
   *     projects/{p}/locations/{l}/memberships/{m}
   *
   * Where {p} is the project number, {l} is a valid location and {m} is a valid
   * Membership in this project at that location. {p} MUST match the Feature's
   * project number.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.gkehub.v1beta.MembershipFeatureState&gt; membership_states = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, com.google.cloud.gkehub.v1beta.MembershipFeatureState>
      getMembershipStatesMap() {
    return internalGetMembershipStates().getMap();
  }
  /**
   *
   *
   * <pre>
   * Output only. Membership-specific Feature status. If this Feature does
   * report any per-Membership status, this field may be unused.
   *
   * The keys indicate which Membership the state is for, in the form:
   *
   *     projects/{p}/locations/{l}/memberships/{m}
   *
   * Where {p} is the project number, {l} is a valid location and {m} is a valid
   * Membership in this project at that location. {p} MUST match the Feature's
   * project number.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.gkehub.v1beta.MembershipFeatureState&gt; membership_states = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public /* nullable */ com.google.cloud.gkehub.v1beta.MembershipFeatureState
      getMembershipStatesOrDefault(
          java.lang.String key,
          /* nullable */
          com.google.cloud.gkehub.v1beta.MembershipFeatureState defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.gkehub.v1beta.MembershipFeatureState> map =
        internalGetMembershipStates().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Output only. Membership-specific Feature status. If this Feature does
   * report any per-Membership status, this field may be unused.
   *
   * The keys indicate which Membership the state is for, in the form:
   *
   *     projects/{p}/locations/{l}/memberships/{m}
   *
   * Where {p} is the project number, {l} is a valid location and {m} is a valid
   * Membership in this project at that location. {p} MUST match the Feature's
   * project number.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.gkehub.v1beta.MembershipFeatureState&gt; membership_states = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.gkehub.v1beta.MembershipFeatureState getMembershipStatesOrThrow(
      java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.gkehub.v1beta.MembershipFeatureState> map =
        internalGetMembershipStates().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 8;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. When the Feature resource was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. When the Feature resource was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. When the Feature resource was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 9;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. When the Feature resource was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. When the Feature resource was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. When the Feature resource was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int DELETE_TIME_FIELD_NUMBER = 10;
  private com.google.protobuf.Timestamp deleteTime_;
  /**
   *
   *
   * <pre>
   * Output only. When the Feature resource was deleted.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp delete_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the deleteTime field is set.
   */
  @java.lang.Override
  public boolean hasDeleteTime() {
    return deleteTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. When the Feature resource was deleted.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp delete_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The deleteTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getDeleteTime() {
    return deleteTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : deleteTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. When the Feature resource was deleted.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp delete_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getDeleteTimeOrBuilder() {
    return deleteTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : deleteTime_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 2);
    if (resourceState_ != null) {
      output.writeMessage(3, getResourceState());
    }
    if (spec_ != null) {
      output.writeMessage(4, getSpec());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetMembershipSpecs(), MembershipSpecsDefaultEntryHolder.defaultEntry, 5);
    if (state_ != null) {
      output.writeMessage(6, getState());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetMembershipStates(), MembershipStatesDefaultEntryHolder.defaultEntry, 7);
    if (createTime_ != null) {
      output.writeMessage(8, getCreateTime());
    }
    if (updateTime_ != null) {
      output.writeMessage(9, getUpdateTime());
    }
    if (deleteTime_ != null) {
      output.writeMessage(10, getDeleteTime());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, labels__);
    }
    if (resourceState_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getResourceState());
    }
    if (spec_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getSpec());
    }
    for (java.util.Map.Entry<java.lang.String, com.google.cloud.gkehub.v1beta.MembershipFeatureSpec>
        entry : internalGetMembershipSpecs().getMap().entrySet()) {
      com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.gkehub.v1beta.MembershipFeatureSpec>
          membershipSpecs__ =
              MembershipSpecsDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, membershipSpecs__);
    }
    if (state_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getState());
    }
    for (java.util.Map.Entry<
            java.lang.String, com.google.cloud.gkehub.v1beta.MembershipFeatureState>
        entry : internalGetMembershipStates().getMap().entrySet()) {
      com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.gkehub.v1beta.MembershipFeatureState>
          membershipStates__ =
              MembershipStatesDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, membershipStates__);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getCreateTime());
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getUpdateTime());
    }
    if (deleteTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getDeleteTime());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.gkehub.v1beta.Feature)) {
      return super.equals(obj);
    }
    com.google.cloud.gkehub.v1beta.Feature other = (com.google.cloud.gkehub.v1beta.Feature) obj;

    if (!getName().equals(other.getName())) return false;
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (hasResourceState() != other.hasResourceState()) return false;
    if (hasResourceState()) {
      if (!getResourceState().equals(other.getResourceState())) return false;
    }
    if (hasSpec() != other.hasSpec()) return false;
    if (hasSpec()) {
      if (!getSpec().equals(other.getSpec())) return false;
    }
    if (!internalGetMembershipSpecs().equals(other.internalGetMembershipSpecs())) return false;
    if (hasState() != other.hasState()) return false;
    if (hasState()) {
      if (!getState().equals(other.getState())) return false;
    }
    if (!internalGetMembershipStates().equals(other.internalGetMembershipStates())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (hasDeleteTime() != other.hasDeleteTime()) return false;
    if (hasDeleteTime()) {
      if (!getDeleteTime().equals(other.getDeleteTime())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (hasResourceState()) {
      hash = (37 * hash) + RESOURCE_STATE_FIELD_NUMBER;
      hash = (53 * hash) + getResourceState().hashCode();
    }
    if (hasSpec()) {
      hash = (37 * hash) + SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getSpec().hashCode();
    }
    if (!internalGetMembershipSpecs().getMap().isEmpty()) {
      hash = (37 * hash) + MEMBERSHIP_SPECS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetMembershipSpecs().hashCode();
    }
    if (hasState()) {
      hash = (37 * hash) + STATE_FIELD_NUMBER;
      hash = (53 * hash) + getState().hashCode();
    }
    if (!internalGetMembershipStates().getMap().isEmpty()) {
      hash = (37 * hash) + MEMBERSHIP_STATES_FIELD_NUMBER;
      hash = (53 * hash) + internalGetMembershipStates().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (hasDeleteTime()) {
      hash = (37 * hash) + DELETE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getDeleteTime().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.gkehub.v1beta.Feature parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gkehub.v1beta.Feature parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gkehub.v1beta.Feature parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gkehub.v1beta.Feature parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gkehub.v1beta.Feature parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gkehub.v1beta.Feature parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gkehub.v1beta.Feature parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.gkehub.v1beta.Feature parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.gkehub.v1beta.Feature parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.gkehub.v1beta.Feature parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.gkehub.v1beta.Feature parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.gkehub.v1beta.Feature parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.gkehub.v1beta.Feature prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Feature represents the settings and status of any Hub Feature.
   * </pre>
   *
   * Protobuf type {@code google.cloud.gkehub.v1beta.Feature}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.gkehub.v1beta.Feature)
      com.google.cloud.gkehub.v1beta.FeatureOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.gkehub.v1beta.FeatureProto
          .internal_static_google_cloud_gkehub_v1beta_Feature_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 2:
          return internalGetLabels();
        case 5:
          return internalGetMembershipSpecs();
        case 7:
          return internalGetMembershipStates();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 2:
          return internalGetMutableLabels();
        case 5:
          return internalGetMutableMembershipSpecs();
        case 7:
          return internalGetMutableMembershipStates();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.gkehub.v1beta.FeatureProto
          .internal_static_google_cloud_gkehub_v1beta_Feature_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.gkehub.v1beta.Feature.class,
              com.google.cloud.gkehub.v1beta.Feature.Builder.class);
    }

    // Construct using com.google.cloud.gkehub.v1beta.Feature.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      internalGetMutableLabels().clear();
      resourceState_ = null;
      if (resourceStateBuilder_ != null) {
        resourceStateBuilder_.dispose();
        resourceStateBuilder_ = null;
      }
      spec_ = null;
      if (specBuilder_ != null) {
        specBuilder_.dispose();
        specBuilder_ = null;
      }
      internalGetMutableMembershipSpecs().clear();
      state_ = null;
      if (stateBuilder_ != null) {
        stateBuilder_.dispose();
        stateBuilder_ = null;
      }
      internalGetMutableMembershipStates().clear();
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      deleteTime_ = null;
      if (deleteTimeBuilder_ != null) {
        deleteTimeBuilder_.dispose();
        deleteTimeBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.gkehub.v1beta.FeatureProto
          .internal_static_google_cloud_gkehub_v1beta_Feature_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.gkehub.v1beta.Feature getDefaultInstanceForType() {
      return com.google.cloud.gkehub.v1beta.Feature.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.gkehub.v1beta.Feature build() {
      com.google.cloud.gkehub.v1beta.Feature result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.gkehub.v1beta.Feature buildPartial() {
      com.google.cloud.gkehub.v1beta.Feature result =
          new com.google.cloud.gkehub.v1beta.Feature(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.gkehub.v1beta.Feature result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.resourceState_ =
            resourceStateBuilder_ == null ? resourceState_ : resourceStateBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.spec_ = specBuilder_ == null ? spec_ : specBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.membershipSpecs_ = internalGetMembershipSpecs();
        result.membershipSpecs_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.state_ = stateBuilder_ == null ? state_ : stateBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.membershipStates_ = internalGetMembershipStates();
        result.membershipStates_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.deleteTime_ = deleteTimeBuilder_ == null ? deleteTime_ : deleteTimeBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.gkehub.v1beta.Feature) {
        return mergeFrom((com.google.cloud.gkehub.v1beta.Feature) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.gkehub.v1beta.Feature other) {
      if (other == com.google.cloud.gkehub.v1beta.Feature.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000002;
      if (other.hasResourceState()) {
        mergeResourceState(other.getResourceState());
      }
      if (other.hasSpec()) {
        mergeSpec(other.getSpec());
      }
      internalGetMutableMembershipSpecs().mergeFrom(other.internalGetMembershipSpecs());
      bitField0_ |= 0x00000010;
      if (other.hasState()) {
        mergeState(other.getState());
      }
      internalGetMutableMembershipStates().mergeFrom(other.internalGetMembershipStates());
      bitField0_ |= 0x00000040;
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (other.hasDeleteTime()) {
        mergeDeleteTime(other.getDeleteTime());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getResourceStateFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getSpecFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                com.google.protobuf.MapEntry<
                        java.lang.String, com.google.cloud.gkehub.v1beta.MembershipFeatureSpec>
                    membershipSpecs__ =
                        input.readMessage(
                            MembershipSpecsDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableMembershipSpecs()
                    .getMutableMap()
                    .put(membershipSpecs__.getKey(), membershipSpecs__.getValue());
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getStateFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                com.google.protobuf.MapEntry<
                        java.lang.String, com.google.cloud.gkehub.v1beta.MembershipFeatureState>
                    membershipStates__ =
                        input.readMessage(
                            MembershipStatesDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableMembershipStates()
                    .getMutableMap()
                    .put(membershipStates__.getKey(), membershipStates__.getValue());
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 74
            case 82:
              {
                input.readMessage(getDeleteTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 82
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The full, unique name of this Feature resource in the format
     * `projects/&#42;&#47;locations/&#42;&#47;features/&#42;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The full, unique name of this Feature resource in the format
     * `projects/&#42;&#47;locations/&#42;&#47;features/&#42;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The full, unique name of this Feature resource in the format
     * `projects/&#42;&#47;locations/&#42;&#47;features/&#42;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The full, unique name of this Feature resource in the format
     * `projects/&#42;&#47;locations/&#42;&#47;features/&#42;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The full, unique name of this Feature resource in the format
     * `projects/&#42;&#47;locations/&#42;&#47;features/&#42;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * GCP labels for this Feature.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 2;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * GCP labels for this Feature.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 2;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * GCP labels for this Feature.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 2;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * GCP labels for this Feature.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 2;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000002);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * GCP labels for this Feature.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 2;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000002;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * GCP labels for this Feature.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 2;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000002;
      return this;
    }
    /**
     *
     *
     * <pre>
     * GCP labels for this Feature.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 2;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000002;
      return this;
    }

    private com.google.cloud.gkehub.v1beta.FeatureResourceState resourceState_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gkehub.v1beta.FeatureResourceState,
            com.google.cloud.gkehub.v1beta.FeatureResourceState.Builder,
            com.google.cloud.gkehub.v1beta.FeatureResourceStateOrBuilder>
        resourceStateBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. State of the Feature resource itself.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta.FeatureResourceState resource_state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the resourceState field is set.
     */
    public boolean hasResourceState() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the Feature resource itself.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta.FeatureResourceState resource_state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The resourceState.
     */
    public com.google.cloud.gkehub.v1beta.FeatureResourceState getResourceState() {
      if (resourceStateBuilder_ == null) {
        return resourceState_ == null
            ? com.google.cloud.gkehub.v1beta.FeatureResourceState.getDefaultInstance()
            : resourceState_;
      } else {
        return resourceStateBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the Feature resource itself.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta.FeatureResourceState resource_state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setResourceState(com.google.cloud.gkehub.v1beta.FeatureResourceState value) {
      if (resourceStateBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        resourceState_ = value;
      } else {
        resourceStateBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the Feature resource itself.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta.FeatureResourceState resource_state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setResourceState(
        com.google.cloud.gkehub.v1beta.FeatureResourceState.Builder builderForValue) {
      if (resourceStateBuilder_ == null) {
        resourceState_ = builderForValue.build();
      } else {
        resourceStateBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the Feature resource itself.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta.FeatureResourceState resource_state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeResourceState(com.google.cloud.gkehub.v1beta.FeatureResourceState value) {
      if (resourceStateBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && resourceState_ != null
            && resourceState_
                != com.google.cloud.gkehub.v1beta.FeatureResourceState.getDefaultInstance()) {
          getResourceStateBuilder().mergeFrom(value);
        } else {
          resourceState_ = value;
        }
      } else {
        resourceStateBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the Feature resource itself.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta.FeatureResourceState resource_state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearResourceState() {
      bitField0_ = (bitField0_ & ~0x00000004);
      resourceState_ = null;
      if (resourceStateBuilder_ != null) {
        resourceStateBuilder_.dispose();
        resourceStateBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the Feature resource itself.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta.FeatureResourceState resource_state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.gkehub.v1beta.FeatureResourceState.Builder getResourceStateBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getResourceStateFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the Feature resource itself.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta.FeatureResourceState resource_state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.gkehub.v1beta.FeatureResourceStateOrBuilder
        getResourceStateOrBuilder() {
      if (resourceStateBuilder_ != null) {
        return resourceStateBuilder_.getMessageOrBuilder();
      } else {
        return resourceState_ == null
            ? com.google.cloud.gkehub.v1beta.FeatureResourceState.getDefaultInstance()
            : resourceState_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the Feature resource itself.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta.FeatureResourceState resource_state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gkehub.v1beta.FeatureResourceState,
            com.google.cloud.gkehub.v1beta.FeatureResourceState.Builder,
            com.google.cloud.gkehub.v1beta.FeatureResourceStateOrBuilder>
        getResourceStateFieldBuilder() {
      if (resourceStateBuilder_ == null) {
        resourceStateBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.gkehub.v1beta.FeatureResourceState,
                com.google.cloud.gkehub.v1beta.FeatureResourceState.Builder,
                com.google.cloud.gkehub.v1beta.FeatureResourceStateOrBuilder>(
                getResourceState(), getParentForChildren(), isClean());
        resourceState_ = null;
      }
      return resourceStateBuilder_;
    }

    private com.google.cloud.gkehub.v1beta.CommonFeatureSpec spec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gkehub.v1beta.CommonFeatureSpec,
            com.google.cloud.gkehub.v1beta.CommonFeatureSpec.Builder,
            com.google.cloud.gkehub.v1beta.CommonFeatureSpecOrBuilder>
        specBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Hub-wide Feature configuration. If this Feature does not support any
     * Hub-wide configuration, this field may be unused.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta.CommonFeatureSpec spec = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the spec field is set.
     */
    public boolean hasSpec() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Hub-wide Feature configuration. If this Feature does not support any
     * Hub-wide configuration, this field may be unused.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta.CommonFeatureSpec spec = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The spec.
     */
    public com.google.cloud.gkehub.v1beta.CommonFeatureSpec getSpec() {
      if (specBuilder_ == null) {
        return spec_ == null
            ? com.google.cloud.gkehub.v1beta.CommonFeatureSpec.getDefaultInstance()
            : spec_;
      } else {
        return specBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Hub-wide Feature configuration. If this Feature does not support any
     * Hub-wide configuration, this field may be unused.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta.CommonFeatureSpec spec = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSpec(com.google.cloud.gkehub.v1beta.CommonFeatureSpec value) {
      if (specBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        spec_ = value;
      } else {
        specBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Hub-wide Feature configuration. If this Feature does not support any
     * Hub-wide configuration, this field may be unused.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta.CommonFeatureSpec spec = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSpec(
        com.google.cloud.gkehub.v1beta.CommonFeatureSpec.Builder builderForValue) {
      if (specBuilder_ == null) {
        spec_ = builderForValue.build();
      } else {
        specBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Hub-wide Feature configuration. If this Feature does not support any
     * Hub-wide configuration, this field may be unused.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta.CommonFeatureSpec spec = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeSpec(com.google.cloud.gkehub.v1beta.CommonFeatureSpec value) {
      if (specBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && spec_ != null
            && spec_ != com.google.cloud.gkehub.v1beta.CommonFeatureSpec.getDefaultInstance()) {
          getSpecBuilder().mergeFrom(value);
        } else {
          spec_ = value;
        }
      } else {
        specBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Hub-wide Feature configuration. If this Feature does not support any
     * Hub-wide configuration, this field may be unused.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta.CommonFeatureSpec spec = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearSpec() {
      bitField0_ = (bitField0_ & ~0x00000008);
      spec_ = null;
      if (specBuilder_ != null) {
        specBuilder_.dispose();
        specBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Hub-wide Feature configuration. If this Feature does not support any
     * Hub-wide configuration, this field may be unused.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta.CommonFeatureSpec spec = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.gkehub.v1beta.CommonFeatureSpec.Builder getSpecBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Hub-wide Feature configuration. If this Feature does not support any
     * Hub-wide configuration, this field may be unused.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta.CommonFeatureSpec spec = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.gkehub.v1beta.CommonFeatureSpecOrBuilder getSpecOrBuilder() {
      if (specBuilder_ != null) {
        return specBuilder_.getMessageOrBuilder();
      } else {
        return spec_ == null
            ? com.google.cloud.gkehub.v1beta.CommonFeatureSpec.getDefaultInstance()
            : spec_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Hub-wide Feature configuration. If this Feature does not support any
     * Hub-wide configuration, this field may be unused.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta.CommonFeatureSpec spec = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gkehub.v1beta.CommonFeatureSpec,
            com.google.cloud.gkehub.v1beta.CommonFeatureSpec.Builder,
            com.google.cloud.gkehub.v1beta.CommonFeatureSpecOrBuilder>
        getSpecFieldBuilder() {
      if (specBuilder_ == null) {
        specBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.gkehub.v1beta.CommonFeatureSpec,
                com.google.cloud.gkehub.v1beta.CommonFeatureSpec.Builder,
                com.google.cloud.gkehub.v1beta.CommonFeatureSpecOrBuilder>(
                getSpec(), getParentForChildren(), isClean());
        spec_ = null;
      }
      return specBuilder_;
    }

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.gkehub.v1beta.MembershipFeatureSpec>
        membershipSpecs_;

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.gkehub.v1beta.MembershipFeatureSpec>
        internalGetMembershipSpecs() {
      if (membershipSpecs_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            MembershipSpecsDefaultEntryHolder.defaultEntry);
      }
      return membershipSpecs_;
    }

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.gkehub.v1beta.MembershipFeatureSpec>
        internalGetMutableMembershipSpecs() {
      if (membershipSpecs_ == null) {
        membershipSpecs_ =
            com.google.protobuf.MapField.newMapField(
                MembershipSpecsDefaultEntryHolder.defaultEntry);
      }
      if (!membershipSpecs_.isMutable()) {
        membershipSpecs_ = membershipSpecs_.copy();
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return membershipSpecs_;
    }

    public int getMembershipSpecsCount() {
      return internalGetMembershipSpecs().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Membership-specific configuration for this Feature. If this Feature does
     * not support any per-Membership configuration, this field may be unused.
     *
     * The keys indicate which Membership the configuration is for, in the form:
     *
     *     projects/{p}/locations/{l}/memberships/{m}
     *
     * Where {p} is the project, {l} is a valid location and {m} is a valid
     * Membership in this project at that location. {p} WILL match the Feature's
     * project.
     *
     * {p} will always be returned as the project number, but the project ID is
     * also accepted during input. If the same Membership is specified in the map
     * twice (using the project ID form, and the project number form), exactly
     * ONE of the entries will be saved, with no guarantees as to which. For this
     * reason, it is recommended the same format be used for all entries when
     * mutating a Feature.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.gkehub.v1beta.MembershipFeatureSpec&gt; membership_specs = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public boolean containsMembershipSpecs(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetMembershipSpecs().getMap().containsKey(key);
    }
    /** Use {@link #getMembershipSpecsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.gkehub.v1beta.MembershipFeatureSpec>
        getMembershipSpecs() {
      return getMembershipSpecsMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Membership-specific configuration for this Feature. If this Feature does
     * not support any per-Membership configuration, this field may be unused.
     *
     * The keys indicate which Membership the configuration is for, in the form:
     *
     *     projects/{p}/locations/{l}/memberships/{m}
     *
     * Where {p} is the project, {l} is a valid location and {m} is a valid
     * Membership in this project at that location. {p} WILL match the Feature's
     * project.
     *
     * {p} will always be returned as the project number, but the project ID is
     * also accepted during input. If the same Membership is specified in the map
     * twice (using the project ID form, and the project number form), exactly
     * ONE of the entries will be saved, with no guarantees as to which. For this
     * reason, it is recommended the same format be used for all entries when
     * mutating a Feature.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.gkehub.v1beta.MembershipFeatureSpec&gt; membership_specs = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, com.google.cloud.gkehub.v1beta.MembershipFeatureSpec>
        getMembershipSpecsMap() {
      return internalGetMembershipSpecs().getMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Membership-specific configuration for this Feature. If this Feature does
     * not support any per-Membership configuration, this field may be unused.
     *
     * The keys indicate which Membership the configuration is for, in the form:
     *
     *     projects/{p}/locations/{l}/memberships/{m}
     *
     * Where {p} is the project, {l} is a valid location and {m} is a valid
     * Membership in this project at that location. {p} WILL match the Feature's
     * project.
     *
     * {p} will always be returned as the project number, but the project ID is
     * also accepted during input. If the same Membership is specified in the map
     * twice (using the project ID form, and the project number form), exactly
     * ONE of the entries will be saved, with no guarantees as to which. For this
     * reason, it is recommended the same format be used for all entries when
     * mutating a Feature.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.gkehub.v1beta.MembershipFeatureSpec&gt; membership_specs = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ com.google.cloud.gkehub.v1beta.MembershipFeatureSpec
        getMembershipSpecsOrDefault(
            java.lang.String key,
            /* nullable */
            com.google.cloud.gkehub.v1beta.MembershipFeatureSpec defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.gkehub.v1beta.MembershipFeatureSpec> map =
          internalGetMembershipSpecs().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional. Membership-specific configuration for this Feature. If this Feature does
     * not support any per-Membership configuration, this field may be unused.
     *
     * The keys indicate which Membership the configuration is for, in the form:
     *
     *     projects/{p}/locations/{l}/memberships/{m}
     *
     * Where {p} is the project, {l} is a valid location and {m} is a valid
     * Membership in this project at that location. {p} WILL match the Feature's
     * project.
     *
     * {p} will always be returned as the project number, but the project ID is
     * also accepted during input. If the same Membership is specified in the map
     * twice (using the project ID form, and the project number form), exactly
     * ONE of the entries will be saved, with no guarantees as to which. For this
     * reason, it is recommended the same format be used for all entries when
     * mutating a Feature.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.gkehub.v1beta.MembershipFeatureSpec&gt; membership_specs = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.gkehub.v1beta.MembershipFeatureSpec getMembershipSpecsOrThrow(
        java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.gkehub.v1beta.MembershipFeatureSpec> map =
          internalGetMembershipSpecs().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearMembershipSpecs() {
      bitField0_ = (bitField0_ & ~0x00000010);
      internalGetMutableMembershipSpecs().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Membership-specific configuration for this Feature. If this Feature does
     * not support any per-Membership configuration, this field may be unused.
     *
     * The keys indicate which Membership the configuration is for, in the form:
     *
     *     projects/{p}/locations/{l}/memberships/{m}
     *
     * Where {p} is the project, {l} is a valid location and {m} is a valid
     * Membership in this project at that location. {p} WILL match the Feature's
     * project.
     *
     * {p} will always be returned as the project number, but the project ID is
     * also accepted during input. If the same Membership is specified in the map
     * twice (using the project ID form, and the project number form), exactly
     * ONE of the entries will be saved, with no guarantees as to which. For this
     * reason, it is recommended the same format be used for all entries when
     * mutating a Feature.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.gkehub.v1beta.MembershipFeatureSpec&gt; membership_specs = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeMembershipSpecs(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableMembershipSpecs().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.gkehub.v1beta.MembershipFeatureSpec>
        getMutableMembershipSpecs() {
      bitField0_ |= 0x00000010;
      return internalGetMutableMembershipSpecs().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Membership-specific configuration for this Feature. If this Feature does
     * not support any per-Membership configuration, this field may be unused.
     *
     * The keys indicate which Membership the configuration is for, in the form:
     *
     *     projects/{p}/locations/{l}/memberships/{m}
     *
     * Where {p} is the project, {l} is a valid location and {m} is a valid
     * Membership in this project at that location. {p} WILL match the Feature's
     * project.
     *
     * {p} will always be returned as the project number, but the project ID is
     * also accepted during input. If the same Membership is specified in the map
     * twice (using the project ID form, and the project number form), exactly
     * ONE of the entries will be saved, with no guarantees as to which. For this
     * reason, it is recommended the same format be used for all entries when
     * mutating a Feature.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.gkehub.v1beta.MembershipFeatureSpec&gt; membership_specs = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putMembershipSpecs(
        java.lang.String key, com.google.cloud.gkehub.v1beta.MembershipFeatureSpec value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableMembershipSpecs().getMutableMap().put(key, value);
      bitField0_ |= 0x00000010;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Membership-specific configuration for this Feature. If this Feature does
     * not support any per-Membership configuration, this field may be unused.
     *
     * The keys indicate which Membership the configuration is for, in the form:
     *
     *     projects/{p}/locations/{l}/memberships/{m}
     *
     * Where {p} is the project, {l} is a valid location and {m} is a valid
     * Membership in this project at that location. {p} WILL match the Feature's
     * project.
     *
     * {p} will always be returned as the project number, but the project ID is
     * also accepted during input. If the same Membership is specified in the map
     * twice (using the project ID form, and the project number form), exactly
     * ONE of the entries will be saved, with no guarantees as to which. For this
     * reason, it is recommended the same format be used for all entries when
     * mutating a Feature.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.gkehub.v1beta.MembershipFeatureSpec&gt; membership_specs = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putAllMembershipSpecs(
        java.util.Map<java.lang.String, com.google.cloud.gkehub.v1beta.MembershipFeatureSpec>
            values) {
      internalGetMutableMembershipSpecs().getMutableMap().putAll(values);
      bitField0_ |= 0x00000010;
      return this;
    }

    private com.google.cloud.gkehub.v1beta.CommonFeatureState state_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gkehub.v1beta.CommonFeatureState,
            com.google.cloud.gkehub.v1beta.CommonFeatureState.Builder,
            com.google.cloud.gkehub.v1beta.CommonFeatureStateOrBuilder>
        stateBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The Hub-wide Feature state.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta.CommonFeatureState state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the state field is set.
     */
    public boolean hasState() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The Hub-wide Feature state.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta.CommonFeatureState state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    public com.google.cloud.gkehub.v1beta.CommonFeatureState getState() {
      if (stateBuilder_ == null) {
        return state_ == null
            ? com.google.cloud.gkehub.v1beta.CommonFeatureState.getDefaultInstance()
            : state_;
      } else {
        return stateBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The Hub-wide Feature state.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta.CommonFeatureState state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setState(com.google.cloud.gkehub.v1beta.CommonFeatureState value) {
      if (stateBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        state_ = value;
      } else {
        stateBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Hub-wide Feature state.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta.CommonFeatureState state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setState(
        com.google.cloud.gkehub.v1beta.CommonFeatureState.Builder builderForValue) {
      if (stateBuilder_ == null) {
        state_ = builderForValue.build();
      } else {
        stateBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Hub-wide Feature state.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta.CommonFeatureState state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeState(com.google.cloud.gkehub.v1beta.CommonFeatureState value) {
      if (stateBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && state_ != null
            && state_ != com.google.cloud.gkehub.v1beta.CommonFeatureState.getDefaultInstance()) {
          getStateBuilder().mergeFrom(value);
        } else {
          state_ = value;
        }
      } else {
        stateBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Hub-wide Feature state.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta.CommonFeatureState state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000020);
      state_ = null;
      if (stateBuilder_ != null) {
        stateBuilder_.dispose();
        stateBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Hub-wide Feature state.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta.CommonFeatureState state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.gkehub.v1beta.CommonFeatureState.Builder getStateBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getStateFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The Hub-wide Feature state.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta.CommonFeatureState state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.gkehub.v1beta.CommonFeatureStateOrBuilder getStateOrBuilder() {
      if (stateBuilder_ != null) {
        return stateBuilder_.getMessageOrBuilder();
      } else {
        return state_ == null
            ? com.google.cloud.gkehub.v1beta.CommonFeatureState.getDefaultInstance()
            : state_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The Hub-wide Feature state.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta.CommonFeatureState state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gkehub.v1beta.CommonFeatureState,
            com.google.cloud.gkehub.v1beta.CommonFeatureState.Builder,
            com.google.cloud.gkehub.v1beta.CommonFeatureStateOrBuilder>
        getStateFieldBuilder() {
      if (stateBuilder_ == null) {
        stateBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.gkehub.v1beta.CommonFeatureState,
                com.google.cloud.gkehub.v1beta.CommonFeatureState.Builder,
                com.google.cloud.gkehub.v1beta.CommonFeatureStateOrBuilder>(
                getState(), getParentForChildren(), isClean());
        state_ = null;
      }
      return stateBuilder_;
    }

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.gkehub.v1beta.MembershipFeatureState>
        membershipStates_;

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.gkehub.v1beta.MembershipFeatureState>
        internalGetMembershipStates() {
      if (membershipStates_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            MembershipStatesDefaultEntryHolder.defaultEntry);
      }
      return membershipStates_;
    }

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.gkehub.v1beta.MembershipFeatureState>
        internalGetMutableMembershipStates() {
      if (membershipStates_ == null) {
        membershipStates_ =
            com.google.protobuf.MapField.newMapField(
                MembershipStatesDefaultEntryHolder.defaultEntry);
      }
      if (!membershipStates_.isMutable()) {
        membershipStates_ = membershipStates_.copy();
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return membershipStates_;
    }

    public int getMembershipStatesCount() {
      return internalGetMembershipStates().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Output only. Membership-specific Feature status. If this Feature does
     * report any per-Membership status, this field may be unused.
     *
     * The keys indicate which Membership the state is for, in the form:
     *
     *     projects/{p}/locations/{l}/memberships/{m}
     *
     * Where {p} is the project number, {l} is a valid location and {m} is a valid
     * Membership in this project at that location. {p} MUST match the Feature's
     * project number.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.gkehub.v1beta.MembershipFeatureState&gt; membership_states = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public boolean containsMembershipStates(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetMembershipStates().getMap().containsKey(key);
    }
    /** Use {@link #getMembershipStatesMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.gkehub.v1beta.MembershipFeatureState>
        getMembershipStates() {
      return getMembershipStatesMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. Membership-specific Feature status. If this Feature does
     * report any per-Membership status, this field may be unused.
     *
     * The keys indicate which Membership the state is for, in the form:
     *
     *     projects/{p}/locations/{l}/memberships/{m}
     *
     * Where {p} is the project number, {l} is a valid location and {m} is a valid
     * Membership in this project at that location. {p} MUST match the Feature's
     * project number.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.gkehub.v1beta.MembershipFeatureState&gt; membership_states = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, com.google.cloud.gkehub.v1beta.MembershipFeatureState>
        getMembershipStatesMap() {
      return internalGetMembershipStates().getMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. Membership-specific Feature status. If this Feature does
     * report any per-Membership status, this field may be unused.
     *
     * The keys indicate which Membership the state is for, in the form:
     *
     *     projects/{p}/locations/{l}/memberships/{m}
     *
     * Where {p} is the project number, {l} is a valid location and {m} is a valid
     * Membership in this project at that location. {p} MUST match the Feature's
     * project number.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.gkehub.v1beta.MembershipFeatureState&gt; membership_states = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ com.google.cloud.gkehub.v1beta.MembershipFeatureState
        getMembershipStatesOrDefault(
            java.lang.String key,
            /* nullable */
            com.google.cloud.gkehub.v1beta.MembershipFeatureState defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.gkehub.v1beta.MembershipFeatureState> map =
          internalGetMembershipStates().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Output only. Membership-specific Feature status. If this Feature does
     * report any per-Membership status, this field may be unused.
     *
     * The keys indicate which Membership the state is for, in the form:
     *
     *     projects/{p}/locations/{l}/memberships/{m}
     *
     * Where {p} is the project number, {l} is a valid location and {m} is a valid
     * Membership in this project at that location. {p} MUST match the Feature's
     * project number.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.gkehub.v1beta.MembershipFeatureState&gt; membership_states = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.gkehub.v1beta.MembershipFeatureState getMembershipStatesOrThrow(
        java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.gkehub.v1beta.MembershipFeatureState> map =
          internalGetMembershipStates().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearMembershipStates() {
      bitField0_ = (bitField0_ & ~0x00000040);
      internalGetMutableMembershipStates().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Membership-specific Feature status. If this Feature does
     * report any per-Membership status, this field may be unused.
     *
     * The keys indicate which Membership the state is for, in the form:
     *
     *     projects/{p}/locations/{l}/memberships/{m}
     *
     * Where {p} is the project number, {l} is a valid location and {m} is a valid
     * Membership in this project at that location. {p} MUST match the Feature's
     * project number.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.gkehub.v1beta.MembershipFeatureState&gt; membership_states = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeMembershipStates(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableMembershipStates().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.gkehub.v1beta.MembershipFeatureState>
        getMutableMembershipStates() {
      bitField0_ |= 0x00000040;
      return internalGetMutableMembershipStates().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. Membership-specific Feature status. If this Feature does
     * report any per-Membership status, this field may be unused.
     *
     * The keys indicate which Membership the state is for, in the form:
     *
     *     projects/{p}/locations/{l}/memberships/{m}
     *
     * Where {p} is the project number, {l} is a valid location and {m} is a valid
     * Membership in this project at that location. {p} MUST match the Feature's
     * project number.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.gkehub.v1beta.MembershipFeatureState&gt; membership_states = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder putMembershipStates(
        java.lang.String key, com.google.cloud.gkehub.v1beta.MembershipFeatureState value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableMembershipStates().getMutableMap().put(key, value);
      bitField0_ |= 0x00000040;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Membership-specific Feature status. If this Feature does
     * report any per-Membership status, this field may be unused.
     *
     * The keys indicate which Membership the state is for, in the form:
     *
     *     projects/{p}/locations/{l}/memberships/{m}
     *
     * Where {p} is the project number, {l} is a valid location and {m} is a valid
     * Membership in this project at that location. {p} MUST match the Feature's
     * project number.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.gkehub.v1beta.MembershipFeatureState&gt; membership_states = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder putAllMembershipStates(
        java.util.Map<java.lang.String, com.google.cloud.gkehub.v1beta.MembershipFeatureState>
            values) {
      internalGetMutableMembershipStates().getMutableMap().putAll(values);
      bitField0_ |= 0x00000040;
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. When the Feature resource was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. When the Feature resource was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. When the Feature resource was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. When the Feature resource was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. When the Feature resource was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. When the Feature resource was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000080);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. When the Feature resource was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. When the Feature resource was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. When the Feature resource was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. When the Feature resource was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. When the Feature resource was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. When the Feature resource was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. When the Feature resource was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. When the Feature resource was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. When the Feature resource was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000100);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. When the Feature resource was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. When the Feature resource was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. When the Feature resource was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.protobuf.Timestamp deleteTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        deleteTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. When the Feature resource was deleted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the deleteTime field is set.
     */
    public boolean hasDeleteTime() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. When the Feature resource was deleted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The deleteTime.
     */
    public com.google.protobuf.Timestamp getDeleteTime() {
      if (deleteTimeBuilder_ == null) {
        return deleteTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : deleteTime_;
      } else {
        return deleteTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. When the Feature resource was deleted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDeleteTime(com.google.protobuf.Timestamp value) {
      if (deleteTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        deleteTime_ = value;
      } else {
        deleteTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. When the Feature resource was deleted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDeleteTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (deleteTimeBuilder_ == null) {
        deleteTime_ = builderForValue.build();
      } else {
        deleteTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. When the Feature resource was deleted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeDeleteTime(com.google.protobuf.Timestamp value) {
      if (deleteTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && deleteTime_ != null
            && deleteTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getDeleteTimeBuilder().mergeFrom(value);
        } else {
          deleteTime_ = value;
        }
      } else {
        deleteTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. When the Feature resource was deleted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearDeleteTime() {
      bitField0_ = (bitField0_ & ~0x00000200);
      deleteTime_ = null;
      if (deleteTimeBuilder_ != null) {
        deleteTimeBuilder_.dispose();
        deleteTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. When the Feature resource was deleted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getDeleteTimeBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getDeleteTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. When the Feature resource was deleted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getDeleteTimeOrBuilder() {
      if (deleteTimeBuilder_ != null) {
        return deleteTimeBuilder_.getMessageOrBuilder();
      } else {
        return deleteTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : deleteTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. When the Feature resource was deleted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getDeleteTimeFieldBuilder() {
      if (deleteTimeBuilder_ == null) {
        deleteTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getDeleteTime(), getParentForChildren(), isClean());
        deleteTime_ = null;
      }
      return deleteTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.gkehub.v1beta.Feature)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.gkehub.v1beta.Feature)
  private static final com.google.cloud.gkehub.v1beta.Feature DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.gkehub.v1beta.Feature();
  }

  public static com.google.cloud.gkehub.v1beta.Feature getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Feature> PARSER =
      new com.google.protobuf.AbstractParser<Feature>() {
        @java.lang.Override
        public Feature parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Feature> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Feature> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.gkehub.v1beta.Feature getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
