/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/gkehub/v1beta1/membership.proto

package com.google.cloud.gkehub.v1beta1;

/**
 *
 *
 * <pre>
 * Authority encodes how Google will recognize identities from this Membership.
 * See the workload identity documentation for more details:
 * https://cloud.google.com/kubernetes-engine/docs/how-to/workload-identity
 * </pre>
 *
 * Protobuf type {@code google.cloud.gkehub.v1beta1.Authority}
 */
public final class Authority extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.gkehub.v1beta1.Authority)
    AuthorityOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Authority.newBuilder() to construct.
  private Authority(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Authority() {
    issuer_ = "";
    workloadIdentityPool_ = "";
    identityProvider_ = "";
    oidcJwks_ = com.google.protobuf.ByteString.EMPTY;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Authority();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.gkehub.v1beta1.MembershipOuterClass
        .internal_static_google_cloud_gkehub_v1beta1_Authority_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.gkehub.v1beta1.MembershipOuterClass
        .internal_static_google_cloud_gkehub_v1beta1_Authority_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.gkehub.v1beta1.Authority.class,
            com.google.cloud.gkehub.v1beta1.Authority.Builder.class);
  }

  public static final int ISSUER_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object issuer_ = "";
  /**
   *
   *
   * <pre>
   * Optional. A JSON Web Token (JWT) issuer URI. `issuer` must start with
   * `https://` and be a valid URL with length &lt;2000 characters.
   *
   * If set, then Google will allow valid OIDC tokens from this issuer to
   * authenticate within the workload_identity_pool. OIDC discovery will be
   * performed on this URI to validate tokens from the issuer.
   *
   * Clearing `issuer` disables Workload Identity. `issuer` cannot be directly
   * modified; it must be cleared (and Workload Identity disabled) before using
   * a new issuer (and re-enabling Workload Identity).
   * </pre>
   *
   * <code>string issuer = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The issuer.
   */
  @java.lang.Override
  public java.lang.String getIssuer() {
    java.lang.Object ref = issuer_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      issuer_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. A JSON Web Token (JWT) issuer URI. `issuer` must start with
   * `https://` and be a valid URL with length &lt;2000 characters.
   *
   * If set, then Google will allow valid OIDC tokens from this issuer to
   * authenticate within the workload_identity_pool. OIDC discovery will be
   * performed on this URI to validate tokens from the issuer.
   *
   * Clearing `issuer` disables Workload Identity. `issuer` cannot be directly
   * modified; it must be cleared (and Workload Identity disabled) before using
   * a new issuer (and re-enabling Workload Identity).
   * </pre>
   *
   * <code>string issuer = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for issuer.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIssuerBytes() {
    java.lang.Object ref = issuer_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      issuer_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int WORKLOAD_IDENTITY_POOL_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object workloadIdentityPool_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The name of the workload identity pool in which `issuer` will
   * be recognized.
   *
   * There is a single Workload Identity Pool per Hub that is shared
   * between all Memberships that belong to that Hub. For a Hub hosted in
   * {PROJECT_ID}, the workload pool format is `{PROJECT_ID}.hub.id.goog`,
   * although this is subject to change in newer versions of this API.
   * </pre>
   *
   * <code>string workload_identity_pool = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The workloadIdentityPool.
   */
  @java.lang.Override
  public java.lang.String getWorkloadIdentityPool() {
    java.lang.Object ref = workloadIdentityPool_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      workloadIdentityPool_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The name of the workload identity pool in which `issuer` will
   * be recognized.
   *
   * There is a single Workload Identity Pool per Hub that is shared
   * between all Memberships that belong to that Hub. For a Hub hosted in
   * {PROJECT_ID}, the workload pool format is `{PROJECT_ID}.hub.id.goog`,
   * although this is subject to change in newer versions of this API.
   * </pre>
   *
   * <code>string workload_identity_pool = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for workloadIdentityPool.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getWorkloadIdentityPoolBytes() {
    java.lang.Object ref = workloadIdentityPool_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      workloadIdentityPool_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int IDENTITY_PROVIDER_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object identityProvider_ = "";
  /**
   *
   *
   * <pre>
   * Output only. An identity provider that reflects the `issuer` in the
   * workload identity pool.
   * </pre>
   *
   * <code>string identity_provider = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The identityProvider.
   */
  @java.lang.Override
  public java.lang.String getIdentityProvider() {
    java.lang.Object ref = identityProvider_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      identityProvider_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. An identity provider that reflects the `issuer` in the
   * workload identity pool.
   * </pre>
   *
   * <code>string identity_provider = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for identityProvider.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIdentityProviderBytes() {
    java.lang.Object ref = identityProvider_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      identityProvider_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int OIDC_JWKS_FIELD_NUMBER = 4;
  private com.google.protobuf.ByteString oidcJwks_ = com.google.protobuf.ByteString.EMPTY;
  /**
   *
   *
   * <pre>
   * Optional. OIDC verification keys for this Membership in JWKS format (RFC
   * 7517).
   *
   * When this field is set, OIDC discovery will NOT be performed on `issuer`,
   * and instead OIDC tokens will be validated using this field.
   * </pre>
   *
   * <code>bytes oidc_jwks = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The oidcJwks.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getOidcJwks() {
    return oidcJwks_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(issuer_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, issuer_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(workloadIdentityPool_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, workloadIdentityPool_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(identityProvider_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, identityProvider_);
    }
    if (!oidcJwks_.isEmpty()) {
      output.writeBytes(4, oidcJwks_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(issuer_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, issuer_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(workloadIdentityPool_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, workloadIdentityPool_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(identityProvider_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, identityProvider_);
    }
    if (!oidcJwks_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream.computeBytesSize(4, oidcJwks_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.gkehub.v1beta1.Authority)) {
      return super.equals(obj);
    }
    com.google.cloud.gkehub.v1beta1.Authority other =
        (com.google.cloud.gkehub.v1beta1.Authority) obj;

    if (!getIssuer().equals(other.getIssuer())) return false;
    if (!getWorkloadIdentityPool().equals(other.getWorkloadIdentityPool())) return false;
    if (!getIdentityProvider().equals(other.getIdentityProvider())) return false;
    if (!getOidcJwks().equals(other.getOidcJwks())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ISSUER_FIELD_NUMBER;
    hash = (53 * hash) + getIssuer().hashCode();
    hash = (37 * hash) + WORKLOAD_IDENTITY_POOL_FIELD_NUMBER;
    hash = (53 * hash) + getWorkloadIdentityPool().hashCode();
    hash = (37 * hash) + IDENTITY_PROVIDER_FIELD_NUMBER;
    hash = (53 * hash) + getIdentityProvider().hashCode();
    hash = (37 * hash) + OIDC_JWKS_FIELD_NUMBER;
    hash = (53 * hash) + getOidcJwks().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.gkehub.v1beta1.Authority parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gkehub.v1beta1.Authority parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gkehub.v1beta1.Authority parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gkehub.v1beta1.Authority parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gkehub.v1beta1.Authority parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gkehub.v1beta1.Authority parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gkehub.v1beta1.Authority parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.gkehub.v1beta1.Authority parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.gkehub.v1beta1.Authority parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.gkehub.v1beta1.Authority parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.gkehub.v1beta1.Authority parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.gkehub.v1beta1.Authority parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.gkehub.v1beta1.Authority prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Authority encodes how Google will recognize identities from this Membership.
   * See the workload identity documentation for more details:
   * https://cloud.google.com/kubernetes-engine/docs/how-to/workload-identity
   * </pre>
   *
   * Protobuf type {@code google.cloud.gkehub.v1beta1.Authority}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.gkehub.v1beta1.Authority)
      com.google.cloud.gkehub.v1beta1.AuthorityOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.gkehub.v1beta1.MembershipOuterClass
          .internal_static_google_cloud_gkehub_v1beta1_Authority_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.gkehub.v1beta1.MembershipOuterClass
          .internal_static_google_cloud_gkehub_v1beta1_Authority_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.gkehub.v1beta1.Authority.class,
              com.google.cloud.gkehub.v1beta1.Authority.Builder.class);
    }

    // Construct using com.google.cloud.gkehub.v1beta1.Authority.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      issuer_ = "";
      workloadIdentityPool_ = "";
      identityProvider_ = "";
      oidcJwks_ = com.google.protobuf.ByteString.EMPTY;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.gkehub.v1beta1.MembershipOuterClass
          .internal_static_google_cloud_gkehub_v1beta1_Authority_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.gkehub.v1beta1.Authority getDefaultInstanceForType() {
      return com.google.cloud.gkehub.v1beta1.Authority.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.gkehub.v1beta1.Authority build() {
      com.google.cloud.gkehub.v1beta1.Authority result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.gkehub.v1beta1.Authority buildPartial() {
      com.google.cloud.gkehub.v1beta1.Authority result =
          new com.google.cloud.gkehub.v1beta1.Authority(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.gkehub.v1beta1.Authority result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.issuer_ = issuer_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.workloadIdentityPool_ = workloadIdentityPool_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.identityProvider_ = identityProvider_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.oidcJwks_ = oidcJwks_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.gkehub.v1beta1.Authority) {
        return mergeFrom((com.google.cloud.gkehub.v1beta1.Authority) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.gkehub.v1beta1.Authority other) {
      if (other == com.google.cloud.gkehub.v1beta1.Authority.getDefaultInstance()) return this;
      if (!other.getIssuer().isEmpty()) {
        issuer_ = other.issuer_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getWorkloadIdentityPool().isEmpty()) {
        workloadIdentityPool_ = other.workloadIdentityPool_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getIdentityProvider().isEmpty()) {
        identityProvider_ = other.identityProvider_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.getOidcJwks() != com.google.protobuf.ByteString.EMPTY) {
        setOidcJwks(other.getOidcJwks());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                issuer_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                workloadIdentityPool_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                identityProvider_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                oidcJwks_ = input.readBytes();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object issuer_ = "";
    /**
     *
     *
     * <pre>
     * Optional. A JSON Web Token (JWT) issuer URI. `issuer` must start with
     * `https://` and be a valid URL with length &lt;2000 characters.
     *
     * If set, then Google will allow valid OIDC tokens from this issuer to
     * authenticate within the workload_identity_pool. OIDC discovery will be
     * performed on this URI to validate tokens from the issuer.
     *
     * Clearing `issuer` disables Workload Identity. `issuer` cannot be directly
     * modified; it must be cleared (and Workload Identity disabled) before using
     * a new issuer (and re-enabling Workload Identity).
     * </pre>
     *
     * <code>string issuer = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The issuer.
     */
    public java.lang.String getIssuer() {
      java.lang.Object ref = issuer_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        issuer_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A JSON Web Token (JWT) issuer URI. `issuer` must start with
     * `https://` and be a valid URL with length &lt;2000 characters.
     *
     * If set, then Google will allow valid OIDC tokens from this issuer to
     * authenticate within the workload_identity_pool. OIDC discovery will be
     * performed on this URI to validate tokens from the issuer.
     *
     * Clearing `issuer` disables Workload Identity. `issuer` cannot be directly
     * modified; it must be cleared (and Workload Identity disabled) before using
     * a new issuer (and re-enabling Workload Identity).
     * </pre>
     *
     * <code>string issuer = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for issuer.
     */
    public com.google.protobuf.ByteString getIssuerBytes() {
      java.lang.Object ref = issuer_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        issuer_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A JSON Web Token (JWT) issuer URI. `issuer` must start with
     * `https://` and be a valid URL with length &lt;2000 characters.
     *
     * If set, then Google will allow valid OIDC tokens from this issuer to
     * authenticate within the workload_identity_pool. OIDC discovery will be
     * performed on this URI to validate tokens from the issuer.
     *
     * Clearing `issuer` disables Workload Identity. `issuer` cannot be directly
     * modified; it must be cleared (and Workload Identity disabled) before using
     * a new issuer (and re-enabling Workload Identity).
     * </pre>
     *
     * <code>string issuer = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The issuer to set.
     * @return This builder for chaining.
     */
    public Builder setIssuer(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      issuer_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A JSON Web Token (JWT) issuer URI. `issuer` must start with
     * `https://` and be a valid URL with length &lt;2000 characters.
     *
     * If set, then Google will allow valid OIDC tokens from this issuer to
     * authenticate within the workload_identity_pool. OIDC discovery will be
     * performed on this URI to validate tokens from the issuer.
     *
     * Clearing `issuer` disables Workload Identity. `issuer` cannot be directly
     * modified; it must be cleared (and Workload Identity disabled) before using
     * a new issuer (and re-enabling Workload Identity).
     * </pre>
     *
     * <code>string issuer = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIssuer() {
      issuer_ = getDefaultInstance().getIssuer();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A JSON Web Token (JWT) issuer URI. `issuer` must start with
     * `https://` and be a valid URL with length &lt;2000 characters.
     *
     * If set, then Google will allow valid OIDC tokens from this issuer to
     * authenticate within the workload_identity_pool. OIDC discovery will be
     * performed on this URI to validate tokens from the issuer.
     *
     * Clearing `issuer` disables Workload Identity. `issuer` cannot be directly
     * modified; it must be cleared (and Workload Identity disabled) before using
     * a new issuer (and re-enabling Workload Identity).
     * </pre>
     *
     * <code>string issuer = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for issuer to set.
     * @return This builder for chaining.
     */
    public Builder setIssuerBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      issuer_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object workloadIdentityPool_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The name of the workload identity pool in which `issuer` will
     * be recognized.
     *
     * There is a single Workload Identity Pool per Hub that is shared
     * between all Memberships that belong to that Hub. For a Hub hosted in
     * {PROJECT_ID}, the workload pool format is `{PROJECT_ID}.hub.id.goog`,
     * although this is subject to change in newer versions of this API.
     * </pre>
     *
     * <code>string workload_identity_pool = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The workloadIdentityPool.
     */
    public java.lang.String getWorkloadIdentityPool() {
      java.lang.Object ref = workloadIdentityPool_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        workloadIdentityPool_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the workload identity pool in which `issuer` will
     * be recognized.
     *
     * There is a single Workload Identity Pool per Hub that is shared
     * between all Memberships that belong to that Hub. For a Hub hosted in
     * {PROJECT_ID}, the workload pool format is `{PROJECT_ID}.hub.id.goog`,
     * although this is subject to change in newer versions of this API.
     * </pre>
     *
     * <code>string workload_identity_pool = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for workloadIdentityPool.
     */
    public com.google.protobuf.ByteString getWorkloadIdentityPoolBytes() {
      java.lang.Object ref = workloadIdentityPool_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        workloadIdentityPool_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the workload identity pool in which `issuer` will
     * be recognized.
     *
     * There is a single Workload Identity Pool per Hub that is shared
     * between all Memberships that belong to that Hub. For a Hub hosted in
     * {PROJECT_ID}, the workload pool format is `{PROJECT_ID}.hub.id.goog`,
     * although this is subject to change in newer versions of this API.
     * </pre>
     *
     * <code>string workload_identity_pool = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The workloadIdentityPool to set.
     * @return This builder for chaining.
     */
    public Builder setWorkloadIdentityPool(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      workloadIdentityPool_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the workload identity pool in which `issuer` will
     * be recognized.
     *
     * There is a single Workload Identity Pool per Hub that is shared
     * between all Memberships that belong to that Hub. For a Hub hosted in
     * {PROJECT_ID}, the workload pool format is `{PROJECT_ID}.hub.id.goog`,
     * although this is subject to change in newer versions of this API.
     * </pre>
     *
     * <code>string workload_identity_pool = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearWorkloadIdentityPool() {
      workloadIdentityPool_ = getDefaultInstance().getWorkloadIdentityPool();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the workload identity pool in which `issuer` will
     * be recognized.
     *
     * There is a single Workload Identity Pool per Hub that is shared
     * between all Memberships that belong to that Hub. For a Hub hosted in
     * {PROJECT_ID}, the workload pool format is `{PROJECT_ID}.hub.id.goog`,
     * although this is subject to change in newer versions of this API.
     * </pre>
     *
     * <code>string workload_identity_pool = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for workloadIdentityPool to set.
     * @return This builder for chaining.
     */
    public Builder setWorkloadIdentityPoolBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      workloadIdentityPool_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object identityProvider_ = "";
    /**
     *
     *
     * <pre>
     * Output only. An identity provider that reflects the `issuer` in the
     * workload identity pool.
     * </pre>
     *
     * <code>string identity_provider = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The identityProvider.
     */
    public java.lang.String getIdentityProvider() {
      java.lang.Object ref = identityProvider_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        identityProvider_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. An identity provider that reflects the `issuer` in the
     * workload identity pool.
     * </pre>
     *
     * <code>string identity_provider = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for identityProvider.
     */
    public com.google.protobuf.ByteString getIdentityProviderBytes() {
      java.lang.Object ref = identityProvider_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        identityProvider_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. An identity provider that reflects the `issuer` in the
     * workload identity pool.
     * </pre>
     *
     * <code>string identity_provider = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The identityProvider to set.
     * @return This builder for chaining.
     */
    public Builder setIdentityProvider(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      identityProvider_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. An identity provider that reflects the `issuer` in the
     * workload identity pool.
     * </pre>
     *
     * <code>string identity_provider = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIdentityProvider() {
      identityProvider_ = getDefaultInstance().getIdentityProvider();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. An identity provider that reflects the `issuer` in the
     * workload identity pool.
     * </pre>
     *
     * <code>string identity_provider = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for identityProvider to set.
     * @return This builder for chaining.
     */
    public Builder setIdentityProviderBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      identityProvider_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.ByteString oidcJwks_ = com.google.protobuf.ByteString.EMPTY;
    /**
     *
     *
     * <pre>
     * Optional. OIDC verification keys for this Membership in JWKS format (RFC
     * 7517).
     *
     * When this field is set, OIDC discovery will NOT be performed on `issuer`,
     * and instead OIDC tokens will be validated using this field.
     * </pre>
     *
     * <code>bytes oidc_jwks = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The oidcJwks.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getOidcJwks() {
      return oidcJwks_;
    }
    /**
     *
     *
     * <pre>
     * Optional. OIDC verification keys for this Membership in JWKS format (RFC
     * 7517).
     *
     * When this field is set, OIDC discovery will NOT be performed on `issuer`,
     * and instead OIDC tokens will be validated using this field.
     * </pre>
     *
     * <code>bytes oidc_jwks = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The oidcJwks to set.
     * @return This builder for chaining.
     */
    public Builder setOidcJwks(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      oidcJwks_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. OIDC verification keys for this Membership in JWKS format (RFC
     * 7517).
     *
     * When this field is set, OIDC discovery will NOT be performed on `issuer`,
     * and instead OIDC tokens will be validated using this field.
     * </pre>
     *
     * <code>bytes oidc_jwks = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOidcJwks() {
      bitField0_ = (bitField0_ & ~0x00000008);
      oidcJwks_ = getDefaultInstance().getOidcJwks();
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.gkehub.v1beta1.Authority)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.gkehub.v1beta1.Authority)
  private static final com.google.cloud.gkehub.v1beta1.Authority DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.gkehub.v1beta1.Authority();
  }

  public static com.google.cloud.gkehub.v1beta1.Authority getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Authority> PARSER =
      new com.google.protobuf.AbstractParser<Authority>() {
        @java.lang.Override
        public Authority parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Authority> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Authority> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.gkehub.v1beta1.Authority getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
