/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/gkehub/v1beta1/membership.proto

package com.google.cloud.gkehub.v1beta1;

/**
 *
 *
 * <pre>
 * KubernetesResource contains the YAML manifests and configuration for
 * Membership Kubernetes resources in the cluster. After CreateMembership or
 * UpdateMembership, these resources should be re-applied in the cluster.
 * </pre>
 *
 * Protobuf type {@code google.cloud.gkehub.v1beta1.KubernetesResource}
 */
public final class KubernetesResource extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.gkehub.v1beta1.KubernetesResource)
    KubernetesResourceOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use KubernetesResource.newBuilder() to construct.
  private KubernetesResource(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private KubernetesResource() {
    membershipCrManifest_ = "";
    membershipResources_ = java.util.Collections.emptyList();
    connectResources_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new KubernetesResource();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.gkehub.v1beta1.MembershipOuterClass
        .internal_static_google_cloud_gkehub_v1beta1_KubernetesResource_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.gkehub.v1beta1.MembershipOuterClass
        .internal_static_google_cloud_gkehub_v1beta1_KubernetesResource_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.gkehub.v1beta1.KubernetesResource.class,
            com.google.cloud.gkehub.v1beta1.KubernetesResource.Builder.class);
  }

  public static final int MEMBERSHIP_CR_MANIFEST_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object membershipCrManifest_ = "";
  /**
   *
   *
   * <pre>
   * Input only. The YAML representation of the Membership CR. This field is
   * ignored for GKE clusters where Hub can read the CR directly.
   *
   * Callers should provide the CR that is currently present in the cluster
   * during CreateMembership or UpdateMembership, or leave this field empty if
   * none exists. The CR manifest is used to validate the cluster has not been
   * registered with another Membership.
   * </pre>
   *
   * <code>string membership_cr_manifest = 1 [(.google.api.field_behavior) = INPUT_ONLY];</code>
   *
   * @return The membershipCrManifest.
   */
  @java.lang.Override
  public java.lang.String getMembershipCrManifest() {
    java.lang.Object ref = membershipCrManifest_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      membershipCrManifest_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Input only. The YAML representation of the Membership CR. This field is
   * ignored for GKE clusters where Hub can read the CR directly.
   *
   * Callers should provide the CR that is currently present in the cluster
   * during CreateMembership or UpdateMembership, or leave this field empty if
   * none exists. The CR manifest is used to validate the cluster has not been
   * registered with another Membership.
   * </pre>
   *
   * <code>string membership_cr_manifest = 1 [(.google.api.field_behavior) = INPUT_ONLY];</code>
   *
   * @return The bytes for membershipCrManifest.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMembershipCrManifestBytes() {
    java.lang.Object ref = membershipCrManifest_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      membershipCrManifest_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MEMBERSHIP_RESOURCES_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.gkehub.v1beta1.ResourceManifest> membershipResources_;
  /**
   *
   *
   * <pre>
   * Output only. Additional Kubernetes resources that need to be applied to the
   * cluster after Membership creation, and after every update.
   *
   * This field is only populated in the Membership returned from a successful
   * long-running operation from CreateMembership or UpdateMembership. It is not
   * populated during normal GetMembership or ListMemberships requests. To get
   * the resource manifest after the initial registration, the caller should
   * make a UpdateMembership call with an empty field mask.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.gkehub.v1beta1.ResourceManifest membership_resources = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.gkehub.v1beta1.ResourceManifest>
      getMembershipResourcesList() {
    return membershipResources_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Additional Kubernetes resources that need to be applied to the
   * cluster after Membership creation, and after every update.
   *
   * This field is only populated in the Membership returned from a successful
   * long-running operation from CreateMembership or UpdateMembership. It is not
   * populated during normal GetMembership or ListMemberships requests. To get
   * the resource manifest after the initial registration, the caller should
   * make a UpdateMembership call with an empty field mask.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.gkehub.v1beta1.ResourceManifest membership_resources = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.gkehub.v1beta1.ResourceManifestOrBuilder>
      getMembershipResourcesOrBuilderList() {
    return membershipResources_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Additional Kubernetes resources that need to be applied to the
   * cluster after Membership creation, and after every update.
   *
   * This field is only populated in the Membership returned from a successful
   * long-running operation from CreateMembership or UpdateMembership. It is not
   * populated during normal GetMembership or ListMemberships requests. To get
   * the resource manifest after the initial registration, the caller should
   * make a UpdateMembership call with an empty field mask.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.gkehub.v1beta1.ResourceManifest membership_resources = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getMembershipResourcesCount() {
    return membershipResources_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Additional Kubernetes resources that need to be applied to the
   * cluster after Membership creation, and after every update.
   *
   * This field is only populated in the Membership returned from a successful
   * long-running operation from CreateMembership or UpdateMembership. It is not
   * populated during normal GetMembership or ListMemberships requests. To get
   * the resource manifest after the initial registration, the caller should
   * make a UpdateMembership call with an empty field mask.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.gkehub.v1beta1.ResourceManifest membership_resources = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.gkehub.v1beta1.ResourceManifest getMembershipResources(int index) {
    return membershipResources_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. Additional Kubernetes resources that need to be applied to the
   * cluster after Membership creation, and after every update.
   *
   * This field is only populated in the Membership returned from a successful
   * long-running operation from CreateMembership or UpdateMembership. It is not
   * populated during normal GetMembership or ListMemberships requests. To get
   * the resource manifest after the initial registration, the caller should
   * make a UpdateMembership call with an empty field mask.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.gkehub.v1beta1.ResourceManifest membership_resources = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.gkehub.v1beta1.ResourceManifestOrBuilder getMembershipResourcesOrBuilder(
      int index) {
    return membershipResources_.get(index);
  }

  public static final int CONNECT_RESOURCES_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.gkehub.v1beta1.ResourceManifest> connectResources_;
  /**
   *
   *
   * <pre>
   * Output only. The Kubernetes resources for installing the GKE Connect agent
   *
   * This field is only populated in the Membership returned from a successful
   * long-running operation from CreateMembership or UpdateMembership. It is not
   * populated during normal GetMembership or ListMemberships requests. To get
   * the resource manifest after the initial registration, the caller should
   * make a UpdateMembership call with an empty field mask.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.gkehub.v1beta1.ResourceManifest connect_resources = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.gkehub.v1beta1.ResourceManifest>
      getConnectResourcesList() {
    return connectResources_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The Kubernetes resources for installing the GKE Connect agent
   *
   * This field is only populated in the Membership returned from a successful
   * long-running operation from CreateMembership or UpdateMembership. It is not
   * populated during normal GetMembership or ListMemberships requests. To get
   * the resource manifest after the initial registration, the caller should
   * make a UpdateMembership call with an empty field mask.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.gkehub.v1beta1.ResourceManifest connect_resources = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.gkehub.v1beta1.ResourceManifestOrBuilder>
      getConnectResourcesOrBuilderList() {
    return connectResources_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The Kubernetes resources for installing the GKE Connect agent
   *
   * This field is only populated in the Membership returned from a successful
   * long-running operation from CreateMembership or UpdateMembership. It is not
   * populated during normal GetMembership or ListMemberships requests. To get
   * the resource manifest after the initial registration, the caller should
   * make a UpdateMembership call with an empty field mask.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.gkehub.v1beta1.ResourceManifest connect_resources = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getConnectResourcesCount() {
    return connectResources_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. The Kubernetes resources for installing the GKE Connect agent
   *
   * This field is only populated in the Membership returned from a successful
   * long-running operation from CreateMembership or UpdateMembership. It is not
   * populated during normal GetMembership or ListMemberships requests. To get
   * the resource manifest after the initial registration, the caller should
   * make a UpdateMembership call with an empty field mask.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.gkehub.v1beta1.ResourceManifest connect_resources = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.gkehub.v1beta1.ResourceManifest getConnectResources(int index) {
    return connectResources_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. The Kubernetes resources for installing the GKE Connect agent
   *
   * This field is only populated in the Membership returned from a successful
   * long-running operation from CreateMembership or UpdateMembership. It is not
   * populated during normal GetMembership or ListMemberships requests. To get
   * the resource manifest after the initial registration, the caller should
   * make a UpdateMembership call with an empty field mask.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.gkehub.v1beta1.ResourceManifest connect_resources = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.gkehub.v1beta1.ResourceManifestOrBuilder getConnectResourcesOrBuilder(
      int index) {
    return connectResources_.get(index);
  }

  public static final int RESOURCE_OPTIONS_FIELD_NUMBER = 4;
  private com.google.cloud.gkehub.v1beta1.ResourceOptions resourceOptions_;
  /**
   *
   *
   * <pre>
   * Optional. Options for Kubernetes resource generation.
   * </pre>
   *
   * <code>
   * .google.cloud.gkehub.v1beta1.ResourceOptions resource_options = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the resourceOptions field is set.
   */
  @java.lang.Override
  public boolean hasResourceOptions() {
    return resourceOptions_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. Options for Kubernetes resource generation.
   * </pre>
   *
   * <code>
   * .google.cloud.gkehub.v1beta1.ResourceOptions resource_options = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The resourceOptions.
   */
  @java.lang.Override
  public com.google.cloud.gkehub.v1beta1.ResourceOptions getResourceOptions() {
    return resourceOptions_ == null
        ? com.google.cloud.gkehub.v1beta1.ResourceOptions.getDefaultInstance()
        : resourceOptions_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Options for Kubernetes resource generation.
   * </pre>
   *
   * <code>
   * .google.cloud.gkehub.v1beta1.ResourceOptions resource_options = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.gkehub.v1beta1.ResourceOptionsOrBuilder getResourceOptionsOrBuilder() {
    return resourceOptions_ == null
        ? com.google.cloud.gkehub.v1beta1.ResourceOptions.getDefaultInstance()
        : resourceOptions_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(membershipCrManifest_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, membershipCrManifest_);
    }
    for (int i = 0; i < membershipResources_.size(); i++) {
      output.writeMessage(2, membershipResources_.get(i));
    }
    for (int i = 0; i < connectResources_.size(); i++) {
      output.writeMessage(3, connectResources_.get(i));
    }
    if (resourceOptions_ != null) {
      output.writeMessage(4, getResourceOptions());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(membershipCrManifest_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, membershipCrManifest_);
    }
    for (int i = 0; i < membershipResources_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(2, membershipResources_.get(i));
    }
    for (int i = 0; i < connectResources_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, connectResources_.get(i));
    }
    if (resourceOptions_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getResourceOptions());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.gkehub.v1beta1.KubernetesResource)) {
      return super.equals(obj);
    }
    com.google.cloud.gkehub.v1beta1.KubernetesResource other =
        (com.google.cloud.gkehub.v1beta1.KubernetesResource) obj;

    if (!getMembershipCrManifest().equals(other.getMembershipCrManifest())) return false;
    if (!getMembershipResourcesList().equals(other.getMembershipResourcesList())) return false;
    if (!getConnectResourcesList().equals(other.getConnectResourcesList())) return false;
    if (hasResourceOptions() != other.hasResourceOptions()) return false;
    if (hasResourceOptions()) {
      if (!getResourceOptions().equals(other.getResourceOptions())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + MEMBERSHIP_CR_MANIFEST_FIELD_NUMBER;
    hash = (53 * hash) + getMembershipCrManifest().hashCode();
    if (getMembershipResourcesCount() > 0) {
      hash = (37 * hash) + MEMBERSHIP_RESOURCES_FIELD_NUMBER;
      hash = (53 * hash) + getMembershipResourcesList().hashCode();
    }
    if (getConnectResourcesCount() > 0) {
      hash = (37 * hash) + CONNECT_RESOURCES_FIELD_NUMBER;
      hash = (53 * hash) + getConnectResourcesList().hashCode();
    }
    if (hasResourceOptions()) {
      hash = (37 * hash) + RESOURCE_OPTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getResourceOptions().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.gkehub.v1beta1.KubernetesResource parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gkehub.v1beta1.KubernetesResource parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gkehub.v1beta1.KubernetesResource parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gkehub.v1beta1.KubernetesResource parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gkehub.v1beta1.KubernetesResource parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gkehub.v1beta1.KubernetesResource parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gkehub.v1beta1.KubernetesResource parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.gkehub.v1beta1.KubernetesResource parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.gkehub.v1beta1.KubernetesResource parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.gkehub.v1beta1.KubernetesResource parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.gkehub.v1beta1.KubernetesResource parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.gkehub.v1beta1.KubernetesResource parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.gkehub.v1beta1.KubernetesResource prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * KubernetesResource contains the YAML manifests and configuration for
   * Membership Kubernetes resources in the cluster. After CreateMembership or
   * UpdateMembership, these resources should be re-applied in the cluster.
   * </pre>
   *
   * Protobuf type {@code google.cloud.gkehub.v1beta1.KubernetesResource}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.gkehub.v1beta1.KubernetesResource)
      com.google.cloud.gkehub.v1beta1.KubernetesResourceOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.gkehub.v1beta1.MembershipOuterClass
          .internal_static_google_cloud_gkehub_v1beta1_KubernetesResource_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.gkehub.v1beta1.MembershipOuterClass
          .internal_static_google_cloud_gkehub_v1beta1_KubernetesResource_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.gkehub.v1beta1.KubernetesResource.class,
              com.google.cloud.gkehub.v1beta1.KubernetesResource.Builder.class);
    }

    // Construct using com.google.cloud.gkehub.v1beta1.KubernetesResource.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      membershipCrManifest_ = "";
      if (membershipResourcesBuilder_ == null) {
        membershipResources_ = java.util.Collections.emptyList();
      } else {
        membershipResources_ = null;
        membershipResourcesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      if (connectResourcesBuilder_ == null) {
        connectResources_ = java.util.Collections.emptyList();
      } else {
        connectResources_ = null;
        connectResourcesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      resourceOptions_ = null;
      if (resourceOptionsBuilder_ != null) {
        resourceOptionsBuilder_.dispose();
        resourceOptionsBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.gkehub.v1beta1.MembershipOuterClass
          .internal_static_google_cloud_gkehub_v1beta1_KubernetesResource_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.gkehub.v1beta1.KubernetesResource getDefaultInstanceForType() {
      return com.google.cloud.gkehub.v1beta1.KubernetesResource.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.gkehub.v1beta1.KubernetesResource build() {
      com.google.cloud.gkehub.v1beta1.KubernetesResource result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.gkehub.v1beta1.KubernetesResource buildPartial() {
      com.google.cloud.gkehub.v1beta1.KubernetesResource result =
          new com.google.cloud.gkehub.v1beta1.KubernetesResource(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.gkehub.v1beta1.KubernetesResource result) {
      if (membershipResourcesBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          membershipResources_ = java.util.Collections.unmodifiableList(membershipResources_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.membershipResources_ = membershipResources_;
      } else {
        result.membershipResources_ = membershipResourcesBuilder_.build();
      }
      if (connectResourcesBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          connectResources_ = java.util.Collections.unmodifiableList(connectResources_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.connectResources_ = connectResources_;
      } else {
        result.connectResources_ = connectResourcesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.gkehub.v1beta1.KubernetesResource result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.membershipCrManifest_ = membershipCrManifest_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.resourceOptions_ =
            resourceOptionsBuilder_ == null ? resourceOptions_ : resourceOptionsBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.gkehub.v1beta1.KubernetesResource) {
        return mergeFrom((com.google.cloud.gkehub.v1beta1.KubernetesResource) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.gkehub.v1beta1.KubernetesResource other) {
      if (other == com.google.cloud.gkehub.v1beta1.KubernetesResource.getDefaultInstance())
        return this;
      if (!other.getMembershipCrManifest().isEmpty()) {
        membershipCrManifest_ = other.membershipCrManifest_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (membershipResourcesBuilder_ == null) {
        if (!other.membershipResources_.isEmpty()) {
          if (membershipResources_.isEmpty()) {
            membershipResources_ = other.membershipResources_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureMembershipResourcesIsMutable();
            membershipResources_.addAll(other.membershipResources_);
          }
          onChanged();
        }
      } else {
        if (!other.membershipResources_.isEmpty()) {
          if (membershipResourcesBuilder_.isEmpty()) {
            membershipResourcesBuilder_.dispose();
            membershipResourcesBuilder_ = null;
            membershipResources_ = other.membershipResources_;
            bitField0_ = (bitField0_ & ~0x00000002);
            membershipResourcesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getMembershipResourcesFieldBuilder()
                    : null;
          } else {
            membershipResourcesBuilder_.addAllMessages(other.membershipResources_);
          }
        }
      }
      if (connectResourcesBuilder_ == null) {
        if (!other.connectResources_.isEmpty()) {
          if (connectResources_.isEmpty()) {
            connectResources_ = other.connectResources_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureConnectResourcesIsMutable();
            connectResources_.addAll(other.connectResources_);
          }
          onChanged();
        }
      } else {
        if (!other.connectResources_.isEmpty()) {
          if (connectResourcesBuilder_.isEmpty()) {
            connectResourcesBuilder_.dispose();
            connectResourcesBuilder_ = null;
            connectResources_ = other.connectResources_;
            bitField0_ = (bitField0_ & ~0x00000004);
            connectResourcesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getConnectResourcesFieldBuilder()
                    : null;
          } else {
            connectResourcesBuilder_.addAllMessages(other.connectResources_);
          }
        }
      }
      if (other.hasResourceOptions()) {
        mergeResourceOptions(other.getResourceOptions());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                membershipCrManifest_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.cloud.gkehub.v1beta1.ResourceManifest m =
                    input.readMessage(
                        com.google.cloud.gkehub.v1beta1.ResourceManifest.parser(),
                        extensionRegistry);
                if (membershipResourcesBuilder_ == null) {
                  ensureMembershipResourcesIsMutable();
                  membershipResources_.add(m);
                } else {
                  membershipResourcesBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 26:
              {
                com.google.cloud.gkehub.v1beta1.ResourceManifest m =
                    input.readMessage(
                        com.google.cloud.gkehub.v1beta1.ResourceManifest.parser(),
                        extensionRegistry);
                if (connectResourcesBuilder_ == null) {
                  ensureConnectResourcesIsMutable();
                  connectResources_.add(m);
                } else {
                  connectResourcesBuilder_.addMessage(m);
                }
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getResourceOptionsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object membershipCrManifest_ = "";
    /**
     *
     *
     * <pre>
     * Input only. The YAML representation of the Membership CR. This field is
     * ignored for GKE clusters where Hub can read the CR directly.
     *
     * Callers should provide the CR that is currently present in the cluster
     * during CreateMembership or UpdateMembership, or leave this field empty if
     * none exists. The CR manifest is used to validate the cluster has not been
     * registered with another Membership.
     * </pre>
     *
     * <code>string membership_cr_manifest = 1 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @return The membershipCrManifest.
     */
    public java.lang.String getMembershipCrManifest() {
      java.lang.Object ref = membershipCrManifest_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        membershipCrManifest_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Input only. The YAML representation of the Membership CR. This field is
     * ignored for GKE clusters where Hub can read the CR directly.
     *
     * Callers should provide the CR that is currently present in the cluster
     * during CreateMembership or UpdateMembership, or leave this field empty if
     * none exists. The CR manifest is used to validate the cluster has not been
     * registered with another Membership.
     * </pre>
     *
     * <code>string membership_cr_manifest = 1 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @return The bytes for membershipCrManifest.
     */
    public com.google.protobuf.ByteString getMembershipCrManifestBytes() {
      java.lang.Object ref = membershipCrManifest_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        membershipCrManifest_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Input only. The YAML representation of the Membership CR. This field is
     * ignored for GKE clusters where Hub can read the CR directly.
     *
     * Callers should provide the CR that is currently present in the cluster
     * during CreateMembership or UpdateMembership, or leave this field empty if
     * none exists. The CR manifest is used to validate the cluster has not been
     * registered with another Membership.
     * </pre>
     *
     * <code>string membership_cr_manifest = 1 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @param value The membershipCrManifest to set.
     * @return This builder for chaining.
     */
    public Builder setMembershipCrManifest(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      membershipCrManifest_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. The YAML representation of the Membership CR. This field is
     * ignored for GKE clusters where Hub can read the CR directly.
     *
     * Callers should provide the CR that is currently present in the cluster
     * during CreateMembership or UpdateMembership, or leave this field empty if
     * none exists. The CR manifest is used to validate the cluster has not been
     * registered with another Membership.
     * </pre>
     *
     * <code>string membership_cr_manifest = 1 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMembershipCrManifest() {
      membershipCrManifest_ = getDefaultInstance().getMembershipCrManifest();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. The YAML representation of the Membership CR. This field is
     * ignored for GKE clusters where Hub can read the CR directly.
     *
     * Callers should provide the CR that is currently present in the cluster
     * during CreateMembership or UpdateMembership, or leave this field empty if
     * none exists. The CR manifest is used to validate the cluster has not been
     * registered with another Membership.
     * </pre>
     *
     * <code>string membership_cr_manifest = 1 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @param value The bytes for membershipCrManifest to set.
     * @return This builder for chaining.
     */
    public Builder setMembershipCrManifestBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      membershipCrManifest_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.gkehub.v1beta1.ResourceManifest> membershipResources_ =
        java.util.Collections.emptyList();

    private void ensureMembershipResourcesIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        membershipResources_ =
            new java.util.ArrayList<com.google.cloud.gkehub.v1beta1.ResourceManifest>(
                membershipResources_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.gkehub.v1beta1.ResourceManifest,
            com.google.cloud.gkehub.v1beta1.ResourceManifest.Builder,
            com.google.cloud.gkehub.v1beta1.ResourceManifestOrBuilder>
        membershipResourcesBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Additional Kubernetes resources that need to be applied to the
     * cluster after Membership creation, and after every update.
     *
     * This field is only populated in the Membership returned from a successful
     * long-running operation from CreateMembership or UpdateMembership. It is not
     * populated during normal GetMembership or ListMemberships requests. To get
     * the resource manifest after the initial registration, the caller should
     * make a UpdateMembership call with an empty field mask.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkehub.v1beta1.ResourceManifest membership_resources = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.gkehub.v1beta1.ResourceManifest>
        getMembershipResourcesList() {
      if (membershipResourcesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(membershipResources_);
      } else {
        return membershipResourcesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional Kubernetes resources that need to be applied to the
     * cluster after Membership creation, and after every update.
     *
     * This field is only populated in the Membership returned from a successful
     * long-running operation from CreateMembership or UpdateMembership. It is not
     * populated during normal GetMembership or ListMemberships requests. To get
     * the resource manifest after the initial registration, the caller should
     * make a UpdateMembership call with an empty field mask.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkehub.v1beta1.ResourceManifest membership_resources = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getMembershipResourcesCount() {
      if (membershipResourcesBuilder_ == null) {
        return membershipResources_.size();
      } else {
        return membershipResourcesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional Kubernetes resources that need to be applied to the
     * cluster after Membership creation, and after every update.
     *
     * This field is only populated in the Membership returned from a successful
     * long-running operation from CreateMembership or UpdateMembership. It is not
     * populated during normal GetMembership or ListMemberships requests. To get
     * the resource manifest after the initial registration, the caller should
     * make a UpdateMembership call with an empty field mask.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkehub.v1beta1.ResourceManifest membership_resources = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.gkehub.v1beta1.ResourceManifest getMembershipResources(int index) {
      if (membershipResourcesBuilder_ == null) {
        return membershipResources_.get(index);
      } else {
        return membershipResourcesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional Kubernetes resources that need to be applied to the
     * cluster after Membership creation, and after every update.
     *
     * This field is only populated in the Membership returned from a successful
     * long-running operation from CreateMembership or UpdateMembership. It is not
     * populated during normal GetMembership or ListMemberships requests. To get
     * the resource manifest after the initial registration, the caller should
     * make a UpdateMembership call with an empty field mask.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkehub.v1beta1.ResourceManifest membership_resources = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setMembershipResources(
        int index, com.google.cloud.gkehub.v1beta1.ResourceManifest value) {
      if (membershipResourcesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMembershipResourcesIsMutable();
        membershipResources_.set(index, value);
        onChanged();
      } else {
        membershipResourcesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional Kubernetes resources that need to be applied to the
     * cluster after Membership creation, and after every update.
     *
     * This field is only populated in the Membership returned from a successful
     * long-running operation from CreateMembership or UpdateMembership. It is not
     * populated during normal GetMembership or ListMemberships requests. To get
     * the resource manifest after the initial registration, the caller should
     * make a UpdateMembership call with an empty field mask.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkehub.v1beta1.ResourceManifest membership_resources = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setMembershipResources(
        int index, com.google.cloud.gkehub.v1beta1.ResourceManifest.Builder builderForValue) {
      if (membershipResourcesBuilder_ == null) {
        ensureMembershipResourcesIsMutable();
        membershipResources_.set(index, builderForValue.build());
        onChanged();
      } else {
        membershipResourcesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional Kubernetes resources that need to be applied to the
     * cluster after Membership creation, and after every update.
     *
     * This field is only populated in the Membership returned from a successful
     * long-running operation from CreateMembership or UpdateMembership. It is not
     * populated during normal GetMembership or ListMemberships requests. To get
     * the resource manifest after the initial registration, the caller should
     * make a UpdateMembership call with an empty field mask.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkehub.v1beta1.ResourceManifest membership_resources = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addMembershipResources(com.google.cloud.gkehub.v1beta1.ResourceManifest value) {
      if (membershipResourcesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMembershipResourcesIsMutable();
        membershipResources_.add(value);
        onChanged();
      } else {
        membershipResourcesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional Kubernetes resources that need to be applied to the
     * cluster after Membership creation, and after every update.
     *
     * This field is only populated in the Membership returned from a successful
     * long-running operation from CreateMembership or UpdateMembership. It is not
     * populated during normal GetMembership or ListMemberships requests. To get
     * the resource manifest after the initial registration, the caller should
     * make a UpdateMembership call with an empty field mask.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkehub.v1beta1.ResourceManifest membership_resources = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addMembershipResources(
        int index, com.google.cloud.gkehub.v1beta1.ResourceManifest value) {
      if (membershipResourcesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMembershipResourcesIsMutable();
        membershipResources_.add(index, value);
        onChanged();
      } else {
        membershipResourcesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional Kubernetes resources that need to be applied to the
     * cluster after Membership creation, and after every update.
     *
     * This field is only populated in the Membership returned from a successful
     * long-running operation from CreateMembership or UpdateMembership. It is not
     * populated during normal GetMembership or ListMemberships requests. To get
     * the resource manifest after the initial registration, the caller should
     * make a UpdateMembership call with an empty field mask.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkehub.v1beta1.ResourceManifest membership_resources = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addMembershipResources(
        com.google.cloud.gkehub.v1beta1.ResourceManifest.Builder builderForValue) {
      if (membershipResourcesBuilder_ == null) {
        ensureMembershipResourcesIsMutable();
        membershipResources_.add(builderForValue.build());
        onChanged();
      } else {
        membershipResourcesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional Kubernetes resources that need to be applied to the
     * cluster after Membership creation, and after every update.
     *
     * This field is only populated in the Membership returned from a successful
     * long-running operation from CreateMembership or UpdateMembership. It is not
     * populated during normal GetMembership or ListMemberships requests. To get
     * the resource manifest after the initial registration, the caller should
     * make a UpdateMembership call with an empty field mask.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkehub.v1beta1.ResourceManifest membership_resources = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addMembershipResources(
        int index, com.google.cloud.gkehub.v1beta1.ResourceManifest.Builder builderForValue) {
      if (membershipResourcesBuilder_ == null) {
        ensureMembershipResourcesIsMutable();
        membershipResources_.add(index, builderForValue.build());
        onChanged();
      } else {
        membershipResourcesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional Kubernetes resources that need to be applied to the
     * cluster after Membership creation, and after every update.
     *
     * This field is only populated in the Membership returned from a successful
     * long-running operation from CreateMembership or UpdateMembership. It is not
     * populated during normal GetMembership or ListMemberships requests. To get
     * the resource manifest after the initial registration, the caller should
     * make a UpdateMembership call with an empty field mask.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkehub.v1beta1.ResourceManifest membership_resources = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllMembershipResources(
        java.lang.Iterable<? extends com.google.cloud.gkehub.v1beta1.ResourceManifest> values) {
      if (membershipResourcesBuilder_ == null) {
        ensureMembershipResourcesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, membershipResources_);
        onChanged();
      } else {
        membershipResourcesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional Kubernetes resources that need to be applied to the
     * cluster after Membership creation, and after every update.
     *
     * This field is only populated in the Membership returned from a successful
     * long-running operation from CreateMembership or UpdateMembership. It is not
     * populated during normal GetMembership or ListMemberships requests. To get
     * the resource manifest after the initial registration, the caller should
     * make a UpdateMembership call with an empty field mask.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkehub.v1beta1.ResourceManifest membership_resources = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearMembershipResources() {
      if (membershipResourcesBuilder_ == null) {
        membershipResources_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        membershipResourcesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional Kubernetes resources that need to be applied to the
     * cluster after Membership creation, and after every update.
     *
     * This field is only populated in the Membership returned from a successful
     * long-running operation from CreateMembership or UpdateMembership. It is not
     * populated during normal GetMembership or ListMemberships requests. To get
     * the resource manifest after the initial registration, the caller should
     * make a UpdateMembership call with an empty field mask.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkehub.v1beta1.ResourceManifest membership_resources = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeMembershipResources(int index) {
      if (membershipResourcesBuilder_ == null) {
        ensureMembershipResourcesIsMutable();
        membershipResources_.remove(index);
        onChanged();
      } else {
        membershipResourcesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional Kubernetes resources that need to be applied to the
     * cluster after Membership creation, and after every update.
     *
     * This field is only populated in the Membership returned from a successful
     * long-running operation from CreateMembership or UpdateMembership. It is not
     * populated during normal GetMembership or ListMemberships requests. To get
     * the resource manifest after the initial registration, the caller should
     * make a UpdateMembership call with an empty field mask.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkehub.v1beta1.ResourceManifest membership_resources = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.gkehub.v1beta1.ResourceManifest.Builder getMembershipResourcesBuilder(
        int index) {
      return getMembershipResourcesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional Kubernetes resources that need to be applied to the
     * cluster after Membership creation, and after every update.
     *
     * This field is only populated in the Membership returned from a successful
     * long-running operation from CreateMembership or UpdateMembership. It is not
     * populated during normal GetMembership or ListMemberships requests. To get
     * the resource manifest after the initial registration, the caller should
     * make a UpdateMembership call with an empty field mask.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkehub.v1beta1.ResourceManifest membership_resources = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.gkehub.v1beta1.ResourceManifestOrBuilder
        getMembershipResourcesOrBuilder(int index) {
      if (membershipResourcesBuilder_ == null) {
        return membershipResources_.get(index);
      } else {
        return membershipResourcesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional Kubernetes resources that need to be applied to the
     * cluster after Membership creation, and after every update.
     *
     * This field is only populated in the Membership returned from a successful
     * long-running operation from CreateMembership or UpdateMembership. It is not
     * populated during normal GetMembership or ListMemberships requests. To get
     * the resource manifest after the initial registration, the caller should
     * make a UpdateMembership call with an empty field mask.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkehub.v1beta1.ResourceManifest membership_resources = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.gkehub.v1beta1.ResourceManifestOrBuilder>
        getMembershipResourcesOrBuilderList() {
      if (membershipResourcesBuilder_ != null) {
        return membershipResourcesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(membershipResources_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional Kubernetes resources that need to be applied to the
     * cluster after Membership creation, and after every update.
     *
     * This field is only populated in the Membership returned from a successful
     * long-running operation from CreateMembership or UpdateMembership. It is not
     * populated during normal GetMembership or ListMemberships requests. To get
     * the resource manifest after the initial registration, the caller should
     * make a UpdateMembership call with an empty field mask.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkehub.v1beta1.ResourceManifest membership_resources = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.gkehub.v1beta1.ResourceManifest.Builder
        addMembershipResourcesBuilder() {
      return getMembershipResourcesFieldBuilder()
          .addBuilder(com.google.cloud.gkehub.v1beta1.ResourceManifest.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional Kubernetes resources that need to be applied to the
     * cluster after Membership creation, and after every update.
     *
     * This field is only populated in the Membership returned from a successful
     * long-running operation from CreateMembership or UpdateMembership. It is not
     * populated during normal GetMembership or ListMemberships requests. To get
     * the resource manifest after the initial registration, the caller should
     * make a UpdateMembership call with an empty field mask.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkehub.v1beta1.ResourceManifest membership_resources = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.gkehub.v1beta1.ResourceManifest.Builder addMembershipResourcesBuilder(
        int index) {
      return getMembershipResourcesFieldBuilder()
          .addBuilder(index, com.google.cloud.gkehub.v1beta1.ResourceManifest.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional Kubernetes resources that need to be applied to the
     * cluster after Membership creation, and after every update.
     *
     * This field is only populated in the Membership returned from a successful
     * long-running operation from CreateMembership or UpdateMembership. It is not
     * populated during normal GetMembership or ListMemberships requests. To get
     * the resource manifest after the initial registration, the caller should
     * make a UpdateMembership call with an empty field mask.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkehub.v1beta1.ResourceManifest membership_resources = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.gkehub.v1beta1.ResourceManifest.Builder>
        getMembershipResourcesBuilderList() {
      return getMembershipResourcesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.gkehub.v1beta1.ResourceManifest,
            com.google.cloud.gkehub.v1beta1.ResourceManifest.Builder,
            com.google.cloud.gkehub.v1beta1.ResourceManifestOrBuilder>
        getMembershipResourcesFieldBuilder() {
      if (membershipResourcesBuilder_ == null) {
        membershipResourcesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.gkehub.v1beta1.ResourceManifest,
                com.google.cloud.gkehub.v1beta1.ResourceManifest.Builder,
                com.google.cloud.gkehub.v1beta1.ResourceManifestOrBuilder>(
                membershipResources_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        membershipResources_ = null;
      }
      return membershipResourcesBuilder_;
    }

    private java.util.List<com.google.cloud.gkehub.v1beta1.ResourceManifest> connectResources_ =
        java.util.Collections.emptyList();

    private void ensureConnectResourcesIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        connectResources_ =
            new java.util.ArrayList<com.google.cloud.gkehub.v1beta1.ResourceManifest>(
                connectResources_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.gkehub.v1beta1.ResourceManifest,
            com.google.cloud.gkehub.v1beta1.ResourceManifest.Builder,
            com.google.cloud.gkehub.v1beta1.ResourceManifestOrBuilder>
        connectResourcesBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The Kubernetes resources for installing the GKE Connect agent
     *
     * This field is only populated in the Membership returned from a successful
     * long-running operation from CreateMembership or UpdateMembership. It is not
     * populated during normal GetMembership or ListMemberships requests. To get
     * the resource manifest after the initial registration, the caller should
     * make a UpdateMembership call with an empty field mask.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkehub.v1beta1.ResourceManifest connect_resources = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.gkehub.v1beta1.ResourceManifest>
        getConnectResourcesList() {
      if (connectResourcesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(connectResources_);
      } else {
        return connectResourcesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The Kubernetes resources for installing the GKE Connect agent
     *
     * This field is only populated in the Membership returned from a successful
     * long-running operation from CreateMembership or UpdateMembership. It is not
     * populated during normal GetMembership or ListMemberships requests. To get
     * the resource manifest after the initial registration, the caller should
     * make a UpdateMembership call with an empty field mask.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkehub.v1beta1.ResourceManifest connect_resources = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getConnectResourcesCount() {
      if (connectResourcesBuilder_ == null) {
        return connectResources_.size();
      } else {
        return connectResourcesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The Kubernetes resources for installing the GKE Connect agent
     *
     * This field is only populated in the Membership returned from a successful
     * long-running operation from CreateMembership or UpdateMembership. It is not
     * populated during normal GetMembership or ListMemberships requests. To get
     * the resource manifest after the initial registration, the caller should
     * make a UpdateMembership call with an empty field mask.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkehub.v1beta1.ResourceManifest connect_resources = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.gkehub.v1beta1.ResourceManifest getConnectResources(int index) {
      if (connectResourcesBuilder_ == null) {
        return connectResources_.get(index);
      } else {
        return connectResourcesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The Kubernetes resources for installing the GKE Connect agent
     *
     * This field is only populated in the Membership returned from a successful
     * long-running operation from CreateMembership or UpdateMembership. It is not
     * populated during normal GetMembership or ListMemberships requests. To get
     * the resource manifest after the initial registration, the caller should
     * make a UpdateMembership call with an empty field mask.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkehub.v1beta1.ResourceManifest connect_resources = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setConnectResources(
        int index, com.google.cloud.gkehub.v1beta1.ResourceManifest value) {
      if (connectResourcesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConnectResourcesIsMutable();
        connectResources_.set(index, value);
        onChanged();
      } else {
        connectResourcesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Kubernetes resources for installing the GKE Connect agent
     *
     * This field is only populated in the Membership returned from a successful
     * long-running operation from CreateMembership or UpdateMembership. It is not
     * populated during normal GetMembership or ListMemberships requests. To get
     * the resource manifest after the initial registration, the caller should
     * make a UpdateMembership call with an empty field mask.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkehub.v1beta1.ResourceManifest connect_resources = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setConnectResources(
        int index, com.google.cloud.gkehub.v1beta1.ResourceManifest.Builder builderForValue) {
      if (connectResourcesBuilder_ == null) {
        ensureConnectResourcesIsMutable();
        connectResources_.set(index, builderForValue.build());
        onChanged();
      } else {
        connectResourcesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Kubernetes resources for installing the GKE Connect agent
     *
     * This field is only populated in the Membership returned from a successful
     * long-running operation from CreateMembership or UpdateMembership. It is not
     * populated during normal GetMembership or ListMemberships requests. To get
     * the resource manifest after the initial registration, the caller should
     * make a UpdateMembership call with an empty field mask.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkehub.v1beta1.ResourceManifest connect_resources = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addConnectResources(com.google.cloud.gkehub.v1beta1.ResourceManifest value) {
      if (connectResourcesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConnectResourcesIsMutable();
        connectResources_.add(value);
        onChanged();
      } else {
        connectResourcesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Kubernetes resources for installing the GKE Connect agent
     *
     * This field is only populated in the Membership returned from a successful
     * long-running operation from CreateMembership or UpdateMembership. It is not
     * populated during normal GetMembership or ListMemberships requests. To get
     * the resource manifest after the initial registration, the caller should
     * make a UpdateMembership call with an empty field mask.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkehub.v1beta1.ResourceManifest connect_resources = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addConnectResources(
        int index, com.google.cloud.gkehub.v1beta1.ResourceManifest value) {
      if (connectResourcesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConnectResourcesIsMutable();
        connectResources_.add(index, value);
        onChanged();
      } else {
        connectResourcesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Kubernetes resources for installing the GKE Connect agent
     *
     * This field is only populated in the Membership returned from a successful
     * long-running operation from CreateMembership or UpdateMembership. It is not
     * populated during normal GetMembership or ListMemberships requests. To get
     * the resource manifest after the initial registration, the caller should
     * make a UpdateMembership call with an empty field mask.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkehub.v1beta1.ResourceManifest connect_resources = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addConnectResources(
        com.google.cloud.gkehub.v1beta1.ResourceManifest.Builder builderForValue) {
      if (connectResourcesBuilder_ == null) {
        ensureConnectResourcesIsMutable();
        connectResources_.add(builderForValue.build());
        onChanged();
      } else {
        connectResourcesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Kubernetes resources for installing the GKE Connect agent
     *
     * This field is only populated in the Membership returned from a successful
     * long-running operation from CreateMembership or UpdateMembership. It is not
     * populated during normal GetMembership or ListMemberships requests. To get
     * the resource manifest after the initial registration, the caller should
     * make a UpdateMembership call with an empty field mask.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkehub.v1beta1.ResourceManifest connect_resources = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addConnectResources(
        int index, com.google.cloud.gkehub.v1beta1.ResourceManifest.Builder builderForValue) {
      if (connectResourcesBuilder_ == null) {
        ensureConnectResourcesIsMutable();
        connectResources_.add(index, builderForValue.build());
        onChanged();
      } else {
        connectResourcesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Kubernetes resources for installing the GKE Connect agent
     *
     * This field is only populated in the Membership returned from a successful
     * long-running operation from CreateMembership or UpdateMembership. It is not
     * populated during normal GetMembership or ListMemberships requests. To get
     * the resource manifest after the initial registration, the caller should
     * make a UpdateMembership call with an empty field mask.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkehub.v1beta1.ResourceManifest connect_resources = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllConnectResources(
        java.lang.Iterable<? extends com.google.cloud.gkehub.v1beta1.ResourceManifest> values) {
      if (connectResourcesBuilder_ == null) {
        ensureConnectResourcesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, connectResources_);
        onChanged();
      } else {
        connectResourcesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Kubernetes resources for installing the GKE Connect agent
     *
     * This field is only populated in the Membership returned from a successful
     * long-running operation from CreateMembership or UpdateMembership. It is not
     * populated during normal GetMembership or ListMemberships requests. To get
     * the resource manifest after the initial registration, the caller should
     * make a UpdateMembership call with an empty field mask.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkehub.v1beta1.ResourceManifest connect_resources = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearConnectResources() {
      if (connectResourcesBuilder_ == null) {
        connectResources_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        connectResourcesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Kubernetes resources for installing the GKE Connect agent
     *
     * This field is only populated in the Membership returned from a successful
     * long-running operation from CreateMembership or UpdateMembership. It is not
     * populated during normal GetMembership or ListMemberships requests. To get
     * the resource manifest after the initial registration, the caller should
     * make a UpdateMembership call with an empty field mask.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkehub.v1beta1.ResourceManifest connect_resources = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeConnectResources(int index) {
      if (connectResourcesBuilder_ == null) {
        ensureConnectResourcesIsMutable();
        connectResources_.remove(index);
        onChanged();
      } else {
        connectResourcesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Kubernetes resources for installing the GKE Connect agent
     *
     * This field is only populated in the Membership returned from a successful
     * long-running operation from CreateMembership or UpdateMembership. It is not
     * populated during normal GetMembership or ListMemberships requests. To get
     * the resource manifest after the initial registration, the caller should
     * make a UpdateMembership call with an empty field mask.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkehub.v1beta1.ResourceManifest connect_resources = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.gkehub.v1beta1.ResourceManifest.Builder getConnectResourcesBuilder(
        int index) {
      return getConnectResourcesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The Kubernetes resources for installing the GKE Connect agent
     *
     * This field is only populated in the Membership returned from a successful
     * long-running operation from CreateMembership or UpdateMembership. It is not
     * populated during normal GetMembership or ListMemberships requests. To get
     * the resource manifest after the initial registration, the caller should
     * make a UpdateMembership call with an empty field mask.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkehub.v1beta1.ResourceManifest connect_resources = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.gkehub.v1beta1.ResourceManifestOrBuilder getConnectResourcesOrBuilder(
        int index) {
      if (connectResourcesBuilder_ == null) {
        return connectResources_.get(index);
      } else {
        return connectResourcesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The Kubernetes resources for installing the GKE Connect agent
     *
     * This field is only populated in the Membership returned from a successful
     * long-running operation from CreateMembership or UpdateMembership. It is not
     * populated during normal GetMembership or ListMemberships requests. To get
     * the resource manifest after the initial registration, the caller should
     * make a UpdateMembership call with an empty field mask.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkehub.v1beta1.ResourceManifest connect_resources = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.gkehub.v1beta1.ResourceManifestOrBuilder>
        getConnectResourcesOrBuilderList() {
      if (connectResourcesBuilder_ != null) {
        return connectResourcesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(connectResources_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The Kubernetes resources for installing the GKE Connect agent
     *
     * This field is only populated in the Membership returned from a successful
     * long-running operation from CreateMembership or UpdateMembership. It is not
     * populated during normal GetMembership or ListMemberships requests. To get
     * the resource manifest after the initial registration, the caller should
     * make a UpdateMembership call with an empty field mask.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkehub.v1beta1.ResourceManifest connect_resources = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.gkehub.v1beta1.ResourceManifest.Builder addConnectResourcesBuilder() {
      return getConnectResourcesFieldBuilder()
          .addBuilder(com.google.cloud.gkehub.v1beta1.ResourceManifest.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. The Kubernetes resources for installing the GKE Connect agent
     *
     * This field is only populated in the Membership returned from a successful
     * long-running operation from CreateMembership or UpdateMembership. It is not
     * populated during normal GetMembership or ListMemberships requests. To get
     * the resource manifest after the initial registration, the caller should
     * make a UpdateMembership call with an empty field mask.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkehub.v1beta1.ResourceManifest connect_resources = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.gkehub.v1beta1.ResourceManifest.Builder addConnectResourcesBuilder(
        int index) {
      return getConnectResourcesFieldBuilder()
          .addBuilder(index, com.google.cloud.gkehub.v1beta1.ResourceManifest.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. The Kubernetes resources for installing the GKE Connect agent
     *
     * This field is only populated in the Membership returned from a successful
     * long-running operation from CreateMembership or UpdateMembership. It is not
     * populated during normal GetMembership or ListMemberships requests. To get
     * the resource manifest after the initial registration, the caller should
     * make a UpdateMembership call with an empty field mask.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.gkehub.v1beta1.ResourceManifest connect_resources = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.gkehub.v1beta1.ResourceManifest.Builder>
        getConnectResourcesBuilderList() {
      return getConnectResourcesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.gkehub.v1beta1.ResourceManifest,
            com.google.cloud.gkehub.v1beta1.ResourceManifest.Builder,
            com.google.cloud.gkehub.v1beta1.ResourceManifestOrBuilder>
        getConnectResourcesFieldBuilder() {
      if (connectResourcesBuilder_ == null) {
        connectResourcesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.gkehub.v1beta1.ResourceManifest,
                com.google.cloud.gkehub.v1beta1.ResourceManifest.Builder,
                com.google.cloud.gkehub.v1beta1.ResourceManifestOrBuilder>(
                connectResources_,
                ((bitField0_ & 0x00000004) != 0),
                getParentForChildren(),
                isClean());
        connectResources_ = null;
      }
      return connectResourcesBuilder_;
    }

    private com.google.cloud.gkehub.v1beta1.ResourceOptions resourceOptions_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gkehub.v1beta1.ResourceOptions,
            com.google.cloud.gkehub.v1beta1.ResourceOptions.Builder,
            com.google.cloud.gkehub.v1beta1.ResourceOptionsOrBuilder>
        resourceOptionsBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Options for Kubernetes resource generation.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.ResourceOptions resource_options = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the resourceOptions field is set.
     */
    public boolean hasResourceOptions() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Options for Kubernetes resource generation.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.ResourceOptions resource_options = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The resourceOptions.
     */
    public com.google.cloud.gkehub.v1beta1.ResourceOptions getResourceOptions() {
      if (resourceOptionsBuilder_ == null) {
        return resourceOptions_ == null
            ? com.google.cloud.gkehub.v1beta1.ResourceOptions.getDefaultInstance()
            : resourceOptions_;
      } else {
        return resourceOptionsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Options for Kubernetes resource generation.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.ResourceOptions resource_options = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setResourceOptions(com.google.cloud.gkehub.v1beta1.ResourceOptions value) {
      if (resourceOptionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        resourceOptions_ = value;
      } else {
        resourceOptionsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Options for Kubernetes resource generation.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.ResourceOptions resource_options = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setResourceOptions(
        com.google.cloud.gkehub.v1beta1.ResourceOptions.Builder builderForValue) {
      if (resourceOptionsBuilder_ == null) {
        resourceOptions_ = builderForValue.build();
      } else {
        resourceOptionsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Options for Kubernetes resource generation.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.ResourceOptions resource_options = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeResourceOptions(com.google.cloud.gkehub.v1beta1.ResourceOptions value) {
      if (resourceOptionsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && resourceOptions_ != null
            && resourceOptions_
                != com.google.cloud.gkehub.v1beta1.ResourceOptions.getDefaultInstance()) {
          getResourceOptionsBuilder().mergeFrom(value);
        } else {
          resourceOptions_ = value;
        }
      } else {
        resourceOptionsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Options for Kubernetes resource generation.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.ResourceOptions resource_options = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearResourceOptions() {
      bitField0_ = (bitField0_ & ~0x00000008);
      resourceOptions_ = null;
      if (resourceOptionsBuilder_ != null) {
        resourceOptionsBuilder_.dispose();
        resourceOptionsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Options for Kubernetes resource generation.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.ResourceOptions resource_options = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.gkehub.v1beta1.ResourceOptions.Builder getResourceOptionsBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getResourceOptionsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Options for Kubernetes resource generation.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.ResourceOptions resource_options = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.gkehub.v1beta1.ResourceOptionsOrBuilder getResourceOptionsOrBuilder() {
      if (resourceOptionsBuilder_ != null) {
        return resourceOptionsBuilder_.getMessageOrBuilder();
      } else {
        return resourceOptions_ == null
            ? com.google.cloud.gkehub.v1beta1.ResourceOptions.getDefaultInstance()
            : resourceOptions_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Options for Kubernetes resource generation.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.ResourceOptions resource_options = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gkehub.v1beta1.ResourceOptions,
            com.google.cloud.gkehub.v1beta1.ResourceOptions.Builder,
            com.google.cloud.gkehub.v1beta1.ResourceOptionsOrBuilder>
        getResourceOptionsFieldBuilder() {
      if (resourceOptionsBuilder_ == null) {
        resourceOptionsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.gkehub.v1beta1.ResourceOptions,
                com.google.cloud.gkehub.v1beta1.ResourceOptions.Builder,
                com.google.cloud.gkehub.v1beta1.ResourceOptionsOrBuilder>(
                getResourceOptions(), getParentForChildren(), isClean());
        resourceOptions_ = null;
      }
      return resourceOptionsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.gkehub.v1beta1.KubernetesResource)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.gkehub.v1beta1.KubernetesResource)
  private static final com.google.cloud.gkehub.v1beta1.KubernetesResource DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.gkehub.v1beta1.KubernetesResource();
  }

  public static com.google.cloud.gkehub.v1beta1.KubernetesResource getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<KubernetesResource> PARSER =
      new com.google.protobuf.AbstractParser<KubernetesResource>() {
        @java.lang.Override
        public KubernetesResource parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<KubernetesResource> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<KubernetesResource> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.gkehub.v1beta1.KubernetesResource getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
