/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/gkehub/v1beta1/membership.proto

package com.google.cloud.gkehub.v1beta1;

/**
 *
 *
 * <pre>
 * Membership contains information about a member cluster.
 * </pre>
 *
 * Protobuf type {@code google.cloud.gkehub.v1beta1.Membership}
 */
public final class Membership extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.gkehub.v1beta1.Membership)
    MembershipOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Membership.newBuilder() to construct.
  private Membership(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Membership() {
    name_ = "";
    description_ = "";
    externalId_ = "";
    uniqueId_ = "";
    infrastructureType_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Membership();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.gkehub.v1beta1.MembershipOuterClass
        .internal_static_google_cloud_gkehub_v1beta1_Membership_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 2:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.gkehub.v1beta1.MembershipOuterClass
        .internal_static_google_cloud_gkehub_v1beta1_Membership_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.gkehub.v1beta1.Membership.class,
            com.google.cloud.gkehub.v1beta1.Membership.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Specifies the infrastructure type of a Membership. Infrastructure type is
   * used by Hub to control infrastructure-specific behavior, including pricing.
   *
   * Each GKE distribution (on-GCP, on-Prem, on-X,...) will set this field
   * automatically, but Attached Clusters customers should specify a type
   * during registration.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.gkehub.v1beta1.Membership.InfrastructureType}
   */
  public enum InfrastructureType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * No type was specified. Some Hub functionality may require a type be
     * specified, and will not support Memberships with this value.
     * </pre>
     *
     * <code>INFRASTRUCTURE_TYPE_UNSPECIFIED = 0;</code>
     */
    INFRASTRUCTURE_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Private infrastructure that is owned or operated by customer. This
     * includes GKE distributions such as GKE-OnPrem and GKE-OnBareMetal.
     * </pre>
     *
     * <code>ON_PREM = 1;</code>
     */
    ON_PREM(1),
    /**
     *
     *
     * <pre>
     * Public cloud infrastructure.
     * </pre>
     *
     * <code>MULTI_CLOUD = 2;</code>
     */
    MULTI_CLOUD(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * No type was specified. Some Hub functionality may require a type be
     * specified, and will not support Memberships with this value.
     * </pre>
     *
     * <code>INFRASTRUCTURE_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int INFRASTRUCTURE_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Private infrastructure that is owned or operated by customer. This
     * includes GKE distributions such as GKE-OnPrem and GKE-OnBareMetal.
     * </pre>
     *
     * <code>ON_PREM = 1;</code>
     */
    public static final int ON_PREM_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Public cloud infrastructure.
     * </pre>
     *
     * <code>MULTI_CLOUD = 2;</code>
     */
    public static final int MULTI_CLOUD_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static InfrastructureType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static InfrastructureType forNumber(int value) {
      switch (value) {
        case 0:
          return INFRASTRUCTURE_TYPE_UNSPECIFIED;
        case 1:
          return ON_PREM;
        case 2:
          return MULTI_CLOUD;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<InfrastructureType>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<InfrastructureType>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<InfrastructureType>() {
              public InfrastructureType findValueByNumber(int number) {
                return InfrastructureType.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.gkehub.v1beta1.Membership.getDescriptor().getEnumTypes().get(0);
    }

    private static final InfrastructureType[] VALUES = values();

    public static InfrastructureType valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private InfrastructureType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.gkehub.v1beta1.Membership.InfrastructureType)
  }

  private int typeCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object type_;

  public enum TypeCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    ENDPOINT(4),
    TYPE_NOT_SET(0);
    private final int value;

    private TypeCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TypeCase valueOf(int value) {
      return forNumber(value);
    }

    public static TypeCase forNumber(int value) {
      switch (value) {
        case 4:
          return ENDPOINT;
        case 0:
          return TYPE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public TypeCase getTypeCase() {
    return TypeCase.forNumber(typeCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The full, unique name of this Membership resource in the
   * format `projects/&#42;&#47;locations/&#42;&#47;memberships/{membership_id}`, set during
   * creation.
   *
   * `membership_id` must be a valid RFC 1123 compliant DNS label:
   *
   *   1. At most 63 characters in length
   *   2. It must consist of lower case alphanumeric characters or `-`
   *   3. It must start and end with an alphanumeric character
   *
   * Which can be expressed as the regex: `[a-z0-9]([-a-z0-9]*[a-z0-9])?`,
   * with a maximum length of 63 characters.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The full, unique name of this Membership resource in the
   * format `projects/&#42;&#47;locations/&#42;&#47;memberships/{membership_id}`, set during
   * creation.
   *
   * `membership_id` must be a valid RFC 1123 compliant DNS label:
   *
   *   1. At most 63 characters in length
   *   2. It must consist of lower case alphanumeric characters or `-`
   *   3. It must start and end with an alphanumeric character
   *
   * Which can be expressed as the regex: `[a-z0-9]([-a-z0-9]*[a-z0-9])?`,
   * with a maximum length of 63 characters.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LABELS_FIELD_NUMBER = 2;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.gkehub.v1beta1.MembershipOuterClass
                .internal_static_google_cloud_gkehub_v1beta1_Membership_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Optional. GCP labels for this membership.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. GCP labels for this membership.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. GCP labels for this membership.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Optional. GCP labels for this membership.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * Optional. Description of this membership, limited to 63 characters.
   * Must match the regex: `[a-zA-Z0-9][a-zA-Z0-9_&#92;-&#92;.&#92; ]*`
   * </pre>
   *
   * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Description of this membership, limited to 63 characters.
   * Must match the regex: `[a-zA-Z0-9][a-zA-Z0-9_&#92;-&#92;.&#92; ]*`
   * </pre>
   *
   * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ENDPOINT_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Optional. Endpoint information to reach this member.
   * </pre>
   *
   * <code>
   * .google.cloud.gkehub.v1beta1.MembershipEndpoint endpoint = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the endpoint field is set.
   */
  @java.lang.Override
  public boolean hasEndpoint() {
    return typeCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Optional. Endpoint information to reach this member.
   * </pre>
   *
   * <code>
   * .google.cloud.gkehub.v1beta1.MembershipEndpoint endpoint = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The endpoint.
   */
  @java.lang.Override
  public com.google.cloud.gkehub.v1beta1.MembershipEndpoint getEndpoint() {
    if (typeCase_ == 4) {
      return (com.google.cloud.gkehub.v1beta1.MembershipEndpoint) type_;
    }
    return com.google.cloud.gkehub.v1beta1.MembershipEndpoint.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. Endpoint information to reach this member.
   * </pre>
   *
   * <code>
   * .google.cloud.gkehub.v1beta1.MembershipEndpoint endpoint = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.gkehub.v1beta1.MembershipEndpointOrBuilder getEndpointOrBuilder() {
    if (typeCase_ == 4) {
      return (com.google.cloud.gkehub.v1beta1.MembershipEndpoint) type_;
    }
    return com.google.cloud.gkehub.v1beta1.MembershipEndpoint.getDefaultInstance();
  }

  public static final int STATE_FIELD_NUMBER = 5;
  private com.google.cloud.gkehub.v1beta1.MembershipState state_;
  /**
   *
   *
   * <pre>
   * Output only. State of the Membership resource.
   * </pre>
   *
   * <code>
   * .google.cloud.gkehub.v1beta1.MembershipState state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the state field is set.
   */
  @java.lang.Override
  public boolean hasState() {
    return state_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. State of the Membership resource.
   * </pre>
   *
   * <code>
   * .google.cloud.gkehub.v1beta1.MembershipState state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.gkehub.v1beta1.MembershipState getState() {
    return state_ == null
        ? com.google.cloud.gkehub.v1beta1.MembershipState.getDefaultInstance()
        : state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. State of the Membership resource.
   * </pre>
   *
   * <code>
   * .google.cloud.gkehub.v1beta1.MembershipState state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.gkehub.v1beta1.MembershipStateOrBuilder getStateOrBuilder() {
    return state_ == null
        ? com.google.cloud.gkehub.v1beta1.MembershipState.getDefaultInstance()
        : state_;
  }

  public static final int AUTHORITY_FIELD_NUMBER = 9;
  private com.google.cloud.gkehub.v1beta1.Authority authority_;
  /**
   *
   *
   * <pre>
   * Optional. How to identify workloads from this Membership.
   * See the documentation on Workload Identity for more details:
   * https://cloud.google.com/kubernetes-engine/docs/how-to/workload-identity
   * </pre>
   *
   * <code>
   * .google.cloud.gkehub.v1beta1.Authority authority = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the authority field is set.
   */
  @java.lang.Override
  public boolean hasAuthority() {
    return authority_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. How to identify workloads from this Membership.
   * See the documentation on Workload Identity for more details:
   * https://cloud.google.com/kubernetes-engine/docs/how-to/workload-identity
   * </pre>
   *
   * <code>
   * .google.cloud.gkehub.v1beta1.Authority authority = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The authority.
   */
  @java.lang.Override
  public com.google.cloud.gkehub.v1beta1.Authority getAuthority() {
    return authority_ == null
        ? com.google.cloud.gkehub.v1beta1.Authority.getDefaultInstance()
        : authority_;
  }
  /**
   *
   *
   * <pre>
   * Optional. How to identify workloads from this Membership.
   * See the documentation on Workload Identity for more details:
   * https://cloud.google.com/kubernetes-engine/docs/how-to/workload-identity
   * </pre>
   *
   * <code>
   * .google.cloud.gkehub.v1beta1.Authority authority = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.gkehub.v1beta1.AuthorityOrBuilder getAuthorityOrBuilder() {
    return authority_ == null
        ? com.google.cloud.gkehub.v1beta1.Authority.getDefaultInstance()
        : authority_;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 6;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. When the Membership was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. When the Membership was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. When the Membership was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 7;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. When the Membership was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. When the Membership was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. When the Membership was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int DELETE_TIME_FIELD_NUMBER = 8;
  private com.google.protobuf.Timestamp deleteTime_;
  /**
   *
   *
   * <pre>
   * Output only. When the Membership was deleted.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the deleteTime field is set.
   */
  @java.lang.Override
  public boolean hasDeleteTime() {
    return deleteTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. When the Membership was deleted.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The deleteTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getDeleteTime() {
    return deleteTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : deleteTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. When the Membership was deleted.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getDeleteTimeOrBuilder() {
    return deleteTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : deleteTime_;
  }

  public static final int EXTERNAL_ID_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private volatile java.lang.Object externalId_ = "";
  /**
   *
   *
   * <pre>
   * Optional. An externally-generated and managed ID for this Membership. This
   * ID may be modified after creation, but this is not recommended. For GKE
   * clusters, external_id is managed by the Hub API and updates will be
   * ignored.
   *
   * The ID must match the regex: `[a-zA-Z0-9][a-zA-Z0-9_&#92;-&#92;.]*`
   *
   * If this Membership represents a Kubernetes cluster, this value should be
   * set to the UID of the `kube-system` namespace object.
   * </pre>
   *
   * <code>string external_id = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The externalId.
   */
  @java.lang.Override
  public java.lang.String getExternalId() {
    java.lang.Object ref = externalId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      externalId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. An externally-generated and managed ID for this Membership. This
   * ID may be modified after creation, but this is not recommended. For GKE
   * clusters, external_id is managed by the Hub API and updates will be
   * ignored.
   *
   * The ID must match the regex: `[a-zA-Z0-9][a-zA-Z0-9_&#92;-&#92;.]*`
   *
   * If this Membership represents a Kubernetes cluster, this value should be
   * set to the UID of the `kube-system` namespace object.
   * </pre>
   *
   * <code>string external_id = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for externalId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getExternalIdBytes() {
    java.lang.Object ref = externalId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      externalId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LAST_CONNECTION_TIME_FIELD_NUMBER = 11;
  private com.google.protobuf.Timestamp lastConnectionTime_;
  /**
   *
   *
   * <pre>
   * Output only. For clusters using Connect, the timestamp of the most recent
   * connection established with Google Cloud. This time is updated every
   * several minutes, not continuously. For clusters that do not use GKE
   * Connect, or that have never connected successfully, this field will be
   * unset.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp last_connection_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the lastConnectionTime field is set.
   */
  @java.lang.Override
  public boolean hasLastConnectionTime() {
    return lastConnectionTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. For clusters using Connect, the timestamp of the most recent
   * connection established with Google Cloud. This time is updated every
   * several minutes, not continuously. For clusters that do not use GKE
   * Connect, or that have never connected successfully, this field will be
   * unset.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp last_connection_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The lastConnectionTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getLastConnectionTime() {
    return lastConnectionTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : lastConnectionTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. For clusters using Connect, the timestamp of the most recent
   * connection established with Google Cloud. This time is updated every
   * several minutes, not continuously. For clusters that do not use GKE
   * Connect, or that have never connected successfully, this field will be
   * unset.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp last_connection_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getLastConnectionTimeOrBuilder() {
    return lastConnectionTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : lastConnectionTime_;
  }

  public static final int UNIQUE_ID_FIELD_NUMBER = 12;

  @SuppressWarnings("serial")
  private volatile java.lang.Object uniqueId_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Google-generated UUID for this resource. This is unique across
   * all Membership resources. If a Membership resource is deleted and another
   * resource with the same name is created, it gets a different unique_id.
   * </pre>
   *
   * <code>string unique_id = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The uniqueId.
   */
  @java.lang.Override
  public java.lang.String getUniqueId() {
    java.lang.Object ref = uniqueId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      uniqueId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Google-generated UUID for this resource. This is unique across
   * all Membership resources. If a Membership resource is deleted and another
   * resource with the same name is created, it gets a different unique_id.
   * </pre>
   *
   * <code>string unique_id = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for uniqueId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUniqueIdBytes() {
    java.lang.Object ref = uniqueId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      uniqueId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INFRASTRUCTURE_TYPE_FIELD_NUMBER = 13;
  private int infrastructureType_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. The infrastructure type this Membership is running on.
   * </pre>
   *
   * <code>
   * .google.cloud.gkehub.v1beta1.Membership.InfrastructureType infrastructure_type = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for infrastructureType.
   */
  @java.lang.Override
  public int getInfrastructureTypeValue() {
    return infrastructureType_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The infrastructure type this Membership is running on.
   * </pre>
   *
   * <code>
   * .google.cloud.gkehub.v1beta1.Membership.InfrastructureType infrastructure_type = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The infrastructureType.
   */
  @java.lang.Override
  public com.google.cloud.gkehub.v1beta1.Membership.InfrastructureType getInfrastructureType() {
    com.google.cloud.gkehub.v1beta1.Membership.InfrastructureType result =
        com.google.cloud.gkehub.v1beta1.Membership.InfrastructureType.forNumber(
            infrastructureType_);
    return result == null
        ? com.google.cloud.gkehub.v1beta1.Membership.InfrastructureType.UNRECOGNIZED
        : result;
  }

  public static final int MONITORING_CONFIG_FIELD_NUMBER = 14;
  private com.google.cloud.gkehub.v1beta1.MonitoringConfig monitoringConfig_;
  /**
   *
   *
   * <pre>
   * Optional. The monitoring config information for this membership.
   * </pre>
   *
   * <code>
   * .google.cloud.gkehub.v1beta1.MonitoringConfig monitoring_config = 14 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the monitoringConfig field is set.
   */
  @java.lang.Override
  public boolean hasMonitoringConfig() {
    return monitoringConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. The monitoring config information for this membership.
   * </pre>
   *
   * <code>
   * .google.cloud.gkehub.v1beta1.MonitoringConfig monitoring_config = 14 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The monitoringConfig.
   */
  @java.lang.Override
  public com.google.cloud.gkehub.v1beta1.MonitoringConfig getMonitoringConfig() {
    return monitoringConfig_ == null
        ? com.google.cloud.gkehub.v1beta1.MonitoringConfig.getDefaultInstance()
        : monitoringConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The monitoring config information for this membership.
   * </pre>
   *
   * <code>
   * .google.cloud.gkehub.v1beta1.MonitoringConfig monitoring_config = 14 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.gkehub.v1beta1.MonitoringConfigOrBuilder getMonitoringConfigOrBuilder() {
    return monitoringConfig_ == null
        ? com.google.cloud.gkehub.v1beta1.MonitoringConfig.getDefaultInstance()
        : monitoringConfig_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 2);
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, description_);
    }
    if (typeCase_ == 4) {
      output.writeMessage(4, (com.google.cloud.gkehub.v1beta1.MembershipEndpoint) type_);
    }
    if (state_ != null) {
      output.writeMessage(5, getState());
    }
    if (createTime_ != null) {
      output.writeMessage(6, getCreateTime());
    }
    if (updateTime_ != null) {
      output.writeMessage(7, getUpdateTime());
    }
    if (deleteTime_ != null) {
      output.writeMessage(8, getDeleteTime());
    }
    if (authority_ != null) {
      output.writeMessage(9, getAuthority());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(externalId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, externalId_);
    }
    if (lastConnectionTime_ != null) {
      output.writeMessage(11, getLastConnectionTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uniqueId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 12, uniqueId_);
    }
    if (infrastructureType_
        != com.google.cloud.gkehub.v1beta1.Membership.InfrastructureType
            .INFRASTRUCTURE_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(13, infrastructureType_);
    }
    if (monitoringConfig_ != null) {
      output.writeMessage(14, getMonitoringConfig());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, labels__);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, description_);
    }
    if (typeCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.cloud.gkehub.v1beta1.MembershipEndpoint) type_);
    }
    if (state_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getState());
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getCreateTime());
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getUpdateTime());
    }
    if (deleteTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getDeleteTime());
    }
    if (authority_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getAuthority());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(externalId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, externalId_);
    }
    if (lastConnectionTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getLastConnectionTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uniqueId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(12, uniqueId_);
    }
    if (infrastructureType_
        != com.google.cloud.gkehub.v1beta1.Membership.InfrastructureType
            .INFRASTRUCTURE_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(13, infrastructureType_);
    }
    if (monitoringConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(14, getMonitoringConfig());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.gkehub.v1beta1.Membership)) {
      return super.equals(obj);
    }
    com.google.cloud.gkehub.v1beta1.Membership other =
        (com.google.cloud.gkehub.v1beta1.Membership) obj;

    if (!getName().equals(other.getName())) return false;
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (hasState() != other.hasState()) return false;
    if (hasState()) {
      if (!getState().equals(other.getState())) return false;
    }
    if (hasAuthority() != other.hasAuthority()) return false;
    if (hasAuthority()) {
      if (!getAuthority().equals(other.getAuthority())) return false;
    }
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (hasDeleteTime() != other.hasDeleteTime()) return false;
    if (hasDeleteTime()) {
      if (!getDeleteTime().equals(other.getDeleteTime())) return false;
    }
    if (!getExternalId().equals(other.getExternalId())) return false;
    if (hasLastConnectionTime() != other.hasLastConnectionTime()) return false;
    if (hasLastConnectionTime()) {
      if (!getLastConnectionTime().equals(other.getLastConnectionTime())) return false;
    }
    if (!getUniqueId().equals(other.getUniqueId())) return false;
    if (infrastructureType_ != other.infrastructureType_) return false;
    if (hasMonitoringConfig() != other.hasMonitoringConfig()) return false;
    if (hasMonitoringConfig()) {
      if (!getMonitoringConfig().equals(other.getMonitoringConfig())) return false;
    }
    if (!getTypeCase().equals(other.getTypeCase())) return false;
    switch (typeCase_) {
      case 4:
        if (!getEndpoint().equals(other.getEndpoint())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    if (hasState()) {
      hash = (37 * hash) + STATE_FIELD_NUMBER;
      hash = (53 * hash) + getState().hashCode();
    }
    if (hasAuthority()) {
      hash = (37 * hash) + AUTHORITY_FIELD_NUMBER;
      hash = (53 * hash) + getAuthority().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (hasDeleteTime()) {
      hash = (37 * hash) + DELETE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getDeleteTime().hashCode();
    }
    hash = (37 * hash) + EXTERNAL_ID_FIELD_NUMBER;
    hash = (53 * hash) + getExternalId().hashCode();
    if (hasLastConnectionTime()) {
      hash = (37 * hash) + LAST_CONNECTION_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getLastConnectionTime().hashCode();
    }
    hash = (37 * hash) + UNIQUE_ID_FIELD_NUMBER;
    hash = (53 * hash) + getUniqueId().hashCode();
    hash = (37 * hash) + INFRASTRUCTURE_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + infrastructureType_;
    if (hasMonitoringConfig()) {
      hash = (37 * hash) + MONITORING_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getMonitoringConfig().hashCode();
    }
    switch (typeCase_) {
      case 4:
        hash = (37 * hash) + ENDPOINT_FIELD_NUMBER;
        hash = (53 * hash) + getEndpoint().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.gkehub.v1beta1.Membership parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gkehub.v1beta1.Membership parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gkehub.v1beta1.Membership parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gkehub.v1beta1.Membership parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gkehub.v1beta1.Membership parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gkehub.v1beta1.Membership parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gkehub.v1beta1.Membership parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.gkehub.v1beta1.Membership parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.gkehub.v1beta1.Membership parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.gkehub.v1beta1.Membership parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.gkehub.v1beta1.Membership parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.gkehub.v1beta1.Membership parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.gkehub.v1beta1.Membership prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Membership contains information about a member cluster.
   * </pre>
   *
   * Protobuf type {@code google.cloud.gkehub.v1beta1.Membership}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.gkehub.v1beta1.Membership)
      com.google.cloud.gkehub.v1beta1.MembershipOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.gkehub.v1beta1.MembershipOuterClass
          .internal_static_google_cloud_gkehub_v1beta1_Membership_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 2:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 2:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.gkehub.v1beta1.MembershipOuterClass
          .internal_static_google_cloud_gkehub_v1beta1_Membership_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.gkehub.v1beta1.Membership.class,
              com.google.cloud.gkehub.v1beta1.Membership.Builder.class);
    }

    // Construct using com.google.cloud.gkehub.v1beta1.Membership.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      internalGetMutableLabels().clear();
      description_ = "";
      if (endpointBuilder_ != null) {
        endpointBuilder_.clear();
      }
      state_ = null;
      if (stateBuilder_ != null) {
        stateBuilder_.dispose();
        stateBuilder_ = null;
      }
      authority_ = null;
      if (authorityBuilder_ != null) {
        authorityBuilder_.dispose();
        authorityBuilder_ = null;
      }
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      deleteTime_ = null;
      if (deleteTimeBuilder_ != null) {
        deleteTimeBuilder_.dispose();
        deleteTimeBuilder_ = null;
      }
      externalId_ = "";
      lastConnectionTime_ = null;
      if (lastConnectionTimeBuilder_ != null) {
        lastConnectionTimeBuilder_.dispose();
        lastConnectionTimeBuilder_ = null;
      }
      uniqueId_ = "";
      infrastructureType_ = 0;
      monitoringConfig_ = null;
      if (monitoringConfigBuilder_ != null) {
        monitoringConfigBuilder_.dispose();
        monitoringConfigBuilder_ = null;
      }
      typeCase_ = 0;
      type_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.gkehub.v1beta1.MembershipOuterClass
          .internal_static_google_cloud_gkehub_v1beta1_Membership_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.gkehub.v1beta1.Membership getDefaultInstanceForType() {
      return com.google.cloud.gkehub.v1beta1.Membership.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.gkehub.v1beta1.Membership build() {
      com.google.cloud.gkehub.v1beta1.Membership result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.gkehub.v1beta1.Membership buildPartial() {
      com.google.cloud.gkehub.v1beta1.Membership result =
          new com.google.cloud.gkehub.v1beta1.Membership(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.gkehub.v1beta1.Membership result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.state_ = stateBuilder_ == null ? state_ : stateBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.authority_ = authorityBuilder_ == null ? authority_ : authorityBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.deleteTime_ = deleteTimeBuilder_ == null ? deleteTime_ : deleteTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.externalId_ = externalId_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.lastConnectionTime_ =
            lastConnectionTimeBuilder_ == null
                ? lastConnectionTime_
                : lastConnectionTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.uniqueId_ = uniqueId_;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.infrastructureType_ = infrastructureType_;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.monitoringConfig_ =
            monitoringConfigBuilder_ == null ? monitoringConfig_ : monitoringConfigBuilder_.build();
      }
    }

    private void buildPartialOneofs(com.google.cloud.gkehub.v1beta1.Membership result) {
      result.typeCase_ = typeCase_;
      result.type_ = this.type_;
      if (typeCase_ == 4 && endpointBuilder_ != null) {
        result.type_ = endpointBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.gkehub.v1beta1.Membership) {
        return mergeFrom((com.google.cloud.gkehub.v1beta1.Membership) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.gkehub.v1beta1.Membership other) {
      if (other == com.google.cloud.gkehub.v1beta1.Membership.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000002;
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasState()) {
        mergeState(other.getState());
      }
      if (other.hasAuthority()) {
        mergeAuthority(other.getAuthority());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (other.hasDeleteTime()) {
        mergeDeleteTime(other.getDeleteTime());
      }
      if (!other.getExternalId().isEmpty()) {
        externalId_ = other.externalId_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (other.hasLastConnectionTime()) {
        mergeLastConnectionTime(other.getLastConnectionTime());
      }
      if (!other.getUniqueId().isEmpty()) {
        uniqueId_ = other.uniqueId_;
        bitField0_ |= 0x00000800;
        onChanged();
      }
      if (other.infrastructureType_ != 0) {
        setInfrastructureTypeValue(other.getInfrastructureTypeValue());
      }
      if (other.hasMonitoringConfig()) {
        mergeMonitoringConfig(other.getMonitoringConfig());
      }
      switch (other.getTypeCase()) {
        case ENDPOINT:
          {
            mergeEndpoint(other.getEndpoint());
            break;
          }
        case TYPE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getEndpointFieldBuilder().getBuilder(), extensionRegistry);
                typeCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getStateFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getDeleteTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(getAuthorityFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 74
            case 82:
              {
                externalId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 82
            case 90:
              {
                input.readMessage(
                    getLastConnectionTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 90
            case 98:
              {
                uniqueId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000800;
                break;
              } // case 98
            case 104:
              {
                infrastructureType_ = input.readEnum();
                bitField0_ |= 0x00001000;
                break;
              } // case 104
            case 114:
              {
                input.readMessage(
                    getMonitoringConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00002000;
                break;
              } // case 114
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int typeCase_ = 0;
    private java.lang.Object type_;

    public TypeCase getTypeCase() {
      return TypeCase.forNumber(typeCase_);
    }

    public Builder clearType() {
      typeCase_ = 0;
      type_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The full, unique name of this Membership resource in the
     * format `projects/&#42;&#47;locations/&#42;&#47;memberships/{membership_id}`, set during
     * creation.
     *
     * `membership_id` must be a valid RFC 1123 compliant DNS label:
     *
     *   1. At most 63 characters in length
     *   2. It must consist of lower case alphanumeric characters or `-`
     *   3. It must start and end with an alphanumeric character
     *
     * Which can be expressed as the regex: `[a-z0-9]([-a-z0-9]*[a-z0-9])?`,
     * with a maximum length of 63 characters.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The full, unique name of this Membership resource in the
     * format `projects/&#42;&#47;locations/&#42;&#47;memberships/{membership_id}`, set during
     * creation.
     *
     * `membership_id` must be a valid RFC 1123 compliant DNS label:
     *
     *   1. At most 63 characters in length
     *   2. It must consist of lower case alphanumeric characters or `-`
     *   3. It must start and end with an alphanumeric character
     *
     * Which can be expressed as the regex: `[a-z0-9]([-a-z0-9]*[a-z0-9])?`,
     * with a maximum length of 63 characters.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The full, unique name of this Membership resource in the
     * format `projects/&#42;&#47;locations/&#42;&#47;memberships/{membership_id}`, set during
     * creation.
     *
     * `membership_id` must be a valid RFC 1123 compliant DNS label:
     *
     *   1. At most 63 characters in length
     *   2. It must consist of lower case alphanumeric characters or `-`
     *   3. It must start and end with an alphanumeric character
     *
     * Which can be expressed as the regex: `[a-z0-9]([-a-z0-9]*[a-z0-9])?`,
     * with a maximum length of 63 characters.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The full, unique name of this Membership resource in the
     * format `projects/&#42;&#47;locations/&#42;&#47;memberships/{membership_id}`, set during
     * creation.
     *
     * `membership_id` must be a valid RFC 1123 compliant DNS label:
     *
     *   1. At most 63 characters in length
     *   2. It must consist of lower case alphanumeric characters or `-`
     *   3. It must start and end with an alphanumeric character
     *
     * Which can be expressed as the regex: `[a-z0-9]([-a-z0-9]*[a-z0-9])?`,
     * with a maximum length of 63 characters.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The full, unique name of this Membership resource in the
     * format `projects/&#42;&#47;locations/&#42;&#47;memberships/{membership_id}`, set during
     * creation.
     *
     * `membership_id` must be a valid RFC 1123 compliant DNS label:
     *
     *   1. At most 63 characters in length
     *   2. It must consist of lower case alphanumeric characters or `-`
     *   3. It must start and end with an alphanumeric character
     *
     * Which can be expressed as the regex: `[a-z0-9]([-a-z0-9]*[a-z0-9])?`,
     * with a maximum length of 63 characters.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional. GCP labels for this membership.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. GCP labels for this membership.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. GCP labels for this membership.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional. GCP labels for this membership.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000002);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. GCP labels for this membership.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000002;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. GCP labels for this membership.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000002;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. GCP labels for this membership.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000002;
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Description of this membership, limited to 63 characters.
     * Must match the regex: `[a-zA-Z0-9][a-zA-Z0-9_&#92;-&#92;.&#92; ]*`
     * </pre>
     *
     * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Description of this membership, limited to 63 characters.
     * Must match the regex: `[a-zA-Z0-9][a-zA-Z0-9_&#92;-&#92;.&#92; ]*`
     * </pre>
     *
     * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Description of this membership, limited to 63 characters.
     * Must match the regex: `[a-zA-Z0-9][a-zA-Z0-9_&#92;-&#92;.&#92; ]*`
     * </pre>
     *
     * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Description of this membership, limited to 63 characters.
     * Must match the regex: `[a-zA-Z0-9][a-zA-Z0-9_&#92;-&#92;.&#92; ]*`
     * </pre>
     *
     * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Description of this membership, limited to 63 characters.
     * Must match the regex: `[a-zA-Z0-9][a-zA-Z0-9_&#92;-&#92;.&#92; ]*`
     * </pre>
     *
     * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gkehub.v1beta1.MembershipEndpoint,
            com.google.cloud.gkehub.v1beta1.MembershipEndpoint.Builder,
            com.google.cloud.gkehub.v1beta1.MembershipEndpointOrBuilder>
        endpointBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Endpoint information to reach this member.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.MembershipEndpoint endpoint = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the endpoint field is set.
     */
    @java.lang.Override
    public boolean hasEndpoint() {
      return typeCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Optional. Endpoint information to reach this member.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.MembershipEndpoint endpoint = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The endpoint.
     */
    @java.lang.Override
    public com.google.cloud.gkehub.v1beta1.MembershipEndpoint getEndpoint() {
      if (endpointBuilder_ == null) {
        if (typeCase_ == 4) {
          return (com.google.cloud.gkehub.v1beta1.MembershipEndpoint) type_;
        }
        return com.google.cloud.gkehub.v1beta1.MembershipEndpoint.getDefaultInstance();
      } else {
        if (typeCase_ == 4) {
          return endpointBuilder_.getMessage();
        }
        return com.google.cloud.gkehub.v1beta1.MembershipEndpoint.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Endpoint information to reach this member.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.MembershipEndpoint endpoint = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setEndpoint(com.google.cloud.gkehub.v1beta1.MembershipEndpoint value) {
      if (endpointBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        type_ = value;
        onChanged();
      } else {
        endpointBuilder_.setMessage(value);
      }
      typeCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Endpoint information to reach this member.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.MembershipEndpoint endpoint = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setEndpoint(
        com.google.cloud.gkehub.v1beta1.MembershipEndpoint.Builder builderForValue) {
      if (endpointBuilder_ == null) {
        type_ = builderForValue.build();
        onChanged();
      } else {
        endpointBuilder_.setMessage(builderForValue.build());
      }
      typeCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Endpoint information to reach this member.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.MembershipEndpoint endpoint = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeEndpoint(com.google.cloud.gkehub.v1beta1.MembershipEndpoint value) {
      if (endpointBuilder_ == null) {
        if (typeCase_ == 4
            && type_ != com.google.cloud.gkehub.v1beta1.MembershipEndpoint.getDefaultInstance()) {
          type_ =
              com.google.cloud.gkehub.v1beta1.MembershipEndpoint.newBuilder(
                      (com.google.cloud.gkehub.v1beta1.MembershipEndpoint) type_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          type_ = value;
        }
        onChanged();
      } else {
        if (typeCase_ == 4) {
          endpointBuilder_.mergeFrom(value);
        } else {
          endpointBuilder_.setMessage(value);
        }
      }
      typeCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Endpoint information to reach this member.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.MembershipEndpoint endpoint = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearEndpoint() {
      if (endpointBuilder_ == null) {
        if (typeCase_ == 4) {
          typeCase_ = 0;
          type_ = null;
          onChanged();
        }
      } else {
        if (typeCase_ == 4) {
          typeCase_ = 0;
          type_ = null;
        }
        endpointBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Endpoint information to reach this member.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.MembershipEndpoint endpoint = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.gkehub.v1beta1.MembershipEndpoint.Builder getEndpointBuilder() {
      return getEndpointFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Endpoint information to reach this member.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.MembershipEndpoint endpoint = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.gkehub.v1beta1.MembershipEndpointOrBuilder getEndpointOrBuilder() {
      if ((typeCase_ == 4) && (endpointBuilder_ != null)) {
        return endpointBuilder_.getMessageOrBuilder();
      } else {
        if (typeCase_ == 4) {
          return (com.google.cloud.gkehub.v1beta1.MembershipEndpoint) type_;
        }
        return com.google.cloud.gkehub.v1beta1.MembershipEndpoint.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Endpoint information to reach this member.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.MembershipEndpoint endpoint = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gkehub.v1beta1.MembershipEndpoint,
            com.google.cloud.gkehub.v1beta1.MembershipEndpoint.Builder,
            com.google.cloud.gkehub.v1beta1.MembershipEndpointOrBuilder>
        getEndpointFieldBuilder() {
      if (endpointBuilder_ == null) {
        if (!(typeCase_ == 4)) {
          type_ = com.google.cloud.gkehub.v1beta1.MembershipEndpoint.getDefaultInstance();
        }
        endpointBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.gkehub.v1beta1.MembershipEndpoint,
                com.google.cloud.gkehub.v1beta1.MembershipEndpoint.Builder,
                com.google.cloud.gkehub.v1beta1.MembershipEndpointOrBuilder>(
                (com.google.cloud.gkehub.v1beta1.MembershipEndpoint) type_,
                getParentForChildren(),
                isClean());
        type_ = null;
      }
      typeCase_ = 4;
      onChanged();
      return endpointBuilder_;
    }

    private com.google.cloud.gkehub.v1beta1.MembershipState state_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gkehub.v1beta1.MembershipState,
            com.google.cloud.gkehub.v1beta1.MembershipState.Builder,
            com.google.cloud.gkehub.v1beta1.MembershipStateOrBuilder>
        stateBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. State of the Membership resource.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.MembershipState state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the state field is set.
     */
    public boolean hasState() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the Membership resource.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.MembershipState state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    public com.google.cloud.gkehub.v1beta1.MembershipState getState() {
      if (stateBuilder_ == null) {
        return state_ == null
            ? com.google.cloud.gkehub.v1beta1.MembershipState.getDefaultInstance()
            : state_;
      } else {
        return stateBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the Membership resource.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.MembershipState state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setState(com.google.cloud.gkehub.v1beta1.MembershipState value) {
      if (stateBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        state_ = value;
      } else {
        stateBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the Membership resource.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.MembershipState state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setState(
        com.google.cloud.gkehub.v1beta1.MembershipState.Builder builderForValue) {
      if (stateBuilder_ == null) {
        state_ = builderForValue.build();
      } else {
        stateBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the Membership resource.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.MembershipState state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeState(com.google.cloud.gkehub.v1beta1.MembershipState value) {
      if (stateBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && state_ != null
            && state_ != com.google.cloud.gkehub.v1beta1.MembershipState.getDefaultInstance()) {
          getStateBuilder().mergeFrom(value);
        } else {
          state_ = value;
        }
      } else {
        stateBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the Membership resource.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.MembershipState state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000010);
      state_ = null;
      if (stateBuilder_ != null) {
        stateBuilder_.dispose();
        stateBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the Membership resource.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.MembershipState state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.gkehub.v1beta1.MembershipState.Builder getStateBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getStateFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the Membership resource.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.MembershipState state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.gkehub.v1beta1.MembershipStateOrBuilder getStateOrBuilder() {
      if (stateBuilder_ != null) {
        return stateBuilder_.getMessageOrBuilder();
      } else {
        return state_ == null
            ? com.google.cloud.gkehub.v1beta1.MembershipState.getDefaultInstance()
            : state_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the Membership resource.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.MembershipState state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gkehub.v1beta1.MembershipState,
            com.google.cloud.gkehub.v1beta1.MembershipState.Builder,
            com.google.cloud.gkehub.v1beta1.MembershipStateOrBuilder>
        getStateFieldBuilder() {
      if (stateBuilder_ == null) {
        stateBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.gkehub.v1beta1.MembershipState,
                com.google.cloud.gkehub.v1beta1.MembershipState.Builder,
                com.google.cloud.gkehub.v1beta1.MembershipStateOrBuilder>(
                getState(), getParentForChildren(), isClean());
        state_ = null;
      }
      return stateBuilder_;
    }

    private com.google.cloud.gkehub.v1beta1.Authority authority_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gkehub.v1beta1.Authority,
            com.google.cloud.gkehub.v1beta1.Authority.Builder,
            com.google.cloud.gkehub.v1beta1.AuthorityOrBuilder>
        authorityBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. How to identify workloads from this Membership.
     * See the documentation on Workload Identity for more details:
     * https://cloud.google.com/kubernetes-engine/docs/how-to/workload-identity
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.Authority authority = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the authority field is set.
     */
    public boolean hasAuthority() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. How to identify workloads from this Membership.
     * See the documentation on Workload Identity for more details:
     * https://cloud.google.com/kubernetes-engine/docs/how-to/workload-identity
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.Authority authority = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The authority.
     */
    public com.google.cloud.gkehub.v1beta1.Authority getAuthority() {
      if (authorityBuilder_ == null) {
        return authority_ == null
            ? com.google.cloud.gkehub.v1beta1.Authority.getDefaultInstance()
            : authority_;
      } else {
        return authorityBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. How to identify workloads from this Membership.
     * See the documentation on Workload Identity for more details:
     * https://cloud.google.com/kubernetes-engine/docs/how-to/workload-identity
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.Authority authority = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAuthority(com.google.cloud.gkehub.v1beta1.Authority value) {
      if (authorityBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        authority_ = value;
      } else {
        authorityBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. How to identify workloads from this Membership.
     * See the documentation on Workload Identity for more details:
     * https://cloud.google.com/kubernetes-engine/docs/how-to/workload-identity
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.Authority authority = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAuthority(com.google.cloud.gkehub.v1beta1.Authority.Builder builderForValue) {
      if (authorityBuilder_ == null) {
        authority_ = builderForValue.build();
      } else {
        authorityBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. How to identify workloads from this Membership.
     * See the documentation on Workload Identity for more details:
     * https://cloud.google.com/kubernetes-engine/docs/how-to/workload-identity
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.Authority authority = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeAuthority(com.google.cloud.gkehub.v1beta1.Authority value) {
      if (authorityBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && authority_ != null
            && authority_ != com.google.cloud.gkehub.v1beta1.Authority.getDefaultInstance()) {
          getAuthorityBuilder().mergeFrom(value);
        } else {
          authority_ = value;
        }
      } else {
        authorityBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. How to identify workloads from this Membership.
     * See the documentation on Workload Identity for more details:
     * https://cloud.google.com/kubernetes-engine/docs/how-to/workload-identity
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.Authority authority = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearAuthority() {
      bitField0_ = (bitField0_ & ~0x00000020);
      authority_ = null;
      if (authorityBuilder_ != null) {
        authorityBuilder_.dispose();
        authorityBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. How to identify workloads from this Membership.
     * See the documentation on Workload Identity for more details:
     * https://cloud.google.com/kubernetes-engine/docs/how-to/workload-identity
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.Authority authority = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.gkehub.v1beta1.Authority.Builder getAuthorityBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getAuthorityFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. How to identify workloads from this Membership.
     * See the documentation on Workload Identity for more details:
     * https://cloud.google.com/kubernetes-engine/docs/how-to/workload-identity
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.Authority authority = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.gkehub.v1beta1.AuthorityOrBuilder getAuthorityOrBuilder() {
      if (authorityBuilder_ != null) {
        return authorityBuilder_.getMessageOrBuilder();
      } else {
        return authority_ == null
            ? com.google.cloud.gkehub.v1beta1.Authority.getDefaultInstance()
            : authority_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. How to identify workloads from this Membership.
     * See the documentation on Workload Identity for more details:
     * https://cloud.google.com/kubernetes-engine/docs/how-to/workload-identity
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.Authority authority = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gkehub.v1beta1.Authority,
            com.google.cloud.gkehub.v1beta1.Authority.Builder,
            com.google.cloud.gkehub.v1beta1.AuthorityOrBuilder>
        getAuthorityFieldBuilder() {
      if (authorityBuilder_ == null) {
        authorityBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.gkehub.v1beta1.Authority,
                com.google.cloud.gkehub.v1beta1.Authority.Builder,
                com.google.cloud.gkehub.v1beta1.AuthorityOrBuilder>(
                getAuthority(), getParentForChildren(), isClean());
        authority_ = null;
      }
      return authorityBuilder_;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. When the Membership was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. When the Membership was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. When the Membership was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. When the Membership was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. When the Membership was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. When the Membership was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000040);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. When the Membership was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. When the Membership was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. When the Membership was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. When the Membership was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. When the Membership was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. When the Membership was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. When the Membership was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. When the Membership was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. When the Membership was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000080);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. When the Membership was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. When the Membership was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. When the Membership was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.protobuf.Timestamp deleteTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        deleteTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. When the Membership was deleted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the deleteTime field is set.
     */
    public boolean hasDeleteTime() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. When the Membership was deleted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The deleteTime.
     */
    public com.google.protobuf.Timestamp getDeleteTime() {
      if (deleteTimeBuilder_ == null) {
        return deleteTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : deleteTime_;
      } else {
        return deleteTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. When the Membership was deleted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDeleteTime(com.google.protobuf.Timestamp value) {
      if (deleteTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        deleteTime_ = value;
      } else {
        deleteTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. When the Membership was deleted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDeleteTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (deleteTimeBuilder_ == null) {
        deleteTime_ = builderForValue.build();
      } else {
        deleteTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. When the Membership was deleted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeDeleteTime(com.google.protobuf.Timestamp value) {
      if (deleteTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && deleteTime_ != null
            && deleteTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getDeleteTimeBuilder().mergeFrom(value);
        } else {
          deleteTime_ = value;
        }
      } else {
        deleteTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. When the Membership was deleted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearDeleteTime() {
      bitField0_ = (bitField0_ & ~0x00000100);
      deleteTime_ = null;
      if (deleteTimeBuilder_ != null) {
        deleteTimeBuilder_.dispose();
        deleteTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. When the Membership was deleted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getDeleteTimeBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getDeleteTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. When the Membership was deleted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getDeleteTimeOrBuilder() {
      if (deleteTimeBuilder_ != null) {
        return deleteTimeBuilder_.getMessageOrBuilder();
      } else {
        return deleteTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : deleteTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. When the Membership was deleted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getDeleteTimeFieldBuilder() {
      if (deleteTimeBuilder_ == null) {
        deleteTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getDeleteTime(), getParentForChildren(), isClean());
        deleteTime_ = null;
      }
      return deleteTimeBuilder_;
    }

    private java.lang.Object externalId_ = "";
    /**
     *
     *
     * <pre>
     * Optional. An externally-generated and managed ID for this Membership. This
     * ID may be modified after creation, but this is not recommended. For GKE
     * clusters, external_id is managed by the Hub API and updates will be
     * ignored.
     *
     * The ID must match the regex: `[a-zA-Z0-9][a-zA-Z0-9_&#92;-&#92;.]*`
     *
     * If this Membership represents a Kubernetes cluster, this value should be
     * set to the UID of the `kube-system` namespace object.
     * </pre>
     *
     * <code>string external_id = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The externalId.
     */
    public java.lang.String getExternalId() {
      java.lang.Object ref = externalId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        externalId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. An externally-generated and managed ID for this Membership. This
     * ID may be modified after creation, but this is not recommended. For GKE
     * clusters, external_id is managed by the Hub API and updates will be
     * ignored.
     *
     * The ID must match the regex: `[a-zA-Z0-9][a-zA-Z0-9_&#92;-&#92;.]*`
     *
     * If this Membership represents a Kubernetes cluster, this value should be
     * set to the UID of the `kube-system` namespace object.
     * </pre>
     *
     * <code>string external_id = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for externalId.
     */
    public com.google.protobuf.ByteString getExternalIdBytes() {
      java.lang.Object ref = externalId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        externalId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. An externally-generated and managed ID for this Membership. This
     * ID may be modified after creation, but this is not recommended. For GKE
     * clusters, external_id is managed by the Hub API and updates will be
     * ignored.
     *
     * The ID must match the regex: `[a-zA-Z0-9][a-zA-Z0-9_&#92;-&#92;.]*`
     *
     * If this Membership represents a Kubernetes cluster, this value should be
     * set to the UID of the `kube-system` namespace object.
     * </pre>
     *
     * <code>string external_id = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The externalId to set.
     * @return This builder for chaining.
     */
    public Builder setExternalId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      externalId_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. An externally-generated and managed ID for this Membership. This
     * ID may be modified after creation, but this is not recommended. For GKE
     * clusters, external_id is managed by the Hub API and updates will be
     * ignored.
     *
     * The ID must match the regex: `[a-zA-Z0-9][a-zA-Z0-9_&#92;-&#92;.]*`
     *
     * If this Membership represents a Kubernetes cluster, this value should be
     * set to the UID of the `kube-system` namespace object.
     * </pre>
     *
     * <code>string external_id = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExternalId() {
      externalId_ = getDefaultInstance().getExternalId();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. An externally-generated and managed ID for this Membership. This
     * ID may be modified after creation, but this is not recommended. For GKE
     * clusters, external_id is managed by the Hub API and updates will be
     * ignored.
     *
     * The ID must match the regex: `[a-zA-Z0-9][a-zA-Z0-9_&#92;-&#92;.]*`
     *
     * If this Membership represents a Kubernetes cluster, this value should be
     * set to the UID of the `kube-system` namespace object.
     * </pre>
     *
     * <code>string external_id = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for externalId to set.
     * @return This builder for chaining.
     */
    public Builder setExternalIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      externalId_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp lastConnectionTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        lastConnectionTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. For clusters using Connect, the timestamp of the most recent
     * connection established with Google Cloud. This time is updated every
     * several minutes, not continuously. For clusters that do not use GKE
     * Connect, or that have never connected successfully, this field will be
     * unset.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_connection_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the lastConnectionTime field is set.
     */
    public boolean hasLastConnectionTime() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. For clusters using Connect, the timestamp of the most recent
     * connection established with Google Cloud. This time is updated every
     * several minutes, not continuously. For clusters that do not use GKE
     * Connect, or that have never connected successfully, this field will be
     * unset.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_connection_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The lastConnectionTime.
     */
    public com.google.protobuf.Timestamp getLastConnectionTime() {
      if (lastConnectionTimeBuilder_ == null) {
        return lastConnectionTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : lastConnectionTime_;
      } else {
        return lastConnectionTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. For clusters using Connect, the timestamp of the most recent
     * connection established with Google Cloud. This time is updated every
     * several minutes, not continuously. For clusters that do not use GKE
     * Connect, or that have never connected successfully, this field will be
     * unset.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_connection_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setLastConnectionTime(com.google.protobuf.Timestamp value) {
      if (lastConnectionTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        lastConnectionTime_ = value;
      } else {
        lastConnectionTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. For clusters using Connect, the timestamp of the most recent
     * connection established with Google Cloud. This time is updated every
     * several minutes, not continuously. For clusters that do not use GKE
     * Connect, or that have never connected successfully, this field will be
     * unset.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_connection_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setLastConnectionTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (lastConnectionTimeBuilder_ == null) {
        lastConnectionTime_ = builderForValue.build();
      } else {
        lastConnectionTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. For clusters using Connect, the timestamp of the most recent
     * connection established with Google Cloud. This time is updated every
     * several minutes, not continuously. For clusters that do not use GKE
     * Connect, or that have never connected successfully, this field will be
     * unset.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_connection_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeLastConnectionTime(com.google.protobuf.Timestamp value) {
      if (lastConnectionTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && lastConnectionTime_ != null
            && lastConnectionTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getLastConnectionTimeBuilder().mergeFrom(value);
        } else {
          lastConnectionTime_ = value;
        }
      } else {
        lastConnectionTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. For clusters using Connect, the timestamp of the most recent
     * connection established with Google Cloud. This time is updated every
     * several minutes, not continuously. For clusters that do not use GKE
     * Connect, or that have never connected successfully, this field will be
     * unset.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_connection_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearLastConnectionTime() {
      bitField0_ = (bitField0_ & ~0x00000400);
      lastConnectionTime_ = null;
      if (lastConnectionTimeBuilder_ != null) {
        lastConnectionTimeBuilder_.dispose();
        lastConnectionTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. For clusters using Connect, the timestamp of the most recent
     * connection established with Google Cloud. This time is updated every
     * several minutes, not continuously. For clusters that do not use GKE
     * Connect, or that have never connected successfully, this field will be
     * unset.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_connection_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getLastConnectionTimeBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getLastConnectionTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. For clusters using Connect, the timestamp of the most recent
     * connection established with Google Cloud. This time is updated every
     * several minutes, not continuously. For clusters that do not use GKE
     * Connect, or that have never connected successfully, this field will be
     * unset.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_connection_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getLastConnectionTimeOrBuilder() {
      if (lastConnectionTimeBuilder_ != null) {
        return lastConnectionTimeBuilder_.getMessageOrBuilder();
      } else {
        return lastConnectionTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : lastConnectionTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. For clusters using Connect, the timestamp of the most recent
     * connection established with Google Cloud. This time is updated every
     * several minutes, not continuously. For clusters that do not use GKE
     * Connect, or that have never connected successfully, this field will be
     * unset.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_connection_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getLastConnectionTimeFieldBuilder() {
      if (lastConnectionTimeBuilder_ == null) {
        lastConnectionTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getLastConnectionTime(), getParentForChildren(), isClean());
        lastConnectionTime_ = null;
      }
      return lastConnectionTimeBuilder_;
    }

    private java.lang.Object uniqueId_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Google-generated UUID for this resource. This is unique across
     * all Membership resources. If a Membership resource is deleted and another
     * resource with the same name is created, it gets a different unique_id.
     * </pre>
     *
     * <code>string unique_id = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The uniqueId.
     */
    public java.lang.String getUniqueId() {
      java.lang.Object ref = uniqueId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uniqueId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Google-generated UUID for this resource. This is unique across
     * all Membership resources. If a Membership resource is deleted and another
     * resource with the same name is created, it gets a different unique_id.
     * </pre>
     *
     * <code>string unique_id = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for uniqueId.
     */
    public com.google.protobuf.ByteString getUniqueIdBytes() {
      java.lang.Object ref = uniqueId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        uniqueId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Google-generated UUID for this resource. This is unique across
     * all Membership resources. If a Membership resource is deleted and another
     * resource with the same name is created, it gets a different unique_id.
     * </pre>
     *
     * <code>string unique_id = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The uniqueId to set.
     * @return This builder for chaining.
     */
    public Builder setUniqueId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      uniqueId_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Google-generated UUID for this resource. This is unique across
     * all Membership resources. If a Membership resource is deleted and another
     * resource with the same name is created, it gets a different unique_id.
     * </pre>
     *
     * <code>string unique_id = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUniqueId() {
      uniqueId_ = getDefaultInstance().getUniqueId();
      bitField0_ = (bitField0_ & ~0x00000800);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Google-generated UUID for this resource. This is unique across
     * all Membership resources. If a Membership resource is deleted and another
     * resource with the same name is created, it gets a different unique_id.
     * </pre>
     *
     * <code>string unique_id = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for uniqueId to set.
     * @return This builder for chaining.
     */
    public Builder setUniqueIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      uniqueId_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    private int infrastructureType_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. The infrastructure type this Membership is running on.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.Membership.InfrastructureType infrastructure_type = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for infrastructureType.
     */
    @java.lang.Override
    public int getInfrastructureTypeValue() {
      return infrastructureType_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The infrastructure type this Membership is running on.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.Membership.InfrastructureType infrastructure_type = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for infrastructureType to set.
     * @return This builder for chaining.
     */
    public Builder setInfrastructureTypeValue(int value) {
      infrastructureType_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The infrastructure type this Membership is running on.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.Membership.InfrastructureType infrastructure_type = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The infrastructureType.
     */
    @java.lang.Override
    public com.google.cloud.gkehub.v1beta1.Membership.InfrastructureType getInfrastructureType() {
      com.google.cloud.gkehub.v1beta1.Membership.InfrastructureType result =
          com.google.cloud.gkehub.v1beta1.Membership.InfrastructureType.forNumber(
              infrastructureType_);
      return result == null
          ? com.google.cloud.gkehub.v1beta1.Membership.InfrastructureType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Optional. The infrastructure type this Membership is running on.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.Membership.InfrastructureType infrastructure_type = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The infrastructureType to set.
     * @return This builder for chaining.
     */
    public Builder setInfrastructureType(
        com.google.cloud.gkehub.v1beta1.Membership.InfrastructureType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00001000;
      infrastructureType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The infrastructure type this Membership is running on.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.Membership.InfrastructureType infrastructure_type = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInfrastructureType() {
      bitField0_ = (bitField0_ & ~0x00001000);
      infrastructureType_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.gkehub.v1beta1.MonitoringConfig monitoringConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gkehub.v1beta1.MonitoringConfig,
            com.google.cloud.gkehub.v1beta1.MonitoringConfig.Builder,
            com.google.cloud.gkehub.v1beta1.MonitoringConfigOrBuilder>
        monitoringConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The monitoring config information for this membership.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.MonitoringConfig monitoring_config = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the monitoringConfig field is set.
     */
    public boolean hasMonitoringConfig() {
      return ((bitField0_ & 0x00002000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The monitoring config information for this membership.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.MonitoringConfig monitoring_config = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The monitoringConfig.
     */
    public com.google.cloud.gkehub.v1beta1.MonitoringConfig getMonitoringConfig() {
      if (monitoringConfigBuilder_ == null) {
        return monitoringConfig_ == null
            ? com.google.cloud.gkehub.v1beta1.MonitoringConfig.getDefaultInstance()
            : monitoringConfig_;
      } else {
        return monitoringConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The monitoring config information for this membership.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.MonitoringConfig monitoring_config = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setMonitoringConfig(com.google.cloud.gkehub.v1beta1.MonitoringConfig value) {
      if (monitoringConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        monitoringConfig_ = value;
      } else {
        monitoringConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The monitoring config information for this membership.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.MonitoringConfig monitoring_config = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setMonitoringConfig(
        com.google.cloud.gkehub.v1beta1.MonitoringConfig.Builder builderForValue) {
      if (monitoringConfigBuilder_ == null) {
        monitoringConfig_ = builderForValue.build();
      } else {
        monitoringConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The monitoring config information for this membership.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.MonitoringConfig monitoring_config = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeMonitoringConfig(com.google.cloud.gkehub.v1beta1.MonitoringConfig value) {
      if (monitoringConfigBuilder_ == null) {
        if (((bitField0_ & 0x00002000) != 0)
            && monitoringConfig_ != null
            && monitoringConfig_
                != com.google.cloud.gkehub.v1beta1.MonitoringConfig.getDefaultInstance()) {
          getMonitoringConfigBuilder().mergeFrom(value);
        } else {
          monitoringConfig_ = value;
        }
      } else {
        monitoringConfigBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The monitoring config information for this membership.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.MonitoringConfig monitoring_config = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearMonitoringConfig() {
      bitField0_ = (bitField0_ & ~0x00002000);
      monitoringConfig_ = null;
      if (monitoringConfigBuilder_ != null) {
        monitoringConfigBuilder_.dispose();
        monitoringConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The monitoring config information for this membership.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.MonitoringConfig monitoring_config = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.gkehub.v1beta1.MonitoringConfig.Builder getMonitoringConfigBuilder() {
      bitField0_ |= 0x00002000;
      onChanged();
      return getMonitoringConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The monitoring config information for this membership.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.MonitoringConfig monitoring_config = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.gkehub.v1beta1.MonitoringConfigOrBuilder
        getMonitoringConfigOrBuilder() {
      if (monitoringConfigBuilder_ != null) {
        return monitoringConfigBuilder_.getMessageOrBuilder();
      } else {
        return monitoringConfig_ == null
            ? com.google.cloud.gkehub.v1beta1.MonitoringConfig.getDefaultInstance()
            : monitoringConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The monitoring config information for this membership.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.MonitoringConfig monitoring_config = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gkehub.v1beta1.MonitoringConfig,
            com.google.cloud.gkehub.v1beta1.MonitoringConfig.Builder,
            com.google.cloud.gkehub.v1beta1.MonitoringConfigOrBuilder>
        getMonitoringConfigFieldBuilder() {
      if (monitoringConfigBuilder_ == null) {
        monitoringConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.gkehub.v1beta1.MonitoringConfig,
                com.google.cloud.gkehub.v1beta1.MonitoringConfig.Builder,
                com.google.cloud.gkehub.v1beta1.MonitoringConfigOrBuilder>(
                getMonitoringConfig(), getParentForChildren(), isClean());
        monitoringConfig_ = null;
      }
      return monitoringConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.gkehub.v1beta1.Membership)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.gkehub.v1beta1.Membership)
  private static final com.google.cloud.gkehub.v1beta1.Membership DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.gkehub.v1beta1.Membership();
  }

  public static com.google.cloud.gkehub.v1beta1.Membership getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Membership> PARSER =
      new com.google.protobuf.AbstractParser<Membership>() {
        @java.lang.Override
        public Membership parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Membership> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Membership> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.gkehub.v1beta1.Membership getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
