/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/gkehub/v1beta1/membership.proto

package com.google.cloud.gkehub.v1beta1;

/**
 *
 *
 * <pre>
 * MembershipEndpoint contains information needed to contact a Kubernetes API,
 * endpoint and any additional Kubernetes metadata.
 * </pre>
 *
 * Protobuf type {@code google.cloud.gkehub.v1beta1.MembershipEndpoint}
 */
public final class MembershipEndpoint extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.gkehub.v1beta1.MembershipEndpoint)
    MembershipEndpointOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use MembershipEndpoint.newBuilder() to construct.
  private MembershipEndpoint(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private MembershipEndpoint() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new MembershipEndpoint();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.gkehub.v1beta1.MembershipOuterClass
        .internal_static_google_cloud_gkehub_v1beta1_MembershipEndpoint_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.gkehub.v1beta1.MembershipOuterClass
        .internal_static_google_cloud_gkehub_v1beta1_MembershipEndpoint_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.gkehub.v1beta1.MembershipEndpoint.class,
            com.google.cloud.gkehub.v1beta1.MembershipEndpoint.Builder.class);
  }

  private int typeCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object type_;

  public enum TypeCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    GKE_CLUSTER(4),
    ON_PREM_CLUSTER(7),
    MULTI_CLOUD_CLUSTER(8),
    EDGE_CLUSTER(9),
    APPLIANCE_CLUSTER(10),
    TYPE_NOT_SET(0);
    private final int value;

    private TypeCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TypeCase valueOf(int value) {
      return forNumber(value);
    }

    public static TypeCase forNumber(int value) {
      switch (value) {
        case 4:
          return GKE_CLUSTER;
        case 7:
          return ON_PREM_CLUSTER;
        case 8:
          return MULTI_CLOUD_CLUSTER;
        case 9:
          return EDGE_CLUSTER;
        case 10:
          return APPLIANCE_CLUSTER;
        case 0:
          return TYPE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public TypeCase getTypeCase() {
    return TypeCase.forNumber(typeCase_);
  }

  public static final int GKE_CLUSTER_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Optional. Specific information for a GKE-on-GCP cluster.
   * </pre>
   *
   * <code>
   * .google.cloud.gkehub.v1beta1.GkeCluster gke_cluster = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the gkeCluster field is set.
   */
  @java.lang.Override
  public boolean hasGkeCluster() {
    return typeCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Optional. Specific information for a GKE-on-GCP cluster.
   * </pre>
   *
   * <code>
   * .google.cloud.gkehub.v1beta1.GkeCluster gke_cluster = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The gkeCluster.
   */
  @java.lang.Override
  public com.google.cloud.gkehub.v1beta1.GkeCluster getGkeCluster() {
    if (typeCase_ == 4) {
      return (com.google.cloud.gkehub.v1beta1.GkeCluster) type_;
    }
    return com.google.cloud.gkehub.v1beta1.GkeCluster.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. Specific information for a GKE-on-GCP cluster.
   * </pre>
   *
   * <code>
   * .google.cloud.gkehub.v1beta1.GkeCluster gke_cluster = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.gkehub.v1beta1.GkeClusterOrBuilder getGkeClusterOrBuilder() {
    if (typeCase_ == 4) {
      return (com.google.cloud.gkehub.v1beta1.GkeCluster) type_;
    }
    return com.google.cloud.gkehub.v1beta1.GkeCluster.getDefaultInstance();
  }

  public static final int ON_PREM_CLUSTER_FIELD_NUMBER = 7;
  /**
   *
   *
   * <pre>
   * Optional. Specific information for a GKE On-Prem cluster. An onprem
   * user-cluster who has no resourceLink is not allowed to use this field, it
   * should have a nil "type" instead.
   * </pre>
   *
   * <code>
   * .google.cloud.gkehub.v1beta1.OnPremCluster on_prem_cluster = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the onPremCluster field is set.
   */
  @java.lang.Override
  public boolean hasOnPremCluster() {
    return typeCase_ == 7;
  }
  /**
   *
   *
   * <pre>
   * Optional. Specific information for a GKE On-Prem cluster. An onprem
   * user-cluster who has no resourceLink is not allowed to use this field, it
   * should have a nil "type" instead.
   * </pre>
   *
   * <code>
   * .google.cloud.gkehub.v1beta1.OnPremCluster on_prem_cluster = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The onPremCluster.
   */
  @java.lang.Override
  public com.google.cloud.gkehub.v1beta1.OnPremCluster getOnPremCluster() {
    if (typeCase_ == 7) {
      return (com.google.cloud.gkehub.v1beta1.OnPremCluster) type_;
    }
    return com.google.cloud.gkehub.v1beta1.OnPremCluster.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. Specific information for a GKE On-Prem cluster. An onprem
   * user-cluster who has no resourceLink is not allowed to use this field, it
   * should have a nil "type" instead.
   * </pre>
   *
   * <code>
   * .google.cloud.gkehub.v1beta1.OnPremCluster on_prem_cluster = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.gkehub.v1beta1.OnPremClusterOrBuilder getOnPremClusterOrBuilder() {
    if (typeCase_ == 7) {
      return (com.google.cloud.gkehub.v1beta1.OnPremCluster) type_;
    }
    return com.google.cloud.gkehub.v1beta1.OnPremCluster.getDefaultInstance();
  }

  public static final int MULTI_CLOUD_CLUSTER_FIELD_NUMBER = 8;
  /**
   *
   *
   * <pre>
   * Optional. Specific information for a GKE Multi-Cloud cluster.
   * </pre>
   *
   * <code>
   * .google.cloud.gkehub.v1beta1.MultiCloudCluster multi_cloud_cluster = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the multiCloudCluster field is set.
   */
  @java.lang.Override
  public boolean hasMultiCloudCluster() {
    return typeCase_ == 8;
  }
  /**
   *
   *
   * <pre>
   * Optional. Specific information for a GKE Multi-Cloud cluster.
   * </pre>
   *
   * <code>
   * .google.cloud.gkehub.v1beta1.MultiCloudCluster multi_cloud_cluster = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The multiCloudCluster.
   */
  @java.lang.Override
  public com.google.cloud.gkehub.v1beta1.MultiCloudCluster getMultiCloudCluster() {
    if (typeCase_ == 8) {
      return (com.google.cloud.gkehub.v1beta1.MultiCloudCluster) type_;
    }
    return com.google.cloud.gkehub.v1beta1.MultiCloudCluster.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. Specific information for a GKE Multi-Cloud cluster.
   * </pre>
   *
   * <code>
   * .google.cloud.gkehub.v1beta1.MultiCloudCluster multi_cloud_cluster = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.gkehub.v1beta1.MultiCloudClusterOrBuilder
      getMultiCloudClusterOrBuilder() {
    if (typeCase_ == 8) {
      return (com.google.cloud.gkehub.v1beta1.MultiCloudCluster) type_;
    }
    return com.google.cloud.gkehub.v1beta1.MultiCloudCluster.getDefaultInstance();
  }

  public static final int EDGE_CLUSTER_FIELD_NUMBER = 9;
  /**
   *
   *
   * <pre>
   * Optional. Specific information for a Google Edge cluster.
   * </pre>
   *
   * <code>
   * .google.cloud.gkehub.v1beta1.EdgeCluster edge_cluster = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the edgeCluster field is set.
   */
  @java.lang.Override
  public boolean hasEdgeCluster() {
    return typeCase_ == 9;
  }
  /**
   *
   *
   * <pre>
   * Optional. Specific information for a Google Edge cluster.
   * </pre>
   *
   * <code>
   * .google.cloud.gkehub.v1beta1.EdgeCluster edge_cluster = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The edgeCluster.
   */
  @java.lang.Override
  public com.google.cloud.gkehub.v1beta1.EdgeCluster getEdgeCluster() {
    if (typeCase_ == 9) {
      return (com.google.cloud.gkehub.v1beta1.EdgeCluster) type_;
    }
    return com.google.cloud.gkehub.v1beta1.EdgeCluster.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. Specific information for a Google Edge cluster.
   * </pre>
   *
   * <code>
   * .google.cloud.gkehub.v1beta1.EdgeCluster edge_cluster = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.gkehub.v1beta1.EdgeClusterOrBuilder getEdgeClusterOrBuilder() {
    if (typeCase_ == 9) {
      return (com.google.cloud.gkehub.v1beta1.EdgeCluster) type_;
    }
    return com.google.cloud.gkehub.v1beta1.EdgeCluster.getDefaultInstance();
  }

  public static final int APPLIANCE_CLUSTER_FIELD_NUMBER = 10;
  /**
   *
   *
   * <pre>
   * Optional. Specific information for a GDC Edge Appliance cluster.
   * </pre>
   *
   * <code>
   * .google.cloud.gkehub.v1beta1.ApplianceCluster appliance_cluster = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the applianceCluster field is set.
   */
  @java.lang.Override
  public boolean hasApplianceCluster() {
    return typeCase_ == 10;
  }
  /**
   *
   *
   * <pre>
   * Optional. Specific information for a GDC Edge Appliance cluster.
   * </pre>
   *
   * <code>
   * .google.cloud.gkehub.v1beta1.ApplianceCluster appliance_cluster = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The applianceCluster.
   */
  @java.lang.Override
  public com.google.cloud.gkehub.v1beta1.ApplianceCluster getApplianceCluster() {
    if (typeCase_ == 10) {
      return (com.google.cloud.gkehub.v1beta1.ApplianceCluster) type_;
    }
    return com.google.cloud.gkehub.v1beta1.ApplianceCluster.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. Specific information for a GDC Edge Appliance cluster.
   * </pre>
   *
   * <code>
   * .google.cloud.gkehub.v1beta1.ApplianceCluster appliance_cluster = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.gkehub.v1beta1.ApplianceClusterOrBuilder getApplianceClusterOrBuilder() {
    if (typeCase_ == 10) {
      return (com.google.cloud.gkehub.v1beta1.ApplianceCluster) type_;
    }
    return com.google.cloud.gkehub.v1beta1.ApplianceCluster.getDefaultInstance();
  }

  public static final int KUBERNETES_METADATA_FIELD_NUMBER = 5;
  private com.google.cloud.gkehub.v1beta1.KubernetesMetadata kubernetesMetadata_;
  /**
   *
   *
   * <pre>
   * Output only. Useful Kubernetes-specific metadata.
   * </pre>
   *
   * <code>
   * .google.cloud.gkehub.v1beta1.KubernetesMetadata kubernetes_metadata = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the kubernetesMetadata field is set.
   */
  @java.lang.Override
  public boolean hasKubernetesMetadata() {
    return kubernetesMetadata_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Useful Kubernetes-specific metadata.
   * </pre>
   *
   * <code>
   * .google.cloud.gkehub.v1beta1.KubernetesMetadata kubernetes_metadata = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The kubernetesMetadata.
   */
  @java.lang.Override
  public com.google.cloud.gkehub.v1beta1.KubernetesMetadata getKubernetesMetadata() {
    return kubernetesMetadata_ == null
        ? com.google.cloud.gkehub.v1beta1.KubernetesMetadata.getDefaultInstance()
        : kubernetesMetadata_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Useful Kubernetes-specific metadata.
   * </pre>
   *
   * <code>
   * .google.cloud.gkehub.v1beta1.KubernetesMetadata kubernetes_metadata = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.gkehub.v1beta1.KubernetesMetadataOrBuilder
      getKubernetesMetadataOrBuilder() {
    return kubernetesMetadata_ == null
        ? com.google.cloud.gkehub.v1beta1.KubernetesMetadata.getDefaultInstance()
        : kubernetesMetadata_;
  }

  public static final int KUBERNETES_RESOURCE_FIELD_NUMBER = 6;
  private com.google.cloud.gkehub.v1beta1.KubernetesResource kubernetesResource_;
  /**
   *
   *
   * <pre>
   * Optional. The in-cluster Kubernetes Resources that should be applied for a
   * correctly registered cluster, in the steady state. These resources:
   *
   *   * Ensure that the cluster is exclusively registered to one and only one
   *     Hub Membership.
   *   * Propagate Workload Pool Information available in the Membership
   *     Authority field.
   *   * Ensure proper initial configuration of default Hub Features.
   * </pre>
   *
   * <code>
   * .google.cloud.gkehub.v1beta1.KubernetesResource kubernetes_resource = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the kubernetesResource field is set.
   */
  @java.lang.Override
  public boolean hasKubernetesResource() {
    return kubernetesResource_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. The in-cluster Kubernetes Resources that should be applied for a
   * correctly registered cluster, in the steady state. These resources:
   *
   *   * Ensure that the cluster is exclusively registered to one and only one
   *     Hub Membership.
   *   * Propagate Workload Pool Information available in the Membership
   *     Authority field.
   *   * Ensure proper initial configuration of default Hub Features.
   * </pre>
   *
   * <code>
   * .google.cloud.gkehub.v1beta1.KubernetesResource kubernetes_resource = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The kubernetesResource.
   */
  @java.lang.Override
  public com.google.cloud.gkehub.v1beta1.KubernetesResource getKubernetesResource() {
    return kubernetesResource_ == null
        ? com.google.cloud.gkehub.v1beta1.KubernetesResource.getDefaultInstance()
        : kubernetesResource_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The in-cluster Kubernetes Resources that should be applied for a
   * correctly registered cluster, in the steady state. These resources:
   *
   *   * Ensure that the cluster is exclusively registered to one and only one
   *     Hub Membership.
   *   * Propagate Workload Pool Information available in the Membership
   *     Authority field.
   *   * Ensure proper initial configuration of default Hub Features.
   * </pre>
   *
   * <code>
   * .google.cloud.gkehub.v1beta1.KubernetesResource kubernetes_resource = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.gkehub.v1beta1.KubernetesResourceOrBuilder
      getKubernetesResourceOrBuilder() {
    return kubernetesResource_ == null
        ? com.google.cloud.gkehub.v1beta1.KubernetesResource.getDefaultInstance()
        : kubernetesResource_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (typeCase_ == 4) {
      output.writeMessage(4, (com.google.cloud.gkehub.v1beta1.GkeCluster) type_);
    }
    if (kubernetesMetadata_ != null) {
      output.writeMessage(5, getKubernetesMetadata());
    }
    if (kubernetesResource_ != null) {
      output.writeMessage(6, getKubernetesResource());
    }
    if (typeCase_ == 7) {
      output.writeMessage(7, (com.google.cloud.gkehub.v1beta1.OnPremCluster) type_);
    }
    if (typeCase_ == 8) {
      output.writeMessage(8, (com.google.cloud.gkehub.v1beta1.MultiCloudCluster) type_);
    }
    if (typeCase_ == 9) {
      output.writeMessage(9, (com.google.cloud.gkehub.v1beta1.EdgeCluster) type_);
    }
    if (typeCase_ == 10) {
      output.writeMessage(10, (com.google.cloud.gkehub.v1beta1.ApplianceCluster) type_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (typeCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.cloud.gkehub.v1beta1.GkeCluster) type_);
    }
    if (kubernetesMetadata_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getKubernetesMetadata());
    }
    if (kubernetesResource_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getKubernetesResource());
    }
    if (typeCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, (com.google.cloud.gkehub.v1beta1.OnPremCluster) type_);
    }
    if (typeCase_ == 8) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              8, (com.google.cloud.gkehub.v1beta1.MultiCloudCluster) type_);
    }
    if (typeCase_ == 9) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              9, (com.google.cloud.gkehub.v1beta1.EdgeCluster) type_);
    }
    if (typeCase_ == 10) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              10, (com.google.cloud.gkehub.v1beta1.ApplianceCluster) type_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.gkehub.v1beta1.MembershipEndpoint)) {
      return super.equals(obj);
    }
    com.google.cloud.gkehub.v1beta1.MembershipEndpoint other =
        (com.google.cloud.gkehub.v1beta1.MembershipEndpoint) obj;

    if (hasKubernetesMetadata() != other.hasKubernetesMetadata()) return false;
    if (hasKubernetesMetadata()) {
      if (!getKubernetesMetadata().equals(other.getKubernetesMetadata())) return false;
    }
    if (hasKubernetesResource() != other.hasKubernetesResource()) return false;
    if (hasKubernetesResource()) {
      if (!getKubernetesResource().equals(other.getKubernetesResource())) return false;
    }
    if (!getTypeCase().equals(other.getTypeCase())) return false;
    switch (typeCase_) {
      case 4:
        if (!getGkeCluster().equals(other.getGkeCluster())) return false;
        break;
      case 7:
        if (!getOnPremCluster().equals(other.getOnPremCluster())) return false;
        break;
      case 8:
        if (!getMultiCloudCluster().equals(other.getMultiCloudCluster())) return false;
        break;
      case 9:
        if (!getEdgeCluster().equals(other.getEdgeCluster())) return false;
        break;
      case 10:
        if (!getApplianceCluster().equals(other.getApplianceCluster())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasKubernetesMetadata()) {
      hash = (37 * hash) + KUBERNETES_METADATA_FIELD_NUMBER;
      hash = (53 * hash) + getKubernetesMetadata().hashCode();
    }
    if (hasKubernetesResource()) {
      hash = (37 * hash) + KUBERNETES_RESOURCE_FIELD_NUMBER;
      hash = (53 * hash) + getKubernetesResource().hashCode();
    }
    switch (typeCase_) {
      case 4:
        hash = (37 * hash) + GKE_CLUSTER_FIELD_NUMBER;
        hash = (53 * hash) + getGkeCluster().hashCode();
        break;
      case 7:
        hash = (37 * hash) + ON_PREM_CLUSTER_FIELD_NUMBER;
        hash = (53 * hash) + getOnPremCluster().hashCode();
        break;
      case 8:
        hash = (37 * hash) + MULTI_CLOUD_CLUSTER_FIELD_NUMBER;
        hash = (53 * hash) + getMultiCloudCluster().hashCode();
        break;
      case 9:
        hash = (37 * hash) + EDGE_CLUSTER_FIELD_NUMBER;
        hash = (53 * hash) + getEdgeCluster().hashCode();
        break;
      case 10:
        hash = (37 * hash) + APPLIANCE_CLUSTER_FIELD_NUMBER;
        hash = (53 * hash) + getApplianceCluster().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.gkehub.v1beta1.MembershipEndpoint parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gkehub.v1beta1.MembershipEndpoint parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gkehub.v1beta1.MembershipEndpoint parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gkehub.v1beta1.MembershipEndpoint parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gkehub.v1beta1.MembershipEndpoint parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gkehub.v1beta1.MembershipEndpoint parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gkehub.v1beta1.MembershipEndpoint parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.gkehub.v1beta1.MembershipEndpoint parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.gkehub.v1beta1.MembershipEndpoint parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.gkehub.v1beta1.MembershipEndpoint parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.gkehub.v1beta1.MembershipEndpoint parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.gkehub.v1beta1.MembershipEndpoint parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.gkehub.v1beta1.MembershipEndpoint prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * MembershipEndpoint contains information needed to contact a Kubernetes API,
   * endpoint and any additional Kubernetes metadata.
   * </pre>
   *
   * Protobuf type {@code google.cloud.gkehub.v1beta1.MembershipEndpoint}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.gkehub.v1beta1.MembershipEndpoint)
      com.google.cloud.gkehub.v1beta1.MembershipEndpointOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.gkehub.v1beta1.MembershipOuterClass
          .internal_static_google_cloud_gkehub_v1beta1_MembershipEndpoint_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.gkehub.v1beta1.MembershipOuterClass
          .internal_static_google_cloud_gkehub_v1beta1_MembershipEndpoint_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.gkehub.v1beta1.MembershipEndpoint.class,
              com.google.cloud.gkehub.v1beta1.MembershipEndpoint.Builder.class);
    }

    // Construct using com.google.cloud.gkehub.v1beta1.MembershipEndpoint.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (gkeClusterBuilder_ != null) {
        gkeClusterBuilder_.clear();
      }
      if (onPremClusterBuilder_ != null) {
        onPremClusterBuilder_.clear();
      }
      if (multiCloudClusterBuilder_ != null) {
        multiCloudClusterBuilder_.clear();
      }
      if (edgeClusterBuilder_ != null) {
        edgeClusterBuilder_.clear();
      }
      if (applianceClusterBuilder_ != null) {
        applianceClusterBuilder_.clear();
      }
      kubernetesMetadata_ = null;
      if (kubernetesMetadataBuilder_ != null) {
        kubernetesMetadataBuilder_.dispose();
        kubernetesMetadataBuilder_ = null;
      }
      kubernetesResource_ = null;
      if (kubernetesResourceBuilder_ != null) {
        kubernetesResourceBuilder_.dispose();
        kubernetesResourceBuilder_ = null;
      }
      typeCase_ = 0;
      type_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.gkehub.v1beta1.MembershipOuterClass
          .internal_static_google_cloud_gkehub_v1beta1_MembershipEndpoint_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.gkehub.v1beta1.MembershipEndpoint getDefaultInstanceForType() {
      return com.google.cloud.gkehub.v1beta1.MembershipEndpoint.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.gkehub.v1beta1.MembershipEndpoint build() {
      com.google.cloud.gkehub.v1beta1.MembershipEndpoint result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.gkehub.v1beta1.MembershipEndpoint buildPartial() {
      com.google.cloud.gkehub.v1beta1.MembershipEndpoint result =
          new com.google.cloud.gkehub.v1beta1.MembershipEndpoint(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.gkehub.v1beta1.MembershipEndpoint result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.kubernetesMetadata_ =
            kubernetesMetadataBuilder_ == null
                ? kubernetesMetadata_
                : kubernetesMetadataBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.kubernetesResource_ =
            kubernetesResourceBuilder_ == null
                ? kubernetesResource_
                : kubernetesResourceBuilder_.build();
      }
    }

    private void buildPartialOneofs(com.google.cloud.gkehub.v1beta1.MembershipEndpoint result) {
      result.typeCase_ = typeCase_;
      result.type_ = this.type_;
      if (typeCase_ == 4 && gkeClusterBuilder_ != null) {
        result.type_ = gkeClusterBuilder_.build();
      }
      if (typeCase_ == 7 && onPremClusterBuilder_ != null) {
        result.type_ = onPremClusterBuilder_.build();
      }
      if (typeCase_ == 8 && multiCloudClusterBuilder_ != null) {
        result.type_ = multiCloudClusterBuilder_.build();
      }
      if (typeCase_ == 9 && edgeClusterBuilder_ != null) {
        result.type_ = edgeClusterBuilder_.build();
      }
      if (typeCase_ == 10 && applianceClusterBuilder_ != null) {
        result.type_ = applianceClusterBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.gkehub.v1beta1.MembershipEndpoint) {
        return mergeFrom((com.google.cloud.gkehub.v1beta1.MembershipEndpoint) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.gkehub.v1beta1.MembershipEndpoint other) {
      if (other == com.google.cloud.gkehub.v1beta1.MembershipEndpoint.getDefaultInstance())
        return this;
      if (other.hasKubernetesMetadata()) {
        mergeKubernetesMetadata(other.getKubernetesMetadata());
      }
      if (other.hasKubernetesResource()) {
        mergeKubernetesResource(other.getKubernetesResource());
      }
      switch (other.getTypeCase()) {
        case GKE_CLUSTER:
          {
            mergeGkeCluster(other.getGkeCluster());
            break;
          }
        case ON_PREM_CLUSTER:
          {
            mergeOnPremCluster(other.getOnPremCluster());
            break;
          }
        case MULTI_CLOUD_CLUSTER:
          {
            mergeMultiCloudCluster(other.getMultiCloudCluster());
            break;
          }
        case EDGE_CLUSTER:
          {
            mergeEdgeCluster(other.getEdgeCluster());
            break;
          }
        case APPLIANCE_CLUSTER:
          {
            mergeApplianceCluster(other.getApplianceCluster());
            break;
          }
        case TYPE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 34:
              {
                input.readMessage(getGkeClusterFieldBuilder().getBuilder(), extensionRegistry);
                typeCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(
                    getKubernetesMetadataFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(
                    getKubernetesResourceFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getOnPremClusterFieldBuilder().getBuilder(), extensionRegistry);
                typeCase_ = 7;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(
                    getMultiCloudClusterFieldBuilder().getBuilder(), extensionRegistry);
                typeCase_ = 8;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(getEdgeClusterFieldBuilder().getBuilder(), extensionRegistry);
                typeCase_ = 9;
                break;
              } // case 74
            case 82:
              {
                input.readMessage(
                    getApplianceClusterFieldBuilder().getBuilder(), extensionRegistry);
                typeCase_ = 10;
                break;
              } // case 82
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int typeCase_ = 0;
    private java.lang.Object type_;

    public TypeCase getTypeCase() {
      return TypeCase.forNumber(typeCase_);
    }

    public Builder clearType() {
      typeCase_ = 0;
      type_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gkehub.v1beta1.GkeCluster,
            com.google.cloud.gkehub.v1beta1.GkeCluster.Builder,
            com.google.cloud.gkehub.v1beta1.GkeClusterOrBuilder>
        gkeClusterBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Specific information for a GKE-on-GCP cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.GkeCluster gke_cluster = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the gkeCluster field is set.
     */
    @java.lang.Override
    public boolean hasGkeCluster() {
      return typeCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specific information for a GKE-on-GCP cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.GkeCluster gke_cluster = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The gkeCluster.
     */
    @java.lang.Override
    public com.google.cloud.gkehub.v1beta1.GkeCluster getGkeCluster() {
      if (gkeClusterBuilder_ == null) {
        if (typeCase_ == 4) {
          return (com.google.cloud.gkehub.v1beta1.GkeCluster) type_;
        }
        return com.google.cloud.gkehub.v1beta1.GkeCluster.getDefaultInstance();
      } else {
        if (typeCase_ == 4) {
          return gkeClusterBuilder_.getMessage();
        }
        return com.google.cloud.gkehub.v1beta1.GkeCluster.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Specific information for a GKE-on-GCP cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.GkeCluster gke_cluster = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setGkeCluster(com.google.cloud.gkehub.v1beta1.GkeCluster value) {
      if (gkeClusterBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        type_ = value;
        onChanged();
      } else {
        gkeClusterBuilder_.setMessage(value);
      }
      typeCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specific information for a GKE-on-GCP cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.GkeCluster gke_cluster = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setGkeCluster(
        com.google.cloud.gkehub.v1beta1.GkeCluster.Builder builderForValue) {
      if (gkeClusterBuilder_ == null) {
        type_ = builderForValue.build();
        onChanged();
      } else {
        gkeClusterBuilder_.setMessage(builderForValue.build());
      }
      typeCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specific information for a GKE-on-GCP cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.GkeCluster gke_cluster = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeGkeCluster(com.google.cloud.gkehub.v1beta1.GkeCluster value) {
      if (gkeClusterBuilder_ == null) {
        if (typeCase_ == 4
            && type_ != com.google.cloud.gkehub.v1beta1.GkeCluster.getDefaultInstance()) {
          type_ =
              com.google.cloud.gkehub.v1beta1.GkeCluster.newBuilder(
                      (com.google.cloud.gkehub.v1beta1.GkeCluster) type_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          type_ = value;
        }
        onChanged();
      } else {
        if (typeCase_ == 4) {
          gkeClusterBuilder_.mergeFrom(value);
        } else {
          gkeClusterBuilder_.setMessage(value);
        }
      }
      typeCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specific information for a GKE-on-GCP cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.GkeCluster gke_cluster = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearGkeCluster() {
      if (gkeClusterBuilder_ == null) {
        if (typeCase_ == 4) {
          typeCase_ = 0;
          type_ = null;
          onChanged();
        }
      } else {
        if (typeCase_ == 4) {
          typeCase_ = 0;
          type_ = null;
        }
        gkeClusterBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specific information for a GKE-on-GCP cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.GkeCluster gke_cluster = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.gkehub.v1beta1.GkeCluster.Builder getGkeClusterBuilder() {
      return getGkeClusterFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Specific information for a GKE-on-GCP cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.GkeCluster gke_cluster = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.gkehub.v1beta1.GkeClusterOrBuilder getGkeClusterOrBuilder() {
      if ((typeCase_ == 4) && (gkeClusterBuilder_ != null)) {
        return gkeClusterBuilder_.getMessageOrBuilder();
      } else {
        if (typeCase_ == 4) {
          return (com.google.cloud.gkehub.v1beta1.GkeCluster) type_;
        }
        return com.google.cloud.gkehub.v1beta1.GkeCluster.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Specific information for a GKE-on-GCP cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.GkeCluster gke_cluster = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gkehub.v1beta1.GkeCluster,
            com.google.cloud.gkehub.v1beta1.GkeCluster.Builder,
            com.google.cloud.gkehub.v1beta1.GkeClusterOrBuilder>
        getGkeClusterFieldBuilder() {
      if (gkeClusterBuilder_ == null) {
        if (!(typeCase_ == 4)) {
          type_ = com.google.cloud.gkehub.v1beta1.GkeCluster.getDefaultInstance();
        }
        gkeClusterBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.gkehub.v1beta1.GkeCluster,
                com.google.cloud.gkehub.v1beta1.GkeCluster.Builder,
                com.google.cloud.gkehub.v1beta1.GkeClusterOrBuilder>(
                (com.google.cloud.gkehub.v1beta1.GkeCluster) type_,
                getParentForChildren(),
                isClean());
        type_ = null;
      }
      typeCase_ = 4;
      onChanged();
      return gkeClusterBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gkehub.v1beta1.OnPremCluster,
            com.google.cloud.gkehub.v1beta1.OnPremCluster.Builder,
            com.google.cloud.gkehub.v1beta1.OnPremClusterOrBuilder>
        onPremClusterBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Specific information for a GKE On-Prem cluster. An onprem
     * user-cluster who has no resourceLink is not allowed to use this field, it
     * should have a nil "type" instead.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.OnPremCluster on_prem_cluster = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the onPremCluster field is set.
     */
    @java.lang.Override
    public boolean hasOnPremCluster() {
      return typeCase_ == 7;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specific information for a GKE On-Prem cluster. An onprem
     * user-cluster who has no resourceLink is not allowed to use this field, it
     * should have a nil "type" instead.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.OnPremCluster on_prem_cluster = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The onPremCluster.
     */
    @java.lang.Override
    public com.google.cloud.gkehub.v1beta1.OnPremCluster getOnPremCluster() {
      if (onPremClusterBuilder_ == null) {
        if (typeCase_ == 7) {
          return (com.google.cloud.gkehub.v1beta1.OnPremCluster) type_;
        }
        return com.google.cloud.gkehub.v1beta1.OnPremCluster.getDefaultInstance();
      } else {
        if (typeCase_ == 7) {
          return onPremClusterBuilder_.getMessage();
        }
        return com.google.cloud.gkehub.v1beta1.OnPremCluster.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Specific information for a GKE On-Prem cluster. An onprem
     * user-cluster who has no resourceLink is not allowed to use this field, it
     * should have a nil "type" instead.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.OnPremCluster on_prem_cluster = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setOnPremCluster(com.google.cloud.gkehub.v1beta1.OnPremCluster value) {
      if (onPremClusterBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        type_ = value;
        onChanged();
      } else {
        onPremClusterBuilder_.setMessage(value);
      }
      typeCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specific information for a GKE On-Prem cluster. An onprem
     * user-cluster who has no resourceLink is not allowed to use this field, it
     * should have a nil "type" instead.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.OnPremCluster on_prem_cluster = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setOnPremCluster(
        com.google.cloud.gkehub.v1beta1.OnPremCluster.Builder builderForValue) {
      if (onPremClusterBuilder_ == null) {
        type_ = builderForValue.build();
        onChanged();
      } else {
        onPremClusterBuilder_.setMessage(builderForValue.build());
      }
      typeCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specific information for a GKE On-Prem cluster. An onprem
     * user-cluster who has no resourceLink is not allowed to use this field, it
     * should have a nil "type" instead.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.OnPremCluster on_prem_cluster = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeOnPremCluster(com.google.cloud.gkehub.v1beta1.OnPremCluster value) {
      if (onPremClusterBuilder_ == null) {
        if (typeCase_ == 7
            && type_ != com.google.cloud.gkehub.v1beta1.OnPremCluster.getDefaultInstance()) {
          type_ =
              com.google.cloud.gkehub.v1beta1.OnPremCluster.newBuilder(
                      (com.google.cloud.gkehub.v1beta1.OnPremCluster) type_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          type_ = value;
        }
        onChanged();
      } else {
        if (typeCase_ == 7) {
          onPremClusterBuilder_.mergeFrom(value);
        } else {
          onPremClusterBuilder_.setMessage(value);
        }
      }
      typeCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specific information for a GKE On-Prem cluster. An onprem
     * user-cluster who has no resourceLink is not allowed to use this field, it
     * should have a nil "type" instead.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.OnPremCluster on_prem_cluster = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearOnPremCluster() {
      if (onPremClusterBuilder_ == null) {
        if (typeCase_ == 7) {
          typeCase_ = 0;
          type_ = null;
          onChanged();
        }
      } else {
        if (typeCase_ == 7) {
          typeCase_ = 0;
          type_ = null;
        }
        onPremClusterBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specific information for a GKE On-Prem cluster. An onprem
     * user-cluster who has no resourceLink is not allowed to use this field, it
     * should have a nil "type" instead.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.OnPremCluster on_prem_cluster = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.gkehub.v1beta1.OnPremCluster.Builder getOnPremClusterBuilder() {
      return getOnPremClusterFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Specific information for a GKE On-Prem cluster. An onprem
     * user-cluster who has no resourceLink is not allowed to use this field, it
     * should have a nil "type" instead.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.OnPremCluster on_prem_cluster = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.gkehub.v1beta1.OnPremClusterOrBuilder getOnPremClusterOrBuilder() {
      if ((typeCase_ == 7) && (onPremClusterBuilder_ != null)) {
        return onPremClusterBuilder_.getMessageOrBuilder();
      } else {
        if (typeCase_ == 7) {
          return (com.google.cloud.gkehub.v1beta1.OnPremCluster) type_;
        }
        return com.google.cloud.gkehub.v1beta1.OnPremCluster.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Specific information for a GKE On-Prem cluster. An onprem
     * user-cluster who has no resourceLink is not allowed to use this field, it
     * should have a nil "type" instead.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.OnPremCluster on_prem_cluster = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gkehub.v1beta1.OnPremCluster,
            com.google.cloud.gkehub.v1beta1.OnPremCluster.Builder,
            com.google.cloud.gkehub.v1beta1.OnPremClusterOrBuilder>
        getOnPremClusterFieldBuilder() {
      if (onPremClusterBuilder_ == null) {
        if (!(typeCase_ == 7)) {
          type_ = com.google.cloud.gkehub.v1beta1.OnPremCluster.getDefaultInstance();
        }
        onPremClusterBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.gkehub.v1beta1.OnPremCluster,
                com.google.cloud.gkehub.v1beta1.OnPremCluster.Builder,
                com.google.cloud.gkehub.v1beta1.OnPremClusterOrBuilder>(
                (com.google.cloud.gkehub.v1beta1.OnPremCluster) type_,
                getParentForChildren(),
                isClean());
        type_ = null;
      }
      typeCase_ = 7;
      onChanged();
      return onPremClusterBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gkehub.v1beta1.MultiCloudCluster,
            com.google.cloud.gkehub.v1beta1.MultiCloudCluster.Builder,
            com.google.cloud.gkehub.v1beta1.MultiCloudClusterOrBuilder>
        multiCloudClusterBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Specific information for a GKE Multi-Cloud cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.MultiCloudCluster multi_cloud_cluster = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the multiCloudCluster field is set.
     */
    @java.lang.Override
    public boolean hasMultiCloudCluster() {
      return typeCase_ == 8;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specific information for a GKE Multi-Cloud cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.MultiCloudCluster multi_cloud_cluster = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The multiCloudCluster.
     */
    @java.lang.Override
    public com.google.cloud.gkehub.v1beta1.MultiCloudCluster getMultiCloudCluster() {
      if (multiCloudClusterBuilder_ == null) {
        if (typeCase_ == 8) {
          return (com.google.cloud.gkehub.v1beta1.MultiCloudCluster) type_;
        }
        return com.google.cloud.gkehub.v1beta1.MultiCloudCluster.getDefaultInstance();
      } else {
        if (typeCase_ == 8) {
          return multiCloudClusterBuilder_.getMessage();
        }
        return com.google.cloud.gkehub.v1beta1.MultiCloudCluster.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Specific information for a GKE Multi-Cloud cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.MultiCloudCluster multi_cloud_cluster = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setMultiCloudCluster(com.google.cloud.gkehub.v1beta1.MultiCloudCluster value) {
      if (multiCloudClusterBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        type_ = value;
        onChanged();
      } else {
        multiCloudClusterBuilder_.setMessage(value);
      }
      typeCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specific information for a GKE Multi-Cloud cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.MultiCloudCluster multi_cloud_cluster = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setMultiCloudCluster(
        com.google.cloud.gkehub.v1beta1.MultiCloudCluster.Builder builderForValue) {
      if (multiCloudClusterBuilder_ == null) {
        type_ = builderForValue.build();
        onChanged();
      } else {
        multiCloudClusterBuilder_.setMessage(builderForValue.build());
      }
      typeCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specific information for a GKE Multi-Cloud cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.MultiCloudCluster multi_cloud_cluster = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeMultiCloudCluster(com.google.cloud.gkehub.v1beta1.MultiCloudCluster value) {
      if (multiCloudClusterBuilder_ == null) {
        if (typeCase_ == 8
            && type_ != com.google.cloud.gkehub.v1beta1.MultiCloudCluster.getDefaultInstance()) {
          type_ =
              com.google.cloud.gkehub.v1beta1.MultiCloudCluster.newBuilder(
                      (com.google.cloud.gkehub.v1beta1.MultiCloudCluster) type_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          type_ = value;
        }
        onChanged();
      } else {
        if (typeCase_ == 8) {
          multiCloudClusterBuilder_.mergeFrom(value);
        } else {
          multiCloudClusterBuilder_.setMessage(value);
        }
      }
      typeCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specific information for a GKE Multi-Cloud cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.MultiCloudCluster multi_cloud_cluster = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearMultiCloudCluster() {
      if (multiCloudClusterBuilder_ == null) {
        if (typeCase_ == 8) {
          typeCase_ = 0;
          type_ = null;
          onChanged();
        }
      } else {
        if (typeCase_ == 8) {
          typeCase_ = 0;
          type_ = null;
        }
        multiCloudClusterBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specific information for a GKE Multi-Cloud cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.MultiCloudCluster multi_cloud_cluster = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.gkehub.v1beta1.MultiCloudCluster.Builder getMultiCloudClusterBuilder() {
      return getMultiCloudClusterFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Specific information for a GKE Multi-Cloud cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.MultiCloudCluster multi_cloud_cluster = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.gkehub.v1beta1.MultiCloudClusterOrBuilder
        getMultiCloudClusterOrBuilder() {
      if ((typeCase_ == 8) && (multiCloudClusterBuilder_ != null)) {
        return multiCloudClusterBuilder_.getMessageOrBuilder();
      } else {
        if (typeCase_ == 8) {
          return (com.google.cloud.gkehub.v1beta1.MultiCloudCluster) type_;
        }
        return com.google.cloud.gkehub.v1beta1.MultiCloudCluster.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Specific information for a GKE Multi-Cloud cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.MultiCloudCluster multi_cloud_cluster = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gkehub.v1beta1.MultiCloudCluster,
            com.google.cloud.gkehub.v1beta1.MultiCloudCluster.Builder,
            com.google.cloud.gkehub.v1beta1.MultiCloudClusterOrBuilder>
        getMultiCloudClusterFieldBuilder() {
      if (multiCloudClusterBuilder_ == null) {
        if (!(typeCase_ == 8)) {
          type_ = com.google.cloud.gkehub.v1beta1.MultiCloudCluster.getDefaultInstance();
        }
        multiCloudClusterBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.gkehub.v1beta1.MultiCloudCluster,
                com.google.cloud.gkehub.v1beta1.MultiCloudCluster.Builder,
                com.google.cloud.gkehub.v1beta1.MultiCloudClusterOrBuilder>(
                (com.google.cloud.gkehub.v1beta1.MultiCloudCluster) type_,
                getParentForChildren(),
                isClean());
        type_ = null;
      }
      typeCase_ = 8;
      onChanged();
      return multiCloudClusterBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gkehub.v1beta1.EdgeCluster,
            com.google.cloud.gkehub.v1beta1.EdgeCluster.Builder,
            com.google.cloud.gkehub.v1beta1.EdgeClusterOrBuilder>
        edgeClusterBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Specific information for a Google Edge cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.EdgeCluster edge_cluster = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the edgeCluster field is set.
     */
    @java.lang.Override
    public boolean hasEdgeCluster() {
      return typeCase_ == 9;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specific information for a Google Edge cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.EdgeCluster edge_cluster = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The edgeCluster.
     */
    @java.lang.Override
    public com.google.cloud.gkehub.v1beta1.EdgeCluster getEdgeCluster() {
      if (edgeClusterBuilder_ == null) {
        if (typeCase_ == 9) {
          return (com.google.cloud.gkehub.v1beta1.EdgeCluster) type_;
        }
        return com.google.cloud.gkehub.v1beta1.EdgeCluster.getDefaultInstance();
      } else {
        if (typeCase_ == 9) {
          return edgeClusterBuilder_.getMessage();
        }
        return com.google.cloud.gkehub.v1beta1.EdgeCluster.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Specific information for a Google Edge cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.EdgeCluster edge_cluster = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setEdgeCluster(com.google.cloud.gkehub.v1beta1.EdgeCluster value) {
      if (edgeClusterBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        type_ = value;
        onChanged();
      } else {
        edgeClusterBuilder_.setMessage(value);
      }
      typeCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specific information for a Google Edge cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.EdgeCluster edge_cluster = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setEdgeCluster(
        com.google.cloud.gkehub.v1beta1.EdgeCluster.Builder builderForValue) {
      if (edgeClusterBuilder_ == null) {
        type_ = builderForValue.build();
        onChanged();
      } else {
        edgeClusterBuilder_.setMessage(builderForValue.build());
      }
      typeCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specific information for a Google Edge cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.EdgeCluster edge_cluster = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeEdgeCluster(com.google.cloud.gkehub.v1beta1.EdgeCluster value) {
      if (edgeClusterBuilder_ == null) {
        if (typeCase_ == 9
            && type_ != com.google.cloud.gkehub.v1beta1.EdgeCluster.getDefaultInstance()) {
          type_ =
              com.google.cloud.gkehub.v1beta1.EdgeCluster.newBuilder(
                      (com.google.cloud.gkehub.v1beta1.EdgeCluster) type_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          type_ = value;
        }
        onChanged();
      } else {
        if (typeCase_ == 9) {
          edgeClusterBuilder_.mergeFrom(value);
        } else {
          edgeClusterBuilder_.setMessage(value);
        }
      }
      typeCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specific information for a Google Edge cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.EdgeCluster edge_cluster = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearEdgeCluster() {
      if (edgeClusterBuilder_ == null) {
        if (typeCase_ == 9) {
          typeCase_ = 0;
          type_ = null;
          onChanged();
        }
      } else {
        if (typeCase_ == 9) {
          typeCase_ = 0;
          type_ = null;
        }
        edgeClusterBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specific information for a Google Edge cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.EdgeCluster edge_cluster = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.gkehub.v1beta1.EdgeCluster.Builder getEdgeClusterBuilder() {
      return getEdgeClusterFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Specific information for a Google Edge cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.EdgeCluster edge_cluster = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.gkehub.v1beta1.EdgeClusterOrBuilder getEdgeClusterOrBuilder() {
      if ((typeCase_ == 9) && (edgeClusterBuilder_ != null)) {
        return edgeClusterBuilder_.getMessageOrBuilder();
      } else {
        if (typeCase_ == 9) {
          return (com.google.cloud.gkehub.v1beta1.EdgeCluster) type_;
        }
        return com.google.cloud.gkehub.v1beta1.EdgeCluster.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Specific information for a Google Edge cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.EdgeCluster edge_cluster = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gkehub.v1beta1.EdgeCluster,
            com.google.cloud.gkehub.v1beta1.EdgeCluster.Builder,
            com.google.cloud.gkehub.v1beta1.EdgeClusterOrBuilder>
        getEdgeClusterFieldBuilder() {
      if (edgeClusterBuilder_ == null) {
        if (!(typeCase_ == 9)) {
          type_ = com.google.cloud.gkehub.v1beta1.EdgeCluster.getDefaultInstance();
        }
        edgeClusterBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.gkehub.v1beta1.EdgeCluster,
                com.google.cloud.gkehub.v1beta1.EdgeCluster.Builder,
                com.google.cloud.gkehub.v1beta1.EdgeClusterOrBuilder>(
                (com.google.cloud.gkehub.v1beta1.EdgeCluster) type_,
                getParentForChildren(),
                isClean());
        type_ = null;
      }
      typeCase_ = 9;
      onChanged();
      return edgeClusterBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gkehub.v1beta1.ApplianceCluster,
            com.google.cloud.gkehub.v1beta1.ApplianceCluster.Builder,
            com.google.cloud.gkehub.v1beta1.ApplianceClusterOrBuilder>
        applianceClusterBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Specific information for a GDC Edge Appliance cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.ApplianceCluster appliance_cluster = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the applianceCluster field is set.
     */
    @java.lang.Override
    public boolean hasApplianceCluster() {
      return typeCase_ == 10;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specific information for a GDC Edge Appliance cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.ApplianceCluster appliance_cluster = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The applianceCluster.
     */
    @java.lang.Override
    public com.google.cloud.gkehub.v1beta1.ApplianceCluster getApplianceCluster() {
      if (applianceClusterBuilder_ == null) {
        if (typeCase_ == 10) {
          return (com.google.cloud.gkehub.v1beta1.ApplianceCluster) type_;
        }
        return com.google.cloud.gkehub.v1beta1.ApplianceCluster.getDefaultInstance();
      } else {
        if (typeCase_ == 10) {
          return applianceClusterBuilder_.getMessage();
        }
        return com.google.cloud.gkehub.v1beta1.ApplianceCluster.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Specific information for a GDC Edge Appliance cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.ApplianceCluster appliance_cluster = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setApplianceCluster(com.google.cloud.gkehub.v1beta1.ApplianceCluster value) {
      if (applianceClusterBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        type_ = value;
        onChanged();
      } else {
        applianceClusterBuilder_.setMessage(value);
      }
      typeCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specific information for a GDC Edge Appliance cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.ApplianceCluster appliance_cluster = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setApplianceCluster(
        com.google.cloud.gkehub.v1beta1.ApplianceCluster.Builder builderForValue) {
      if (applianceClusterBuilder_ == null) {
        type_ = builderForValue.build();
        onChanged();
      } else {
        applianceClusterBuilder_.setMessage(builderForValue.build());
      }
      typeCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specific information for a GDC Edge Appliance cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.ApplianceCluster appliance_cluster = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeApplianceCluster(com.google.cloud.gkehub.v1beta1.ApplianceCluster value) {
      if (applianceClusterBuilder_ == null) {
        if (typeCase_ == 10
            && type_ != com.google.cloud.gkehub.v1beta1.ApplianceCluster.getDefaultInstance()) {
          type_ =
              com.google.cloud.gkehub.v1beta1.ApplianceCluster.newBuilder(
                      (com.google.cloud.gkehub.v1beta1.ApplianceCluster) type_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          type_ = value;
        }
        onChanged();
      } else {
        if (typeCase_ == 10) {
          applianceClusterBuilder_.mergeFrom(value);
        } else {
          applianceClusterBuilder_.setMessage(value);
        }
      }
      typeCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specific information for a GDC Edge Appliance cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.ApplianceCluster appliance_cluster = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearApplianceCluster() {
      if (applianceClusterBuilder_ == null) {
        if (typeCase_ == 10) {
          typeCase_ = 0;
          type_ = null;
          onChanged();
        }
      } else {
        if (typeCase_ == 10) {
          typeCase_ = 0;
          type_ = null;
        }
        applianceClusterBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specific information for a GDC Edge Appliance cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.ApplianceCluster appliance_cluster = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.gkehub.v1beta1.ApplianceCluster.Builder getApplianceClusterBuilder() {
      return getApplianceClusterFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Specific information for a GDC Edge Appliance cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.ApplianceCluster appliance_cluster = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.gkehub.v1beta1.ApplianceClusterOrBuilder
        getApplianceClusterOrBuilder() {
      if ((typeCase_ == 10) && (applianceClusterBuilder_ != null)) {
        return applianceClusterBuilder_.getMessageOrBuilder();
      } else {
        if (typeCase_ == 10) {
          return (com.google.cloud.gkehub.v1beta1.ApplianceCluster) type_;
        }
        return com.google.cloud.gkehub.v1beta1.ApplianceCluster.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Specific information for a GDC Edge Appliance cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.ApplianceCluster appliance_cluster = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gkehub.v1beta1.ApplianceCluster,
            com.google.cloud.gkehub.v1beta1.ApplianceCluster.Builder,
            com.google.cloud.gkehub.v1beta1.ApplianceClusterOrBuilder>
        getApplianceClusterFieldBuilder() {
      if (applianceClusterBuilder_ == null) {
        if (!(typeCase_ == 10)) {
          type_ = com.google.cloud.gkehub.v1beta1.ApplianceCluster.getDefaultInstance();
        }
        applianceClusterBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.gkehub.v1beta1.ApplianceCluster,
                com.google.cloud.gkehub.v1beta1.ApplianceCluster.Builder,
                com.google.cloud.gkehub.v1beta1.ApplianceClusterOrBuilder>(
                (com.google.cloud.gkehub.v1beta1.ApplianceCluster) type_,
                getParentForChildren(),
                isClean());
        type_ = null;
      }
      typeCase_ = 10;
      onChanged();
      return applianceClusterBuilder_;
    }

    private com.google.cloud.gkehub.v1beta1.KubernetesMetadata kubernetesMetadata_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gkehub.v1beta1.KubernetesMetadata,
            com.google.cloud.gkehub.v1beta1.KubernetesMetadata.Builder,
            com.google.cloud.gkehub.v1beta1.KubernetesMetadataOrBuilder>
        kubernetesMetadataBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Useful Kubernetes-specific metadata.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.KubernetesMetadata kubernetes_metadata = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the kubernetesMetadata field is set.
     */
    public boolean hasKubernetesMetadata() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Useful Kubernetes-specific metadata.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.KubernetesMetadata kubernetes_metadata = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The kubernetesMetadata.
     */
    public com.google.cloud.gkehub.v1beta1.KubernetesMetadata getKubernetesMetadata() {
      if (kubernetesMetadataBuilder_ == null) {
        return kubernetesMetadata_ == null
            ? com.google.cloud.gkehub.v1beta1.KubernetesMetadata.getDefaultInstance()
            : kubernetesMetadata_;
      } else {
        return kubernetesMetadataBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Useful Kubernetes-specific metadata.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.KubernetesMetadata kubernetes_metadata = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setKubernetesMetadata(com.google.cloud.gkehub.v1beta1.KubernetesMetadata value) {
      if (kubernetesMetadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        kubernetesMetadata_ = value;
      } else {
        kubernetesMetadataBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Useful Kubernetes-specific metadata.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.KubernetesMetadata kubernetes_metadata = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setKubernetesMetadata(
        com.google.cloud.gkehub.v1beta1.KubernetesMetadata.Builder builderForValue) {
      if (kubernetesMetadataBuilder_ == null) {
        kubernetesMetadata_ = builderForValue.build();
      } else {
        kubernetesMetadataBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Useful Kubernetes-specific metadata.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.KubernetesMetadata kubernetes_metadata = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeKubernetesMetadata(
        com.google.cloud.gkehub.v1beta1.KubernetesMetadata value) {
      if (kubernetesMetadataBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && kubernetesMetadata_ != null
            && kubernetesMetadata_
                != com.google.cloud.gkehub.v1beta1.KubernetesMetadata.getDefaultInstance()) {
          getKubernetesMetadataBuilder().mergeFrom(value);
        } else {
          kubernetesMetadata_ = value;
        }
      } else {
        kubernetesMetadataBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Useful Kubernetes-specific metadata.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.KubernetesMetadata kubernetes_metadata = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearKubernetesMetadata() {
      bitField0_ = (bitField0_ & ~0x00000020);
      kubernetesMetadata_ = null;
      if (kubernetesMetadataBuilder_ != null) {
        kubernetesMetadataBuilder_.dispose();
        kubernetesMetadataBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Useful Kubernetes-specific metadata.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.KubernetesMetadata kubernetes_metadata = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.gkehub.v1beta1.KubernetesMetadata.Builder
        getKubernetesMetadataBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getKubernetesMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Useful Kubernetes-specific metadata.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.KubernetesMetadata kubernetes_metadata = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.gkehub.v1beta1.KubernetesMetadataOrBuilder
        getKubernetesMetadataOrBuilder() {
      if (kubernetesMetadataBuilder_ != null) {
        return kubernetesMetadataBuilder_.getMessageOrBuilder();
      } else {
        return kubernetesMetadata_ == null
            ? com.google.cloud.gkehub.v1beta1.KubernetesMetadata.getDefaultInstance()
            : kubernetesMetadata_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Useful Kubernetes-specific metadata.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.KubernetesMetadata kubernetes_metadata = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gkehub.v1beta1.KubernetesMetadata,
            com.google.cloud.gkehub.v1beta1.KubernetesMetadata.Builder,
            com.google.cloud.gkehub.v1beta1.KubernetesMetadataOrBuilder>
        getKubernetesMetadataFieldBuilder() {
      if (kubernetesMetadataBuilder_ == null) {
        kubernetesMetadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.gkehub.v1beta1.KubernetesMetadata,
                com.google.cloud.gkehub.v1beta1.KubernetesMetadata.Builder,
                com.google.cloud.gkehub.v1beta1.KubernetesMetadataOrBuilder>(
                getKubernetesMetadata(), getParentForChildren(), isClean());
        kubernetesMetadata_ = null;
      }
      return kubernetesMetadataBuilder_;
    }

    private com.google.cloud.gkehub.v1beta1.KubernetesResource kubernetesResource_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gkehub.v1beta1.KubernetesResource,
            com.google.cloud.gkehub.v1beta1.KubernetesResource.Builder,
            com.google.cloud.gkehub.v1beta1.KubernetesResourceOrBuilder>
        kubernetesResourceBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The in-cluster Kubernetes Resources that should be applied for a
     * correctly registered cluster, in the steady state. These resources:
     *
     *   * Ensure that the cluster is exclusively registered to one and only one
     *     Hub Membership.
     *   * Propagate Workload Pool Information available in the Membership
     *     Authority field.
     *   * Ensure proper initial configuration of default Hub Features.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.KubernetesResource kubernetes_resource = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the kubernetesResource field is set.
     */
    public boolean hasKubernetesResource() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The in-cluster Kubernetes Resources that should be applied for a
     * correctly registered cluster, in the steady state. These resources:
     *
     *   * Ensure that the cluster is exclusively registered to one and only one
     *     Hub Membership.
     *   * Propagate Workload Pool Information available in the Membership
     *     Authority field.
     *   * Ensure proper initial configuration of default Hub Features.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.KubernetesResource kubernetes_resource = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The kubernetesResource.
     */
    public com.google.cloud.gkehub.v1beta1.KubernetesResource getKubernetesResource() {
      if (kubernetesResourceBuilder_ == null) {
        return kubernetesResource_ == null
            ? com.google.cloud.gkehub.v1beta1.KubernetesResource.getDefaultInstance()
            : kubernetesResource_;
      } else {
        return kubernetesResourceBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The in-cluster Kubernetes Resources that should be applied for a
     * correctly registered cluster, in the steady state. These resources:
     *
     *   * Ensure that the cluster is exclusively registered to one and only one
     *     Hub Membership.
     *   * Propagate Workload Pool Information available in the Membership
     *     Authority field.
     *   * Ensure proper initial configuration of default Hub Features.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.KubernetesResource kubernetes_resource = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setKubernetesResource(com.google.cloud.gkehub.v1beta1.KubernetesResource value) {
      if (kubernetesResourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        kubernetesResource_ = value;
      } else {
        kubernetesResourceBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The in-cluster Kubernetes Resources that should be applied for a
     * correctly registered cluster, in the steady state. These resources:
     *
     *   * Ensure that the cluster is exclusively registered to one and only one
     *     Hub Membership.
     *   * Propagate Workload Pool Information available in the Membership
     *     Authority field.
     *   * Ensure proper initial configuration of default Hub Features.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.KubernetesResource kubernetes_resource = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setKubernetesResource(
        com.google.cloud.gkehub.v1beta1.KubernetesResource.Builder builderForValue) {
      if (kubernetesResourceBuilder_ == null) {
        kubernetesResource_ = builderForValue.build();
      } else {
        kubernetesResourceBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The in-cluster Kubernetes Resources that should be applied for a
     * correctly registered cluster, in the steady state. These resources:
     *
     *   * Ensure that the cluster is exclusively registered to one and only one
     *     Hub Membership.
     *   * Propagate Workload Pool Information available in the Membership
     *     Authority field.
     *   * Ensure proper initial configuration of default Hub Features.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.KubernetesResource kubernetes_resource = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeKubernetesResource(
        com.google.cloud.gkehub.v1beta1.KubernetesResource value) {
      if (kubernetesResourceBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && kubernetesResource_ != null
            && kubernetesResource_
                != com.google.cloud.gkehub.v1beta1.KubernetesResource.getDefaultInstance()) {
          getKubernetesResourceBuilder().mergeFrom(value);
        } else {
          kubernetesResource_ = value;
        }
      } else {
        kubernetesResourceBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The in-cluster Kubernetes Resources that should be applied for a
     * correctly registered cluster, in the steady state. These resources:
     *
     *   * Ensure that the cluster is exclusively registered to one and only one
     *     Hub Membership.
     *   * Propagate Workload Pool Information available in the Membership
     *     Authority field.
     *   * Ensure proper initial configuration of default Hub Features.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.KubernetesResource kubernetes_resource = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearKubernetesResource() {
      bitField0_ = (bitField0_ & ~0x00000040);
      kubernetesResource_ = null;
      if (kubernetesResourceBuilder_ != null) {
        kubernetesResourceBuilder_.dispose();
        kubernetesResourceBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The in-cluster Kubernetes Resources that should be applied for a
     * correctly registered cluster, in the steady state. These resources:
     *
     *   * Ensure that the cluster is exclusively registered to one and only one
     *     Hub Membership.
     *   * Propagate Workload Pool Information available in the Membership
     *     Authority field.
     *   * Ensure proper initial configuration of default Hub Features.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.KubernetesResource kubernetes_resource = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.gkehub.v1beta1.KubernetesResource.Builder
        getKubernetesResourceBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getKubernetesResourceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The in-cluster Kubernetes Resources that should be applied for a
     * correctly registered cluster, in the steady state. These resources:
     *
     *   * Ensure that the cluster is exclusively registered to one and only one
     *     Hub Membership.
     *   * Propagate Workload Pool Information available in the Membership
     *     Authority field.
     *   * Ensure proper initial configuration of default Hub Features.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.KubernetesResource kubernetes_resource = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.gkehub.v1beta1.KubernetesResourceOrBuilder
        getKubernetesResourceOrBuilder() {
      if (kubernetesResourceBuilder_ != null) {
        return kubernetesResourceBuilder_.getMessageOrBuilder();
      } else {
        return kubernetesResource_ == null
            ? com.google.cloud.gkehub.v1beta1.KubernetesResource.getDefaultInstance()
            : kubernetesResource_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The in-cluster Kubernetes Resources that should be applied for a
     * correctly registered cluster, in the steady state. These resources:
     *
     *   * Ensure that the cluster is exclusively registered to one and only one
     *     Hub Membership.
     *   * Propagate Workload Pool Information available in the Membership
     *     Authority field.
     *   * Ensure proper initial configuration of default Hub Features.
     * </pre>
     *
     * <code>
     * .google.cloud.gkehub.v1beta1.KubernetesResource kubernetes_resource = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.gkehub.v1beta1.KubernetesResource,
            com.google.cloud.gkehub.v1beta1.KubernetesResource.Builder,
            com.google.cloud.gkehub.v1beta1.KubernetesResourceOrBuilder>
        getKubernetesResourceFieldBuilder() {
      if (kubernetesResourceBuilder_ == null) {
        kubernetesResourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.gkehub.v1beta1.KubernetesResource,
                com.google.cloud.gkehub.v1beta1.KubernetesResource.Builder,
                com.google.cloud.gkehub.v1beta1.KubernetesResourceOrBuilder>(
                getKubernetesResource(), getParentForChildren(), isClean());
        kubernetesResource_ = null;
      }
      return kubernetesResourceBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.gkehub.v1beta1.MembershipEndpoint)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.gkehub.v1beta1.MembershipEndpoint)
  private static final com.google.cloud.gkehub.v1beta1.MembershipEndpoint DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.gkehub.v1beta1.MembershipEndpoint();
  }

  public static com.google.cloud.gkehub.v1beta1.MembershipEndpoint getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<MembershipEndpoint> PARSER =
      new com.google.protobuf.AbstractParser<MembershipEndpoint>() {
        @java.lang.Override
        public MembershipEndpoint parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<MembershipEndpoint> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<MembershipEndpoint> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.gkehub.v1beta1.MembershipEndpoint getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
