/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/gkehub/v1beta1/membership.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.gkehub.v1beta1;

/**
 *
 *
 * <pre>
 * This field informs Fleet-based applications/services/UIs with the necessary
 * information for where each underlying Cluster reports its metrics.
 * </pre>
 *
 * Protobuf type {@code google.cloud.gkehub.v1beta1.MonitoringConfig}
 */
public final class MonitoringConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.gkehub.v1beta1.MonitoringConfig)
    MonitoringConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use MonitoringConfig.newBuilder() to construct.
  private MonitoringConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private MonitoringConfig() {
    projectId_ = "";
    location_ = "";
    cluster_ = "";
    kubernetesMetricsPrefix_ = "";
    clusterHash_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new MonitoringConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.gkehub.v1beta1.MembershipOuterClass
        .internal_static_google_cloud_gkehub_v1beta1_MonitoringConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.gkehub.v1beta1.MembershipOuterClass
        .internal_static_google_cloud_gkehub_v1beta1_MonitoringConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.gkehub.v1beta1.MonitoringConfig.class,
            com.google.cloud.gkehub.v1beta1.MonitoringConfig.Builder.class);
  }

  public static final int PROJECT_ID_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object projectId_ = "";
  /**
   *
   *
   * <pre>
   * Immutable. Project used to report Metrics
   * </pre>
   *
   * <code>string project_id = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The projectId.
   */
  @java.lang.Override
  public java.lang.String getProjectId() {
    java.lang.Object ref = projectId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      projectId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Immutable. Project used to report Metrics
   * </pre>
   *
   * <code>string project_id = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for projectId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getProjectIdBytes() {
    java.lang.Object ref = projectId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      projectId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LOCATION_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object location_ = "";
  /**
   *
   *
   * <pre>
   * Immutable. Location used to report Metrics
   * </pre>
   *
   * <code>string location = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The location.
   */
  @java.lang.Override
  public java.lang.String getLocation() {
    java.lang.Object ref = location_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      location_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Immutable. Location used to report Metrics
   * </pre>
   *
   * <code>string location = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for location.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLocationBytes() {
    java.lang.Object ref = location_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      location_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CLUSTER_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object cluster_ = "";
  /**
   *
   *
   * <pre>
   * Immutable. Cluster name used to report metrics.
   * For Anthos on VMWare/Baremetal, it would be in format
   * `memberClusters/cluster_name`; And for Anthos on MultiCloud, it would be in
   * format
   * `{azureClusters, awsClusters}/cluster_name`.
   * </pre>
   *
   * <code>string cluster = 3 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The cluster.
   */
  @java.lang.Override
  public java.lang.String getCluster() {
    java.lang.Object ref = cluster_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      cluster_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Immutable. Cluster name used to report metrics.
   * For Anthos on VMWare/Baremetal, it would be in format
   * `memberClusters/cluster_name`; And for Anthos on MultiCloud, it would be in
   * format
   * `{azureClusters, awsClusters}/cluster_name`.
   * </pre>
   *
   * <code>string cluster = 3 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for cluster.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getClusterBytes() {
    java.lang.Object ref = cluster_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      cluster_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int KUBERNETES_METRICS_PREFIX_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object kubernetesMetricsPrefix_ = "";
  /**
   *
   *
   * <pre>
   * Kubernetes system metrics, if available, are written to this prefix.
   * This defaults to kubernetes.io for GKE, and kubernetes.io/anthos for Anthos
   * eventually. Noted: Anthos MultiCloud will have kubernetes.io prefix today
   * but will migration to be under kubernetes.io/anthos
   * </pre>
   *
   * <code>string kubernetes_metrics_prefix = 4;</code>
   *
   * @return The kubernetesMetricsPrefix.
   */
  @java.lang.Override
  public java.lang.String getKubernetesMetricsPrefix() {
    java.lang.Object ref = kubernetesMetricsPrefix_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kubernetesMetricsPrefix_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Kubernetes system metrics, if available, are written to this prefix.
   * This defaults to kubernetes.io for GKE, and kubernetes.io/anthos for Anthos
   * eventually. Noted: Anthos MultiCloud will have kubernetes.io prefix today
   * but will migration to be under kubernetes.io/anthos
   * </pre>
   *
   * <code>string kubernetes_metrics_prefix = 4;</code>
   *
   * @return The bytes for kubernetesMetricsPrefix.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKubernetesMetricsPrefixBytes() {
    java.lang.Object ref = kubernetesMetricsPrefix_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kubernetesMetricsPrefix_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CLUSTER_HASH_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object clusterHash_ = "";
  /**
   *
   *
   * <pre>
   * Immutable. Cluster hash, this is a unique string generated by google code,
   * which does not contain any PII, which we can use to reference the cluster.
   * This is expected to be created by the monitoring stack and persisted into
   * the Cluster object as well as to GKE-Hub.
   * </pre>
   *
   * <code>string cluster_hash = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The clusterHash.
   */
  @java.lang.Override
  public java.lang.String getClusterHash() {
    java.lang.Object ref = clusterHash_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      clusterHash_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Immutable. Cluster hash, this is a unique string generated by google code,
   * which does not contain any PII, which we can use to reference the cluster.
   * This is expected to be created by the monitoring stack and persisted into
   * the Cluster object as well as to GKE-Hub.
   * </pre>
   *
   * <code>string cluster_hash = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for clusterHash.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getClusterHashBytes() {
    java.lang.Object ref = clusterHash_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      clusterHash_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, projectId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(location_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, location_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cluster_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, cluster_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kubernetesMetricsPrefix_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, kubernetesMetricsPrefix_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clusterHash_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, clusterHash_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, projectId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(location_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, location_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cluster_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, cluster_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kubernetesMetricsPrefix_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, kubernetesMetricsPrefix_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clusterHash_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, clusterHash_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.gkehub.v1beta1.MonitoringConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.gkehub.v1beta1.MonitoringConfig other =
        (com.google.cloud.gkehub.v1beta1.MonitoringConfig) obj;

    if (!getProjectId().equals(other.getProjectId())) return false;
    if (!getLocation().equals(other.getLocation())) return false;
    if (!getCluster().equals(other.getCluster())) return false;
    if (!getKubernetesMetricsPrefix().equals(other.getKubernetesMetricsPrefix())) return false;
    if (!getClusterHash().equals(other.getClusterHash())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PROJECT_ID_FIELD_NUMBER;
    hash = (53 * hash) + getProjectId().hashCode();
    hash = (37 * hash) + LOCATION_FIELD_NUMBER;
    hash = (53 * hash) + getLocation().hashCode();
    hash = (37 * hash) + CLUSTER_FIELD_NUMBER;
    hash = (53 * hash) + getCluster().hashCode();
    hash = (37 * hash) + KUBERNETES_METRICS_PREFIX_FIELD_NUMBER;
    hash = (53 * hash) + getKubernetesMetricsPrefix().hashCode();
    hash = (37 * hash) + CLUSTER_HASH_FIELD_NUMBER;
    hash = (53 * hash) + getClusterHash().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.gkehub.v1beta1.MonitoringConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gkehub.v1beta1.MonitoringConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gkehub.v1beta1.MonitoringConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gkehub.v1beta1.MonitoringConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gkehub.v1beta1.MonitoringConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.gkehub.v1beta1.MonitoringConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.gkehub.v1beta1.MonitoringConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.gkehub.v1beta1.MonitoringConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.gkehub.v1beta1.MonitoringConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.gkehub.v1beta1.MonitoringConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.gkehub.v1beta1.MonitoringConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.gkehub.v1beta1.MonitoringConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.gkehub.v1beta1.MonitoringConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * This field informs Fleet-based applications/services/UIs with the necessary
   * information for where each underlying Cluster reports its metrics.
   * </pre>
   *
   * Protobuf type {@code google.cloud.gkehub.v1beta1.MonitoringConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.gkehub.v1beta1.MonitoringConfig)
      com.google.cloud.gkehub.v1beta1.MonitoringConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.gkehub.v1beta1.MembershipOuterClass
          .internal_static_google_cloud_gkehub_v1beta1_MonitoringConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.gkehub.v1beta1.MembershipOuterClass
          .internal_static_google_cloud_gkehub_v1beta1_MonitoringConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.gkehub.v1beta1.MonitoringConfig.class,
              com.google.cloud.gkehub.v1beta1.MonitoringConfig.Builder.class);
    }

    // Construct using com.google.cloud.gkehub.v1beta1.MonitoringConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      projectId_ = "";
      location_ = "";
      cluster_ = "";
      kubernetesMetricsPrefix_ = "";
      clusterHash_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.gkehub.v1beta1.MembershipOuterClass
          .internal_static_google_cloud_gkehub_v1beta1_MonitoringConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.gkehub.v1beta1.MonitoringConfig getDefaultInstanceForType() {
      return com.google.cloud.gkehub.v1beta1.MonitoringConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.gkehub.v1beta1.MonitoringConfig build() {
      com.google.cloud.gkehub.v1beta1.MonitoringConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.gkehub.v1beta1.MonitoringConfig buildPartial() {
      com.google.cloud.gkehub.v1beta1.MonitoringConfig result =
          new com.google.cloud.gkehub.v1beta1.MonitoringConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.gkehub.v1beta1.MonitoringConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.projectId_ = projectId_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.location_ = location_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.cluster_ = cluster_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.kubernetesMetricsPrefix_ = kubernetesMetricsPrefix_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.clusterHash_ = clusterHash_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.gkehub.v1beta1.MonitoringConfig) {
        return mergeFrom((com.google.cloud.gkehub.v1beta1.MonitoringConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.gkehub.v1beta1.MonitoringConfig other) {
      if (other == com.google.cloud.gkehub.v1beta1.MonitoringConfig.getDefaultInstance())
        return this;
      if (!other.getProjectId().isEmpty()) {
        projectId_ = other.projectId_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getLocation().isEmpty()) {
        location_ = other.location_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getCluster().isEmpty()) {
        cluster_ = other.cluster_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getKubernetesMetricsPrefix().isEmpty()) {
        kubernetesMetricsPrefix_ = other.kubernetesMetricsPrefix_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getClusterHash().isEmpty()) {
        clusterHash_ = other.clusterHash_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                projectId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                location_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                cluster_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                kubernetesMetricsPrefix_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                clusterHash_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object projectId_ = "";
    /**
     *
     *
     * <pre>
     * Immutable. Project used to report Metrics
     * </pre>
     *
     * <code>string project_id = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The projectId.
     */
    public java.lang.String getProjectId() {
      java.lang.Object ref = projectId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        projectId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. Project used to report Metrics
     * </pre>
     *
     * <code>string project_id = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for projectId.
     */
    public com.google.protobuf.ByteString getProjectIdBytes() {
      java.lang.Object ref = projectId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        projectId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. Project used to report Metrics
     * </pre>
     *
     * <code>string project_id = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The projectId to set.
     * @return This builder for chaining.
     */
    public Builder setProjectId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      projectId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Project used to report Metrics
     * </pre>
     *
     * <code>string project_id = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProjectId() {
      projectId_ = getDefaultInstance().getProjectId();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Project used to report Metrics
     * </pre>
     *
     * <code>string project_id = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes for projectId to set.
     * @return This builder for chaining.
     */
    public Builder setProjectIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      projectId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object location_ = "";
    /**
     *
     *
     * <pre>
     * Immutable. Location used to report Metrics
     * </pre>
     *
     * <code>string location = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The location.
     */
    public java.lang.String getLocation() {
      java.lang.Object ref = location_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        location_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. Location used to report Metrics
     * </pre>
     *
     * <code>string location = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for location.
     */
    public com.google.protobuf.ByteString getLocationBytes() {
      java.lang.Object ref = location_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        location_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. Location used to report Metrics
     * </pre>
     *
     * <code>string location = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The location to set.
     * @return This builder for chaining.
     */
    public Builder setLocation(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      location_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Location used to report Metrics
     * </pre>
     *
     * <code>string location = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLocation() {
      location_ = getDefaultInstance().getLocation();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Location used to report Metrics
     * </pre>
     *
     * <code>string location = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes for location to set.
     * @return This builder for chaining.
     */
    public Builder setLocationBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      location_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object cluster_ = "";
    /**
     *
     *
     * <pre>
     * Immutable. Cluster name used to report metrics.
     * For Anthos on VMWare/Baremetal, it would be in format
     * `memberClusters/cluster_name`; And for Anthos on MultiCloud, it would be in
     * format
     * `{azureClusters, awsClusters}/cluster_name`.
     * </pre>
     *
     * <code>string cluster = 3 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The cluster.
     */
    public java.lang.String getCluster() {
      java.lang.Object ref = cluster_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        cluster_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. Cluster name used to report metrics.
     * For Anthos on VMWare/Baremetal, it would be in format
     * `memberClusters/cluster_name`; And for Anthos on MultiCloud, it would be in
     * format
     * `{azureClusters, awsClusters}/cluster_name`.
     * </pre>
     *
     * <code>string cluster = 3 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for cluster.
     */
    public com.google.protobuf.ByteString getClusterBytes() {
      java.lang.Object ref = cluster_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        cluster_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. Cluster name used to report metrics.
     * For Anthos on VMWare/Baremetal, it would be in format
     * `memberClusters/cluster_name`; And for Anthos on MultiCloud, it would be in
     * format
     * `{azureClusters, awsClusters}/cluster_name`.
     * </pre>
     *
     * <code>string cluster = 3 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The cluster to set.
     * @return This builder for chaining.
     */
    public Builder setCluster(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      cluster_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Cluster name used to report metrics.
     * For Anthos on VMWare/Baremetal, it would be in format
     * `memberClusters/cluster_name`; And for Anthos on MultiCloud, it would be in
     * format
     * `{azureClusters, awsClusters}/cluster_name`.
     * </pre>
     *
     * <code>string cluster = 3 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCluster() {
      cluster_ = getDefaultInstance().getCluster();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Cluster name used to report metrics.
     * For Anthos on VMWare/Baremetal, it would be in format
     * `memberClusters/cluster_name`; And for Anthos on MultiCloud, it would be in
     * format
     * `{azureClusters, awsClusters}/cluster_name`.
     * </pre>
     *
     * <code>string cluster = 3 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes for cluster to set.
     * @return This builder for chaining.
     */
    public Builder setClusterBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      cluster_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object kubernetesMetricsPrefix_ = "";
    /**
     *
     *
     * <pre>
     * Kubernetes system metrics, if available, are written to this prefix.
     * This defaults to kubernetes.io for GKE, and kubernetes.io/anthos for Anthos
     * eventually. Noted: Anthos MultiCloud will have kubernetes.io prefix today
     * but will migration to be under kubernetes.io/anthos
     * </pre>
     *
     * <code>string kubernetes_metrics_prefix = 4;</code>
     *
     * @return The kubernetesMetricsPrefix.
     */
    public java.lang.String getKubernetesMetricsPrefix() {
      java.lang.Object ref = kubernetesMetricsPrefix_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kubernetesMetricsPrefix_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Kubernetes system metrics, if available, are written to this prefix.
     * This defaults to kubernetes.io for GKE, and kubernetes.io/anthos for Anthos
     * eventually. Noted: Anthos MultiCloud will have kubernetes.io prefix today
     * but will migration to be under kubernetes.io/anthos
     * </pre>
     *
     * <code>string kubernetes_metrics_prefix = 4;</code>
     *
     * @return The bytes for kubernetesMetricsPrefix.
     */
    public com.google.protobuf.ByteString getKubernetesMetricsPrefixBytes() {
      java.lang.Object ref = kubernetesMetricsPrefix_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kubernetesMetricsPrefix_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Kubernetes system metrics, if available, are written to this prefix.
     * This defaults to kubernetes.io for GKE, and kubernetes.io/anthos for Anthos
     * eventually. Noted: Anthos MultiCloud will have kubernetes.io prefix today
     * but will migration to be under kubernetes.io/anthos
     * </pre>
     *
     * <code>string kubernetes_metrics_prefix = 4;</code>
     *
     * @param value The kubernetesMetricsPrefix to set.
     * @return This builder for chaining.
     */
    public Builder setKubernetesMetricsPrefix(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kubernetesMetricsPrefix_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Kubernetes system metrics, if available, are written to this prefix.
     * This defaults to kubernetes.io for GKE, and kubernetes.io/anthos for Anthos
     * eventually. Noted: Anthos MultiCloud will have kubernetes.io prefix today
     * but will migration to be under kubernetes.io/anthos
     * </pre>
     *
     * <code>string kubernetes_metrics_prefix = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKubernetesMetricsPrefix() {
      kubernetesMetricsPrefix_ = getDefaultInstance().getKubernetesMetricsPrefix();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Kubernetes system metrics, if available, are written to this prefix.
     * This defaults to kubernetes.io for GKE, and kubernetes.io/anthos for Anthos
     * eventually. Noted: Anthos MultiCloud will have kubernetes.io prefix today
     * but will migration to be under kubernetes.io/anthos
     * </pre>
     *
     * <code>string kubernetes_metrics_prefix = 4;</code>
     *
     * @param value The bytes for kubernetesMetricsPrefix to set.
     * @return This builder for chaining.
     */
    public Builder setKubernetesMetricsPrefixBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kubernetesMetricsPrefix_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object clusterHash_ = "";
    /**
     *
     *
     * <pre>
     * Immutable. Cluster hash, this is a unique string generated by google code,
     * which does not contain any PII, which we can use to reference the cluster.
     * This is expected to be created by the monitoring stack and persisted into
     * the Cluster object as well as to GKE-Hub.
     * </pre>
     *
     * <code>string cluster_hash = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The clusterHash.
     */
    public java.lang.String getClusterHash() {
      java.lang.Object ref = clusterHash_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        clusterHash_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. Cluster hash, this is a unique string generated by google code,
     * which does not contain any PII, which we can use to reference the cluster.
     * This is expected to be created by the monitoring stack and persisted into
     * the Cluster object as well as to GKE-Hub.
     * </pre>
     *
     * <code>string cluster_hash = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for clusterHash.
     */
    public com.google.protobuf.ByteString getClusterHashBytes() {
      java.lang.Object ref = clusterHash_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        clusterHash_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. Cluster hash, this is a unique string generated by google code,
     * which does not contain any PII, which we can use to reference the cluster.
     * This is expected to be created by the monitoring stack and persisted into
     * the Cluster object as well as to GKE-Hub.
     * </pre>
     *
     * <code>string cluster_hash = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The clusterHash to set.
     * @return This builder for chaining.
     */
    public Builder setClusterHash(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      clusterHash_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Cluster hash, this is a unique string generated by google code,
     * which does not contain any PII, which we can use to reference the cluster.
     * This is expected to be created by the monitoring stack and persisted into
     * the Cluster object as well as to GKE-Hub.
     * </pre>
     *
     * <code>string cluster_hash = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearClusterHash() {
      clusterHash_ = getDefaultInstance().getClusterHash();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Cluster hash, this is a unique string generated by google code,
     * which does not contain any PII, which we can use to reference the cluster.
     * This is expected to be created by the monitoring stack and persisted into
     * the Cluster object as well as to GKE-Hub.
     * </pre>
     *
     * <code>string cluster_hash = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes for clusterHash to set.
     * @return This builder for chaining.
     */
    public Builder setClusterHashBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      clusterHash_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.gkehub.v1beta1.MonitoringConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.gkehub.v1beta1.MonitoringConfig)
  private static final com.google.cloud.gkehub.v1beta1.MonitoringConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.gkehub.v1beta1.MonitoringConfig();
  }

  public static com.google.cloud.gkehub.v1beta1.MonitoringConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<MonitoringConfig> PARSER =
      new com.google.protobuf.AbstractParser<MonitoringConfig>() {
        @java.lang.Override
        public MonitoringConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<MonitoringConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<MonitoringConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.gkehub.v1beta1.MonitoringConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
